/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGrid;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIAxisBreakConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisBreakDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementAxisBreak2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIAxisBreakDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SGFigureElementAxisBreak
extends SGFigureElement
implements SGIFigureElementAxisBreak,
SGIAxisBreakConstants {
    private SGIFigureElementAxis mAxisElement = null;
    private SGAxisBreakDialog mDialog = null;

    public void dispose() {
        super.dispose();
        this.mDialog.dispose();
        this.mDialog = null;
        this.mAxisElement = null;
    }

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createDialog();
        return true;
    }

    private boolean createDialog() {
        SGAxisBreakDialog sGAxisBreakDialog;
        this.mDialog = sGAxisBreakDialog = new SGAxisBreakDialog(this.mDialogOwner, true);
        return true;
    }

    public String toString() {
        return "SGAxisBreakElement";
    }

    public String getClassDescription() {
        return "Axis Break Symbols";
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement, String string) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIFigureElementGraph || sGIFigureElement instanceof SGIFigureElementString || sGIFigureElement instanceof SGIFigureElementLegend)) {
            if (sGIFigureElement instanceof SGIFigureElementAxis) {
                bl = this.synchronizeToAxisElement((SGIFigureElementAxis)sGIFigureElement, string);
            } else if (!(sGIFigureElement instanceof SGIFigureElementAxisBreak || sGIFigureElement instanceof SGIFigureElementSignificantDifference || sGIFigureElement instanceof SGIFigureElementTimingLine || sGIFigureElement instanceof SGIFigureElementGrid || sGIFigureElement instanceof SGIFigureElementShape)) {
                bl = sGIFigureElement.synchronizeArgument(this, string);
            }
        }
        return bl;
    }

    private boolean synchronizeToAxisElement(SGIFigureElementAxis sGIFigureElementAxis, String string) {
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            axisBreakSymbol.setDrawingElementsLocation();
        }
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement, String string) {
        throw new Error();
    }

    public void setAxisElement(SGIFigureElementAxis sGIFigureElementAxis) {
        this.mAxisElement = sGIFigureElementAxis;
    }

    public String getTagName() {
        return "AxisBreakSymbols";
    }

    public boolean writeProperty(Element element) {
        return true;
    }

    public boolean readProperty(Element element) {
        NodeList nodeList = element.getElementsByTagName("AxisBreakSymbol");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            AxisBreakSymbol axisBreakSymbol = new AxisBreakSymbol();
            Element element2 = (Element)node;
            if (!axisBreakSymbol.readProperty(element2)) {
                return false;
            }
            axisBreakSymbol.initPropertiesHistory();
            this.addToList(axisBreakSymbol);
        }
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        this.setLocationOfAllDrawingElements();
        return true;
    }

    private boolean setLocationOfAllDrawingElements() {
        List list = this.mChildList;
        for (int i = 0; i < list.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)list.get(i);
            axisBreakSymbol.setDrawingElementsLocation();
        }
        return true;
    }

    public boolean zoom(float f) {
        super.zoom(f);
        List list = this.mChildList;
        for (int i = 0; i < list.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)list.get(i);
            axisBreakSymbol.zoom(f);
        }
        return true;
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        Object object;
        AxisBreakSymbol axisBreakSymbol;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        ArrayList arrayList = this.getVisibleChildList();
        for (n = 0; n < arrayList.size(); ++n) {
            axisBreakSymbol = (AxisBreakSymbol)arrayList.get(n);
            if (!axisBreakSymbol.isValid()) continue;
            axisBreakSymbol.paintElement(graphics2D);
        }
        if (this.mSymbolsVisibleFlagAroundAllObjects) {
            for (n = 0; n < arrayList.size(); ++n) {
                axisBreakSymbol = (AxisBreakSymbol)arrayList.get(n);
                if (!axisBreakSymbol.isValid()) continue;
                object = axisBreakSymbol.getAnchorPointList();
                SGUtilityForFigureElementJava2D.drawAnchorAsChildObject((List)object, graphics2D);
            }
        }
        if (this.mSymbolsVisibleFlagAroundFocusedObjects) {
            ArrayList arrayList2 = new ArrayList();
            this.getFocusedObjectsList(arrayList2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                object = (AxisBreakSymbol)arrayList2.get(i);
                if (!((AxisBreakSymbol)object).isValid()) continue;
                ArrayList arrayList3 = ((AxisBreakSymbol)object).getAnchorPointList();
                SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(arrayList3, graphics2D);
            }
        }
    }

    public Element createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!axisBreakSymbol.isValid()) continue;
            Element element2 = axisBreakSymbol.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        return element;
    }

    public boolean addAxisBreakSymbol(int n, int n2) {
        if (!this.getGraphRect().contains(n, n2)) {
            return false;
        }
        SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
        SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
        return this.addAxisBreakSymbol(sGAxis, sGAxis2, n, n2);
    }

    public boolean addAxisBreakSymbol(SGAxis sGAxis, SGAxis sGAxis2, int n, int n2) {
        AxisBreakSymbol axisBreakSymbol = new AxisBreakSymbol(1.0f, "cm", 0.5f, "cm", 0.5f, 0.0f, true);
        axisBreakSymbol.addColor(SGIAxisBreakConstants.DEFAULT_AXIS_BREAK_INNER_COLOR);
        axisBreakSymbol.setLineColor(SGIAxisBreakConstants.DEFAULT_AXIS_BREAK_LINE_COLOR);
        axisBreakSymbol.setLineWidth(1.5f, "pt");
        axisBreakSymbol.setMagnification(this.mMagnification);
        axisBreakSymbol.mXAxis = sGAxis;
        axisBreakSymbol.mYAxis = sGAxis2;
        axisBreakSymbol.setLocation(n, n2);
        axisBreakSymbol.setAxisValue();
        this.addToList(axisBreakSymbol);
        this.setChanged(true);
        axisBreakSymbol.initPropertiesHistory();
        this.notifyToRoot();
        return true;
    }

    protected boolean setAllDrawingElementsLocation() {
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (axisBreakSymbol.setDrawingElementsLocation()) continue;
            return false;
        }
        return true;
    }

    public boolean setMementoBackward() {
        boolean bl = super.setMementoBackward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChangeOnUndo();
        return true;
    }

    public boolean setMementoForward() {
        boolean bl = super.setMementoForward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChangeOnUndo();
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!axisBreakSymbol.isValid() || !this.clickDrawingElements(axisBreakSymbol, mouseEvent)) continue;
            return true;
        }
        return false;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            axisBreakSymbol.mTemporaryProperties = axisBreakSymbol.getProperties();
        }
        return true;
    }

    public ArrayList getPropertyDialogObserverList() {
        return this.getFocusedObjectsList();
    }

    private boolean clickDrawingElements(AxisBreakSymbol axisBreakSymbol, MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        if (axisBreakSymbol.contains(n, n2)) {
            this.updateFocusedObjectsList((SGISelectable)axisBreakSymbol, mouseEvent);
            if (!(SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 1)) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 2) {
                    this.setPropertiesOfSelectedObjects();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) & n3 == 1) {
                    axisBreakSymbol.getPopupMenu().show(this.getComponent(), n, n2);
                }
            }
            return true;
        }
        return false;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!axisBreakSymbol.isValid() || !axisBreakSymbol.contains(n, n2)) continue;
            this.mPressedPoint = mouseEvent.getPoint();
            this.setMouseCursor(13);
            if (axisBreakSymbol.isSelected()) {
                this.mDraggableFlag = true;
            }
            return true;
        }
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mPressedPoint == null) {
            return false;
        }
        if (!this.mDraggableFlag) {
            return false;
        }
        int n = mouseEvent.getX() - this.mPressedPoint.x;
        int n2 = mouseEvent.getY() - this.mPressedPoint.y;
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!axisBreakSymbol.isValid()) continue;
            axisBreakSymbol.translate(n, n2);
        }
        this.mPressedPoint = mouseEvent.getPoint();
        return true;
    }

    public boolean setChangedFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGProperties sGProperties;
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            SGProperties sGProperties2 = axisBreakSymbol.mTemporaryProperties;
            if (sGProperties2 == null || (sGProperties = axisBreakSymbol.getProperties()).equals(sGProperties2)) continue;
            axisBreakSymbol.setChanged(true);
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!axisBreakSymbol.isValid()) continue;
            Rectangle2D rectangle2D = axisBreakSymbol.getElementBounds();
            if (rectangle2D.contains(mouseEvent.getPoint())) {
                this.setMouseCursor(12);
                continue;
            }
            this.setMouseCursor(0);
        }
        this.mDraggableFlag = false;
        this.notifyToRoot();
        return true;
    }

    public boolean onDrawingElement(int n, int n2) {
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            boolean bl;
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!axisBreakSymbol.isValid() || !(bl = axisBreakSymbol.contains(n, n2))) continue;
            this.setMouseCursor(12);
            return true;
        }
        return false;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        Cloneable cloneable;
        Object object;
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        ArrayList arrayList = this.getVisibleChildList();
        ArrayList<Rectangle2D> arrayList2 = new ArrayList<Rectangle2D>();
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (AxisBreakSymbol)arrayList.get(i);
            cloneable = ((SGDrawingElementAxisBreak2D)object).getElementBounds();
            arrayList2.add((Rectangle2D)cloneable);
        }
        Rectangle2D rectangle2D = null;
        if (arrayList2.size() != 0) {
            rectangle2D = SGUtility.createUnion(arrayList2);
        }
        object = this.getGraphRect();
        cloneable = new ArrayList();
        ((ArrayList)cloneable).add(object);
        if (rectangle2D != null) {
            ((ArrayList)cloneable).add(rectangle2D);
        }
        Rectangle2D rectangle2D2 = SGUtility.createUnion((ArrayList)cloneable);
        float f = (float)(((RectangularShape)object).getY() - rectangle2D2.getY());
        float f2 = (float)(rectangle2D2.getY() + rectangle2D2.getHeight() - (((RectangularShape)object).getY() + ((RectangularShape)object).getHeight()));
        float f3 = (float)(((RectangularShape)object).getX() - rectangle2D2.getX());
        float f4 = (float)(rectangle2D2.getX() + rectangle2D2.getWidth() - (((RectangularShape)object).getX() + ((RectangularShape)object).getWidth()));
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    protected Set getAvailableChildSet() {
        HashSet hashSet = new HashSet();
        List list = this.getMementoList();
        for (int i = 0; i < list.size(); ++i) {
            AxisProperties axisProperties = (AxisProperties)list.get(i);
            hashSet.addAll(axisProperties.visibleAxisBreakSymbolList);
        }
        return hashSet;
    }

    public SGProperties getProperties() {
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.visibleAxisBreakSymbolList = this.getVisibleChildList();
        return axisProperties;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof AxisProperties)) {
            return false;
        }
        AxisProperties axisProperties = (AxisProperties)sGProperties;
        boolean bl = this.setVisibleChildList(axisProperties.visibleAxisBreakSymbolList);
        return bl;
    }

    public boolean duplicateFocusedObjects() {
        int n = (int)(this.mMagnification * 10.0f);
        int n2 = (int)(this.mMagnification * 10.0f);
        ArrayList arrayList = this.duplicateObjects();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            axisBreakSymbol.translate(n, n2);
            axisBreakSymbol.setSelected(true);
            this.addToList(axisBreakSymbol);
            axisBreakSymbol.initPropertiesHistory();
        }
        if (arrayList.size() != 0) {
            this.setChanged(true);
        }
        return true;
    }

    public boolean paste(ArrayList arrayList) {
        float f = this.getMagnification();
        int n = (int)(f * 10.0f);
        int n2 = (int)(f * 10.0f);
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof AxisBreakSymbol)) continue;
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)e;
            axisBreakSymbol.translate(n, n2);
            SGProperties sGProperties = axisBreakSymbol.getProperties();
            AxisBreakSymbol axisBreakSymbol2 = new AxisBreakSymbol();
            axisBreakSymbol2.setMagnification(f);
            axisBreakSymbol2.setProperties(sGProperties);
            axisBreakSymbol2.mXAxis = this.mAxisElement.getAxisInCube(axisBreakSymbol.mTempXAxis);
            axisBreakSymbol2.mYAxis = this.mAxisElement.getAxisInCube(axisBreakSymbol.mTempYAxis);
            axisBreakSymbol2.setDrawingElementsLocation();
            axisBreakSymbol2.setAxisValue();
            this.addToList(axisBreakSymbol2);
            axisBreakSymbol2.initPropertiesHistory();
            ++n3;
        }
        if (n3 != 0) {
            this.setChanged(true);
        }
        return true;
    }

    private AxisBreakSymbol getAxisBreakSymbol(int n) {
        AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)this.getChildObject(n);
        if (axisBreakSymbol == null) {
            return null;
        }
        if (!axisBreakSymbol.isVisible()) {
            return null;
        }
        return axisBreakSymbol;
    }

    public boolean setAxisXDirectly(int n, int n2) {
        AxisBreakSymbol axisBreakSymbol = this.getAxisBreakSymbol(n);
        if (axisBreakSymbol == null) {
            return false;
        }
        if (!this.setDirectlyBefore(axisBreakSymbol)) {
            return false;
        }
        if (!axisBreakSymbol.setXAxisLocation(n2)) {
            return false;
        }
        return this.setDirectlyAfter(axisBreakSymbol);
    }

    public boolean setAxisYDirectly(int n, int n2) {
        AxisBreakSymbol axisBreakSymbol = this.getAxisBreakSymbol(n);
        if (axisBreakSymbol == null) {
            return false;
        }
        if (!this.setDirectlyBefore(axisBreakSymbol)) {
            return false;
        }
        if (!axisBreakSymbol.setYAxisLocation(n2)) {
            return false;
        }
        return this.setDirectlyAfter(axisBreakSymbol);
    }

    public boolean setLocationXDirectly(int n, double d) {
        AxisBreakSymbol axisBreakSymbol = this.getAxisBreakSymbol(n);
        if (axisBreakSymbol == null) {
            return false;
        }
        if (!this.setDirectlyBefore(axisBreakSymbol)) {
            return false;
        }
        if (!axisBreakSymbol.setXValue(d)) {
            return false;
        }
        return this.setDirectlyAfter(axisBreakSymbol);
    }

    public boolean setLocationYDirectly(int n, double d) {
        AxisBreakSymbol axisBreakSymbol = this.getAxisBreakSymbol(n);
        if (axisBreakSymbol == null) {
            return false;
        }
        if (!this.setDirectlyBefore(axisBreakSymbol)) {
            return false;
        }
        if (!axisBreakSymbol.setYValue(d)) {
            return false;
        }
        return this.setDirectlyAfter(axisBreakSymbol);
    }

    public boolean setLengthDirectly(int n, float f, String string) {
        AxisBreakSymbol axisBreakSymbol = this.getAxisBreakSymbol(n);
        if (axisBreakSymbol == null) {
            return false;
        }
        if (!this.setDirectlyBefore(axisBreakSymbol)) {
            return false;
        }
        if (!axisBreakSymbol.setLength(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(axisBreakSymbol);
    }

    public boolean setIntervalDirectly(int n, float f, String string) {
        AxisBreakSymbol axisBreakSymbol = this.getAxisBreakSymbol(n);
        if (axisBreakSymbol == null) {
            return false;
        }
        if (!this.setDirectlyBefore(axisBreakSymbol)) {
            return false;
        }
        if (!axisBreakSymbol.setInterval(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(axisBreakSymbol);
    }

    public boolean setDistortionDirectly(int n, float f) {
        AxisBreakSymbol axisBreakSymbol = this.getAxisBreakSymbol(n);
        if (axisBreakSymbol == null) {
            return false;
        }
        if (!this.setDirectlyBefore(axisBreakSymbol)) {
            return false;
        }
        if (!axisBreakSymbol.setDistortion(f)) {
            return false;
        }
        return this.setDirectlyAfter(axisBreakSymbol);
    }

    public boolean setAngleDirectly(int n, float f) {
        AxisBreakSymbol axisBreakSymbol = this.getAxisBreakSymbol(n);
        if (axisBreakSymbol == null) {
            return false;
        }
        if (!this.setDirectlyBefore(axisBreakSymbol)) {
            return false;
        }
        if (!axisBreakSymbol.setAngle(f)) {
            return false;
        }
        return this.setDirectlyAfter(axisBreakSymbol);
    }

    public boolean setLineWidthDirectly(int n, float f, String string) {
        AxisBreakSymbol axisBreakSymbol = this.getAxisBreakSymbol(n);
        if (axisBreakSymbol == null) {
            return false;
        }
        if (!this.setDirectlyBefore(axisBreakSymbol)) {
            return false;
        }
        if (!axisBreakSymbol.setLineWidth(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(axisBreakSymbol);
    }

    public boolean setAlignmentDirectly(int n, boolean bl) {
        AxisBreakSymbol axisBreakSymbol = this.getAxisBreakSymbol(n);
        if (axisBreakSymbol == null) {
            return false;
        }
        if (!this.setDirectlyBefore(axisBreakSymbol)) {
            return false;
        }
        if (!axisBreakSymbol.setForHorizontalAxisFlag(bl)) {
            return false;
        }
        return this.setDirectlyAfter(axisBreakSymbol);
    }

    public boolean setLineColorDirectly(int n, Color color) {
        AxisBreakSymbol axisBreakSymbol = this.getAxisBreakSymbol(n);
        if (axisBreakSymbol == null) {
            return false;
        }
        if (!this.setDirectlyBefore(axisBreakSymbol)) {
            return false;
        }
        if (!axisBreakSymbol.setLineColor(color)) {
            return false;
        }
        return this.setDirectlyAfter(axisBreakSymbol);
    }

    public boolean setInnerColorDirectly(int n, Color color) {
        AxisBreakSymbol axisBreakSymbol = this.getAxisBreakSymbol(n);
        if (axisBreakSymbol == null) {
            return false;
        }
        if (!this.setDirectlyBefore(axisBreakSymbol)) {
            return false;
        }
        if (!axisBreakSymbol.setInnerColor(color)) {
            return false;
        }
        return this.setDirectlyAfter(axisBreakSymbol);
    }

    private boolean setDirectlyBefore(AxisBreakSymbol axisBreakSymbol) {
        return axisBreakSymbol.prepare();
    }

    private boolean setDirectlyAfter(AxisBreakSymbol axisBreakSymbol) {
        if (!axisBreakSymbol.commit()) {
            return false;
        }
        this.notifyChange();
        this.notifyToRoot();
        this.repaint();
        return true;
    }

    public static class AxisBreakSymbolWithAxesProperties
    extends SGDrawingElementAxisBreak.AxisBreakSymbolProperties {
        private double mXValue = 0.0;
        private double mYValue = 0.0;
        private SGAxis mXAxis = null;
        private SGAxis mYAxis = null;

        public boolean equals(Object object) {
            if (!(object instanceof AxisBreakSymbolWithAxesProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = (AxisBreakSymbolWithAxesProperties)object;
            if (axisBreakSymbolWithAxesProperties.mXValue != this.mXValue) {
                return false;
            }
            if (axisBreakSymbolWithAxesProperties.mYValue != this.mYValue) {
                return false;
            }
            if (!this.mXAxis.equals(axisBreakSymbolWithAxesProperties.mXAxis)) {
                return false;
            }
            return this.mYAxis.equals(axisBreakSymbolWithAxesProperties.mYAxis);
        }

        public Double getXValue() {
            return new Double(this.mXValue);
        }

        public Double getYValue() {
            return new Double(this.mYValue);
        }

        public SGAxis getXAxis() {
            return this.mXAxis;
        }

        public SGAxis getYAxis() {
            return this.mYAxis;
        }

        public boolean setXValue(double d) {
            this.mXValue = d;
            return true;
        }

        public boolean setYValue(double d) {
            this.mYValue = d;
            return true;
        }

        private boolean setXAxis(SGAxis sGAxis) {
            if (sGAxis == null) {
                throw new IllegalArgumentException("axis==null");
            }
            this.mXAxis = sGAxis;
            return true;
        }

        private boolean setYAxis(SGAxis sGAxis) {
            if (sGAxis == null) {
                throw new IllegalArgumentException("axis==null");
            }
            this.mYAxis = sGAxis;
            return true;
        }
    }

    private class AxisBreakSymbol
    extends SGDrawingElementAxisBreak2D
    implements ActionListener,
    SGIAxisBreakDialogObserver,
    SGIUndoable,
    SGISelectable,
    SGIMovable,
    SGICopiable,
    SGINode,
    SGIDisposable,
    SGFigureElement.ChildObject {
        private int mID;
        private SGAxis mXAxis = null;
        private SGAxis mYAxis = null;
        private double mXValue;
        private double mYValue;
        private boolean mFrameFlag = false;
        private SGProperties mTemporaryProperties = null;
        private JPopupMenu mPopupMenu = new JPopupMenu();
        private int mTempXAxis = -1;
        private int mTempYAxis = -1;
        private boolean mValidFlag = true;
        private SGUndoManager mUndoManager = new SGUndoManager(this);
        private boolean mSelectedFlag = false;

        public int getID() {
            return this.mID;
        }

        public boolean setID(int n) {
            this.mID = n;
            return true;
        }

        AxisBreakSymbol() {
            this.init();
        }

        AxisBreakSymbol(float f, String string, float f2, String string2, float f3, float f4, boolean bl) {
            super(f, string, f2, string2, f3, f4, bl);
            this.init();
        }

        private boolean init() {
            this.createPopupMenu();
            return true;
        }

        public void dispose() {
            super.dispose();
            this.mPopupMenu = null;
            this.mTemporaryProperties = null;
            this.mUndoManager.dispose();
            this.mUndoManager = null;
            this.mXAxis = null;
            this.mYAxis = null;
        }

        public String toString() {
            return "AxisBreak:" + this.mID;
        }

        public void finalize() {
        }

        public int getXAxisLocation() {
            return SGFigureElementAxisBreak.this.mAxisElement.getLocationInPlane(this.mXAxis);
        }

        public int getYAxisLocation() {
            return SGFigureElementAxisBreak.this.mAxisElement.getLocationInPlane(this.mYAxis);
        }

        public boolean setXAxisLocation(int n) {
            if (n != 0 & n != 1) {
                return false;
            }
            this.mXAxis = this.getAxis(n);
            return true;
        }

        public boolean setYAxisLocation(int n) {
            if (n != 2 & n != 3) {
                return false;
            }
            this.mYAxis = this.getAxis(n);
            return true;
        }

        private SGAxis getAxis(int n) {
            return SGFigureElementAxisBreak.this.mAxisElement.getAxisInPlane(n);
        }

        public double getXValue() {
            return this.mXValue;
        }

        public double getYValue() {
            return this.mYValue;
        }

        public Color getInnerColor() {
            return this.getColor(0);
        }

        public float getLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
        }

        public float getLength(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLength(), string);
        }

        public float getInterval(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getInterval(), string);
        }

        public boolean setXValue(double d) {
            this.mXValue = d;
            return true;
        }

        public boolean setYValue(double d) {
            this.mYValue = d;
            return true;
        }

        public boolean setLineWidth(float f, String string) {
            double d = SGUtilityText.convert(f, string, "pt");
            if (d < 0.25) {
                return false;
            }
            if (d > 6.0) {
                return false;
            }
            return super.setLineWidth(f, string);
        }

        public boolean setLength(float f, String string) {
            double d = SGUtilityText.convert(f, string, "cm");
            if (d < 0.5) {
                return false;
            }
            if (d > 2.0) {
                return false;
            }
            return super.setLength(f, string);
        }

        public boolean setInterval(float f, String string) {
            double d = SGUtilityText.convert(f, string, "cm");
            if (d < 0.1) {
                return false;
            }
            if (d > 2.0) {
                return false;
            }
            return super.setInterval(f, string);
        }

        public boolean hasValidXValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mXAxis : SGFigureElementAxisBreak.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidYValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mYAxis : SGFigureElementAxisBreak.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getYValue();
            return sGAxis.isValidValue(d);
        }

        public boolean setInnerColor(Color color) {
            return this.setColor(color);
        }

        public Object copy() {
            AxisBreakSymbol axisBreakSymbol = new AxisBreakSymbol();
            axisBreakSymbol.setMagnification(this.getMagnification());
            axisBreakSymbol.setProperties(this.getProperties());
            axisBreakSymbol.setLocation(this.getX(), this.getY());
            axisBreakSymbol.mTempXAxis = SGFigureElementAxisBreak.this.mAxisElement.getLocationInCube(this.mXAxis);
            axisBreakSymbol.mTempYAxis = SGFigureElementAxisBreak.this.mAxisElement.getLocationInCube(this.mYAxis);
            return axisBreakSymbol;
        }

        public SGPropertyDialog getPropertyDialog() {
            return SGFigureElementAxisBreak.this.mDialog;
        }

        public ArrayList getChildNodes() {
            return new ArrayList();
        }

        public String getClassDescription() {
            return "";
        }

        public String getInstanceDescription() {
            SGIFigureElementAxis sGIFigureElementAxis = SGFigureElementAxisBreak.this.mAxisElement;
            String string = sGIFigureElementAxis.getLocationName(this.mXAxis);
            String string2 = sGIFigureElementAxis.getLocationName(this.mYAxis);
            String string3 = "";
            string3 = string3 + this.mID + ": " + string + ", " + string2 + ", ";
            string3 = string3 + "( X=" + this.mXValue + ", Y=" + this.mYValue + " )";
            return string3;
        }

        private JPopupMenu getPopupMenu() {
            return this.mPopupMenu;
        }

        private boolean createPopupMenu() {
            JPopupMenu jPopupMenu = this.mPopupMenu;
            jPopupMenu.setBounds(0, 0, 100, 100);
            jPopupMenu.add(new JLabel("  -- AxisBreak --"));
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Move to Front");
            SGUtility.addItem(jPopupMenu, this, "Move to Back");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Cut");
            SGUtility.addItem(jPopupMenu, this, "Copy");
            SGUtility.addItem(jPopupMenu, this, "Paste");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Delete");
            SGUtility.addItem(jPopupMenu, this, "Duplicate");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Property");
            return true;
        }

        public SGTuple2f getLocation() {
            float f = super.getX();
            float f2 = super.getY();
            float f3 = this.getMagnification() * f + SGFigureElementAxisBreak.this.mGraphRectX;
            float f4 = this.getMagnification() * f2 + SGFigureElementAxisBreak.this.mGraphRectY;
            return new SGTuple2f(f3, f4);
        }

        public float getX() {
            return this.getLocation().x;
        }

        public float getY() {
            return this.getLocation().y;
        }

        public boolean setLocation(float f, float f2) {
            float f3 = this.getMagnification();
            float f4 = (f - SGFigureElementAxisBreak.this.mGraphRectX) / f3;
            float f5 = (f2 - SGFigureElementAxisBreak.this.mGraphRectY) / f3;
            super.setLocation(f4, f5);
            return true;
        }

        public void translate(float f, float f2) {
            this.setLocation(this.getX() + f, this.getY() + f2);
            this.setAxisValue();
            this.setDrawingElementsLocation();
        }

        private void drawBoundingBox(Graphics2D graphics2D) {
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setPaint(Color.BLACK);
            graphics2D.draw(this.getElementBounds());
        }

        private ArrayList getAnchorPointList() {
            ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
            Shape[] shapeArray = this.getShapeArray();
            Line2D line2D = (Line2D)shapeArray[1];
            Line2D line2D2 = (Line2D)shapeArray[3];
            Point2D point2D = line2D.getP1();
            Point2D point2D2 = line2D.getP2();
            Point2D point2D3 = line2D2.getP1();
            Point2D point2D4 = line2D2.getP2();
            Point2D.Float float_ = new Point2D.Float((float)(point2D4.getX() + point2D.getX()) / 2.0f, (float)(point2D4.getY() + point2D.getY()) / 2.0f);
            Point2D.Float float_2 = new Point2D.Float((float)(point2D2.getX() + point2D3.getX()) / 2.0f, (float)(point2D2.getY() + point2D3.getY()) / 2.0f);
            arrayList.add(point2D4);
            arrayList.add(float_);
            arrayList.add(point2D);
            arrayList.add(point2D2);
            arrayList.add(float_2);
            arrayList.add(point2D3);
            return arrayList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            if (string.equals("Property")) {
                SGFigureElementAxisBreak.this.setPropertiesOfSelectedObjects();
            } else if (string.equals("Copy") | string.equals("Cut") | string.equals("Paste") | string.equals("Delete") | string.equals("Duplicate") | string.equals("Move to Front") | string.equals("Move to Back")) {
                SGFigureElementAxisBreak.this.notifyToListener(string);
            }
        }

        public boolean isValid() {
            return this.mValidFlag;
        }

        public void setValid(boolean bl) {
            this.mValidFlag = bl;
        }

        public boolean setDrawingElementsLocation() {
            float f = SGFigureElementAxisBreak.this.calcLocation(this.mXValue, this.mXAxis, true);
            float f2 = SGFigureElementAxisBreak.this.calcLocation(this.mYValue, this.mYAxis, false);
            if (Float.isNaN(f) | Float.isNaN(f2)) {
                this.setValid(false);
                return false;
            }
            this.setValid(true);
            this.setLocation(f, f2);
            return true;
        }

        public boolean setAxisValue() {
            double d = SGFigureElementAxisBreak.this.calcValue(this.getX(), this.mXAxis, true);
            double d2 = SGFigureElementAxisBreak.this.calcValue(this.getY(), this.mYAxis, false);
            this.mXValue = SGFigureElementAxisBreak.this.getNumberInRangeOrder(d, this.mXAxis);
            this.mYValue = SGFigureElementAxisBreak.this.getNumberInRangeOrder(d2, this.mYAxis);
            return true;
        }

        public String getTagName() {
            return "AxisBreakSymbol";
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            element.setAttribute("XValue", Double.toString(this.mXValue));
            element.setAttribute("YValue", Double.toString(this.mYValue));
            element.setAttribute("XAxisPosition", SGFigureElementAxisBreak.this.mAxisElement.getLocationName(this.mXAxis));
            element.setAttribute("YAxisPosition", SGFigureElementAxisBreak.this.mAxisElement.getLocationName(this.mYAxis));
            return true;
        }

        public boolean readProperty(Element element) {
            SGAxis sGAxis;
            if (!super.readProperty(element)) {
                return false;
            }
            String string = null;
            Double d = null;
            Object var4_4 = null;
            Object var5_5 = null;
            Object var6_6 = null;
            string = element.getAttribute("XAxisPosition");
            if (string.length() != 0) {
                sGAxis = SGFigureElementAxisBreak.this.mAxisElement.getAxis(string);
                if (sGAxis == null) {
                    return false;
                }
                this.mXAxis = sGAxis;
            }
            if ((string = element.getAttribute("YAxisPosition")).length() != 0) {
                sGAxis = SGFigureElementAxisBreak.this.mAxisElement.getAxis(string);
                if (sGAxis == null) {
                    return false;
                }
                this.mYAxis = sGAxis;
            }
            if ((string = element.getAttribute("XValue")).length() != 0) {
                d = SGUtilityText.getDouble(string);
                if (d == null) {
                    return false;
                }
                double d2 = d;
                if (!this.mXAxis.isValidValue(d2)) {
                    return false;
                }
                if (!this.setXValue(d2)) {
                    return false;
                }
            }
            if ((string = element.getAttribute("YValue")).length() != 0) {
                d = SGUtilityText.getDouble(string);
                if (d == null) {
                    return false;
                }
                double d3 = d;
                if (!this.mYAxis.isValidValue(d3)) {
                    return false;
                }
                if (!this.setYValue(d3)) {
                    return false;
                }
            }
            return true;
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getProperties();
            return true;
        }

        public boolean commit() {
            SGProperties sGProperties = this.getProperties();
            if (sGProperties == null) {
                return false;
            }
            if (!sGProperties.equals(this.mTemporaryProperties)) {
                this.setChanged(true);
            }
            if (!this.create()) {
                return false;
            }
            if (!this.setDrawingElementsLocation()) {
                return false;
            }
            SGFigureElementAxisBreak.this.repaint();
            return true;
        }

        public boolean cancel() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            if (!this.create()) {
                return false;
            }
            if (!this.setDrawingElementsLocation()) {
                return false;
            }
            SGFigureElementAxisBreak.this.repaint();
            return true;
        }

        public boolean preview() {
            if (!this.create()) {
                return false;
            }
            if (!this.setDrawingElementsLocation()) {
                return false;
            }
            SGFigureElementAxisBreak.this.repaint();
            return true;
        }

        public SGProperties getMemento() {
            return this.getProperties();
        }

        public boolean setMemento(SGProperties sGProperties) {
            return this.setProperties(sGProperties);
        }

        public boolean isUndoable() {
            return this.mUndoManager.isUndoable();
        }

        public boolean isRedoable() {
            return this.mUndoManager.isRedoable();
        }

        public boolean initPropertiesHistory() {
            return this.mUndoManager.initPropertiesHistory();
        }

        public boolean setMementoBackward() {
            if (!this.mUndoManager.setMementoBackward()) {
                return false;
            }
            this.create();
            this.setDrawingElementsLocation();
            return true;
        }

        public boolean setMementoForward() {
            if (!this.mUndoManager.setMementoForward()) {
                return false;
            }
            this.create();
            this.setDrawingElementsLocation();
            return true;
        }

        public boolean undo() {
            return this.setMementoBackward();
        }

        public boolean redo() {
            return this.setMementoForward();
        }

        public boolean updateHistory() {
            return this.mUndoManager.updateHistory();
        }

        public void initUndoBuffer() {
            this.mUndoManager.initUndoBuffer();
        }

        public boolean isChanged() {
            return this.mUndoManager.isChanged();
        }

        public void setChanged(boolean bl) {
            this.mUndoManager.setChanged(bl);
        }

        public boolean isChangedRoot() {
            return this.isChanged();
        }

        public void notifyToRoot() {
            SGFigureElementAxisBreak.this.notifyToRoot();
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof AxisBreakSymbolWithAxesProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = (AxisBreakSymbolWithAxesProperties)sGProperties;
            Double d = axisBreakSymbolWithAxesProperties.getXValue();
            if (d == null) {
                return false;
            }
            this.mXValue = d;
            Double d2 = axisBreakSymbolWithAxesProperties.getYValue();
            if (d2 == null) {
                return false;
            }
            this.mYValue = d2;
            this.mXAxis = axisBreakSymbolWithAxesProperties.mXAxis;
            this.mYAxis = axisBreakSymbolWithAxesProperties.mYAxis;
            return true;
        }

        public SGProperties getProperties() {
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = new AxisBreakSymbolWithAxesProperties();
            if (!this.getProperties(axisBreakSymbolWithAxesProperties)) {
                return null;
            }
            return axisBreakSymbolWithAxesProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof AxisBreakSymbolWithAxesProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = (AxisBreakSymbolWithAxesProperties)sGProperties;
            axisBreakSymbolWithAxesProperties.setXValue(this.mXValue);
            axisBreakSymbolWithAxesProperties.setYValue(this.mYValue);
            axisBreakSymbolWithAxesProperties.mXAxis = this.mXAxis;
            axisBreakSymbolWithAxesProperties.mYAxis = this.mYAxis;
            return true;
        }

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
        }
    }

    public static class AxisProperties
    extends SGProperties {
        List visibleAxisBreakSymbolList = new ArrayList();

        AxisProperties() {
        }

        public void dispose() {
            this.visibleAxisBreakSymbolList.clear();
            this.visibleAxisBreakSymbolList = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AxisProperties)) {
                return false;
            }
            AxisProperties axisProperties = (AxisProperties)object;
            return ((Object)axisProperties.visibleAxisBreakSymbolList).equals(this.visibleAxisBreakSymbolList);
        }
    }
}

