/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;
import org.w3c.dom.Element;

public abstract class SGElementGroupLine
extends SGElementGroupSXY
implements SGILineConstants,
SGIElementGroupConstants {
    public static final int MODE_ALL = 0;
    public static final int MODE_OMIT = 1;
    protected int mMode = 1;
    protected float mLineWidth;
    protected int mLineType;
    protected int mCap = 0;
    protected int mJoin = 1;
    protected float mMiterLimit = 1.0f;
    protected float mDashPhase = 0.0f;
    protected ArrayList mConnectedPathList = new ArrayList();

    public void dispose() {
        super.dispose();
        this.mConnectedPathList.clear();
        this.mConnectedPathList = null;
    }

    public boolean setLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("width<0.0f");
        }
        this.mLineWidth = f;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)sGDrawingElementArray[i];
                sGDrawingElementLine2D.setLineWidth(f);
            }
        }
        return true;
    }

    public boolean setLineWidth(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setLineWidth((float)d);
    }

    public boolean setLineType(int n) {
        this.mLineType = n;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)sGDrawingElementArray[i];
                sGDrawingElementLine2D.setType(n);
            }
        }
        return true;
    }

    public boolean setBasicStrokeProperty(int n, int n2, float f, float f2) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("The argument is invalid.");
        }
        if (n2 != 2 && n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("The argument is invalid.");
        }
        if (f < 1.0f && n2 == 0) {
            throw new IllegalArgumentException("The argument is invalid.");
        }
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("The argument is invalid.");
        }
        this.mCap = n;
        this.mJoin = n2;
        this.mMiterLimit = f;
        this.mDashPhase = f2;
        return true;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public float getLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
    }

    public int getLineType() {
        return this.mLineType;
    }

    public int getCap() {
        return this.mCap;
    }

    public int getJoin() {
        return this.mJoin;
    }

    public float getMiterLimit() {
        return this.mMiterLimit;
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)this.createDrawingElementInstance();
        sGDrawingElementLine.setVisible(this.isVisible());
        sGDrawingElementLine.setLineWidth(this.getLineWidth());
        sGDrawingElementLine.setType(this.getLineType());
        sGDrawingElementLine.setColorList(this.getColorList());
        return sGDrawingElementLine;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementLine)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)sGDrawingElement;
        this.setLineType(sGDrawingElementLine.getLineType());
        this.setLineWidth(sGDrawingElementLine.getLineWidth());
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (graphics2D == null) {
            return false;
        }
        graphics2D.setPaint(this.getColor(0));
        float f = this.mMagnification * this.mLineWidth;
        BasicStroke basicStroke = SGUtilityJava2D.getBasicStroke(this.mLineType, f, this.mCap, this.mJoin, this.mMiterLimit, this.mDashPhase);
        graphics2D.setStroke(basicStroke);
        ArrayList arrayList = new ArrayList(this.mConnectedPathList);
        if (rectangle2D == null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                GeneralPath generalPath = (GeneralPath)arrayList.get(i);
                graphics2D.draw(generalPath);
            }
        } else {
            Area area = new Area(rectangle2D);
            for (int i = 0; i < arrayList.size(); ++i) {
                GeneralPath generalPath = (GeneralPath)arrayList.get(i);
                Shape shape = basicStroke.createStrokedShape(generalPath);
                Area area2 = new Area(shape);
                area2.intersect(area);
                graphics2D.fill(area2);
            }
        }
        return true;
    }

    public String getTagName() {
        return "Line";
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("Width", Float.toString(this.mLineWidth) + "pt");
        element.setAttribute("Type", SGDrawingElementLine.getLineTypeName(this.mLineType));
        element.setAttribute("Color", SGUtilityText.getColorListString(this.mColorList));
        return true;
    }

    public boolean readProperty(Element element) {
        Serializable serializable;
        String string = null;
        Number number = null;
        Object var4_4 = null;
        Object var5_5 = null;
        List list = null;
        string = element.getAttribute("Width");
        if (string.length() != 0) {
            serializable = new StringBuffer();
            number = SGUtilityText.getNumber(string, serializable);
            if (number == null) {
                return false;
            }
            float f = number.floatValue();
            if (!this.setLineWidth(f, serializable.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Type")).length() != 0) {
            number = SGDrawingElementLine.getLineTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setLineType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Color")).length() != 0) {
            list = SGUtilityText.getColorList(string);
            if (list == null) {
                return false;
            }
            if (list.size() < 1) {
                return false;
            }
            serializable = (Color)list.get(0);
            if (!this.setColor((Color)serializable)) {
                return false;
            }
        }
        return true;
    }

    protected SGDrawingElement createDrawingElementInstance() {
        return new SGDrawingElementLine2D();
    }

    public boolean initDrawingElement(int n) {
        return super.initDrawingElement(n - 1);
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
        int n = sGTuple2fArray.length;
        if (!this.initDrawingElement(n)) {
            return false;
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            ((SGDrawingElementLine)sGDrawingElementArray[i]).setTermPoints(sGTuple2fArray[i], sGTuple2fArray[i + 1]);
        }
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        return this.setLocation(sGTuple2fArray, true);
    }

    protected boolean setLocation(SGTuple2f[] sGTuple2fArray, boolean bl) {
        int n;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray == null) {
            return true;
        }
        if (sGTuple2fArray.length - 1 != sGDrawingElementArray.length) {
            throw new Error("pointArray.length != this.mDrawingElementArray.length + 1");
        }
        ArrayList arrayList = this.mConnectedPathList;
        arrayList.clear();
        boolean bl2 = true;
        boolean[] blArray = new boolean[sGTuple2fArray.length];
        for (n = 0; n < blArray.length; ++n) {
            boolean bl3 = blArray[n] = !(sGTuple2fArray[n].isInfinite() | sGTuple2fArray[n].isNaN());
            if (blArray[n]) continue;
            bl2 = false;
        }
        if (bl2) {
            int n2;
            if (bl) {
                for (n = 0; n < sGTuple2fArray.length - 1; ++n) {
                    SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)sGDrawingElementArray[n];
                    sGDrawingElementLine.setTermPoints(sGTuple2fArray[n], sGTuple2fArray[n + 1]);
                }
            }
            SGTuple2f[] sGTuple2fArray2 = sGTuple2fArray;
            if (this.mMode == 1) {
                sGTuple2fArray2 = this.reduceClosePoints(sGTuple2fArray2);
            }
            if ((n2 = sGTuple2fArray2.length) > 1) {
                GeneralPath generalPath = new GeneralPath();
                Line2D.Float float_ = new Line2D.Float(sGTuple2fArray2[0].x, sGTuple2fArray2[0].y, sGTuple2fArray2[1].x, sGTuple2fArray2[1].y);
                generalPath.append(float_, true);
                if (n2 > 2) {
                    for (int i = 0; i < sGTuple2fArray2.length; ++i) {
                        generalPath.lineTo(sGTuple2fArray2[i].x, sGTuple2fArray2[i].y);
                    }
                }
                arrayList.add(generalPath);
            }
        } else {
            Object object;
            int n3;
            ArrayList arrayList2 = new ArrayList();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            for (n3 = 0; n3 < sGTuple2fArray.length - 1; ++n3) {
                object = (SGDrawingElementLine)sGDrawingElementArray[n3];
                boolean bl4 = blArray[n3] & blArray[n3 + 1];
                ((SGDrawingElement)object).setVisible(bl4);
                if (bl4) {
                    ((SGDrawingElementLine)object).setTermPoints(sGTuple2fArray[n3], sGTuple2fArray[n3 + 1]);
                    arrayList3.add(object);
                    continue;
                }
                if (arrayList3.size() == 0) continue;
                arrayList2.add(arrayList3);
                arrayList3 = new ArrayList();
            }
            if (arrayList3.size() != 0) {
                arrayList2.add(arrayList3);
            }
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                object = (ArrayList)arrayList2.get(n3);
                GeneralPath generalPath = new GeneralPath();
                SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)((ArrayList)object).get(0);
                Line2D line2D = SGDrawingElementLine2D.getLine(sGDrawingElementLine);
                generalPath.append(line2D, true);
                if (((ArrayList)object).size() > 2) {
                    Point2D point2D = line2D.getP2();
                    int n4 = (int)point2D.getX();
                    int n5 = (int)point2D.getY();
                    for (int i = 1; i < ((ArrayList)object).size(); ++i) {
                        float f;
                        SGDrawingElementLine sGDrawingElementLine2 = (SGDrawingElementLine)((ArrayList)object).get(i);
                        SGTuple2f sGTuple2f = sGDrawingElementLine2.getEnd();
                        float f2 = sGTuple2f.x;
                        if ((int)f2 == n4 & (int)(f = sGTuple2f.y) == n5) continue;
                        generalPath.lineTo(f2, f);
                        n4 = (int)f2;
                        n5 = (int)f;
                    }
                }
                arrayList.add(generalPath);
            }
        }
        return true;
    }

    private SGTuple2f[] reduceClosePoints(SGTuple2f[] sGTuple2fArray) {
        int n = sGTuple2fArray.length;
        if (n < 2) {
            return sGTuple2fArray;
        }
        ArrayList<SGTuple2f> arrayList = new ArrayList<SGTuple2f>();
        arrayList.add(sGTuple2fArray[0]);
        int n2 = (int)sGTuple2fArray[0].x;
        int n3 = (int)sGTuple2fArray[0].y;
        for (int i = 1; i < n; ++i) {
            float f;
            float f2 = sGTuple2fArray[i].x;
            if ((int)f2 == n2 & (int)(f = sGTuple2fArray[i].y) == n3) continue;
            arrayList.add(sGTuple2fArray[i]);
            n2 = (int)f2;
            n3 = (int)f;
        }
        SGTuple2f[] sGTuple2fArray2 = arrayList.toArray(new SGTuple2f[0]);
        return sGTuple2fArray2;
    }

    private SGTuple2f[] reducePointsInNoise(SGTuple2f[] sGTuple2fArray) {
        int n = sGTuple2fArray.length;
        if (n < 2) {
            return sGTuple2fArray;
        }
        ArrayList<SGTuple2f> arrayList = new ArrayList<SGTuple2f>();
        arrayList.add(sGTuple2fArray[0]);
        float f = sGTuple2fArray[0].x;
        float f2 = sGTuple2fArray[0].y;
        float f3 = sGTuple2fArray[0].y;
        float f4 = sGTuple2fArray[0].y;
        int n2 = 1;
        boolean bl = false;
        do {
            float f5 = sGTuple2fArray[n2].x;
            float f6 = sGTuple2fArray[n2].y;
            if ((int)f5 == (int)f) {
                f3 = Math.min(f6, f3);
                f4 = Math.max(f6, f4);
                bl = true;
            } else {
                if (bl) {
                    arrayList.add(new SGTuple2f(f, f3));
                    arrayList.add(new SGTuple2f(f, f4));
                    arrayList.add(new SGTuple2f(f, f2));
                }
                arrayList.add(new SGTuple2f(f5, f6));
                f3 = f6;
                f4 = f6;
                bl = false;
            }
            f = f5;
            f2 = f6;
        } while (++n2 < n);
        if (bl) {
            arrayList.add(new SGTuple2f(f, f3));
            arrayList.add(new SGTuple2f(f, f4));
        }
        SGTuple2f[] sGTuple2fArray2 = arrayList.toArray(new SGTuple2f[0]);
        return sGTuple2fArray2;
    }

    public boolean setPropertiesOfDrawingElements() {
        for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
            SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)this.mDrawingElementArray[i];
            sGDrawingElementLine.setType(this.mLineType);
            sGDrawingElementLine.setColorList(this.mColorList);
            sGDrawingElementLine.setLineWidth(this.mLineWidth);
            sGDrawingElementLine.setMagnification(this.mMagnification);
        }
        return true;
    }

    public SGProperties getProperties() {
        LineProperties lineProperties = new LineProperties();
        this.getProperties(lineProperties);
        return lineProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof LineProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        LineProperties lineProperties = (LineProperties)sGProperties;
        lineProperties.setLineWidth(this.getLineWidth());
        lineProperties.setLineType(this.getLineType());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof LineProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        LineProperties lineProperties = (LineProperties)sGProperties;
        Float f = lineProperties.getLineWidth();
        if (f == null) {
            return false;
        }
        Integer n = lineProperties.getLineType();
        if (n == null) {
            return false;
        }
        this.setLineWidth(f.floatValue());
        this.setLineType(n);
        return true;
    }

    public static class LineProperties
    extends SGElementGroup.ElementGroupProperties {
        private SGDrawingElementLine.LineProperties mLineProperties = new SGDrawingElementLine.LineProperties();

        public boolean equals(Object object) {
            if (!(object instanceof LineProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            LineProperties lineProperties = (LineProperties)object;
            return this.mLineProperties.equals(lineProperties.mLineProperties);
        }

        public Float getLineWidth() {
            return this.mLineProperties.getLineWidth();
        }

        public Integer getLineType() {
            return this.mLineProperties.getLineType();
        }

        public void setLineWidth(float f) {
            this.mLineProperties.setLineWidth(f);
        }

        public void setLineType(int n) {
            this.mLineProperties.setLineType(n);
        }
    }
}

