/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIErrorBarConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGISymbolConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementErrorBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupVXY;
import org.w3c.dom.Element;

public abstract class SGElementGroupErrorBar
extends SGElementGroupVXY
implements SGILineConstants,
SGISymbolConstants,
SGIErrorBarConstants,
SGIArrowConstants {
    protected float mLineWidth;
    protected int mLineType;
    protected float mHeadSize;
    protected int mHeadType = -1;
    protected int mErrorBarStyle = 1;

    protected SGDrawingElement createDrawingElementInstance() {
        return new SGDrawingElementErrorBar2D();
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2) {
        int n = sGTuple2fArray.length;
        if (!this.initDrawingElement(n)) {
            return false;
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < n; ++i) {
            ((SGDrawingElementErrorBar)sGDrawingElementArray[i]).setTermPoints(sGTuple2fArray[i], sGTuple2fArray2[i]);
        }
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2) {
        if (sGTuple2fArray == null || sGTuple2fArray2 == null) {
            throw new IllegalArgumentException("startArray==null || endArray==null");
        }
        if (sGTuple2fArray.length != sGTuple2fArray2.length) {
            throw new IllegalArgumentException("startArray.length != endArray.length");
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            throw new IllegalArgumentException("startArray.length != this.mDrawingElementArray.length");
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray == null) {
            return false;
        }
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            boolean bl = !sGTuple2fArray[i].isInfinite() && !sGTuple2fArray[i].isNaN() && !sGTuple2fArray2[i].isInfinite() && !sGTuple2fArray2[i].isNaN();
            sGDrawingElementArray[i].setVisible(bl);
            if (!bl) continue;
            ((SGDrawingElementErrorBar)sGDrawingElementArray[i]).setTermPoints(sGTuple2fArray[i], sGTuple2fArray2[i]);
        }
        return true;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public float getLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
    }

    public boolean setLineWidth(float f) {
        this.mLineWidth = f;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                if (((SGDrawingElementErrorBar)sGDrawingElementArray[i]).setLineWidth(f)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean setLineWidth(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setLineWidth((float)d);
    }

    public float getHeadSize() {
        return this.mHeadSize;
    }

    public float getHeadSize(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getHeadSize(), string);
    }

    public boolean setHeadSize(float f) {
        this.mHeadSize = f;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                if (((SGDrawingElementErrorBar)sGDrawingElementArray[i]).setHeadSize(f)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean setHeadSize(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setHeadSize((float)d);
    }

    public int getErrorBarStyle() {
        return this.mErrorBarStyle;
    }

    public boolean setErrorBarStyle(int n) {
        this.mErrorBarStyle = n;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray == null) {
            return true;
        }
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            if (((SGDrawingElementErrorBar)sGDrawingElementArray[i]).setErrorBarStyle(n)) continue;
            return false;
        }
        return true;
    }

    public String getTagName() {
        return "ErrorBar";
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("Style", SGDrawingElementErrorBar.getErrorBarStyleName(this.mErrorBarStyle));
        element.setAttribute("Width", Float.toString(this.mLineWidth) + "pt");
        element.setAttribute("HeadSize", Float.toString(this.mHeadSize * 0.035277776f) + "cm");
        element.setAttribute("HeadType", SGDrawingElementSymbol.getSymbolTypeName(this.getHeadType()));
        element.setAttribute("Color", SGUtilityText.getColorListString(this.mColorList));
        return true;
    }

    public boolean readProperty(Element element) {
        String string = null;
        Number number = null;
        Object var4_4 = null;
        Object var5_5 = null;
        List list = null;
        string = element.getAttribute("Color");
        if (string.length() == 0) {
            return false;
        }
        list = SGUtilityText.getColorList(string);
        if (list == null) {
            return false;
        }
        if (list.size() < 1) {
            return false;
        }
        Color color = (Color)list.get(0);
        string = element.getAttribute("Width");
        if (string.length() == 0 && (string = element.getAttribute("LineWidth")).length() == 0) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        number = SGUtilityText.getNumber(string, stringBuffer);
        if (number == null) {
            return false;
        }
        float f = number.floatValue();
        string = element.getAttribute("HeadSize");
        if (string.length() == 0) {
            return false;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        number = SGUtilityText.getNumber(string, stringBuffer2);
        if (number == null) {
            return false;
        }
        float f2 = number.floatValue();
        string = element.getAttribute("Style");
        if (string.length() == 0) {
            return false;
        }
        number = SGDrawingElementErrorBar.getErrorBarStyleFromName(string);
        if (number == null) {
            return false;
        }
        int n = number.intValue();
        string = element.getAttribute("HeadType");
        if (string.length() == 0) {
            return false;
        }
        Integer n2 = SGDrawingElementErrorBar.getHeadTypeFromName(string);
        if (n2 == null) {
            return false;
        }
        int n3 = n2;
        if (!this.setLineWidth(f, stringBuffer.toString())) {
            return false;
        }
        if (!this.setColor(color)) {
            return false;
        }
        if (!this.setErrorBarStyle(n)) {
            return false;
        }
        return this.setHeadType(n3);
    }

    public int getHeadType() {
        return this.mHeadType;
    }

    public boolean setHeadType(int n) {
        this.mHeadType = n;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                if (((SGDrawingElementErrorBar)sGDrawingElementArray[i]).setHeadType(n)) continue;
                return false;
            }
        }
        return true;
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementErrorBar sGDrawingElementErrorBar = (SGDrawingElementErrorBar)this.createDrawingElementInstance();
        sGDrawingElementErrorBar.setVisible(this.isVisible());
        sGDrawingElementErrorBar.setLineWidth(this.getLineWidth());
        sGDrawingElementErrorBar.setColorList(this.getColorList());
        sGDrawingElementErrorBar.setHeadSize(this.getHeadSize());
        sGDrawingElementErrorBar.setHeadType(this.getHeadType());
        sGDrawingElementErrorBar.setErrorBarStyle(this.getErrorBarStyle());
        return sGDrawingElementErrorBar;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        SGDrawingElement[] sGDrawingElementArray;
        Area area = null;
        if (rectangle2D != null) {
            area = new Area(rectangle2D);
        }
        if ((sGDrawingElementArray = this.mDrawingElementArray) != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementErrorBar2D sGDrawingElementErrorBar2D = (SGDrawingElementErrorBar2D)sGDrawingElementArray[i];
                if (!sGDrawingElementErrorBar2D.isVisible()) continue;
                sGDrawingElementErrorBar2D.paint(graphics2D, rectangle2D);
            }
        }
        return true;
    }

    public SGProperties getProperties() {
        ErrorBarProperties errorBarProperties = new ErrorBarProperties();
        if (!this.getProperties(errorBarProperties)) {
            return null;
        }
        return errorBarProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ErrorBarProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        ErrorBarProperties errorBarProperties = (ErrorBarProperties)sGProperties;
        errorBarProperties.setLineWidth(this.getLineWidth());
        errorBarProperties.setHeadSize(this.getHeadSize());
        errorBarProperties.setHeadType(this.getHeadType());
        errorBarProperties.setErrorBarStyle(this.getErrorBarStyle());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ErrorBarProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        ErrorBarProperties errorBarProperties = (ErrorBarProperties)sGProperties;
        this.setLineWidth(errorBarProperties.getLineWidth().floatValue());
        this.setHeadSize(errorBarProperties.getHeadSize().floatValue());
        this.setHeadType(errorBarProperties.getHeadType());
        Integer n = errorBarProperties.getErrorBarStyle();
        if (n == null) {
            return false;
        }
        this.setErrorBarStyle(n);
        return true;
    }

    public boolean setPropertiesOfDrawingElements() {
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        float f = this.getMagnification();
        ArrayList arrayList = this.getColorList();
        float f2 = this.getLineWidth();
        float f3 = this.getHeadSize();
        int n = this.getHeadType();
        int n2 = this.getErrorBarStyle();
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGDrawingElementErrorBar sGDrawingElementErrorBar = (SGDrawingElementErrorBar)sGDrawingElementArray[i];
            sGDrawingElementErrorBar.setErrorBarStyle(n2);
            sGDrawingElementErrorBar.setMagnification(f);
            sGDrawingElementErrorBar.setColorList(arrayList);
            sGDrawingElementErrorBar.setLineWidth(f2);
            sGDrawingElementErrorBar.setHeadSize(f3);
            sGDrawingElementErrorBar.setHeadType(n);
        }
        return true;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementErrorBar)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementErrorBar sGDrawingElementErrorBar = (SGDrawingElementErrorBar)sGDrawingElement;
        this.setLineWidth(sGDrawingElementErrorBar.getLineWidth());
        this.setHeadSize(sGDrawingElementErrorBar.getHeadSize());
        this.setLineWidth(sGDrawingElementErrorBar.getLineWidth());
        this.setHeadType(sGDrawingElementErrorBar.getHeadType());
        this.setErrorBarStyle(sGDrawingElementErrorBar.getErrorBarStyle());
        return true;
    }

    public static class ErrorBarProperties
    extends SGElementGroup.ElementGroupProperties {
        private SGDrawingElementErrorBar.ErrorBarProperties mErrorBarProperties = new SGDrawingElementErrorBar.ErrorBarProperties();

        public boolean equals(Object object) {
            if (!(object instanceof ErrorBarProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ErrorBarProperties errorBarProperties = (ErrorBarProperties)object;
            return this.mErrorBarProperties.equals(errorBarProperties.mErrorBarProperties);
        }

        public Float getLineWidth() {
            return this.mErrorBarProperties.getLineWidth();
        }

        public Float getHeadSize() {
            return this.mErrorBarProperties.getHeadSize();
        }

        public Integer getHeadType() {
            return this.mErrorBarProperties.getHeadType();
        }

        public void setColor(ArrayList arrayList) {
            super.setColor(arrayList);
            this.mErrorBarProperties.setColor(arrayList);
        }

        public void setLineWidth(float f) {
            this.mErrorBarProperties.setLineWidth(f);
        }

        public void setHeadSize(float f) {
            this.mErrorBarProperties.setHeadSize(f);
        }

        public void setHeadType(int n) {
            this.mErrorBarProperties.setHeadType(n);
        }

        public Integer getErrorBarStyle() {
            return this.mErrorBarProperties.getErrorBarStyle();
        }

        public void setErrorBarStyle(int n) {
            this.mErrorBarProperties.setErrorBarStyle(n);
        }
    }
}

