/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;

public class SGDrawingElementString2DExtended
extends SGDrawingElementString2D {
    private final float SCRIPT_FONTFACTOR = 1.4f;
    private ArrayList mBaseElementList = new ArrayList();
    private ArrayList mSubscriptElementList = new ArrayList();
    private ArrayList mSuperscriptElementList = new ArrayList();
    private float mAscent;
    private float mDescent;
    private float mLeading;
    private float mAdvance;
    private float mStrikethroughOffset;
    private Rectangle2D mStringRect = null;
    private Rectangle2D mElementBounds = null;
    private boolean mUpdateLocationRequired = true;

    public SGDrawingElementString2DExtended() {
        this.createStringElements();
    }

    public SGDrawingElementString2DExtended(String string) {
        super(string);
        this.createStringElements();
    }

    public SGDrawingElementString2DExtended(SGDrawingElementString sGDrawingElementString) {
        super(sGDrawingElementString);
        this.createStringElements();
    }

    public SGDrawingElementString2DExtended(String string, String string2, int n, float f, Color color, float f2, float f3) {
        super(string, string2, n, f, color, f2, f3);
        this.createStringElements();
    }

    public void dispose() {
        super.dispose();
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.dispose();
        }
        this.mBaseElementList.clear();
        this.mSuperscriptElementList.clear();
        this.mSubscriptElementList.clear();
        this.mBaseElementList = null;
        this.mSuperscriptElementList = null;
        this.mSubscriptElementList = null;
        this.mStringRect = null;
        this.mElementBounds = null;
    }

    private boolean containsSubscriptsOrSuperscripts() {
        String string = this.getString();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                bl = false;
                continue;
            }
            if (c == '\\') {
                bl = true;
            }
            if (c != '_' && c != '^') continue;
            return true;
        }
        return false;
    }

    protected final ArrayList getAllStringElement() {
        ArrayList arrayList = new ArrayList();
        if (this.mBaseElementList != null) {
            arrayList.addAll(this.mBaseElementList);
        }
        if (this.mSubscriptElementList != null) {
            arrayList.addAll(this.mSubscriptElementList);
        }
        if (this.mSuperscriptElementList != null) {
            arrayList.addAll(this.mSuperscriptElementList);
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Object e = arrayList.get(i);
            if (e != null) continue;
            arrayList.remove(i);
        }
        return arrayList;
    }

    public boolean setString(String string) {
        boolean bl = super.setString(string);
        this.createStringElements();
        this.mUpdateLocationRequired = true;
        return bl;
    }

    public boolean setMagnification(float f) {
        super.setMagnification(f);
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.setMagnification(f);
        }
        this.mUpdateLocationRequired = true;
        return true;
    }

    public boolean setColorList(List list) {
        super.setColorList(list);
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)arrayList.get(i);
            sGDrawingElementString.setColorList(list);
        }
        return true;
    }

    public boolean setColor(Color color) {
        super.setColor(color);
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)arrayList.get(i);
            sGDrawingElementString.setColor(color);
        }
        return true;
    }

    public boolean addColor(Color color) {
        super.addColor(color);
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)arrayList.get(i);
            sGDrawingElementString.addColor(color);
        }
        return true;
    }

    public boolean setFont(String string, int n, float f) {
        super.setFont(string, n, f);
        if (this.mBaseElementList == null) {
            return true;
        }
        Font font = new Font(string, n, (int)f);
        Font font2 = new Font(string, n, (int)(f / this.SCRIPT_FONTFACTOR));
        ArrayList arrayList = this.mBaseElementList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.setFont(font.getFamily(), font.getStyle(), font.getSize());
        }
        ArrayList arrayList2 = this.mSubscriptElementList;
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)arrayList2.get(i);
            if (sGDrawingElementString2DExtended == null) continue;
            sGDrawingElementString2DExtended.setFont(font2.getFamily(), font2.getStyle(), font2.getSize());
        }
        ArrayList arrayList3 = this.mSuperscriptElementList;
        for (int i = 0; i < arrayList3.size(); ++i) {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)arrayList3.get(i);
            if (sGDrawingElementString2DExtended == null) continue;
            sGDrawingElementString2DExtended.setFont(font2.getFamily(), font2.getStyle(), font2.getSize());
        }
        this.mUpdateLocationRequired = true;
        return true;
    }

    public boolean setX(float f) {
        super.setX(f);
        this.mUpdateLocationRequired = true;
        return true;
    }

    public boolean setY(float f) {
        super.setY(f);
        this.mUpdateLocationRequired = true;
        return true;
    }

    public boolean setAngle(float f) {
        if (!super.setAngle(f)) {
            return false;
        }
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.setAngle(f);
        }
        this.mUpdateLocationRequired = true;
        return true;
    }

    private boolean createStringElementsDirectly() {
        SGDrawingElementString2D sGDrawingElementString2D = new SGDrawingElementString2D(SGUtilityText.unescapeString(this.getString()), this.getFontName(), this.getFontStyle(), this.getFontSize(), this.getColor(0), this.getMagnification(), this.getAngle());
        this.mBaseElementList.add(sGDrawingElementString2D);
        this.mSubscriptElementList.add(null);
        this.mSuperscriptElementList.add(null);
        return true;
    }

    private boolean createStringElements() {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        String string = this.getFontName();
        int n = this.getFontStyle();
        float f = this.getFontSize();
        Color color = this.getColor(0);
        float f2 = this.getMagnification();
        float f3 = this.getAngle();
        float f4 = f / this.SCRIPT_FONTFACTOR;
        this.mBaseElementList.clear();
        this.mSubscriptElementList.clear();
        this.mSuperscriptElementList.clear();
        if (!this.containsSubscriptsOrSuperscripts()) {
            return this.createStringElementsDirectly();
        }
        String string2 = this.getString();
        if (!SGUtilityText.getSubscriptAndSuperscriptInfo(string2, arrayList3 = new ArrayList(), arrayList2 = new ArrayList(), arrayList = new ArrayList())) {
            return this.createStringElementsDirectly();
        }
        for (int i = 0; i < arrayList3.size(); ++i) {
            Object object;
            String string3 = (String)arrayList3.get(i);
            Object object2 = new SGDrawingElementString2D(string3, string, n, f, color, f2, f3);
            this.mBaseElementList.add(object2);
            string3 = arrayList.get(i);
            if (string3 != null) {
                object2 = string3;
                object = new SGDrawingElementString2DExtended((String)object2, string, n, f4, color, f2, f3);
                this.mSubscriptElementList.add(object);
            } else {
                this.mSubscriptElementList.add(null);
            }
            object2 = arrayList2.get(i);
            if (object2 != null) {
                object = (String)object2;
                SGDrawingElementString2DExtended sGDrawingElementString2DExtended = new SGDrawingElementString2DExtended((String)object, string, n, f4, color, f2, f3);
                this.mSuperscriptElementList.add(sGDrawingElementString2DExtended);
                continue;
            }
            this.mSuperscriptElementList.add(null);
        }
        return true;
    }

    protected float getAscent() {
        if (this.mUpdateLocationRequired) {
            this.updateLocation();
        }
        return this.mAscent;
    }

    protected float getDescent() {
        if (this.mUpdateLocationRequired) {
            this.updateLocation();
        }
        return this.mDescent;
    }

    protected float getLeading() {
        if (this.mUpdateLocationRequired) {
            this.updateLocation();
        }
        return this.mLeading;
    }

    protected float getAdvance() {
        if (this.mUpdateLocationRequired) {
            this.updateLocation();
        }
        return this.mAdvance;
    }

    protected float getStrikethroughOffset() {
        if (this.mUpdateLocationRequired) {
            this.updateLocation();
        }
        return this.mStrikethroughOffset;
    }

    public Rectangle2D getStringRect() {
        if (this.mUpdateLocationRequired) {
            this.updateLocation();
        }
        return (Rectangle2D)this.mStringRect.clone();
    }

    public Rectangle2D getElementBounds() {
        if (this.mUpdateLocationRequired) {
            this.updateLocation();
        }
        return (Rectangle2D)this.mElementBounds.clone();
    }

    public void requestUpdateLocation() {
        this.mUpdateLocationRequired = true;
    }

    public void paintElement(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.mUpdateLocationRequired) {
            this.updateLocation();
        }
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.paintElement(graphics2D);
        }
    }

    private boolean updateLocation() {
        this.calcMetrics();
        float f = this.getAngle();
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        float f4 = this.getX();
        float f5 = this.getY();
        float f6 = (float)(-this.mStringRect.getY());
        float f7 = f6 + this.mStrikethroughOffset;
        float f8 = this.mLeading / 2.0f;
        float f9 = f7 - f8;
        float f10 = f7 + f8;
        ArrayList arrayList = this.mBaseElementList;
        ArrayList arrayList2 = this.mSubscriptElementList;
        ArrayList arrayList3 = this.mSuperscriptElementList;
        float f11 = 0.0f;
        for (int i = 0; i < arrayList.size(); ++i) {
            float f12;
            float f13;
            float f14 = 0.0f;
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            float f15 = (float)sGDrawingElementString2D.getStringRect().getHeight();
            float f16 = f11;
            float f17 = f6 - f15;
            float f18 = f4 + f16 * f2 + f17 * f3;
            float f19 = f5 - f16 * f3 + f17 * f2;
            sGDrawingElementString2D.setLocation(f18, f19);
            f14 = sGDrawingElementString2D.getAdvance();
            float f20 = 0.0f;
            Object e = arrayList3.get(i);
            if (e != null) {
                SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)e;
                f17 = (float)sGDrawingElementString2DExtended.getStringRect().getHeight();
                f18 = f11 + f14;
                f19 = f9 - f17;
                f13 = f4 + f18 * f2 + f19 * f3;
                f12 = f5 - f18 * f3 + f19 * f2;
                sGDrawingElementString2DExtended.setLocation(f13, f12);
                f20 = sGDrawingElementString2DExtended.getAdvance();
            }
            f15 = 0.0f;
            Object e2 = arrayList2.get(i);
            if (e2 != null) {
                SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)e2;
                f18 = f11 + f14;
                f19 = f10;
                f13 = f4 + f18 * f2 + f19 * f3;
                f12 = f5 - f18 * f3 + f19 * f2;
                sGDrawingElementString2DExtended.setLocation(f13, f12);
                f15 = sGDrawingElementString2DExtended.getAdvance();
            }
            f11 += f14 + (f20 > f15 ? f20 : f15);
        }
        this.calcElementBounds();
        this.mUpdateLocationRequired = false;
        return true;
    }

    private void calcMetrics() {
        float f;
        float f2;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        float f17 = 0.0f;
        float f18 = 0.0f;
        ArrayList arrayList = this.mBaseElementList;
        ArrayList arrayList2 = this.mSuperscriptElementList;
        ArrayList arrayList3 = this.mSubscriptElementList;
        if (arrayList.size() != 0) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(0);
            f4 = sGDrawingElementString2D.getStrikethroughOffset();
            f5 = sGDrawingElementString2D.getLeading();
            f3 = (float)sGDrawingElementString2D.getStringRect().getX();
        }
        f17 = f5;
        f16 = f4;
        for (int i = 0; i < arrayList.size(); ++i) {
            float f19;
            f2 = 0.0f;
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            float f20 = -((float)sGDrawingElementString2D.getStringRect().getY());
            if (f20 > f6) {
                f6 = f20;
            }
            if ((f19 = (float)sGDrawingElementString2D.getStringRect().getHeight() - f20) > f7) {
                f7 = f19;
            }
            f2 = sGDrawingElementString2D.getAdvance();
            f = 0.0f;
            Object e = arrayList2.get(i);
            if (e != null) {
                SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)e;
                float f21 = (float)sGDrawingElementString2DExtended.getStringRect().getHeight();
                if (f21 > f8) {
                    f8 = f21;
                }
                f = sGDrawingElementString2DExtended.getAdvance();
            }
            f20 = 0.0f;
            Object e2 = arrayList3.get(i);
            if (e2 != null) {
                SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)e2;
                float f22 = (float)sGDrawingElementString2DExtended.getStringRect().getHeight();
                if (f22 > f9) {
                    f9 = f22;
                }
                f20 = sGDrawingElementString2DExtended.getAdvance();
            }
            f18 += f2 + (f > f20 ? f : f20);
        }
        float f23 = f5 / 2.0f;
        f = f8 + f23;
        f2 = f6 + f4;
        f12 = f > f2 ? f - f4 : f2 - f4;
        f2 = f7 - f4;
        f = f9 + f23;
        f13 = f > f2 ? f + f4 : f2 + f4;
        f14 = f12 + f13;
        f10 = f3;
        f11 = -f12;
        f15 = f18 - f10;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f10, f11, f15, f14);
        this.mStrikethroughOffset = f16;
        this.mLeading = f5;
        this.mAscent = f12;
        this.mDescent = f13;
        this.mAdvance = f18;
        this.mStringRect = float_;
    }

    private void calcElementBounds() {
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        ArrayList arrayList2 = this.getAllStringElement();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList2.get(i);
            arrayList.add(sGDrawingElementString2D.getElementBounds());
        }
        this.mElementBounds = SGUtility.createUnion(arrayList);
    }
}

