/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;

public class SGDrawingElementArrow2D
extends SGDrawingElementArrow
implements SGIDrawingElementJava2D {
    protected SGDrawingElementLine createBodyInstance() {
        return new ArrowBody();
    }

    protected SGDrawingElementSymbol createHeadInstance() {
        return new ArrowHead();
    }

    public Rectangle2D getElementBounds() {
        SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)this.getLine();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.getStartHead();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D2 = (SGDrawingElementSymbol2D)this.getEndHead();
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        arrayList.add(sGDrawingElementLine2D.getElementBounds());
        arrayList.add(sGDrawingElementSymbol2D.getElementBounds());
        arrayList.add(sGDrawingElementSymbol2D2.getElementBounds());
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        return rectangle2D;
    }

    public void paintElement(Graphics2D graphics2D) {
        if (!this.isVisible()) {
            return;
        }
        SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)this.getLine();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.getStartHead();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D2 = (SGDrawingElementSymbol2D)this.getEndHead();
        sGDrawingElementLine2D.paintElement(graphics2D);
        sGDrawingElementSymbol2D.paintElement(graphics2D);
        sGDrawingElementSymbol2D2.paintElement(graphics2D);
    }

    public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (!this.isVisible()) {
            return;
        }
        SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)this.getLine();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.getStartHead();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D2 = (SGDrawingElementSymbol2D)this.getEndHead();
        sGDrawingElementLine2D.paint(graphics2D, rectangle2D);
        sGDrawingElementSymbol2D.paint(graphics2D, rectangle2D);
        sGDrawingElementSymbol2D2.paint(graphics2D, rectangle2D);
    }

    public float getMagnitude() {
        SGTuple2f sGTuple2f = this.getStart();
        SGTuple2f sGTuple2f2 = this.getEnd();
        float f = sGTuple2f.x - sGTuple2f2.x;
        float f2 = sGTuple2f.y - sGTuple2f2.y;
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public boolean setStartX(float f) {
        super.setStartX(f);
        this.updateHeadAngle();
        return true;
    }

    public boolean setStartY(float f) {
        super.setStartY(f);
        this.updateHeadAngle();
        return true;
    }

    public boolean setEndX(float f) {
        super.setEndX(f);
        this.updateHeadAngle();
        return true;
    }

    public boolean setEndY(float f) {
        super.setEndY(f);
        this.updateHeadAngle();
        return true;
    }

    public boolean setTermPoints(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        super.setTermPoints(sGTuple2f, sGTuple2f2);
        this.updateHeadAngle();
        return true;
    }

    private void updateHeadAngle() {
        SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)this.getLine();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.getStartHead();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D2 = (SGDrawingElementSymbol2D)this.getEndHead();
        float f = sGDrawingElementLine2D.getAngle();
        sGDrawingElementSymbol2D.setAngle(f - 1.5707964f);
        sGDrawingElementSymbol2D2.setAngle(f + 1.5707964f);
    }

    private float getOpenAngleTangent() {
        return (float)Math.tan(this.getHeadOpenAngle());
    }

    private float getCloseAngleTangent() {
        return (float)Math.tan(this.getHeadCloseAngle());
    }

    private class ArrowHead
    extends SGDrawingElementSymbol2D {
        private ArrowHead() {
        }

        protected void paintLine(Graphics2D graphics2D, Shape shape) {
            if (ArrowHead.isLineTypeSymbol(this.getType())) {
                super.paintLine(graphics2D, shape);
            }
        }

        protected void paintLine(Graphics2D graphics2D, Area area, Shape shape) {
            if (ArrowHead.isLineTypeSymbol(this.getType())) {
                super.paintLine(graphics2D, area, shape);
            }
        }

        public Shape getSymbolShape() {
            if (this.getType() == -1) {
                return null;
            }
            Shape shape = null;
            int n = this.getType();
            if (n == 10) {
                float f = SGDrawingElementArrow2D.this.getHeadOpenAngle();
                float f2 = SGDrawingElementArrow2D.this.getHeadCloseAngle();
                if (f2 <= f) {
                    return null;
                }
                float f3 = (float)Math.tan(f);
                float f4 = (float)Math.tan(f2);
                float f5 = this.getX();
                float f6 = this.getY();
                float f7 = this.getMagnification();
                float f8 = f7 * this.getSize();
                float f9 = f8 * f3;
                Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f5, f6), new Point2D.Float(f5 + f9, f6 + f8), new Point2D.Float(f5, f6 + f8 - f9 / f4), new Point2D.Float(f5 - f9, f6 + f8)};
                Line2D[] line2DArray = new Line2D[point2DArray.length];
                for (int i = 0; i < line2DArray.length; ++i) {
                    line2DArray[i] = new Line2D.Float(point2DArray[i], point2DArray[(i + 1) % point2DArray.length]);
                }
                GeneralPath generalPath = new GeneralPath();
                for (int i = 0; i < line2DArray.length; ++i) {
                    generalPath.append(line2DArray[i], true);
                }
                shape = this.getAffineTransform().createTransformedShape(generalPath);
            } else {
                shape = super.getSymbolShape();
            }
            return shape;
        }
    }

    private class ArrowBody
    extends SGDrawingElementLine2D {
        private ArrowBody() {
        }

        public Shape getLineShape() {
            float f = SGDrawingElementArrow2D.this.getHeadOpenAngle();
            float f2 = SGDrawingElementArrow2D.this.getHeadCloseAngle();
            float f3 = (float)Math.tan(f);
            float f4 = (float)Math.tan(f2);
            float f5 = f <= f2 ? this.getMagnification() * SGDrawingElementArrow2D.this.getHeadSize() * (1.0f - f3 / f4) : 0.0f;
            float f6 = this.getMagnitude();
            float f7 = SGDrawingElementArrow2D.this.getStartHeadType() != 10 ? 0.0f : 0.5f * f5;
            float f8 = SGDrawingElementArrow2D.this.getEndHeadType() != 10 ? f6 : f6 - 0.5f * f5;
            Line2D.Float float_ = new Line2D.Float(0.0f, f7, 0.0f, f8);
            Shape shape = this.getAffineTransform().createTransformedShape(float_);
            return shape;
        }

        private AffineTransform getAffineTransform() {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(this.getStart().x, this.getStart().y);
            double d = (double)this.getAngle() - 1.5707963267948966;
            affineTransform.rotate(d);
            return affineTransform;
        }
    }
}

