/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIZoomable;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public class SGZoomComboBox
extends JComboBox
implements SGIRootObjectConstants {
    private static final String PERCENT = "%";
    private float mMagnification = 100.0f;
    private boolean mExternalFlag = false;
    private final ArrayList mZoomableList = new ArrayList();

    public SGZoomComboBox() {
        this.init();
    }

    private void init() {
        Dimension dimension;
        String[] stringArray = SGIRootObjectConstants.MAGNIFICATION_STRING_ARRAY;
        for (int i = 0; i < stringArray.length; ++i) {
            this.addItem(stringArray[i] + PERCENT);
        }
        this.addItem("Auto");
        this.setEditable(true);
        this.setToolTipText("Zoom");
        this.setFont(new Font("Dialog", 1, 12));
        String string = SGUtility.getLookAndFeelID();
        if (!"Aqua".equals(string) & !"Windows".equals(string)) {
            dimension = new Dimension(120, 25);
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        } else {
            dimension = new Dimension(120, 22);
        }
        this.setPreferredSize(dimension);
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        this.addActionListener(this);
        this.setText(new Integer(100));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this) && !this.mExternalFlag) {
            String string = (String)this.getSelectedItem();
            boolean bl = string.equals("Auto");
            this.setAutoZoom(bl);
            if (!bl) {
                this.onZoomed();
            }
        }
    }

    private void setAutoZoom(boolean bl) {
        ArrayList arrayList = this.mZoomableList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIZoomable sGIZoomable = (SGIZoomable)arrayList.get(i);
            sGIZoomable.setAutoZoom(bl);
        }
    }

    public void setZoomValue(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("num==null");
        }
        this.mExternalFlag = true;
        this.setText(number);
        this.mExternalFlag = false;
    }

    private void onZoomed() {
        float f;
        String string = (String)this.getSelectedItem();
        Integer n = new Integer((int)(this.mMagnification * 100.0f));
        Number number = SGUtilityText.getFloat(string);
        if (number == null && (number = this.parse(string)) == null) {
            number = n;
        }
        Integer n2 = (double)(f = ((Number)number).floatValue()) < 0.0 ? n : (f < 10.0f ? new Integer(10) : (f > 400.0f ? new Integer(400) : new Integer((int)f)));
        this.setText(n2);
        this.mMagnification = ((Number)n2).floatValue() / 100.0f;
        this.zoom(this.mMagnification);
    }

    private Float parse(String string) {
        Float f = null;
        if (string.endsWith(PERCENT)) {
            ArrayList arrayList;
            String string2 = string.substring(0, string.length() - 1);
            if (!SGUtilityText.tokenize(string2, arrayList = new ArrayList(), false)) {
                return null;
            }
            if (arrayList.size() != 1) {
                return null;
            }
            String string3 = (String)arrayList.get(0);
            f = SGUtilityText.getFloat(string3);
        }
        return f;
    }

    private void setText(Number number) {
        String string = number.toString();
        string = string + PERCENT;
        this.setSelectedItem(string);
    }

    public void addZoomable(SGIZoomable sGIZoomable) {
        this.mZoomableList.add(sGIZoomable);
    }

    public void removeZoomable(SGIZoomable sGIZoomable) {
        this.mZoomableList.remove(sGIZoomable);
    }

    private void zoom(float f) {
        ArrayList arrayList = this.mZoomableList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIZoomable sGIZoomable = (SGIZoomable)arrayList.get(i);
            sGIZoomable.zoom(f);
        }
    }
}

