/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import jp.riken.brain.ni.samuraigraph.base.SGAxisSelectionPanel;
import jp.riken.brain.ni.samuraigraph.base.SGExclusiveAccessController;
import jp.riken.brain.ni.samuraigraph.base.SGISingleAxisHolder;

public class SGSingleAxisSelectionPanel
extends SGAxisSelectionPanel {
    private JToggleButton mNoAxisSelectionButton = new JToggleButton();
    private SGExclusiveAccessController mController = new SGExclusiveAccessController();

    public SGSingleAxisSelectionPanel() {
        this.initProperty();
    }

    private void initProperty() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mTopButton);
        buttonGroup.add(this.mBottomButton);
        buttonGroup.add(this.mLeftButton);
        buttonGroup.add(this.mRightButton);
        buttonGroup.add(this.mNoAxisSelectionButton);
        this.mController.add(this.mTopLine);
        this.mController.add(this.mBottomLine);
        this.mController.add(this.mLeftLine);
        this.mController.add(this.mRightLine);
    }

    protected void updateImage() {
        this.mAxisImagePanel.setTopSelected(this.isTopSelected());
        this.mAxisImagePanel.setBottomSelected(this.isBottomSelected());
        this.mAxisImagePanel.setLeftSelected(this.isLeftSelected());
        this.mAxisImagePanel.setRightSelected(this.isRightSelected());
        this.repaint();
    }

    protected void updateButtons() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4 = this.isTopSelected();
        if (bl4 | (bl3 = this.isBottomSelected()) | (bl2 = this.isLeftSelected()) | (bl = this.isRightSelected())) {
            this.mTopButton.setSelected(bl4);
            this.mBottomButton.setSelected(bl3);
            this.mLeftButton.setSelected(bl2);
            this.mRightButton.setSelected(bl);
        } else {
            this.mNoAxisSelectionButton.setSelected(true);
        }
    }

    public int getAxisConfiguration() {
        int n = -1;
        if (!this.mNoAxisSelectionButton.isSelected()) {
            if (this.isTopSelected()) {
                n = 1;
            } else if (this.isBottomSelected()) {
                n = 0;
            } else if (this.isLeftSelected()) {
                n = 2;
            } else if (this.isRightSelected()) {
                n = 3;
            }
        }
        return n;
    }

    public boolean setSelected(List list) {
        Object object;
        int n = list.size();
        if (n == 0) {
            return false;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            object = (SGISingleAxisHolder)list.get(i);
            arrayList.add(new Integer(object.getAxisLocation()));
        }
        Integer n2 = (Integer)arrayList.get(0);
        object = n2;
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                Integer n3 = (Integer)arrayList.get(i);
                if (n2.equals(n3)) continue;
                object = null;
                break;
            }
        }
        this.clearAll();
        if (object != null) {
            this.setSelected((Integer)object);
        }
        this.updateButtons();
        this.updateImage();
        return true;
    }

    private boolean setSelected(int n) {
        switch (n) {
            case 0: {
                this.setBottomSelected(true);
                break;
            }
            case 1: {
                this.setTopSelected(true);
                break;
            }
            case 2: {
                this.setLeftSelected(true);
                break;
            }
            case 3: {
                this.setRightSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        return true;
    }

    protected void selectLine(SGAxisSelectionPanel.Line line) {
        this.mController.select(line);
    }
}

