/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroup;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroupElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGILegendConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGILegendDialogObserver;

public class SGLegendDialog
extends SGPropertyDialog
implements SGILegendConstants,
SGIDrawingElementConstants {
    public static final String TITLE = "Legend Properties";
    private SGTwoAxesSelectionPanel mAxisPanel;
    private SGColorSelectionButton mBackgroundColorButton;
    private JLabel mBackgroundColorLabel;
    private JLabel mBackgroundLabel;
    private JSeparator mBackgroundSeparator;
    private SGCheckBox mBackgroundTransparentCheckBox;
    private JButton mCancelButton;
    private JSeparator mDataSeparator;
    private JLabel mFontFamilyLabel;
    private JComboBox mFontNameComboBox;
    private JLabel mFontSizeLabel;
    private SGSpinner mFontSizeSpinner;
    private JComboBox mFontStyleComboBox;
    private JLabel mFontStyleLabel;
    private JLabel mFrameLabel;
    private SGColorSelectionButton mFrameLineColorButton;
    private JLabel mFrameLineColorLabel;
    private JLabel mFrameLineWidthLabel;
    private SGSpinner mFrameLineWidthSpinner;
    private JSeparator mFrameSeparator;
    private SGCheckBox mFrameVisibleCheckBox;
    private JLabel mLabelSpace1;
    private JLabel mLeftSpaceLabel;
    private JPanel mLegendPanel;
    private SGCheckBox mLegendVisibleCheckBox;
    private JLabel mLocationLabel;
    private JSeparator mLocationSeparator;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JLabel mSpanLabel;
    private SGSpinner mSpanSpinner;
    private SGColorSelectionButton mStringColorButton;
    private JLabel mStringColorLabel;
    private JLabel mStringLabel;
    private JSeparator mStringSeparator;
    private JLabel mSymbolLabel;
    private JLabel mXValueLabel;
    private SGTextField mXValueTextField;
    private JLabel mYValueLabel;
    private SGTextField mYValueTextField;
    private JPanel mlButtonPanel;
    public static final double SYMBOL_SPAN_STEP = 0.1;
    private SGComponentGroup mVisibleComponentGroup = new SGComponentGroup();
    private SGComponentGroup mFrameVisibleComponentGroup = new SGComponentGroup();
    private SGComponentGroup mBackgroundComponentGroup = new SGComponentGroup();

    public SGLegendDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mLabelSpace1 = new JLabel();
        this.mLegendPanel = new JPanel();
        this.mLegendVisibleCheckBox = new SGCheckBox();
        this.mFrameVisibleCheckBox = new SGCheckBox();
        this.mFrameLabel = new JLabel();
        this.mFrameLineWidthLabel = new JLabel();
        this.mFrameLineColorLabel = new JLabel();
        this.mBackgroundColorLabel = new JLabel();
        this.mFrameLineWidthSpinner = new SGSpinner();
        this.mFrameLineColorButton = new SGColorSelectionButton();
        this.mFrameSeparator = new JSeparator();
        this.mBackgroundColorButton = new SGColorSelectionButton();
        this.mFontFamilyLabel = new JLabel();
        this.mFontSizeLabel = new JLabel();
        this.mStringColorLabel = new JLabel();
        this.mFontNameComboBox = new JComboBox();
        this.mFontSizeSpinner = new SGSpinner();
        this.mFontStyleComboBox = new JComboBox();
        this.mStringColorButton = new SGColorSelectionButton();
        this.mStringLabel = new JLabel();
        this.mStringSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mBackgroundLabel = new JLabel();
        this.mBackgroundTransparentCheckBox = new SGCheckBox();
        this.mLocationLabel = new JLabel();
        this.mBackgroundSeparator = new JSeparator();
        this.mXValueLabel = new JLabel();
        this.mXValueTextField = new SGTextField();
        this.mYValueLabel = new JLabel();
        this.mYValueTextField = new SGTextField();
        this.mFontStyleLabel = new JLabel();
        this.mLocationSeparator = new JSeparator();
        this.mSpanSpinner = new SGSpinner();
        this.mSpanLabel = new JLabel();
        this.mSymbolLabel = new JLabel();
        this.mDataSeparator = new JSeparator();
        this.mlButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mAxisPanel = new SGTwoAxesSelectionPanel();
        this.mLabelSpace1.setText("  ");
        this.getContentPane().setLayout(new GridBagLayout());
        this.mLegendPanel.setLayout(new GridBagLayout());
        this.mLegendPanel.setBorder(new BevelBorder(0));
        this.mLegendPanel.setFont(new Font("MS Sans Serif", 0, 12));
        this.mLegendVisibleCheckBox.setText("Visible");
        this.mLegendVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLegendPanel.add((Component)this.mLegendVisibleCheckBox, gridBagConstraints);
        this.mFrameVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mFrameVisibleCheckBox.setText("Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        this.mLegendPanel.add((Component)this.mFrameVisibleCheckBox, gridBagConstraints);
        this.mFrameLabel.setFont(new Font("Dialog", 3, 12));
        this.mFrameLabel.setText("Frame");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFrameLabel, gridBagConstraints);
        this.mFrameLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineWidthLabel, gridBagConstraints);
        this.mFrameLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineColorLabel, gridBagConstraints);
        this.mBackgroundColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mBackgroundColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mLegendPanel.add((Component)this.mBackgroundColorLabel, gridBagConstraints);
        this.mFrameLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineWidthSpinner, gridBagConstraints);
        this.mFrameLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mLegendPanel.add((Component)this.mFrameLineColorButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 50, 5, 5);
        this.mLegendPanel.add((Component)this.mFrameSeparator, gridBagConstraints);
        this.mBackgroundColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mLegendPanel.add((Component)this.mBackgroundColorButton, gridBagConstraints);
        this.mFontFamilyLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontFamilyLabel.setText("Family");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLegendPanel.add((Component)this.mFontFamilyLabel, gridBagConstraints);
        this.mFontSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLegendPanel.add((Component)this.mFontSizeLabel, gridBagConstraints);
        this.mStringColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mStringColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mLegendPanel.add((Component)this.mStringColorLabel, gridBagConstraints);
        this.mFontNameComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFontNameComboBox, gridBagConstraints);
        this.mFontSizeSpinner.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeSpinner.setMinimumSize(new Dimension(25, 20));
        this.mFontSizeSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFontSizeSpinner, gridBagConstraints);
        this.mFontStyleComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mFontStyleComboBox, gridBagConstraints);
        this.mStringColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mStringColorButton, gridBagConstraints);
        this.mStringLabel.setFont(new Font("Dialog", 3, 12));
        this.mStringLabel.setText("String");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mStringLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 45, 5, 5);
        this.mLegendPanel.add((Component)this.mStringSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mLegendPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        this.mLegendPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mBackgroundLabel.setFont(new Font("Dialog", 3, 12));
        this.mBackgroundLabel.setText("Background");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mBackgroundLabel, gridBagConstraints);
        this.mBackgroundTransparentCheckBox.setText("Transparency");
        this.mBackgroundTransparentCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mLegendPanel.add((Component)this.mBackgroundTransparentCheckBox, gridBagConstraints);
        this.mLocationLabel.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        this.mLegendPanel.add((Component)this.mBackgroundSeparator, gridBagConstraints);
        this.mXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mXValueLabel.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mXValueLabel, gridBagConstraints);
        this.mXValueTextField.setColumns(6);
        this.mXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mXValueTextField, gridBagConstraints);
        this.mYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mYValueLabel.setText("Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mYValueLabel, gridBagConstraints);
        this.mYValueTextField.setColumns(6);
        this.mYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mLegendPanel.add((Component)this.mYValueTextField, gridBagConstraints);
        this.mFontStyleLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontStyleLabel.setText("Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mLegendPanel.add((Component)this.mFontStyleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.mLegendPanel.add((Component)this.mLocationSeparator, gridBagConstraints);
        this.mSpanSpinner.setFont(new Font("Dialog", 0, 12));
        this.mSpanSpinner.setMinimumSize(new Dimension(25, 20));
        this.mSpanSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mLegendPanel.add((Component)this.mSpanSpinner, gridBagConstraints);
        this.mSpanLabel.setFont(new Font("Dialog", 0, 12));
        this.mSpanLabel.setText("Span");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mLegendPanel.add((Component)this.mSpanLabel, gridBagConstraints);
        this.mSymbolLabel.setFont(new Font("Dialog", 3, 12));
        this.mSymbolLabel.setText("Symbol ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.mLegendPanel.add((Component)this.mSymbolLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 60, 5, 5);
        gridBagConstraints.anchor = 13;
        this.mLegendPanel.add((Component)this.mDataSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mLegendPanel, gridBagConstraints);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mlButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mlButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mlButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mlButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mAxisPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        String[] stringArray = SGUtility.getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mFontNameComboBox.addItem(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.mFontStyleComboBox.addItem(stringArray2[i]);
        }
        this.pack();
        this.mFrameLineWidthSpinner.initProperties(SGLegendDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mFontSizeSpinner.initProperties(SGLegendDialog.getFontSizeSpinnerNumberModel(), "pt", 1, 2);
        this.mSpanSpinner.initProperties(new SpinnerNumberModel(1.0, 0.5, 6.0, 0.1), "cm", 1, 2);
        this.mLegendVisibleCheckBox.addActionListener(this);
        this.mFrameVisibleCheckBox.addActionListener(this);
        this.mBackgroundTransparentCheckBox.addActionListener(this);
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
        this.mFocusedColorSetButton = this.mFrameLineColorButton;
        this.mXValueTextField.setDescription("Location-> X");
        this.mYValueTextField.setDescription("Location-> Y");
        this.mFrameLineWidthSpinner.setDescription("Frame-> Width");
        this.mFontSizeSpinner.setDescription("String-> Size");
        this.mSpanSpinner.setDescription("Data-> Width");
        SGComponentGroupElement[] sGComponentGroupElementArray = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mFrameLineWidthLabel), new SGComponentGroupElement(this.mFrameLineWidthSpinner), new SGComponentGroupElement(this.mFrameLineColorLabel), new SGComponentGroupElement(this.mFrameLineColorButton)};
        SGComponentGroupElement[] sGComponentGroupElementArray2 = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mBackgroundColorLabel), new SGComponentGroupElement(this.mBackgroundColorButton)};
        SGComponentGroupElement[] sGComponentGroupElementArray3 = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mSpanLabel), new SGComponentGroupElement(this.mSpanSpinner)};
        SGComponentGroupElement[] sGComponentGroupElementArray4 = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mLocationLabel), new SGComponentGroupElement(this.mXValueLabel), new SGComponentGroupElement(this.mXValueTextField), new SGComponentGroupElement(this.mYValueLabel), new SGComponentGroupElement(this.mYValueTextField), new SGComponentGroupElement(this.mStringLabel), new SGComponentGroupElement(this.mFontFamilyLabel), new SGComponentGroupElement(this.mFontStyleLabel), new SGComponentGroupElement(this.mFontNameComboBox), new SGComponentGroupElement(this.mFontStyleComboBox), new SGComponentGroupElement(this.mFontSizeLabel), new SGComponentGroupElement(this.mFontSizeSpinner), new SGComponentGroupElement(this.mStringColorLabel), new SGComponentGroupElement(this.mStringColorButton), new SGComponentGroupElement(this.mFrameLabel), new SGComponentGroupElement(this.mFrameVisibleCheckBox), sGComponentGroupElementArray[0], sGComponentGroupElementArray[1], sGComponentGroupElementArray[2], sGComponentGroupElementArray[3], new SGComponentGroupElement(this.mBackgroundLabel), new SGComponentGroupElement(this.mBackgroundTransparentCheckBox), sGComponentGroupElementArray2[0], sGComponentGroupElementArray2[1], new SGComponentGroupElement(this.mSpanLabel), sGComponentGroupElementArray3[0], sGComponentGroupElementArray3[1]};
        this.mVisibleComponentGroup.addElement(sGComponentGroupElementArray4);
        this.mFrameVisibleComponentGroup.addElement(sGComponentGroupElementArray);
        this.mBackgroundComponentGroup.addElement(sGComponentGroupElementArray2);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mLegendVisibleCheckBox)) {
            this.setLegendVisible(this.mLegendVisibleCheckBox.getSelected());
        } else if (object.equals(this.mFrameVisibleCheckBox)) {
            this.setFrameComponentsEnabled(this.mFrameVisibleCheckBox.getSelected());
        } else if (object.equals(this.mBackgroundTransparentCheckBox)) {
            this.setBackgroundComponentsEnabled(this.mBackgroundTransparentCheckBox.getSelected());
        }
    }

    private boolean setAllLegendComponentsEnabled(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.mVisibleComponentGroup.setEnabled(bl2);
        return true;
    }

    private boolean setFrameComponentsEnabled(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.setFrameComponentsEnabled(bl2);
        return true;
    }

    private boolean setFrameComponentsEnabled(boolean bl) {
        this.mFrameVisibleComponentGroup.setEnabled(bl);
        return true;
    }

    private boolean setBackgroundComponentsEnabled(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl == false;
        }
        this.setBackgroundComponentsEnabled(bl2);
        return true;
    }

    private boolean setBackgroundComponentsEnabled(boolean bl) {
        this.mBackgroundComponentGroup.setEnabled(bl);
        return true;
    }

    public Number getXValue() {
        return this.getNumber(this.mXValueTextField);
    }

    public Number getYValue() {
        return this.getNumber(this.mYValueTextField);
    }

    public Boolean getLegendVisible() {
        return this.mLegendVisibleCheckBox.getSelected();
    }

    public Boolean getFrameVisible() {
        return this.mFrameVisibleCheckBox.getSelected();
    }

    public Number getFrameLineWidth() {
        return this.mFrameLineWidthSpinner.getNumber();
    }

    public Color getFrameLineColor() {
        return this.mFrameLineColorButton.getColor();
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColorButton.getColor();
    }

    public Number getFontSize() {
        return this.mFontSizeSpinner.getNumber();
    }

    public String getFontName() {
        return (String)this.mFontNameComboBox.getSelectedItem();
    }

    public int getFontStyle() {
        String string = (String)this.mFontStyleComboBox.getSelectedItem();
        return SGUtilityText.getFontStyle(string);
    }

    public Color getTextColor() {
        return this.mStringColorButton.getColor();
    }

    public Boolean isLegendTransparent() {
        return this.mBackgroundTransparentCheckBox.getSelected();
    }

    public Number getSymbolSpan() {
        return this.mSpanSpinner.getNumber();
    }

    public boolean setXValue(Object object) {
        return this.setValue(this.mXValueTextField, object);
    }

    public boolean setYValue(Object object) {
        return this.setValue(this.mYValueTextField, object);
    }

    public void setLegendVisible(Boolean bl) {
        this.mLegendVisibleCheckBox.setSelected(bl);
        this.setAllLegendComponentsEnabled(bl);
    }

    public void setFrameVisible(Boolean bl) {
        this.mFrameVisibleCheckBox.setSelected(bl);
        this.setFrameComponentsEnabled(bl);
    }

    public boolean setFrameLineWidth(Object object) {
        return this.setValue(this.mFrameLineWidthSpinner, object);
    }

    public void setFrameLineColor(Color color) {
        this.mFrameLineColorButton.setColor(color);
    }

    public void setBackgroundColor(Color color) {
        this.mBackgroundColorButton.setColor(color);
    }

    public boolean setFontSize(Object object) {
        return this.setValue(this.mFontSizeSpinner, object);
    }

    public void setFontName(String string) {
        this.mFontNameComboBox.setSelectedItem(string);
    }

    public boolean setFontStyle(Integer n) {
        String string = null;
        if (n != null) {
            string = SGUtilityText.getFontStyleName(n);
        }
        this.mFontStyleComboBox.setSelectedItem(string);
        return true;
    }

    public void setTextColor(Color color) {
        this.mStringColorButton.setColor(color);
    }

    public void setLegendTransparent(Boolean bl) {
        this.mBackgroundTransparentCheckBox.setSelected(bl);
        this.setBackgroundComponentsEnabled(bl);
    }

    public boolean setSymbolSpan(Object object) {
        return this.setValue(this.mSpanSpinner, object);
    }

    public List getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mBackgroundColorButton);
        arrayList.add(this.mFrameLineColorButton);
        arrayList.add(this.mStringColorButton);
        return arrayList;
    }

    public List getTextFieldComponentsList() {
        List list = this.getFormattedTextFieldsListFromSpinners();
        list.addAll(this.getNumberTextFieldList());
        return list;
    }

    public List getNumberTextFieldList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.add(this.mXValueTextField);
        arrayList.add(this.mYValueTextField);
        return arrayList;
    }

    public List getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mFontSizeSpinner);
        arrayList.add(this.mFrameLineWidthSpinner);
        arrayList.add(this.mSpanSpinner);
        return arrayList;
    }

    public boolean setDialogProperty() {
        SGLegendDialog sGLegendDialog = this;
        List list = this.mPropertyDialogObserverList;
        if (!this.mAxisPanel.setSelected(list)) {
            return false;
        }
        SGILegendDialogObserver sGILegendDialogObserver = (SGILegendDialogObserver)list.get(0);
        double d = sGILegendDialogObserver.getXValue();
        double d2 = sGILegendDialogObserver.getYValue();
        String string = sGILegendDialogObserver.getFontName();
        float f = sGILegendDialogObserver.getFontSize("pt");
        int n = sGILegendDialogObserver.getFontStyle();
        Color color = sGILegendDialogObserver.getStringColor();
        float f2 = sGILegendDialogObserver.getFrameLineWidth("pt");
        Color color2 = sGILegendDialogObserver.getFrameLineColor();
        Color color3 = sGILegendDialogObserver.getBackgroundColor();
        boolean bl = sGILegendDialogObserver.isLegendVisible();
        boolean bl2 = sGILegendDialogObserver.isFrameLineVisible();
        boolean bl3 = sGILegendDialogObserver.isBackgroundTransparent();
        float f3 = sGILegendDialogObserver.getSymbolSpan("cm");
        Double d3 = new Double(d);
        Double d4 = new Double(d2);
        String string2 = new String(string);
        Float f4 = new Float(f);
        Integer n2 = new Integer(n);
        Color color4 = color;
        Float f5 = new Float(f2);
        Color color5 = color2;
        Color color6 = color3;
        Boolean bl4 = bl;
        Boolean bl5 = bl2;
        Boolean bl6 = bl3;
        Float f6 = new Float(f3);
        if (list.size() > 1) {
            double d5;
            SGILegendDialogObserver sGILegendDialogObserver2;
            int n3;
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n3);
                d5 = sGILegendDialogObserver2.getXValue();
                if (d == d5) continue;
                d3 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n3);
                d5 = sGILegendDialogObserver2.getYValue();
                if (d2 == d5) continue;
                d4 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n3);
                String string3 = sGILegendDialogObserver2.getFontName();
                if (string.equals(string3)) continue;
                string2 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n3);
                float f7 = sGILegendDialogObserver2.getFontSize("pt");
                if (f == f7) continue;
                f4 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n3);
                int n4 = sGILegendDialogObserver2.getFontStyle();
                if (n == n4) continue;
                n2 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n3);
                Color color7 = sGILegendDialogObserver2.getStringColor();
                if (color4.equals(color7)) continue;
                color4 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n3);
                float f8 = sGILegendDialogObserver2.getFrameLineWidth("pt");
                if (f2 == f8) continue;
                f5 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n3);
                Color color8 = sGILegendDialogObserver2.getFrameLineColor();
                if (color5.equals(color8)) continue;
                color5 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n3);
                Color color9 = sGILegendDialogObserver2.getBackgroundColor();
                if (color6.equals(color9)) continue;
                color6 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n3);
                boolean bl7 = sGILegendDialogObserver2.isLegendVisible();
                if (bl == bl7) continue;
                bl4 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n3);
                boolean bl8 = sGILegendDialogObserver2.isFrameLineVisible();
                if (bl2 == bl8) continue;
                bl5 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n3);
                boolean bl9 = sGILegendDialogObserver2.isBackgroundTransparent();
                if (bl3 == bl9) continue;
                bl6 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILegendDialogObserver2 = (SGILegendDialogObserver)list.get(n3);
                float f9 = sGILegendDialogObserver2.getSymbolSpan("cm");
                if (f3 == f9) continue;
                f6 = null;
                break;
            }
        }
        sGLegendDialog.setXValue(d3);
        sGLegendDialog.setYValue(d4);
        sGLegendDialog.setFrameVisible(bl5);
        sGLegendDialog.setFrameLineWidth(f5);
        sGLegendDialog.setFrameLineColor(color5);
        sGLegendDialog.setFontName(string2);
        sGLegendDialog.setFontSize(f4);
        sGLegendDialog.setFontStyle(n2);
        sGLegendDialog.setTextColor(color4);
        sGLegendDialog.setBackgroundColor(color6);
        sGLegendDialog.setLegendTransparent(bl6);
        sGLegendDialog.setLegendVisible(bl4);
        sGLegendDialog.setSymbolSpan(f6);
        this.setColorButtonBorder(true);
        return true;
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        SGILegendDialogObserver sGILegendDialogObserver = (SGILegendDialogObserver)sGIPropertyDialogObserver;
        int n = this.mAxisPanel.getXAxisConfiguration();
        int n2 = this.mAxisPanel.getYAxisConfiguration();
        Number number = this.getXValue();
        Number number2 = this.getYValue();
        Boolean bl = this.getLegendVisible();
        Boolean bl2 = this.getFrameVisible();
        Number number3 = this.getFrameLineWidth();
        Color color = this.getFrameLineColor();
        Color color2 = this.getBackgroundColor();
        Boolean bl3 = this.isLegendTransparent();
        String string = this.getFontName();
        Number number4 = this.getFontSize();
        int n3 = this.getFontStyle();
        Color color3 = this.getTextColor();
        Number number5 = this.getSymbolSpan();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!sGILegendDialogObserver.hasValidXAxisValue(n, number)) {
            arrayList.add("X");
        }
        if (!sGILegendDialogObserver.hasValidYAxisValue(n2, number2)) {
            arrayList.add("Y");
        }
        if (arrayList.size() != 0) {
            String string2 = "Axis value is invalid.:\n";
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = (String)arrayList.get(i);
                string2 = string2 + " - " + string3 + "\n";
            }
            this.setInputErrorMessage(string2);
            return false;
        }
        if (n != -1) {
            sGILegendDialogObserver.setXAxisLocation(n);
        }
        if (n2 != -1) {
            sGILegendDialogObserver.setYAxisLocation(n2);
        }
        if (number != null) {
            sGILegendDialogObserver.setXValue(number.doubleValue());
        }
        if (number2 != null) {
            sGILegendDialogObserver.setYValue(number2.doubleValue());
        }
        if (bl != null) {
            sGILegendDialogObserver.setLegendVisible(bl);
        }
        if (bl2 != null) {
            sGILegendDialogObserver.setFrameVisible(bl2);
        }
        if (number3 != null) {
            sGILegendDialogObserver.setFrameLineWidth(number3.floatValue(), "pt");
        }
        if (color != null) {
            sGILegendDialogObserver.setFrameLineColor(color);
        }
        if (color2 != null) {
            sGILegendDialogObserver.setBackgroundColor(color2);
        }
        if (bl3 != null) {
            sGILegendDialogObserver.setBackgroundTransparent(bl3);
        }
        if (string != null) {
            sGILegendDialogObserver.setFontName(string);
        }
        if (number4 != null) {
            sGILegendDialogObserver.setFontSize(number4.floatValue(), "pt");
        }
        if (n3 != -1) {
            sGILegendDialogObserver.setFontStyle(n3);
        }
        if (color3 != null) {
            sGILegendDialogObserver.setFontColor(color3);
        }
        if (number5 != null) {
            sGILegendDialogObserver.setSymbolSpan(number5.floatValue(), "cm");
        }
        return true;
    }
}

