/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public abstract class SGDateData
extends SGData
implements Cloneable {
    protected InnerDate[] mDateArray = null;

    public SGDateData() {
    }

    public SGDateData(String[] stringArray, String[] stringArray2) throws ParseException {
        DateFormat dateFormat = DateFormat.getDateInstance();
        Calendar calendar = Calendar.getInstance();
        int n = stringArray2.length;
        InnerDate[] innerDateArray = new InnerDate[n];
        for (int i = 0; i < n; ++i) {
            innerDateArray[i] = new InnerDate(stringArray2[i]);
        }
        this.setTitle(stringArray);
        this.mDateArray = innerDateArray;
    }

    public SGDateData(String[] stringArray, int[] nArray, int[] nArray2, int[] nArray3) {
        if (nArray == null | nArray2 == null | nArray3 == null) {
            throw new IllegalArgumentException("yearArray==null | monthArray==null | dateArray==null");
        }
        if (nArray.length != nArray2.length | nArray2.length != nArray3.length) {
            throw new IllegalArgumentException("yearArray.length!=monthArray.length | monthArray.length!=dateArray.length");
        }
        int n = nArray.length;
        InnerDate[] innerDateArray = new InnerDate[n];
        for (int i = 0; i < n; ++i) {
            innerDateArray[i] = new InnerDate(nArray[i], nArray2[i], nArray3[i]);
        }
        this.setTitle(stringArray);
        this.mDateArray = innerDateArray;
    }

    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGDateData)) {
            throw new IllegalArgumentException("!(data instanceof SGDateData)");
        }
        SGDateData sGDateData = (SGDateData)sGData;
        this.setTitle(sGDateData.getTitleArray());
        this.mDateArray = (InnerDate[])sGDateData.mDateArray.clone();
        return true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object copy() {
        return this.clone();
    }

    public void dispose() {
        super.dispose();
        this.mDateArray = null;
    }

    protected static class InnerDate {
        private final String DEFAULT_DATE_FORMAT = "####/##/##";
        protected String mDateString;
        protected int year;
        protected int month;
        protected int date;

        protected InnerDate(int n, int n2, int n3) {
            this.year = n;
            this.month = n2;
            this.date = n3;
            DecimalFormat decimalFormat = new DecimalFormat("####/##/##");
            this.mDateString = decimalFormat.format(this.year * 10000 + this.month * 100 + this.date);
        }

        protected InnerDate(String string) throws ParseException {
            Calendar calendar = Calendar.getInstance();
            this.mDateString = string;
            Date date = SGUtilityText.getDate(string);
            if (date == null) {
                throw new ParseException("Parse error", 0);
            }
            calendar.setTime(date);
            this.year = calendar.get(1);
            this.month = calendar.get(2);
            this.date = calendar.get(5);
        }
    }
}

