/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.io.PrintWriter;
import java.net.Socket;
import jp.riken.brain.ni.samuraigraph.application.SGDrawingServer;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationCommandConstants;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;

public class SGClient
implements SGIApplicationCommandConstants {
    public static void main(String[] stringArray) {
        try {
            if (!SGClient.readCommandLine(stringArray)) {
                return;
            }
            Socket socket = new Socket("localhost", SGDrawingServer.PORT_NUMBER);
            socket.setSoTimeout(10000);
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream());
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.println(stringArray[i]);
            }
            printWriter.close();
            socket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(200);
        }
    }

    private static boolean readCommandLine(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        if (stringArray.length == 0) {
            return false;
        }
        String string = stringArray[0];
        if (string == null) {
            return false;
        }
        return !(string.equals("drawGraph") ? !SGClient.onAddData(stringArray) : string.equals("loadProperty") && !SGClient.onReadProperty(stringArray));
    }

    private static boolean onAddData(String[] stringArray) {
        if (stringArray.length < 2) {
            return false;
        }
        if (stringArray[1] == null) {
            return false;
        }
        stringArray[1] = SGUtility.getCanonicalPath(stringArray[1]);
        return stringArray[1] != null;
    }

    private static boolean onReadProperty(String[] stringArray) {
        if (stringArray.length < 3) {
            return false;
        }
        if (stringArray[1] == null) {
            return false;
        }
        stringArray[1] = SGUtility.getCanonicalPath(stringArray[1]);
        if (stringArray[1] == null) {
            return false;
        }
        if (stringArray[2] == null) {
            return false;
        }
        stringArray[2] = SGUtility.getCanonicalPath(stringArray[2]);
        return stringArray[2] != null;
    }
}

