/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.freehep.graphicsio.font.FontTable;
import org.freehep.graphicsio.font.encoding.CharTable;
import org.freehep.graphicsio.font.encoding.Lookup;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFFontEmbedderType1;
import org.freehep.graphicsio.pdf.PDFFontEmbedderType3;
import org.freehep.graphicsio.pdf.PDFFontIncluder;
import org.freehep.graphicsio.pdf.PDFRedundanceTracker;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFFontTable
extends FontTable {
    private int currentFontIndex = 1;
    private PDFWriter pdf;
    private PDFRedundanceTracker tracker;
    private static final Properties replaceFonts = new Properties();

    public PDFFontTable(PDFWriter pdf) {
        this.pdf = pdf;
        this.tracker = new PDFRedundanceTracker(pdf);
    }

    public int addFontDictionary() throws IOException {
        Collection fonts = this.getEntries();
        if (fonts.size() > 0) {
            PDFDictionary fontList = this.pdf.openDictionary("FontList");
            Iterator i = fonts.iterator();
            while (i.hasNext()) {
                FontTable.Entry e = (FontTable.Entry)i.next();
                fontList.entry(e.getReference(), this.pdf.ref(e.getReference()));
            }
            this.pdf.close(fontList);
        }
        return fonts.size();
    }

    public void embedAll(FontRenderContext context, boolean embed, String embedAs) throws IOException {
        Collection col = this.getEntries();
        Iterator i = col.iterator();
        while (i.hasNext()) {
            FontTable.Entry e = (FontTable.Entry)i.next();
            boolean _embed = embed;
            if (e.isWritten()) continue;
            e.setWritten(true);
            Object fontIncluder = null;
            if (PDFFontIncluder.isStandardFont(e.getFont())) {
                _embed = false;
            }
            if (_embed) {
                if (embedAs.equals("Type3")) {
                    fontIncluder = new PDFFontEmbedderType3(context, this.pdf, e.getReference(), this.tracker);
                } else if (embedAs.equals("Type1")) {
                    fontIncluder = PDFFontEmbedderType1.create(context, this.pdf, e.getReference(), this.tracker);
                } else {
                    System.out.println("PDFFontTable: invalid value for embedAs: " + embedAs);
                }
            } else {
                fontIncluder = new PDFFontIncluder(context, this.pdf, e.getReference(), this.tracker);
            }
            fontIncluder.includeFont(e.getFont(), e.getEncoding(), e.getReference());
        }
        this.tracker.writeAll();
    }

    public CharTable getEncodingTable() {
        return Lookup.getInstance().getTable("PDFLatin");
    }

    public void firstRequest(FontTable.Entry e, boolean embed, String embedAs) {
    }

    protected Font substituteFont(Font font) {
        String fontName = replaceFonts.getProperty(font.getName(), null);
        if (fontName != null) {
            Font newFont = new Font(fontName, font.getStyle(), font.getSize());
            font = newFont.deriveFont(font.getSize2D());
        }
        return font;
    }

    protected String createFontReference(Font f) {
        return "F" + this.currentFontIndex++;
    }

    static {
        replaceFonts.setProperty("Dialog", "Helvetica");
        replaceFonts.setProperty("DialogInput", "Helvetica");
        replaceFonts.setProperty("Serif", "TimesRoman");
        replaceFonts.setProperty("SansSerif", "Helvetica");
        replaceFonts.setProperty("Monospaced", "Courier");
    }
}

