/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroup;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroupElement;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIRectangularShapeDialogObserver;

public class SGRectangularShapeDialog
extends SGPropertyDialog {
    public static final String TITLE = "Rectangular Shape Properties";
    private SGTwoAxesSelectionPanel mAxisPanel;
    private JLabel mBackgroundLabel;
    private JSeparator mBackgroundSeparator;
    private SGCheckBox mBackgroundTransparentCheckBox;
    private JLabel mBottomYValueLabel;
    private SGTextField mBottomYValueTextField;
    private JLabel mBoundsLabel;
    private JSeparator mBoundsSeparator;
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JLabel mEdgeLineLabel;
    private JSeparator mEdgeLineSeparator;
    private JComboBox mEdgeLineTypeComboBox;
    private JLabel mEdgeLineTypeLabel;
    private JLabel mEdgeLineWidthLabel;
    private SGSpinner mEdgeLineWidthSpinner;
    private SGColorSelectionButton mInnerColorButton;
    private JLabel mInnerColorLabel;
    private JLabel mLeftSpaceLabel;
    private JLabel mLeftXValueLabel;
    private SGTextField mLeftXValueTextField;
    private SGColorSelectionButton mLineColorButton;
    private JLabel mLineColorLabel;
    private JButton mOKButton;
    private JPanel mPanel;
    private JButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JLabel mRightXValueLabel;
    private SGTextField mRightXValueTextField;
    private JLabel mTopYValueLabel;
    private SGTextField mTopYValueTextField;
    private SGComponentGroup mTransparentComponentGroup = new SGComponentGroup();

    public SGRectangularShapeDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mAxisPanel = new SGTwoAxesSelectionPanel();
        this.mPanel = new JPanel();
        this.mEdgeLineLabel = new JLabel();
        this.mEdgeLineSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mBoundsLabel = new JLabel();
        this.mBoundsSeparator = new JSeparator();
        this.mLeftXValueLabel = new JLabel();
        this.mLeftXValueTextField = new SGTextField();
        this.mTopYValueLabel = new JLabel();
        this.mTopYValueTextField = new SGTextField();
        this.mRightXValueLabel = new JLabel();
        this.mRightXValueTextField = new SGTextField();
        this.mBottomYValueLabel = new JLabel();
        this.mBottomYValueTextField = new SGTextField();
        this.mBackgroundLabel = new JLabel();
        this.mBackgroundSeparator = new JSeparator();
        this.mLineColorLabel = new JLabel();
        this.mLineColorButton = new SGColorSelectionButton();
        this.mInnerColorLabel = new JLabel();
        this.mInnerColorButton = new SGColorSelectionButton();
        this.mEdgeLineWidthLabel = new JLabel();
        this.mEdgeLineWidthSpinner = new SGSpinner();
        this.mBackgroundTransparentCheckBox = new SGCheckBox();
        this.mEdgeLineTypeLabel = new JLabel();
        this.mEdgeLineTypeComboBox = new JComboBox();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mAxisPanel, gridBagConstraints);
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setBorder(new BevelBorder(0));
        this.mEdgeLineLabel.setFont(new Font("Dialog", 3, 12));
        this.mEdgeLineLabel.setText("Edge Line ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mEdgeLineLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 4, 5, 5);
        this.mPanel.add((Component)this.mEdgeLineSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        this.mPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mBoundsLabel.setFont(new Font("Dialog", 3, 12));
        this.mBoundsLabel.setText("Bounds ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mPanel.add((Component)this.mBoundsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 4, 5, 5);
        this.mPanel.add((Component)this.mBoundsSeparator, gridBagConstraints);
        this.mLeftXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mLeftXValueLabel.setText("Left X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mLeftXValueLabel, gridBagConstraints);
        this.mLeftXValueTextField.setColumns(6);
        this.mLeftXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mLeftXValueTextField, gridBagConstraints);
        this.mTopYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mTopYValueLabel.setText("Top Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mPanel.add((Component)this.mTopYValueLabel, gridBagConstraints);
        this.mTopYValueTextField.setColumns(6);
        this.mTopYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mTopYValueTextField, gridBagConstraints);
        this.mRightXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mRightXValueLabel.setText("Right X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.mPanel.add((Component)this.mRightXValueLabel, gridBagConstraints);
        this.mRightXValueTextField.setColumns(6);
        this.mRightXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mRightXValueTextField, gridBagConstraints);
        this.mBottomYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mBottomYValueLabel.setText("Bottom Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mBottomYValueLabel, gridBagConstraints);
        this.mBottomYValueTextField.setColumns(6);
        this.mBottomYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mBottomYValueTextField, gridBagConstraints);
        this.mBackgroundLabel.setFont(new Font("Dialog", 3, 12));
        this.mBackgroundLabel.setText("Background");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mBackgroundLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.mPanel.add((Component)this.mBackgroundSeparator, gridBagConstraints);
        this.mLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 10);
        this.mPanel.add((Component)this.mLineColorLabel, gridBagConstraints);
        this.mLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 7, 5);
        this.mPanel.add((Component)this.mLineColorButton, gridBagConstraints);
        this.mInnerColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mInnerColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mPanel.add((Component)this.mInnerColorLabel, gridBagConstraints);
        this.mInnerColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mPanel.add((Component)this.mInnerColorButton, gridBagConstraints);
        this.mEdgeLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mEdgeLineWidthLabel.setText("Line Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mEdgeLineWidthLabel, gridBagConstraints);
        this.mEdgeLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mEdgeLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mEdgeLineWidthSpinner, gridBagConstraints);
        this.mBackgroundTransparentCheckBox.setText("Transparency");
        this.mBackgroundTransparentCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mPanel.add((Component)this.mBackgroundTransparentCheckBox, gridBagConstraints);
        this.mEdgeLineTypeLabel.setFont(new Font("Dialog", 0, 12));
        this.mEdgeLineTypeLabel.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mEdgeLineTypeLabel, gridBagConstraints);
        this.mEdgeLineTypeComboBox.setFont(new Font("Dialog", 0, 12));
        this.mEdgeLineTypeComboBox.setPreferredSize(new Dimension(140, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mEdgeLineTypeComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private void initProperty() {
        this.setTitle(TITLE);
        Object[] objectArray = new String[]{"Solid", "Broken", "Dotted", "Dashed", "Double Dashed"};
        for (int i = 0; i < objectArray.length; ++i) {
            this.mEdgeLineTypeComboBox.addItem(objectArray[i]);
        }
        this.pack();
        this.mEdgeLineWidthSpinner.initProperties(SGRectangularShapeDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mFocusedColorSetButton = this.mInnerColorButton;
        objectArray = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mInnerColorLabel), new SGComponentGroupElement(this.mInnerColorButton)};
        this.mTransparentComponentGroup.addElement((SGComponentGroupElement[])objectArray);
        this.mLeftXValueTextField.setDescription("Bounds-> LeftX");
        this.mRightXValueTextField.setDescription("Bounds-> RightX");
        this.mBottomYValueTextField.setDescription("Bounds-> BottomY");
        this.mTopYValueTextField.setDescription("Bounds-> TopY");
        this.mEdgeLineWidthSpinner.setDescription("Edge Line-> Line Width");
        this.mBackgroundTransparentCheckBox.addActionListener(this);
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object.equals(this.mBackgroundTransparentCheckBox)) {
            this.setTransparent(this.isTransparent());
        }
    }

    public List getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mLineColorButton);
        arrayList.add(this.mInnerColorButton);
        return arrayList;
    }

    public List getTextFieldComponentsList() {
        List list = this.getFormattedTextFieldsListFromSpinners();
        list.addAll(this.getNumberTextFieldList());
        return list;
    }

    public List getNumberTextFieldList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.add(this.mLeftXValueTextField);
        arrayList.add(this.mRightXValueTextField);
        arrayList.add(this.mTopYValueTextField);
        arrayList.add(this.mBottomYValueTextField);
        return arrayList;
    }

    public List getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mEdgeLineWidthSpinner);
        return arrayList;
    }

    public boolean setDialogProperty() {
        List list = this.mPropertyDialogObserverList;
        if (!this.mAxisPanel.setSelected(list)) {
            return false;
        }
        SGIRectangularShapeDialogObserver sGIRectangularShapeDialogObserver = (SGIRectangularShapeDialogObserver)list.get(0);
        double d = sGIRectangularShapeDialogObserver.getLeftXValue();
        double d2 = sGIRectangularShapeDialogObserver.getTopYValue();
        double d3 = sGIRectangularShapeDialogObserver.getRightXValue();
        double d4 = sGIRectangularShapeDialogObserver.getBottomYValue();
        float f = sGIRectangularShapeDialogObserver.getLineWidth("pt");
        int n = sGIRectangularShapeDialogObserver.getLineType();
        Color color = sGIRectangularShapeDialogObserver.getInnerColor();
        Color color2 = sGIRectangularShapeDialogObserver.getLineColor();
        boolean bl = sGIRectangularShapeDialogObserver.isTransparent();
        Double d5 = new Double(d);
        Double d6 = new Double(d2);
        Double d7 = new Double(d3);
        Double d8 = new Double(d4);
        Float f2 = new Float(f);
        Integer n2 = new Integer(n);
        Color color3 = color;
        Color color4 = color2;
        Boolean bl2 = bl;
        if (list.size() > 1) {
            double d9;
            SGIRectangularShapeDialogObserver sGIRectangularShapeDialogObserver2;
            int n3;
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                d9 = sGIRectangularShapeDialogObserver2.getLeftXValue();
                if (d == d9) continue;
                d5 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                d9 = sGIRectangularShapeDialogObserver2.getTopYValue();
                if (d2 == d9) continue;
                d6 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                d9 = sGIRectangularShapeDialogObserver2.getRightXValue();
                if (d3 == d9) continue;
                d7 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                d9 = sGIRectangularShapeDialogObserver2.getBottomYValue();
                if (d4 == d9) continue;
                d8 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                float f3 = sGIRectangularShapeDialogObserver2.getLineWidth("pt");
                if (f == f3) continue;
                f2 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                int n4 = sGIRectangularShapeDialogObserver2.getLineType();
                if (n == n4) continue;
                n2 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                Color color5 = sGIRectangularShapeDialogObserver2.getInnerColor();
                if (color.equals(color5)) continue;
                color3 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                Color color6 = sGIRectangularShapeDialogObserver2.getLineColor();
                if (color2.equals(color6)) continue;
                color4 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGIRectangularShapeDialogObserver2 = (SGIRectangularShapeDialogObserver)list.get(n3);
                boolean bl3 = sGIRectangularShapeDialogObserver2.isTransparent();
                if (bl == bl3) continue;
                bl2 = null;
                break;
            }
        }
        this.setLeftXValue(d5);
        this.setTopYValue(d6);
        this.setRightXValue(d7);
        this.setBottomYValue(d8);
        this.setLineWidth(f2);
        this.setLineType(n2);
        this.setInnerColor(color3);
        this.setLineColor(color4);
        this.setTransparent(bl2);
        this.setColorButtonBorder(true);
        return true;
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        SGIRectangularShapeDialogObserver sGIRectangularShapeDialogObserver = (SGIRectangularShapeDialogObserver)sGIPropertyDialogObserver;
        int n = this.mAxisPanel.getXAxisConfiguration();
        int n2 = this.mAxisPanel.getYAxisConfiguration();
        Number number = this.getLeftXValue();
        Number number2 = this.getTopYValue();
        Number number3 = this.getRightXValue();
        Number number4 = this.getBottomYValue();
        Number number5 = this.getLineWidth();
        int n3 = this.getLineType();
        Color color = this.getInnerColor();
        Color color2 = this.getLineColor();
        Boolean bl = this.isTransparent();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!sGIRectangularShapeDialogObserver.hasValidLeftXValue(n, number)) {
            arrayList.add("LeftX");
        }
        if (!sGIRectangularShapeDialogObserver.hasValidTopYValue(n2, number2)) {
            arrayList.add("TopY");
        }
        if (!sGIRectangularShapeDialogObserver.hasValidRightXValue(n, number3)) {
            arrayList.add("RightX");
        }
        if (!sGIRectangularShapeDialogObserver.hasValidBottomYValue(n2, number4)) {
            arrayList.add("BottomY");
        }
        if (arrayList.size() != 0) {
            String string = "Axis value is invalid.:\n";
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                string = string + " - " + string2 + "\n";
            }
            this.setInputErrorMessage(string);
            return false;
        }
        if (n != -1) {
            sGIRectangularShapeDialogObserver.setXAxisLocation(n);
        }
        if (n2 != -1) {
            sGIRectangularShapeDialogObserver.setYAxisLocation(n2);
        }
        if (number != null) {
            sGIRectangularShapeDialogObserver.setLeftXValue(number.doubleValue());
        }
        if (number2 != null) {
            sGIRectangularShapeDialogObserver.setTopYValue(number2.doubleValue());
        }
        if (number3 != null) {
            sGIRectangularShapeDialogObserver.setRightXValue(number3.doubleValue());
        }
        if (number4 != null) {
            sGIRectangularShapeDialogObserver.setBottomYValue(number4.doubleValue());
        }
        if (number5 != null) {
            sGIRectangularShapeDialogObserver.setLineWidth(number5.floatValue(), "pt");
        }
        if (n3 != -1) {
            sGIRectangularShapeDialogObserver.setLineType(n3);
        }
        if (color != null) {
            sGIRectangularShapeDialogObserver.setInnerColor(color);
        }
        if (color2 != null) {
            sGIRectangularShapeDialogObserver.setLineColor(color2);
        }
        if (bl != null) {
            sGIRectangularShapeDialogObserver.setTransparent(bl);
        }
        return true;
    }

    public Number getLeftXValue() {
        return this.getNumber(this.mLeftXValueTextField);
    }

    public Number getRightXValue() {
        return this.getNumber(this.mRightXValueTextField);
    }

    public Number getTopYValue() {
        return this.getNumber(this.mTopYValueTextField);
    }

    public Number getBottomYValue() {
        return this.getNumber(this.mBottomYValueTextField);
    }

    public Color getLineColor() {
        return this.mLineColorButton.getColor();
    }

    public Color getInnerColor() {
        return this.mInnerColorButton.getColor();
    }

    public Number getLineWidth() {
        return this.mEdgeLineWidthSpinner.getNumber();
    }

    public int getLineType() {
        String string = (String)this.mEdgeLineTypeComboBox.getSelectedItem();
        if (string == null) {
            return -1;
        }
        Integer n = SGDrawingElementLine.getLineTypeFromName(string);
        return n;
    }

    public Boolean isTransparent() {
        return this.mBackgroundTransparentCheckBox.getSelected();
    }

    public boolean setLeftXValue(Object object) {
        return this.setValue(this.mLeftXValueTextField, object);
    }

    public boolean setRightXValue(Object object) {
        return this.setValue(this.mRightXValueTextField, object);
    }

    public boolean setTopYValue(Object object) {
        return this.setValue(this.mTopYValueTextField, object);
    }

    public boolean setBottomYValue(Object object) {
        return this.setValue(this.mBottomYValueTextField, object);
    }

    public boolean setLineColor(Color color) {
        this.mLineColorButton.setColor(color);
        return true;
    }

    public boolean setInnerColor(Color color) {
        this.mInnerColorButton.setColor(color);
        return true;
    }

    public boolean setLineWidth(Object object) {
        return this.setValue(this.mEdgeLineWidthSpinner, object);
    }

    public boolean setLineType(Integer n) {
        if (n != null) {
            String string = SGDrawingElementLine.getLineTypeName(n);
            this.mEdgeLineTypeComboBox.setSelectedItem(string);
        } else {
            this.mEdgeLineTypeComboBox.setSelectedItem(null);
        }
        return true;
    }

    public boolean setTransparent(Boolean bl) {
        this.mBackgroundTransparentCheckBox.setSelected(bl);
        this.setTransparentComponentEnabled(bl);
        return true;
    }

    private boolean setTransparentComponentEnabled(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.setTransparentComponentEnabled(!bl2);
        return true;
    }

    private boolean setTransparentComponentEnabled(boolean bl) {
        this.mTransparentComponentGroup.setEnabled(bl);
        if (this.mInnerColorButton.equals(this.mFocusedColorSetButton)) {
            this.mFocusedColorSetButton = this.mLineColorButton;
            this.setColorButtonBorder(true);
        }
        return true;
    }
}

