/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.io.IOException;
import java.io.Writer;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;

public class SGSXYSamplingData
extends SGSXYMultipleData
implements Cloneable {
    private double mSamplingRate;

    public SGSXYSamplingData() {
    }

    public SGSXYSamplingData(double d, double[][] dArray) {
        int n;
        if (d <= 0.0) {
            throw new IllegalArgumentException("sRate<=0.0");
        }
        if (dArray == null) {
            throw new IllegalArgumentException("yArray==null");
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("yArray.length==0");
        }
        int n2 = dArray[0].length;
        for (n = 1; n < dArray.length; ++n) {
            if (dArray[n].length == n2) continue;
            throw new IllegalArgumentException("yArray[ii].length!=len");
        }
        this.mSamplingRate = d;
        this.mYValueArray = new double[dArray.length][];
        for (n = 0; n < this.mYValueArray.length; ++n) {
            this.mYValueArray[n] = (double[])dArray[n].clone();
        }
    }

    public double getSamplingRate() {
        return this.mSamplingRate;
    }

    public Double getXValue(int n) {
        return new Double(this.getPrimitiveXValue(n));
    }

    private double getPrimitiveXValue(int n) {
        return (double)n / this.mSamplingRate;
    }

    public double[] getXValueArray() {
        int n = this.getPointsNumber();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.getPrimitiveXValue(i);
        }
        return dArray;
    }

    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYSamplingData)) {
            return false;
        }
        SGSXYSamplingData sGSXYSamplingData = (SGSXYSamplingData)sGData;
        this.mSamplingRate = sGSXYSamplingData.mSamplingRate;
        this.mYValueArray = sGSXYSamplingData.mYValueArray;
        return true;
    }

    public String getDataType() {
        return "SXY_SAMPLING";
    }

    public double getMinValueX() {
        return 0.0;
    }

    public double getMaxValueX() {
        return (double)(this.getPointsNumber() - 1) / this.mSamplingRate;
    }

    public int getPointsNumber() {
        return this.mYValueArray[0].length;
    }

    public String toString() {
        String string = "[";
        string = string + "SamplingRate=" + Double.toString(this.mSamplingRate) + ", ";
        string = string + "Y={";
        int n = this.getDataNumber();
        for (int i = 0; i < n; ++i) {
            double[] dArray = this.mYValueArray[i];
            string = string + this.toDoubleArrayString(dArray);
            if (i == dArray.length - 1) break;
            string = string + ",";
        }
        string = string + "}";
        string = string + "]";
        return string;
    }

    protected boolean writeData(Writer writer) throws IOException {
        if (this.mYValueArray == null || this.mYValueArray.length == 0) {
            return false;
        }
        int n = this.getPointsNumber();
        int n2 = this.getDataNumber();
        for (int i = 0; i < n; ++i) {
            String string = "";
            for (int j = 0; j < n2; ++j) {
                if (j != 0) {
                    string = string + ",";
                }
                string = string + this.mYValueArray[j][i];
            }
            string = string + "\n";
            writer.write(string);
        }
        return true;
    }
}

