/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.Calendar;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGDateData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;

public class SGSXYDateData
extends SGDateData
implements SGISXYTypeData {
    private SGSXYData mData = null;

    public SGSXYDateData() {
    }

    public SGSXYDateData(String[] stringArray, double[] dArray) throws ParseException {
        this(stringArray, dArray, null, null, null);
    }

    public SGSXYDateData(String[] stringArray, double[] dArray, String[] stringArray2) throws ParseException {
        this(stringArray, dArray, null, null, stringArray2);
    }

    public SGSXYDateData(String[] stringArray, double[] dArray, double[] dArray2, double[] dArray3) throws ParseException {
        this(stringArray, dArray, dArray2, dArray3, null);
    }

    public SGSXYDateData(String[] stringArray, double[] dArray, double[] dArray2, double[] dArray3, String[] stringArray2) throws ParseException {
        super(stringArray);
        if (dArray.length != stringArray.length) {
            throw new IllegalArgumentException("yValueArray.length!=dateArray.length");
        }
        if (dArray2 != null & dArray3 != null) {
            if (dArray2.length != stringArray.length) {
                throw new IllegalArgumentException("lowerErrorArray.length!=dateArray.length");
            }
            if (dArray3.length != stringArray.length) {
                throw new IllegalArgumentException("upperErrorArray.length!=dateArray.length");
            }
        }
        if (stringArray2 != null && stringArray2.length != stringArray.length) {
            throw new IllegalArgumentException("labelArray.length!=dateArray.length");
        }
        double[] dArray4 = this.calcXValueArray();
        String[] stringArray3 = stringArray2 != null ? SGUtility.copyStringArray(stringArray2) : SGUtility.copyStringArray(stringArray);
        this.mData = new SGSXYData(dArray4, dArray, dArray2, dArray3, stringArray3);
    }

    public SGSXYDateData(int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) {
        this(nArray, nArray2, nArray3, null, null, dArray);
    }

    public SGSXYDateData(int[] nArray, int[] nArray2, int[] nArray3, double[] dArray, double[] dArray2, double[] dArray3) {
        super(nArray, nArray2, nArray3);
        if (dArray == null) {
            throw new IllegalArgumentException("yValueArray==null");
        }
        if (dArray.length != nArray.length) {
            throw new IllegalArgumentException("yValueArray.length!=yearArray.length");
        }
        if (dArray2 != null & dArray3 != null) {
            if (dArray2.length != nArray.length) {
                throw new IllegalArgumentException("lowerErrorArray.length!=yearArray.length");
            }
            if (dArray3.length != nArray.length) {
                throw new IllegalArgumentException("upperErrorArray.length!=yearArray.length");
            }
        }
        double[] dArray4 = this.calcXValueArray();
        String[] stringArray = this.getStringArray(nArray, nArray2, nArray3);
        this.mData = new SGSXYData(dArray4, dArray, dArray2, dArray3, stringArray);
    }

    private double[] calcXValueArray() {
        SGDateData.InnerDate[] innerDateArray = this.mDateArray;
        int n = innerDateArray.length;
        double[] dArray = new double[n];
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < n; ++i) {
            SGDateData.InnerDate innerDate = innerDateArray[i];
            calendar.set(innerDate.year, innerDate.month, innerDate.date);
            dArray[i] = calendar.getTimeInMillis() / 86400000L;
        }
        return dArray;
    }

    private String[] getStringArray(int[] nArray, int[] nArray2, int[] nArray3) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            SGDateData.InnerDate innerDate = new SGDateData.InnerDate(nArray[i], nArray2[i], nArray3[i]);
            stringArray[i] = innerDate.mDateString;
        }
        return stringArray;
    }

    public int getPointsNumber() {
        return this.mData.getPointsNumber();
    }

    public String getDataType() {
        return "SXY_DATE";
    }

    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYDateData)) {
            throw new IllegalArgumentException("!(data instanceof SGSXYCalendarData)");
        }
        if (!super.setData(sGData)) {
            return false;
        }
        SGSXYDateData sGSXYDateData = (SGSXYDateData)sGData;
        this.mData = (SGSXYData)sGSXYDateData.mData.copy();
        return true;
    }

    public double getMinValueX() {
        return this.mData.getMinValueX();
    }

    public double getMaxValueX() {
        return this.mData.getMaxValueX();
    }

    public double getMinValueY() {
        return this.mData.getMinValueY();
    }

    public double getMaxValueY() {
        return this.mData.getMaxValueY();
    }

    public Double getXValue(int n) {
        return this.mData.getXValue(n);
    }

    public Double getYValue(int n) {
        return this.mData.getYValue(n);
    }

    public Double getLowerErrorValue(int n) {
        return this.mData.getLowerErrorValue(n);
    }

    public Double getUpperErrorValue(int n) {
        return this.mData.getUpperErrorValue(n);
    }

    public String getString(int n) {
        return this.mData.getString(n);
    }

    public double[] getXValueArray() {
        return this.mData.getXValueArray();
    }

    public double[] getYValueArray() {
        return this.mData.getYValueArray();
    }

    public double[] getLowerErrorValueArray() {
        return this.mData.getLowerErrorValueArray();
    }

    public double[] getUpperErrorValueArray() {
        return this.mData.getUpperErrorValueArray();
    }

    public String[] getStringArray() {
        return this.mData.getStringArray();
    }

    public boolean isErrorValueHolding() {
        return this.mData.isErrorValueHolding();
    }

    public boolean isStringArrayHolding() {
        return this.mData.isStringArrayHolding();
    }

    public void dispose() {
        super.dispose();
        this.mData = null;
    }

    protected boolean writeData(Writer writer) throws IOException {
        if (this.mData == null || this.mData.mXValueArray.length == 0) {
            return false;
        }
        for (int i = 0; i < this.mData.mXValueArray.length; ++i) {
            String string = this.mDateArray[i].mDateString + "," + this.mData.mYValueArray[i];
            if (this.mData.mUpperErrorArray != null) {
                string = string + "," + this.mData.mUpperErrorArray[i] + "," + this.mData.mLowerErrorArray[i];
            }
            if (this.mData.mStringArray[i] != null) {
                string = string + "," + SGUtilityText.getCSVString(this.mData.mStringArray[i]);
            }
            string = string + "\n";
            writer.write(string);
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = new String[]{"2005/1/1", "2005/2/1", "2005/3/1", "2005/4/1", "2005/5/1", "2005/6/1", "2005/7/1", "2005/8/1", "2005/9/1", "2005/10/1", "2005/11/1", "2005/12/1", "2006/1/1"};
        double[] dArray = new double[]{3.1, 8.0, 1.4, 2.5, 5.8, 6.3, 10.8, 3.4, 4.1, 8.5, 6.8, 9.5, 7.3};
        double[] dArray2 = new double[stringArray2.length];
        double[] dArray3 = new double[stringArray2.length];
        SGSXYDateData sGSXYDateData = new SGSXYDateData(stringArray2, dArray, dArray2, dArray3);
        SGSXYData sGSXYData = sGSXYDateData.mData;
        double[] dArray4 = sGSXYData.getXValueArray();
        double[] dArray5 = sGSXYData.getYValueArray();
        String[] stringArray3 = sGSXYData.getStringArray();
        for (int i = 0; i < dArray4.length; ++i) {
            System.out.println(stringArray2[i] + "  " + (long)dArray4[i] + "  " + dArray5[i] + "  " + stringArray3[i]);
            if (i == dArray4.length - 1) continue;
            System.out.println((long)(dArray4[i + 1] - dArray4[i]) / 86400000L);
        }
        System.out.println();
    }
}

