/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.print.attribute.standard.MediaSize;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.riken.brain.ni.samuraigraph.base.SGCSVTokenizer;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import org.w3c.dom.Document;

public class SGUtilityText
implements SGIConstants,
SGIDrawingElementConstants {
    public static final String[] DEFAULT_DATE_FORMAT_ARRAY = new String[]{"yy/MM/dd", "yy.MM.dd", "yy-MM-dd", "yyyyMMdd", "yyMMdd", "yy MM dd", "yyyy MM dd"};
    private static final ArrayList DATE_FORMAT_ARRAY_LIST = new ArrayList();
    public static final Color[] defaultColors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.CYAN, Color.MAGENTA, Color.YELLOW, Color.ORANGE, Color.PINK, Color.WHITE, Color.LIGHT_GRAY, Color.GRAY, Color.DARK_GRAY, Color.BLACK};
    public static final String[] names = new String[]{"RED", "GREEN", "BLUE", "CYAN", "MAGENTA", "YELLOW", "ORANGE", "PINK", "WHITE", "LIGHT_GRAY", "GRAY", "DARK_GRAY", "BLACK"};

    public static void main(String[] stringArray) throws Exception {
        System.out.println("<< start >>");
        String string = "1.0 inch";
        Number number = SGUtilityText.getLength(string, "pt");
        System.out.println(number);
    }

    public static String getSuperscriptString(String string, String string2) {
        String string3 = string + "^{" + string2 + "}";
        return string3;
    }

    public static String getSubscriptString(String string, String string2) {
        String string3 = string + "_{" + string2 + "}";
        return string3;
    }

    public static boolean getSubscriptAndSuperscriptInfo(String string, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        if (string == null || arrayList == null || arrayList2 == null || arrayList3 == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl || bl2) {
                if (bl3) {
                    if (c == '}' && n2 == 0) {
                        bl3 = false;
                        bl = false;
                        bl2 = false;
                        continue;
                    }
                    if (c == '}') {
                        --n2;
                    }
                    if (c == '{') {
                        ++n2;
                    }
                    if (bl) {
                        string3 = string3 + c;
                        continue;
                    }
                    string4 = string4 + c;
                    continue;
                }
                if (c == '{') {
                    bl3 = true;
                    n2 = 0;
                    continue;
                }
                if (bl) {
                    string3 = string3 + c;
                    bl = false;
                    continue;
                }
                string4 = string4 + c;
                bl2 = false;
                continue;
            }
            if (c == '^') {
                if (string2.length() == 0 || string3.length() != 0) {
                    return false;
                }
                bl = true;
                continue;
            }
            if (c == '_') {
                if (string2.length() == 0 || string4.length() != 0) {
                    return false;
                }
                bl2 = true;
                continue;
            }
            if (string3.length() != 0 || string4.length() != 0) {
                arrayList.add(string2);
                if (string3.length() != 0) {
                    arrayList2.add(string3);
                } else {
                    arrayList2.add(null);
                }
                if (string4.length() != 0) {
                    arrayList3.add(string4);
                } else {
                    arrayList3.add(null);
                }
                string2 = "";
                string3 = "";
                string4 = "";
            }
            string2 = string2 + c;
        }
        if (bl || bl2 || bl3) {
            return false;
        }
        if (string2.length() != 0) {
            arrayList.add(string2);
            if (string3.length() != 0) {
                arrayList2.add(string3);
            } else {
                arrayList2.add(null);
            }
            if (string4.length() != 0) {
                arrayList3.add(string4);
            } else {
                arrayList3.add(null);
            }
        }
        return true;
    }

    public static boolean tokenize(String string, ArrayList arrayList, boolean bl) {
        if (string == null | arrayList == null) {
            throw new IllegalArgumentException("str==null | strList==null");
        }
        if (string.length() == 0) {
            return true;
        }
        SGCSVTokenizer sGCSVTokenizer = new SGCSVTokenizer(string, bl);
        while (sGCSVTokenizer.hasMoreTokens()) {
            try {
                String string2 = sGCSVTokenizer.nextToken();
                arrayList.add(string2);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        return true;
    }

    public static String createString(ArrayList arrayList) {
        char[] cArray = new char[arrayList.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = ((Character)arrayList.get(i)).charValue();
        }
        String string = new String(cArray);
        return string;
    }

    public static String readLine(BufferedReader bufferedReader) {
        String string = null;
        try {
            do {
                if ((string = bufferedReader.readLine()) != null) continue;
                return null;
            } while (string.length() == 0);
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    public static String getColorListString(List list) {
        String string = "{";
        for (int i = 0; i < list.size(); ++i) {
            Color color = (Color)list.get(i);
            String string2 = SGUtilityText.getColorString(color);
            string = string + string2;
            string = i != list.size() - 1 ? string + ',' : string + "}";
        }
        return string;
    }

    public static boolean writeColorListPropertyLine(Writer writer, String string, List list) throws IOException {
        writer.write(string + "=");
        String string2 = SGUtilityText.getColorListString(list);
        writer.write(string2 + "\n");
        return true;
    }

    public static String getInnerString(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return null;
        }
        int n3 = string.indexOf(n) + 1;
        int n4 = string.lastIndexOf(n2);
        if (n4 <= n3) {
            return null;
        }
        String string2 = string.substring(n3, n4);
        return string2;
    }

    private static final int[] getIntegerArray(String string) {
        if (string == null) {
            return null;
        }
        String string2 = SGUtilityText.getInnerString(string, 40, 41);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        int[] nArray = new int[arrayList.size()];
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                int n;
                String string3 = (String)arrayList.get(i);
                nArray[i] = n = Integer.valueOf(string3).intValue();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return nArray;
    }

    public static Color getColorFromString(String string) {
        int[] nArray = SGUtilityText.getIntegerArray(string);
        int n = nArray.length;
        if (n != 4 & n != 3) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            if (!(nArray[i] < 0 | nArray[i] > 255)) continue;
            return null;
        }
        Color color = null;
        if (n == 3) {
            color = new Color(nArray[0], nArray[1], nArray[2]);
        } else if (n == 4) {
            color = new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        return color;
    }

    public static String getColorString(Color color) {
        String string = new String("(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + color.getAlpha() + ")");
        return string;
    }

    public static Boolean getBoolean(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase();
        Boolean bl = null;
        if (Boolean.TRUE.toString().equals(string2)) {
            bl = Boolean.TRUE;
        } else if (Boolean.FALSE.toString().equals(string2)) {
            bl = Boolean.FALSE;
        } else {
            return null;
        }
        return bl;
    }

    public static Integer getInteger(String string) {
        Number number = SGUtilityText.parse(string);
        if (number == null) {
            return null;
        }
        return new Integer(number.intValue());
    }

    public static Float getFloat(String string) {
        Number number = SGUtilityText.parse(string);
        if (number == null) {
            return null;
        }
        return new Float(number.floatValue());
    }

    public static Double getDouble(String string) {
        Number number = SGUtilityText.parse(string);
        if (number == null) {
            return null;
        }
        return new Double(number.doubleValue());
    }

    public static String getCSVString(String string) {
        boolean bl = false;
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ',') {
                bl = true;
            } else if (c == '\"') {
                bl = true;
                string2 = string2 + '\"';
            }
            string2 = string2 + c;
        }
        if (string.startsWith(" ") || string.startsWith("\t") || string.endsWith(" ") || string.endsWith("\t")) {
            bl = true;
        }
        if (bl) {
            string2 = "\"" + string2 + "\"";
        }
        return string2;
    }

    public static List getColorList(String string) {
        String string2 = SGUtilityText.getInnerString(string, 123, 125);
        if (string2 == null) {
            return null;
        }
        ArrayList arrayList = SGUtilityText.getStringListFromCommaSeparatedLine(string2);
        ArrayList<Color> arrayList2 = new ArrayList<Color>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            Color color = SGUtilityText.getColorFromString(string3);
            arrayList2.add(color);
        }
        return arrayList2;
    }

    public static ArrayList getStringListFromCommaSeparatedLine(String string) {
        String string2;
        int n;
        int n2;
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n2 = string.indexOf("(", n3)) < (n = string.indexOf(")", n3)) && (string2 = string.substring(n2, n + 1)) != null) {
            arrayList.add(string2);
            n3 = n + 1;
        }
        return arrayList;
    }

    public static String getFontStyleName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Plain";
                break;
            }
            case 1: {
                string = "Bold";
                break;
            }
            case 2: {
                string = "Italic";
                break;
            }
            case 3: {
                string = "Bold Italic";
                break;
            }
        }
        return string;
    }

    public static int getFontStyle(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = string.toLowerCase();
        int n = string2.equals("Plain".toLowerCase()) ? 0 : (string2.equals("Bold".toLowerCase()) ? 1 : (string2.equals("Italic".toLowerCase()) ? 2 : (string2.equals("Bold Italic".toLowerCase()) ? 3 : -1)));
        return n;
    }

    public static String getScaleTypeName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Linear";
                break;
            }
            case 1: {
                string = "Log";
                break;
            }
        }
        return string;
    }

    public static int getScaleType(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = string.toLowerCase();
        int n = -1;
        if (string2.equals("Linear".toLowerCase())) {
            n = 0;
        } else if (string2.equals("Log".toLowerCase())) {
            n = 1;
        }
        return n;
    }

    public static Document getDocument(String string) {
        Document document = null;
        try {
            URL uRL = new URL(string);
            document = SGUtilityText.getDocument(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static Document getDocument(URL uRL) {
        Document document;
        block16: {
            document = null;
            BufferedInputStream bufferedInputStream = null;
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bufferedInputStream, uRL.toString());
            }
            catch (Exception exception) {
                Document document2 = null;
                Object var6_7 = null;
                try {
                    if (bufferedInputStream != null) {
                        ((InputStream)bufferedInputStream).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return document2;
            }
            Object var6_8 = null;
            try {
                if (bufferedInputStream != null) {
                    ((InputStream)bufferedInputStream).close();
                }
                break block16;
            }
            catch (IOException iOException) {}
            break block16;
            {
                catch (IOException iOException) {
                    Document document3 = null;
                    Object var6_9 = null;
                    try {
                        if (bufferedInputStream != null) {
                            ((InputStream)bufferedInputStream).close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    return document3;
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (bufferedInputStream != null) {
                        ((InputStream)bufferedInputStream).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return document;
    }

    private static Number parse(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string.startsWith("+") && string.length() > 1) {
            string2 = string2.substring(1);
        }
        string2 = string2.toUpperCase();
        string2 = string2.replaceAll("E\\+", "E");
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = NumberFormat.getInstance().parse(string2, parsePosition);
        if (parsePosition.getIndex() != string2.length()) {
            return null;
        }
        return number;
    }

    public static Number getLengthInPoint(String string) {
        return SGUtilityText.getLength(string, "pt");
    }

    public static Number getLength(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        String string3 = string.toLowerCase();
        String[] stringArray = SGUtilityText.getUnitsArrayOfLength();
        for (int i = 0; i < stringArray.length; ++i) {
            Number number;
            if (!string3.endsWith(stringArray[i]) || (number = SGUtilityText.removeUnit(string3, stringArray[i])) == null) continue;
            return new Double(SGUtilityText.convert(number.doubleValue(), stringArray[i], string2));
        }
        return null;
    }

    public static Float getFloat(String string, String string2) {
        Number number = SGUtilityText.removeUnit(string, string2);
        if (number == null) {
            return null;
        }
        return new Float(number.floatValue());
    }

    public static Double getDouble(String string, String string2) {
        Number number = SGUtilityText.removeUnit(string, string2);
        if (number == null) {
            return null;
        }
        return new Double(number.doubleValue());
    }

    public static boolean isValidString(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!(c != ' ' & c != '\u3000' & c != '\t' & c != '\n' & c != '\r' & c != '\f')) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String getSerialName(List list, String string) {
        String string2 = string;
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            String string3 = (String)list.get(i);
            if (!string3.startsWith(string)) continue;
            String string4 = string3.substring(string.length());
            if (string4.startsWith("(") & string4.endsWith(")")) {
                int n2;
                String string5 = string4.substring(1, string4.length() - 1);
                Integer n3 = SGUtilityText.getInteger(string5);
                if (n3 == null || (n2 = n3.intValue()) <= n) continue;
                n = n2;
                continue;
            }
            if (!string4.equals("")) continue;
            n = 0;
        }
        if (n != -1) {
            string2 = string2 + "(" + ++n + ")";
        }
        return string2;
    }

    public static void addAvailableDateFormat(String string) {
        DATE_FORMAT_ARRAY_LIST.add(new SimpleDateFormat(string));
    }

    public static Date getDate(String string) {
        Date date = null;
        ArrayList arrayList = DATE_FORMAT_ARRAY_LIST;
        for (int i = 0; i < arrayList.size(); ++i) {
            DateFormat dateFormat = (DateFormat)arrayList.get(i);
            ParsePosition parsePosition = new ParsePosition(0);
            Date date2 = dateFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length() || date2 == null) continue;
            date = date2;
            break;
        }
        return date;
    }

    public static String[] getUnitsArrayOfLength() {
        return new String[]{"cm", "mm", "pt", "inch"};
    }

    public static boolean isLengthUnit(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String string2 = string.toLowerCase();
        String[] stringArray = SGUtilityText.getUnitsArrayOfLength();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static double convert(double d, String string, String string2) {
        int n;
        String string3;
        if (string == null | string2 == null) {
            throw new IllegalArgumentException();
        }
        if (!SGUtilityText.isLengthUnit(string) | !SGUtilityText.isLengthUnit(string2)) {
            throw new IllegalArgumentException();
        }
        String string4 = string.toLowerCase();
        if (string4.equals(string3 = string2.toLowerCase())) {
            return d;
        }
        String[] stringArray = SGUtilityText.getUnitsArrayOfLength();
        float[] fArray = new float[]{1.0f, 0.1f, 0.035277776f, 2.54f};
        int n2 = -1;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals(string4)) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string3)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        float f = fArray[n2] / fArray[n];
        return d * (double)f;
    }

    public static double convertToPoint(double d, String string) {
        return SGUtilityText.convert(d, string, "pt");
    }

    public static double convertFromPoint(double d, String string) {
        return SGUtilityText.convert(d, "pt", string);
    }

    public static String convertString(String string, String string2) {
        if (string == null | string2 == null) {
            return null;
        }
        if (string.length() == 0 | string2.length() == 0) {
            return null;
        }
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        String[] stringArray = SGUtilityText.getUnitsArrayOfLength();
        String string5 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            string5 = stringArray[i];
            break;
        }
        if (string5 == null) {
            return null;
        }
        Number number = SGUtilityText.removeUnit(string3, string5);
        if (number == null) {
            return null;
        }
        double d = number.doubleValue();
        double d2 = SGUtilityText.convert(d, string5, string4);
        String string6 = Double.toString(d2);
        return string6;
    }

    public static Number removeUnit(String string, String string2) {
        String string3 = SGUtilityText.removeSuffix(string, string2);
        if (string3 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (arrayList.size() != 1) {
            return null;
        }
        String string4 = (String)arrayList.get(0);
        return SGUtilityText.getDouble(string4);
    }

    public static String removeSuffix(String string, String string2) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        if (!string.endsWith(string2)) {
            return string;
        }
        int n2 = -1;
        while ((n = string.indexOf(string2, n2 + 1)) != -1) {
            n2 = n;
        }
        String string3 = string.substring(0, n2);
        if (string3.length() == 0) {
            return null;
        }
        return string3;
    }

    public static Color getColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name==null");
        }
        String string2 = string.toUpperCase();
        Color color = null;
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(string2)) continue;
            color = defaultColors[i];
            break;
        }
        return color;
    }

    public static Color getColor(String string, String string2, String string3) {
        Integer n = SGUtilityText.getInteger(string);
        if (n == null) {
            return null;
        }
        Integer n2 = SGUtilityText.getInteger(string2);
        if (n2 == null) {
            return null;
        }
        Integer n3 = SGUtilityText.getInteger(string3);
        if (n3 == null) {
            return null;
        }
        if (!SGUtilityText.isValidColor(n, n2, n3)) {
            return null;
        }
        return new Color(n, n2, n3);
    }

    private static boolean isValidColor(int n, int n2, int n3) {
        return SGUtilityText.isValidColor(n) & SGUtilityText.isValidColor(n2) & SGUtilityText.isValidColor(n3);
    }

    private static boolean isValidColor(int n) {
        return n >= 0 & n < 256;
    }

    public static final MediaSize getMediaSize(String string) {
        MediaSize mediaSize = null;
        if ("A4".equals(string)) {
            mediaSize = MediaSize.ISO.A4;
        } else if ("A3".equals(string)) {
            mediaSize = MediaSize.ISO.A3;
        } else if ("B5".equals(string)) {
            mediaSize = MediaSize.ISO.B5;
        } else if ("B4".equals(string)) {
            mediaSize = MediaSize.ISO.B4;
        } else if ("US Letter".equals(string)) {
            mediaSize = MediaSize.NA.LETTER;
        }
        return mediaSize;
    }

    public static Dimension getDimension(String string) {
        int[] nArray = SGUtilityText.getIntegerArray(string);
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        if (n != 2) {
            return null;
        }
        if (nArray[0] < 0 | nArray[1] < 0) {
            return null;
        }
        Dimension dimension = new Dimension(nArray[0], nArray[1]);
        return dimension;
    }

    public static Number getNumber(String string, StringBuffer stringBuffer) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase();
        String string3 = null;
        String[] stringArray = SGUtilityText.getUnitsArrayOfLength();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.endsWith(stringArray[i])) continue;
            string3 = stringArray[i];
            break;
        }
        if (string3 == null) {
            return null;
        }
        stringBuffer.append(string3);
        Number number = SGUtilityText.removeUnit(string2, string3);
        if (number == null) {
            return null;
        }
        return new Double(number.doubleValue());
    }

    public static String getBooleanString(String string) {
        String string2 = Boolean.TRUE.toString();
        String string3 = Boolean.FALSE.toString();
        Integer n = SGUtilityText.getInteger(string);
        String string4 = null;
        if (n != null) {
            string4 = string.equals("0") ? string2 : string3;
        } else {
            String string5 = string.toLowerCase();
            if (string5.equals(string2)) {
                string4 = string2;
            } else if (string5.equals(string3)) {
                string4 = string3;
            }
        }
        return string4;
    }

    static {
        String[] stringArray = DEFAULT_DATE_FORMAT_ARRAY;
        for (int i = 0; i < stringArray.length; ++i) {
            SGUtilityText.addAvailableDateFormat(stringArray[i]);
        }
    }
}

