/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class SGCSVTokenizer
implements Enumeration {
    private String record;
    private int currentIndex;
    private static final String DOUBLE_QUATE = "\"";
    private static final String WHITE_SPACE = " \t\n\r\f,";
    private static final String SEPARATOR_COMMA = ",";
    private static final int SEPARATOR_LEN = 1;
    private static final int DOUBLE_QUATE_LEN = 1;
    private ArrayList mWhiteSpaceList = new ArrayList();
    private boolean is_csv_mode = false;
    private boolean is_comment_line = false;

    public SGCSVTokenizer(String string, boolean bl) {
        int n;
        this.record = string.trim();
        this.currentIndex = 0;
        for (n = 0; n < WHITE_SPACE.length(); ++n) {
            this.mWhiteSpaceList.add(new Character(WHITE_SPACE.charAt(n)));
        }
        if (bl && this.record.startsWith("#")) {
            this.is_comment_line = true;
        }
        boolean bl2 = false;
        for (int i = 0; i < this.record.length(); ++i) {
            n = this.record.charAt(i);
            if (bl2) {
                if (n != 34) continue;
                bl2 = false;
                continue;
            }
            if (n == 34) {
                bl2 = true;
                continue;
            }
            if (n != 44) continue;
            this.is_csv_mode = true;
        }
    }

    public boolean hasMoreTokens() {
        if (this.is_comment_line) {
            return false;
        }
        return this.currentIndex >= 0;
    }

    public String nextToken() throws NoSuchElementException, IllegalArgumentException {
        String string = null;
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException();
        }
        if (this.record.startsWith(DOUBLE_QUATE, this.currentIndex)) {
            int n;
            String string2 = this.record.substring(this.currentIndex + 1);
            string = "";
            while (true) {
                if ((n = string2.indexOf(DOUBLE_QUATE)) < 0) {
                    throw new IllegalArgumentException("Illegal format");
                }
                if (!string2.startsWith(DOUBLE_QUATE, n + 1)) break;
                string = string + string2.substring(0, n + 1);
                string2 = string2.substring(n + 2);
                ++this.currentIndex;
            }
            string = string + string2.substring(0, n);
            this.currentIndex += string.length() + 2 + 1;
            if (!this.is_csv_mode) {
                this.currentIndex = this.nextTokenIndexOf(this.currentIndex);
            }
            if (this.currentIndex >= this.record.length()) {
                this.currentIndex = -1;
            }
        } else {
            int n = this.currentIndex;
            int n2 = this.is_csv_mode ? this.record.indexOf(SEPARATOR_COMMA, this.currentIndex) : this.nextSeparatorIndexOf(this.currentIndex);
            if (n2 >= 0) {
                string = this.record.substring(n, n2);
                if (this.is_csv_mode) {
                    this.currentIndex = n2 + 1;
                } else {
                    this.currentIndex = this.nextTokenIndexOf(n2);
                    if (this.currentIndex == this.record.length()) {
                        this.currentIndex = -1;
                    }
                }
            } else {
                string = this.currentIndex == this.record.length() ? "" : this.record.substring(n);
                this.currentIndex = -1;
            }
            string = string.trim();
        }
        return string;
    }

    private int nextSeparatorIndexOf(int n) {
        char c;
        int n2;
        int n3 = 0;
        int n4 = this.record.length();
        if (n4 == n) {
            return -1;
        }
        for (n2 = n; n2 < n4 && !this.mWhiteSpaceList.contains(new Character(c = this.record.charAt(n2))); ++n2) {
            ++n3;
        }
        if (n2 == n4) {
            return -1;
        }
        return n3 + n;
    }

    private int nextTokenIndexOf(int n) {
        char c;
        int n2 = 0;
        int n3 = this.record.length();
        for (int i = n; i < n3 && this.mWhiteSpaceList.contains(new Character(c = this.record.charAt(i))); ++i) {
            ++n2;
        }
        return n2 + n;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public static void main(String[] stringArray) {
        int n = 1;
        String string = "1, \t 2, \"\" 3,  4, \"a,  \"\"\\hoge\"";
        string = "1, \t 2, \"\" 3, b 4, a hoge";
        System.out.println("String : [" + string + "]");
        SGCSVTokenizer sGCSVTokenizer = new SGCSVTokenizer(string, true);
        n = 1;
        while (sGCSVTokenizer.hasMoreTokens()) {
            try {
                String string2 = String.valueOf(n++);
                String string3 = sGCSVTokenizer.nextToken();
                System.out.print(string2 + ": [");
                System.out.println(string3 + "]");
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
                System.exit(-1);
            }
        }
    }
}

