/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Font;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;

public abstract class SGDrawingElementString
extends SGDrawingElement
implements SGIStringConstants,
SGIDrawingElementConstants {
    protected String mString = new String();
    protected Font mFont;
    protected String mFontName;
    protected float mFontSize;
    protected int mFontStyle;
    protected float mX;
    protected float mY;
    protected float mAngle;

    public SGDrawingElementString() {
    }

    public SGDrawingElementString(String string) {
        this.mString = new String(string);
    }

    public SGDrawingElementString(SGDrawingElementString sGDrawingElementString) {
        this.mMagnification = sGDrawingElementString.mMagnification;
        this.mString = new String(sGDrawingElementString.mString);
        this.setFont(sGDrawingElementString.getFontName(), sGDrawingElementString.getFontStyle(), sGDrawingElementString.getFontSize());
        this.mX = sGDrawingElementString.mX;
        this.mY = sGDrawingElementString.mY;
        this.mAngle = sGDrawingElementString.mAngle;
        this.mColorList = new ArrayList(sGDrawingElementString.mColorList);
    }

    public SGDrawingElementString(String string, String string2, int n, float f) {
        this.mString = new String(string);
        this.setFont(string2, n, f);
    }

    public SGDrawingElementString(String string, String string2, int n, float f, float f2, float f3) {
        this.mString = new String(string);
        this.setFont(string2, n, f);
        this.mX = f2;
        this.mY = f3;
    }

    public void dispose() {
        super.dispose();
        this.mFont = null;
        this.mString = null;
        this.mFontName = null;
    }

    public String toString() {
        return this.getString();
    }

    public boolean setString(String string) {
        this.mString = new String(string);
        return true;
    }

    public boolean setMagnification(float f) {
        super.setMagnification(f);
        this.updateFont();
        return true;
    }

    public void setFont(Font font) {
        this.setFont(font.getFamily(), font.getStyle(), font.getSize());
    }

    public void setFontName(String string) {
        this.setFont(string, this.mFontStyle, this.mFontSize);
    }

    public void setFontStyle(int n) {
        this.setFont(this.mFontName, n, this.mFontSize);
    }

    public void setFontSize(float f) {
        this.setFont(this.mFontName, this.mFontStyle, f);
    }

    public boolean setFont(String string, int n, float f) {
        this.mFontName = string;
        this.mFontStyle = n;
        this.mFontSize = f;
        this.updateFont();
        return true;
    }

    private boolean updateFont() {
        this.mFont = new Font(this.mFontName, this.mFontStyle, (int)(this.mMagnification * this.mFontSize));
        return true;
    }

    public boolean setLocation(SGTuple2f sGTuple2f) {
        if (sGTuple2f == null) {
            throw new IllegalArgumentException("pos==null");
        }
        this.setLocation(sGTuple2f.x, sGTuple2f.y);
        return true;
    }

    public boolean setLocation(float f, float f2) {
        this.mX = f;
        this.mY = f2;
        return true;
    }

    public boolean setX(float f) {
        this.setLocation(f, this.getY());
        return true;
    }

    public boolean setY(float f) {
        this.setLocation(this.getX(), f);
        return true;
    }

    public boolean setAngle(float f) {
        this.mAngle = f;
        return true;
    }

    public String getString() {
        return new String(this.mString);
    }

    public float getX() {
        return this.getLocation().x;
    }

    public float getY() {
        return this.getLocation().y;
    }

    public SGTuple2f getLocation() {
        return new SGTuple2f(this.mX, this.mY);
    }

    public String getFontName() {
        return this.mFontName;
    }

    public float getFontSize() {
        return this.mFontSize;
    }

    public int getFontStyle() {
        return this.mFontStyle;
    }

    public float getAngle() {
        return this.mAngle;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementString)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)sGDrawingElement;
        this.setX(sGDrawingElementString.getX());
        this.setY(sGDrawingElementString.getY());
        this.setString(sGDrawingElementString.getString());
        this.setFont(sGDrawingElementString.getFontName(), sGDrawingElementString.getFontStyle(), sGDrawingElementString.getFontSize());
        this.setAngle(sGDrawingElementString.getAngle());
        return true;
    }

    public SGProperties getProperties() {
        StringProperties stringProperties = new StringProperties();
        this.getProperties(stringProperties);
        return stringProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        StringProperties stringProperties = (StringProperties)sGProperties;
        stringProperties.setFontName(this.getFontName());
        stringProperties.setFontSize(this.getFontSize());
        stringProperties.setFontStyle(this.getFontStyle());
        stringProperties.setAngle(this.getAngle());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        StringProperties stringProperties = (StringProperties)sGProperties;
        this.setFont(stringProperties.getFontName(), stringProperties.getFontStyle(), stringProperties.getFontSize().floatValue());
        this.setAngle(stringProperties.getAngle().floatValue());
        return true;
    }

    public void translate(float f, float f2) {
        this.setLocation(this.getX() + f, this.getY() + f2);
    }

    public static class StringProperties
    extends SGDrawingElement.DrawingElementProperties {
        private float mFontSize = 0.0f;
        private int mFontStyle = -1;
        private String mFontName = null;
        private float mAngle = 0.0f;

        public boolean equals(Object object) {
            if (!(object instanceof StringProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            StringProperties stringProperties = (StringProperties)object;
            if (this.mFontSize != stringProperties.mFontSize) {
                return false;
            }
            if (this.mFontStyle != stringProperties.mFontStyle) {
                return false;
            }
            if (!this.mFontName.equals(stringProperties.mFontName)) {
                return false;
            }
            return this.mAngle == stringProperties.mAngle;
        }

        public String getFontName() {
            return this.mFontName;
        }

        public Float getFontSize() {
            return new Float(this.mFontSize);
        }

        public Integer getFontStyle() {
            return new Integer(this.mFontStyle);
        }

        public Float getAngle() {
            return new Float(this.mAngle);
        }

        public boolean setFontName(String string) {
            this.mFontName = string;
            return true;
        }

        public boolean setFontSize(float f) {
            this.mFontSize = f;
            return true;
        }

        public boolean setFontStyle(int n) {
            this.mFontStyle = n;
            return true;
        }

        public boolean setAngle(float f) {
            this.mAngle = f;
            return true;
        }
    }
}

