/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIShapeElement;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGITimingLineDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGTimingLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGTimingLineDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SGTimingLineElement
extends SGFigureElement
implements SGITimingLineElement {
    private SGIAxisElement mAxisElement = null;
    private ArrayList mTimingLineList = new ArrayList();
    private SGTimingLineDialog mDialog = null;
    private int mIDCounter = 0;
    private SGDrawingElementArrow2D mGuideArrow = null;

    public SGTimingLineElement() {
        this.init();
    }

    private void init() {
        SGDrawingElementArrow2D sGDrawingElementArrow2D = new SGDrawingElementArrow2D();
        sGDrawingElementArrow2D.setStartHeadType(-1);
        sGDrawingElementArrow2D.setEndHeadType(10);
        sGDrawingElementArrow2D.setLineWidth(3.0f);
        sGDrawingElementArrow2D.setLineType(1);
        sGDrawingElementArrow2D.setColor(Color.RED);
        sGDrawingElementArrow2D.setHeadSize(12.0f);
        sGDrawingElementArrow2D.setHeadOpenAngle(0.62831855f);
        sGDrawingElementArrow2D.setHeadCloseAngle(1.0471976f);
        sGDrawingElementArrow2D.setVisible(false);
        this.mGuideArrow = sGDrawingElementArrow2D;
    }

    public String toString() {
        return "SGTimingLineEement";
    }

    public String getClassDescription() {
        return "Timing Lines";
    }

    public void setAxisElement(SGIAxisElement sGIAxisElement) {
        this.mAxisElement = sGIAxisElement;
    }

    public void guideToAdd(int n, int n2) {
        float f;
        if (!this.getGraphRect().contains(n, n2)) {
            this.mGuideArrow.setVisible(false);
            this.repaint();
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.getNearestAxisInfo(n, n2, arrayList, arrayList2);
        int n3 = (Integer)arrayList.get(0);
        float f2 = f = ((Number)arrayList2.get(0)).floatValue();
        SGTuple2f sGTuple2f = new SGTuple2f(n, n2);
        SGTuple2f sGTuple2f2 = new SGTuple2f();
        if (n3 == 0) {
            sGTuple2f2.x = n;
            sGTuple2f2.y = (float)n2 + f2;
        } else if (n3 == 1) {
            sGTuple2f2.x = n;
            sGTuple2f2.y = (float)n2 - f2;
        } else if (n3 == 2) {
            sGTuple2f2.x = (float)n - f2;
            sGTuple2f2.y = n2;
        } else if (n3 == 3) {
            sGTuple2f2.x = (float)n + f2;
            sGTuple2f2.y = n2;
        }
        this.mGuideArrow.setTermPoints(sGTuple2f, sGTuple2f2);
        this.mGuideArrow.setVisible(true);
        this.repaint();
    }

    private void getNearestAxisInfo(int n, int n2, ArrayList arrayList, ArrayList arrayList2) {
        int n3;
        float f = this.getGraphRectX();
        float f2 = f + this.getGraphRectWidth();
        float f3 = this.getGraphRectY();
        float f4 = f3 + this.getGraphRectHeight();
        float f5 = (float)n - f;
        float f6 = f2 - (float)n;
        float f7 = (float)n2 - f3;
        float f8 = f4 - (float)n2;
        float[] fArray = new float[]{f5, f6, f7, f8};
        float f9 = Float.MAX_VALUE;
        for (n3 = 0; n3 < fArray.length; ++n3) {
            if (!(fArray[n3] < f9)) continue;
            f9 = fArray[n3];
        }
        n3 = -1;
        if (f9 == f8) {
            n3 = 0;
        } else if (f9 == f7) {
            n3 = 1;
        } else if (f9 == f5) {
            n3 = 2;
        } else if (f9 == f6) {
            n3 = 3;
        }
        arrayList.add(new Integer(n3));
        arrayList2.add(new Float(f9));
    }

    public boolean addTimingLine(int n, int n2) {
        if (!this.getGraphRect().contains(n, n2)) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.getNearestAxisInfo(n, n2, arrayList, arrayList2);
        int n3 = (Integer)arrayList.get(0);
        SGAxis sGAxis = this.mAxisElement.getAxisInPlane(n3);
        double d = this.mAxisElement.getValue(n3, n, n2);
        TimingLine timingLine = new TimingLine();
        timingLine.setAxis(sGAxis);
        timingLine.setValue(d);
        timingLine.setMagnification(this.getMagnification());
        this.addToList(timingLine);
        this.mGuideArrow.setVisible(false);
        this.updateFocusedObjectsList((SGISelectable)timingLine, 0);
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    private void addToList(TimingLine timingLine) {
        timingLine.initDrawingElement(2);
        timingLine.setDrawingElementsLocation();
        timingLine.setPropertiesOfDrawingElements();
        timingLine.initPropertiesHistory();
        this.mTimingLineList.add(timingLine);
        timingLine.mID = this.mIDCounter;
        ++this.mIDCounter;
    }

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createTimingLineDialog();
        return true;
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGILegendElement)) {
            if (sGIFigureElement instanceof SGIAxisElement) {
                SGIAxisElement sGIAxisElement = (SGIAxisElement)sGIFigureElement;
                bl = this.synchronizeToAxisElement(sGIAxisElement);
            } else if (!(sGIFigureElement instanceof SGIStringElement || sGIFigureElement instanceof SGIGraphElement || sGIFigureElement instanceof SGIAxisBreakElement || sGIFigureElement instanceof SGISignificantDifferenceElement || sGIFigureElement instanceof SGITimingLineElement || sGIFigureElement instanceof SGIGridElement || sGIFigureElement instanceof SGIShapeElement)) {
                bl = this.synchronizeArgument(sGIFigureElement);
            }
        }
        return bl;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error();
    }

    public boolean updateHistory() {
        return this.updateHistory(this.getVisibleTimingElementList());
    }

    public SGProperties getProperties() {
        TimingElementProperties timingElementProperties = new TimingElementProperties();
        if (!this.getProperties(timingElementProperties)) {
            return null;
        }
        return timingElementProperties;
    }

    public String getTagName() {
        return "TimingLines";
    }

    public boolean writeProperty(Element element) {
        return true;
    }

    public boolean readProperty(Element element) {
        NodeList nodeList = element.getElementsByTagName("TimingLine");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            TimingLine timingLine = new TimingLine();
            Element element2 = (Element)node;
            if (!timingLine.readProperty(element2)) {
                return false;
            }
            this.addToList(timingLine);
        }
        return true;
    }

    public Element createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        ArrayList arrayList = this.getVisibleTimingElementList();
        for (int i = 0; i < arrayList.size(); ++i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            if (!timingLine.isValid()) continue;
            Element element2 = timingLine.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        return element;
    }

    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        ArrayList arrayList = this.getVisibleTimingElementList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            if (!sGIUndoable.isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean zoom(float f) {
        super.zoom(f);
        ArrayList arrayList = this.mTimingLineList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGTimingLine sGTimingLine = (SGTimingLine)arrayList.get(i);
            sGTimingLine.zoom(f);
        }
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        return this.setAllDrawingElementsLocation();
    }

    private boolean calcLocationOfTimingLine(double d, SGAxis sGAxis, boolean bl, SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        float f = this.calcLocation(d, sGAxis, bl);
        if (Float.isNaN(f)) {
            return false;
        }
        Rectangle2D rectangle2D = this.getGraphRect();
        if (bl) {
            sGTuple2f.x = f;
            sGTuple2f.y = (float)rectangle2D.getY();
            sGTuple2f2.x = f;
            sGTuple2f2.y = sGTuple2f.y + (float)rectangle2D.getHeight();
        } else {
            sGTuple2f.x = (float)rectangle2D.getX();
            sGTuple2f.y = f;
            sGTuple2f2.x = sGTuple2f.x + (float)rectangle2D.getWidth();
            sGTuple2f2.y = f;
        }
        return true;
    }

    private boolean createTimingLineDialog() {
        SGTimingLineDialog sGTimingLineDialog;
        this.mDialog = sGTimingLineDialog = new SGTimingLineDialog(this.mDialogOwner, true);
        return true;
    }

    private ArrayList getVisibleTimingElementListInside() {
        ArrayList<SGTimingLine> arrayList = new ArrayList<SGTimingLine>();
        ArrayList arrayList2 = this.getVisibleTimingElementList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGTimingLine sGTimingLine = (SGTimingLine)arrayList2.get(i);
            if (!this.isInsideRange(sGTimingLine)) continue;
            arrayList.add(sGTimingLine);
        }
        return arrayList;
    }

    private ArrayList getVisibleTimingElementList() {
        ArrayList<SGTimingLine> arrayList = new ArrayList<SGTimingLine>();
        ArrayList arrayList2 = this.mTimingLineList;
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGTimingLine sGTimingLine = (SGTimingLine)arrayList2.get(i);
            if (!sGTimingLine.isVisible()) continue;
            arrayList.add(sGTimingLine);
        }
        return arrayList;
    }

    public ArrayList getChildNodes() {
        return this.getVisibleTimingElementList();
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        ArrayList arrayList2 = this.getVisibleTimingElementListInside();
        for (int i = 0; i < arrayList2.size(); ++i) {
            TimingLine timingLine = (TimingLine)arrayList2.get(i);
            if (!timingLine.isSelected()) continue;
            arrayList.add(timingLine);
        }
        return true;
    }

    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        TimingLine timingLine = (TimingLine)sGISelectable;
        timingLine.setVisible(false);
        return true;
    }

    private boolean isInsideRange(SGTimingLine sGTimingLine) {
        SGAxis sGAxis = sGTimingLine.mAxis;
        double d = sGTimingLine.mValue;
        return sGAxis.insideRange(d);
    }

    protected boolean setVisibleTimingElements(ArrayList arrayList) {
        int n;
        ArrayList arrayList2 = new ArrayList(arrayList);
        ArrayList<SGTimingLine> arrayList3 = new ArrayList<SGTimingLine>();
        ArrayList arrayList4 = this.mTimingLineList;
        for (n = 0; n < arrayList4.size(); ++n) {
            SGTimingLine sGTimingLine = (SGTimingLine)arrayList4.get(n);
            boolean bl = arrayList.contains(sGTimingLine);
            sGTimingLine.setVisible(bl);
            if (bl) continue;
            arrayList3.add(sGTimingLine);
        }
        arrayList4.clear();
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList4.add(arrayList2.get(n));
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            arrayList4.add(arrayList3.get(n));
        }
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getVisibleTimingElementListInside();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            if (!timingLine.isValid() || !this.clickDrawingElements(timingLine, mouseEvent)) continue;
            return true;
        }
        return false;
    }

    private boolean clickDrawingElements(TimingLine timingLine, MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        if (timingLine.contains(n, n2)) {
            if (n3 == 1) {
                this.updateFocusedObjectsList((SGISelectable)timingLine, mouseEvent);
                if (!SwingUtilities.isLeftMouseButton(mouseEvent) && SwingUtilities.isRightMouseButton(mouseEvent)) {
                    timingLine.getPopupMenu().show(this.getComponent(), n, n2);
                }
            } else if (n3 == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.setPropertiesOfSelectedObjects();
            }
            return true;
        }
        return false;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        ArrayList arrayList = this.getVisibleTimingElementListInside();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            if (!timingLine.isValid() || !timingLine.contains(n, n2)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        return true;
    }

    public boolean onDrawingElement(int n, int n2) {
        ArrayList arrayList = this.getVisibleTimingElementListInside();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            boolean bl;
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            if (!timingLine.isValid() || !(bl = timingLine.contains(n, n2))) continue;
            this.setMouseCursor(12);
            return true;
        }
        return false;
    }

    public ArrayList getPropertyDialogObserverList() {
        return this.getFocusedObjectsList();
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            timingLine.mTemporaryProperties = timingLine.getProperties();
        }
        return true;
    }

    public boolean setChangedFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGProperties sGProperties;
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            SGProperties sGProperties2 = timingLine.mTemporaryProperties;
            if (sGProperties2 == null || (sGProperties = timingLine.getProperties()).equals(sGProperties2)) continue;
            timingLine.setChanged(true);
        }
        return true;
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        Object object;
        TimingLine timingLine;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        ArrayList arrayList = this.getVisibleTimingElementListInside();
        Rectangle2D rectangle2D = this.getGraphRect();
        if (this.mGuideArrow.isVisible()) {
            this.mGuideArrow.paint(graphics2D, rectangle2D);
        }
        if (bl) {
            SGUtilityForFigureElement.clipGraphRect(this, graphics2D);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            timingLine = (TimingLine)arrayList.get(n);
            if (!timingLine.isValid()) continue;
            if (bl) {
                timingLine.paintElement(graphics2D);
                continue;
            }
            timingLine.paintElement(graphics2D, rectangle2D);
        }
        if (bl) {
            graphics2D.setClip(this.getViewBounds());
        }
        if (this.mSymbolsVisibleFlagAroundAllObjects) {
            for (n = 0; n < arrayList.size(); ++n) {
                timingLine = (TimingLine)arrayList.get(n);
                if (!timingLine.isValid()) continue;
                object = timingLine.getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsChildObject((ArrayList)object, graphics2D);
            }
        }
        if (this.mSymbolsVisibleFlagAroundFocusedObjects) {
            ArrayList arrayList2 = new ArrayList();
            this.getFocusedObjectsList(arrayList2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                object = (TimingLine)arrayList2.get(i);
                if (!((TimingLine)object).isValid()) continue;
                ArrayList arrayList3 = ((TimingLine)object).getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsFocusedObject(arrayList3, graphics2D);
            }
        }
    }

    public boolean moveFocusedObjects(boolean bl) {
        return this.moveFocusedObjects(bl, this.mTimingLineList);
    }

    protected boolean hideTimingElementGroupSet(SGTimingLine sGTimingLine) {
        sGTimingLine.setVisible(false);
        this.notifyChange();
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    protected boolean removeTimingElementGroupSet(SGTimingLine sGTimingLine) {
        this.mTimingLineList.remove(sGTimingLine);
        return false;
    }

    protected boolean synchronizeToAxisElement(SGIAxisElement sGIAxisElement) {
        return this.setAllDrawingElementsLocation();
    }

    protected boolean setAllDrawingElementsLocation() {
        ArrayList arrayList = this.getVisibleTimingElementList();
        for (int i = 0; i < arrayList.size(); ++i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            if (timingLine.setDrawingElementsLocation()) continue;
            return false;
        }
        return true;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof TimingElementProperties)) {
            return false;
        }
        TimingElementProperties timingElementProperties = (TimingElementProperties)sGProperties;
        timingElementProperties.visibleTimingElementList = this.getVisibleTimingElementList();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof TimingElementProperties)) {
            return false;
        }
        TimingElementProperties timingElementProperties = (TimingElementProperties)sGProperties;
        boolean bl = this.setVisibleTimingElements(timingElementProperties.visibleTimingElementList);
        return bl;
    }

    public boolean duplicateFocusedObjects() {
        int n = (int)(this.mMagnification * 10.0f);
        int n2 = (int)(this.mMagnification * 10.0f);
        ArrayList arrayList = this.duplicateObjects();
        for (int i = 0; i < arrayList.size(); ++i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            timingLine.translate(n, n2);
            timingLine.setSelected(true);
            this.addToList(timingLine);
        }
        if (arrayList.size() != 0) {
            this.setChanged(true);
        }
        return true;
    }

    public boolean paste(ArrayList arrayList) {
        float f = this.getMagnification();
        int n = (int)(f * 10.0f);
        int n2 = (int)(f * 10.0f);
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof TimingLine)) continue;
            TimingLine timingLine = (TimingLine)e;
            timingLine.translate(n, n2);
            SGProperties sGProperties = timingLine.getProperties();
            TimingLine timingLine2 = new TimingLine();
            timingLine2.setMagnification(f);
            timingLine2.setProperties(sGProperties);
            timingLine2.mAxis = this.mAxisElement.getAxisInCube(timingLine.mTempAxis);
            this.addToList(timingLine2);
            timingLine2.initPropertiesHistory();
            ++n3;
        }
        if (n3 != 0) {
            this.setChanged(true);
        }
        return true;
    }

    public static class TimingElementProperties
    extends SGProperties {
        ArrayList visibleTimingElementList = new ArrayList();

        public boolean equals(Object object) {
            if (!(object instanceof TimingElementProperties)) {
                return false;
            }
            TimingElementProperties timingElementProperties = (TimingElementProperties)object;
            return timingElementProperties.visibleTimingElementList.equals(this.visibleTimingElementList);
        }

        public String toString() {
            String string = new String("[");
            string = string + this.visibleTimingElementList.toString();
            string = string + new String("]");
            return string;
        }
    }

    class TimingLine
    extends SGTimingLine
    implements ActionListener,
    SGIUndoable,
    SGISelectable,
    SGICopiable,
    SGIMovable,
    SGITimingLineDialogObserver,
    SGINode {
        private int mID;
        private boolean mSelectedFlag = false;
        private SGProperties mTemporaryProperties = null;
        private JPopupMenu mPopupMenu = new JPopupMenu();
        private boolean mValidFlag = true;
        private SGUndoManager mUndoManager = new SGUndoManager(this);
        private boolean mChangedFlag = false;
        public static final String TAG_NAME_TIMING_LINE = "TimingLine";
        private int mTempAxis = -1;

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
        }

        public Color getColor() {
            return this.getColor(0);
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getProperties();
            return true;
        }

        protected TimingLine() {
            this.init();
        }

        private boolean init() {
            this.setLineWidth(1.0f);
            Integer n = SGDrawingElementLine.getLineTypeFromName("Solid");
            if (n == null) {
                return false;
            }
            this.setLineType(n);
            this.setColor(SGDefaultValues.TIMING_LINE_COLOR);
            this.createPopupMenu();
            return true;
        }

        public String getClassDescription() {
            return "";
        }

        public String getInstanceDescription() {
            String string = "";
            string = string + this.mID + ": ";
            String string2 = SGTimingLineElement.this.mAxisElement.getAxisLocation(this.mAxis);
            string = string + string2 + ", ";
            String string3 = this.isHorizontal() ? "X" : "Y";
            string = string + string3 + "=" + this.getValue();
            return string;
        }

        private ArrayList getAnchorPointList() {
            ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
            Point2D.Float float_ = new Point2D.Float();
            Point2D.Float float_2 = new Point2D.Float();
            boolean bl = this.isHorizontal();
            float f = SGTimingLineElement.this.calcLocation(this.mValue, this.mAxis, bl);
            Rectangle2D rectangle2D = SGTimingLineElement.this.getGraphRect();
            if (bl) {
                float f2 = (float)rectangle2D.getY();
                float f3 = f2 + (float)rectangle2D.getHeight();
                ((Point2D)float_).setLocation(f, f2);
                ((Point2D)float_2).setLocation(f, f3);
            } else {
                float f4 = (float)rectangle2D.getX();
                float f5 = f4 + (float)rectangle2D.getWidth();
                ((Point2D)float_).setLocation(f4, f);
                ((Point2D)float_2).setLocation(f5, f);
            }
            arrayList.add(float_);
            arrayList.add(float_2);
            return arrayList;
        }

        private boolean createPopupMenu() {
            JPopupMenu jPopupMenu = this.mPopupMenu;
            jPopupMenu.setBounds(0, 0, 100, 100);
            jPopupMenu.add(new JLabel("  -- Timing Line --"));
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Move to Front");
            SGUtility.addItem(jPopupMenu, this, "Move to Back");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Cut");
            SGUtility.addItem(jPopupMenu, this, "Copy");
            SGUtility.addItem(jPopupMenu, this, "Paste");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Delete");
            SGUtility.addItem(jPopupMenu, this, "Duplicate");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Property");
            return true;
        }

        public JPopupMenu getPopupMenu() {
            return this.mPopupMenu;
        }

        public int getAxisConfiguration() {
            return SGTimingLineElement.this.mAxisElement.getConfigurationInPlane(this.mAxis);
        }

        public void setAxisConfiguration(int n) {
            SGAxis sGAxis;
            SGIAxisElement sGIAxisElement = SGTimingLineElement.this.mAxisElement;
            this.mAxis = sGAxis = sGIAxisElement.getAxisInPlane(n);
        }

        private boolean setDrawingElementsLocation() {
            SGAxis sGAxis = this.mAxis;
            double d = this.mValue;
            boolean bl = this.isHorizontal();
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[]{new SGTuple2f(), new SGTuple2f()};
            if (!SGTimingLineElement.this.calcLocationOfTimingLine(d, sGAxis, bl, sGTuple2fArray[0], sGTuple2fArray[1])) {
                this.setValid(false);
                return false;
            }
            this.setValid(true);
            return this.setLocation(sGTuple2fArray);
        }

        public boolean isValid() {
            return this.mValidFlag;
        }

        public void setValid(boolean bl) {
            this.mValidFlag = bl;
        }

        public void translate(float f, float f2) {
            SGAxis sGAxis = this.mAxis;
            boolean bl = this.isHorizontal();
            float f3 = SGTimingLineElement.this.calcLocation(this.getValue(), sGAxis, bl);
            float f4 = this.isHorizontal() ? f3 + f : f3 + f2;
            double d = SGTimingLineElement.this.calcValue(f4, sGAxis, bl);
            d = SGTimingLineElement.this.getNumberInRangeOrder(d, sGAxis);
            this.setValue(d);
        }

        private boolean isHorizontal() {
            ArrayList arrayList = SGTimingLineElement.this.mAxisElement.getHorizontalAxisList();
            ArrayList arrayList2 = SGTimingLineElement.this.mAxisElement.getPerpendicularAxisList();
            Boolean bl = null;
            if (arrayList.contains(this.mAxis)) {
                bl = Boolean.TRUE;
            }
            if (arrayList2.contains(this.mAxis)) {
                bl = Boolean.FALSE;
            }
            if (bl == null) {
                throw new Error("");
            }
            return bl;
        }

        public boolean hasValidValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mAxis : SGTimingLineElement.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getValue();
            return sGAxis.isValidValue(d);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Property")) {
                SGTimingLineElement.this.setPropertiesOfSelectedObjects();
            } else if (string.equals("Copy") | string.equals("Cut") | string.equals("Paste") | string.equals("Delete") | string.equals("Duplicate") | string.equals("Move to Front") | string.equals("Move to Back")) {
                SGTimingLineElement.this.notifyToListener(string);
            }
        }

        public boolean commit() {
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.setChanged(true);
            }
            this.mTemporaryProperties = null;
            this.setDrawingElementsLocation();
            SGTimingLineElement.this.repaint();
            SGTimingLineElement.this.notifyChange();
            return true;
        }

        public boolean cancel() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.setDrawingElementsLocation();
            SGTimingLineElement.this.repaint();
            SGTimingLineElement.this.notifyChange();
            return true;
        }

        public boolean preview() {
            this.setDrawingElementsLocation();
            SGTimingLineElement.this.repaint();
            SGTimingLineElement.this.notifyChange();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            return SGTimingLineElement.this.mDialog;
        }

        public ArrayList getChildNodes() {
            return new ArrayList();
        }

        public SGProperties getMemento() {
            return this.getProperties();
        }

        public boolean setMemento(SGProperties sGProperties) {
            return this.setProperties(sGProperties);
        }

        public boolean isUndoable() {
            return this.mUndoManager.isUndoable();
        }

        public boolean isRedoable() {
            return this.mUndoManager.isRedoable();
        }

        public boolean initPropertiesHistory() {
            return this.mUndoManager.initPropertiesHistory();
        }

        public boolean setMementoBackward() {
            if (!this.mUndoManager.setMementoBackward()) {
                return false;
            }
            SGTimingLineElement.this.setAllDrawingElementsLocation();
            SGTimingLineElement.this.notifyChange();
            return true;
        }

        public boolean setMementoForward() {
            if (!this.mUndoManager.setMementoForward()) {
                return false;
            }
            SGTimingLineElement.this.setAllDrawingElementsLocation();
            SGTimingLineElement.this.notifyChange();
            return true;
        }

        public boolean undo() {
            return this.setMementoBackward();
        }

        public boolean redo() {
            return this.setMementoForward();
        }

        public boolean updateHistory() {
            return this.mUndoManager.updateHistory();
        }

        public void notifyToRoot() {
            SGTimingLineElement.this.notifyToRoot();
        }

        public boolean isChanged() {
            return this.mChangedFlag;
        }

        public void setChanged(boolean bl) {
            this.mChangedFlag = bl;
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public String getTagName() {
            return TAG_NAME_TIMING_LINE;
        }

        public boolean writeProperty(Element element) {
            element.setAttribute("AxisPosition", SGTimingLineElement.this.mAxisElement.getAxisLocation(this.mAxis));
            element.setAttribute("Value", Double.toString(this.mValue));
            element.setAttribute("Width", Float.toString(this.mLineWidth) + "pt");
            element.setAttribute("Type", SGDrawingElementLine.getLineTypeName(this.mLineType));
            element.setAttribute("Color", SGUtilityText.getColorListString(this.mColorList));
            return true;
        }

        public boolean readProperties(Element element, SGProperties sGProperties) {
            if (!(sGProperties instanceof SGTimingLine.TimingLineProperties)) {
                return false;
            }
            SGTimingLine.TimingLineProperties timingLineProperties = (SGTimingLine.TimingLineProperties)sGProperties;
            String string = null;
            Number number = null;
            Object var9_6 = null;
            Object var10_7 = null;
            ArrayList arrayList = null;
            string = element.getAttribute("Width");
            if (string.length() == 0) {
                return false;
            }
            number = SGUtilityText.getDouble(string, "pt");
            if (number == null) {
                return false;
            }
            timingLineProperties.setLineWidth(number.floatValue());
            string = element.getAttribute("Type");
            if (string.length() == 0) {
                return false;
            }
            number = SGDrawingElementLine.getLineTypeFromName(string);
            if (number == null) {
                return false;
            }
            timingLineProperties.setLineType(number.intValue());
            string = element.getAttribute("Color");
            if (string.length() == 0) {
                return false;
            }
            arrayList = SGUtilityText.getColorList(string);
            if (arrayList == null) {
                return false;
            }
            timingLineProperties.setColorList(arrayList);
            string = element.getAttribute("Value");
            if (string.length() == 0) {
                return false;
            }
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            timingLineProperties.setValue(number.doubleValue());
            string = element.getAttribute("AxisPosition");
            if (string.length() == 0) {
                return false;
            }
            int n = SGTimingLineElement.this.mAxisElement.getConfigurationInCube(string);
            SGAxis sGAxis = SGTimingLineElement.this.mAxisElement.getAxisInCube(n);
            if (sGAxis == null) {
                return false;
            }
            timingLineProperties.setAxis(sGAxis);
            timingLineProperties.setVisible(true);
            return true;
        }

        public Object copy() {
            TimingLine timingLine = new TimingLine();
            timingLine.setMagnification(this.mMagnification);
            timingLine.setProperties(this.getProperties());
            timingLine.mTempAxis = SGTimingLineElement.this.mAxisElement.getConfigurationInCube(this.mAxis);
            return timingLine;
        }
    }
}

