/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;

public class SGDrawingElementString2DExtended
extends SGDrawingElementString2D {
    private final ArrayList mBaseElementList = new ArrayList();
    private final ArrayList mSubscriptElementList = new ArrayList();
    private final ArrayList mSuperscriptElementList = new ArrayList();

    public SGDrawingElementString2DExtended() {
        this.createStringElements();
    }

    public SGDrawingElementString2DExtended(String string) {
        super(string);
        this.createStringElements();
    }

    public SGDrawingElementString2DExtended(SGDrawingElementString sGDrawingElementString) {
        super(sGDrawingElementString);
        this.createStringElements();
    }

    public SGDrawingElementString2DExtended(String string, String string2, int n, float f) {
        super(string, string2, n, f);
        this.createStringElements();
    }

    public SGDrawingElementString2DExtended(String string, String string2, int n, float f, float f2, float f3) {
        super(string, string2, n, f, f2, f3);
        this.createStringElements();
    }

    public boolean containsSuperscripts() {
        return this.mString.indexOf("^") != -1;
    }

    public boolean containsSubscripts() {
        return this.mString.indexOf("_") != -1;
    }

    public boolean containsSubscriptsOrSuperscripts() {
        return this.containsSubscripts() | this.containsSuperscripts();
    }

    protected ArrayList getAllStringElement() {
        ArrayList arrayList = new ArrayList();
        if (this.mBaseElementList != null) {
            arrayList.addAll(this.mBaseElementList);
        }
        if (this.mSubscriptElementList != null) {
            arrayList.addAll(this.mSubscriptElementList);
        }
        if (this.mSuperscriptElementList != null) {
            arrayList.addAll(this.mSuperscriptElementList);
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Object e = arrayList.get(i);
            if (e != null) continue;
            arrayList.remove(i);
        }
        return arrayList;
    }

    public boolean setMagnification(float f) {
        super.setMagnification(f);
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)arrayList.get(i);
            sGDrawingElementString.setMagnification(f);
        }
        this.updateLocation();
        return true;
    }

    public boolean setColor(ArrayList arrayList) {
        super.setColor(arrayList);
        ArrayList arrayList2 = this.getAllStringElement();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)arrayList2.get(i);
            sGDrawingElementString.setColor(arrayList);
        }
        return true;
    }

    public boolean setColor(Color color) {
        super.setColor(color);
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)arrayList.get(i);
            sGDrawingElementString.setColor(color);
        }
        return true;
    }

    public boolean addColor(Color color) {
        super.addColor(color);
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)arrayList.get(i);
            sGDrawingElementString.addColor(color);
        }
        return true;
    }

    public boolean setLocation(float f, float f2) {
        float f3 = f - this.getX();
        float f4 = f2 - this.getY();
        super.setLocation(f, f2);
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.translate(f3, f4);
        }
        return true;
    }

    public boolean setFont(String string, int n, float f) {
        super.setFont(string, n, f);
        if (this.mBaseElementList == null) {
            return true;
        }
        Font font = new Font(string, n, (int)f);
        Font font2 = new Font(string, n, (int)(f / 2.0f));
        ArrayList arrayList = this.mBaseElementList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)arrayList.get(i);
            sGDrawingElementString.setFont(font);
        }
        ArrayList arrayList2 = this.mSubscriptElementList;
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)arrayList2.get(i);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.setFont(font2);
        }
        ArrayList arrayList3 = this.mSuperscriptElementList;
        for (int i = 0; i < arrayList3.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)arrayList3.get(i);
            if (sGDrawingElementString == null) continue;
            sGDrawingElementString.setFont(font2);
        }
        this.updateLocation();
        return true;
    }

    public boolean setString(String string) {
        super.setString(string);
        this.createStringElements();
        this.updateLocation();
        return true;
    }

    public boolean setAngle(float f) {
        super.setAngle(f);
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)arrayList.get(i);
            sGDrawingElementString.setAngle(f);
        }
        this.updateLocation();
        return true;
    }

    private boolean createStringElementsDirectly() {
        SGDrawingElementString2D sGDrawingElementString2D = new SGDrawingElementString2D(this.mString);
        this.mBaseElementList.add(sGDrawingElementString2D);
        this.mSubscriptElementList.add(null);
        this.mSuperscriptElementList.add(null);
        this.setPropertiesToAllStringElements();
        return true;
    }

    private boolean createStringElements() {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        this.mBaseElementList.clear();
        this.mSubscriptElementList.clear();
        this.mSuperscriptElementList.clear();
        if (!this.containsSubscriptsOrSuperscripts()) {
            return this.createStringElementsDirectly();
        }
        String string = this.getString();
        if (!SGUtilityText.getSubscriptAndSuperscriptInfo(string, arrayList3 = new ArrayList(), arrayList2 = new ArrayList(), arrayList = new ArrayList())) {
            return this.createStringElementsDirectly();
        }
        if (arrayList3.size() != arrayList2.size() || arrayList2.size() != arrayList.size()) {
            return this.createStringElementsDirectly();
        }
        for (int i = 0; i < arrayList3.size(); ++i) {
            Object object;
            Character c = (Character)arrayList3.get(i);
            Object object2 = new SGDrawingElementString2D(c.toString());
            this.mBaseElementList.add(object2);
            c = arrayList.get(i);
            if (c != null) {
                object2 = (String)((Object)c);
                object = new SGDrawingElementString2DExtended((String)object2);
                this.mSubscriptElementList.add(object);
            } else {
                this.mSubscriptElementList.add(null);
            }
            object2 = arrayList2.get(i);
            if (object2 != null) {
                object = (String)object2;
                SGDrawingElementString2DExtended sGDrawingElementString2DExtended = new SGDrawingElementString2DExtended((String)object);
                this.mSuperscriptElementList.add(sGDrawingElementString2DExtended);
                continue;
            }
            this.mSuperscriptElementList.add(null);
        }
        this.setPropertiesToAllStringElements();
        return true;
    }

    private boolean setPropertiesToAllStringElements() {
        float f = this.getMagnification();
        ArrayList arrayList = this.getColorList();
        float f2 = this.getFontSize();
        String string = this.getFontName();
        int n = this.getFontStyle();
        float f3 = this.getAngle();
        ArrayList arrayList2 = this.mBaseElementList;
        ArrayList arrayList3 = this.mSubscriptElementList;
        ArrayList arrayList4 = this.mSuperscriptElementList;
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D;
            SGDrawingElementString2D sGDrawingElementString2D2 = (SGDrawingElementString2D)arrayList2.get(i);
            sGDrawingElementString2D2.setMagnification(f);
            sGDrawingElementString2D2.setColor(arrayList);
            sGDrawingElementString2D2.setFont(string, n, f2);
            sGDrawingElementString2D2.setAngle(f3);
            sGDrawingElementString2D2 = (SGDrawingElementString2D)arrayList3.get(i);
            if (sGDrawingElementString2D2 != null) {
                this.setSubAndSuper(sGDrawingElementString2D2, f, string, n, f2, f3, arrayList);
            }
            if ((sGDrawingElementString2D = (SGDrawingElementString2D)arrayList4.get(i)) == null) continue;
            this.setSubAndSuper(sGDrawingElementString2D, f, string, n, f2, f3, arrayList);
        }
        return true;
    }

    private void setSubAndSuper(SGDrawingElementString2D sGDrawingElementString2D, float f, String string, int n, float f2, float f3, ArrayList arrayList) {
        sGDrawingElementString2D.setMagnification(f);
        sGDrawingElementString2D.setColor(arrayList);
        sGDrawingElementString2D.setFont(string, n, f2 / 2.0f);
        sGDrawingElementString2D.setAngle(f3);
        if (sGDrawingElementString2D instanceof SGDrawingElementString2DExtended) {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)sGDrawingElementString2D;
            sGDrawingElementString2DExtended.setPropertiesToAllStringElements();
        }
    }

    public Rectangle2D getStringRect() {
        float f = 0.0f;
        float f2 = 0.0f;
        ArrayList arrayList = this.mBaseElementList;
        ArrayList arrayList2 = this.mSubscriptElementList;
        ArrayList arrayList3 = this.mSuperscriptElementList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D;
            SGDrawingElementString2D sGDrawingElementString2D2 = (SGDrawingElementString2D)arrayList.get(i);
            Rectangle2D rectangle2D = sGDrawingElementString2D2.getStringRect();
            f += (float)rectangle2D.getWidth();
            f2 = (float)rectangle2D.getHeight();
            sGDrawingElementString2D2 = arrayList2.get(i);
            float f3 = 0.0f;
            if (sGDrawingElementString2D2 != null) {
                sGDrawingElementString2D = sGDrawingElementString2D2;
                Rectangle2D rectangle2D2 = sGDrawingElementString2D.getStringRect();
                f3 += (float)rectangle2D2.getWidth();
            }
            sGDrawingElementString2D = arrayList3.get(i);
            float f4 = 0.0f;
            if (sGDrawingElementString2D != null) {
                SGDrawingElementString2D sGDrawingElementString2D3 = sGDrawingElementString2D;
                Rectangle2D rectangle2D3 = sGDrawingElementString2D3.getStringRect();
                f4 += (float)rectangle2D3.getWidth();
            }
            if (sGDrawingElementString2D == null && sGDrawingElementString2D2 == null) continue;
            f += Math.max(f4, f3);
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
        return float_;
    }

    public Rectangle2D getElementBounds() {
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        ArrayList arrayList2 = this.getAllStringElement();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList2.get(i);
            arrayList.add(sGDrawingElementString2D.getElementBounds());
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        return rectangle2D;
    }

    protected boolean updateStringRect() {
        super.updateStringRect();
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.updateStringRect();
        }
        return true;
    }

    protected boolean updateLocation() {
        float f = this.getAngle();
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        float f4 = this.getX();
        float f5 = this.getY();
        ArrayList arrayList = this.mBaseElementList;
        ArrayList arrayList2 = this.mSubscriptElementList;
        ArrayList arrayList3 = this.mSuperscriptElementList;
        float f6 = 0.0f;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D;
            SGDrawingElementString2D sGDrawingElementString2D2;
            SGDrawingElementString2D sGDrawingElementString2D3 = (SGDrawingElementString2D)arrayList.get(i);
            Rectangle2D rectangle2D = sGDrawingElementString2D3.getStringRect();
            sGDrawingElementString2D3.setLocation(f4 + f6 * f2, f5 - f6 * f3);
            f6 += (float)rectangle2D.getWidth();
            sGDrawingElementString2D3 = arrayList3.get(i);
            float f7 = 0.0f;
            if (sGDrawingElementString2D3 != null) {
                sGDrawingElementString2D2 = sGDrawingElementString2D3;
                Rectangle2D rectangle2D2 = sGDrawingElementString2D2.getStringRect();
                sGDrawingElementString2D2.setLocation(f4 + f6 * f2, f5 - f6 * f3);
                if (sGDrawingElementString2D2 instanceof SGDrawingElementString2DExtended) {
                    sGDrawingElementString2D = (SGDrawingElementString2DExtended)sGDrawingElementString2D2;
                    ((SGDrawingElementString2DExtended)sGDrawingElementString2D).updateLocation();
                }
                f7 += (float)rectangle2D2.getWidth();
            }
            sGDrawingElementString2D2 = arrayList2.get(i);
            float f8 = 0.0f;
            if (sGDrawingElementString2D2 != null) {
                sGDrawingElementString2D = sGDrawingElementString2D2;
                Rectangle2D rectangle2D3 = sGDrawingElementString2D.getStringRect();
                float f9 = (float)rectangle2D3.getHeight();
                sGDrawingElementString2D.setLocation(f4 + f6 * f2 + f9 * f3, f5 - f6 * f3 + f9 * f2);
                if (sGDrawingElementString2D instanceof SGDrawingElementString2DExtended) {
                    SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)sGDrawingElementString2D;
                    sGDrawingElementString2DExtended.updateLocation();
                }
                f8 += (float)rectangle2D3.getWidth();
            }
            if (!(sGDrawingElementString2D3 != null | sGDrawingElementString2D2 != null)) continue;
            f6 += Math.max(f7, f8);
        }
        return true;
    }

    public void paintElement(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.paintElement(graphics2D);
        }
    }
}

