/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public abstract class SGDateData
extends SGData
implements Cloneable {
    protected InnerDate[] mDateArray = null;

    public SGDateData() {
    }

    public SGDateData(String[] stringArray) throws ParseException {
        DateFormat dateFormat = DateFormat.getDateInstance();
        Calendar calendar = Calendar.getInstance();
        int n = stringArray.length;
        InnerDate[] innerDateArray = new InnerDate[n];
        for (int i = 0; i < n; ++i) {
            Date date = SGUtilityText.getDate(stringArray[i]);
            if (date == null) {
                throw new ParseException("Parse error", 0);
            }
            calendar.setTime(date);
            int n2 = calendar.get(1);
            int n3 = calendar.get(2);
            int n4 = calendar.get(5);
            innerDateArray[i] = new InnerDate(n2, n3, n4);
        }
        this.mDateArray = innerDateArray;
    }

    public SGDateData(int[] nArray, int[] nArray2, int[] nArray3) {
        if (nArray == null | nArray2 == null | nArray3 == null) {
            throw new IllegalArgumentException("yearArray==null | monthArray==null | dateArray==null");
        }
        if (nArray.length != nArray2.length | nArray2.length != nArray3.length) {
            throw new IllegalArgumentException("yearArray.length!=monthArray.length | monthArray.length!=dateArray.length");
        }
        int n = nArray.length;
        InnerDate[] innerDateArray = new InnerDate[n];
        for (int i = 0; i < n; ++i) {
            innerDateArray[i] = new InnerDate(nArray[i], nArray2[i], nArray3[i]);
        }
        this.mDateArray = innerDateArray;
    }

    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGDateData)) {
            throw new IllegalArgumentException("!(data instanceof SGDateData)");
        }
        SGDateData sGDateData = (SGDateData)sGData;
        this.mDateArray = (InnerDate[])sGDateData.mDateArray.clone();
        return true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object copy() {
        return this.clone();
    }

    protected static class InnerDate {
        protected int year;
        protected int month;
        protected int date;

        protected InnerDate(int n, int n2, int n3) {
            this.year = n;
            this.month = n2;
            this.date = n3;
        }
    }
}

