/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.math.BigDecimal;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;

public class SGUtilityNumber
implements SGIConstants {
    public static int getOrder(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("d < 0.0");
        }
        BigDecimal bigDecimal = new BigDecimal(d);
        int n = 0;
        int n2 = 0;
        if (d > 1.0) {
            while (!(bigDecimal.doubleValue() < 1.0)) {
                bigDecimal = bigDecimal.movePointLeft(1);
                ++n;
            }
            n2 = n - 1;
        } else {
            while (!(bigDecimal.doubleValue() >= 1.0)) {
                bigDecimal = bigDecimal.movePointRight(1);
                ++n;
            }
            n2 = -n;
        }
        return n2;
    }

    public static double getPowersOfTen(int n) {
        BigDecimal bigDecimal = SGUtilityNumber.getBigDecimalPowersOfTen(n);
        return bigDecimal.doubleValue();
    }

    public static BigDecimal getBigDecimalPowersOfTen(int n) {
        BigDecimal bigDecimal = new BigDecimal("1.0");
        bigDecimal = bigDecimal.movePointRight(n);
        return bigDecimal;
    }

    public static double truncateNumber(double d, int n) {
        return SGUtilityNumber.truncateNumber(new Double(d).toString(), n);
    }

    public static double truncateNumber(String string, int n) {
        BigDecimal bigDecimal = new BigDecimal(string);
        bigDecimal = bigDecimal.movePointLeft(n);
        int n2 = (int)bigDecimal.doubleValue();
        bigDecimal = new BigDecimal((double)n2);
        bigDecimal = bigDecimal.movePointRight(n);
        return bigDecimal.doubleValue();
    }

    public static double roundOffNumber(double d, int n) {
        return SGUtilityNumber.roundOffNumber(Double.toString(d), n);
    }

    public static double roundOffNumber(String string, int n) {
        BigDecimal bigDecimal = new BigDecimal(string);
        bigDecimal = bigDecimal.movePointLeft(n + 1);
        double d = Math.rint(bigDecimal.doubleValue());
        bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.movePointRight(n + 1);
        return bigDecimal.doubleValue();
    }

    public static double roundOutNumber(double d, int n) {
        return SGUtilityNumber.roundOutNumber(Double.toString(d), n);
    }

    public static double roundOutNumber(String string, int n) {
        BigDecimal bigDecimal = new BigDecimal(string);
        bigDecimal = bigDecimal.movePointLeft(n + 1);
        double d = Math.ceil(bigDecimal.doubleValue());
        bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.movePointRight(n + 1);
        return bigDecimal.doubleValue();
    }

    public static boolean isOverlapping(double d, double d2, double d3, double d4) {
        double d5 = SGUtilityNumber.getOverlap(d, d2, d3, d4);
        return d5 != 0.0;
    }

    public static double getOverlap(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = d < d2 ? d : d2;
        double d7 = d < d2 ? d2 : d;
        double d8 = d3 < d4 ? d3 : d4;
        double d9 = d5 = d3 < d4 ? d4 : d3;
        if (!(d6 < d5) && !(d8 < d7)) {
            return 0.0;
        }
        double d10 = d6 < d8 ? d7 - d8 : d5 - d6;
        return d10;
    }

    public static boolean contains(double d, double d2, double d3) {
        double d4;
        double d5;
        if (d <= d2) {
            d5 = d;
            d4 = d2;
        } else {
            d5 = d2;
            d4 = d;
        }
        return d5 <= d3 && d3 <= d4;
    }

    public static boolean contains(double d, double d2, double d3, double d4) {
        double d5 = d < d2 ? d : d2;
        double d6 = d < d2 ? d2 : d;
        double d7 = d3 < d4 ? d3 : d4;
        double d8 = d3 < d4 ? d4 : d3;
        boolean bl = d5 <= d7 && d8 <= d6;
        return bl;
    }

    public static float stepValue(boolean bl, float f, float f2, float f3, float f4, float f5) {
        int n = (int)Math.rint(f3 / f4);
        int n2 = (int)Math.rint(f / f4);
        float f6 = (float)n2 * f4;
        int n3 = Math.abs(f - f6) < f5 ? (bl ? n2 + 1 : n2 - 1) : (bl ? (int)Math.floor(f / f4) + 1 : (int)Math.floor(f / f4));
        float f7 = (float)n3 * f4;
        return f7;
    }

    public static double getNumberInRangeOrder(double d, double d2, double d3, int n) {
        int n2 = SGUtilityNumber.getOrder(d3 - d2) - n + 1;
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        bigDecimal = bigDecimal.movePointLeft(n2);
        bigDecimal = bigDecimal.setScale(0, 4);
        bigDecimal = bigDecimal.movePointRight(n2);
        return bigDecimal.doubleValue();
    }
}

