/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIVisible;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;

public abstract class SGDrawingElement
implements SGIDrawingElementConstants,
SGIVisible {
    protected float mMagnification = 1.0f;
    protected ArrayList mColorList = new ArrayList();
    protected boolean mVisibleFlag = true;

    public abstract boolean contains(int var1, int var2);

    public boolean zoom(float f) {
        this.setMagnification(f);
        return true;
    }

    public boolean isVisible() {
        return this.mVisibleFlag;
    }

    public void setVisible(boolean bl) {
        this.mVisibleFlag = bl;
    }

    public boolean setMagnification(float f) {
        this.mMagnification = f;
        return true;
    }

    public boolean setColor(ArrayList arrayList) {
        if (arrayList == null) {
            new IllegalArgumentException("list==null");
        }
        if (arrayList.size() == 0) {
            new IllegalArgumentException("list.size()==0");
        }
        this.mColorList.clear();
        this.mColorList.addAll(arrayList);
        return true;
    }

    public boolean setColor(Color color) {
        if (color == null) {
            new IllegalArgumentException("cl==null");
        }
        this.mColorList.clear();
        this.mColorList.add(color);
        return true;
    }

    public boolean addColor(Color color) {
        this.mColorList.add(color);
        return true;
    }

    public ArrayList getColorList() {
        return new ArrayList(this.mColorList);
    }

    public Color getColor(int n) {
        if (n >= this.mColorList.size()) {
            new IllegalArgumentException("index >= this.mColorList.size()");
        }
        return (Color)this.mColorList.get(n);
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        this.setVisible(sGDrawingElement.isVisible());
        this.setMagnification(sGDrawingElement.getMagnification());
        this.setColor(sGDrawingElement.getColorList());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof DrawingElementProperties)) {
            return false;
        }
        DrawingElementProperties drawingElementProperties = (DrawingElementProperties)sGProperties;
        Boolean bl = drawingElementProperties.isVisible();
        if (bl == null) {
            return false;
        }
        this.setVisible(bl);
        ArrayList arrayList = drawingElementProperties.getColorList();
        if (arrayList == null) {
            return false;
        }
        this.setColor(arrayList);
        return true;
    }

    public SGProperties getProperties() {
        DrawingElementProperties drawingElementProperties = new DrawingElementProperties();
        if (!this.getProperties(drawingElementProperties)) {
            return null;
        }
        return drawingElementProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof DrawingElementProperties)) {
            return false;
        }
        DrawingElementProperties drawingElementProperties = (DrawingElementProperties)sGProperties;
        drawingElementProperties.setVisible(this.isVisible());
        drawingElementProperties.setColor(this.getColorList());
        return true;
    }

    public static class DrawingElementProperties
    extends SGProperties {
        private boolean mVisible = true;
        private ArrayList mColorList = new ArrayList();

        public boolean equals(Object object) {
            if (!(object instanceof DrawingElementProperties)) {
                return false;
            }
            DrawingElementProperties drawingElementProperties = (DrawingElementProperties)object;
            if (this.mVisible != drawingElementProperties.mVisible) {
                return false;
            }
            return this.mColorList.equals(drawingElementProperties.mColorList);
        }

        public Boolean isVisible() {
            return this.mVisible;
        }

        public ArrayList getColorList() {
            return new ArrayList(this.mColorList);
        }

        public void setVisible(boolean bl) {
            this.mVisible = bl;
        }

        public void setColor(Color color) {
            if (color == null) {
                new IllegalArgumentException("cl==null");
            }
            this.mColorList.clear();
            this.mColorList.add(color);
        }

        public void setColor(ArrayList arrayList) {
            if (arrayList == null) {
                new IllegalArgumentException("list==null");
            }
            if (arrayList.size() == 0) {
                new IllegalArgumentException("list.size()==0");
            }
            this.mColorList.clear();
            this.mColorList.addAll(arrayList);
        }
    }
}

