/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.preview;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;

class TextLabel {
    int tmpPosition;
    int tmpConflicts;
    private int position;
    private int conflicts;
    private String text;
    private Point location;
    private Component component;

    public TextLabel(String text, Point location, int position, Component component) {
        this.text = text;
        this.location = location;
        this.tmpPosition = position;
        this.component = component;
        this.tmpConflicts = 0;
        this.keep();
    }

    public String getText() {
        return this.text;
    }

    public int getConflicts() {
        return this.conflicts;
    }

    int keep() {
        this.position = this.tmpPosition;
        this.conflicts = this.tmpConflicts;
        return this.conflicts;
    }

    Rectangle getBounds(int position) {
        Font font = this.component.getFont();
        int width = 2;
        int height = 2;
        if (font != null) {
            FontMetrics fm = this.component.getFontMetrics(font);
            height = fm.getHeight();
            width = fm.stringWidth(this.text);
        }
        return new Rectangle(this.location.x + (int)(TextLabel.getTx(position) * (double)width), this.location.y + (int)(TextLabel.getTy(position) * (double)height), width, height);
    }

    public Rectangle getBounds() {
        return this.getBounds(this.position);
    }

    public int getX() {
        return this.location.x;
    }

    public int getY() {
        return this.location.y;
    }

    public int getAlignmentX() {
        return TextLabel.getHor(this.position);
    }

    private static int getHor(int position) {
        switch (position) {
            default: {
                throw new RuntimeException("Location not allowed");
            }
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 7: 
        }
        return 2;
    }

    public int getAlignmentY() {
        return TextLabel.getVer(this.position);
    }

    private static int getVer(int position) {
        switch (position) {
            default: {
                throw new RuntimeException("Location not allowed");
            }
            case 0: {
                return 3;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 2;
            }
            case 7: 
        }
        return 1;
    }

    static double getTx(int position) {
        switch (position) {
            default: {
                throw new RuntimeException("Location not allowed");
            }
            case 0: {
                return 0.0;
            }
            case 1: {
                return -1.0;
            }
            case 2: {
                return 0.0;
            }
            case 3: {
                return -1.0;
            }
            case 4: {
                return 0.0;
            }
            case 5: {
                return -0.5;
            }
            case 6: {
                return -1.0;
            }
            case 7: 
        }
        return -0.5;
    }

    static double getTy(int position) {
        switch (position) {
            default: {
                throw new RuntimeException("Location not allowed");
            }
            case 0: {
                return -1.0;
            }
            case 1: {
                return -1.0;
            }
            case 2: {
                return 0.0;
            }
            case 3: {
                return 0.0;
            }
            case 4: {
                return -0.5;
            }
            case 5: {
                return -1.0;
            }
            case 6: {
                return -0.5;
            }
            case 7: 
        }
        return 0.0;
    }
}

