/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGTwoAxesRadioButtonManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGILabelDialogObserver;

public class SGStringElementDialog
extends SGPropertyDialog {
    public static final String TITLE = "Label Properties";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private SGColorSelectionButton mColorButton;
    private JPanel mCommonPanel;
    private JLabel mFontFamilyLabel;
    private JComboBox mFontNameComboBox;
    private JLabel mFontSizeLabel;
    private SGSpinner mFontSizeSpinner;
    private JComboBox mFontStyleComboBox;
    private JLabel mFontStyleLabel;
    private JRadioButton mLeftBottomRadioButton;
    private JLabel mLeftSpaceLabel;
    private JRadioButton mLeftTopRadioButton;
    private JLabel mLocationLabel;
    private JSeparator mLocationSeparator;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JRadioButton mRightBottomRadioButton;
    private JLabel mRightSpaceLabel;
    private JRadioButton mRightTopRadioButton;
    private JLabel mScaleReferenceLabel1;
    private JLabel mScaleReferenceLabel2;
    private JLabel mStringLabel;
    private JSeparator mStringSeparator;
    private JLabel mTextAngleLabel;
    private SGSpinner mTextAngleSpinner;
    private JLabel mTextColorLabel;
    private SGTextField mTextField;
    private JLabel mTextLabel;
    private JPanel mTextPanel;
    private JLabel mXValueLabel;
    private SGTextField mXValueTextField;
    private JLabel mYValueLabel;
    private SGTextField mYValueTextField;
    private SGTwoAxesRadioButtonManager mAxesButtonGroup = null;

    public SGStringElementDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mTextPanel = new JPanel();
        this.mFontFamilyLabel = new JLabel();
        this.mFontStyleComboBox = new JComboBox();
        this.mFontSizeLabel = new JLabel();
        this.mTextAngleSpinner = new SGSpinner();
        this.mTextColorLabel = new JLabel();
        this.mTextAngleLabel = new JLabel();
        this.mFontSizeSpinner = new SGSpinner();
        this.mColorButton = new SGColorSelectionButton();
        this.mFontNameComboBox = new JComboBox();
        this.mRightSpaceLabel = new JLabel();
        this.mLeftSpaceLabel = new JLabel();
        this.mStringLabel = new JLabel();
        this.mStringSeparator = new JSeparator();
        this.mXValueLabel = new JLabel();
        this.mXValueTextField = new SGTextField();
        this.mYValueLabel = new JLabel();
        this.mYValueTextField = new SGTextField();
        this.mLocationLabel = new JLabel();
        this.mLocationSeparator = new JSeparator();
        this.mFontStyleLabel = new JLabel();
        this.mTextField = new SGTextField();
        this.mTextLabel = new JLabel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mCommonPanel = new JPanel();
        this.mLeftTopRadioButton = new JRadioButton();
        this.mLeftBottomRadioButton = new JRadioButton();
        this.mRightTopRadioButton = new JRadioButton();
        this.mRightBottomRadioButton = new JRadioButton();
        this.mScaleReferenceLabel2 = new JLabel();
        this.mScaleReferenceLabel1 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mTextPanel.setLayout(new GridBagLayout());
        this.mTextPanel.setBorder(new BevelBorder(0));
        this.mFontFamilyLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontFamilyLabel.setText("Family");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mTextPanel.add((Component)this.mFontFamilyLabel, gridBagConstraints);
        this.mFontStyleComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mFontStyleComboBox, gridBagConstraints);
        this.mFontSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mTextPanel.add((Component)this.mFontSizeLabel, gridBagConstraints);
        this.mTextAngleSpinner.setFont(new Font("Dialog", 0, 12));
        this.mTextAngleSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTextPanel.add((Component)this.mTextAngleSpinner, gridBagConstraints);
        this.mTextColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mTextColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mTextPanel.add((Component)this.mTextColorLabel, gridBagConstraints);
        this.mTextAngleLabel.setFont(new Font("Dialog", 0, 12));
        this.mTextAngleLabel.setText("Angle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mTextPanel.add((Component)this.mTextAngleLabel, gridBagConstraints);
        this.mFontSizeSpinner.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTextPanel.add((Component)this.mFontSizeSpinner, gridBagConstraints);
        this.mColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTextPanel.add((Component)this.mColorButton, gridBagConstraints);
        this.mFontNameComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mFontNameComboBox, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.mTextPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mTextPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mStringLabel.setFont(new Font("Dialog", 3, 12));
        this.mStringLabel.setText("String");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mStringLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 45, 0, 0);
        this.mTextPanel.add((Component)this.mStringSeparator, gridBagConstraints);
        this.mXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mXValueLabel.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mTextPanel.add((Component)this.mXValueLabel, gridBagConstraints);
        this.mXValueTextField.setColumns(6);
        this.mXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mXValueTextField, gridBagConstraints);
        this.mYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mYValueLabel.setText("Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mTextPanel.add((Component)this.mYValueLabel, gridBagConstraints);
        this.mYValueTextField.setColumns(6);
        this.mYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mYValueTextField, gridBagConstraints);
        this.mLocationLabel.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 4, 0, 0);
        this.mTextPanel.add((Component)this.mLocationSeparator, gridBagConstraints);
        this.mFontStyleLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontStyleLabel.setText("Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mTextPanel.add((Component)this.mFontStyleLabel, gridBagConstraints);
        this.mTextField.setColumns(16);
        this.mTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTextPanel.add((Component)this.mTextField, gridBagConstraints);
        this.mTextLabel.setFont(new Font("Dialog", 0, 12));
        this.mTextLabel.setText("Text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 15, 5, 5);
        this.mTextPanel.add((Component)this.mTextLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mTextPanel, gridBagConstraints);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mCommonPanel.setLayout(new GridBagLayout());
        this.mLeftTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftTopRadioButton.setText("Left/Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mLeftTopRadioButton, gridBagConstraints);
        this.mLeftBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftBottomRadioButton.setText("Left/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mLeftBottomRadioButton, gridBagConstraints);
        this.mRightTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightTopRadioButton.setText("Right/Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mRightTopRadioButton, gridBagConstraints);
        this.mRightBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightBottomRadioButton.setText("Right/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mRightBottomRadioButton, gridBagConstraints);
        this.mScaleReferenceLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel2, gridBagConstraints);
        this.mScaleReferenceLabel1.setFont(new Font("Dialog", 1, 12));
        this.mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mCommonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        String[] stringArray = SGUtility.getAvailableFontNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mFontNameComboBox.addItem(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.mFontStyleComboBox.addItem(stringArray2[i]);
        }
        this.pack();
        this.mAxesButtonGroup = new SGTwoAxesRadioButtonManager(this.mLeftBottomRadioButton, this.mLeftTopRadioButton, this.mRightBottomRadioButton, this.mRightTopRadioButton, new JRadioButton());
        this.mFontSizeSpinner.initProperties(this.getFontSizeSpinnerNumberModel(), " pt");
        this.mTextAngleSpinner.initProperties(new SpinnerNumberModel(0.0, -180.0, 180.0, 1.0), SGSpinner.SPINNER_UNIT_DEGREE);
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
        this.mFocusedColorSetButton = this.mColorButton;
        return true;
    }

    public String getText() {
        return this.mTextField.getText();
    }

    public Number getXValue() {
        return this.getNumber(this.mXValueTextField);
    }

    public Number getYValue() {
        return this.getNumber(this.mYValueTextField);
    }

    public Number getFontSize() {
        return this.mFontSizeSpinner.getNumber();
    }

    public String getFontName() {
        return (String)this.mFontNameComboBox.getSelectedItem();
    }

    public int getFontStyle() {
        String string = (String)this.mFontStyleComboBox.getSelectedItem();
        return SGUtilityText.getFontStyle(string);
    }

    public Color getTextColor() {
        return this.mColorButton.getColor();
    }

    public Number getAngle() {
        return this.mTextAngleSpinner.getNumber();
    }

    public boolean setText(String string) {
        this.mTextField.setText(string);
        return true;
    }

    public boolean setFontSize(Object object) {
        return this.setValue(this.mFontSizeSpinner, object);
    }

    public boolean setFontName(String string) {
        this.mFontNameComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setFontStyle(Integer n) {
        String string = null;
        if (n != null) {
            string = SGUtilityText.getFontStyleName(n);
        }
        this.mFontStyleComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setTextColor(Color color) {
        this.mColorButton.setColor(color);
        return true;
    }

    public boolean setAngle(Object object) {
        return this.setValue(this.mTextAngleSpinner, object);
    }

    public boolean setXValue(Object object) {
        return this.setValue(this.mXValueTextField, object);
    }

    public boolean setYValue(Object object) {
        return this.setValue(this.mYValueTextField, object);
    }

    public ArrayList getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mColorButton);
        return arrayList;
    }

    public ArrayList getTextFieldComponentsList() {
        ArrayList arrayList = this.getFormattedTextFieldsListFromSpinners();
        arrayList.addAll(this.getNumberTextFieldList());
        arrayList.add(this.mTextField);
        return arrayList;
    }

    public ArrayList getNumberTextFieldList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.add(this.mXValueTextField);
        arrayList.add(this.mYValueTextField);
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mFontSizeSpinner);
        arrayList.add(this.mTextAngleSpinner);
        return arrayList;
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        SGILabelDialogObserver sGILabelDialogObserver = (SGILabelDialogObserver)sGIPropertyDialogObserver;
        int n = this.mAxesButtonGroup.getXAxisConfiguration();
        int n2 = this.mAxesButtonGroup.getYAxisConfiguration();
        String string = this.getText();
        Number number = this.getXValue();
        Number number2 = this.getYValue();
        Number number3 = this.getFontSize();
        String string2 = this.getFontName();
        int n3 = this.getFontStyle();
        Number number4 = this.getAngle();
        Color color = this.getTextColor();
        if (!sGILabelDialogObserver.hasValidXValue(n, number)) {
            return false;
        }
        if (!sGILabelDialogObserver.hasValidYValue(n2, number2)) {
            return false;
        }
        if (n != -1 & n2 != -1) {
            sGILabelDialogObserver.setAxisConfiguration(n, n2);
        }
        if (string != null) {
            sGILabelDialogObserver.setString(string);
        }
        if (number != null) {
            sGILabelDialogObserver.setXValue(number.doubleValue());
        }
        if (number2 != null) {
            sGILabelDialogObserver.setYValue(number2.doubleValue());
        }
        if (number3 != null) {
            sGILabelDialogObserver.setFontSize(number3.floatValue());
        }
        if (string2 != null) {
            sGILabelDialogObserver.setFontName(string2);
        }
        if (n3 != -1) {
            sGILabelDialogObserver.setFontStyle(n3);
        }
        if (number4 != null) {
            sGILabelDialogObserver.setAngle(number4.floatValue() * ((float)Math.PI / 180));
        }
        if (color != null) {
            sGILabelDialogObserver.setStringColor(color);
        }
        return true;
    }

    public boolean setDialogProperty() {
        SGStringElementDialog sGStringElementDialog = this;
        ArrayList arrayList = this.mPropertyDialogObserverList;
        if (!this.mAxesButtonGroup.setRadioButton(arrayList)) {
            return false;
        }
        SGILabelDialogObserver sGILabelDialogObserver = (SGILabelDialogObserver)arrayList.get(0);
        String string = sGILabelDialogObserver.getString();
        double d = sGILabelDialogObserver.getXValue();
        double d2 = sGILabelDialogObserver.getYValue();
        String string2 = sGILabelDialogObserver.getFontName();
        float f = sGILabelDialogObserver.getFontSize();
        int n = sGILabelDialogObserver.getFontStyle();
        float f2 = sGILabelDialogObserver.getAngle();
        Color color = sGILabelDialogObserver.getStringColor();
        String string3 = new String(string);
        Double d3 = new Double(d);
        Double d4 = new Double(d2);
        String string4 = new String(string2);
        Float f3 = new Float(f);
        Integer n2 = new Integer(n);
        Float f4 = new Float(f2);
        Color color2 = color;
        if (arrayList.size() > 1) {
            String string5;
            SGILabelDialogObserver sGILabelDialogObserver2;
            int n3;
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)arrayList.get(n3);
                string5 = sGILabelDialogObserver2.getString();
                if (string.equals(string5)) continue;
                string3 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)arrayList.get(n3);
                double d5 = sGILabelDialogObserver2.getXValue();
                if (d == d5) continue;
                d3 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)arrayList.get(n3);
                double d6 = sGILabelDialogObserver2.getYValue();
                if (d2 == d6) continue;
                d4 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)arrayList.get(n3);
                string5 = sGILabelDialogObserver2.getFontName();
                if (string2.equals(string5)) continue;
                string4 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)arrayList.get(n3);
                float f5 = sGILabelDialogObserver2.getFontSize();
                if (f == f5) continue;
                f3 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)arrayList.get(n3);
                int n4 = sGILabelDialogObserver2.getFontStyle();
                if (n == n4) continue;
                n2 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)arrayList.get(n3);
                float f6 = sGILabelDialogObserver2.getAngle();
                if (f2 == f6) continue;
                f4 = null;
                break;
            }
            for (n3 = 1; n3 < arrayList.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)arrayList.get(n3);
                Color color3 = sGILabelDialogObserver2.getStringColor();
                if (color.equals(color3)) continue;
                color2 = null;
                break;
            }
        }
        this.setText(string3);
        this.setXValue(d3);
        this.setYValue(d4);
        this.setFontName(string4);
        this.setFontSize(f3);
        this.setFontStyle(n2);
        if (f4 != null) {
            f4 = new Float(f4.floatValue() / ((float)Math.PI / 180));
        }
        this.setAngle(f4);
        this.setTextColor(color2);
        this.setColorButtonBorder(true);
        return true;
    }

    protected boolean hasValidInputValues() {
        if (!super.hasValidInputValues()) {
            return false;
        }
        if (!this.mTextField.hasValidText()) {
            this.setInputErrorMessage("The input value is illegal.");
            return false;
        }
        return true;
    }
}

