/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupString;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupTickLabel;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGGraphElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGISXYDataDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGPropertyDialogSXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SGSXYGraphElement
extends SGGraphElement {
    protected boolean createDataDialog() {
        SGPropertyDialogSXYData sGPropertyDialogSXYData = new SGPropertyDialogSXYData(this.mDialogOwner, true);
        this.mDialog = sGPropertyDialogSXYData;
        return true;
    }

    public String getClassDescription() {
        return "SXY Graph";
    }

    public boolean addData(SGData sGData, String string) {
        if (!(sGData instanceof SGSXYData) & !(sGData instanceof SGSXYMultipleData)) {
            return false;
        }
        if (!super.addData(sGData, string)) {
            return false;
        }
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = this.createGroupSet(sGData, string);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        elementGroupSetInGraph.initPropertiesHistory();
        if (this.mDialog == null) {
            this.createDataDialog();
        }
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    public boolean addData(SGData sGData, String string, SGProperties sGProperties) {
        if (!(sGData instanceof SGSXYData) & !(sGData instanceof SGSXYMultipleData)) {
            return false;
        }
        if (!super.addData(sGData, string)) {
            return false;
        }
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = this.createGroupSet(sGData, string);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        if (!elementGroupSetInGraph.setWholeProperties(sGProperties)) {
            return false;
        }
        elementGroupSetInGraph.setName(string);
        elementGroupSetInGraph.initPropertiesHistory();
        if (this.mDialog == null) {
            this.createDataDialog();
        }
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    private SGGraphElement.ElementGroupSetInGraph createGroupSet(SGData sGData, String string) {
        SGAxis sGAxis = this.mAxisElement.getAxisInPlane(0);
        SGAxis sGAxis2 = this.mAxisElement.getAxisInPlane(1);
        SGAxis sGAxis3 = this.mAxisElement.getAxisInPlane(2);
        SGAxis sGAxis4 = this.mAxisElement.getAxisInPlane(3);
        SGAxis sGAxis5 = null;
        SGAxis sGAxis6 = null;
        if ("Left-Bottom".equals("Left-Bottom")) {
            sGAxis5 = sGAxis;
            sGAxis6 = sGAxis3;
        } else if ("Left-Bottom".equals("Left-Top")) {
            sGAxis5 = sGAxis2;
            sGAxis6 = sGAxis3;
        } else if ("Left-Bottom".equals("Right-Bottom")) {
            sGAxis5 = sGAxis;
            sGAxis6 = sGAxis4;
        } else if ("Left-Bottom".equals("Right-Top")) {
            sGAxis5 = sGAxis2;
            sGAxis6 = sGAxis4;
        } else {
            return null;
        }
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = null;
        if (sGData instanceof SGSXYData) {
            elementGroupSetInGraph = this.createSingleGroupSet((SGSXYData)sGData, sGAxis5, sGAxis6, string);
        } else if (sGData instanceof SGSXYMultipleData) {
            elementGroupSetInGraph = this.createMultipleGroupSet((SGSXYMultipleData)sGData, sGAxis5, sGAxis6, string);
        } else {
            return null;
        }
        this.mGroupSetList.add(elementGroupSetInGraph);
        return elementGroupSetInGraph;
    }

    private SGGraphElement.ElementGroupSetForMultipleData createMultipleGroupSet(SGSXYMultipleData sGSXYMultipleData, SGAxis sGAxis, SGAxis sGAxis2, String string) {
        ElementGroupSetForMultipleDataInSXYGraph elementGroupSetForMultipleDataInSXYGraph = new ElementGroupSetForMultipleDataInSXYGraph();
        elementGroupSetForMultipleDataInSXYGraph.setName(string);
        SGSXYData[] sGSXYDataArray = sGSXYMultipleData.getSXYDataArray();
        for (int i = 0; i < sGSXYDataArray.length; ++i) {
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.createGroupSetSXYInstance(sGSXYDataArray[i], sGAxis, sGAxis2);
            elementGroupSetInSXYGraph.setName(string);
            elementGroupSetInSXYGraph.initPropertiesHistory();
            elementGroupSetForMultipleDataInSXYGraph.mElementGroupSetList.add(elementGroupSetInSXYGraph);
        }
        return elementGroupSetForMultipleDataInSXYGraph;
    }

    private ElementGroupSetInSXYGraph createSingleGroupSet(SGSXYData sGSXYData, SGAxis sGAxis, SGAxis sGAxis2, String string) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.createGroupSetSXYInstance(sGSXYData, sGAxis, sGAxis2);
        elementGroupSetInSXYGraph.setName(string);
        return elementGroupSetInSXYGraph;
    }

    private ElementGroupSetInSXYGraph createGroupSetSXYInstance(SGSXYData sGSXYData, SGAxis sGAxis, SGAxis sGAxis2) {
        SGElementGroup sGElementGroup;
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = new ElementGroupSetInSXYGraph();
        elementGroupSetInSXYGraph.setXAxis(sGAxis);
        elementGroupSetInSXYGraph.setYAxis(sGAxis2);
        int n = sGSXYData.getPointsNumber();
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
        for (int i = 0; i < n; ++i) {
            sGTuple2fArray[i] = new SGTuple2f();
        }
        ElementGroupSetInSXYGraph.access$002(elementGroupSetInSXYGraph, sGTuple2fArray);
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(2)) {
            return null;
        }
        double[] dArray = sGSXYData.getXValueArray();
        double d = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length - 1; ++i) {
            double d2 = Math.abs(dArray[i + 1] - dArray[i]);
            if (!(d2 < d)) continue;
            d = d2;
        }
        double d3 = sGAxis.getMinValue();
        double d4 = sGAxis.getMaxValue();
        double d5 = d / (d4 - d3);
        float f = this.mGraphRectWidth * (float)d5;
        if (f < 1.4173229f) {
            f = 1.4173229f;
        } else if (f > 141.73228f) {
            f = 141.73228f;
        }
        elementGroupSetInSXYGraph.getBarGroup().setRectangleWidth(f);
        if (sGSXYData.isErrorValueHolding() && !((SGElementGroupErrorBar)(sGElementGroup = elementGroupSetInSXYGraph.createErrorBars(sGSXYData))).setPropertiesOfDrawingElements()) {
            return null;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(0)) {
            return null;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(1)) {
            return null;
        }
        if (sGSXYData.isStringArrayHolding() && !((SGElementGroupString)(sGElementGroup = elementGroupSetInSXYGraph.createTickLabels(sGSXYData))).setPropertiesOfDrawingElements()) {
            return null;
        }
        if (!elementGroupSetInSXYGraph.setDrawingElementsLocation(sGSXYData)) {
            return null;
        }
        elementGroupSetInSXYGraph.setMagnification(this.getMagnification());
        return elementGroupSetInSXYGraph;
    }

    private JPopupMenu createGroupSetPopupMenu(SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setBounds(0, 0, 100, 100);
        jPopupMenu.add(new JLabel("  -- Data --"));
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Move to Front");
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Move to Back");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Cut");
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Copy");
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Paste");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Delete");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Property");
        return jPopupMenu;
    }

    protected boolean synchronizeToLegendElement(SGILegendElement sGILegendElement) {
        boolean bl = super.synchronizeToLegendElement(sGILegendElement);
        if (!bl) {
            return bl;
        }
        ArrayList arrayList = new ArrayList(this.mDataList);
        ArrayList arrayList2 = new ArrayList(this.mGroupSetList);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            boolean bl2;
            String string;
            SGData sGData = (SGData)arrayList.get(i);
            SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)arrayList2.get(i);
            boolean bl3 = false;
            String string2 = sGILegendElement.getDataName(sGData);
            if (!string2.equals(string = elementGroupSetInGraph.getName())) {
                elementGroupSetInGraph.setChanged(true);
            }
            elementGroupSetInGraph.setName(string2);
            SGAxis sGAxis = sGILegendElement.getXAxis(sGData);
            if (sGAxis != null & elementGroupSetInGraph.getXAxis() != null && !sGAxis.equals(elementGroupSetInGraph.getXAxis())) {
                elementGroupSetInGraph.setChanged(true);
            }
            elementGroupSetInGraph.setXAxis(sGAxis);
            SGAxis sGAxis2 = sGILegendElement.getYAxis(sGData);
            if (sGAxis2 != null & elementGroupSetInGraph.getYAxis() != null && !sGAxis2.equals(elementGroupSetInGraph.getYAxis())) {
                elementGroupSetInGraph.setChanged(true);
            }
            elementGroupSetInGraph.setYAxis(sGAxis2);
            SGAxis sGAxis3 = sGILegendElement.getZAxis(sGData);
            if (sGAxis3 != null & elementGroupSetInGraph.mZAxis != null) {
                if (!sGAxis3.equals(elementGroupSetInGraph.mZAxis)) {
                    elementGroupSetInGraph.setChanged(true);
                }
                elementGroupSetInGraph.setZAxis(sGAxis3);
            }
            if ((bl2 = sGILegendElement.isDataVisible(sGData)) != elementGroupSetInGraph.isVisible()) {
                this.setChanged(true);
            }
            elementGroupSetInGraph.setVisible(bl2);
            ArrayList arrayList3 = sGILegendElement.getDrawingElementList(sGData);
            boolean bl4 = ((IElementGroupSetInSXYGraph)((Object)elementGroupSetInGraph)).synchronizeDrawingElement(arrayList3);
            if (bl4) {
                bl3 = true;
            }
            if (!bl3) continue;
            elementGroupSetInGraph.setChanged(true);
        }
        this.setAllDrawingElementsLocation();
        this.repaint();
        return bl;
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        SGElementGroupSet sGElementGroupSet;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        ArrayList arrayList = this.mGroupSetList;
        for (n = 0; n < arrayList.size(); ++n) {
            sGElementGroupSet = (SGElementGroupSet)arrayList.get(n);
            if (!sGElementGroupSet.isVisible()) continue;
            IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)((Object)sGElementGroupSet);
            iElementGroupSetInSXYGraph.paintDataString(graphics2D);
        }
        if (bl) {
            SGUtilityForFigureElement.clipGraphRect(this, graphics2D);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            sGElementGroupSet = (SGGraphElement.ElementGroupSetInGraph)arrayList.get(n);
            if (!sGElementGroupSet.isVisible()) continue;
            ((SGGraphElement.ElementGroupSetInGraph)sGElementGroupSet).setClipFlag(bl);
            sGElementGroupSet.paintGraphics2D(graphics2D);
        }
        if (bl) {
            graphics2D.setClip(this.getBounds());
        }
    }

    private ElementGroupLine getGroupLine(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph) {
        ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupLine)) continue;
            return (ElementGroupLine)sGElementGroup;
        }
        return null;
    }

    private ElementGroupBar getGroupBar(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph) {
        ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupBar)) continue;
            return (ElementGroupBar)sGElementGroup;
        }
        return null;
    }

    private ElementGroupSymbol getGroupSymbol(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph) {
        ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupSymbol)) continue;
            return (ElementGroupSymbol)sGElementGroup;
        }
        return null;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGData sGData;
            SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mGroupSetList.get(i);
            Rectangle2D rectangle2D = ((IElementGroupSetInSXYGraph)((Object)elementGroupSetInGraph)).getTickLabelsBoundingBox(sGData = this.getData(elementGroupSetInGraph));
            if (rectangle2D == null) {
                return false;
            }
            if (rectangle2D.getWidth() < Double.MIN_VALUE || rectangle2D.getHeight() < Double.MIN_VALUE) continue;
            arrayList.add(rectangle2D);
        }
        if (arrayList.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        float f = this.mGraphRectY - (float)rectangle2D.getY();
        float f2 = -(this.mGraphRectY + this.mGraphRectHeight) + (float)(rectangle2D.getY() + rectangle2D.getHeight());
        float f3 = this.mGraphRectX - (float)rectangle2D.getX();
        float f4 = -(this.mGraphRectX + this.mGraphRectWidth) + (float)(rectangle2D.getX() + rectangle2D.getWidth());
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    protected boolean setAllDrawingElementsLocation() {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGData sGData;
            SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mGroupSetList.get(i);
            if (!elementGroupSetInGraph.isVisible() || ((IElementGroupSetInSXYGraph)((Object)elementGroupSetInGraph)).setDrawingElementsLocation(sGData = (SGData)this.mDataList.get(i))) continue;
            return false;
        }
        return true;
    }

    protected SGGraphElement.ElementGroupSetInGraph getGroupSetNewInstance(SGData sGData) {
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = null;
        if (sGData instanceof SGSXYData) {
            elementGroupSetInGraph = new ElementGroupSetInSXYGraph();
        } else if (sGData instanceof SGSXYMultipleData) {
            elementGroupSetInGraph = new ElementGroupSetForMultipleDataInSXYGraph();
        }
        return elementGroupSetInGraph;
    }

    public boolean createDataObject(Element element, SGData sGData) {
        if (!(sGData instanceof SGSXYData) && !(sGData instanceof SGSXYMultipleData)) {
            return false;
        }
        if (!super.createDataObject(element, sGData)) {
            return false;
        }
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = this.getGroupSetNewInstance(sGData);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        this.mGroupSetList.add(elementGroupSetInGraph);
        int n = this.setProperty(element, elementGroupSetInGraph);
        if (n == 1) {
            return false;
        }
        this.createDataDialog();
        return true;
    }

    private int setProperty(Element element, SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph) {
        SGData sGData = this.getData(elementGroupSetInGraph);
        int n = 1;
        if (sGData instanceof SGSXYData) {
            SGSXYData sGSXYData = (SGSXYData)sGData;
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)elementGroupSetInGraph;
            n = this.setPropertyOfElementGroupSetInSXYGraph(element, elementGroupSetInSXYGraph, sGSXYData);
        } else if (sGData instanceof SGSXYMultipleData) {
            SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)sGData;
            ElementGroupSetForMultipleDataInSXYGraph elementGroupSetForMultipleDataInSXYGraph = (ElementGroupSetForMultipleDataInSXYGraph)elementGroupSetInGraph;
            n = this.setPropertyOfElementGroupSetForMultipleDataInSXYGraph(element, elementGroupSetForMultipleDataInSXYGraph, sGSXYMultipleData);
        }
        return n;
    }

    private int setPropertyOfElementGroupSetForMultipleDataInSXYGraph(Element element, ElementGroupSetForMultipleDataInSXYGraph elementGroupSetForMultipleDataInSXYGraph, SGSXYMultipleData sGSXYMultipleData) {
        elementGroupSetForMultipleDataInSXYGraph.mDrawingElementGroupList.clear();
        SGSXYData[] sGSXYDataArray = sGSXYMultipleData.getSXYDataArray();
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = new ElementGroupSetInSXYGraph();
        int n = this.setPropertyOfElementGroupSetInSXYGraph(element, elementGroupSetInSXYGraph, sGSXYDataArray[0]);
        if (n == 1) {
            return n;
        }
        SGProperties sGProperties = elementGroupSetInSXYGraph.getProperties();
        SGProperties sGProperties2 = elementGroupSetInSXYGraph.getWholeProperties();
        ArrayList<ElementGroupSetInSXYGraph> arrayList = new ArrayList<ElementGroupSetInSXYGraph>();
        for (int i = 0; i < sGSXYDataArray.length; ++i) {
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph2 = new ElementGroupSetInSXYGraph();
            if (!elementGroupSetInSXYGraph2.setProperties(sGProperties)) {
                return 1;
            }
            int n2 = sGSXYDataArray[i].getPointsNumber();
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[n2];
            for (int j = 0; j < n2; ++j) {
                sGTuple2fArray[j] = new SGTuple2f();
            }
            ElementGroupSetInSXYGraph.access$002(elementGroupSetInSXYGraph2, sGTuple2fArray);
            elementGroupSetInSXYGraph2.setDrawingElementsLocation(sGSXYDataArray[i]);
            elementGroupSetInSXYGraph2.addDrawingElementGroup(2);
            elementGroupSetInSXYGraph2.addDrawingElementGroup(0);
            elementGroupSetInSXYGraph2.addDrawingElementGroup(1);
            if (!elementGroupSetInSXYGraph2.setWholeProperties(sGProperties2)) {
                return 1;
            }
            elementGroupSetInSXYGraph2.initPropertiesHistory();
            arrayList.add(elementGroupSetInSXYGraph2);
        }
        elementGroupSetForMultipleDataInSXYGraph.mElementGroupSetList = new ArrayList(arrayList);
        elementGroupSetForMultipleDataInSXYGraph.setName(elementGroupSetInSXYGraph.getName());
        elementGroupSetForMultipleDataInSXYGraph.setXAxis(elementGroupSetInSXYGraph.getXAxis());
        elementGroupSetForMultipleDataInSXYGraph.setYAxis(elementGroupSetInSXYGraph.getYAxis());
        elementGroupSetForMultipleDataInSXYGraph.setZAxis(elementGroupSetInSXYGraph.getZAxis());
        elementGroupSetForMultipleDataInSXYGraph.initPropertiesHistory();
        return 0;
    }

    private int setPropertyOfElementGroupSetInSXYGraph(Element element, ElementGroupSetInSXYGraph elementGroupSetInSXYGraph, SGSXYData sGSXYData) {
        Element element2;
        Object object;
        SGIAxisElement sGIAxisElement = this.mAxisElement;
        String string = null;
        string = element.getAttribute("Name");
        if (string.length() == 0) {
            return 1;
        }
        String string2 = string;
        elementGroupSetInSXYGraph.setName(string2);
        string = element.getAttribute("XAxisPosition");
        if (string.length() == 0) {
            return 1;
        }
        int n = sGIAxisElement.getConfigurationInCube(string);
        string = element.getAttribute("YAxisPosition");
        if (string.length() == 0) {
            return 1;
        }
        int n2 = sGIAxisElement.getConfigurationInCube(string);
        elementGroupSetInSXYGraph.setXAxis(sGIAxisElement.getAxisInCube(n));
        elementGroupSetInSXYGraph.setYAxis(sGIAxisElement.getAxisInCube(n2));
        string = element.getAttribute("VisibleInLegend");
        if (string.length() == 0) {
            return 1;
        }
        Boolean bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return 1;
        }
        boolean bl2 = bl;
        elementGroupSetInSXYGraph.setVisibleInLegend(bl2);
        int n3 = sGSXYData.getPointsNumber();
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[n3];
        for (int i = 0; i < n3; ++i) {
            sGTuple2fArray[i] = new SGTuple2f();
        }
        ElementGroupSetInSXYGraph.access$002(elementGroupSetInSXYGraph, sGTuple2fArray);
        SGElementGroupSXY sGElementGroupSXY = null;
        NodeList nodeList = null;
        nodeList = element.getElementsByTagName("Bar");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(2)) {
            return 1;
        }
        Element element3 = (Element)nodeList.item(0);
        sGElementGroupSXY = elementGroupSetInSXYGraph.getBarGroup();
        if (!sGElementGroupSXY.readProperty(element3)) {
            return 1;
        }
        nodeList = element.getElementsByTagName("ErrorBar");
        if (nodeList.getLength() == 1) {
            if (sGSXYData.isErrorValueHolding()) {
                object = elementGroupSetInSXYGraph.createErrorBars(sGSXYData);
                if (!((SGElementGroup)object).readProperty(element2 = (Element)nodeList.item(0))) {
                    return 1;
                }
                if (!((SGElementGroupErrorBar)object).setPropertiesOfDrawingElements()) {
                    return 1;
                }
                ((SGElementGroupErrorBar)object).setLocation(((ElementGroupErrorBar)object).mStartArray, ((ElementGroupErrorBar)object).mEndArray);
            }
        } else if (nodeList.getLength() == 0) {
            if (sGSXYData.isErrorValueHolding() && !((SGElementGroupErrorBar)(object = elementGroupSetInSXYGraph.createErrorBars(sGSXYData))).setPropertiesOfDrawingElements()) {
                return 1;
            }
        } else {
            return 1;
        }
        if ((nodeList = element.getElementsByTagName("Line")).getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(0)) {
            return 1;
        }
        object = (Element)nodeList.item(0);
        sGElementGroupSXY = elementGroupSetInSXYGraph.getLineGroup();
        if (!sGElementGroupSXY.readProperty((Element)object)) {
            return 1;
        }
        nodeList = element.getElementsByTagName("Symbol");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(1)) {
            return 1;
        }
        element2 = (Element)nodeList.item(0);
        sGElementGroupSXY = elementGroupSetInSXYGraph.getSymbolGroup();
        if (!sGElementGroupSXY.readProperty(element2)) {
            return 1;
        }
        nodeList = element.getElementsByTagName("TickLabels");
        if (nodeList.getLength() == 1) {
            if (sGSXYData.isStringArrayHolding()) {
                Element element4;
                ElementGroupTickLabels elementGroupTickLabels = elementGroupSetInSXYGraph.createTickLabels(sGSXYData);
                if (!elementGroupTickLabels.readProperty(element4 = (Element)nodeList.item(0))) {
                    return 1;
                }
                if (!elementGroupTickLabels.setPropertiesOfDrawingElements()) {
                    return 1;
                }
                elementGroupTickLabels.setLocation(elementGroupTickLabels.mPointsArray);
            }
        } else if (nodeList.getLength() == 0) {
            ElementGroupTickLabels elementGroupTickLabels;
            if (sGSXYData.isStringArrayHolding() && !(elementGroupTickLabels = elementGroupSetInSXYGraph.createTickLabels(sGSXYData)).setPropertiesOfDrawingElements()) {
                return 1;
            }
        } else {
            return 1;
        }
        elementGroupSetInSXYGraph.initPropertiesHistory();
        return 0;
    }

    public static class TickLabelStringElement
    extends SGDrawingElementString2DExtended {
        protected TickLabelStringElement() {
        }
    }

    class ElementGroupTickLabels
    extends SGElementGroupTickLabel
    implements SGGraphElement.IElementGroupInGraph {
        private SGTuple2f[] mPointsArray = null;
        private boolean mFocusedFlag = false;

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupTickLabels(SGSXYData sGSXYData) {
            int n = sGSXYData.getPointsNumber();
            this.initDrawingElement(n);
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2fArray[i] = new SGTuple2f();
            }
            this.mPointsArray = sGTuple2fArray;
            String[] stringArray = sGSXYData.getStringArray();
            SGDrawingElementString[] sGDrawingElementStringArray = (SGDrawingElementString[])this.mDrawingElementArray;
            for (int i = 0; i < n; ++i) {
                SGDrawingElementString sGDrawingElementString = sGDrawingElementStringArray[i];
                sGDrawingElementString.setString(stringArray[i]);
            }
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            this.setFont("Serif", SGUtilityText.getFontStyle("Plain"), 16.0f);
            Float f = SGElementGroupTickLabel.getTickLabelAngleFromName("Horizontal");
            if (f == null) {
                return false;
            }
            this.setAngle(f.floatValue());
            this.setColor(SGDefaultValues.TICK_LABEL_COLOR);
            return true;
        }

        private boolean drawStringBounds(SGDrawingElementString2DExtended sGDrawingElementString2DExtended, Graphics2D graphics2D) {
            Color color = Color.BLACK;
            graphics2D.setPaint(color);
            graphics2D.setStroke(new BasicStroke(1.0f));
            Rectangle2D rectangle2D = sGDrawingElementString2DExtended.getElementBounds();
            graphics2D.drawRect((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            return true;
        }

        protected boolean initDrawingElement(int n) {
            TickLabelStringElement[] tickLabelStringElementArray = new TickLabelStringElement[n];
            for (int i = 0; i < n; ++i) {
                tickLabelStringElementArray[i] = new TickLabelStringElement();
            }
            this.mDrawingElementArray = tickLabelStringElementArray;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean calcTickLabelLocation(SGSXYData sGSXYData, SGAxis sGAxis, SGTuple2f[] sGTuple2fArray) {
            float f = SGSXYGraphElement.this.mGraphRectX;
            float f2 = SGSXYGraphElement.this.mGraphRectY;
            float f3 = SGSXYGraphElement.this.mGraphRectWidth;
            float f4 = SGSXYGraphElement.this.mGraphRectHeight;
            int n = SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(sGAxis);
            float f5 = this.getAngle();
            float f6 = SGSXYGraphElement.this.mAxisElement.getSpaceAxisLineAndNumber() * this.mMagnification;
            int n2 = sGSXYData.getPointsNumber();
            for (int i = 0; i < n2; ++i) {
                TickLabelStringElement tickLabelStringElement = (TickLabelStringElement)this.mDrawingElementArray[i];
                double d = sGSXYData.getXValue(i);
                float f7 = SGSXYGraphElement.this.calcLocation(d, sGAxis, true);
                Rectangle2D rectangle2D = tickLabelStringElement.getElementBounds();
                float f8 = (float)rectangle2D.getWidth();
                float f9 = (float)rectangle2D.getHeight();
                Rectangle2D rectangle2D2 = tickLabelStringElement.getStringRect();
                float f10 = (float)rectangle2D2.getWidth();
                float f11 = (float)rectangle2D2.getHeight();
                float f12 = 0.0f;
                float f13 = 0.0f;
                float f14 = 0.0f;
                if (f5 == 0.0f) {
                    f12 = f7 - 0.5f * f8;
                } else {
                    if (f5 != 0.5235988f) throw new Error();
                    if (n == 0) {
                        f12 = f7 - f10 * (float)Math.cos(f5);
                    } else {
                        if (n != 1) throw new Error();
                        f12 = f7 - f11 * (float)Math.sin(f5);
                    }
                }
                if (n == 0) {
                    f14 = f2 + f4 + f6;
                } else {
                    if (n != 1) throw new Error();
                    f14 = f2 - f6 - f9;
                }
                tickLabelStringElement.setLocation(f12, f14);
                float f15 = (float)tickLabelStringElement.getElementBounds().getY();
                f13 = f14 + (f14 - f15);
                sGTuple2fArray[i].setValues(f12, f13);
            }
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            super.setLocation(sGTuple2fArray);
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet;
            SGAxis sGAxis = elementGroupSetInSXYGraph.getXAxis();
            SGSXYData sGSXYData = (SGSXYData)SGSXYGraphElement.this.getData(elementGroupSetInSXYGraph);
            for (int i = 0; i < sGTuple2fArray.length; ++i) {
                double d = sGSXYData.getXValue(i);
                TickLabelStringElement tickLabelStringElement = (TickLabelStringElement)this.mDrawingElementArray[i];
                tickLabelStringElement.setVisible(sGAxis.insideRange(d));
            }
            return true;
        }

        public String getTagName() {
            return "TickLabels";
        }
    }

    class ElementGroupErrorBar
    extends SGElementGroupErrorBar
    implements SGGraphElement.IElementGroupInGraph {
        protected SGTuple2f[] mStartArray = null;
        protected SGTuple2f[] mEndArray = null;
        private boolean mFocusedFlag = false;

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupErrorBar(SGSXYData sGSXYData) {
            int n = sGSXYData.getPointsNumber();
            this.initDrawingElement(n);
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
            SGTuple2f[] sGTuple2fArray2 = new SGTuple2f[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2fArray[i] = new SGTuple2f();
                sGTuple2fArray2[i] = new SGTuple2f();
            }
            this.mStartArray = sGTuple2fArray;
            this.mEndArray = sGTuple2fArray2;
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f);
            this.setHeadSize(7.0866146f);
            Integer n = SGDrawingElementSymbol.getSymbolTypeFromName("Transverse Line");
            if (n == null) {
                return false;
            }
            this.setHeadType(n);
            this.setLineWidth(1.0f);
            Integer n2 = SGDrawingElementErrorBar.getErrorBarStyleFromName("Bothsides");
            if (n2 == null) {
                return false;
            }
            this.setErrorBarStyle(n2);
            this.setColor(SGDefaultValues.ERROR_BAR_COLOR);
            return true;
        }

        private boolean calcErrorBarLocation(SGSXYData sGSXYData, SGAxis sGAxis, SGAxis sGAxis2, SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2) {
            int n = sGSXYData.getPointsNumber();
            double[] dArray = sGSXYData.getXValueArray();
            double[] dArray2 = sGSXYData.getYValueArray();
            SGTuple2d[] sGTuple2dArray = new SGTuple2d[n];
            SGTuple2d[] sGTuple2dArray2 = new SGTuple2d[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2dArray[i] = new SGTuple2d();
                sGTuple2dArray2[i] = new SGTuple2d();
                sGTuple2dArray[i].x = dArray[i];
                sGTuple2dArray2[i].x = dArray[i];
            }
            if (this.mErrorBarStyle == 1) {
                double[] dArray3 = sGSXYData.getUpperErrorValueArray();
                double[] dArray4 = sGSXYData.getLowerErrorValueArray();
                for (int i = 0; i < n; ++i) {
                    sGTuple2dArray[i].y = dArray2[i] + dArray4[i];
                    sGTuple2dArray2[i].y = dArray2[i] + dArray3[i];
                }
            } else if (this.mErrorBarStyle == 2) {
                double[] dArray5 = sGSXYData.getUpperErrorValueArray();
                for (int i = 0; i < n; ++i) {
                    sGTuple2dArray[i].y = dArray2[i];
                    sGTuple2dArray2[i].y = dArray2[i] + dArray5[i];
                }
            } else if (this.mErrorBarStyle == 3) {
                double[] dArray6 = sGSXYData.getLowerErrorValueArray();
                for (int i = 0; i < n; ++i) {
                    sGTuple2dArray[i].y = dArray2[i] + dArray6[i];
                    sGTuple2dArray2[i].y = dArray2[i];
                }
            } else {
                throw new Error();
            }
            SGSXYGraphElement.this.calcLocationOfVXYData(sGTuple2dArray, sGTuple2dArray2, sGAxis, sGAxis2, sGTuple2fArray, sGTuple2fArray2);
            return true;
        }
    }

    class ElementGroupSymbol
    extends SGElementGroupSymbol
    implements SGGraphElement.IElementGroupInGraph {
        private boolean mFocusedFlag = false;

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupSymbol() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            Integer n = SGDrawingElementSymbol.getSymbolTypeFromName("Circle");
            if (n == null) {
                return false;
            }
            this.setType(n);
            this.setSize(8.503938f);
            this.setColor(SGDefaultValues.SYMBOL_BODY_COLOR);
            this.setLineWidth(1.0f);
            this.setLineColor(SGDefaultValues.SYMBOL_LINE_COLOR);
            return true;
        }

        private boolean drawRectangle(Shape shape, Graphics2D graphics2D) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            graphics2D.setPaint(Color.black);
            graphics2D.setStroke(new BasicStroke(1.0f));
            int n = (int)rectangle2D.getX();
            int n2 = (int)rectangle2D.getY();
            int n3 = (int)rectangle2D.getWidth();
            int n4 = (int)rectangle2D.getHeight();
            graphics2D.drawRect(n, n2, n3, n4);
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            block4: {
                super.paintElement(graphics2D, rectangle2D);
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet;
                SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
                if (!this.isFocused() || !SGSXYGraphElement.this.mSymbolsVisibleFlagAroundFocusedObjects || elementGroupSetInSXYGraph.isBarVisible()) break block4;
                int n = sGDrawingElementArray.length;
                if (n <= 8) {
                    for (int i = 0; i < n; ++i) {
                        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[i];
                        this.emphasisSymbol(sGDrawingElementSymbol2D, graphics2D);
                    }
                } else {
                    int n2 = n / 8;
                    int n3 = 0;
                    do {
                        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[n3];
                        this.emphasisSymbol(sGDrawingElementSymbol2D, graphics2D);
                    } while ((n3 += n2) < n);
                }
            }
            return true;
        }

        private boolean emphasisSymbol(SGDrawingElementSymbol2D sGDrawingElementSymbol2D, Graphics2D graphics2D) {
            Rectangle2D rectangle2D = sGDrawingElementSymbol2D.getElementBounds();
            Point2D.Float float_ = new Point2D.Float((float)rectangle2D.getX(), (float)rectangle2D.getY());
            Point2D.Float float_2 = new Point2D.Float((float)(rectangle2D.getX() + rectangle2D.getWidth()), (float)rectangle2D.getY());
            Point2D.Float float_3 = new Point2D.Float((float)rectangle2D.getX(), (float)(rectangle2D.getY() + rectangle2D.getHeight()));
            Point2D.Float float_4 = new Point2D.Float((float)(rectangle2D.getX() + rectangle2D.getWidth()), (float)(rectangle2D.getY() + rectangle2D.getHeight()));
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_, graphics2D);
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_2, graphics2D);
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_3, graphics2D);
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_4, graphics2D);
            return true;
        }
    }

    class ElementGroupBar
    extends SGElementGroupBar
    implements SGGraphElement.IElementGroupInGraph {
        private boolean mFocusedFlag = false;

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupBar() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            this.setBaselineValue(0.0);
            this.setColor(SGDefaultValues.BAR_COLOR);
            this.setEdgeLineWidth(0.5f);
            this.setEdgeLineColor(SGDefaultValues.BAR_LINE_COLOR);
            return true;
        }

        private float getBaselineLocation(double d) {
            SGAxis sGAxis = ((ElementGroupSetInSXYGraph)this.mGroupSet).getYAxis();
            return SGSXYGraphElement.this.calcLocation(d, sGAxis, false);
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            if (this.mDrawingElementArray == null) {
                return true;
            }
            float f = SGSXYGraphElement.this.mGraphRectX;
            float f2 = SGSXYGraphElement.this.mGraphRectY;
            float f3 = SGSXYGraphElement.this.mGraphRectWidth;
            float f4 = SGSXYGraphElement.this.mGraphRectHeight;
            float f5 = this.getBaselineLocation(this.mBaselineValue);
            boolean bl = true;
            if (Float.isInfinite(f5) || Float.isNaN(f5)) {
                bl = false;
            }
            float f6 = this.mMagnification * this.mRectangleWidth;
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)this.mDrawingElementArray[i];
                float f7 = f5;
                SGTuple2f sGTuple2f = sGTuple2fArray[i];
                float f8 = sGTuple2f.y;
                if (Float.isInfinite(f8) || Float.isNaN(f8)) {
                    if (bl) {
                        f8 = f5;
                        f7 = f2 + f4;
                        continue;
                    }
                    sGDrawingElementBar2D.setVisible(false);
                    continue;
                }
                if (!bl) {
                    f7 = f2 + f4;
                }
                float f9 = sGTuple2f.x - 0.5f * f6;
                float f10 = 0.0f;
                float f11 = 0.0f;
                if (f8 <= f7) {
                    f10 = f8;
                    f11 = f7 - f8;
                } else {
                    f10 = f7;
                    f11 = f8 - f7;
                }
                sGDrawingElementBar2D.setVisible(true);
                sGDrawingElementBar2D.setBounds(f9, f10, f6, f11);
            }
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            block4: {
                super.paintElement(graphics2D, rectangle2D);
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mGroupSet;
                SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
                if (!this.isFocused() || !SGSXYGraphElement.this.mSymbolsVisibleFlagAroundFocusedObjects) break block4;
                int n = sGDrawingElementArray.length;
                if (n <= 8) {
                    for (int i = 0; i < n; ++i) {
                        SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
                        this.emphasisBar(sGDrawingElementBar2D, graphics2D);
                    }
                } else {
                    int n2 = n / 8;
                    int n3 = 0;
                    do {
                        SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[n3];
                        this.emphasisBar(sGDrawingElementBar2D, graphics2D);
                    } while ((n3 += n2) < n);
                }
            }
            return true;
        }

        private boolean emphasisBar(SGDrawingElementBar2D sGDrawingElementBar2D, Graphics2D graphics2D) {
            Rectangle2D rectangle2D = sGDrawingElementBar2D.getElementBounds();
            Point2D.Float float_ = new Point2D.Float((float)rectangle2D.getX(), (float)rectangle2D.getY());
            Point2D.Float float_2 = new Point2D.Float((float)(rectangle2D.getX() + rectangle2D.getWidth()), (float)rectangle2D.getY());
            Point2D.Float float_3 = new Point2D.Float((float)rectangle2D.getX(), (float)(rectangle2D.getY() + rectangle2D.getHeight()));
            Point2D.Float float_4 = new Point2D.Float((float)(rectangle2D.getX() + rectangle2D.getWidth()), (float)(rectangle2D.getY() + rectangle2D.getHeight()));
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_, graphics2D);
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_2, graphics2D);
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_3, graphics2D);
            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(float_4, graphics2D);
            return true;
        }
    }

    class ElementGroupLine
    extends SGElementGroupLine
    implements SGGraphElement.IElementGroupInGraph {
        private boolean mFocusedFlag = false;

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupLine() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f);
            Integer n = SGDrawingElementLine.getLineTypeFromName("Solid");
            if (n == null) {
                return false;
            }
            this.setLineType(n);
            this.setColor(SGDefaultValues.LINE_COLOR);
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            return this.setLocation_(sGTuple2fArray, false);
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            super.paintElement(graphics2D, rectangle2D);
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet;
            if (this.isFocused() && SGSXYGraphElement.this.mSymbolsVisibleFlagAroundFocusedObjects && !elementGroupSetInSXYGraph.isSymbolVisible() && !elementGroupSetInSXYGraph.isBarVisible()) {
                ArrayList arrayList = this.mConnectedPathList;
                for (int i = 0; i < arrayList.size(); ++i) {
                    int n;
                    GeneralPath generalPath = (GeneralPath)arrayList.get(i);
                    int n2 = 0;
                    ArrayList<Point2D.Float> arrayList2 = new ArrayList<Point2D.Float>();
                    PathIterator pathIterator = generalPath.getPathIterator(new AffineTransform());
                    float[] fArray = new float[6];
                    pathIterator.currentSegment(fArray);
                    Point2D.Float float_ = new Point2D.Float(fArray[0], fArray[1]);
                    pathIterator.next();
                    while (!pathIterator.isDone()) {
                        pathIterator.currentSegment(fArray);
                        Point2D.Float float_2 = new Point2D.Float(fArray[0], fArray[1]);
                        ((Point2D)float_2).setLocation((((Point2D)float_).getX() + ((Point2D)float_2).getX()) / 2.0, (((Point2D)float_).getY() + ((Point2D)float_2).getY()) / 2.0);
                        ((Point2D)float_).setLocation(fArray[0], fArray[1]);
                        arrayList2.add(float_2);
                        pathIterator.next();
                        ++n2;
                    }
                    if (n2 <= 8) {
                        for (n = 0; n < n2; ++n) {
                            Point2D point2D = (Point2D)arrayList2.get(n);
                            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(point2D, graphics2D);
                        }
                        continue;
                    }
                    n = n2 / 8;
                    int n3 = 0;
                    do {
                        Point2D point2D = (Point2D)arrayList2.get(n3);
                        SGSXYGraphElement.this.drawAnchorsForFocusedObjects(point2D, graphics2D);
                    } while ((n3 += n) < n2);
                }
            }
            return true;
        }
    }

    class ElementGroupSetInSXYGraph
    extends SGGraphElement.ElementGroupSetInGraph
    implements IElementGroupSetInSXYGraph,
    SGISXYDataDialogObserver {
        private int mSelectedTabIndex = -1;
        private SGTuple2f[] mPointsArray = null;

        protected ElementGroupSetInSXYGraph() {
            this.mPopupMenu = SGSXYGraphElement.this.createGroupSetPopupMenu(this);
        }

        public String getClassDescription() {
            return "";
        }

        public String getInstanceDescription() {
            return "SXY: " + this.getName();
        }

        public String getDataClassName() {
            return "SXY";
        }

        private boolean setProperties(ArrayList arrayList, SGProperties sGProperties) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                if (sGElementGroup.setProperties(sGProperties)) continue;
                return false;
            }
            return true;
        }

        public boolean getLegendVisibleFlag() {
            return this.isVisibleInLegend();
        }

        public int getXAxisConfiguration() {
            return SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(this.getXAxis());
        }

        public int getYAxisConfiguration() {
            return SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(this.getYAxis());
        }

        public ArrayList getLineGroupList() {
            return this.getLineGroups();
        }

        public ArrayList getSymbolGroupList() {
            return this.getSymbolGroups();
        }

        public ArrayList getBarGroupList() {
            return this.getBarGroups();
        }

        public ArrayList getErrorBarGroupList() {
            return this.getErrorBarGroups();
        }

        public ArrayList getTickLabelGroupList() {
            return this.getTickLabelGroups();
        }

        public int getSelectedTabIndex() {
            return this.mSelectedTabIndex;
        }

        public boolean isLineVisible() {
            return this.getLineGroup().isVisible();
        }

        public float getLineWidth() {
            return this.getLineGroup().getLineWidth();
        }

        public int getLineType() {
            return this.getLineGroup().getLineType();
        }

        public Color getLineColor() {
            return this.getLineGroup().getColor(0);
        }

        public boolean setLineVisible(boolean bl) {
            this.getLineGroup().setVisible(bl);
            return true;
        }

        public boolean setLineWidth(float f) {
            return this.getLineGroup().setLineWidth(f);
        }

        public boolean setLineType(int n) {
            return this.getLineGroup().setLineType(n);
        }

        public boolean setLineColor(Color color) {
            return this.getLineGroup().setColor(color);
        }

        public boolean isSymbolVisible() {
            return this.getSymbolGroup().isVisible();
        }

        public int getSymbolType() {
            return this.getSymbolGroup().getType();
        }

        public float getSymbolSize() {
            return this.getSymbolGroup().getSize();
        }

        public float getSymbolLineWidth() {
            return this.getSymbolGroup().getLineWidth();
        }

        public Color getSymbolInnerColor() {
            return this.getSymbolGroup().getColor(0);
        }

        public Color getSymbolLineColor() {
            return this.getSymbolGroup().getLineColor();
        }

        public boolean setSymbolVisible(boolean bl) {
            this.getSymbolGroup().setVisible(bl);
            return true;
        }

        public boolean setSymbolType(int n) {
            return this.getSymbolGroup().setType(n);
        }

        public boolean setSymbolSize(float f) {
            return this.getSymbolGroup().setSize(f);
        }

        public boolean setSymbolLineWidth(float f) {
            return this.getSymbolGroup().setLineWidth(f);
        }

        public boolean setSymbolInnerColor(Color color) {
            return this.getSymbolGroup().setColor(color);
        }

        public boolean setSymbolLineColor(Color color) {
            return this.getSymbolGroup().setLineColor(color);
        }

        public boolean isBarVisible() {
            return this.getBarGroup().isVisible();
        }

        public double getBarBaselineValue() {
            return this.getBarGroup().getBaselineValue();
        }

        public float getBarWidth() {
            return this.getBarGroup().getRectangleWidth();
        }

        public float getBarEdgeLineWidth() {
            return this.getBarGroup().getEdgeLineWidth();
        }

        public Color getBarInnerColor() {
            return this.getBarGroup().getColor(0);
        }

        public Color getBarEdgeLineColor() {
            return this.getBarGroup().getEdgeLineColor();
        }

        public boolean setBarVisible(boolean bl) {
            this.getBarGroup().setVisible(bl);
            return true;
        }

        public boolean setBarBaselineValue(double d) {
            return this.getBarGroup().setBaselineValue(d);
        }

        public boolean setBarWidth(float f) {
            return this.getBarGroup().setRectangleWidth(f);
        }

        public boolean setBarEdgeLineWidth(float f) {
            return this.getBarGroup().setEdgeLineWidth(f);
        }

        public boolean setBarInnerColor(Color color) {
            return this.getBarGroup().setColor(color);
        }

        public boolean setBarEdgeLineColor(Color color) {
            return this.getBarGroup().setEdgeLineColor(color);
        }

        public boolean isErrorBarHolding() {
            return this.getErrorBarGroup() != null;
        }

        public boolean isErrorBarVisible() {
            return this.getErrorBarGroup().isVisible();
        }

        public int getErrorBarHeadType() {
            return this.getErrorBarGroup().getHeadType();
        }

        public float getErrorBarHeadSize() {
            return this.getErrorBarGroup().getHeadSize();
        }

        public Color getErrorBarColor() {
            return this.getErrorBarGroup().getColor(0);
        }

        public float getErrorBarLineWidth() {
            return this.getErrorBarGroup().getLineWidth();
        }

        public int getErrorBarStyle() {
            return this.getErrorBarGroup().getErrorBarStyle();
        }

        public boolean setErrorBarVisible(boolean bl) {
            this.getErrorBarGroup().setVisible(bl);
            return true;
        }

        public boolean setErrorBarHeadType(int n) {
            this.getErrorBarGroup().setHeadType(n);
            return true;
        }

        public boolean setErrorBarHeadSize(float f) {
            this.getErrorBarGroup().setHeadSize(f);
            return true;
        }

        public boolean setErrorBarColor(Color color) {
            return this.getErrorBarGroup().setColor(color);
        }

        public boolean setErrorBarLineWidth(float f) {
            this.getErrorBarGroup().setLineWidth(f);
            return true;
        }

        public boolean setErrorBarStyle(int n) {
            this.getErrorBarGroup().setErrorBarStyle(n);
            return true;
        }

        public boolean isTickLabelHolding() {
            return this.getTickLabelGroup() != null;
        }

        public boolean isTickLabelVisible() {
            return this.getTickLabelGroup().isVisible();
        }

        public String getTickLabelFontName() {
            return this.getTickLabelGroup().getFontName();
        }

        public int getTickLabelFontStyle() {
            return this.getTickLabelGroup().getFontStyle();
        }

        public float getTickLabelFontSize() {
            return this.getTickLabelGroup().getFontSize();
        }

        public Color getTickLabelColor() {
            return this.getTickLabelGroup().getColor(0);
        }

        public boolean isTickLabelHorizontal() {
            return this.getTickLabelGroup().getAngle() == 0.0f;
        }

        public boolean setTickLabelVisible(boolean bl) {
            this.getTickLabelGroup().setVisible(bl);
            return true;
        }

        public boolean setTickLabelFontName(String string) {
            return this.getTickLabelGroup().setFontName(string);
        }

        public boolean setTickLabelFontStyle(int n) {
            return this.getTickLabelGroup().setFontStyle(n);
        }

        public boolean setTickLabelFontSize(float f) {
            return this.getTickLabelGroup().setFontSize(f);
        }

        public boolean setTickLabelColor(Color color) {
            return this.getTickLabelGroup().setColor(color);
        }

        public boolean setTickLabelHorizontal(boolean bl) {
            float f = bl ? 0.0f : 0.5235988f;
            return this.getTickLabelGroup().setAngle(f);
        }

        public boolean addDrawingElementGroup(int n) {
            SGElementGroupSXY sGElementGroupSXY = null;
            if (n == 0) {
                sGElementGroupSXY = new ElementGroupLine();
            } else if (n == 2) {
                sGElementGroupSXY = new ElementGroupBar();
            } else if (n == 1) {
                sGElementGroupSXY = new ElementGroupSymbol();
            } else {
                return false;
            }
            if (!this.checkGroupType(sGElementGroupSXY)) {
                return false;
            }
            this.addElementGroup(sGElementGroupSXY);
            return true;
        }

        private boolean checkGroupType(SGElementGroup sGElementGroup) {
            Class<?> clazz = sGElementGroup.getClass();
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup2 = (SGElementGroup)arrayList.get(i);
                Class<?> clazz2 = sGElementGroup2.getClass();
                if (!clazz.equals(clazz2)) continue;
                return false;
            }
            return true;
        }

        private ElementGroupErrorBar createErrorBars(SGSXYData sGSXYData) {
            ElementGroupErrorBar elementGroupErrorBar = new ElementGroupErrorBar(sGSXYData);
            this.mDrawingElementGroupList.add(elementGroupErrorBar);
            elementGroupErrorBar.mGroupSet = this;
            return elementGroupErrorBar;
        }

        private ElementGroupTickLabels createTickLabels(SGSXYData sGSXYData) {
            ElementGroupTickLabels elementGroupTickLabels = new ElementGroupTickLabels(sGSXYData);
            this.mDrawingElementGroupList.add(elementGroupTickLabels);
            elementGroupTickLabels.mGroupSet = this;
            return elementGroupTickLabels;
        }

        public boolean synchronizeDrawingElement(ArrayList arrayList) {
            SGIConstants sGIConstants;
            int n;
            ArrayList<SGElementGroupErrorBar> arrayList2 = new ArrayList<SGElementGroupErrorBar>();
            for (n = 0; n < arrayList.size(); ++n) {
                SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(n);
                sGIConstants = null;
                if (sGDrawingElement instanceof SGDrawingElementErrorBar) {
                    sGIConstants = this.getErrorBarGroup();
                } else if (sGDrawingElement instanceof SGDrawingElementLine) {
                    sGIConstants = this.getLineGroup();
                } else if (sGDrawingElement instanceof SGDrawingElementSymbol) {
                    sGIConstants = this.getSymbolGroup();
                } else if (sGDrawingElement instanceof SGDrawingElementBar) {
                    sGIConstants = this.getBarGroup();
                } else if (sGDrawingElement instanceof SGDrawingElementString) {
                    sGIConstants = this.getTickLabelGroup();
                }
                if (sGIConstants == null) continue;
                arrayList2.add((SGElementGroupErrorBar)sGIConstants);
            }
            n = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGProperties sGProperties;
                sGIConstants = (SGDrawingElement)arrayList.get(i);
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
                SGDrawingElement sGDrawingElement = sGElementGroup.getDrawingElement();
                SGProperties sGProperties2 = ((SGDrawingElement)sGIConstants).getProperties();
                if (!sGProperties2.equals(sGProperties = sGDrawingElement.getProperties())) {
                    n = 1;
                }
                sGElementGroup.setProperty((SGDrawingElement)sGIConstants);
            }
            return n != 0;
        }

        public boolean setDrawingElementsLocation(SGData sGData) {
            if (!(sGData instanceof SGSXYData)) {
                return false;
            }
            SGSXYData sGSXYData = (SGSXYData)sGData;
            int n = sGSXYData.getPointsNumber();
            if (!SGSXYGraphElement.this.calcLocationOfSXYData(sGSXYData, this.getXAxis(), this.getYAxis(), this.mPointsArray)) {
                return false;
            }
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGTuple2f[] sGTuple2fArray;
                SGElementGroup sGElementGroup;
                SGElementGroup sGElementGroup2 = (SGElementGroup)arrayList.get(i);
                if (!sGElementGroup2.isVisible()) continue;
                if (sGElementGroup2 instanceof SGElementGroupErrorBar) {
                    sGElementGroup = (ElementGroupErrorBar)sGElementGroup2;
                    sGTuple2fArray = ((ElementGroupErrorBar)sGElementGroup).mStartArray;
                    SGTuple2f[] sGTuple2fArray2 = ((ElementGroupErrorBar)sGElementGroup).mEndArray;
                    if (!((ElementGroupErrorBar)sGElementGroup).calcErrorBarLocation(sGSXYData, this.getXAxis(), this.getYAxis(), sGTuple2fArray, sGTuple2fArray2)) {
                        return false;
                    }
                    if (((SGElementGroupErrorBar)sGElementGroup).setLocation(sGTuple2fArray, sGTuple2fArray2)) continue;
                    return false;
                }
                if (sGElementGroup2 instanceof SGElementGroupTickLabel) {
                    sGElementGroup = (ElementGroupTickLabels)sGElementGroup2;
                    sGTuple2fArray = ((ElementGroupTickLabels)sGElementGroup).mPointsArray;
                    if (!((ElementGroupTickLabels)sGElementGroup).calcTickLabelLocation(sGSXYData, this.getXAxis(), sGTuple2fArray)) {
                        return false;
                    }
                    if (((ElementGroupTickLabels)sGElementGroup).setLocation(sGTuple2fArray)) continue;
                    return false;
                }
                if (!(sGElementGroup2 instanceof SGElementGroupLine | sGElementGroup2 instanceof SGElementGroupSymbol | sGElementGroup2 instanceof SGElementGroupBar) || ((SGElementGroupSXY)(sGElementGroup = (SGElementGroupSXY)sGElementGroup2)).setLocation(this.mPointsArray)) continue;
                return false;
            }
            return true;
        }

        protected boolean createDrawingElements() {
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup;
                SGElementGroup sGElementGroup2 = (SGElementGroup)arrayList.get(i);
                if (!sGElementGroup2.isVisible()) continue;
                if (sGElementGroup2 instanceof SGElementGroupSXY) {
                    sGElementGroup = (SGElementGroupSXY)sGElementGroup2;
                    ((SGElementGroupSXY)sGElementGroup).setLocation(this.mPointsArray);
                    continue;
                }
                if (sGElementGroup2 instanceof ElementGroupErrorBar) {
                    sGElementGroup = (ElementGroupErrorBar)sGElementGroup2;
                    ((SGElementGroupErrorBar)sGElementGroup).setLocation(((ElementGroupErrorBar)sGElementGroup).mStartArray, ((ElementGroupErrorBar)sGElementGroup).mEndArray);
                    continue;
                }
                if (!(sGElementGroup2 instanceof ElementGroupTickLabels)) continue;
                sGElementGroup = (ElementGroupTickLabels)sGElementGroup2;
                ((ElementGroupTickLabels)sGElementGroup).setLocation(((ElementGroupTickLabels)sGElementGroup).mPointsArray);
            }
            return true;
        }

        private boolean addElementGroup(SGElementGroupSXY sGElementGroupSXY) {
            sGElementGroupSXY.mGroupSet = this;
            if (!sGElementGroupSXY.initDrawingElement(this.mPointsArray)) {
                throw new Error();
            }
            if (!sGElementGroupSXY.setPropertiesOfDrawingElements()) {
                return false;
            }
            this.mDrawingElementGroupList.add(sGElementGroupSXY);
            return true;
        }

        public Rectangle2D getTickLabelsBoundingBox(SGData sGData) {
            if (!(sGData instanceof SGSXYData)) {
                return null;
            }
            SGSXYData sGSXYData = (SGSXYData)sGData;
            ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
            ArrayList arrayList2 = this.getTickLabelGroups();
            if (arrayList2.size() == 0) {
                return new Rectangle2D.Float();
            }
            ElementGroupTickLabels elementGroupTickLabels = (ElementGroupTickLabels)arrayList2.get(0);
            if (!elementGroupTickLabels.isVisible()) {
                return new Rectangle2D.Float();
            }
            ArrayList<SGDrawingElement> arrayList3 = new ArrayList<SGDrawingElement>();
            SGDrawingElement[] sGDrawingElementArray = elementGroupTickLabels.mDrawingElementArray;
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                if (!sGDrawingElementArray[i].isVisible()) continue;
                arrayList3.add(sGDrawingElementArray[i]);
            }
            Rectangle2D rectangle2D = SGUtilityJava2D.getBoundingBox(arrayList3);
            if (rectangle2D == null) {
                return new Rectangle2D.Float();
            }
            arrayList.add(rectangle2D);
            Rectangle2D rectangle2D2 = SGUtility.createUnion(arrayList);
            if (rectangle2D2 == null) {
                new Rectangle2D.Float();
            }
            return rectangle2D2;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            ElementGroupSymbol elementGroupSymbol;
            SGElementGroup sGElementGroup;
            ArrayList arrayList;
            ElementGroupBar elementGroupBar;
            Rectangle2D rectangle2D = null;
            if (!this.getClipFlag()) {
                rectangle2D = SGSXYGraphElement.this.getGraphRect();
            }
            if ((elementGroupBar = SGSXYGraphElement.this.getGroupBar(this)) != null && elementGroupBar.isVisible()) {
                elementGroupBar.paintElement(graphics2D, rectangle2D);
            }
            if ((arrayList = this.getErrorBarGroups()).size() != 0 && (sGElementGroup = (ElementGroupErrorBar)arrayList.get(0)) != null && sGElementGroup.isVisible()) {
                ((SGElementGroupErrorBar)sGElementGroup).paintElement(graphics2D, rectangle2D);
            }
            if ((sGElementGroup = SGSXYGraphElement.this.getGroupLine(this)) != null && sGElementGroup.isVisible()) {
                ((ElementGroupLine)sGElementGroup).paintElement(graphics2D, rectangle2D);
            }
            if ((elementGroupSymbol = SGSXYGraphElement.this.getGroupSymbol(this)) != null && elementGroupSymbol.isVisible()) {
                elementGroupSymbol.paintElement(graphics2D, rectangle2D);
            }
        }

        public boolean paintDataString(Graphics2D graphics2D) {
            ElementGroupTickLabels elementGroupTickLabels;
            ArrayList arrayList = this.getTickLabelGroups();
            if (arrayList.size() != 0 && (elementGroupTickLabels = (ElementGroupTickLabels)arrayList.get(0)) != null && elementGroupTickLabels.isVisible()) {
                elementGroupTickLabels.paintElement(graphics2D);
            }
            return true;
        }

        public void setAxisConfiguration(int n, int n2) {
            SGIAxisElement sGIAxisElement = SGSXYGraphElement.this.mAxisElement;
            SGAxis sGAxis = sGIAxisElement.getAxisInPlane(n);
            SGAxis sGAxis2 = sGIAxisElement.getAxisInPlane(n2);
            this.setXAxis(sGAxis);
            this.setYAxis(sGAxis2);
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getWholeProperties();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            return SGSXYGraphElement.this.mDialog;
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            int n = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(this.getXAxis());
            int n2 = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(this.getYAxis());
            String string = SGSXYGraphElement.this.mAxisElement.getConfigurationString(n);
            String string2 = SGSXYGraphElement.this.mAxisElement.getConfigurationString(n2);
            element.setAttribute("XAxisPosition", string);
            element.setAttribute("YAxisPosition", string2);
            return true;
        }

        protected boolean onMouseClicked(MouseEvent mouseEvent) {
            if (!super.onMouseClicked(mouseEvent)) {
                return false;
            }
            SGElementGroup sGElementGroup = this.getElementGroupAt(mouseEvent.getX(), mouseEvent.getY());
            int n = -1;
            if (sGElementGroup instanceof ElementGroupLine) {
                n = 0;
            } else if (sGElementGroup instanceof ElementGroupSymbol) {
                n = 1;
            } else if (sGElementGroup instanceof ElementGroupBar) {
                n = 2;
            } else if (sGElementGroup instanceof ElementGroupErrorBar) {
                n = 3;
            } else if (sGElementGroup instanceof ElementGroupTickLabels) {
                n = 4;
            }
            this.mSelectedTabIndex = n;
            return true;
        }

        static /* synthetic */ SGTuple2f[] access$002(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph, SGTuple2f[] sGTuple2fArray) {
            elementGroupSetInSXYGraph.mPointsArray = sGTuple2fArray;
            return sGTuple2fArray;
        }
    }

    class ElementGroupSetForMultipleDataInSXYGraph
    extends SGGraphElement.ElementGroupSetForMultipleData
    implements IElementGroupSetInSXYGraph,
    SGISXYDataDialogObserver {
        private int mSelectedTabIndex = -1;

        protected ElementGroupSetForMultipleDataInSXYGraph() {
            this.mPopupMenu = SGSXYGraphElement.this.createGroupSetPopupMenu(this);
        }

        public String getClassDescription() {
            return "";
        }

        public String getInstanceDescription() {
            SGData sGData = SGSXYGraphElement.this.getData(this);
            String string = "SXY Multiple";
            if (sGData instanceof SGSXYSamplingData) {
                string = "SXY Sampling";
            }
            return string + ": " + this.getName();
        }

        public String getDataClassName() {
            SGData sGData = SGSXYGraphElement.this.getData(this);
            String string = null;
            string = sGData instanceof SGSXYSamplingData ? "SXY_SAMPLING" : "SXY_MULTIPLE";
            return string;
        }

        protected boolean createDrawingElements() {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                if (elementGroupSetInGraph.createDrawingElements()) continue;
                return false;
            }
            return true;
        }

        public boolean setDrawingElementsLocation(SGData sGData) {
            if (!(sGData instanceof SGSXYMultipleData)) {
                return false;
            }
            SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)sGData;
            SGSXYData[] sGSXYDataArray = sGSXYMultipleData.getSXYDataArray();
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                if (iElementGroupSetInSXYGraph.setDrawingElementsLocation(sGSXYDataArray[i])) continue;
                return false;
            }
            return true;
        }

        public Rectangle2D getTickLabelsBoundingBox(SGData sGData) {
            if (!(sGData instanceof SGSXYMultipleData)) {
                return null;
            }
            SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)sGData;
            SGSXYData[] sGSXYDataArray = sGSXYMultipleData.getSXYDataArray();
            ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                Rectangle2D rectangle2D = iElementGroupSetInSXYGraph.getTickLabelsBoundingBox(sGSXYDataArray[i]);
                if (rectangle2D == null) {
                    return null;
                }
                arrayList.add(rectangle2D);
            }
            Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
            return rectangle2D;
        }

        public boolean paintDataString(Graphics2D graphics2D) {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                iElementGroupSetInSXYGraph.paintDataString(graphics2D);
            }
            return true;
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getWholeProperties();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            return SGSXYGraphElement.this.mDialog;
        }

        public void setAxisConfiguration(int n, int n2) {
            SGIAxisElement sGIAxisElement = SGSXYGraphElement.this.mAxisElement;
            SGAxis sGAxis = sGIAxisElement.getAxisInPlane(n);
            SGAxis sGAxis2 = sGIAxisElement.getAxisInPlane(n2);
            this.setXAxis(sGAxis);
            this.setYAxis(sGAxis2);
        }

        public boolean setXAxis(SGAxis sGAxis) {
            super.setXAxis(sGAxis);
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)arrayList.get(i);
                elementGroupSetInGraph.setXAxis(sGAxis);
            }
            return true;
        }

        public boolean setYAxis(SGAxis sGAxis) {
            super.setYAxis(sGAxis);
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)arrayList.get(i);
                elementGroupSetInGraph.setYAxis(sGAxis);
            }
            return true;
        }

        public double getSamplingRate() {
            SGData sGData = SGSXYGraphElement.this.getData(this);
            SGSXYSamplingData sGSXYSamplingData = (SGSXYSamplingData)sGData;
            return sGSXYSamplingData.getSamplingRate();
        }

        public SGProperties getWholeProperties() {
            SGElementGroupSet.WholeProperties wholeProperties;
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getFirst();
            if (!elementGroupSetInSXYGraph.getWholeProperties(wholeProperties = new SGElementGroupSet.WholeProperties())) {
                return null;
            }
            return wholeProperties;
        }

        public boolean setWholeProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSet.WholeProperties)) {
                return false;
            }
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)sGProperties;
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList.get(i);
                if (elementGroupSetInSXYGraph.setWholeProperties(sGProperties)) continue;
                return false;
            }
            return true;
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getFirst();
            SGAxis sGAxis = elementGroupSetInSXYGraph.getXAxis();
            SGAxis sGAxis2 = elementGroupSetInSXYGraph.getYAxis();
            int n = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(sGAxis);
            int n2 = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(sGAxis2);
            String string = SGSXYGraphElement.this.mAxisElement.getConfigurationString(n);
            String string2 = SGSXYGraphElement.this.mAxisElement.getConfigurationString(n2);
            element.setAttribute("XAxisPosition", string);
            element.setAttribute("YAxisPosition", string2);
            ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                Element element2 = sGElementGroup.createElement(document);
                if (element2 == null) {
                    return null;
                }
                element.appendChild(element2);
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)SGSXYGraphElement.this.getData(this);
            if (!super.writeProperty(element)) {
                return false;
            }
            if (sGSXYMultipleData instanceof SGSXYSamplingData) {
                double d = this.getSamplingRate();
                element.setAttribute("SamplingRate", Double.toString(d));
            }
            return true;
        }

        public boolean isLineVisible() {
            return this.getLineGroup().isVisible();
        }

        public float getLineWidth() {
            return this.getLineGroup().getLineWidth();
        }

        public int getLineType() {
            return this.getLineGroup().getLineType();
        }

        public Color getLineColor() {
            return this.getLineGroup().getColor(0);
        }

        public boolean setLineVisible(boolean bl) {
            ArrayList arrayList = this.getLineGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupLine elementGroupLine = (ElementGroupLine)arrayList.get(i);
                elementGroupLine.setVisible(bl);
            }
            return true;
        }

        public boolean setLineWidth(float f) {
            ArrayList arrayList = this.getLineGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupLine elementGroupLine = (ElementGroupLine)arrayList.get(i);
                elementGroupLine.setLineWidth(f);
            }
            return true;
        }

        public boolean setLineType(int n) {
            ArrayList arrayList = this.getLineGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupLine elementGroupLine = (ElementGroupLine)arrayList.get(i);
                elementGroupLine.setLineType(n);
            }
            return true;
        }

        public boolean setLineColor(Color color) {
            ArrayList arrayList = this.getLineGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupLine elementGroupLine = (ElementGroupLine)arrayList.get(i);
                elementGroupLine.setColor(color);
            }
            return true;
        }

        public boolean isSymbolVisible() {
            return this.getSymbolGroup().isVisible();
        }

        public int getSymbolType() {
            return this.getSymbolGroup().getType();
        }

        public float getSymbolSize() {
            return this.getSymbolGroup().getSize();
        }

        public float getSymbolLineWidth() {
            return this.getSymbolGroup().getLineWidth();
        }

        public Color getSymbolInnerColor() {
            return this.getSymbolGroup().getColor(0);
        }

        public Color getSymbolLineColor() {
            return this.getSymbolGroup().getLineColor();
        }

        public boolean setSymbolVisible(boolean bl) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setVisible(bl);
            }
            return true;
        }

        public boolean setSymbolType(int n) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setType(n);
            }
            return true;
        }

        public boolean setSymbolSize(float f) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setSize(f);
            }
            return true;
        }

        public boolean setSymbolLineWidth(float f) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setLineWidth(f);
            }
            return true;
        }

        public boolean setSymbolInnerColor(Color color) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setColor(color);
            }
            return true;
        }

        public boolean setSymbolLineColor(Color color) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setLineColor(color);
            }
            return true;
        }

        public boolean isBarVisible() {
            return this.getBarGroup().isVisible();
        }

        public double getBarBaselineValue() {
            return this.getBarGroup().getBaselineValue();
        }

        public float getBarWidth() {
            return this.getBarGroup().getRectangleWidth();
        }

        public float getBarEdgeLineWidth() {
            return this.getBarGroup().getEdgeLineWidth();
        }

        public Color getBarInnerColor() {
            return this.getBarGroup().getColor(0);
        }

        public Color getBarEdgeLineColor() {
            return this.getBarGroup().getEdgeLineColor();
        }

        public boolean setBarVisible(boolean bl) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setVisible(bl);
            }
            return true;
        }

        public boolean setBarBaselineValue(double d) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setBaselineValue(d);
            }
            return true;
        }

        public boolean setBarWidth(float f) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setRectangleWidth(f);
            }
            return true;
        }

        public boolean setBarEdgeLineWidth(float f) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setEdgeLineWidth(f);
            }
            return true;
        }

        public boolean setBarInnerColor(Color color) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setColor(color);
            }
            return true;
        }

        public boolean setBarEdgeLineColor(Color color) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setEdgeLineColor(color);
            }
            return true;
        }

        public boolean isErrorBarHolding() {
            return this.getErrorBarGroup() != null;
        }

        public boolean isErrorBarVisible() {
            return this.getErrorBarGroup().isVisible();
        }

        public int getErrorBarHeadType() {
            return this.getErrorBarGroup().getHeadType();
        }

        public float getErrorBarHeadSize() {
            return this.getErrorBarGroup().getHeadSize();
        }

        public Color getErrorBarColor() {
            return this.getErrorBarGroup().getColor(0);
        }

        public float getErrorBarLineWidth() {
            return this.getErrorBarGroup().getLineWidth();
        }

        public int getErrorBarStyle() {
            return this.getErrorBarGroup().getErrorBarStyle();
        }

        public boolean setErrorBarVisible(boolean bl) {
            return true;
        }

        public boolean setErrorBarHeadType(int n) {
            return true;
        }

        public boolean setErrorBarHeadSize(float f) {
            return true;
        }

        public boolean setErrorBarColor(Color color) {
            return true;
        }

        public boolean setErrorBarLineWidth(float f) {
            return true;
        }

        public boolean setErrorBarStyle(int n) {
            return true;
        }

        public boolean isTickLabelHolding() {
            return this.getTickLabelGroup() != null;
        }

        public boolean isTickLabelVisible() {
            return this.getTickLabelGroup().isVisible();
        }

        public String getTickLabelFontName() {
            return this.getTickLabelGroup().getFontName();
        }

        public int getTickLabelFontStyle() {
            return this.getTickLabelGroup().getFontStyle();
        }

        public float getTickLabelFontSize() {
            return this.getTickLabelGroup().getFontSize();
        }

        public Color getTickLabelColor() {
            return this.getTickLabelGroup().getColor(0);
        }

        public boolean isTickLabelHorizontal() {
            return this.getTickLabelGroup().getAngle() == 0.0f;
        }

        public boolean setTickLabelVisible(boolean bl) {
            return true;
        }

        public boolean setTickLabelFontName(String string) {
            return true;
        }

        public boolean setTickLabelFontStyle(int n) {
            return true;
        }

        public boolean setTickLabelFontSize(float f) {
            return true;
        }

        public boolean setTickLabelColor(Color color) {
            return true;
        }

        public boolean setTickLabelHorizontal(boolean bl) {
            return true;
        }

        public ArrayList getLineGroups() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getLineGroups());
            }
            return arrayList;
        }

        public ArrayList getSymbolGroups() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getSymbolGroups());
            }
            return arrayList;
        }

        public ArrayList getBarGroups() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getBarGroups());
            }
            return arrayList;
        }

        public ArrayList getErrorBarGroups() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getErrorBarGroups());
            }
            return arrayList;
        }

        public ArrayList getTickLabelGroups() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getTickLabelGroups());
            }
            return arrayList;
        }

        public int getSelectedTabIndex() {
            return this.mSelectedTabIndex;
        }

        protected boolean onMouseClicked(MouseEvent mouseEvent) {
            if (!super.onMouseClicked(mouseEvent)) {
                return false;
            }
            SGElementGroup sGElementGroup = this.getElementGroupAt(mouseEvent.getX(), mouseEvent.getY());
            int n = -1;
            if (sGElementGroup instanceof ElementGroupLine) {
                n = 0;
            } else if (sGElementGroup instanceof ElementGroupSymbol) {
                n = 1;
            } else if (sGElementGroup instanceof ElementGroupBar) {
                n = 2;
            }
            this.mSelectedTabIndex = n;
            return true;
        }

        private ElementGroupSetInSXYGraph getFirst() {
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mElementGroupSetList.get(0);
            return elementGroupSetInSXYGraph;
        }

        public int getXAxisConfiguration() {
            return this.getFirst().getXAxisConfiguration();
        }

        public int getYAxisConfiguration() {
            return this.getFirst().getYAxisConfiguration();
        }

        public boolean getLegendVisibleFlag() {
            return this.isVisibleInLegend();
        }

        public boolean synchronizeDrawingElement(ArrayList arrayList) {
            boolean bl = false;
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                boolean bl2 = elementGroupSetInSXYGraph.synchronizeDrawingElement(arrayList);
                if (!bl2) continue;
                bl = true;
            }
            return bl;
        }
    }

    private static interface IElementGroupSetInSXYGraph {
        public Rectangle2D getTickLabelsBoundingBox(SGData var1);

        public boolean setDrawingElementsLocation(SGData var1);

        public boolean paintDataString(Graphics2D var1);

        public boolean synchronizeDrawingElement(ArrayList var1);
    }
}

