/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIFigureDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SGGraphElement
extends SGFigureElement
implements SGIGraphElement,
SGIFigureDrawingElementConstants {
    protected SGIAxisElement mAxisElement = null;
    protected ArrayList mGroupSetList = new ArrayList();
    protected SGPropertyDialog mDialog = null;
    public static final int MAX_NUMBER_OF_ANCHORS = 8;

    public ArrayList getVisibleDataList() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            if (!elementGroupSetInGraph.isVisible()) continue;
            arrayList.add(this.mDataList.get(i));
        }
        return arrayList;
    }

    public String toString() {
        return new String("SGGraphElement");
    }

    public String getInstanceDescription() {
        return "Graph";
    }

    protected abstract boolean createDataDialog();

    protected abstract boolean setAllDrawingElementsLocation();

    public boolean setAxisElement(SGIAxisElement sGIAxisElement) {
        this.mAxisElement = sGIAxisElement;
        return true;
    }

    public String getDataName(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.getName();
        }
        return null;
    }

    public boolean setDataName(String string, SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph != null) {
            elementGroupSetInGraph.setName(string);
            return true;
        }
        return false;
    }

    public SGProperties getDataProperties(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.getWholeProperties();
        }
        return null;
    }

    public ArrayList getDrawingElementList(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.getDrawingElementList();
        }
        return null;
    }

    public ArrayList getVisibleFlagList(SGData sGData) {
        if (sGData == null) {
            throw new IllegalArgumentException("data==null");
        }
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph == null) {
            throw new Error();
        }
        ArrayList arrayList = elementGroupSetInGraph.getVisibleFlagList();
        return arrayList;
    }

    public boolean getVisibleInLegendFlag(SGData sGData) {
        if (sGData == null) {
            throw new IllegalArgumentException("data==null");
        }
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph == null) {
            throw new Error();
        }
        boolean bl = elementGroupSetInGraph.isVisibleInLegend();
        return bl;
    }

    public SGAxis getXAxis(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.getXAxis();
        }
        return null;
    }

    public SGAxis getYAxis(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.getYAxis();
        }
        return null;
    }

    public SGAxis getZAxis(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        if (elementGroupSetInGraph != null) {
            return elementGroupSetInGraph.mZAxis;
        }
        return null;
    }

    public boolean zoom(float f) {
        super.zoom(f);
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            elementGroupSetInGraph.zoom(f);
        }
        this.setAllDrawingElementsLocation();
        return true;
    }

    public boolean removeData(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        this.mDataList.remove(sGData);
        this.mGroupSetList.remove(elementGroupSetInGraph);
        return true;
    }

    public boolean setDataVisible(SGData sGData, boolean bl) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        elementGroupSetInGraph.setVisible(bl);
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        return this.setAllDrawingElementsLocation();
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (sGIFigureElement instanceof SGILegendElement) {
            SGILegendElement sGILegendElement = (SGILegendElement)sGIFigureElement;
            bl = this.synchronizeToLegendElement(sGILegendElement);
        } else if (sGIFigureElement instanceof SGIAxisElement) {
            SGIAxisElement sGIAxisElement = (SGIAxisElement)sGIFigureElement;
            bl = this.synchronizeToAxisElement(sGIAxisElement);
        } else if (!(sGIFigureElement instanceof SGIStringElement || sGIFigureElement instanceof SGIGraphElement || sGIFigureElement instanceof SGIAxisBreakElement || sGIFigureElement instanceof SGISignificantDifferenceElement || sGIFigureElement instanceof SGITimingLineElement || sGIFigureElement instanceof SGIGridElement)) {
            bl = this.synchronizeArgument(sGIFigureElement);
        }
        return bl;
    }

    protected boolean synchronizeToAxisElement(SGIAxisElement sGIAxisElement) {
        return this.setAllDrawingElementsLocation();
    }

    protected boolean synchronizeToLegendElement(SGILegendElement sGILegendElement) {
        ArrayList arrayList = sGILegendElement.getDataList();
        if (arrayList.size() != this.mDataList.size()) {
            throw new Error("dataList.size() != this.mDataList.size()");
        }
        ArrayList<SGData> arrayList2 = new ArrayList<SGData>();
        ArrayList<SGElementGroupSet> arrayList3 = new ArrayList<SGElementGroupSet>();
        block0: for (int i = 0; i < arrayList.size(); ++i) {
            SGData sGData = (SGData)arrayList.get(i);
            for (int j = this.mDataList.size() - 1; j >= 0; --j) {
                SGData sGData2 = (SGData)this.mDataList.get(j);
                if (!sGData.equals(sGData2)) continue;
                SGData sGData3 = (SGData)this.mDataList.remove(j);
                arrayList2.add(sGData3);
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.remove(j);
                arrayList3.add(sGElementGroupSet);
                continue block0;
            }
        }
        this.mDataList = arrayList2;
        this.mGroupSetList = arrayList3;
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error();
    }

    protected boolean isInsideAxisRange(SGTuple2d sGTuple2d, SGAxis sGAxis, SGAxis sGAxis2) {
        return sGAxis.insideRange(sGTuple2d.x) && sGAxis2.insideRange(sGTuple2d.y);
    }

    protected boolean calcLocationOfSXYData(SGSXYData sGSXYData, SGAxis sGAxis, SGAxis sGAxis2, SGTuple2f[] sGTuple2fArray) {
        int n;
        double[] dArray;
        int n2 = sGSXYData.getPointsNumber();
        SGTuple2d sGTuple2d = sGAxis.getRange();
        SGTuple2d sGTuple2d2 = sGAxis2.getRange();
        double d = sGTuple2d.x;
        double d2 = sGTuple2d.y;
        double d3 = sGTuple2d2.x;
        double d4 = sGTuple2d2.y;
        int n3 = sGAxis.getScaleType();
        int n4 = sGAxis2.getScaleType();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        if (n3 == 0) {
            d5 = d;
            d6 = d2;
            dArray = sGSXYData.getXValueArray();
            for (n = 0; n < n2; ++n) {
                dArray2[n] = dArray[n];
            }
        } else if (n3 == 1) {
            d5 = Math.log(d);
            d6 = Math.log(d2);
            dArray = sGSXYData.getXValueArray();
            for (n = 0; n < n2; ++n) {
                dArray2[n] = Math.log(dArray[n]);
            }
        }
        if (n4 == 0) {
            d7 = d3;
            d8 = d4;
            dArray = sGSXYData.getYValueArray();
            for (n = 0; n < n2; ++n) {
                dArray3[n] = dArray[n];
            }
        } else if (n4 == 1) {
            d7 = Math.log(d3);
            d8 = Math.log(d4);
            dArray = sGSXYData.getYValueArray();
            for (n = 0; n < n2; ++n) {
                dArray3[n] = Math.log(dArray[n]);
            }
        }
        float f = this.mGraphRectX;
        float f2 = this.mGraphRectY;
        float f3 = this.mGraphRectWidth;
        float f4 = this.mGraphRectHeight;
        for (int i = 0; i < n2; ++i) {
            float f5 = (float)((dArray2[i] - d5) / (d6 - d5));
            float f6 = (float)(1.0 - (dArray3[i] - d7) / (d8 - d7));
            float f7 = f + f5 * f3;
            float f8 = f2 + f6 * f4;
            sGTuple2fArray[i].setValues(f7, f8);
        }
        return true;
    }

    protected boolean calcLocationOfVXYData(SGTuple2d[] sGTuple2dArray, SGTuple2d[] sGTuple2dArray2, SGAxis sGAxis, SGAxis sGAxis2, SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2) {
        int n;
        int n2;
        if (sGTuple2dArray == null || sGTuple2dArray2 == null || sGTuple2fArray == null || sGTuple2fArray2 == null) {
            throw new IllegalArgumentException("startArray==null || endArray==null || startLocationArray==null || endLocationArray==null");
        }
        if (sGTuple2dArray.length != sGTuple2dArray2.length) {
            throw new IllegalArgumentException("startArray.length != endArray.length");
        }
        if (sGTuple2fArray.length != sGTuple2fArray2.length) {
            throw new IllegalArgumentException("startLocationArray.length != endLocationArray.length");
        }
        int n3 = sGTuple2dArray.length;
        SGTuple2d sGTuple2d = sGAxis.getRange();
        SGTuple2d sGTuple2d2 = sGAxis2.getRange();
        double d = sGTuple2d.x;
        double d2 = sGTuple2d.y;
        double d3 = sGTuple2d2.x;
        double d4 = sGTuple2d2.y;
        int n4 = sGAxis.getScaleType();
        int n5 = sGAxis2.getScaleType();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        if (n4 == 0) {
            d5 = d;
            d6 = d2;
            for (n2 = 0; n2 < n3; ++n2) {
                dArray[n2] = sGTuple2dArray[n2].x;
                dArray3[n2] = sGTuple2dArray2[n2].x;
            }
        } else if (n4 == 1) {
            d5 = Math.log(d);
            d6 = Math.log(d2);
            for (n2 = 0; n2 < n3; ++n2) {
                dArray[n2] = Math.log(sGTuple2dArray[n2].x);
                dArray3[n2] = Math.log(sGTuple2dArray2[n2].x);
            }
        }
        if (n5 == 0) {
            d7 = d3;
            d8 = d4;
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = sGTuple2dArray[n2].y;
                dArray4[n2] = sGTuple2dArray2[n2].y;
            }
        } else if (n5 == 1) {
            d7 = Math.log(d3);
            d8 = Math.log(d4);
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = Math.log(sGTuple2dArray[n2].y);
                dArray4[n2] = Math.log(sGTuple2dArray2[n2].y);
            }
        }
        float[] fArray = new float[n3];
        float[] fArray2 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            fArray[i] = (float)((dArray[i] - d5) / (d6 - d5));
            fArray2[i] = (float)(1.0 - (dArray2[i] - d7) / (d8 - d7));
        }
        float[] fArray3 = new float[n3];
        float[] fArray4 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            fArray3[i] = (float)((dArray3[i] - d5) / (d6 - d5));
            fArray4[i] = (float)(1.0 - (dArray4[i] - d7) / (d8 - d7));
        }
        float f = this.mGraphRectX;
        float f2 = this.mGraphRectY;
        float f3 = this.mGraphRectWidth;
        float f4 = this.mGraphRectHeight;
        for (n = 0; n < n3; ++n) {
            sGTuple2fArray[n].setValues(f + fArray[n] * f3, f2 + fArray2[n] * f4);
        }
        for (n = 0; n < n3; ++n) {
            sGTuple2fArray2[n].setValues(f + fArray3[n] * f3, f2 + fArray4[n] * f4);
        }
        return true;
    }

    public int getSelectedDataNumber() {
        return this.getFocusedObjectsList().size();
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        ArrayList arrayList2 = this.getVisibleElementGroupSetList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList2.get(i);
            if (!sGISelectable.isSelected()) continue;
            arrayList.add(sGISelectable);
        }
        return true;
    }

    public ArrayList getFocusedDataList() {
        ArrayList arrayList = this.getFocusedObjectsList();
        ArrayList<SGData> arrayList2 = new ArrayList<SGData>();
        for (int i = 0; i < arrayList.size(); ++i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
            SGData sGData = this.getData(elementGroupSetInGraph);
            arrayList2.add(sGData);
        }
        return arrayList2;
    }

    public ArrayList cutFocusedObjects() {
        return new ArrayList();
    }

    public ArrayList cutFocusedData() {
        ArrayList arrayList = this.getFocusedDataList();
        this.hideSelectedData();
        return arrayList;
    }

    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)sGISelectable;
        elementGroupSetInGraph.setVisible(false);
        return true;
    }

    protected boolean hideGroupSet(SGElementGroupSet sGElementGroupSet) {
        sGElementGroupSet.setVisible(false);
        return true;
    }

    protected boolean moveGroupSetToFront(SGElementGroupSet sGElementGroupSet) {
        SGData sGData = null;
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mGroupSetList.get(i))) continue;
            this.mGroupSetList.remove(i);
            sGData = (SGData)this.mDataList.remove(i);
            break;
        }
        if (sGData == null) {
            return false;
        }
        this.mGroupSetList.add(this.mGroupSetList.size(), sGElementGroupSet);
        this.mDataList.add(this.mDataList.size(), sGData);
        return true;
    }

    protected boolean moveGroupSetToBack(SGElementGroupSet sGElementGroupSet) {
        SGData sGData = null;
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mGroupSetList.get(i))) continue;
            this.mGroupSetList.remove(i);
            sGData = (SGData)this.mDataList.remove(i);
            break;
        }
        if (sGData == null) {
            return false;
        }
        this.mGroupSetList.add(0, sGElementGroupSet);
        this.mDataList.add(0, sGData);
        return true;
    }

    protected boolean removeGroupSet(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mGroupSetList.get(i))) continue;
            this.mGroupSetList.remove(i);
            this.mDataList.remove(i);
            return true;
        }
        return false;
    }

    protected boolean hideSelectedData() {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 0) {
            return true;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
            sGElementGroupSet.setVisible(false);
        }
        this.clearFocusedObjects();
        this.notifyChange();
        this.setChanged(true);
        return true;
    }

    public boolean isDataVisible(SGData sGData) {
        ElementGroupSetInGraph elementGroupSetInGraph = this.getElementGroupSet(sGData);
        return elementGroupSetInGraph.isVisible();
    }

    public boolean removeSelectedData() {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 0) {
            return true;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
            this.removeGroupSet(sGElementGroupSet);
        }
        this.notifyChange();
        this.setChanged(true);
        return true;
    }

    public boolean moveFocusedObjects(boolean bl) {
        if (bl) {
            return this.moveSelectedDataToFront();
        }
        return this.moveSelectedDataToBack();
    }

    public boolean moveSelectedDataToFront() {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 0) {
            return true;
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
            if (this.moveGroupSetToFront(sGElementGroupSet)) continue;
            return false;
        }
        this.notifyChange();
        this.setChanged(true);
        return true;
    }

    public boolean moveSelectedDataToBack() {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 0) {
            return true;
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)arrayList.get(i);
            if (this.moveGroupSetToBack(sGElementGroupSet)) continue;
            return false;
        }
        this.notifyChange();
        this.setChanged(true);
        return true;
    }

    protected ElementGroupSetInGraph getElementGroupSet(SGData sGData) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mGroupSetList.get(i);
            return elementGroupSetInGraph;
        }
        return null;
    }

    protected SGData getData(ElementGroupSetInGraph elementGroupSetInGraph) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.get(i);
            if (!sGElementGroupSet.equals(elementGroupSetInGraph)) continue;
            SGData sGData = (SGData)this.mDataList.get(i);
            return sGData;
        }
        return null;
    }

    public ArrayList getPropertyDialogObserverList() {
        return this.getFocusedObjectsList();
    }

    protected boolean drawAnchorsForFocusedObjects(Point2D point2D, Graphics2D graphics2D) {
        SGUtilityForFigureElement.drawAnchorAsFocusedObject(point2D, graphics2D);
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        ArrayList arrayList = this.mGroupSetList;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
            if (!elementGroupSetInGraph.isVisible() || !elementGroupSetInGraph.onMouseClicked(mouseEvent)) continue;
            return true;
        }
        return false;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        ArrayList arrayList = this.mGroupSetList;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
            if (!elementGroupSetInGraph.onMousePressed(mouseEvent)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        return this.getFocusedObjectsList().size() != 0;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        return true;
    }

    public boolean onDrawingElement(int n, int n2) {
        return false;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        return true;
    }

    public boolean setChangedFocusedObjects() {
        return true;
    }

    protected boolean drawRectangle(double d, double d2, double d3, double d4, Graphics2D graphics2D) {
        if (graphics2D == null) {
            return false;
        }
        Line2D.Double double_ = new Line2D.Double(d, d3, d2, d3);
        Line2D.Double double_2 = new Line2D.Double(d, d4, d2, d4);
        Line2D.Double double_3 = new Line2D.Double(d, d3, d, d4);
        Line2D.Double double_4 = new Line2D.Double(d2, d3, d2, d4);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
        graphics2D.draw(double_3);
        graphics2D.draw(double_4);
        return true;
    }

    public String getTagName() {
        return "Graph";
    }

    public Element createElement(Document document) {
        return null;
    }

    public boolean writeProperty(Element element) {
        return true;
    }

    public boolean readProperty(Element element) {
        return true;
    }

    public boolean createElementOfData(Document document, ArrayList arrayList) {
        ArrayList arrayList2 = this.getVisibleElementGroupSetList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList2.get(i);
            Element element = elementGroupSetInGraph.createElement(document);
            if (element == null) {
                return false;
            }
            element.setAttribute("Type", elementGroupSetInGraph.getDataClassName());
            arrayList.add(element);
        }
        return true;
    }

    public SGProperties getProperties() {
        GraphProperties graphProperties = new GraphProperties();
        if (!this.getProperties(graphProperties)) {
            return null;
        }
        return graphProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof GraphProperties)) {
            return false;
        }
        GraphProperties graphProperties = (GraphProperties)sGProperties;
        graphProperties.visibleElementGroupList = this.getVisibleElementGroupSetList();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof GraphProperties)) {
            return false;
        }
        GraphProperties graphProperties = (GraphProperties)sGProperties;
        boolean bl = this.setVisibleElementGroupList(graphProperties.visibleElementGroupList);
        return bl;
    }

    protected ArrayList getVisibleElementGroupSetList() {
        ArrayList<SGElementGroupSet> arrayList = new ArrayList<SGElementGroupSet>();
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.get(i);
            if (!sGElementGroupSet.isVisible()) continue;
            arrayList.add(sGElementGroupSet);
        }
        return arrayList;
    }

    public ArrayList getChildNodes() {
        return this.getVisibleElementGroupSetList();
    }

    protected boolean setVisibleElementGroupList(ArrayList arrayList) {
        ElementGroupSetInGraph elementGroupSetInGraph;
        int n;
        ArrayList arrayList2 = new ArrayList(arrayList);
        ArrayList<ElementGroupSetInGraph> arrayList3 = new ArrayList<ElementGroupSetInGraph>();
        ArrayList<SGData> arrayList4 = new ArrayList<SGData>();
        ArrayList<SGData> arrayList5 = new ArrayList<SGData>();
        for (n = 0; n < this.mGroupSetList.size(); ++n) {
            elementGroupSetInGraph = (ElementGroupSetInGraph)this.mGroupSetList.get(n);
            boolean bl = arrayList.contains(elementGroupSetInGraph);
            elementGroupSetInGraph.setVisible(bl);
            if (bl) continue;
            arrayList3.add(elementGroupSetInGraph);
            arrayList5.add(this.getData(elementGroupSetInGraph));
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList2.get(n);
            SGData sGData = this.getData(elementGroupSetInGraph);
            arrayList4.add(sGData);
        }
        this.mGroupSetList.clear();
        this.mDataList.clear();
        for (n = 0; n < arrayList2.size(); ++n) {
            this.mGroupSetList.add(arrayList2.get(n));
            this.mDataList.add(arrayList4.get(n));
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            this.mGroupSetList.add(arrayList3.get(n));
            this.mDataList.add(arrayList5.get(n));
        }
        return true;
    }

    public boolean addPropertiesHistory(SGProperties sGProperties) {
        if (!(sGProperties instanceof GraphProperties)) {
            return false;
        }
        boolean bl = super.addPropertiesHistory(sGProperties);
        return bl;
    }

    public boolean undo() {
        boolean bl = super.undo();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.setAllDrawingElementsLocation();
        this.notifyChange();
        return true;
    }

    public boolean redo() {
        boolean bl = super.redo();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.setAllDrawingElementsLocation();
        this.notifyChange();
        return true;
    }

    public boolean updateHistory() {
        return this.updateHistory_(this.getVisibleElementGroupSetList());
    }

    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        ArrayList arrayList = this.getVisibleElementGroupSetList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            if (!sGIUndoable.isChanged()) continue;
            return true;
        }
        return false;
    }

    public static class GraphProperties
    extends SGProperties {
        ArrayList visibleElementGroupList = new ArrayList();

        public boolean equals(Object object) {
            if (!(object instanceof GraphProperties)) {
                return false;
            }
            GraphProperties graphProperties = (GraphProperties)object;
            return graphProperties.visibleElementGroupList.equals(this.visibleElementGroupList);
        }
    }

    public static interface IElementGroupInGraph {
        public void setFocused(boolean var1);

        public boolean isFocused();
    }

    abstract class ElementGroupSetForMultipleData
    extends ElementGroupSetInGraph {
        protected ArrayList mElementGroupSetList = new ArrayList();

        protected ElementGroupSetForMultipleData() {
        }

        public ArrayList getVisibleFlagList() {
            if (this.mElementGroupSetList.size() == 0) {
                return new ArrayList();
            }
            ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mElementGroupSetList.get(0);
            ArrayList arrayList = elementGroupSetInGraph.getVisibleFlagList();
            return arrayList;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                SGISelectable sGISelectable = (SGISelectable)arrayList.get(i);
                sGISelectable.setSelected(bl);
            }
        }

        public boolean contains(int n, int n2) {
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
                if (!elementGroupSetInGraph.contains(n, n2)) continue;
                return true;
            }
            return false;
        }

        public SGElementGroup getElementGroupAt(int n, int n2) {
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
                SGElementGroup sGElementGroup = elementGroupSetInGraph.getElementGroupAt(n, n2);
                if (sGElementGroup == null) continue;
                return sGElementGroup;
            }
            return null;
        }

        public boolean setMagnification(float f) {
            super.setMagnification(f);
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mElementGroupSetList.get(i);
                sGElementGroupSet.setMagnification(f);
            }
            return true;
        }

        public boolean zoom(float f) {
            super.zoom(f);
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mElementGroupSetList.get(i);
                sGElementGroupSet.zoom(f);
            }
            return true;
        }

        public boolean addDrawingElementGroup(int n) {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                elementGroupSetInGraph.addDrawingElementGroup(n);
            }
            return true;
        }

        public boolean onDrawingElement(int n, int n2) {
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
                boolean bl = elementGroupSetInGraph.onDrawingElement(n, n2);
                if (!bl) continue;
                return true;
            }
            return false;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
                elementGroupSetInGraph.paintGraphics2D(graphics2D);
            }
        }

        public void setClipFlag(boolean bl) {
            super.setClipFlag(bl);
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList.get(i);
                elementGroupSetInGraph.setClipFlag(bl);
            }
        }

        public ArrayList getDrawingElementList() {
            ArrayList<SGDrawingElement> arrayList = new ArrayList<SGDrawingElement>();
            if (this.mElementGroupSetList.size() == 0) {
                return arrayList;
            }
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mElementGroupSetList.get(0);
            for (int i = 0; i < sGElementGroupSet.mDrawingElementGroupList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)sGElementGroupSet.mDrawingElementGroupList.get(i);
                SGDrawingElement sGDrawingElement = sGElementGroup.getDrawingElement();
                arrayList.add(sGDrawingElement);
            }
            return arrayList;
        }

        public boolean setDrawingElementProperties(ArrayList arrayList) {
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInGraph elementGroupSetInGraph = (ElementGroupSetInGraph)arrayList2.get(i);
                elementGroupSetInGraph.setDrawingElementProperties(arrayList);
            }
            return true;
        }
    }

    protected abstract class ElementGroupSetInGraph
    extends SGElementGroupSetInFigureElement
    implements ActionListener,
    SGIPropertyDialogObserver,
    SGISelectable,
    SGINode {
        protected boolean mClipFlag = true;
        protected boolean mSelectedFlag = false;
        protected SGProperties mTemporaryProperties = null;
        protected JPopupMenu mPopupMenu = new JPopupMenu();

        protected void setClipFlag(boolean bl) {
            this.mClipFlag = bl;
        }

        protected boolean getClipFlag() {
            return this.mClipFlag;
        }

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
            ArrayList arrayList = new ArrayList(this.mDrawingElementGroupList);
            for (int i = 0; i < arrayList.size(); ++i) {
                IElementGroupInGraph iElementGroupInGraph = (IElementGroupInGraph)arrayList.get(i);
                iElementGroupInGraph.setFocused(bl);
            }
        }

        protected ElementGroupSetInGraph() {
        }

        public ArrayList getVisibleFlagList() {
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
            ArrayList arrayList2 = new ArrayList(this.mDrawingElementGroupList);
            for (int i = 0; i < arrayList2.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
                boolean bl = sGElementGroup.isVisible();
                arrayList.add(bl);
            }
            return arrayList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Property")) {
                SGGraphElement.this.setPropertiesOfSelectedObjects();
            } else if (string.equals("Move to Front") | string.equals("Move to Back") | string.equals("Cut") | string.equals("Copy") | string.equals("Paste") | string.equals("Delete")) {
                SGGraphElement.this.notifyToListener(string);
            }
        }

        protected abstract boolean createDrawingElements();

        protected boolean onMouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            if (this.contains(n, n2)) {
                SGGraphElement.this.updateFocusedObjectsList(this, mouseEvent);
                if (SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 2) {
                    SGGraphElement.this.setPropertiesOfSelectedObjects();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) & n3 == 1) {
                    this.mPopupMenu.show(SGGraphElement.this, n, n2);
                }
                return true;
            }
            return false;
        }

        protected boolean onMousePressed(MouseEvent mouseEvent) {
            return this.contains(mouseEvent.getX(), mouseEvent.getY());
        }

        public boolean commit() {
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getWholeProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.mChangedFlag = true;
            }
            this.mTemporaryProperties = null;
            if (!SGGraphElement.this.setAllDrawingElementsLocation()) {
                return false;
            }
            SGGraphElement.this.repaint();
            SGGraphElement.this.notifyChange();
            return true;
        }

        public boolean cancel() {
            if (!this.setWholeProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            if (!SGGraphElement.this.setAllDrawingElementsLocation()) {
                return false;
            }
            SGGraphElement.this.repaint();
            SGGraphElement.this.notifyChange();
            return true;
        }

        public boolean preview() {
            if (!SGGraphElement.this.setAllDrawingElementsLocation()) {
                return false;
            }
            SGGraphElement.this.repaint();
            SGGraphElement.this.notifyChange();
            return true;
        }

        public ArrayList getChildNodes() {
            return new ArrayList();
        }

        public SGProperties getProperties() {
            ElementGroupSetInGraphProperties elementGroupSetInGraphProperties = new ElementGroupSetInGraphProperties();
            if (!this.getProperties(elementGroupSetInGraphProperties)) {
                return null;
            }
            return elementGroupSetInGraphProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ElementGroupSetInGraphProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            ElementGroupSetInGraphProperties elementGroupSetInGraphProperties = (ElementGroupSetInGraphProperties)sGProperties;
            elementGroupSetInGraphProperties.xAxis = SGGraphElement.this.mAxisElement.getConfigurationInCube(this.getXAxis());
            elementGroupSetInGraphProperties.yAxis = SGGraphElement.this.mAxisElement.getConfigurationInCube(this.getYAxis());
            elementGroupSetInGraphProperties.zAxis = SGGraphElement.this.mAxisElement.getConfigurationInCube(this.getZAxis());
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ElementGroupSetInGraphProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            ElementGroupSetInGraphProperties elementGroupSetInGraphProperties = (ElementGroupSetInGraphProperties)sGProperties;
            SGIAxisElement sGIAxisElement = SGGraphElement.this.mAxisElement;
            this.setXAxis(sGIAxisElement.getAxisInCube(elementGroupSetInGraphProperties.xAxis));
            this.setYAxis(sGIAxisElement.getAxisInCube(elementGroupSetInGraphProperties.yAxis));
            this.setZAxis(sGIAxisElement.getAxisInCube(elementGroupSetInGraphProperties.zAxis));
            return true;
        }

        public abstract String getDataClassName();

        public Element createElement(Document document) {
            Element element = super.createElement(document);
            element.setAttribute("Type", this.getDataClassName());
            return element;
        }

        public String getTagName() {
            return "Data";
        }

        public boolean setDrawingElementProperties(ArrayList arrayList) {
            ArrayList arrayList2 = this.mDrawingElementGroupList;
            if (arrayList.size() != arrayList2.size()) {
                throw new IllegalArgumentException("dElementList.size() != groupList.size()");
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
                SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(i);
                sGElementGroup.setProperty(sGDrawingElement);
            }
            return true;
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            SGGraphElement.this.setAllDrawingElementsLocation();
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            SGGraphElement.this.setAllDrawingElementsLocation();
            return true;
        }

        public void notifyToRoot() {
            SGGraphElement.this.notifyToRoot();
        }

        class ElementGroupSetInGraphProperties
        extends SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement {
            int xAxis;
            int yAxis;
            int zAxis;

            ElementGroupSetInGraphProperties() {
            }

            public boolean equals(Object object) {
                if (!(object instanceof ElementGroupSetInGraphProperties)) {
                    return false;
                }
                ElementGroupSetInGraphProperties elementGroupSetInGraphProperties = (ElementGroupSetInGraphProperties)object;
                if (!super.equals(object)) {
                    return false;
                }
                if (elementGroupSetInGraphProperties.xAxis != this.xAxis) {
                    return false;
                }
                if (elementGroupSetInGraphProperties.yAxis != this.yAxis) {
                    return false;
                }
                return elementGroupSetInGraphProperties.zAxis == this.zAxis;
            }
        }
    }
}

