/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIErrorBarConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGISymbolConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementErrorBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupVXY;
import org.w3c.dom.Element;

public abstract class SGElementGroupErrorBar
extends SGElementGroupVXY
implements SGILineConstants,
SGISymbolConstants,
SGIErrorBarConstants,
SGIArrowConstants {
    protected float mLineWidth;
    protected int mLineType;
    protected float mHeadSize;
    protected int mHeadType = -1;
    protected int mErrorBarStyle = 1;

    protected boolean initDrawingElement(int n) {
        SGDrawingElementErrorBar2D[] sGDrawingElementErrorBar2DArray = new SGDrawingElementErrorBar2D[n];
        for (int i = 0; i < n; ++i) {
            sGDrawingElementErrorBar2DArray[i] = new SGDrawingElementErrorBar2D();
        }
        this.mDrawingElementArray = sGDrawingElementErrorBar2DArray;
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2) {
        if (sGTuple2fArray == null || sGTuple2fArray2 == null) {
            throw new IllegalArgumentException("startArray==null || endArray==null");
        }
        if (sGTuple2fArray.length != sGTuple2fArray2.length) {
            throw new IllegalArgumentException("startArray.length != endArray.length");
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            throw new IllegalArgumentException("startArray.length != this.mDrawingElementArray.length");
        }
        SGDrawingElementErrorBar2D[] sGDrawingElementErrorBar2DArray = (SGDrawingElementErrorBar2D[])this.mDrawingElementArray;
        if (sGDrawingElementErrorBar2DArray == null) {
            return false;
        }
        for (int i = 0; i < sGDrawingElementErrorBar2DArray.length; ++i) {
            boolean bl = !sGTuple2fArray[i].isInfinite() && !sGTuple2fArray[i].isNaN() && !sGTuple2fArray2[i].isInfinite() && !sGTuple2fArray2[i].isNaN();
            sGDrawingElementErrorBar2DArray[i].setVisible(bl);
            if (!bl) continue;
            sGDrawingElementErrorBar2DArray[i].setTermPoints(sGTuple2fArray[i], sGTuple2fArray2[i]);
        }
        return true;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public void setLineWidth(float f) {
        this.mLineWidth = f;
        SGDrawingElementErrorBar2D[] sGDrawingElementErrorBar2DArray = (SGDrawingElementErrorBar2D[])this.mDrawingElementArray;
        if (sGDrawingElementErrorBar2DArray == null) {
            return;
        }
        for (int i = 0; i < sGDrawingElementErrorBar2DArray.length; ++i) {
            sGDrawingElementErrorBar2DArray[i].setLineWidth(f);
        }
    }

    public float getHeadSize() {
        return this.mHeadSize;
    }

    public void setHeadSize(float f) {
        this.mHeadSize = f;
        SGDrawingElementErrorBar2D[] sGDrawingElementErrorBar2DArray = (SGDrawingElementErrorBar2D[])this.mDrawingElementArray;
        if (sGDrawingElementErrorBar2DArray == null) {
            return;
        }
        for (int i = 0; i < sGDrawingElementErrorBar2DArray.length; ++i) {
            sGDrawingElementErrorBar2DArray[i].setHeadSize(f);
        }
    }

    public int getErrorBarStyle() {
        return this.mErrorBarStyle;
    }

    public void setErrorBarStyle(int n) {
        this.mErrorBarStyle = n;
        SGDrawingElementErrorBar2D[] sGDrawingElementErrorBar2DArray = (SGDrawingElementErrorBar2D[])this.mDrawingElementArray;
        if (sGDrawingElementErrorBar2DArray == null) {
            return;
        }
        for (int i = 0; i < sGDrawingElementErrorBar2DArray.length; ++i) {
            sGDrawingElementErrorBar2DArray[i].setErrorBarStyle(n);
        }
    }

    public String getTagName() {
        return "ErrorBar";
    }

    public boolean writeProperty(Element element) {
        String string = "cm";
        String string2 = "pt";
        element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
        element.setAttribute("Style", SGDrawingElementErrorBar.getErrorBarStyleName(this.mErrorBarStyle));
        element.setAttribute("Width", Float.toString(this.mLineWidth) + string2);
        element.setAttribute("HeadSize", Float.toString(this.mHeadSize * 0.035277776f) + string);
        element.setAttribute("HeadType", SGDrawingElementSymbol.getSymbolTypeName(this.getHeadType()));
        element.setAttribute("Color", SGUtilityText.getColorListString(this.mColorList));
        return true;
    }

    public SGProperties readProperties(Element element) {
        String string = null;
        Number number = null;
        Object var7_4 = null;
        Boolean bl = null;
        ArrayList arrayList = null;
        ErrorBarProperties errorBarProperties = new ErrorBarProperties();
        string = element.getAttribute("Visible");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        errorBarProperties.setVisible(bl);
        string = element.getAttribute("Color");
        if (string.length() == 0) {
            return null;
        }
        arrayList = SGUtilityText.getColorList(string);
        if (arrayList == null) {
            return null;
        }
        errorBarProperties.setColorList(arrayList);
        string = element.getAttribute("Width");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getFloat(string, "pt");
        if (number == null) {
            return null;
        }
        float f = number.floatValue();
        errorBarProperties.setLineWidth(f);
        string = element.getAttribute("HeadSize");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getFloat(string, "cm");
        if (number == null) {
            return null;
        }
        errorBarProperties.setHeadSize(number.floatValue() / 0.035277776f);
        string = element.getAttribute("Style");
        if (string.length() == 0) {
            return null;
        }
        number = SGDrawingElementErrorBar.getErrorBarStyleFromName(string);
        if (number == null) {
            return null;
        }
        int n = number.intValue();
        errorBarProperties.setErrorBarStyle(n);
        string = element.getAttribute("HeadType");
        if (string.length() == 0) {
            return null;
        }
        Integer n2 = SGDrawingElementErrorBar.getHeadTypeFromName(string);
        if (n2 == null) {
            return null;
        }
        int n3 = n2;
        errorBarProperties.setHeadType(n3);
        return errorBarProperties;
    }

    public int getHeadType() {
        return this.mHeadType;
    }

    public void setHeadType(int n) {
        this.mHeadType = n;
        SGDrawingElementErrorBar2D[] sGDrawingElementErrorBar2DArray = (SGDrawingElementErrorBar2D[])this.mDrawingElementArray;
        if (sGDrawingElementErrorBar2DArray == null) {
            return;
        }
        for (int i = 0; i < sGDrawingElementErrorBar2DArray.length; ++i) {
            sGDrawingElementErrorBar2DArray[i].setHeadType(n);
        }
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementErrorBar2D sGDrawingElementErrorBar2D = new SGDrawingElementErrorBar2D();
        sGDrawingElementErrorBar2D.setVisible(this.isVisible());
        sGDrawingElementErrorBar2D.setLineWidth(this.getLineWidth());
        sGDrawingElementErrorBar2D.setColor(this.getColorList());
        sGDrawingElementErrorBar2D.setHeadSize(this.getHeadSize());
        sGDrawingElementErrorBar2D.setHeadType(this.getHeadType());
        sGDrawingElementErrorBar2D.setErrorBarStyle(this.getErrorBarStyle());
        return sGDrawingElementErrorBar2D;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        SGDrawingElement[] sGDrawingElementArray;
        Area area = null;
        if (rectangle2D != null) {
            area = new Area(rectangle2D);
        }
        if ((sGDrawingElementArray = this.mDrawingElementArray) != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementErrorBar2D sGDrawingElementErrorBar2D = (SGDrawingElementErrorBar2D)sGDrawingElementArray[i];
                if (!sGDrawingElementErrorBar2D.isVisible()) continue;
                sGDrawingElementErrorBar2D.paint(graphics2D, rectangle2D);
            }
        }
        return true;
    }

    public SGProperties getProperties() {
        ErrorBarProperties errorBarProperties = new ErrorBarProperties();
        if (!this.getProperties(errorBarProperties)) {
            return null;
        }
        return errorBarProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ErrorBarProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        ErrorBarProperties errorBarProperties = (ErrorBarProperties)sGProperties;
        errorBarProperties.setLineWidth(this.getLineWidth());
        errorBarProperties.setHeadSize(this.getHeadSize());
        errorBarProperties.setHeadType(this.getHeadType());
        errorBarProperties.setErrorBarStyle(this.getErrorBarStyle());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ErrorBarProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        ErrorBarProperties errorBarProperties = (ErrorBarProperties)sGProperties;
        this.setLineWidth(errorBarProperties.getLineWidth().floatValue());
        this.setHeadSize(errorBarProperties.getHeadSize().floatValue());
        this.setHeadType(errorBarProperties.getHeadType());
        Integer n = errorBarProperties.getErrorBarStyle();
        if (n == null) {
            return false;
        }
        this.setErrorBarStyle(n);
        return true;
    }

    public boolean setPropertiesOfDrawingElements() {
        SGDrawingElementErrorBar2D[] sGDrawingElementErrorBar2DArray = (SGDrawingElementErrorBar2D[])this.mDrawingElementArray;
        float f = this.getMagnification();
        ArrayList arrayList = this.getColorList();
        float f2 = this.getLineWidth();
        float f3 = this.getHeadSize();
        int n = this.getHeadType();
        int n2 = this.getErrorBarStyle();
        for (int i = 0; i < sGDrawingElementErrorBar2DArray.length; ++i) {
            SGDrawingElementErrorBar2D sGDrawingElementErrorBar2D = sGDrawingElementErrorBar2DArray[i];
            sGDrawingElementErrorBar2D.setErrorBarStyle(n2);
            sGDrawingElementErrorBar2D.setMagnification(f);
            sGDrawingElementErrorBar2D.setColor(arrayList);
            sGDrawingElementErrorBar2D.setLineWidth(f2);
            sGDrawingElementErrorBar2D.setHeadSize(f3);
            sGDrawingElementErrorBar2D.setHeadType(n);
        }
        return true;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementErrorBar)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementErrorBar sGDrawingElementErrorBar = (SGDrawingElementErrorBar)sGDrawingElement;
        this.setLineWidth(sGDrawingElementErrorBar.getLineWidth());
        this.setHeadSize(sGDrawingElementErrorBar.getHeadSize());
        this.setLineWidth(sGDrawingElementErrorBar.getLineWidth());
        this.setHeadType(sGDrawingElementErrorBar.getHeadType());
        this.setErrorBarStyle(sGDrawingElementErrorBar.getErrorBarStyle());
        return true;
    }

    public static class ErrorBarProperties
    extends SGElementGroup.ElementGroupProperties {
        private SGDrawingElementErrorBar.ErrorBarProperties mErrorBarProperties = new SGDrawingElementErrorBar.ErrorBarProperties();

        public boolean equals(Object object) {
            if (!(object instanceof ErrorBarProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ErrorBarProperties errorBarProperties = (ErrorBarProperties)object;
            return this.mErrorBarProperties.equals(errorBarProperties.mErrorBarProperties);
        }

        public Float getLineWidth() {
            return this.mErrorBarProperties.getLineWidth();
        }

        public Float getHeadSize() {
            return this.mErrorBarProperties.getHeadSize();
        }

        public Integer getHeadType() {
            return this.mErrorBarProperties.getHeadType();
        }

        public void setColorList(ArrayList arrayList) {
            super.setColorList(arrayList);
            this.mErrorBarProperties.setColor(arrayList);
        }

        public void setLineWidth(float f) {
            this.mErrorBarProperties.setLineWidth(f);
        }

        public void setHeadSize(float f) {
            this.mErrorBarProperties.setHeadSize(f);
        }

        public void setHeadType(int n) {
            this.mErrorBarProperties.setHeadType(n);
        }

        public Integer getErrorBarStyle() {
            return this.mErrorBarProperties.getErrorBarStyle();
        }

        public void setErrorBarStyle(int n) {
            this.mErrorBarProperties.setErrorBarStyle(n);
        }
    }
}

