/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import javax.swing.text.JTextComponent;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGTwoAxesRadioButtonManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIXYFigureDialogObserver;

public class SGXYFigureDialog
extends SGPropertyDialog
implements SGILineConstants {
    public static final String TITLE = "Figure Properties";
    private SGCheckBox mAutoCheckBox;
    private JPanel mAxisPanel;
    private SGColorSelectionButton mBackgroundColorButton;
    private JLabel mBackgroundColorLabel;
    private JLabel mBaseXValueLabel;
    private SGTextField mBaseXValueTextField;
    private JLabel mBaseYValueLabel;
    private SGTextField mBaseYValueTextField;
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JSeparator mColorSeparator;
    private JPanel mFigurePanel;
    private JButton mGridDialogButton;
    private JLabel mGridLabel;
    private JPanel mGridPanel;
    private SGCheckBox mGridVisibleCheckBox;
    private JLabel mHeightLabel;
    private SGSpinner mHeightSpinner;
    private JPanel mInnerGridPanel;
    private JRadioButton mLeftBottomRadioButton;
    private JLabel mLeftSpaceLabel;
    private JRadioButton mLeftTopRadioButton;
    private SGCheckBox mLegendVisibleCheckBox;
    private JLabel mLegendVisibleLabel;
    private SGColorSelectionButton mLineColorButton;
    private JLabel mLineColorLabel;
    private JLabel mLineLabel;
    private JSeparator mLineSeparator;
    private JComboBox mLineTypeComboBox;
    private JLabel mLineTypeLabel;
    private JLabel mLineWidthLabel;
    private SGSpinner mLineWidthSpinner;
    private JLabel mLocationLabel;
    private JLabel mLocationLabel1;
    private JSeparator mLocationSeparator;
    private JSeparator mLocationSeparator1;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JRadioButton mRightBottomRadioButton;
    private JLabel mRightSpaceLabel;
    private JRadioButton mRightTopRadioButton;
    private JLabel mScaleReferenceLabel1;
    private JLabel mScaleReferenceLabel2;
    private JLabel mSizeLabel;
    private JSeparator mSizeSeparator;
    private JLabel mSpaceLabel;
    private JLabel mSpaceLineAndScaleLabel;
    private SGSpinner mSpaceLineAndScaleSpinner;
    private JLabel mSpaceScaleAndTitleLabel;
    private SGSpinner mSpaceScaleAndTitleSpinner;
    private JSeparator mSpaceSeparator;
    private JLabel mStepXValueLabel;
    private SGTextField mStepXValueTextField;
    private JLabel mStepYValueLabel;
    private SGTextField mStepYValueTextField;
    private JTabbedPane mTabbedPane;
    private SGCheckBox mTransparentCheckBox;
    private JLabel mWidthLabel;
    private SGSpinner mWidthSpinner;
    private JLabel mXLabel;
    private SGSpinner mXSpinner;
    private JLabel mYLabel;
    private SGSpinner mYSpinner;
    public static final String SHOW_GRID_DIALOG = "Show Dialog";
    private SGTwoAxesRadioButtonManager mAxesButtonGroup = null;

    public SGXYFigureDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mGridLabel = new JLabel();
        this.mGridDialogButton = new JButton();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mTabbedPane = new JTabbedPane();
        this.mFigurePanel = new JPanel();
        this.mWidthLabel = new JLabel();
        this.mHeightLabel = new JLabel();
        this.mWidthSpinner = new SGSpinner();
        this.mHeightSpinner = new SGSpinner();
        this.mLocationLabel = new JLabel();
        this.mSizeLabel = new JLabel();
        this.mXLabel = new JLabel();
        this.mXSpinner = new SGSpinner();
        this.mYLabel = new JLabel();
        this.mYSpinner = new SGSpinner();
        this.mSpaceLabel = new JLabel();
        this.mSpaceLineAndScaleLabel = new JLabel();
        this.mSpaceScaleAndTitleLabel = new JLabel();
        this.mSpaceLineAndScaleSpinner = new SGSpinner();
        this.mSpaceScaleAndTitleSpinner = new SGSpinner();
        this.mBackgroundColorLabel = new JLabel();
        this.mBackgroundColorButton = new SGColorSelectionButton();
        this.mLegendVisibleCheckBox = new SGCheckBox();
        this.mLegendVisibleLabel = new JLabel();
        this.mLocationSeparator = new JSeparator();
        this.mSizeSeparator = new JSeparator();
        this.mSpaceSeparator = new JSeparator();
        this.mColorSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mTransparentCheckBox = new SGCheckBox();
        this.mGridPanel = new JPanel();
        this.mInnerGridPanel = new JPanel();
        this.mLineLabel = new JLabel();
        this.mLineSeparator = new JSeparator();
        this.mGridVisibleCheckBox = new SGCheckBox();
        this.mLocationLabel1 = new JLabel();
        this.mLocationSeparator1 = new JSeparator();
        this.mStepXValueLabel = new JLabel();
        this.mStepXValueTextField = new SGTextField();
        this.mBaseXValueLabel = new JLabel();
        this.mBaseXValueTextField = new SGTextField();
        this.mStepYValueLabel = new JLabel();
        this.mStepYValueTextField = new SGTextField();
        this.mBaseYValueLabel = new JLabel();
        this.mBaseYValueTextField = new SGTextField();
        this.mLineTypeLabel = new JLabel();
        this.mLineTypeComboBox = new JComboBox();
        this.mLineWidthLabel = new JLabel();
        this.mLineWidthSpinner = new SGSpinner();
        this.mLineColorLabel = new JLabel();
        this.mLineColorButton = new SGColorSelectionButton();
        this.mAutoCheckBox = new SGCheckBox();
        this.mAxisPanel = new JPanel();
        this.mLeftTopRadioButton = new JRadioButton();
        this.mLeftBottomRadioButton = new JRadioButton();
        this.mRightTopRadioButton = new JRadioButton();
        this.mRightBottomRadioButton = new JRadioButton();
        this.mScaleReferenceLabel2 = new JLabel();
        this.mScaleReferenceLabel1 = new JLabel();
        this.mGridLabel.setFont(new Font("Dialog", 3, 12));
        this.mGridLabel.setText("Grid ");
        this.mGridDialogButton.setFont(new Font("Dialog", 0, 12));
        this.mGridDialogButton.setText(SHOW_GRID_DIALOG);
        this.getContentPane().setLayout(new GridBagLayout());
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mTabbedPane.setFont(new Font("Dialog", 1, 12));
        this.mFigurePanel.setLayout(new GridBagLayout());
        this.mFigurePanel.setFont(new Font("Dialog", 0, 12));
        this.mWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mFigurePanel.add((Component)this.mWidthLabel, gridBagConstraints);
        this.mHeightLabel.setFont(new Font("Dialog", 0, 12));
        this.mHeightLabel.setText("Height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mFigurePanel.add((Component)this.mHeightLabel, gridBagConstraints);
        this.mWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mWidthSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mWidthSpinner, gridBagConstraints);
        this.mHeightSpinner.setFont(new Font("Dialog", 0, 12));
        this.mHeightSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mHeightSpinner, gridBagConstraints);
        this.mLocationLabel.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mLocationLabel, gridBagConstraints);
        this.mSizeLabel.setFont(new Font("Dialog", 3, 12));
        this.mSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mSizeLabel, gridBagConstraints);
        this.mXLabel.setFont(new Font("Dialog", 0, 12));
        this.mXLabel.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mFigurePanel.add((Component)this.mXLabel, gridBagConstraints);
        this.mXSpinner.setFont(new Font("Dialog", 0, 12));
        this.mXSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mXSpinner, gridBagConstraints);
        this.mYLabel.setFont(new Font("Dialog", 0, 12));
        this.mYLabel.setText("Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mFigurePanel.add((Component)this.mYLabel, gridBagConstraints);
        this.mYSpinner.setFont(new Font("Dialog", 0, 12));
        this.mYSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mYSpinner, gridBagConstraints);
        this.mSpaceLabel.setFont(new Font("Dialog", 3, 12));
        this.mSpaceLabel.setText("Space");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mSpaceLabel, gridBagConstraints);
        this.mSpaceLineAndScaleLabel.setFont(new Font("Dialog", 0, 12));
        this.mSpaceLineAndScaleLabel.setText("to Scale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mFigurePanel.add((Component)this.mSpaceLineAndScaleLabel, gridBagConstraints);
        this.mSpaceScaleAndTitleLabel.setFont(new Font("Dialog", 0, 12));
        this.mSpaceScaleAndTitleLabel.setText("to Title");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mFigurePanel.add((Component)this.mSpaceScaleAndTitleLabel, gridBagConstraints);
        this.mSpaceLineAndScaleSpinner.setFont(new Font("Dialog", 0, 12));
        this.mSpaceLineAndScaleSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mSpaceLineAndScaleSpinner, gridBagConstraints);
        this.mSpaceScaleAndTitleSpinner.setFont(new Font("Dialog", 0, 12));
        this.mSpaceScaleAndTitleSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mSpaceScaleAndTitleSpinner, gridBagConstraints);
        this.mBackgroundColorLabel.setFont(new Font("Dialog", 3, 12));
        this.mBackgroundColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mBackgroundColorLabel, gridBagConstraints);
        this.mBackgroundColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mBackgroundColorButton, gridBagConstraints);
        this.mLegendVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mLegendVisibleCheckBox.setText("Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mLegendVisibleCheckBox, gridBagConstraints);
        this.mLegendVisibleLabel.setFont(new Font("Dialog", 3, 12));
        this.mLegendVisibleLabel.setText("Legend ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mLegendVisibleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 60, 0, 0);
        this.mFigurePanel.add((Component)this.mLocationSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 35, 0, 0);
        this.mFigurePanel.add((Component)this.mSizeSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 48, 0, 0);
        this.mFigurePanel.add((Component)this.mSpaceSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 45, 0, 0);
        this.mFigurePanel.add((Component)this.mColorSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mFigurePanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mFigurePanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mTransparentCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mTransparentCheckBox.setText("Transparency");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mFigurePanel.add((Component)this.mTransparentCheckBox, gridBagConstraints);
        this.mTabbedPane.addTab("Figure", this.mFigurePanel);
        this.mGridPanel.setLayout(new GridBagLayout());
        this.mGridPanel.setFont(new Font("Dialog", 0, 12));
        this.mInnerGridPanel.setLayout(new GridBagLayout());
        this.mInnerGridPanel.setBorder(new BevelBorder(0));
        this.mLineLabel.setFont(new Font("Dialog", 3, 12));
        this.mLineLabel.setText("Line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 10, 0, 5);
        this.mInnerGridPanel.add((Component)this.mLineLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 40, 0, 10);
        this.mInnerGridPanel.add((Component)this.mLineSeparator, gridBagConstraints);
        this.mGridVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mGridVisibleCheckBox.setText("Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.mInnerGridPanel.add((Component)this.mGridVisibleCheckBox, gridBagConstraints);
        this.mLocationLabel1.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel1.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 5, 5);
        this.mInnerGridPanel.add((Component)this.mLocationLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 65, 5, 10);
        this.mInnerGridPanel.add((Component)this.mLocationSeparator1, gridBagConstraints);
        this.mStepXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mStepXValueLabel.setText("Step X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mInnerGridPanel.add((Component)this.mStepXValueLabel, gridBagConstraints);
        this.mStepXValueTextField.setColumns(6);
        this.mStepXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mInnerGridPanel.add((Component)this.mStepXValueTextField, gridBagConstraints);
        this.mBaseXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mBaseXValueLabel.setText("Base X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mInnerGridPanel.add((Component)this.mBaseXValueLabel, gridBagConstraints);
        this.mBaseXValueTextField.setColumns(6);
        this.mBaseXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mInnerGridPanel.add((Component)this.mBaseXValueTextField, gridBagConstraints);
        this.mStepYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mStepYValueLabel.setText("Step Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mInnerGridPanel.add((Component)this.mStepYValueLabel, gridBagConstraints);
        this.mStepYValueTextField.setColumns(6);
        this.mStepYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mInnerGridPanel.add((Component)this.mStepYValueTextField, gridBagConstraints);
        this.mBaseYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mBaseYValueLabel.setText("Base Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mInnerGridPanel.add((Component)this.mBaseYValueLabel, gridBagConstraints);
        this.mBaseYValueTextField.setColumns(6);
        this.mBaseYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mInnerGridPanel.add((Component)this.mBaseYValueTextField, gridBagConstraints);
        this.mLineTypeLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineTypeLabel.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mInnerGridPanel.add((Component)this.mLineTypeLabel, gridBagConstraints);
        this.mLineTypeComboBox.setFont(new Font("Dialog", 0, 12));
        this.mLineTypeComboBox.setPreferredSize(new Dimension(140, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mInnerGridPanel.add((Component)this.mLineTypeComboBox, gridBagConstraints);
        this.mLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mInnerGridPanel.add((Component)this.mLineWidthLabel, gridBagConstraints);
        this.mLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthSpinner.setPreferredSize(new Dimension(75, 22));
        this.mLineWidthSpinner.setMinimumSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mInnerGridPanel.add((Component)this.mLineWidthSpinner, gridBagConstraints);
        this.mLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mInnerGridPanel.add((Component)this.mLineColorLabel, gridBagConstraints);
        this.mLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mInnerGridPanel.add((Component)this.mLineColorButton, gridBagConstraints);
        this.mAutoCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mAutoCheckBox.setText("Auto");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.mInnerGridPanel.add((Component)this.mAutoCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mGridPanel.add((Component)this.mInnerGridPanel, gridBagConstraints);
        this.mAxisPanel.setLayout(new GridBagLayout());
        this.mLeftTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftTopRadioButton.setText("Left/Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mAxisPanel.add((Component)this.mLeftTopRadioButton, gridBagConstraints);
        this.mLeftBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftBottomRadioButton.setText("Left/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mAxisPanel.add((Component)this.mLeftBottomRadioButton, gridBagConstraints);
        this.mRightTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightTopRadioButton.setText("Right/Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mAxisPanel.add((Component)this.mRightTopRadioButton, gridBagConstraints);
        this.mRightBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightBottomRadioButton.setText("Right/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mAxisPanel.add((Component)this.mRightBottomRadioButton, gridBagConstraints);
        this.mScaleReferenceLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.mAxisPanel.add((Component)this.mScaleReferenceLabel2, gridBagConstraints);
        this.mScaleReferenceLabel1.setFont(new Font("Dialog", 1, 12));
        this.mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        this.mAxisPanel.add((Component)this.mScaleReferenceLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.mGridPanel.add((Component)this.mAxisPanel, gridBagConstraints);
        this.mTabbedPane.addTab("Grid", this.mGridPanel);
        this.getContentPane().add((Component)this.mTabbedPane, new GridBagConstraints());
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mXSpinner.setDigitForRoundingOut(-2);
        this.mXSpinner.initProperties(new SpinnerNumberModel(0.0, -50.0, 150.0, 1.0), " cm");
        this.mXSpinner.setMinimumFractionDigits(1);
        this.mXSpinner.setMaximumFractionDigits(1);
        this.mYSpinner.setDigitForRoundingOut(-2);
        this.mYSpinner.initProperties(new SpinnerNumberModel(0.0, -50.0, 150.0, 1.0), " cm");
        this.mYSpinner.setMinimumFractionDigits(1);
        this.mYSpinner.setMaximumFractionDigits(1);
        this.mWidthSpinner.setDigitForRoundingOut(-2);
        this.mWidthSpinner.initProperties(new SpinnerNumberModel(10.0, 1.0, 50.0, 1.0), " cm");
        this.mWidthSpinner.setMinimumFractionDigits(1);
        this.mWidthSpinner.setMaximumFractionDigits(1);
        this.mHeightSpinner.setDigitForRoundingOut(-2);
        this.mHeightSpinner.initProperties(new SpinnerNumberModel(10.0, 1.0, 50.0, 1.0), " cm");
        this.mHeightSpinner.setMinimumFractionDigits(1);
        this.mHeightSpinner.setMaximumFractionDigits(1);
        this.mSpaceLineAndScaleSpinner.initProperties(new SpinnerNumberModel(0.0, 0.0, 5.0, 0.1), " cm");
        this.mSpaceScaleAndTitleSpinner.initProperties(new SpinnerNumberModel(0.0, 0.0, 5.0, 0.1), " cm");
        JComboBox jComboBox = this.mLineTypeComboBox;
        String[] stringArray = new String[]{"Solid", "Broken", "Dotted", "Dashed", "Double Dashed"};
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox.addItem(stringArray[i]);
        }
        this.pack();
        this.mAxesButtonGroup = new SGTwoAxesRadioButtonManager(this.mLeftBottomRadioButton, this.mLeftTopRadioButton, this.mRightBottomRadioButton, this.mRightTopRadioButton, new JRadioButton());
        this.mLineWidthSpinner.initProperties(this.getLineWidthSpinnerNumberModel(), " pt");
        this.mFocusedColorSetButton = this.mBackgroundColorButton;
        this.mTransparentCheckBox.addActionListener(this);
        this.mLegendVisibleCheckBox.addActionListener(this);
        this.mGridVisibleCheckBox.addActionListener(this);
        this.mAutoCheckBox.addActionListener(this);
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mTransparentCheckBox)) {
            this.setFigureTransparent(this.isFigureTransparent());
        } else if (!object.equals(this.mLegendVisibleCheckBox)) {
            if (object.equals(this.mGridDialogButton)) {
                this.mColorDialog.setVisible(false);
            } else if (object.equals(this.mGridVisibleCheckBox)) {
                this.setGridVisible(this.mGridVisibleCheckBox.getSelected());
            } else if (object.equals(this.mAutoCheckBox)) {
                this.setAutoFlag(this.mAutoCheckBox.getSelected());
            }
        }
    }

    public Number getFigureX() {
        return this.mXSpinner.getNumber();
    }

    public Number getFigureY() {
        return this.mYSpinner.getNumber();
    }

    public Number getFigureWidth() {
        return this.mWidthSpinner.getNumber();
    }

    public Number getFigureHeight() {
        return this.mHeightSpinner.getNumber();
    }

    public Number getSpaceLineAndNumber() {
        return this.mSpaceLineAndScaleSpinner.getNumber();
    }

    public Number getSpaceNumberAndTitle() {
        return this.mSpaceScaleAndTitleSpinner.getNumber();
    }

    public Color getFigureBackgroundColor() {
        return this.mBackgroundColorButton.getColor();
    }

    public Boolean isFigureTransparent() {
        return this.mTransparentCheckBox.getSelected();
    }

    public Boolean getFigureLegendVisible() {
        return this.mLegendVisibleCheckBox.getSelected();
    }

    public boolean setFigureX(Object object) {
        return this.setValue(this.mXSpinner, object);
    }

    public boolean setFigureY(Object object) {
        return this.setValue(this.mYSpinner, object);
    }

    public boolean setFigureWidth(Object object) {
        return this.setValue(this.mWidthSpinner, object);
    }

    public boolean setFigureHeight(Object object) {
        return this.setValue(this.mHeightSpinner, object);
    }

    public boolean setFigureSpaceLineAndNumber(Object object) {
        return this.setValue(this.mSpaceLineAndScaleSpinner, object);
    }

    public boolean setFigureSpaceNumberAndTitle(Object object) {
        return this.setValue(this.mSpaceScaleAndTitleSpinner, object);
    }

    public boolean setFigureBackgroundColor(Color color) {
        this.mBackgroundColorButton.setColor(color);
        return true;
    }

    public boolean setFigureTransparent(Boolean bl) {
        this.mTransparentCheckBox.setSelected(bl);
        this.setBackgroundComponentsEnabled(bl);
        return true;
    }

    private boolean setBackgroundComponentsEnabled(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl == false;
        }
        this.mBackgroundColorButton.setEnabled(bl2);
        return true;
    }

    public boolean setFigureLegendVisible(Boolean bl) {
        this.mLegendVisibleCheckBox.setSelected(bl);
        return true;
    }

    public void setGridVisible(Boolean bl) {
        this.mGridVisibleCheckBox.setSelected(bl);
        this.setGridComponentsEnabled(bl);
    }

    private void setGridComponentsEnabled(Boolean bl) {
        boolean bl2 = false;
        if (bl != null) {
            bl2 = bl;
        }
        this.setGridComponentsEnabled(bl2);
    }

    private void setGridComponentsEnabled(boolean bl) {
        Component[] componentArray = new Component[]{this.mScaleReferenceLabel1, this.mScaleReferenceLabel2, this.mLeftBottomRadioButton, this.mLeftTopRadioButton, this.mRightBottomRadioButton, this.mRightTopRadioButton, this.mLocationLabel1, this.mLineLabel, this.mAutoCheckBox, this.mLineWidthLabel, this.mLineWidthSpinner, this.mLineTypeLabel, this.mLineTypeComboBox, this.mLineColorLabel, this.mLineColorButton};
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
        }
        this.setScaleComponentsEnabled(bl);
    }

    public void setAutoFlag(Boolean bl) {
        this.mAutoCheckBox.setSelected(bl);
        this.setScaleComponentsEditable(bl);
        this.setScaleComponentsEnabled(bl);
    }

    private void setScaleComponentsEnabled(Boolean bl) {
        boolean bl2;
        if (bl == null) {
            bl2 = true;
        } else {
            boolean bl3 = bl;
            Boolean bl4 = this.getGridVisible();
            boolean bl5 = bl4 == null ? false : bl4;
            bl2 = !bl3 & bl5;
        }
        this.setScaleComponentsEnabled(bl2);
    }

    private void setScaleComponentsEnabled(boolean bl) {
        Component[] componentArray = new Component[]{this.mBaseXValueLabel, this.mBaseXValueTextField, this.mBaseYValueLabel, this.mBaseYValueTextField, this.mStepXValueLabel, this.mStepXValueTextField, this.mStepYValueLabel, this.mStepYValueTextField};
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
        }
    }

    private void setScaleComponentsEditable(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl == false;
        }
        this.setScaleComponentsEditable(bl2);
    }

    private void setScaleComponentsEditable(boolean bl) {
        JTextComponent[] jTextComponentArray = new JTextComponent[]{this.mBaseXValueTextField, this.mBaseYValueTextField, this.mStepXValueTextField, this.mStepYValueTextField};
        for (int i = 0; i < jTextComponentArray.length; ++i) {
            jTextComponentArray[i].setEditable(bl);
        }
    }

    public boolean setLineType(Integer n) {
        if (n != null) {
            String string = SGDrawingElementLine.getLineTypeName(n);
            this.mLineTypeComboBox.setSelectedItem(string);
        } else {
            this.mLineTypeComboBox.setSelectedItem(null);
        }
        return true;
    }

    public Boolean getGridVisible() {
        return this.mGridVisibleCheckBox.getSelected();
    }

    public int getLineType() {
        String string = (String)this.mLineTypeComboBox.getSelectedItem();
        Integer n = SGDrawingElementLine.getLineTypeFromName(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public boolean setLineWidth(Object object) {
        return this.setValue(this.mLineWidthSpinner, object);
    }

    public Number getLineWidth() {
        return this.mLineWidthSpinner.getNumber();
    }

    public boolean setLineColor(Color color) {
        this.mLineColorButton.setColor(color);
        return true;
    }

    public Color getLineColor() {
        return this.mLineColorButton.getColor();
    }

    public Boolean getAutoFlag() {
        return this.mAutoCheckBox.getSelected();
    }

    public Number getBaseXValue() {
        String string = this.mBaseXValueTextField.getText();
        Double d = SGUtilityText.getDouble(string);
        return d;
    }

    public Number getBaseYValue() {
        String string = this.mBaseYValueTextField.getText();
        Double d = SGUtilityText.getDouble(string);
        return d;
    }

    public Number getStepXValue() {
        String string = this.mStepXValueTextField.getText();
        Double d = SGUtilityText.getDouble(string);
        return d;
    }

    public Number getStepYValue() {
        String string = this.mStepYValueTextField.getText();
        Double d = SGUtilityText.getDouble(string);
        return d;
    }

    public void setBaseXValue(Object object) {
        this.setValue(this.mBaseXValueTextField, object);
    }

    public void setStepXValue(Object object) {
        this.setValue(this.mStepXValueTextField, object);
    }

    public void setBaseYValue(Object object) {
        this.setValue(this.mBaseYValueTextField, object);
    }

    public void setStepYValue(Object object) {
        this.setValue(this.mStepYValueTextField, object);
    }

    public ArrayList getTextFieldComponentsList() {
        ArrayList arrayList = this.getFormattedTextFieldsListFromSpinners();
        arrayList.addAll(this.getNumberTextFieldList());
        return arrayList;
    }

    public ArrayList getNumberTextFieldList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.add(this.mStepXValueTextField);
        arrayList.add(this.mStepYValueTextField);
        arrayList.add(this.mBaseXValueTextField);
        arrayList.add(this.mBaseYValueTextField);
        return arrayList;
    }

    public ArrayList getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mBackgroundColorButton);
        arrayList.add(this.mLineColorButton);
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mXSpinner);
        arrayList.add(this.mYSpinner);
        arrayList.add(this.mWidthSpinner);
        arrayList.add(this.mHeightSpinner);
        arrayList.add(this.mSpaceLineAndScaleSpinner);
        arrayList.add(this.mSpaceScaleAndTitleSpinner);
        arrayList.add(this.mLineWidthSpinner);
        return arrayList;
    }

    public boolean setDialogProperty() {
        SGXYFigureDialog sGXYFigureDialog = this;
        ArrayList arrayList = this.mPropertyDialogObserverList;
        SGIFigureDialogObserver sGIFigureDialogObserver = (SGIFigureDialogObserver)arrayList.get(0);
        float f = sGIFigureDialogObserver.getFigureX();
        float f2 = sGIFigureDialogObserver.getFigureY();
        float f3 = sGIFigureDialogObserver.getFigureWidth();
        float f4 = sGIFigureDialogObserver.getFigureHeight();
        float f5 = sGIFigureDialogObserver.getSpaceAxisLineAndNumber();
        float f6 = sGIFigureDialogObserver.getSpaceNumberAndTitle();
        boolean bl = sGIFigureDialogObserver.isLegendVisible();
        Color color = sGIFigureDialogObserver.getBackgroundColor();
        boolean bl2 = sGIFigureDialogObserver.isTransparent();
        Float f7 = new Float(f);
        Float f8 = new Float(f2);
        Float f9 = new Float(f3);
        Float f10 = new Float(f4);
        Float f11 = new Float(f5);
        Float f12 = new Float(f6);
        Boolean bl3 = bl;
        Color color2 = color;
        Boolean bl4 = bl2;
        if (arrayList.size() > 1) {
            float f13;
            SGIFigureDialogObserver sGIFigureDialogObserver2;
            int n;
            for (n = 1; n < arrayList.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)arrayList.get(n);
                f13 = sGIFigureDialogObserver2.getFigureX();
                if (f == f13) continue;
                f7 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)arrayList.get(n);
                f13 = sGIFigureDialogObserver2.getFigureY();
                if (f2 == f13) continue;
                f8 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)arrayList.get(n);
                f13 = sGIFigureDialogObserver2.getFigureWidth();
                if (f3 == f13) continue;
                f9 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)arrayList.get(n);
                f13 = sGIFigureDialogObserver2.getFigureHeight();
                if (f4 == f13) continue;
                f10 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)arrayList.get(n);
                f13 = sGIFigureDialogObserver2.getSpaceAxisLineAndNumber();
                if (f5 == f13) continue;
                f11 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)arrayList.get(n);
                f13 = sGIFigureDialogObserver2.getSpaceNumberAndTitle();
                if (f6 == f13) continue;
                f12 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)arrayList.get(n);
                boolean bl5 = sGIFigureDialogObserver2.isLegendVisible();
                if (bl == bl5) continue;
                bl3 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)arrayList.get(n);
                Color color3 = sGIFigureDialogObserver2.getBackgroundColor();
                if (color.equals(color3)) continue;
                color2 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIFigureDialogObserver2 = (SGIFigureDialogObserver)arrayList.get(n);
                boolean bl6 = sGIFigureDialogObserver2.isTransparent();
                if (bl2 == bl6) continue;
                bl4 = null;
                break;
            }
        }
        if (f7 != null) {
            f7 = new Float(f7.floatValue() * 0.035277776f);
        }
        this.setFigureX(f7);
        if (f8 != null) {
            f8 = new Float(f8.floatValue() * 0.035277776f);
        }
        this.setFigureY(f8);
        if (f9 != null) {
            f9 = new Float(f9.floatValue() * 0.035277776f);
        }
        this.setFigureWidth(f9);
        if (f10 != null) {
            f10 = new Float(f10.floatValue() * 0.035277776f);
        }
        this.setFigureHeight(f10);
        if (f11 != null) {
            f11 = new Float(f11.floatValue() * 0.035277776f);
        }
        this.setFigureSpaceLineAndNumber(f11);
        if (f12 != null) {
            f12 = new Float(f12.floatValue() * 0.035277776f);
        }
        this.setFigureSpaceNumberAndTitle(f12);
        this.setFigureLegendVisible(bl3);
        this.setFigureBackgroundColor(color2);
        this.setFigureTransparent(bl4);
        if (!this.setGridProperty()) {
            return false;
        }
        this.setColorButtonBorder(true);
        return true;
    }

    private boolean isGridTabEnable() {
        return this.mTabbedPane.isEnabledAt(1);
    }

    private void setGridTabEnabled(boolean bl) {
        this.mTabbedPane.setEnabledAt(1, bl);
        if (!bl) {
            this.mTabbedPane.setSelectedIndex(0);
        }
    }

    private boolean setGridProperty() {
        boolean bl;
        SGIXYFigureDialogObserver sGIXYFigureDialogObserver;
        int n;
        ArrayList arrayList = this.mPropertyDialogObserverList;
        if (!this.mAxesButtonGroup.setRadioButton(arrayList)) {
            return false;
        }
        SGIXYFigureDialogObserver sGIXYFigureDialogObserver2 = (SGIXYFigureDialogObserver)arrayList.get(0);
        boolean bl2 = sGIXYFigureDialogObserver2.isGridVisible();
        boolean bl3 = sGIXYFigureDialogObserver2.isAutoRange();
        double d = sGIXYFigureDialogObserver2.getStepValueX();
        double d2 = sGIXYFigureDialogObserver2.getStepValueY();
        double d3 = sGIXYFigureDialogObserver2.getBaselineValueX();
        double d4 = sGIXYFigureDialogObserver2.getBaselineValueY();
        float f = sGIXYFigureDialogObserver2.getLineWidth();
        int n2 = sGIXYFigureDialogObserver2.getLineType();
        Color color = sGIXYFigureDialogObserver2.getColor();
        Boolean bl4 = bl2;
        Boolean bl5 = bl3;
        Double d5 = new Double(d);
        Double d6 = new Double(d2);
        Double d7 = new Double(d3);
        Double d8 = new Double(d4);
        Float f2 = new Float(f);
        Integer n3 = new Integer(n2);
        Color color2 = color;
        if (arrayList.size() > 1) {
            for (n = 1; n < arrayList.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)arrayList.get(n);
                bl = sGIXYFigureDialogObserver.isGridVisible();
                if (bl2 == bl) continue;
                bl4 = null;
                break;
            }
        }
        if (arrayList.size() > 1) {
            for (n = 1; n < arrayList.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)arrayList.get(n);
                bl = sGIXYFigureDialogObserver.isAutoRange();
                if (bl3 == bl) continue;
                bl5 = null;
                break;
            }
        }
        if (arrayList.size() > 1) {
            for (n = 1; n < arrayList.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)arrayList.get(n);
                double d9 = sGIXYFigureDialogObserver.getStepValueX();
                if (d == d9) continue;
                d5 = null;
                break;
            }
        }
        if (arrayList.size() > 1) {
            for (n = 1; n < arrayList.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)arrayList.get(n);
                double d10 = sGIXYFigureDialogObserver.getStepValueY();
                if (d2 == d10) continue;
                d6 = null;
                break;
            }
        }
        if (arrayList.size() > 1) {
            for (n = 1; n < arrayList.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)arrayList.get(n);
                double d11 = sGIXYFigureDialogObserver.getBaselineValueX();
                if (d3 == d11) continue;
                d7 = null;
                break;
            }
        }
        if (arrayList.size() > 1) {
            for (n = 1; n < arrayList.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)arrayList.get(n);
                double d12 = sGIXYFigureDialogObserver.getBaselineValueY();
                if (d4 == d12) continue;
                d8 = null;
                break;
            }
        }
        if (arrayList.size() > 1) {
            for (n = 1; n < arrayList.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)arrayList.get(n);
                float f3 = sGIXYFigureDialogObserver.getLineWidth();
                if (f == f3) continue;
                f2 = null;
                break;
            }
        }
        if (arrayList.size() > 1) {
            for (n = 1; n < arrayList.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)arrayList.get(n);
                int n4 = sGIXYFigureDialogObserver.getLineType();
                if (n2 == n4) continue;
                n3 = null;
                break;
            }
        }
        if (arrayList.size() > 1) {
            for (n = 1; n < arrayList.size(); ++n) {
                sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)arrayList.get(n);
                Color color3 = sGIXYFigureDialogObserver.getColor();
                if (color.equals(color3)) continue;
                color2 = null;
                break;
            }
        }
        this.setAutoFlag(bl5);
        this.setStepXValue(d5);
        this.setStepYValue(d6);
        this.setBaseXValue(d7);
        this.setBaseYValue(d8);
        this.setLineWidth(f2);
        this.setLineType(n3);
        this.setLineColor(color2);
        this.setGridVisible(bl4);
        return true;
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        Color color;
        Boolean bl;
        Boolean bl2;
        Number number;
        Number number2;
        Number number3;
        Number number4;
        Number number5;
        SGIXYFigureDialogObserver sGIXYFigureDialogObserver = (SGIXYFigureDialogObserver)sGIPropertyDialogObserver;
        Number number6 = this.getFigureX();
        if (number6 != null) {
            sGIXYFigureDialogObserver.setFigureX(number6.floatValue() / 0.035277776f);
        }
        if ((number5 = this.getFigureY()) != null) {
            sGIXYFigureDialogObserver.setFigureY(number5.floatValue() / 0.035277776f);
        }
        if ((number4 = this.getFigureWidth()) != null) {
            sGIXYFigureDialogObserver.setFigureWidth(number4.floatValue() / 0.035277776f);
        }
        if ((number3 = this.getFigureHeight()) != null) {
            sGIXYFigureDialogObserver.setFigureHeight(number3.floatValue() / 0.035277776f);
        }
        if ((number2 = this.getSpaceLineAndNumber()) != null) {
            sGIXYFigureDialogObserver.setSpaceAxisLineAndNumber(number2.floatValue() / 0.035277776f);
        }
        if ((number = this.getSpaceNumberAndTitle()) != null) {
            sGIXYFigureDialogObserver.setSpaceNumberAndTitle(number.floatValue() / 0.035277776f);
        }
        if ((bl2 = this.isFigureTransparent()) != null) {
            sGIXYFigureDialogObserver.setTransparent(bl2);
        }
        if ((bl = this.getFigureLegendVisible()) != null) {
            sGIXYFigureDialogObserver.setLegendVisible(bl);
        }
        if ((color = this.getFigureBackgroundColor()) != null) {
            sGIXYFigureDialogObserver.setBackgroundColor(color);
        }
        return !this.isGridTabEnable() || this.setPropertiesToGridListeners(sGIXYFigureDialogObserver);
    }

    private boolean setPropertiesToGridListeners(SGIXYFigureDialogObserver sGIXYFigureDialogObserver) {
        Boolean bl;
        int n;
        SGIXYFigureDialogObserver sGIXYFigureDialogObserver2 = sGIXYFigureDialogObserver;
        int n2 = this.mAxesButtonGroup.getXAxisConfiguration();
        if (n2 != -1 & (n = this.mAxesButtonGroup.getYAxisConfiguration()) != -1) {
            sGIXYFigureDialogObserver2.setAxisConfiguration(n2, n);
        }
        if ((bl = this.getAutoFlag()) != null && !sGIXYFigureDialogObserver2.setAutoRangeFlag(bl)) {
            return false;
        }
        Boolean bl2 = this.getGridVisible();
        if (bl2 != null && !sGIXYFigureDialogObserver2.setGridVisible(bl2)) {
            return false;
        }
        Number number = this.getBaseXValue();
        if (number != null && !sGIXYFigureDialogObserver2.setBaselineValueX(number.doubleValue())) {
            return false;
        }
        Number number2 = this.getBaseYValue();
        if (number2 != null && !sGIXYFigureDialogObserver2.setBaselineValueY(number2.doubleValue())) {
            return false;
        }
        Number number3 = this.getStepXValue();
        if (number3 != null && !sGIXYFigureDialogObserver2.setStepValueX(number3.doubleValue())) {
            return false;
        }
        Number number4 = this.getStepYValue();
        if (number4 != null && !sGIXYFigureDialogObserver2.setStepValueY(number4.doubleValue())) {
            return false;
        }
        Number number5 = this.getLineWidth();
        if (number5 != null && !sGIXYFigureDialogObserver2.setLineWidth(number5.floatValue())) {
            return false;
        }
        int n3 = this.getLineType();
        if (n3 != -1 && !sGIXYFigureDialogObserver2.setLineType(n3)) {
            return false;
        }
        Color color = this.getLineColor();
        return color == null || sGIXYFigureDialogObserver2.setColor(color);
    }

    protected boolean hasValidInputValues() {
        if (!super.hasValidInputValues()) {
            return false;
        }
        Boolean bl = this.getAutoFlag();
        if (bl != null && !bl.booleanValue()) {
            Number number = this.getStepXValue();
            if (number != null && number.doubleValue() < 0.0) {
                return false;
            }
            Number number2 = this.getStepYValue();
            if (number2 != null && number2.doubleValue() < 0.0) {
                return false;
            }
        }
        return true;
    }
}

