/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGISymbolConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import org.w3c.dom.Element;

public abstract class SGElementGroupSymbol
extends SGElementGroupSXY
implements SGISymbolConstants,
SGIElementGroupConstants {
    protected float mSymbolSize;
    protected int mSymbolType;
    protected double mAngle;
    protected Color mLineColor;
    protected float mLineWidth;

    public float getSize() {
        return this.mSymbolSize;
    }

    public int getType() {
        return this.mSymbolType;
    }

    public double getAngle() {
        return this.mAngle;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public Color getLineColor() {
        return this.mLineColor;
    }

    public boolean setSize(float f) {
        this.mSymbolSize = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[i];
                sGDrawingElementSymbol2D.setSize(this.mSymbolSize);
            }
        }
        return true;
    }

    public boolean setType(int n) {
        this.mSymbolType = n;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[i];
                sGDrawingElementSymbol2D.setType(this.mSymbolType);
            }
        }
        return true;
    }

    public boolean setLineColor(Color color) {
        this.mLineColor = color;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[i];
                sGDrawingElementSymbol2D.setLineColor(this.mLineColor);
            }
        }
        return true;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidth = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[i];
                sGDrawingElementSymbol2D.setLineWidth(this.mLineWidth);
            }
        }
        return true;
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = new SGDrawingElementSymbol2D();
        sGDrawingElementSymbol2D.setVisible(this.mVisibleFlag);
        sGDrawingElementSymbol2D.setSize(this.mSymbolSize);
        sGDrawingElementSymbol2D.setType(this.mSymbolType);
        sGDrawingElementSymbol2D.setColorList(this.mColorList);
        sGDrawingElementSymbol2D.setLineColor(this.mLineColor);
        sGDrawingElementSymbol2D.setLineWidth(this.mLineWidth);
        return sGDrawingElementSymbol2D;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementSymbol)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementSymbol sGDrawingElementSymbol = (SGDrawingElementSymbol)sGDrawingElement;
        this.setType(sGDrawingElementSymbol.getType());
        this.setSize(sGDrawingElementSymbol.getSize());
        this.setLineWidth(sGDrawingElementSymbol.getLineWidth());
        this.setLineColor(sGDrawingElementSymbol.getLineColor());
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[i];
                if (!sGDrawingElementSymbol2D.isVisible()) continue;
                sGDrawingElementSymbol2D.paint(graphics2D, rectangle2D);
            }
        }
        return true;
    }

    public String getTagName() {
        return "Symbol";
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
        element.setAttribute("Size", Float.toString(this.mSymbolSize * 0.035277776f) + "cm");
        element.setAttribute("Type", SGDrawingElementSymbol.getSymbolTypeName(this.mSymbolType));
        element.setAttribute("InnerColor", SGUtilityText.getColorListString(this.mColorList));
        element.setAttribute("LineWidth", Float.toString(this.mLineWidth) + "pt");
        element.setAttribute("LineColor", SGUtilityText.getColorString(this.mLineColor));
        return true;
    }

    public SGProperties readProperties(Element element) {
        String string = null;
        Number number = null;
        Color color = null;
        Boolean bl = null;
        ArrayList arrayList = null;
        SymbolProperties symbolProperties = new SymbolProperties();
        string = element.getAttribute("Visible");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        symbolProperties.setVisible(bl);
        string = element.getAttribute("Size");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getFloat(string, "cm");
        if (number == null) {
            return null;
        }
        symbolProperties.setSize(number.floatValue() / 0.035277776f);
        string = element.getAttribute("Type");
        if (string.length() == 0) {
            return null;
        }
        number = SGDrawingElementSymbol.getSymbolTypeFromName(string);
        if (number == null) {
            return null;
        }
        symbolProperties.setSymbolType(number.intValue());
        string = element.getAttribute("InnerColor");
        if (string.length() == 0) {
            return null;
        }
        arrayList = SGUtilityText.getColorList(string);
        if (arrayList == null) {
            return null;
        }
        symbolProperties.setColorList(arrayList);
        string = element.getAttribute("LineWidth");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getFloat(string, "pt");
        if (number == null) {
            return null;
        }
        symbolProperties.setLineWidth(number.floatValue());
        string = element.getAttribute("LineColor");
        if (string.length() == 0) {
            return null;
        }
        color = SGUtilityText.getColorFromString(string);
        if (color == null) {
            return null;
        }
        symbolProperties.setLineColor(color);
        return symbolProperties;
    }

    protected boolean initDrawingElement(int n) {
        SGDrawingElementSymbol2D[] sGDrawingElementSymbol2DArray = new SGDrawingElementSymbol2D[n];
        for (int i = 0; i < n; ++i) {
            sGDrawingElementSymbol2DArray[i] = new SGDrawingElementSymbol2D();
        }
        this.mDrawingElementArray = sGDrawingElementSymbol2DArray;
        return true;
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
        int n = sGTuple2fArray.length;
        SGDrawingElementSymbol2D[] sGDrawingElementSymbol2DArray = new SGDrawingElementSymbol2D[n];
        for (int i = 0; i < n; ++i) {
            sGDrawingElementSymbol2DArray[i] = new SGDrawingElementSymbol2D();
            sGDrawingElementSymbol2DArray[i].setLocation(sGTuple2fArray[i]);
        }
        this.mDrawingElementArray = sGDrawingElementSymbol2DArray;
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < sGTuple2fArray.length; ++i) {
            SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[i];
            boolean bl = !sGTuple2fArray[i].isInfinite() && !sGTuple2fArray[i].isNaN();
            sGDrawingElementSymbol2D.setVisible(bl);
            if (!bl) continue;
            sGDrawingElementSymbol2D.setLocation(sGTuple2fArray[i]);
        }
        return true;
    }

    public boolean setPropertiesOfDrawingElements() {
        for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
            SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[i];
            sGDrawingElementSymbol2D.setMagnification(this.mMagnification);
            sGDrawingElementSymbol2D.setColorList(this.mColorList);
            sGDrawingElementSymbol2D.setSize(this.mSymbolSize);
            sGDrawingElementSymbol2D.setType(this.mSymbolType);
            sGDrawingElementSymbol2D.setLineWidth(this.mLineWidth);
            sGDrawingElementSymbol2D.setLineColor(this.mLineColor);
        }
        return true;
    }

    public SGProperties getProperties() {
        SymbolProperties symbolProperties = new SymbolProperties();
        this.getProperties(symbolProperties);
        return symbolProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof SymbolProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        SymbolProperties symbolProperties = (SymbolProperties)sGProperties;
        symbolProperties.setSize(this.getSize());
        symbolProperties.setSymbolType(this.getType());
        symbolProperties.setLineWidth(this.getLineWidth());
        symbolProperties.setLineColor(this.getLineColor());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SymbolProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SymbolProperties symbolProperties = (SymbolProperties)sGProperties;
        Float f = symbolProperties.getSize();
        if (f == null) {
            return false;
        }
        this.setSize(f.floatValue());
        Integer n = symbolProperties.getSymbolType();
        if (n == null) {
            return false;
        }
        this.setType(n);
        Float f2 = symbolProperties.getLineWidth();
        if (f2 == null) {
            return false;
        }
        this.setLineWidth(f2.floatValue());
        Color color = symbolProperties.getLineColor();
        if (color == null) {
            return false;
        }
        this.setLineColor(color);
        return true;
    }

    public static class SymbolProperties
    extends SGElementGroup.ElementGroupProperties {
        private SGDrawingElementSymbol.SymbolProperties mSymbolProperties = new SGDrawingElementSymbol.SymbolProperties();

        public boolean equals(Object object) {
            if (!(object instanceof SymbolProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SymbolProperties symbolProperties = (SymbolProperties)object;
            return this.mSymbolProperties.equals(symbolProperties.mSymbolProperties);
        }

        public Float getSize() {
            return this.mSymbolProperties.getSize();
        }

        public Integer getSymbolType() {
            return this.mSymbolProperties.getSymbolType();
        }

        public Float getLineWidth() {
            return this.mSymbolProperties.getLineWidth();
        }

        public Color getLineColor() {
            return this.mSymbolProperties.getLineColor();
        }

        public void setSize(float f) {
            this.mSymbolProperties.setSize(f);
        }

        public void setSymbolType(int n) {
            this.mSymbolProperties.setSymbolType(n);
        }

        public void setLineWidth(float f) {
            this.mSymbolProperties.setLineWidth(f);
        }

        public void setLineColor(Color color) {
            this.mSymbolProperties.setLineColor(color);
        }
    }
}

