/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGITwoDimensionalData;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIAxisDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIAxisPanelObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SGAxisElement
extends SGFigureElement
implements SGIAxisElement,
SGIStringConstants,
SGIAxisDialogObserver,
CaretListener,
ActionListener {
    private int mViewDirection = 0;
    private final ArrayList mElementsGroupList = new ArrayList();
    private Color mLineColor = SGDefaultValues.AXIS_LINE_COLOR;
    private float mAxisLineWidth = 1.5f;
    private float mScaleLineWidth = 1.5f;
    private Color mStringColor = SGDefaultValues.AXIS_STRING_COLOR;
    private float mTitleFontSize = 16.0f;
    private int mTitleFontStyle = -1;
    private String mTitleFontName = "Serif";
    private float mScaleFontSize = 16.0f;
    private int mScaleFontStyle = -1;
    private String mScaleFontName = "Serif";
    private float mScaleLineLength = 7.0866146f;
    private float mSpaceAxisLineAndNumber = 5.6692915f;
    private float mSpaceNumberAndTitle = 5.6692915f;
    private SGDrawingElement mPressedElement = null;
    private Point mPressedElementOrigin = null;
    private SGAxisDialog mDialog = null;
    private boolean mFrameLinesVisibleFlag = true;
    private Color mFrameLineColor = SGDefaultValues.AXIS_FRAME_LINE_COLOR;
    private float mFrameLineWidth = 1.5f;
    private boolean mNotifyChangeOnDraggingFlag = true;
    private final JTextField mTextField = new JTextField();
    private boolean mStartFlag = true;
    private int mTempAxisConfiguration = -1;
    private SGProperties mTemporaryProperties = null;
    private static final double ALTERNATIVE_AXIS_VALUE = 1.0;
    private SGITimingLineElement mTimingLineElement = null;
    private boolean mClickedFlag = false;
    private SGDrawingElementString2D mEditingStringElement = null;

    public SGAxisElement() {
        this.initEditField();
        if (!this.init()) {
            throw new Error();
        }
    }

    private boolean init() {
        this.setAxisLineWidth(1.5f);
        this.setScaleLineWidth(1.5f);
        this.setScaleLineLength(7.0866146f);
        this.setLineColor(SGDefaultValues.AXIS_LINE_COLOR);
        this.setFrameLinesVisible(false);
        this.setFrameLineWidth(1.5f);
        this.setFrameLineColor(SGDefaultValues.AXIS_FRAME_LINE_COLOR);
        this.setFontName("Serif");
        this.setFontSize(16.0f);
        int n = SGUtilityText.getFontStyle("Plain");
        if (n == -1) {
            return false;
        }
        this.setFontStyle(n);
        this.setStringColor(SGDefaultValues.AXIS_STRING_COLOR);
        return true;
    }

    private boolean initEditField() {
        this.setLayout(null);
        this.add(this.mTextField);
        this.mTextField.setVisible(false);
        this.mTextField.addActionListener(this);
        this.mTextField.addCaretListener(this);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object.equals(this.mTextField)) {
            this.terminateEditField();
            return;
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        String string = this.mTextField.getText();
        Font font = new Font(this.getFontName(), this.getFontStyle(), (int)(this.getFontSize() * this.getMagnification()));
        Rectangle2D rectangle2D = font.getStringBounds(string, new FontRenderContext(null, false, false));
        double d = rectangle2D.getWidth();
        if (d > (double)this.mTextField.getWidth()) {
            this.mTextField.setSize((int)(rectangle2D.getWidth() + (double)(this.getMagnification() * this.getFontSize())), this.mTextField.getHeight());
        }
    }

    private boolean terminateEditField() {
        this.commitEdit();
        this.hideEditField();
        return true;
    }

    private boolean commitEdit() {
        String string = this.mTextField.getText();
        String string2 = this.mEditingStringElement.getString();
        String string3 = string;
        this.mEditingStringElement.setString(string3);
        if (!string2.equals(string3)) {
            this.setChanged(true);
        }
        this.createAllDrawingElements();
        this.notifyChange();
        this.notifyToRoot();
        return true;
    }

    private boolean hideEditField() {
        this.mTextField.setText("");
        this.mTextField.setVisible(false);
        return true;
    }

    public String getFontName() {
        return this.mTitleFontName;
    }

    public float getFontSize() {
        return this.mTitleFontSize;
    }

    public int getFontStyle() {
        return this.mTitleFontStyle;
    }

    public Color getStringColor() {
        return this.mStringColor;
    }

    public boolean isFrameLineVisible() {
        return this.mFrameLinesVisibleFlag;
    }

    public float getFrameLineWidth() {
        return this.mAxisLineWidth;
    }

    public Color getFrameLineColor() {
        return this.mFrameLineColor;
    }

    public float getAxisLineWidth() {
        return this.mAxisLineWidth;
    }

    public float getTickMarkWidth() {
        return this.mScaleLineWidth;
    }

    public float getTickMarkLength() {
        return this.mScaleLineLength;
    }

    public Color getLineColor() {
        return this.mLineColor;
    }

    public boolean setFrameVisible(boolean bl) {
        this.mFrameLinesVisibleFlag = bl;
        return true;
    }

    public boolean setTickMarkWidth(float f) {
        this.mScaleLineWidth = f;
        return true;
    }

    public boolean setTickMarkLength(float f) {
        this.mScaleLineLength = f;
        return true;
    }

    public boolean setLineColor(Color color) {
        this.mLineColor = color;
        return true;
    }

    public int getAxisConfigurationForSelectedTab() {
        return this.mTempAxisConfiguration;
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIGraphElement || sGIFigureElement instanceof SGIStringElement || sGIFigureElement instanceof SGILegendElement || sGIFigureElement instanceof SGIAxisElement || sGIFigureElement instanceof SGIAxisBreakElement || sGIFigureElement instanceof SGISignificantDifferenceElement || sGIFigureElement instanceof SGITimingLineElement || sGIFigureElement instanceof SGIGridElement)) {
            bl = sGIFigureElement.synchronizeArgument(this);
        }
        return bl;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error();
    }

    public boolean zoom(float f) {
        super.zoom(f);
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            elementsGroupOfAxis.zoom(f);
        }
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            boolean bl = elementsGroupOfAxis.onMouseClicked(mouseEvent);
            if (!bl) continue;
            return true;
        }
        if (this.mTextField.isVisible()) {
            this.terminateEditField();
        } else {
            this.hideEditField();
        }
        return false;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            boolean bl = elementsGroupOfAxis.onMousePressed(mouseEvent);
            if (!bl) continue;
            this.prepare();
            return true;
        }
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            boolean bl = elementsGroupOfAxis.onMouseDragged(mouseEvent);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        boolean bl = false;
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            if (!elementsGroupOfAxis.onMouseReleased(mouseEvent)) continue;
            if (!this.createAllDrawingElements()) {
                return false;
            }
            this.initializePressedElement();
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.setChanged(true);
                bl = true;
            }
            this.mTemporaryProperties = null;
        }
        this.initializePressedElement();
        if (bl) {
            this.notifyChange();
            this.notifyToRoot();
        }
        return true;
    }

    public boolean onDrawingElement(int n, int n2) {
        ArrayList arrayList = this.mElementsGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)arrayList.get(i);
            if (!elementsGroupOfAxis.onDrawingElement(n, n2)) continue;
            return true;
        }
        return false;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        return true;
    }

    public boolean setChangedFocusedObjects() {
        return true;
    }

    private void initializePressedElement() {
        this.mPressedElement = null;
        this.mPressedElementOrigin = null;
    }

    public boolean prepare() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    private boolean createDialog(int n) {
        SGAxisDialog sGAxisDialog;
        this.mDialog = sGAxisDialog = new SGAxisDialog(this.mDialogOwner, true);
        return true;
    }

    public boolean addData(SGData sGData, String string) {
        super.addData(sGData, string);
        if (this.mElementsGroupList.size() == 0 && sGData instanceof SGITwoDimensionalData) {
            SGITwoDimensionalData sGITwoDimensionalData = (SGITwoDimensionalData)((Object)sGData);
            double d = sGITwoDimensionalData.getMinValueX();
            double d2 = sGITwoDimensionalData.getMaxValueX();
            double d3 = sGITwoDimensionalData.getMinValueY();
            double d4 = sGITwoDimensionalData.getMaxValueY();
            double d5 = d4 - d3;
            double d6 = 0.05 * d5;
            double d7 = d;
            double d8 = d2;
            double d9 = d3 - d6;
            double d10 = d4 + d6;
            d9 = SGUtilityNumber.getNumberInRangeOrder(d9, d3, d4, 4);
            d10 = SGUtilityNumber.getNumberInRangeOrder(d10, d3, d4, 4);
            double d11 = 1.0;
            if (Math.abs(d2 - d) < Double.MIN_VALUE) {
                d7 = d - d11;
                d8 = d + d11;
            }
            if (Math.abs(d4 - d3) < Double.MIN_VALUE) {
                d9 = d3 - d11;
                d10 = d3 + d11;
            }
            ElementsGroupOfAxis elementsGroupOfAxis = new ElementsGroupOfAxis();
            ElementsGroupOfAxis elementsGroupOfAxis2 = new ElementsGroupOfAxis();
            ElementsGroupOfAxis elementsGroupOfAxis3 = new ElementsGroupOfAxis();
            ElementsGroupOfAxis elementsGroupOfAxis4 = new ElementsGroupOfAxis();
            SGAxis sGAxis = new SGAxis();
            sGAxis.setRange(d7, d8);
            sGAxis.setScaleType(0);
            ElementsGroupOfAxis elementsGroupOfAxis5 = elementsGroupOfAxis;
            elementsGroupOfAxis5.zoom(this.mMagnification);
            elementsGroupOfAxis5.setConfigurationInPlane(0);
            elementsGroupOfAxis5.mAxis = sGAxis;
            elementsGroupOfAxis5.mVisibleFlag = true;
            elementsGroupOfAxis5.setTitle("X Label");
            this.mElementsGroupList.add(elementsGroupOfAxis5);
            sGAxis = new SGAxis();
            sGAxis.setRange(d7, d8);
            sGAxis.setScaleType(0);
            elementsGroupOfAxis5 = elementsGroupOfAxis2;
            elementsGroupOfAxis5.zoom(this.mMagnification);
            elementsGroupOfAxis5.setConfigurationInPlane(1);
            elementsGroupOfAxis5.mAxis = sGAxis;
            elementsGroupOfAxis5.mVisibleFlag = false;
            elementsGroupOfAxis5.mTitle.setString("X Label");
            this.mElementsGroupList.add(elementsGroupOfAxis5);
            sGAxis = new SGAxis();
            sGAxis.setRange(d9, d10);
            sGAxis.setScaleType(0);
            elementsGroupOfAxis5 = elementsGroupOfAxis3;
            elementsGroupOfAxis5.zoom(this.mMagnification);
            elementsGroupOfAxis5.setConfigurationInPlane(2);
            elementsGroupOfAxis5.mAxis = sGAxis;
            elementsGroupOfAxis5.mVisibleFlag = true;
            elementsGroupOfAxis5.mTitle.setString("Y Label");
            this.mElementsGroupList.add(elementsGroupOfAxis5);
            sGAxis = new SGAxis();
            sGAxis.setRange(d9, d10);
            sGAxis.setScaleType(0);
            elementsGroupOfAxis5 = elementsGroupOfAxis4;
            elementsGroupOfAxis5.zoom(this.mMagnification);
            elementsGroupOfAxis5.setConfigurationInPlane(3);
            elementsGroupOfAxis5.mAxis = sGAxis;
            elementsGroupOfAxis5.mVisibleFlag = false;
            elementsGroupOfAxis5.mTitle.setString("Y Label");
            this.mElementsGroupList.add(elementsGroupOfAxis5);
            this.createAllDrawingElements();
            this.createDialog(0);
        }
        if (this.mStartFlag) {
            this.mStartFlag = false;
        }
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        this.setLocationOfAllDrawingElements();
        return true;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroupInPlane(1);
        ElementsGroupOfAxis elementsGroupOfAxis2 = this.getAxisGroupInPlane(0);
        ElementsGroupOfAxis elementsGroupOfAxis3 = this.getAxisGroupInPlane(2);
        ElementsGroupOfAxis elementsGroupOfAxis4 = this.getAxisGroupInPlane(3);
        if (elementsGroupOfAxis == null || elementsGroupOfAxis2 == null || elementsGroupOfAxis3 == null || elementsGroupOfAxis4 == null) {
            return false;
        }
        float f = this.getSpaceAxisLineAndNumber() * this.mMagnification;
        Rectangle2D rectangle2D = elementsGroupOfAxis.getBoundingBox();
        Rectangle2D rectangle2D2 = elementsGroupOfAxis2.getBoundingBox();
        Rectangle2D rectangle2D3 = elementsGroupOfAxis3.getBoundingBox();
        Rectangle2D rectangle2D4 = elementsGroupOfAxis4.getBoundingBox();
        Rectangle2D rectangle2D5 = this.getGraphRect();
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        arrayList.add(rectangle2D5);
        if (rectangle2D != null) {
            arrayList.add(rectangle2D);
        }
        if (rectangle2D2 != null) {
            arrayList.add(rectangle2D2);
        }
        if (rectangle2D3 != null) {
            arrayList.add(rectangle2D3);
        }
        if (rectangle2D4 != null) {
            arrayList.add(rectangle2D4);
        }
        Rectangle2D rectangle2D6 = SGUtility.createUnion(arrayList);
        float f2 = (float)(rectangle2D5.getY() - rectangle2D6.getY());
        float f3 = (float)(rectangle2D6.getY() + rectangle2D6.getHeight() - (rectangle2D5.getY() + rectangle2D5.getHeight()));
        float f4 = (float)(rectangle2D5.getX() - rectangle2D6.getX());
        float f5 = (float)(rectangle2D6.getX() + rectangle2D6.getWidth() - (rectangle2D5.getX() + rectangle2D5.getWidth()));
        sGTuple2f.x += f2;
        sGTuple2f.y += f3;
        sGTuple2f2.x += f4;
        sGTuple2f2.y += f5;
        return true;
    }

    public boolean setViewDirection(int n) {
        this.mViewDirection = n;
        return true;
    }

    public boolean setTitleFontSize(float f) {
        this.mTitleFontSize = f;
        return true;
    }

    public boolean setTitleFontStyle(int n) {
        this.mTitleFontStyle = n;
        return true;
    }

    public boolean setTitleFontName(String string) {
        this.mTitleFontName = string;
        return true;
    }

    public boolean setAxisLineWidth(float f) {
        this.mAxisLineWidth = f;
        return true;
    }

    public boolean setScaleLineWidth(float f) {
        this.mScaleLineWidth = f;
        return true;
    }

    public boolean setStringColor(Color color) {
        this.mStringColor = color;
        return true;
    }

    public boolean setFontSize(float f) {
        this.setTitleFontSize(f);
        this.setScaleFontSize(f);
        return true;
    }

    public boolean setFontStyle(int n) {
        this.setTitleFontStyle(n);
        this.setScaleFontStyle(n);
        return true;
    }

    public boolean setFontName(String string) {
        this.setTitleFontName(string);
        this.setScaleFontName(string);
        return true;
    }

    public boolean setScaleFontSize(float f) {
        this.mScaleFontSize = f;
        return true;
    }

    public boolean setScaleFontStyle(int n) {
        this.mScaleFontStyle = n;
        return true;
    }

    public boolean setScaleFontName(String string) {
        this.mScaleFontName = string;
        return true;
    }

    public boolean setScaleLineLength(float f) {
        this.mScaleLineLength = f;
        return true;
    }

    public boolean setFrameLinesVisible(boolean bl) {
        this.mFrameLinesVisibleFlag = bl;
        return true;
    }

    public boolean setFrameLineWidth(float f) {
        this.mFrameLineWidth = f;
        return true;
    }

    public boolean setFrameLineColor(Color color) {
        this.mFrameLineColor = color;
        return true;
    }

    public boolean setSpaceAxisLineAndNumber(float f) {
        this.mSpaceAxisLineAndNumber = f;
        return true;
    }

    public boolean setSpaceNumberAndTitle(float f) {
        this.mSpaceNumberAndTitle = f;
        return true;
    }

    public float getSpaceAxisLineAndNumber() {
        return this.mSpaceAxisLineAndNumber;
    }

    public float getSpaceNumberAndTitle() {
        return this.mSpaceNumberAndTitle;
    }

    public float getNumberFontSize() {
        return this.mScaleFontSize;
    }

    public float getTitleFontSize() {
        return this.mTitleFontSize;
    }

    private ElementsGroupOfAxis getAxisGroup(int n, int n2) {
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            if (!elementsGroupOfAxis.isAxisVisible() || !elementsGroupOfAxis.contains(n, n2)) continue;
            return elementsGroupOfAxis;
        }
        return null;
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        return true;
    }

    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        return true;
    }

    private double getValue(ElementsGroupOfAxis elementsGroupOfAxis, int n, int n2) {
        SGAxis sGAxis = elementsGroupOfAxis.mAxis;
        double d = 0.0;
        ArrayList arrayList = this.getHorizontalAxisList();
        ArrayList arrayList2 = this.getPerpendicularAxisList();
        if (arrayList.contains(sGAxis)) {
            d = this.calcValue(n, sGAxis, true);
        } else if (arrayList2.contains(sGAxis)) {
            d = this.calcValue(n2, sGAxis, false);
        } else {
            throw new Error();
        }
        d = this.getNumberInRangeOrder(d, elementsGroupOfAxis.mAxis);
        return d;
    }

    public boolean addTimingLine(int n, int n2) {
        ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroup(n, n2);
        if (elementsGroupOfAxis == null) {
            return false;
        }
        double d = this.getValue(elementsGroupOfAxis, n, n2);
        this.mTimingLineElement.addTimingLine(elementsGroupOfAxis.mAxis, d);
        return true;
    }

    public void setTimingLineElement(SGITimingLineElement sGITimingLineElement) {
        this.mTimingLineElement = sGITimingLineElement;
    }

    private ElementsGroupOfAxis addAxisGroup(int n, SGTuple2d sGTuple2d, int n2) {
        ElementsGroupOfAxis elementsGroupOfAxis = new ElementsGroupOfAxis();
        SGAxis sGAxis = new SGAxis();
        sGAxis.setRange(new SGTuple2d(sGTuple2d));
        sGAxis.setScaleType(n2);
        elementsGroupOfAxis.mAxis = sGAxis;
        elementsGroupOfAxis.setConfigurationInCube(n);
        this.mElementsGroupList.add(elementsGroupOfAxis);
        return elementsGroupOfAxis;
    }

    private ElementsGroupOfAxis addAxisGroup(int n) {
        return this.addAxisGroup(n, new SGTuple2d(), 0);
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.mFrameLinesVisibleFlag) {
            this.drawGraphAreaBoundsLines(graphics2D);
        }
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            if (!elementsGroupOfAxis.isAxisVisible()) continue;
            elementsGroupOfAxis.paintGraphics2D(graphics2D);
        }
    }

    private boolean drawGraphAreaBoundsLines(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return false;
        }
        graphics2D.setPaint(this.mFrameLineColor);
        graphics2D.setStroke(new BasicStroke(this.mMagnification * this.mFrameLineWidth));
        graphics2D.drawRect((int)this.mGraphRectX, (int)this.mGraphRectY, (int)this.mGraphRectWidth, (int)this.mGraphRectHeight);
        return true;
    }

    private boolean drawStringBounds(SGDrawingElementString2D sGDrawingElementString2D, Graphics2D graphics2D) {
        if (sGDrawingElementString2D == null || graphics2D == null) {
            return false;
        }
        Color color = Color.BLACK;
        graphics2D.setPaint(color);
        graphics2D.setStroke(new BasicStroke(1.0f));
        Rectangle2D rectangle2D = sGDrawingElementString2D.getElementBounds();
        graphics2D.drawRect((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        return true;
    }

    private boolean drawString(SGDrawingElementString2D sGDrawingElementString2D, Graphics2D graphics2D) {
        if (sGDrawingElementString2D == null || graphics2D == null) {
            return false;
        }
        sGDrawingElementString2D.drawString(graphics2D);
        return true;
    }

    private boolean drawLine(SGDrawingElementLine2D sGDrawingElementLine2D, Graphics2D graphics2D, BasicStroke basicStroke) {
        if (sGDrawingElementLine2D == null || graphics2D == null) {
            return false;
        }
        graphics2D.setPaint(sGDrawingElementLine2D.getColor(0));
        graphics2D.setStroke(basicStroke);
        SGTuple2f sGTuple2f = sGDrawingElementLine2D.getStart();
        SGTuple2f sGTuple2f2 = sGDrawingElementLine2D.getEnd();
        Line2D.Float float_ = new Line2D.Float(sGTuple2f.x, sGTuple2f.y, sGTuple2f2.x, sGTuple2f2.y);
        graphics2D.draw(float_);
        return true;
    }

    public boolean isHorizontal(SGAxis sGAxis) {
        return this.getHorizontalAxisList().contains(sGAxis);
    }

    public boolean isPerpendicular(SGAxis sGAxis) {
        return this.getPerpendicularAxisList().contains(sGAxis);
    }

    public boolean isNormal(SGAxis sGAxis) {
        return this.getNormalAxisList().contains(sGAxis);
    }

    public ArrayList getAxisList() {
        ArrayList<SGAxis> arrayList = new ArrayList<SGAxis>();
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            arrayList.add(elementsGroupOfAxis.mAxis);
        }
        return arrayList;
    }

    public ArrayList getXAxisList() {
        ArrayList arrayList = new ArrayList();
        switch (this.mViewDirection) {
            case 0: {
                arrayList = this.getHorizontalAxisList();
                break;
            }
            case 1: {
                arrayList = this.getHorizontalAxisList();
                break;
            }
            case 2: {
                arrayList = this.getNormalAxisList();
                break;
            }
        }
        return arrayList;
    }

    public ArrayList getYAxisList() {
        ArrayList arrayList = new ArrayList();
        switch (this.mViewDirection) {
            case 0: {
                arrayList = this.getPerpendicularAxisList();
                break;
            }
            case 1: {
                arrayList = this.getNormalAxisList();
                break;
            }
            case 2: {
                arrayList = this.getHorizontalAxisList();
                break;
            }
        }
        return arrayList;
    }

    public ArrayList getZAxisList() {
        ArrayList arrayList = new ArrayList();
        switch (this.mViewDirection) {
            case 0: {
                arrayList = this.getNormalAxisList();
                break;
            }
            case 1: {
                arrayList = this.getPerpendicularAxisList();
                break;
            }
            case 2: {
                arrayList = this.getPerpendicularAxisList();
                break;
            }
            default: {
                throw new Error("not defined");
            }
        }
        return arrayList;
    }

    public ArrayList getHorizontalAxisList() {
        ArrayList<SGAxis> arrayList = new ArrayList<SGAxis>();
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            int n = this.getConfiguration(elementsGroupOfAxis.getConfigurationInCube());
            if (n != 0 && n != 1) continue;
            arrayList.add(elementsGroupOfAxis.mAxis);
        }
        return arrayList;
    }

    public ArrayList getPerpendicularAxisList() {
        ArrayList<SGAxis> arrayList = new ArrayList<SGAxis>();
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            int n = this.getConfiguration(elementsGroupOfAxis.getConfigurationInCube());
            if (n != 2 && n != 3) continue;
            arrayList.add(elementsGroupOfAxis.mAxis);
        }
        return arrayList;
    }

    public ArrayList getNormalAxisList() {
        ArrayList arrayList = this.getHorizontalAxisList();
        ArrayList arrayList2 = this.getPerpendicularAxisList();
        ArrayList arrayList3 = this.getAxisList();
        for (int i = arrayList3.size() - 1; i >= 0; --i) {
            SGAxis sGAxis = (SGAxis)arrayList3.get(i);
            if (!arrayList.contains(sGAxis) && !arrayList2.contains(sGAxis)) continue;
            arrayList3.remove(sGAxis);
        }
        return arrayList3;
    }

    public SGAxis getAxisInCube(int n) {
        ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroupInCube(n);
        if (elementsGroupOfAxis == null) {
            return null;
        }
        SGAxis sGAxis = elementsGroupOfAxis.mAxis;
        return sGAxis;
    }

    public SGAxis getAxisInPlane(int n) {
        ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroupInPlane(n);
        if (elementsGroupOfAxis == null) {
            return null;
        }
        SGAxis sGAxis = elementsGroupOfAxis.mAxis;
        return sGAxis;
    }

    public SGIAxisPanelObserver getAxisPanelObserverInPlane(int n) {
        return this.getAxisGroupInPlane(n);
    }

    private ElementsGroupOfAxis getAxisGroupInCube(int n) {
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            if (elementsGroupOfAxis.getConfigurationInCube() != n) continue;
            return elementsGroupOfAxis;
        }
        return null;
    }

    private ElementsGroupOfAxis getAxisGroupInPlane(int n) {
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            if (elementsGroupOfAxis.getConfigurationInPlane() != n) continue;
            return elementsGroupOfAxis;
        }
        return null;
    }

    public int getConfigurationInCube(SGAxis sGAxis) {
        if (sGAxis == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            SGAxis sGAxis2 = elementsGroupOfAxis.mAxis;
            if (!sGAxis2.equals(sGAxis)) continue;
            n = elementsGroupOfAxis.getConfigurationInCube();
            return n;
        }
        return n;
    }

    public String getAxisLocation(SGAxis sGAxis) {
        int n = this.getConfigurationInPlane(sGAxis);
        return this.getAxisLocation(n);
    }

    public String getAxisLocation(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Bottom";
                break;
            }
            case 1: {
                string = "Top";
                break;
            }
            case 2: {
                string = "Left";
                break;
            }
            case 3: {
                string = "Right";
                break;
            }
        }
        return string;
    }

    public int getConfigFromString(String string) {
        int n = -1;
        if ("Bottom".equals(string)) {
            n = 0;
        } else if ("Top".equals(string)) {
            n = 1;
        } else if ("Left".equals(string)) {
            n = 2;
        } else if ("Right".equals(string)) {
            n = 3;
        }
        return n;
    }

    public String getConfigurationStringInPlane(SGAxis sGAxis) {
        int n = this.getConfigurationInPlane(sGAxis);
        return this.getAxisLocation(n);
    }

    public int getConfigurationInPlane(SGAxis sGAxis) {
        if (sGAxis == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            SGAxis sGAxis2 = elementsGroupOfAxis.mAxis;
            if (!sGAxis2.equals(sGAxis)) continue;
            n = elementsGroupOfAxis.getConfigurationInPlane();
            return n;
        }
        return n;
    }

    public int getConfiguration(int n) {
        int n2 = 0;
        block0 : switch (this.mViewDirection) {
            case 0: {
                switch (n) {
                    case 1: {
                        n2 = 0;
                        break block0;
                    }
                    case 2: {
                        n2 = 1;
                        break block0;
                    }
                    case 3: {
                        n2 = 1;
                        break block0;
                    }
                    case 4: {
                        n2 = 0;
                        break block0;
                    }
                    case 5: {
                        n2 = 2;
                        break block0;
                    }
                    case 6: {
                        n2 = 2;
                        break block0;
                    }
                    case 7: {
                        n2 = 3;
                        break block0;
                    }
                    case 8: {
                        n2 = 3;
                        break block0;
                    }
                }
                n2 = -1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new Error("not defined");
            }
        }
        return n2;
    }

    private int getConfigurationInCubeByPlane(int n) {
        int n2 = 0;
        block0 : switch (this.mViewDirection) {
            case 0: {
                switch (n) {
                    case 0: {
                        n2 = 1;
                        break block0;
                    }
                    case 1: {
                        n2 = 2;
                        break block0;
                    }
                    case 2: {
                        n2 = 5;
                        break block0;
                    }
                    case 3: {
                        n2 = 8;
                        break block0;
                    }
                }
                n2 = -1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new Error("not defined");
            }
        }
        return n2;
    }

    public String getConfigurationString(int n) {
        int n2 = this.getConfiguration(n);
        return this.getAxisLocation(n2);
    }

    public int getConfigurationInCube(String string) {
        int n = this.getConfigFromString(string);
        int n2 = this.getConfigurationInCubeByPlane(n);
        return n2;
    }

    public SGAxis getAxis(String string) {
        int n = this.getConfigurationInCube(string);
        SGAxis sGAxis = this.getAxisInCube(n);
        return sGAxis;
    }

    public String toString() {
        return new String("SGAxisElement");
    }

    public String getClassDescription() {
        return "Axes";
    }

    public ArrayList getPropertyDialogObserverList() {
        ArrayList<SGAxisElement> arrayList = new ArrayList<SGAxisElement>();
        if (this.mClickedFlag) {
            arrayList.add(this);
        }
        return arrayList;
    }

    public ArrayList getChildNodes() {
        return new ArrayList();
    }

    public SGPropertyDialog getPropertyDialog() {
        return this.mDialog;
    }

    private boolean showEditField(SGDrawingElementString2D sGDrawingElementString2D) {
        JTextField jTextField = this.mTextField;
        this.mEditingStringElement = sGDrawingElementString2D;
        Rectangle2D rectangle2D = sGDrawingElementString2D.getStringRect();
        Rectangle2D rectangle2D2 = sGDrawingElementString2D.getElementBounds();
        float f = this.getMagnification() * this.getFontSize();
        int n = (int)(rectangle2D2.getX() - (double)jTextField.getInsets().left);
        int n2 = (int)(rectangle2D2.getY() - (double)(f / 2.0f));
        int n3 = (int)(rectangle2D.getWidth() + (double)f);
        int n4 = (int)(rectangle2D.getHeight() + (double)f);
        jTextField.setLocation(n, n2);
        jTextField.setSize(n3, n4);
        Font font = new Font(this.getFontName(), this.getFontStyle(), (int)f);
        jTextField.setFont(font);
        jTextField.setForeground(this.mStringColor);
        jTextField.setText(sGDrawingElementString2D.getString());
        jTextField.setVisible(true);
        jTextField.requestFocus();
        jTextField.setCaretPosition(0);
        return true;
    }

    public boolean commit() {
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.mChangedFlag = true;
        }
        this.mTemporaryProperties = null;
        this.createAllDrawingElements();
        this.repaint();
        this.notifyChange();
        return true;
    }

    public boolean cancel() {
        if (!this.setProperties(this.mTemporaryProperties)) {
            return false;
        }
        this.mTemporaryProperties = null;
        this.mDialog.setVisible(false);
        this.createAllDrawingElements();
        this.repaint();
        this.notifyChange();
        return true;
    }

    public boolean preview() {
        if (!this.createAllDrawingElements()) {
            return false;
        }
        this.repaint();
        this.notifyChange();
        return true;
    }

    public boolean undo() {
        boolean bl = super.undo();
        if (!bl) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    public boolean redo() {
        boolean bl = super.redo();
        if (!bl) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    public boolean updateHistory() {
        return this.updateHistory_(new ArrayList());
    }

    public boolean addPropertiesHistory(SGProperties sGProperties) {
        if (!(sGProperties instanceof AxisProperties)) {
            return false;
        }
        boolean bl = super.addPropertiesHistory(sGProperties);
        return bl;
    }

    private float getMaxLengthOfScaleNumbers(ElementsGroupOfAxis elementsGroupOfAxis) {
        ArrayList arrayList = elementsGroupOfAxis.mScaleNumberList;
        double d = Double.MIN_VALUE;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            Rectangle2D rectangle2D = sGDrawingElementString2D.getElementBounds();
            double d2 = rectangle2D.getWidth();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return (float)d;
    }

    private boolean createAllDrawingElements() {
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            if (elementsGroupOfAxis.createDrawingElements()) continue;
            return false;
        }
        return true;
    }

    private boolean setLocationOfAllDrawingElements() {
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            if (elementsGroupOfAxis.setLocationOfDrawingElements()) continue;
            return false;
        }
        return true;
    }

    public String getTagName() {
        return "Axes";
    }

    public Element createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            Element element2 = elementsGroupOfAxis.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        return element;
    }

    public boolean createDataObject(Element element, SGData sGData) {
        if (!super.createDataObject(element, sGData)) {
            return false;
        }
        this.mStartFlag = false;
        return true;
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("AxisLineWidth", Float.toString(this.mAxisLineWidth) + "pt");
        element.setAttribute("TickMarkWidth", Float.toString(this.mScaleLineWidth) + "pt");
        element.setAttribute("TickMarkLength", Float.toString(this.mScaleLineLength * 0.035277776f) + "cm");
        element.setAttribute("LineColor", SGUtilityText.getColorString(this.mLineColor));
        element.setAttribute("FontName", this.mTitleFontName);
        element.setAttribute("FontSize", Float.toString(this.mTitleFontSize) + "pt");
        element.setAttribute("FontStyle", SGUtilityText.getFontStyleName(this.mTitleFontStyle));
        element.setAttribute("StringColor", SGUtilityText.getColorString(this.mStringColor));
        element.setAttribute("FrameLineVisible", Boolean.toString(this.mFrameLinesVisibleFlag));
        element.setAttribute("FrameLineWidth", Float.toString(this.mFrameLineWidth) + "pt");
        element.setAttribute("FrameLineColor", SGUtilityText.getColorString(this.mFrameLineColor));
        return true;
    }

    public boolean readProperty(Element element) {
        ElementsGroupOfAxis elementsGroupOfAxis = null;
        elementsGroupOfAxis = this.addAxisGroup(1);
        if (elementsGroupOfAxis == null) {
            return false;
        }
        elementsGroupOfAxis = this.addAxisGroup(2);
        if (elementsGroupOfAxis == null) {
            return false;
        }
        elementsGroupOfAxis = this.addAxisGroup(5);
        if (elementsGroupOfAxis == null) {
            return false;
        }
        elementsGroupOfAxis = this.addAxisGroup(8);
        if (elementsGroupOfAxis == null) {
            return false;
        }
        boolean bl = this.createDialog(0);
        if (!bl) {
            return false;
        }
        bl = this.setProperty(element);
        return bl;
    }

    private AxisCommonProperties readCommonProperties(Element element) {
        String string = null;
        Float f = null;
        Color color = null;
        Boolean bl = null;
        string = element.getAttribute("AxisLineWidth");
        if (string.length() == 0) {
            return null;
        }
        f = SGUtilityText.getFloat(string, "pt");
        if (f == null) {
            return null;
        }
        float f2 = ((Number)f).floatValue();
        string = element.getAttribute("TickMarkWidth");
        if (string.length() == 0) {
            return null;
        }
        f = SGUtilityText.getFloat(string, "pt");
        if (f == null) {
            return null;
        }
        float f3 = ((Number)f).floatValue();
        string = element.getAttribute("TickMarkLength");
        if (string.length() == 0) {
            return null;
        }
        f = SGUtilityText.getFloat(string, "cm");
        if (f == null) {
            return null;
        }
        float f4 = ((Number)f).floatValue() / 0.035277776f;
        string = element.getAttribute("LineColor");
        if (string.length() == 0) {
            return null;
        }
        Color color2 = SGUtilityText.getColorFromString(string);
        string = element.getAttribute("FontName");
        if (string.length() == 0) {
            return null;
        }
        String string2 = string;
        string = element.getAttribute("FontStyle");
        if (string.length() == 0) {
            return null;
        }
        int n = SGUtilityText.getFontStyle(string);
        if (n == -1) {
            return null;
        }
        string = element.getAttribute("FontSize");
        if (string.length() == 0) {
            return null;
        }
        f = SGUtilityText.getFloat(string, "pt");
        if (f == null) {
            return null;
        }
        float f5 = ((Number)f).floatValue();
        string = element.getAttribute("StringColor");
        if (string.length() == 0) {
            return null;
        }
        color = SGUtilityText.getColorFromString(string);
        if (color == null) {
            return null;
        }
        Color color3 = color;
        string = element.getAttribute("FrameLineVisible");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl2 = bl;
        string = element.getAttribute("FrameLineWidth");
        if (string.length() == 0) {
            return null;
        }
        f = SGUtilityText.getFloat(string, "pt");
        if (f == null) {
            return null;
        }
        float f6 = ((Number)f).floatValue();
        string = element.getAttribute("FrameLineColor");
        if (string.length() == 0) {
            return null;
        }
        color = SGUtilityText.getColorFromString(string);
        if (color == null) {
            return null;
        }
        Color color4 = color;
        AxisCommonProperties axisCommonProperties = new AxisCommonProperties();
        axisCommonProperties.axisLineWidth = f2;
        axisCommonProperties.scaleLineLength = f4;
        axisCommonProperties.scaleLineWidth = f3;
        axisCommonProperties.lineColor = color2;
        axisCommonProperties.stringColor = color3;
        axisCommonProperties.fontName = string2;
        axisCommonProperties.fontSize = f5;
        axisCommonProperties.fontStyle = n;
        axisCommonProperties.frameLinesVisibleFlag = bl2;
        axisCommonProperties.frameLineColor = color4;
        axisCommonProperties.frameLineWidth = f6;
        return axisCommonProperties;
    }

    private AxisIndividualProperties readIndividualProperties(Element element) {
        String string = null;
        Number number = null;
        Object var7_4 = null;
        Boolean bl = null;
        string = element.getAttribute("Position");
        if (string.length() == 0) {
            return null;
        }
        int n = this.getConfigFromString(string);
        if (n == -1) {
            return null;
        }
        int n2 = this.getConfigurationInCubeByPlane(n);
        string = element.getAttribute("AxisVisible");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl2 = bl;
        string = element.getAttribute("ScaleType");
        if (string.length() == 0) {
            return null;
        }
        int n3 = SGUtilityText.getScaleType(string);
        if (n3 == -1) {
            return null;
        }
        string = element.getAttribute("MinValue");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getDouble(string);
        if (number == null) {
            return null;
        }
        double d = number.doubleValue();
        string = element.getAttribute("MaxValue");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getDouble(string);
        if (number == null) {
            return null;
        }
        double d2 = number.doubleValue();
        string = element.getAttribute("AutomaticCalculationOfTick");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl3 = bl;
        string = element.getAttribute("StepValue");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getDouble(string);
        if (number == null) {
            return null;
        }
        double d3 = number.doubleValue();
        string = element.getAttribute("BaselineValue");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getDouble(string);
        if (number == null) {
            return null;
        }
        double d4 = number.doubleValue();
        string = element.getAttribute("TitleVisible");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl4 = bl;
        string = element.getAttribute("Title");
        if (string.length() == 0) {
            return null;
        }
        String string2 = string;
        string = element.getAttribute("NumberVisible");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl5 = bl;
        string = element.getAttribute("NumberInteger");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl6 = bl;
        string = element.getAttribute("TickMarkVisible");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl7 = bl;
        string = element.getAttribute("TickMarkInside");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl8 = bl;
        string = element.getAttribute("Exponent");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl9 = bl;
        string = element.getAttribute("ExponentValue");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getInteger(string);
        if (number == null) {
            return null;
        }
        int n4 = number.intValue();
        AxisIndividualProperties axisIndividualProperties = new AxisIndividualProperties();
        axisIndividualProperties.configuration = n2;
        axisIndividualProperties.axisVisibleFlag = bl2;
        axisIndividualProperties.scaleType = n3;
        axisIndividualProperties.minValue = d;
        axisIndividualProperties.maxValue = d2;
        axisIndividualProperties.autoCalcAxisNumberFlag = bl3;
        axisIndividualProperties.incrementValue = d3;
        axisIndividualProperties.baseTickValue = d4;
        axisIndividualProperties.titleVisibleFlag = bl4;
        axisIndividualProperties.titleString = string2;
        axisIndividualProperties.scaleNumbersVisibleFlag = bl5;
        axisIndividualProperties.scaleNumbersIntegerFlag = bl6;
        axisIndividualProperties.scaleLinesInsideFlag = bl8;
        axisIndividualProperties.scaleLinesVisibleFlag = bl7;
        axisIndividualProperties.exponentFlag = bl9;
        axisIndividualProperties.exponentValue = n4;
        return axisIndividualProperties;
    }

    private boolean setProperty(Element element) {
        AxisCommonProperties axisCommonProperties = this.readCommonProperties(element);
        if (axisCommonProperties == null) {
            return false;
        }
        boolean bl = this.setCommonProperties(axisCommonProperties);
        if (!bl) {
            return false;
        }
        NodeList nodeList = element.getElementsByTagName("Axis");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            AxisIndividualProperties axisIndividualProperties = this.readIndividualProperties(element2);
            ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroupInCube(axisIndividualProperties.configuration);
            bl = elementsGroupOfAxis.setProperties(axisIndividualProperties);
            if (!bl) {
                return false;
            }
            if (elementsGroupOfAxis.createDrawingElements()) continue;
            return false;
        }
        return true;
    }

    public SGProperties getProperties() {
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.cp = this.getCommonProperties();
        axisProperties.ipArray = new AxisIndividualProperties[this.mElementsGroupList.size()];
        for (int i = 0; i < axisProperties.ipArray.length; ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            axisProperties.ipArray[i] = elementsGroupOfAxis.getProperties();
        }
        return axisProperties;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof AxisProperties)) {
            return false;
        }
        AxisProperties axisProperties = (AxisProperties)sGProperties;
        if (!this.setCommonProperties(axisProperties.cp)) {
            return false;
        }
        AxisIndividualProperties[] axisIndividualPropertiesArray = axisProperties.ipArray;
        for (int i = 0; i < axisIndividualPropertiesArray.length; ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroupInCube(axisIndividualPropertiesArray[i].configuration);
            if (elementsGroupOfAxis.setProperties(axisIndividualPropertiesArray[i])) continue;
            return false;
        }
        return true;
    }

    private AxisCommonProperties getCommonProperties() {
        AxisCommonProperties axisCommonProperties = new AxisCommonProperties();
        axisCommonProperties.viewDirection = this.mViewDirection;
        axisCommonProperties.frameLinesVisibleFlag = this.mFrameLinesVisibleFlag;
        axisCommonProperties.frameLineWidth = this.mFrameLineWidth;
        axisCommonProperties.frameLineColor = this.mFrameLineColor;
        axisCommonProperties.lineColor = this.mLineColor;
        axisCommonProperties.stringColor = this.mStringColor;
        axisCommonProperties.axisLineWidth = this.mAxisLineWidth;
        axisCommonProperties.scaleLineWidth = this.mScaleLineWidth;
        axisCommonProperties.scaleLineLength = this.mScaleLineLength;
        axisCommonProperties.fontSize = this.mTitleFontSize;
        axisCommonProperties.fontName = this.mTitleFontName;
        axisCommonProperties.fontStyle = this.mTitleFontStyle;
        return axisCommonProperties;
    }

    private boolean setCommonProperties(AxisCommonProperties axisCommonProperties) {
        this.mViewDirection = axisCommonProperties.viewDirection;
        this.setFrameLinesVisible(axisCommonProperties.frameLinesVisibleFlag);
        this.setFrameLineWidth(axisCommonProperties.frameLineWidth);
        this.setFrameLineColor(axisCommonProperties.frameLineColor);
        this.setLineColor(axisCommonProperties.lineColor);
        this.setStringColor(axisCommonProperties.stringColor);
        this.setAxisLineWidth(axisCommonProperties.axisLineWidth);
        this.setScaleLineWidth(axisCommonProperties.scaleLineWidth);
        this.setScaleLineLength(axisCommonProperties.scaleLineLength);
        this.setFontSize(axisCommonProperties.fontSize);
        this.setFontName(axisCommonProperties.fontName);
        this.setFontStyle(axisCommonProperties.fontStyle);
        return true;
    }

    public static class AxisIndividualProperties
    extends SGProperties {
        int configuration;
        int scaleType;
        double minValue;
        double maxValue;
        boolean autoCalcAxisNumberFlag;
        double incrementValue;
        double baseTickValue;
        String titleString;
        boolean axisVisibleFlag;
        boolean titleVisibleFlag;
        boolean scaleLinesVisibleFlag;
        boolean scaleNumbersVisibleFlag;
        boolean scaleLinesInsideFlag;
        boolean scaleNumbersIntegerFlag;
        boolean exponentFlag;
        int exponentValue;

        public boolean equals(Object object) {
            if (!(object instanceof AxisIndividualProperties)) {
                return false;
            }
            AxisIndividualProperties axisIndividualProperties = (AxisIndividualProperties)object;
            if (axisIndividualProperties.configuration != this.configuration) {
                return false;
            }
            if (axisIndividualProperties.scaleType != this.scaleType) {
                return false;
            }
            if (axisIndividualProperties.minValue != this.minValue) {
                return false;
            }
            if (axisIndividualProperties.maxValue != this.maxValue) {
                return false;
            }
            if (axisIndividualProperties.autoCalcAxisNumberFlag != this.autoCalcAxisNumberFlag) {
                return false;
            }
            if (axisIndividualProperties.incrementValue != this.incrementValue) {
                return false;
            }
            if (axisIndividualProperties.baseTickValue != this.baseTickValue) {
                return false;
            }
            if (!axisIndividualProperties.titleString.equals(this.titleString)) {
                return false;
            }
            if (axisIndividualProperties.axisVisibleFlag != this.axisVisibleFlag) {
                return false;
            }
            if (axisIndividualProperties.titleVisibleFlag != this.titleVisibleFlag) {
                return false;
            }
            if (axisIndividualProperties.scaleLinesVisibleFlag != this.scaleLinesVisibleFlag) {
                return false;
            }
            if (axisIndividualProperties.scaleNumbersVisibleFlag != this.scaleNumbersVisibleFlag) {
                return false;
            }
            if (axisIndividualProperties.scaleLinesInsideFlag != this.scaleLinesInsideFlag) {
                return false;
            }
            if (axisIndividualProperties.scaleNumbersIntegerFlag != this.scaleNumbersIntegerFlag) {
                return false;
            }
            if (axisIndividualProperties.exponentFlag != this.exponentFlag) {
                return false;
            }
            return axisIndividualProperties.exponentValue == this.exponentValue;
        }
    }

    public static class AxisCommonProperties
    extends SGProperties {
        int viewDirection;
        boolean frameLinesVisibleFlag;
        float frameLineWidth;
        Color frameLineColor;
        Color lineColor;
        Color stringColor;
        float axisLineWidth;
        float scaleLineWidth;
        float scaleLineLength;
        float fontSize;
        String fontName;
        int fontStyle;

        public boolean equals(Object object) {
            if (!(object instanceof AxisCommonProperties)) {
                return false;
            }
            AxisCommonProperties axisCommonProperties = (AxisCommonProperties)object;
            if (axisCommonProperties.viewDirection != this.viewDirection) {
                return false;
            }
            if (axisCommonProperties.frameLinesVisibleFlag != this.frameLinesVisibleFlag) {
                return false;
            }
            if (axisCommonProperties.frameLineWidth != this.frameLineWidth) {
                return false;
            }
            if (!axisCommonProperties.frameLineColor.equals(this.frameLineColor)) {
                return false;
            }
            if (!axisCommonProperties.lineColor.equals(this.lineColor)) {
                return false;
            }
            if (!axisCommonProperties.stringColor.equals(this.stringColor)) {
                return false;
            }
            if (axisCommonProperties.axisLineWidth != this.axisLineWidth) {
                return false;
            }
            if (axisCommonProperties.scaleLineWidth != this.scaleLineWidth) {
                return false;
            }
            if (axisCommonProperties.scaleLineLength != this.scaleLineLength) {
                return false;
            }
            if (axisCommonProperties.fontSize != this.fontSize) {
                return false;
            }
            if (!axisCommonProperties.fontName.equals(this.fontName)) {
                return false;
            }
            return axisCommonProperties.fontStyle == this.fontStyle;
        }
    }

    public static class AxisProperties
    extends SGProperties {
        AxisCommonProperties cp;
        AxisIndividualProperties[] ipArray;

        AxisProperties() {
        }

        public boolean equals(Object object) {
            if (!(object instanceof AxisProperties)) {
                return false;
            }
            AxisProperties axisProperties = (AxisProperties)object;
            if (!axisProperties.cp.equals(this.cp)) {
                return false;
            }
            if (axisProperties.ipArray.length != this.ipArray.length) {
                return false;
            }
            for (int i = 0; i < this.ipArray.length; ++i) {
                if (axisProperties.ipArray[i].equals(this.ipArray[i])) continue;
                return false;
            }
            return true;
        }
    }

    class ElementsGroupOfAxis
    implements ActionListener,
    SGIAxisPanelObserver {
        private int mConfigurationInCube = -1;
        private SGAxis mAxis = null;
        private final ElementLineOfAxis mAxisLine = new ElementLineOfAxis();
        private final ElementStringOfTitle mTitle = new ElementStringOfTitle();
        private final ArrayList mScaleNumberList = new ArrayList();
        private final ArrayList mScaleLineList = new ArrayList();
        private boolean mVisibleFlag = true;
        private boolean mAxisLineVisibleFlag = true;
        private boolean mTitleVisibleFlag = true;
        private boolean mScaleNumbersVisibleFlag = true;
        private boolean mScaleLinesVisibleFlag = true;
        private boolean mScaleLinesInsideFlag = true;
        private double[] mAxisValueArray = null;
        private boolean mAutoCalcAxisNumberFlag = true;
        private double mStepValue = 0.0;
        private double mBaseTickValue = 0.0;
        private boolean mScaleNumbersIntegerFlag = false;
        private boolean mExponentFlag = false;
        private int mExponentValue = 0;
        private SGDrawingElementString2DExtended mExponentDrawingElement = null;
        private SGDrawingElement mDraggingElement = null;
        private final JPopupMenu mPopupMenu = new JPopupMenu();
        private boolean mGridLineVisibleFlag;
        private float mGridLineWidth;
        private int mGridLineStyle;
        private Color mGridLineColor;
        public static final String MENUCMD_HIDE = "Hide Axis";
        private SGTuple2d mTempRange = null;

        protected ElementsGroupOfAxis() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.mScaleNumbersVisibleFlag = true;
            this.mScaleNumbersIntegerFlag = false;
            this.mScaleLinesVisibleFlag = true;
            this.mScaleLinesInsideFlag = true;
            this.mGridLineVisibleFlag = false;
            this.mGridLineWidth = 1.0f;
            Integer n = SGDrawingElementLine.getLineTypeFromName("Dotted");
            if (n == null) {
                return false;
            }
            this.mGridLineStyle = n;
            this.mGridLineColor = SGDefaultValues.AXIS_GRID_LINE_COLOR;
            this.createPopupMenu();
            return true;
        }

        public boolean isAxisVisible() {
            return this.mVisibleFlag;
        }

        public boolean isTitleVisible() {
            return this.mTitleVisibleFlag;
        }

        public String getTitleString() {
            return this.mTitle.getString();
        }

        public double getMinValue() {
            return this.mAxis.getMinValue();
        }

        public double getMaxValue() {
            return this.mAxis.getMaxValue();
        }

        public int getScaleType() {
            return this.mAxis.getScaleType();
        }

        public boolean isCalculateAutomatically() {
            return this.mAutoCalcAxisNumberFlag;
        }

        public double getStepValue() {
            return this.mStepValue;
        }

        public double getBaselineValue() {
            return this.mBaseTickValue;
        }

        public boolean isTickMarksVisible() {
            return this.mScaleLinesVisibleFlag;
        }

        public boolean isTickMarksInside() {
            return this.mScaleLinesInsideFlag;
        }

        public boolean isNumbersVisible() {
            return this.mScaleNumbersVisibleFlag;
        }

        public boolean isNumbersInteger() {
            return this.mScaleNumbersIntegerFlag;
        }

        public boolean isExponentVisible() {
            return this.mExponentFlag;
        }

        public int getExponent() {
            return this.mExponentValue;
        }

        public boolean setAxisVisible(boolean bl) {
            this.mVisibleFlag = bl;
            return true;
        }

        public boolean setTitleVisible(boolean bl) {
            this.mTitleVisibleFlag = bl;
            return true;
        }

        public boolean setTitle(String string) {
            this.mTitle.setString(string);
            return true;
        }

        public boolean setMinValue(double d) {
            this.mAxis.setRange(d, this.getMaxValue());
            return true;
        }

        public boolean setMaxValue(double d) {
            this.mAxis.setRange(this.getMinValue(), d);
            return true;
        }

        public boolean setScaleType(int n) {
            this.mAxis.setScaleType(n);
            return true;
        }

        public boolean setCalculateAutomatically(boolean bl) {
            this.mAutoCalcAxisNumberFlag = bl;
            return true;
        }

        public boolean setTickMarksStepValue(double d) {
            this.mStepValue = d;
            return true;
        }

        public boolean setTickMarksBaselineValue(double d) {
            this.mBaseTickValue = d;
            return true;
        }

        public boolean setTickMarksVisible(boolean bl) {
            this.mScaleLinesVisibleFlag = bl;
            return true;
        }

        public boolean setTickMarksInside(boolean bl) {
            this.mScaleLinesInsideFlag = bl;
            return true;
        }

        public boolean setNumbersVisible(boolean bl) {
            this.mScaleNumbersVisibleFlag = bl;
            return true;
        }

        public boolean setNumbersInteger(boolean bl) {
            this.mScaleNumbersIntegerFlag = bl;
            return true;
        }

        public boolean setExponentVisible(boolean bl) {
            this.mExponentFlag = bl;
            return true;
        }

        public boolean setExponentValue(int n) {
            this.mExponentValue = n;
            return true;
        }

        public boolean hasValidAxisValues(Number number, Number number2, Integer n, Number number3, Number number4) {
            double d;
            double d2 = number != null ? number.doubleValue() : this.getMinValue();
            double d3 = number2 != null ? number2.doubleValue() : this.getMaxValue();
            int n2 = n != null ? n.intValue() : this.getScaleType();
            double d4 = number3 != null ? number3.doubleValue() : this.getBaselineValue();
            double d5 = d = number4 != null ? number4.doubleValue() : this.getStepValue();
            if (d2 >= d3) {
                return false;
            }
            if (n2 == 1 && d2 <= 0.0) {
                return false;
            }
            return d != 0.0;
        }

        private boolean createPopupMenu() {
            JPopupMenu jPopupMenu = this.mPopupMenu;
            jPopupMenu.setBounds(0, 0, 100, 100);
            jPopupMenu.add(new JLabel("  -- Axis --"));
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, MENUCMD_HIDE);
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Property");
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals(MENUCMD_HIDE)) {
                this.mVisibleFlag = false;
                SGAxisElement.this.repaint();
                SGAxisElement.this.setChanged(true);
                SGAxisElement.this.notifyToRoot();
                return;
            }
            if (string.equals("Property")) {
                this.showPropertyDialog();
            }
        }

        private void showPropertyDialog() {
            SGAxisElement.this.mClickedFlag = true;
            SGAxisElement.this.mTempAxisConfiguration = this.getConfigurationInPlane();
            SGAxisElement.this.setPropertiesOfSelectedObjects();
            SGAxisElement.this.mClickedFlag = false;
            SGAxisElement.this.mTempAxisConfiguration = -1;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            if (this.mVisibleFlag) {
                Object object;
                Object object2;
                if (this.mAxisLineVisibleFlag) {
                    object2 = this.mAxisLine;
                    float f = SGAxisElement.this.mMagnification * ((SGDrawingElementLine)object2).getLineWidth();
                    object = new BasicStroke(f, 2, 0);
                    SGAxisElement.this.drawLine((SGDrawingElementLine2D)object2, graphics2D, (BasicStroke)object);
                }
                if (this.mTitleVisibleFlag) {
                    SGAxisElement.this.drawString(this.mTitle, graphics2D);
                    if (this.mTitle.equals(SGAxisElement.this.mPressedElement)) {
                        SGAxisElement.this.drawStringBounds(this.mTitle, graphics2D);
                    }
                }
                if (this.mScaleNumbersVisibleFlag) {
                    object2 = this.mScaleNumberList;
                    for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                        object = (ElementStringOfScale)((ArrayList)object2).get(i);
                        SGAxisElement.this.drawString((SGDrawingElementString2D)object, graphics2D);
                    }
                    if (this.mDraggingElement != null && this.mDraggingElement instanceof ElementStringOfScale) {
                        ElementStringOfScale elementStringOfScale = (ElementStringOfScale)this.mDraggingElement;
                        SGAxisElement.this.drawString(elementStringOfScale, graphics2D);
                        SGAxisElement.this.drawStringBounds(elementStringOfScale, graphics2D);
                    }
                    if (this.mExponentFlag) {
                        SGAxisElement.this.drawString(this.mExponentDrawingElement, graphics2D);
                    }
                }
                if (this.mScaleLinesVisibleFlag) {
                    ElementLineOfScale elementLineOfScale;
                    int n;
                    float f;
                    object2 = this.mScaleLineList;
                    boolean bl = this.mDraggingElement != null & this.mDraggingElement instanceof ElementLineOfScale;
                    float f2 = SGAxisElement.this.mMagnification * SGAxisElement.this.mScaleLineWidth;
                    float f3 = f = bl ? f2 * 2.0f : f2;
                    if (bl) {
                        for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                            ElementLineOfScale elementLineOfScale2 = (ElementLineOfScale)((ArrayList)object2).get(i);
                            elementLineOfScale2.setLineWidth(f);
                        }
                    }
                    BasicStroke basicStroke = new BasicStroke(f, 0, 2);
                    for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                        elementLineOfScale = (ElementLineOfScale)((ArrayList)object2).get(n);
                        SGAxisElement.this.drawLine(elementLineOfScale, graphics2D, basicStroke);
                    }
                    if (bl) {
                        for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                            elementLineOfScale = (ElementLineOfScale)((ArrayList)object2).get(n);
                            elementLineOfScale.setLineWidth(f2);
                        }
                    }
                }
            }
        }

        private double getTitleHeight() {
            Rectangle2D rectangle2D = this.mTitle.getStringRect();
            return rectangle2D.getHeight();
        }

        private double getScaleHeight() {
            double d = 0.0;
            if (this.mScaleNumberList.size() == 0) {
                Font font = new Font(SGAxisElement.this.mScaleFontName, SGAxisElement.this.mScaleFontStyle, (int)(SGAxisElement.this.mMagnification * SGAxisElement.this.mScaleFontSize));
                Rectangle2D rectangle2D = font.getStringBounds("", new FontRenderContext(null, false, false));
                d = rectangle2D.getHeight();
            } else {
                SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)this.mScaleNumberList.get(0);
                Rectangle2D rectangle2D = sGDrawingElementString2D.getStringRect();
                d = rectangle2D.getHeight();
            }
            return d;
        }

        private int getConfigurationInPlane() {
            return SGAxisElement.this.getConfiguration(this.mConfigurationInCube);
        }

        private int getConfigurationInCube() {
            return this.mConfigurationInCube;
        }

        private boolean setConfigurationInPlane(int n) {
            this.mConfigurationInCube = SGAxisElement.this.getConfigurationInCubeByPlane(n);
            return true;
        }

        private boolean setConfigurationInCube(int n) {
            this.mConfigurationInCube = n;
            return true;
        }

        public boolean zoom(float f) {
            SGDrawingElement sGDrawingElement;
            int n;
            this.mAxisLine.zoom(f);
            this.mTitle.zoom(f);
            for (n = 0; n < this.mScaleNumberList.size(); ++n) {
                sGDrawingElement = (ElementStringOfScale)this.mScaleNumberList.get(n);
                sGDrawingElement.zoom(f);
            }
            for (n = 0; n < this.mScaleLineList.size(); ++n) {
                sGDrawingElement = (ElementLineOfScale)this.mScaleLineList.get(n);
                sGDrawingElement.zoom(f);
            }
            return true;
        }

        private Rectangle2D getBoundingBox() {
            if (!this.isAxisVisible()) {
                return null;
            }
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            ArrayList<SGDrawingElement> arrayList = new ArrayList<SGDrawingElement>();
            arrayList.add(this.mAxisLine);
            if (this.mTitleVisibleFlag) {
                arrayList.add(this.mTitle);
            }
            if (this.mScaleNumbersVisibleFlag) {
                for (int i = 0; i < this.mScaleNumberList.size(); ++i) {
                    ElementStringOfScale elementStringOfScale = (ElementStringOfScale)this.mScaleNumberList.get(i);
                    if (!elementStringOfScale.isVisible()) continue;
                    arrayList.add(elementStringOfScale);
                }
                if (this.mExponentFlag) {
                    arrayList.add(this.mExponentDrawingElement);
                }
            }
            if (arrayList.size() != 0) {
                ((Rectangle2D)float_).setRect(SGUtilityJava2D.getBoundingBox(arrayList));
            }
            return float_;
        }

        public boolean onMouseClicked(MouseEvent mouseEvent) {
            SGDrawingElement sGDrawingElement;
            int n;
            int n2;
            int n3 = mouseEvent.getX();
            boolean bl = this.mAxisLine.contains(n3, n2 = mouseEvent.getY());
            if (bl) {
                return this.clicked(mouseEvent);
            }
            if (!this.mVisibleFlag) {
                return false;
            }
            if (this.mTitleVisibleFlag && (bl = this.mTitle.contains(n3, n2))) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                    SGAxisElement.this.showEditField(this.mTitle);
                    return true;
                }
                return this.clicked(mouseEvent);
            }
            if (this.mScaleNumbersVisibleFlag) {
                for (n = 0; n < this.mScaleNumberList.size(); ++n) {
                    sGDrawingElement = (ElementStringOfScale)this.mScaleNumberList.get(n);
                    bl = ((SGDrawingElementString2D)sGDrawingElement).contains(n3, n2);
                    if (!bl) continue;
                    return this.clicked(mouseEvent);
                }
            }
            if (this.mScaleLinesVisibleFlag) {
                for (n = 0; n < this.mScaleLineList.size(); ++n) {
                    sGDrawingElement = (ElementLineOfScale)this.mScaleLineList.get(n);
                    bl = ((SGDrawingElementLine2D)sGDrawingElement).contains(n3, n2);
                    if (!bl) continue;
                    return this.clicked(mouseEvent);
                }
            }
            return false;
        }

        public boolean contains(int n, int n2) {
            SGDrawingElement sGDrawingElement;
            int n3;
            boolean bl = this.mAxisLine.contains(n, n2);
            if (bl) {
                return true;
            }
            bl = this.mTitle.contains(n, n2);
            if (bl) {
                return true;
            }
            for (n3 = 0; n3 < this.mScaleNumberList.size(); ++n3) {
                sGDrawingElement = (ElementStringOfScale)this.mScaleNumberList.get(n3);
                bl = ((SGDrawingElementString2D)sGDrawingElement).contains(n, n2);
                if (!bl) continue;
                return true;
            }
            for (n3 = 0; n3 < this.mScaleLineList.size(); ++n3) {
                sGDrawingElement = (ElementLineOfScale)this.mScaleLineList.get(n3);
                bl = ((SGDrawingElementLine2D)sGDrawingElement).contains(n, n2);
                if (!bl) continue;
                return true;
            }
            return false;
        }

        private boolean clicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                SGAxisElement.this.showPopupMenu(this.mPopupMenu, n, n2);
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                this.showPropertyDialog();
            }
            return true;
        }

        public boolean onMousePressed(MouseEvent mouseEvent) {
            SGDrawingElement sGDrawingElement;
            int n;
            int n2;
            if (!this.mVisibleFlag) {
                return false;
            }
            int n3 = mouseEvent.getX();
            boolean bl = this.mAxisLine.contains(n3, n2 = mouseEvent.getY());
            if (bl) {
                return true;
            }
            if (this.mTitleVisibleFlag && (bl = this.mTitle.contains(n3, n2))) {
                SGAxisElement.this.mPressedElement = this.mTitle;
                SGAxisElement.this.mPressedElementOrigin = new Point((int)((float)mouseEvent.getX() - this.mTitle.getX()), (int)((float)mouseEvent.getY() - this.mTitle.getY()));
                return true;
            }
            if (this.mScaleNumbersVisibleFlag) {
                for (n = 0; n < this.mScaleNumberList.size(); ++n) {
                    sGDrawingElement = (ElementStringOfScale)this.mScaleNumberList.get(n);
                    if (!sGDrawingElement.isVisible() || !((SGDrawingElementString2D)sGDrawingElement).contains(n3, n2)) continue;
                    SGAxisElement.this.mPressedElement = sGDrawingElement;
                    SGAxisElement.this.mPressedElementOrigin = new Point((int)((float)mouseEvent.getX() - ((SGDrawingElementString)sGDrawingElement).getX()), (int)((float)mouseEvent.getY() - ((SGDrawingElementString)sGDrawingElement).getY()));
                    this.mTempRange = this.mAxis.getRange();
                    this.mDraggingElement = new ElementStringOfScale((ElementStringOfScale)sGDrawingElement);
                    this.mDraggingElement.setMagnification(sGDrawingElement.getMagnification());
                    return true;
                }
            }
            if (this.mScaleLinesVisibleFlag) {
                for (n = 0; n < this.mScaleLineList.size(); ++n) {
                    sGDrawingElement = (ElementLineOfScale)this.mScaleLineList.get(n);
                    if (!sGDrawingElement.isVisible() || !((SGDrawingElementLine2D)sGDrawingElement).contains(n3, n2)) continue;
                    SGAxisElement.this.mPressedElement = sGDrawingElement;
                    SGAxisElement.this.mPressedElementOrigin = mouseEvent.getPoint();
                    this.mTempRange = this.mAxis.getRange();
                    this.mDraggingElement = new ElementLineOfScale((ElementLineOfScale)sGDrawingElement);
                    this.mDraggingElement.setMagnification(sGDrawingElement.getMagnification());
                    return true;
                }
            }
            return false;
        }

        public boolean onMouseDragged(MouseEvent mouseEvent) {
            if (this.mDraggingElement == null || this.mTempRange == null) {
                return false;
            }
            int n = this.mAxis.getScaleType();
            if (this.mDraggingElement instanceof ElementStringOfScale) {
                double d;
                double d2;
                double d3;
                double d4;
                float f;
                double d5;
                double d6;
                double d7;
                ElementStringOfScale elementStringOfScale = (ElementStringOfScale)this.mDraggingElement;
                Rectangle2D rectangle2D = elementStringOfScale.getElementBounds();
                if (n == 0) {
                    d7 = this.mTempRange.x;
                    d6 = this.mTempRange.y;
                    d5 = elementStringOfScale.mValue;
                } else if (n == 1) {
                    d7 = Math.log(this.mTempRange.x) / Math.log(10.0);
                    d6 = Math.log(this.mTempRange.y) / Math.log(10.0);
                    d5 = Math.log(elementStringOfScale.mValue) / Math.log(10.0);
                } else {
                    throw new Error();
                }
                if (this.getConfigurationInPlane() == 0 || this.getConfigurationInPlane() == 1) {
                    double d8 = (double)(mouseEvent.getX() - ((SGAxisElement)SGAxisElement.this).mPressedElementOrigin.x) + rectangle2D.getWidth() / 2.0;
                    f = this.mAxisLine.getStart().x;
                    float f2 = this.mAxisLine.getEnd().x;
                    float f3 = f2 - f;
                    if (d8 > (double)f2) {
                        d8 = f2;
                    }
                    if (d8 <= (double)f) {
                        return false;
                    }
                    double d9 = d7 + (d6 - d7) * (d8 - (double)f) / (double)(f2 - f);
                    d4 = d7;
                    d3 = d7 + (d6 - d7) * (d5 - d7) / (d9 - d7);
                    if (n == 0) {
                        d3 = SGAxisElement.this.getNumberInRangeOrder(d3, this.mAxis);
                    }
                    float f4 = (float)(d8 - rectangle2D.getWidth() / 2.0);
                    elementStringOfScale.setX(f4);
                    if (d3 - d4 < 0.05 * (d6 - d7)) {
                        return false;
                    }
                } else if (this.getConfigurationInPlane() == 2 || this.getConfigurationInPlane() == 3) {
                    float f5 = (float)(mouseEvent.getY() - ((SGAxisElement)SGAxisElement.this).mPressedElementOrigin.y) + (float)rectangle2D.getHeight() / 2.0f;
                    float f6 = this.mAxisLine.getEnd().y;
                    f = this.mAxisLine.getStart().y;
                    float f7 = f - f6;
                    if (f5 >= f) {
                        return false;
                    }
                    if (f5 < f6) {
                        f5 = f6;
                    }
                    double d10 = d7 + (d6 - d7) * (1.0 - (double)((f5 - f6) / (f - f6)));
                    d4 = d7;
                    d3 = d7 + (d6 - d7) * (d5 - d7) / (d10 - d7);
                    if (n == 0) {
                        d3 = SGAxisElement.this.getNumberInRangeOrder(d3, this.mAxis);
                    }
                    float f8 = (float)((double)f5 - rectangle2D.getHeight() / 2.0);
                    elementStringOfScale.setY(f8);
                    if (d3 - d4 < 0.05 * (d6 - d7)) {
                        return false;
                    }
                } else {
                    throw new Error();
                }
                if (n == 0) {
                    d2 = d4;
                    d = d3;
                } else if (n == 1) {
                    d2 = Math.pow(10.0, d4);
                    d = Math.pow(10.0, d3);
                } else {
                    throw new Error();
                }
                this.mAxis.setRange(d2, d);
            } else if (this.mDraggingElement instanceof ElementLineOfScale) {
                double d;
                double d11;
                double d12;
                double d13;
                float f;
                float f9;
                double d14;
                double d15;
                double d16;
                ElementLineOfScale elementLineOfScale = (ElementLineOfScale)this.mDraggingElement;
                if (n == 0) {
                    d16 = this.mTempRange.x;
                    d15 = this.mTempRange.y;
                    d14 = elementLineOfScale.mValue;
                } else if (n == 1) {
                    d16 = Math.log(this.mTempRange.x) / Math.log(10.0);
                    d15 = Math.log(this.mTempRange.y) / Math.log(10.0);
                    d14 = Math.log(elementLineOfScale.mValue) / Math.log(10.0);
                } else {
                    throw new Error();
                }
                if (this.getConfigurationInPlane() == 0 || this.getConfigurationInPlane() == 1) {
                    f9 = mouseEvent.getX();
                    if ((float)((SGAxisElement)SGAxisElement.this).mPressedElementOrigin.x == f9) {
                        return false;
                    }
                    float f10 = this.mAxisLine.getStart().x;
                    f = this.mAxisLine.getEnd().x;
                    if (f9 > f) {
                        f9 = f;
                    }
                    if (f9 < f10) {
                        f9 = f10;
                    }
                    double d17 = d16 + (d15 - d16) * (double)(f9 - f10) / (double)(f - f10);
                    double d18 = Math.abs(d17 - d14);
                    if (d17 > d14) {
                        d13 = d16 - d18;
                        d12 = d15 - d18;
                    } else {
                        d13 = d16 + d18;
                        d12 = d15 + d18;
                    }
                    if (n == 0) {
                        d13 = SGAxisElement.this.getNumberInRangeOrder(d13, this.mAxis);
                        d12 = SGAxisElement.this.getNumberInRangeOrder(d12, this.mAxis);
                    }
                } else if (this.getConfigurationInPlane() == 2 || this.getConfigurationInPlane() == 3) {
                    f9 = mouseEvent.getY();
                    if ((float)((SGAxisElement)SGAxisElement.this).mPressedElementOrigin.y == f9) {
                        return false;
                    }
                    float f11 = this.mAxisLine.getEnd().y;
                    f = this.mAxisLine.getStart().y;
                    if (f9 > f) {
                        f9 = f;
                    }
                    if (f9 < f11) {
                        f9 = f11;
                    }
                    double d19 = d16 + (d15 - d16) * (1.0 - (double)((f9 - f11) / (f - f11)));
                    double d20 = Math.abs(d19 - d14);
                    if (d19 > d14) {
                        d13 = d16 - d20;
                        d12 = d15 - d20;
                    } else {
                        d13 = d16 + d20;
                        d12 = d15 + d20;
                    }
                    if (n == 0) {
                        d13 = SGAxisElement.this.getNumberInRangeOrder(d13, this.mAxis);
                        d12 = SGAxisElement.this.getNumberInRangeOrder(d12, this.mAxis);
                    }
                } else {
                    throw new Error();
                }
                if (n == 0) {
                    d11 = d13;
                    d = d12;
                } else if (n == 1) {
                    d11 = Math.pow(10.0, d13);
                    d = Math.pow(10.0, d12);
                } else {
                    throw new Error();
                }
                this.mAxis.setRange(d11, d);
            }
            if (!this.createDrawingElements()) {
                return false;
            }
            if (SGAxisElement.this.mNotifyChangeOnDraggingFlag) {
                SGAxisElement.this.notifyChange();
            }
            return true;
        }

        public boolean onMouseReleased(MouseEvent mouseEvent) {
            if (this.mTempRange != null || this.mDraggingElement != null) {
                this.mTempRange = null;
                this.mDraggingElement = null;
                if (this.getConfigurationInPlane() == 0 || this.getConfigurationInPlane() == 1) {
                    ElementsGroupOfAxis elementsGroupOfAxis = SGAxisElement.this.getAxisGroupInPlane(2);
                } else if (this.getConfigurationInPlane() == 2 || this.getConfigurationInPlane() == 3) {
                    ElementsGroupOfAxis elementsGroupOfAxis = SGAxisElement.this.getAxisGroupInPlane(0);
                }
                return true;
            }
            return false;
        }

        public boolean onDrawingElement(int n, int n2) {
            boolean bl = false;
            bl = this.isAxisVisible() ? this.contains(n, n2) : this.mAxisLine.contains(n, n2);
            if (bl) {
                SGAxisElement.this.setMouseCursor(12);
                return true;
            }
            return false;
        }

        private boolean createDrawingElements() {
            if (!this.setAxisLineProperties()) {
                return false;
            }
            if (!this.setAxisLineLocation()) {
                return false;
            }
            if (!this.createScaleDrawingElements()) {
                return false;
            }
            if (!this.setTitleProperties()) {
                return false;
            }
            return this.setLocationOfTitleElement();
        }

        private boolean setLocationOfDrawingElements() {
            if (!this.setAxisLineLocation()) {
                return false;
            }
            if (this.mScaleNumbersVisibleFlag && !this.setLocationOfScaleNumbers()) {
                return false;
            }
            if (this.mScaleLinesVisibleFlag && !this.createScaleLines()) {
                return false;
            }
            return !this.mTitleVisibleFlag || this.setLocationOfTitleElement();
        }

        private boolean createScaleDrawingElements() {
            if (!this.calcValueArrayInScale()) {
                return false;
            }
            if (!this.createScaleNumberInstances()) {
                return false;
            }
            if (!this.setLocationOfScaleNumbers()) {
                return false;
            }
            return this.createScaleLines();
        }

        private boolean setAxisLineLocation() {
            float f;
            float f2;
            float f3;
            float f4;
            float f5 = SGAxisElement.this.mGraphRectX;
            float f6 = SGAxisElement.this.mGraphRectY;
            float f7 = SGAxisElement.this.mGraphRectWidth;
            float f8 = SGAxisElement.this.mGraphRectHeight;
            switch (this.getConfigurationInPlane()) {
                case 0: {
                    f4 = f5;
                    f3 = f6 + f8;
                    f2 = f5 + f7;
                    f = f3;
                    break;
                }
                case 1: {
                    f4 = f5;
                    f3 = f6;
                    f2 = f5 + f7;
                    f = f3;
                    break;
                }
                case 2: {
                    f4 = f5;
                    f3 = f6 + f8;
                    f2 = f4;
                    f = f6;
                    break;
                }
                case 3: {
                    f4 = f5 + f7;
                    f3 = f6 + f8;
                    f2 = f4;
                    f = f6;
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            this.mAxisLine.setTermPoints(f4, f3, f2, f);
            return true;
        }

        private boolean setAxisLineProperties() {
            this.mAxisLine.setLineWidth(SGAxisElement.this.mAxisLineWidth);
            this.mAxisLine.setColor(SGAxisElement.this.mLineColor);
            return true;
        }

        private boolean setLocationOfTitleElement() {
            float f = SGAxisElement.this.mGraphRectX;
            float f2 = SGAxisElement.this.mGraphRectY;
            float f3 = SGAxisElement.this.mGraphRectWidth;
            float f4 = SGAxisElement.this.mGraphRectHeight;
            float f5 = SGAxisElement.this.mMagnification;
            float f6 = SGAxisElement.this.getSpaceAxisLineAndNumber() * f5;
            float f7 = SGAxisElement.this.getSpaceNumberAndTitle() * f5;
            float f8 = 0.0f;
            float f9 = 0.0f;
            f8 = (float)this.getScaleHeight();
            f9 = SGAxisElement.this.getMaxLengthOfScaleNumbers(this);
            switch (this.getConfigurationInPlane()) {
                case 0: {
                    Rectangle2D rectangle2D = this.mTitle.getElementBounds();
                    this.mTitle.setLocation(f + (f3 - (float)rectangle2D.getWidth()) / 2.0f, f2 + f4 + f8 + (f6 + f7));
                    break;
                }
                case 1: {
                    Rectangle2D rectangle2D = this.mTitle.getElementBounds();
                    this.mTitle.setLocation(f + (f3 - (float)rectangle2D.getWidth()) / 2.0f, f2 - f8 - (float)rectangle2D.getHeight() - (f6 + f7));
                    break;
                }
                case 2: {
                    this.mTitle.setAngle(1.5707964f);
                    Rectangle2D rectangle2D = this.mTitle.getElementBounds();
                    this.mTitle.setLocation(f - f9 - (float)rectangle2D.getWidth() - (f6 + f7), f2 + (f4 + (float)rectangle2D.getHeight()) / 2.0f);
                    break;
                }
                case 3: {
                    this.mTitle.setAngle(1.5707964f);
                    Rectangle2D rectangle2D = this.mTitle.getElementBounds();
                    this.mTitle.setLocation(f + f3 + f9 + (f6 + f7), f2 + (f4 + (float)rectangle2D.getHeight()) / 2.0f);
                    break;
                }
            }
            return true;
        }

        private boolean setTitleProperties() {
            this.mTitle.setColor(SGAxisElement.this.mStringColor);
            this.mTitle.setFont(SGAxisElement.this.mTitleFontName, SGAxisElement.this.mTitleFontStyle, SGAxisElement.this.mTitleFontSize);
            return true;
        }

        private boolean createScaleNumberInstances() {
            this.mScaleNumberList.clear();
            this.mExponentDrawingElement = null;
            int n = this.mAxis.getScaleType();
            double[] dArray = this.mAxisValueArray;
            double[] dArray2 = null;
            int n2 = this.mExponentValue;
            if (this.mExponentFlag) {
                dArray2 = new double[this.mAxisValueArray.length];
                for (int i = 0; i < dArray2.length; ++i) {
                    BigDecimal bigDecimal = new BigDecimal(Double.toString(dArray[i]));
                    bigDecimal = bigDecimal.movePointLeft(n2);
                    dArray2[i] = bigDecimal.doubleValue();
                }
            } else {
                dArray2 = dArray;
            }
            String[] stringArray = new String[dArray2.length];
            if (n == 0) {
                if (this.mScaleNumbersIntegerFlag) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = Integer.toString((int)dArray2[i]);
                    }
                } else {
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = Double.toString(dArray2[i]);
                    }
                }
            } else if (n == 1) {
                for (int i = 0; i < stringArray.length; ++i) {
                    int n3 = SGUtilityNumber.getOrder(dArray2[i]);
                    stringArray[i] = SGUtilityText.getSuperscriptString("10", Integer.toString(n3));
                }
            }
            float f = SGAxisElement.this.mMagnification;
            Color color = SGAxisElement.this.mStringColor;
            String string = SGAxisElement.this.mScaleFontName;
            int n4 = SGAxisElement.this.mScaleFontStyle;
            float f2 = SGAxisElement.this.mScaleFontSize;
            for (int i = 0; i < dArray.length; ++i) {
                ElementStringOfScale elementStringOfScale = new ElementStringOfScale(stringArray[i], string, n4, f2);
                elementStringOfScale.mValue = dArray[i];
                if (!this.mAxis.insideRange(elementStringOfScale.mValue)) {
                    elementStringOfScale.setVisible(false);
                }
                elementStringOfScale.setMagnification(f);
                elementStringOfScale.setColor(color);
                this.mScaleNumberList.add(elementStringOfScale);
            }
            if (this.mExponentFlag) {
                this.createExponentDrawingElement();
            }
            return true;
        }

        private boolean createExponentDrawingElement() {
            String string = SGIConstants.multiply + "10";
            string = SGUtilityText.getSuperscriptString(string, Integer.toString(this.mExponentValue));
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = new SGDrawingElementString2DExtended(string, SGAxisElement.this.mScaleFontName, SGAxisElement.this.mScaleFontStyle, SGAxisElement.this.mScaleFontSize);
            sGDrawingElementString2DExtended.setMagnification(SGAxisElement.this.mMagnification);
            sGDrawingElementString2DExtended.setColor(SGAxisElement.this.mStringColor);
            this.mExponentDrawingElement = sGDrawingElementString2DExtended;
            this.setLocationOfExponentDrawingElement();
            return true;
        }

        private boolean setLocationOfExponentDrawingElement() {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = this.mExponentDrawingElement;
            Rectangle2D rectangle2D = ((SGDrawingElementString2D)sGDrawingElementString2DExtended).getElementBounds();
            float f = SGAxisElement.this.mGraphRectX;
            float f2 = SGAxisElement.this.mGraphRectY;
            float f3 = SGAxisElement.this.mGraphRectWidth;
            float f4 = SGAxisElement.this.mGraphRectHeight;
            float f5 = SGAxisElement.this.mMagnification;
            float f6 = SGAxisElement.this.getSpaceAxisLineAndNumber() * f5;
            float f7 = SGAxisElement.this.getSpaceNumberAndTitle() * f5;
            float f8 = 0.0f;
            float f9 = 0.0f;
            switch (this.getConfigurationInPlane()) {
                case 0: {
                    f8 = f + f3 - 0.0f * (float)rectangle2D.getWidth();
                    f9 = f2 + f4 + (float)((double)f6 + this.getScaleHeight() + (double)f7);
                    break;
                }
                case 1: {
                    f8 = f + f3 - 0.0f * (float)rectangle2D.getWidth();
                    f9 = f2 - (float)((double)f6 + this.getScaleHeight() + (double)f7 + this.getTitleHeight());
                    break;
                }
                case 2: {
                    f8 = f - (float)((double)(f6 + SGAxisElement.this.getMaxLengthOfScaleNumbers(this) + f7) + rectangle2D.getWidth());
                    f9 = f2 - (float)rectangle2D.getHeight();
                    break;
                }
                case 3: {
                    f8 = f + f3 + f6 + SGAxisElement.this.getMaxLengthOfScaleNumbers(this) + f7;
                    f9 = f2 - (float)rectangle2D.getHeight();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            ((SGDrawingElementString)sGDrawingElementString2DExtended).setLocation(f8, f9);
            return true;
        }

        private boolean setLocationOfScaleNumbers() {
            int n = this.getConfigurationInPlane();
            float f = SGAxisElement.this.mGraphRectX;
            float f2 = SGAxisElement.this.mGraphRectY;
            float f3 = SGAxisElement.this.mGraphRectWidth;
            float f4 = SGAxisElement.this.mGraphRectHeight;
            int n2 = this.mAxis.getScaleType();
            double[] dArray = null;
            if (n2 == 0) {
                dArray = this.mAxisValueArray;
            } else if (n2 == 1) {
                dArray = new double[this.mAxisValueArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = Math.log(this.mAxisValueArray[i]);
                }
            }
            double d = 0.0;
            double d2 = 0.0;
            if (n2 == 0) {
                d = this.mAxis.getMinValue();
                d2 = this.mAxis.getMaxValue();
            } else if (n2 == 1) {
                d = Math.log(this.mAxis.getMinValue());
                d2 = Math.log(this.mAxis.getMaxValue());
            }
            float f5 = SGAxisElement.this.mMagnification;
            float f6 = SGAxisElement.this.getSpaceNumberAndTitle() * f5;
            float f7 = SGAxisElement.this.getSpaceAxisLineAndNumber() * f5;
            block7: for (int i = 0; i < this.mScaleNumberList.size(); ++i) {
                ElementStringOfScale elementStringOfScale = (ElementStringOfScale)this.mScaleNumberList.get(i);
                Rectangle2D rectangle2D = elementStringOfScale.getElementBounds();
                float f8 = (float)rectangle2D.getWidth();
                float f9 = (float)rectangle2D.getHeight();
                switch (n) {
                    case 0: {
                        float f10 = (float)((double)f + (double)f3 * (dArray[i] - d) / (d2 - d));
                        float f11 = f2 + f4 + f7;
                        elementStringOfScale.setLocation(f10 - 0.5f * f8, f11);
                        continue block7;
                    }
                    case 1: {
                        float f10 = (float)((double)f + (double)f3 * (dArray[i] - d) / (d2 - d));
                        float f11 = (float)((double)(f2 - f7) - rectangle2D.getHeight());
                        elementStringOfScale.setLocation(f10 - 0.5f * f8, f11);
                        continue block7;
                    }
                    case 2: {
                        float f10 = (float)((double)f2 + (double)f4 * (1.0 - (dArray[i] - d) / (d2 - d)));
                        float f11 = (float)((double)(f - f7) - rectangle2D.getWidth());
                        elementStringOfScale.setLocation(f11, f10 - 0.5f * f9);
                        continue block7;
                    }
                    case 3: {
                        float f10 = (float)((double)f2 + (double)f4 * (1.0 - (dArray[i] - d) / (d2 - d)));
                        float f11 = f + f3 + f7;
                        elementStringOfScale.setLocation(f11, f10 - 0.5f * f9);
                        continue block7;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            if (this.mExponentFlag) {
                this.setLocationOfExponentDrawingElement();
            }
            return true;
        }

        private boolean createScaleLines() {
            this.mScaleLineList.clear();
            boolean bl = true;
            switch (this.mAxis.getScaleType()) {
                case 0: {
                    bl = this.createScaleLinesInLinearScale();
                    break;
                }
                case 1: {
                    bl = this.createScaleLinesInLogScale();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return bl;
        }

        private boolean createScaleLinesInLinearScale() {
            ElementLineOfScale elementLineOfScale;
            double d;
            int n;
            float f = SGAxisElement.this.mMagnification;
            float f2 = f * SGAxisElement.this.mScaleLineLength;
            Color color = SGAxisElement.this.mLineColor;
            double[] dArray = this.mAxisValueArray;
            for (n = 0; n < dArray.length; ++n) {
                d = dArray[n];
                elementLineOfScale = this.createSingleScaleLine(d, f2);
                if (elementLineOfScale == null) continue;
                elementLineOfScale.mValue = d;
                elementLineOfScale.setMagnification(f);
                elementLineOfScale.setColor(color);
                this.mScaleLineList.add(elementLineOfScale);
            }
            for (n = 0; n < dArray.length && n != dArray.length - 1; ++n) {
                d = (dArray[n] + dArray[n + 1]) / 2.0;
                elementLineOfScale = this.createSingleScaleLine(d, f2);
                if (elementLineOfScale == null) continue;
                elementLineOfScale.mValue = d;
                elementLineOfScale.setMagnification(f);
                elementLineOfScale.setColor(color);
                this.mScaleLineList.add(elementLineOfScale);
            }
            return true;
        }

        private boolean createScaleLinesInLogScale() {
            int n;
            float f = SGAxisElement.this.mMagnification * SGAxisElement.this.mScaleLineLength;
            for (int i = 0; i < this.mAxisValueArray.length; ++i) {
                double d = this.mAxisValueArray[i];
                ElementLineOfScale elementLineOfScale = this.createSingleScaleLine(d, f);
                if (elementLineOfScale == null) continue;
                elementLineOfScale.mValue = d;
                elementLineOfScale.setMagnification(SGAxisElement.this.mMagnification);
                elementLineOfScale.setColor(SGAxisElement.this.mLineColor);
                this.mScaleLineList.add(elementLineOfScale);
            }
            for (n = 0; n < this.mAxisValueArray.length; ++n) {
                for (int i = 2; i < 10; ++i) {
                    double d = this.mAxisValueArray[n] * 0.1 * (double)i;
                    ElementLineOfScale elementLineOfScale = this.createSingleScaleLine(d, 1.0f * f);
                    if (elementLineOfScale == null) continue;
                    elementLineOfScale.mValue = d;
                    elementLineOfScale.setMagnification(SGAxisElement.this.mMagnification);
                    elementLineOfScale.setColor(SGAxisElement.this.mLineColor);
                    this.mScaleLineList.add(elementLineOfScale);
                }
            }
            if (this.mAxisValueArray.length >= 1) {
                for (n = 2; n < 10; ++n) {
                    double d = this.mAxisValueArray[this.mAxisValueArray.length - 1] * (double)n;
                    ElementLineOfScale elementLineOfScale = this.createSingleScaleLine(d, 1.0f * f);
                    if (elementLineOfScale == null) continue;
                    elementLineOfScale.mValue = d;
                    elementLineOfScale.setMagnification(SGAxisElement.this.mMagnification);
                    elementLineOfScale.setColor(SGAxisElement.this.mLineColor);
                    this.mScaleLineList.add(elementLineOfScale);
                }
            }
            return true;
        }

        private ElementLineOfScale createSingleScaleLine(double d, float f) {
            double d2;
            double d3;
            double d4;
            if (!this.mAxis.insideRange(d)) {
                return null;
            }
            float f2 = SGAxisElement.this.mGraphRectX;
            float f3 = SGAxisElement.this.mGraphRectY;
            float f4 = SGAxisElement.this.mGraphRectWidth;
            float f5 = SGAxisElement.this.mGraphRectHeight;
            float f6 = SGAxisElement.this.mMagnification;
            boolean bl = this.mScaleLinesInsideFlag;
            float f7 = SGAxisElement.this.mScaleLineWidth;
            switch (this.mAxis.getScaleType()) {
                case 0: {
                    d4 = this.mAxis.getMinValue();
                    d3 = this.mAxis.getMaxValue();
                    d2 = d;
                    break;
                }
                case 1: {
                    d4 = Math.log(this.mAxis.getMinValue());
                    d3 = Math.log(this.mAxis.getMaxValue());
                    d2 = Math.log(d);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            ElementLineOfScale elementLineOfScale = null;
            switch (this.getConfigurationInPlane()) {
                case 0: {
                    double d5 = (double)f2 + (double)f4 * (d2 - d4) / (d3 - d4);
                    double d6 = f3 + f5;
                    double d7 = 0.0;
                    d7 = bl ? d6 - (double)f : d6 + (double)f;
                    SGTuple2f sGTuple2f = new SGTuple2f((float)d5, (float)d6);
                    SGTuple2f sGTuple2f2 = new SGTuple2f((float)d5, (float)d7);
                    elementLineOfScale = new ElementLineOfScale(sGTuple2f, sGTuple2f2);
                    elementLineOfScale.setLineWidth(f7);
                    elementLineOfScale.setMagnification(f6);
                    break;
                }
                case 1: {
                    double d8 = (double)f2 + (double)f4 * (d2 - d4) / (d3 - d4);
                    double d9 = f3;
                    double d10 = 0.0;
                    d10 = bl ? d9 + (double)f : d9 - (double)f;
                    SGTuple2f sGTuple2f = new SGTuple2f((float)d8, (float)d9);
                    SGTuple2f sGTuple2f3 = new SGTuple2f((float)d8, (float)d10);
                    elementLineOfScale = new ElementLineOfScale(sGTuple2f, sGTuple2f3);
                    elementLineOfScale.setLineWidth(f7);
                    elementLineOfScale.setMagnification(f6);
                    break;
                }
                case 2: {
                    double d11 = (double)f3 + (double)f5 * (1.0 - (d2 - d4) / (d3 - d4));
                    double d12 = f2;
                    double d13 = 0.0;
                    d13 = bl ? d12 + (double)f : d12 - (double)f;
                    SGTuple2f sGTuple2f = new SGTuple2f((float)d12, (float)d11);
                    SGTuple2f sGTuple2f4 = new SGTuple2f((float)d13, (float)d11);
                    elementLineOfScale = new ElementLineOfScale(sGTuple2f, sGTuple2f4);
                    elementLineOfScale.setLineWidth(f7);
                    elementLineOfScale.setMagnification(f6);
                    break;
                }
                case 3: {
                    double d14 = (double)f3 + (double)f5 * (1.0 - (d2 - d4) / (d3 - d4));
                    double d15 = f2 + f4;
                    double d16 = 0.0;
                    d16 = bl ? d15 - (double)f : d15 + (double)f;
                    SGTuple2f sGTuple2f = new SGTuple2f((float)d15, (float)d14);
                    SGTuple2f sGTuple2f5 = new SGTuple2f((float)d16, (float)d14);
                    elementLineOfScale = new ElementLineOfScale(sGTuple2f, sGTuple2f5);
                    elementLineOfScale.setLineWidth(f7);
                    elementLineOfScale.setMagnification(f6);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return elementLineOfScale;
        }

        private boolean calcValueArrayInScale() {
            double[] dArray = null;
            switch (this.mAxis.getScaleType()) {
                case 0: {
                    dArray = this.calcScaleValuesInLinearScale();
                    break;
                }
                case 1: {
                    dArray = this.calcScaleValuesInLogScale();
                    break;
                }
            }
            this.mAxisValueArray = dArray;
            return true;
        }

        private int getRangeOrder() {
            SGTuple2d sGTuple2d = this.mAxis.getRange();
            int n = SGUtilityNumber.getOrder(sGTuple2d.y - sGTuple2d.x);
            return n;
        }

        private double[] calcScaleValuesInLinearScale() {
            double d;
            int n;
            int n2;
            double d2;
            int n3;
            SGAxis sGAxis = this.mAxis;
            SGTuple2d sGTuple2d = sGAxis.getRange();
            double d3 = sGTuple2d.x;
            double d4 = sGTuple2d.y;
            int n4 = SGUtilityNumber.getOrder(d4 - d3);
            if (this.mAutoCalcAxisNumberFlag) {
                this.mBaseTickValue = 0.0;
                this.mStepValue = SGAxisElement.this.calcStepValue(sGAxis);
            }
            double d5 = this.mBaseTickValue;
            double d6 = this.mStepValue;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            if (d5 > d4) {
                if (this.mAxis.insideRange(d5 - d6)) {
                    arrayList.add(new Double(d5));
                }
            } else {
                n3 = 0;
                while (true) {
                    if ((d2 = d5 + (double)n3 * d6) < d3) {
                        if (this.mAxis.insideRange(d2 + d6)) {
                            this.addNumberToList(d2, arrayList, n4, true);
                        }
                        ++n3;
                        continue;
                    }
                    this.addNumberToList(d2, arrayList, n4, true);
                    ++n3;
                    if (d2 > d4) break;
                }
            }
            if (d5 < d3) {
                if (this.mAxis.insideRange(d5 + d6)) {
                    arrayList.add(0, new Double(d5));
                }
            } else {
                n3 = 0;
                while (true) {
                    if ((d2 = d5 - (double)n3 * d6) > d4) {
                        if (this.mAxis.insideRange(d2 - d6)) {
                            this.addNumberToList(d2, arrayList, n4, false);
                        }
                        ++n3;
                        continue;
                    }
                    this.addNumberToList(d2, arrayList, n4, false);
                    ++n3;
                    if (d2 < d3) break;
                }
            }
            double[] dArray = new double[arrayList.size()];
            for (n2 = 0; n2 < dArray.length; ++n2) {
                dArray[n2] = (Double)arrayList.get(n2);
            }
            if (SGAxisElement.this.mStartFlag) {
                n2 = 1;
                for (n = 0; n < dArray.length; ++n) {
                    d = Math.abs(dArray[n] - (double)((int)dArray[n]));
                    if (Math.round(d) == 0L) continue;
                    n2 = 0;
                    break;
                }
                this.mScaleNumbersIntegerFlag = n2;
            }
            if (this.mScaleNumbersIntegerFlag) {
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                for (n = 0; n < dArray.length; ++n) {
                    if (this.mExponentFlag) {
                        BigDecimal bigDecimal = new BigDecimal(Double.toString(dArray[n]));
                        bigDecimal = bigDecimal.movePointLeft(this.mExponentValue);
                        d = bigDecimal.doubleValue();
                    } else {
                        d = dArray[n];
                    }
                    int n5 = (int)d;
                    if (!(Math.abs((double)n5 - d) < Double.MIN_VALUE)) continue;
                    arrayList2.add(new Integer(n5));
                }
                block5: for (n = arrayList2.size() - 1; n >= 1; --n) {
                    Integer n6 = (Integer)arrayList2.get(n);
                    for (int i = n - 1; i >= 0; --i) {
                        Integer n7 = (Integer)arrayList2.get(i);
                        if (n7.intValue() != n6.intValue()) continue;
                        arrayList2.remove(n);
                        continue block5;
                    }
                }
                double[] dArray2 = new double[arrayList2.size()];
                for (int i = 0; i < dArray2.length; ++i) {
                    double d7 = ((Integer)arrayList2.get(i)).doubleValue();
                    if (this.mExponentFlag) {
                        BigDecimal bigDecimal = new BigDecimal(Double.toString(d7));
                        bigDecimal = bigDecimal.movePointRight(this.mExponentValue);
                        d7 = bigDecimal.doubleValue();
                    }
                    dArray2[i] = d7;
                }
                dArray = dArray2;
            }
            return dArray;
        }

        private void addNumberToList(double d, ArrayList arrayList, int n, boolean bl) {
            double d2 = SGUtilityNumber.roundOffNumber(d, n - 5);
            Double d3 = new Double(d2);
            if (bl) {
                arrayList.add(d3);
            } else {
                arrayList.add(0, d3);
            }
        }

        private double[] calcScaleValuesInLogScale() {
            int n;
            double d = this.mAxis.getRange().x;
            double d2 = this.mAxis.getRange().y;
            double[] dArray = null;
            int n2 = SGUtilityNumber.getOrder(0.99999999999999 * d);
            int n3 = SGUtilityNumber.getOrder(d2);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = n2 + 1; n <= n3; ++n) {
                arrayList.add(new Integer(n));
            }
            dArray = new double[arrayList.size()];
            for (n = 0; n < dArray.length; ++n) {
                int n4 = (Integer)arrayList.get(n);
                dArray[n] = SGUtilityNumber.getPowersOfTen(n4);
            }
            return dArray;
        }

        public String getTagName() {
            return "Axis";
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            SGTuple2d sGTuple2d = this.mAxis.getRange();
            int n = this.getConfigurationInCube();
            String string = SGAxisElement.this.getConfigurationString(n);
            element.setAttribute("Position", string);
            element.setAttribute("AxisVisible", Boolean.toString(this.mVisibleFlag));
            element.setAttribute("ScaleType", SGUtilityText.getScaleTypeName(this.mAxis.getScaleType()));
            element.setAttribute("MinValue", Double.toString(sGTuple2d.x));
            element.setAttribute("MaxValue", Double.toString(sGTuple2d.y));
            element.setAttribute("AutomaticCalculationOfTick", Boolean.toString(this.mAutoCalcAxisNumberFlag));
            element.setAttribute("StepValue", Double.toString(this.mStepValue));
            element.setAttribute("BaselineValue", Double.toString(this.mBaseTickValue));
            element.setAttribute("TitleVisible", Boolean.toString(this.mTitleVisibleFlag));
            element.setAttribute("Title", this.mTitle.getString());
            element.setAttribute("NumberVisible", Boolean.toString(this.mScaleNumbersVisibleFlag));
            element.setAttribute("NumberInteger", Boolean.toString(this.mScaleNumbersIntegerFlag));
            element.setAttribute("TickMarkVisible", Boolean.toString(this.mScaleLinesVisibleFlag));
            element.setAttribute("TickMarkInside", Boolean.toString(this.mScaleLinesInsideFlag));
            element.setAttribute("Exponent", Boolean.toString(this.mExponentFlag));
            element.setAttribute("ExponentValue", Integer.toString(this.mExponentValue));
            element.setAttribute("GridLineVisible", Boolean.toString(this.mGridLineVisibleFlag));
            element.setAttribute("GridLineWidth", Float.toString(this.mGridLineWidth) + "pt");
            element.setAttribute("GridLineStyle", SGDrawingElementLine.getLineTypeName(this.mGridLineStyle));
            element.setAttribute("GridLineColor", SGUtilityText.getColorString(this.mGridLineColor));
            return true;
        }

        private AxisIndividualProperties getProperties() {
            AxisIndividualProperties axisIndividualProperties = new AxisIndividualProperties();
            axisIndividualProperties.configuration = this.getConfigurationInCube();
            axisIndividualProperties.scaleType = this.mAxis.getScaleType();
            SGTuple2d sGTuple2d = this.mAxis.getRange();
            axisIndividualProperties.minValue = sGTuple2d.x;
            axisIndividualProperties.maxValue = sGTuple2d.y;
            axisIndividualProperties.autoCalcAxisNumberFlag = this.mAutoCalcAxisNumberFlag;
            axisIndividualProperties.incrementValue = this.mStepValue;
            axisIndividualProperties.baseTickValue = this.mBaseTickValue;
            axisIndividualProperties.titleString = this.mTitle.getString();
            axisIndividualProperties.axisVisibleFlag = this.mVisibleFlag;
            axisIndividualProperties.titleVisibleFlag = this.mTitleVisibleFlag;
            axisIndividualProperties.scaleLinesVisibleFlag = this.mScaleLinesVisibleFlag;
            axisIndividualProperties.scaleNumbersVisibleFlag = this.mScaleNumbersVisibleFlag;
            axisIndividualProperties.scaleLinesInsideFlag = this.mScaleLinesInsideFlag;
            axisIndividualProperties.scaleNumbersIntegerFlag = this.mScaleNumbersIntegerFlag;
            axisIndividualProperties.exponentFlag = this.mExponentFlag;
            axisIndividualProperties.exponentValue = this.mExponentValue;
            return axisIndividualProperties;
        }

        private boolean setProperties(AxisIndividualProperties axisIndividualProperties) {
            this.mConfigurationInCube = axisIndividualProperties.configuration;
            this.mAxis.setScaleType(axisIndividualProperties.scaleType);
            this.mAxis.setRange(axisIndividualProperties.minValue, axisIndividualProperties.maxValue);
            this.mAutoCalcAxisNumberFlag = axisIndividualProperties.autoCalcAxisNumberFlag;
            this.mStepValue = axisIndividualProperties.incrementValue;
            this.mBaseTickValue = axisIndividualProperties.baseTickValue;
            this.mTitle.setString(axisIndividualProperties.titleString);
            this.mVisibleFlag = axisIndividualProperties.axisVisibleFlag;
            this.mTitleVisibleFlag = axisIndividualProperties.titleVisibleFlag;
            this.mScaleLinesVisibleFlag = axisIndividualProperties.scaleLinesVisibleFlag;
            this.mScaleNumbersVisibleFlag = axisIndividualProperties.scaleNumbersVisibleFlag;
            this.mScaleLinesInsideFlag = axisIndividualProperties.scaleLinesInsideFlag;
            this.mScaleNumbersIntegerFlag = axisIndividualProperties.scaleNumbersIntegerFlag;
            this.mExponentFlag = axisIndividualProperties.exponentFlag;
            this.mExponentValue = axisIndividualProperties.exponentValue;
            return true;
        }
    }

    public static class ElementStringOfScale
    extends SGDrawingElementString2DExtended {
        private double mValue;

        protected ElementStringOfScale(String string, String string2, int n, float f) {
            super(string, string2, n, f);
        }

        protected ElementStringOfScale(ElementStringOfScale elementStringOfScale) {
            super(elementStringOfScale);
            this.mValue = elementStringOfScale.mValue;
        }
    }

    public static class ElementLineOfScale
    extends SGDrawingElementLine2D {
        private double mValue;

        protected ElementLineOfScale(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
            super(sGTuple2f, sGTuple2f2);
        }

        protected ElementLineOfScale(ElementLineOfScale elementLineOfScale) {
            this.mValue = elementLineOfScale.mValue;
        }
    }

    public static class ElementStringOfTitle
    extends SGDrawingElementString2DExtended {
        protected ElementStringOfTitle() {
        }
    }

    public static class ElementLineOfAxis
    extends SGDrawingElementLine2D {
        protected ElementLineOfAxis() {
        }
    }
}

