/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;

public abstract class SGDrawingElementArrow
extends SGDrawingElement
implements SGIArrowConstants,
SGIDrawingElementConstants {
    protected SGDrawingElementLine mLine;
    protected SGDrawingElementSymbol mStartHead;
    protected SGDrawingElementSymbol mEndHead;
    protected float mHeadOpenAngle;
    protected float mHeadCloseAngle;

    public boolean setColor(Color color) {
        super.setColor(color);
        this.mLine.setColor(color);
        this.mStartHead.setColor(color);
        this.mStartHead.setLineColor(color);
        this.mEndHead.setColor(color);
        this.mEndHead.setLineColor(color);
        return true;
    }

    public boolean setColorList(ArrayList arrayList) {
        super.setColorList(arrayList);
        this.mLine.setColorList(arrayList);
        this.mStartHead.setColorList(arrayList);
        this.mEndHead.setColorList(arrayList);
        Color color = (Color)arrayList.get(0);
        this.mStartHead.setLineColor(color);
        this.mEndHead.setLineColor(color);
        return true;
    }

    public boolean setMagnification(float f) {
        super.setMagnification(f);
        this.mLine.setMagnification(f);
        this.mStartHead.setMagnification(f);
        this.mEndHead.setMagnification(f);
        return true;
    }

    public boolean setTermPoints(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        this.mLine.setTermPoints(sGTuple2f, sGTuple2f2);
        this.mStartHead.setLocation(sGTuple2f);
        this.mEndHead.setLocation(sGTuple2f2);
        return true;
    }

    public SGTuple2f getStart() {
        return this.mLine.getStart();
    }

    public SGTuple2f getEnd() {
        return this.mLine.getEnd();
    }

    public boolean setLineWidth(float f) {
        this.mLine.setLineWidth(f);
        return true;
    }

    public boolean setLineType(int n) {
        this.mLine.setLineType(n);
        return true;
    }

    public boolean setHeadSize(float f) {
        this.mStartHead.setSize(f);
        this.mEndHead.setSize(f);
        return true;
    }

    public boolean setHeadOpenAngle(float f) {
        this.mHeadOpenAngle = f;
        return true;
    }

    public boolean setHeadCloseAngle(float f) {
        this.mHeadCloseAngle = f;
        return true;
    }

    public boolean setHeadLineWidth(float f) {
        this.mStartHead.setLineWidth(f);
        this.mEndHead.setLineWidth(f);
        return true;
    }

    public boolean setStartHeadType(int n) {
        this.mStartHead.setType(n);
        return true;
    }

    public boolean setEndHeadType(int n) {
        this.mEndHead.setType(n);
        return true;
    }

    public float getLineWidth() {
        return this.mLine.getLineWidth();
    }

    public int getLineType() {
        return this.mLine.getLineType();
    }

    public float getHeadSize() {
        return this.mStartHead.getSize();
    }

    public float getHeadOpenAngle() {
        return this.mHeadOpenAngle;
    }

    public float getHeadCloseAngle() {
        return this.mHeadCloseAngle;
    }

    public float getHeadLineWidth() {
        return this.mStartHead.getLineWidth();
    }

    public int getStartHeadType() {
        return this.mStartHead.getType();
    }

    public int getEndHeadType() {
        return this.mEndHead.getType();
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementArrow)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)sGDrawingElement;
        this.setHeadSize(sGDrawingElementArrow.getHeadSize());
        this.setHeadOpenAngle(sGDrawingElementArrow.getHeadOpenAngle());
        this.setHeadCloseAngle(sGDrawingElementArrow.getHeadCloseAngle());
        this.setHeadLineWidth(sGDrawingElementArrow.getHeadLineWidth());
        this.setStartHeadType(sGDrawingElementArrow.getStartHeadType());
        this.setEndHeadType(sGDrawingElementArrow.getEndHeadType());
        return true;
    }

    public SGProperties getProperties() {
        ArrowProperties arrowProperties = new ArrowProperties();
        this.getProperties(arrowProperties);
        return arrowProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ArrowProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        ArrowProperties arrowProperties = (ArrowProperties)sGProperties;
        arrowProperties.setLineWidth(this.getLineWidth());
        arrowProperties.setLineType(this.getLineType());
        arrowProperties.setHeadSize(this.getHeadSize());
        arrowProperties.setHeadOpenAngle(this.getHeadOpenAngle());
        arrowProperties.setHeadCloseAngle(this.getHeadCloseAngle());
        arrowProperties.setHeadLineWidth(this.getHeadLineWidth());
        arrowProperties.setStartHeadType(this.getStartHeadType());
        arrowProperties.setEndHeadType(this.getEndHeadType());
        return true;
    }

    public static class ArrowProperties
    extends SGDrawingElement.DrawingElementProperties {
        private SGDrawingElementLine.LineProperties mLineProperties = new SGDrawingElementLine.LineProperties();
        private SGDrawingElementSymbol.SymbolProperties mSymbolProperties = new SGDrawingElementSymbol.SymbolProperties();
        private int mEndHeadType;
        private double mHeadOpenAngle;
        private double mHeadCloseAngle;

        public boolean equals(Object object) {
            if (!(object instanceof ArrowProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ArrowProperties arrowProperties = (ArrowProperties)object;
            if (!this.mLineProperties.equals(arrowProperties.mLineProperties)) {
                return false;
            }
            if (!this.mSymbolProperties.equals(arrowProperties.mSymbolProperties)) {
                return false;
            }
            if (this.mEndHeadType != arrowProperties.mEndHeadType) {
                return false;
            }
            if (this.mHeadOpenAngle != arrowProperties.mHeadOpenAngle) {
                return false;
            }
            return this.mHeadCloseAngle == arrowProperties.mHeadCloseAngle;
        }

        public Float getLineWidth() {
            return this.mLineProperties.getLineWidth();
        }

        public Integer getLineType() {
            return this.mLineProperties.getLineType();
        }

        public Float getHeadLineWidth() {
            return this.mSymbolProperties.getLineWidth();
        }

        public Float getHeadSize() {
            return this.mSymbolProperties.getSize();
        }

        public Integer getStartHeadType() {
            return this.mSymbolProperties.getSymbolType();
        }

        public Integer getEndHeadType() {
            return new Integer(this.mEndHeadType);
        }

        public Float getHeadOpenAngle() {
            return new Float(this.mHeadOpenAngle);
        }

        public Float getHeadCloseAngle() {
            return new Float(this.mHeadCloseAngle);
        }

        public void setLineWidth(float f) {
            this.mLineProperties.setLineWidth(f);
        }

        public void setLineType(int n) {
            this.mLineProperties.setLineType(n);
        }

        public void setHeadLineWidth(float f) {
            this.mSymbolProperties.setLineWidth(f);
        }

        public void setStartHeadType(int n) {
            this.mSymbolProperties.setSymbolType(n);
        }

        public void setEndHeadType(int n) {
            this.mEndHeadType = n;
        }

        public void setHeadSize(float f) {
            this.mSymbolProperties.setSize(f);
        }

        public void setColor(Color color) {
            super.setColor(color);
            this.mLineProperties.setColor(color);
            this.mSymbolProperties.setColor(color);
            this.mSymbolProperties.setLineColor(color);
        }

        public void setColorList(ArrayList arrayList) {
            super.setColorList(arrayList);
            this.mLineProperties.setColorList(arrayList);
            this.mSymbolProperties.setColorList(arrayList);
            Color color = (Color)arrayList.get(0);
            this.mSymbolProperties.setLineColor(color);
        }

        public void setHeadOpenAngle(float f) {
            this.mHeadOpenAngle = f;
        }

        public void setHeadCloseAngle(float f) {
            this.mHeadCloseAngle = f;
        }
    }
}

