/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.data.SGITwoDimensionalData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;

public class SGSXYSamplingData
extends SGSXYMultipleData
implements SGITwoDimensionalData,
Cloneable {
    private double mSamplingRate;

    public SGSXYSamplingData() {
    }

    public SGSXYSamplingData(double d, double[][] dArray) {
        int n;
        if (d <= 0.0) {
            throw new IllegalArgumentException("sRate<=0.0");
        }
        if (dArray == null) {
            throw new IllegalArgumentException("yArray==null");
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("yArray.length==0");
        }
        int n2 = dArray[0].length;
        for (n = 1; n < dArray.length; ++n) {
            if (dArray[n].length == n2) continue;
            throw new IllegalArgumentException("yArray[ii].length!=len");
        }
        this.mSamplingRate = d;
        this.mYValueArray = new double[dArray.length][];
        for (n = 0; n < this.mYValueArray.length; ++n) {
            this.mYValueArray[n] = (double[])dArray[n].clone();
        }
    }

    public double getSamplingRate() {
        return this.mSamplingRate;
    }

    public Double getXValue(int n) {
        return new Double((double)n / this.mSamplingRate);
    }

    protected double[] getXValueArray() {
        double[] dArray = new double[this.getPointsNumber()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.getXValue(i);
        }
        return dArray;
    }

    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYSamplingData)) {
            return false;
        }
        SGSXYSamplingData sGSXYSamplingData = (SGSXYSamplingData)sGData;
        this.mSamplingRate = sGSXYSamplingData.mSamplingRate;
        this.mYValueArray = sGSXYSamplingData.mYValueArray;
        return true;
    }

    public double getMinValueX() {
        return 0.0;
    }

    public double getMaxValueX() {
        return (double)(this.getPointsNumber() - 1) / this.mSamplingRate;
    }

    public int getPointsNumber() {
        return this.mYValueArray[0].length;
    }

    public String toString() {
        String string = "[";
        string = string + "SamplingRate=" + Double.toString(this.mSamplingRate) + ", ";
        string = string + "Y={";
        int n = this.getDataNumber();
        for (int i = 0; i < n; ++i) {
            double[] dArray = this.mYValueArray[i];
            string = string + this.toDoubleArrayString(dArray);
            if (i == dArray.length - 1) break;
            string = string + ",";
        }
        string = string + "}";
        string = string + "]";
        return string;
    }
}

