/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGIPaintable;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SGFigure
extends JLayeredPane
implements ActionListener,
SGIConstants,
SGIUndoable,
SGIMovable,
SGISelectable,
SGIPaintable,
SGIFigureDialogObserver,
SGINode,
SGIRootObjectConstants {
    private int mID;
    protected SGDrawingWindow mWnd = null;
    protected ArrayList mDataList = new ArrayList();
    protected SGIGraphElement mGraphElement = null;
    protected SGILegendElement mLegendElement = null;
    protected SGIStringElement mStringElement = null;
    protected SGIAxisElement mAxisElement = null;
    protected SGIAxisBreakElement mAxisBreakElement = null;
    protected SGISignificantDifferenceElement mSignificantDifferenceElement = null;
    protected SGITimingLineElement mTimingLineElement = null;
    protected SGIGridElement mGridElement = null;
    protected float mGraphRectX = 0.0f;
    protected float mGraphRectY = 0.0f;
    protected float mGraphRectWidth = 0.0f;
    protected float mGraphRectHeight = 0.0f;
    protected float mMagnification = 1.0f;
    protected JPopupMenu mPopupMenu = new JPopupMenu();
    protected SGPropertyDialog mDialog = null;
    protected SGIFigureElement mPressedElement = null;
    protected Point mPressedPoint = new Point();
    protected final Rectangle2D mTempFigureRect = new Rectangle2D.Float();
    protected Rectangle2D mViewBounds = null;
    protected Color mBackgroundColor;
    protected final Rectangle2D mDraggingRect = new Rectangle2D.Float();
    protected boolean mSnapToGridFlag = false;
    protected final Rectangle2D mRubberBandRect = new Rectangle2D.Float();
    public static boolean mRubberBandFlag = true;
    public static boolean mRubberBandVisibleFlag = false;
    protected int mMouseLocation = 0;
    protected float mMinWidth = 50.0f;
    protected float mMinHeight = 50.0f;
    private static boolean mBoundingBoxVisibleFlag = false;
    protected boolean mUpperFitFlag = false;
    protected boolean mLowerFitFlag = false;
    protected boolean mLeftFitFlag = false;
    protected boolean mRightFitFlag = false;
    protected SGProperties mTemporaryProperties = null;
    private boolean mTransparentFlag = false;
    public static final int LAYER_GRID = 10;
    public static final int LAYER_TIMING_LINE = 20;
    public static final int LAYER_GRAPH = 30;
    public static final int LAYER_SIGNIFICANT_DIFFERENCE = 40;
    public static final int LAYER_AXIS = 50;
    public static final int LAYER_AXIS_BREAK = 60;
    public static final int LAYER_LEGEND = 70;
    public static final int LAYER_STRING = 80;
    protected static final int OTHER = 0;
    protected static final int NORTH = 1;
    protected static final int SOUTH = 2;
    protected static final int WEST = 3;
    protected static final int EAST = 4;
    protected static final int NORTH_WEST = 5;
    protected static final int NORTH_EAST = 6;
    protected static final int SOUTH_WEST = 7;
    protected static final int SOUTH_EAST = 8;
    public static final String NOTIFY_CHANGE = "Notify the change";
    public static final String SET_PROPERTIES_OF_SELECTED_OBJECTS = "Set properties of selected objects";
    public static final String CLEAR_FOCUSED_OBJECTS = "Clear focused objects";
    public static final String NOTIFY_CHANGE_TO_ROOT = "Notify the change to root";
    public static final String NOTIFY_CHANGE_CURSOR = "Notify the change of cursor";
    public static final String MENUCMD_SHOW_BOUNDING_BOX = "Show Bounding Box";
    private SGIFigureElement[] mFigureElementArray;
    private boolean mSelectionSymbolsVisibleFlag = true;
    private boolean mSelectedFlag = false;
    public static final int DRAW_BACK_MARGIN = 2;
    protected boolean mChangedFlag = false;
    public static final String MENUCMD_RUBBER_BANDING = "Rubber Banding";
    public static final String MENUCMD_SAVE_PROPERTY = "Save Property";
    public static final String MENUCMD_PROPERTY = "Property";
    public static final String MENUCMD_GRID_VISIBLE = "Grid Visible";
    public static final String MENUCMD_GRID_PROPERTY = "Grid Property";
    private ArrayList mFigurePropertyHistoryList = new ArrayList();
    private int mFigureStateCounter = 0;
    protected ArrayList mUndoableObjectHistoryList = new ArrayList();
    private int mCurrentStateCounter = 0;
    public static final int MARGIN_TOP = 5;
    public static final int MARGIN_BOTTOM = 5;
    public static final int MARGIN_LEFT = 5;
    public static final int MARGIN_RIGHT = 5;
    public static final String TAG_NAME_FIGURE = "Figure";
    public static final String KEY_FIGURE_TYPE = "Type";
    public static final String KEY_FIGURE_X_IN_CLIENT = "X";
    public static final String KEY_FIGURE_Y_IN_CLIENT = "Y";
    public static final String KEY_FIGURE_WIDTH = "Width";
    public static final String KEY_FIGURE_HEIGHT = "Height";
    public static final String KEY_SPACE_AXIS_LINE_AND_NUMBER = "SpaceAxisLineAndNumber";
    public static final String KEY_SPACE_NUMBER_AND_TITLE = "SpaceNumberAndTitle";
    public static final String KEY_FIGURE_BACKGROUND_COLOR = "BackgroundColor";
    public static final String KEY_FIGURE_BACKGROUND_TRANSPARENT = "BackgroundTransparent";
    private final float DUPLICATION_OFFSET = 20.0f;

    public SGFigure() {
        this.create();
    }

    public SGFigure(SGDrawingWindow sGDrawingWindow) {
        this.setWindow(sGDrawingWindow);
        this.create();
    }

    public String toString() {
        return new String("SGFigure:" + this.getID());
    }

    private boolean create() {
        this.createDialog();
        this.createPopupMenu();
        this.setBackgroundColor(SGDefaultValues.FIGURE_BACKGROUND_COLOR);
        this.setVisible(true);
        this.setOpaque(false);
        return true;
    }

    protected boolean isFocusedFigure() {
        ArrayList arrayList = this.getWindow().getFocusedObjectsList();
        return arrayList.contains(this);
    }

    public int getID() {
        return this.mID;
    }

    public boolean setID(int n) {
        this.mID = n;
        return true;
    }

    public boolean setBackgroundColor(Color color) {
        this.mBackgroundColor = color;
        return true;
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public boolean isTransparent() {
        return this.mTransparentFlag;
    }

    public SGDrawingWindow getWindow() {
        return this.mWnd;
    }

    public float getSpaceAxisLineAndNumber() {
        return this.mAxisElement.getSpaceAxisLineAndNumber();
    }

    public float getSpaceNumberAndTitle() {
        return this.mAxisElement.getSpaceNumberAndTitle();
    }

    public boolean setSpaceAxisLineAndNumber(float f) {
        float f2 = this.mAxisElement.getSpaceAxisLineAndNumber();
        if (f != f2) {
            this.mAxisElement.setSpaceAxisLineAndNumber(f);
            this.mAxisElement.setChanged(true);
            this.updateGraphRect();
        }
        return true;
    }

    public boolean setSpaceNumberAndTitle(float f) {
        float f2 = this.mAxisElement.getSpaceNumberAndTitle();
        if (f != f2) {
            this.mAxisElement.setSpaceNumberAndTitle(f);
            this.mAxisElement.setChanged(true);
            this.updateGraphRect();
        }
        return true;
    }

    public boolean setLegendVisible(boolean bl) {
        boolean bl2 = this.mLegendElement.isLegendVisible();
        if (bl2 != bl) {
            this.mLegendElement.setLegendVisible(bl);
            this.mLegendElement.setChanged(true);
            this.repaint();
        }
        return true;
    }

    public boolean setTransparent(boolean bl) {
        this.mTransparentFlag = bl;
        return true;
    }

    public void setWindow(SGDrawingWindow sGDrawingWindow) {
        this.mWnd = sGDrawingWindow;
    }

    public void setGraphElement(SGIGraphElement sGIGraphElement) {
        this.mGraphElement = sGIGraphElement;
    }

    public void setLegendElement(SGILegendElement sGILegendElement) {
        this.mLegendElement = sGILegendElement;
    }

    public void setStringElement(SGIStringElement sGIStringElement) {
        this.mStringElement = sGIStringElement;
    }

    public void setAxisElement(SGIAxisElement sGIAxisElement) {
        this.mAxisElement = sGIAxisElement;
    }

    public void setAxisBreakElement(SGIAxisBreakElement sGIAxisBreakElement) {
        this.mAxisBreakElement = sGIAxisBreakElement;
    }

    public void setSignificantDifferenceElement(SGISignificantDifferenceElement sGISignificantDifferenceElement) {
        this.mSignificantDifferenceElement = sGISignificantDifferenceElement;
    }

    public void setTimingLineElement(SGITimingLineElement sGITimingLineElement) {
        this.mTimingLineElement = sGITimingLineElement;
    }

    public void setGridElement(SGIGridElement sGIGridElement) {
        this.mGridElement = sGIGridElement;
    }

    public SGIGraphElement getGraphElement() {
        return this.mGraphElement;
    }

    public SGIAxisElement getAxisElement() {
        return this.mAxisElement;
    }

    public SGILegendElement getLegendElement() {
        return this.mLegendElement;
    }

    public SGIStringElement getStringElement() {
        return this.mStringElement;
    }

    public SGIAxisBreakElement getAxisBreakElement() {
        return this.mAxisBreakElement;
    }

    public SGISignificantDifferenceElement getSignigicantDifferenceElement() {
        return this.mSignificantDifferenceElement;
    }

    public SGITimingLineElement getTimingLineElement() {
        return this.mTimingLineElement;
    }

    public SGIGridElement getGridElement() {
        return this.mGridElement;
    }

    public void setFigureElementArray(SGIFigureElement[] sGIFigureElementArray) {
        this.mFigureElementArray = (SGIFigureElement[])sGIFigureElementArray.clone();
    }

    public SGIFigureElement[] getIFigureElementArray() {
        return this.mFigureElementArray;
    }

    public ArrayList getChildNodes() {
        ArrayList<SGIFigureElement> arrayList = new ArrayList<SGIFigureElement>(Arrays.asList(this.getIFigureElementArray()));
        return arrayList;
    }

    public String getClassDescription() {
        return "Figure: " + this.mID;
    }

    public String getInstanceDescription() {
        float f = (float)SGUtilityNumber.roundOffNumber(this.mGraphRectX * 0.035277776f, -2);
        float f2 = (float)SGUtilityNumber.roundOffNumber(this.mGraphRectY * 0.035277776f, -2);
        String string = this.getClassDescription();
        string = string + " ( X=" + f + "cm, Y=" + f2 + "cm )";
        return string;
    }

    public SGIFigureElement[] getIFigureElementArrayFromLayer() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof SGIFigureElement)) continue;
            arrayList.add(componentArray[i]);
        }
        SGIFigureElement[] sGIFigureElementArray = new SGIFigureElement[arrayList.size()];
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i] = (SGIFigureElement)((Object)componentArray[i]);
        }
        return sGIFigureElementArray;
    }

    SGIFigureElement getIFigureElement(SGIFigureElement sGIFigureElement) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (!sGIFigureElementArray[i].getClass().equals(sGIFigureElement.getClass())) continue;
            return sGIFigureElementArray[i];
        }
        return null;
    }

    void clearFocusedObjectsOtherThan(SGIFigureElement sGIFigureElement) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].getClass().equals(sGIFigureElement.getClass())) continue;
            sGIFigureElementArray[i].clearFocusedObjects();
        }
        this.setSelected(false);
    }

    protected Rectangle2D getViewBounds() {
        return this.mViewBounds;
    }

    public boolean isGraphRectContains(Point2D point2D) {
        Rectangle2D rectangle2D = this.getGraphRect();
        return rectangle2D.contains(point2D);
    }

    public boolean isGraphRectContains(int n, int n2) {
        Rectangle2D rectangle2D = this.getGraphRect();
        return rectangle2D.contains(n, n2);
    }

    public Rectangle2D getGraphRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getGraphRectX(), this.getGraphRectY(), this.getGraphRectWidth(), this.getGraphRectHeight());
        return float_;
    }

    public Rectangle2D getGraphRectInClientRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.mGraphRectX, this.mGraphRectY, this.mGraphRectWidth, this.mGraphRectHeight);
        return float_;
    }

    public float getGraphRectX() {
        Rectangle2D rectangle2D = this.mWnd.getPaperRect();
        return (float)rectangle2D.getX() + this.mMagnification * this.mGraphRectX;
    }

    public float getGraphRectY() {
        Rectangle2D rectangle2D = this.mWnd.getPaperRect();
        return (float)rectangle2D.getY() + this.mMagnification * this.mGraphRectY;
    }

    public float getGraphRectWidth() {
        return this.mMagnification * this.mGraphRectWidth;
    }

    public float getGraphRectHeight() {
        return this.mMagnification * this.mGraphRectHeight;
    }

    public float getFigureX() {
        return this.mGraphRectX;
    }

    public float getFigureY() {
        return this.mGraphRectY;
    }

    public float getFigureWidth() {
        return this.mGraphRectWidth;
    }

    public float getFigureHeight() {
        return this.mGraphRectHeight;
    }

    public void setFigureX(float f) {
        if (this.equalLength(this.mGraphRectX, f)) {
            return;
        }
        this.mGraphRectX = f;
        this.updateGraphRect();
    }

    public void setFigureY(float f) {
        if (this.equalLength(this.mGraphRectY, f)) {
            return;
        }
        this.mGraphRectY = f;
        this.updateGraphRect();
    }

    public void setFigureWidth(float f) {
        if (this.equalLength(this.mGraphRectWidth, f)) {
            return;
        }
        this.mGraphRectWidth = f;
        this.updateGraphRect();
    }

    public void setFigureHeight(float f) {
        if (this.equalLength(this.mGraphRectHeight, f)) {
            return;
        }
        this.mGraphRectHeight = f;
        this.updateGraphRect();
    }

    private boolean equalLength(float f, float f2) {
        float f3;
        float f4 = Math.abs(f - f2) * 0.035277776f;
        return f4 < (f3 = (float)SGUtilityNumber.getPowersOfTen(-1));
    }

    public boolean setGraphRectLocation(float f, float f2) {
        this.setGraphRectLocation2(f, f2);
        this.updateGraphRect();
        return true;
    }

    private boolean setGraphRectLocation2(float f, float f2) {
        Rectangle2D rectangle2D = this.mWnd.getPaperRect();
        this.mGraphRectX = (f - (float)rectangle2D.getX()) / this.mMagnification;
        this.mGraphRectY = (f2 - (float)rectangle2D.getY()) / this.mMagnification;
        return true;
    }

    protected boolean setGraphRectLocationRoundingOut(float f, float f2) {
        Rectangle2D rectangle2D = this.mWnd.getPaperRect();
        float f3 = (f - (float)rectangle2D.getX()) * 0.035277776f / this.mMagnification;
        float f4 = (f2 - (float)rectangle2D.getY()) * 0.035277776f / this.mMagnification;
        float f5 = (float)SGUtilityNumber.roundOutNumber(f3, -2);
        float f6 = (float)SGUtilityNumber.roundOutNumber(f4, -2);
        float f7 = f5 / 0.035277776f;
        float f8 = f6 / 0.035277776f;
        this.mGraphRectX = f7;
        this.mGraphRectY = f8;
        this.updateGraphRect();
        return true;
    }

    private Rectangle2D getRectangleRoundingOut(Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        return this.getRectangleRoundingOut(f, f2, f3, f4);
    }

    private Rectangle2D getRectangleRoundingOut(float f, float f2, float f3, float f4) {
        Rectangle2D rectangle2D = this.mWnd.getPaperRect();
        float f5 = (f - (float)rectangle2D.getX()) * 0.035277776f / this.mMagnification;
        float f6 = (f2 - (float)rectangle2D.getY()) * 0.035277776f / this.mMagnification;
        float f7 = (float)SGUtilityNumber.roundOutNumber(f5, -2);
        float f8 = (float)SGUtilityNumber.roundOutNumber(f6, -2);
        float f9 = f7 / 0.035277776f;
        float f10 = f8 / 0.035277776f;
        float f11 = f3 * 0.035277776f / this.mMagnification;
        float f12 = f4 * 0.035277776f / this.mMagnification;
        float f13 = (float)SGUtilityNumber.roundOutNumber(f11, -2);
        float f14 = (float)SGUtilityNumber.roundOutNumber(f12, -2);
        float f15 = f13 / 0.035277776f;
        float f16 = f14 / 0.035277776f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f9, f10, f15, f16);
        return float_;
    }

    public boolean setGraphRectSize(float f, float f2) {
        this.setGraphRectSize2(f, f2);
        this.updateGraphRect();
        return true;
    }

    private boolean setGraphRectSize2(float f, float f2) {
        this.mGraphRectWidth = f / this.mMagnification;
        this.mGraphRectHeight = f2 / this.mMagnification;
        return true;
    }

    protected boolean setGraphRectSizeRoundingOut(float f, float f2) {
        float f3 = f * 0.035277776f / this.mMagnification;
        float f4 = f2 * 0.035277776f / this.mMagnification;
        float f5 = (float)SGUtilityNumber.roundOutNumber(f3, -2);
        float f6 = (float)SGUtilityNumber.roundOutNumber(f4, -2);
        float f7 = f5 / 0.035277776f;
        float f8 = f6 / 0.035277776f;
        this.mGraphRectWidth = f7;
        this.mGraphRectHeight = f8;
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        this.setGraphRectLocation2(f, f2);
        this.setGraphRectSize2(f3, f4);
        this.updateGraphRect();
        return true;
    }

    public boolean isLegendVisible() {
        return this.mLegendElement.isLegendVisible();
    }

    public boolean addData(SGData sGData) {
        return this.addData(sGData, "data");
    }

    public boolean addData(SGData sGData, String string) {
        this.mDataList.add(sGData);
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].addData(sGData, string);
        }
        return true;
    }

    public boolean addData(SGData sGData, String string, Map map) {
        SGIFigureElement[] sGIFigureElementArray;
        this.mDataList.add(sGData);
        ArrayList arrayList = this.getVisibleDataList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            sGIFigureElementArray = (SGIFigureElement[])arrayList.get(i);
            String string2 = this.getDataName((SGData)sGIFigureElementArray);
            arrayList2.add(string2);
        }
        String string3 = SGUtilityText.getSerialName(arrayList2, string);
        sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            Object v = map.get(new Integer(i));
            SGProperties sGProperties = (SGProperties)v;
            if (sGIFigureElementArray[i].addData(sGData, string3, sGProperties)) continue;
            return false;
        }
        this.broadcast(this.getGraphElement());
        return true;
    }

    protected boolean setViewBounds() {
        Rectangle2D rectangle2D = this.mWnd.getViewportBounds();
        this.setViewBounds(rectangle2D);
        return true;
    }

    protected boolean setViewBounds(Rectangle2D rectangle2D) {
        this.mViewBounds = rectangle2D;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setViewBounds(rectangle2D);
        }
        return true;
    }

    public boolean setSize(SGTuple2f sGTuple2f) {
        this.setSize((int)sGTuple2f.x, (int)sGTuple2f.y);
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setISize(new SGTuple2f(sGTuple2f));
        }
        return true;
    }

    public boolean resize(float f, float f2) {
        this.mGraphRectX *= f;
        this.mGraphRectY *= f2;
        this.mGraphRectWidth *= f;
        this.mGraphRectHeight *= f2;
        this.updateGraphRect();
        this.setViewBounds();
        return true;
    }

    public boolean zoom(float f) {
        this.mMagnification = f;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].zoom(f);
        }
        this.updateGraphRect();
        return true;
    }

    protected void setSelectionSymbolsVisible(boolean bl) {
        this.mSelectionSymbolsVisibleFlag = bl;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setSymbolsVisibleAroundFocusedObjects(bl);
        }
    }

    protected boolean isSelectionSymbolsVisible() {
        return this.mSelectionSymbolsVisibleFlag;
    }

    private boolean setFitFlag() {
        return true;
    }

    protected boolean onMouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (!this.mWnd.isInsertToggleButtonSelected()) {
            Cursor cursor = this.setMouseCursor(n, n2);
            if (!Cursor.getDefaultCursor().equals(cursor)) {
                return true;
            }
        }
        return false;
    }

    protected boolean onToggleSelected(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = false;
        if (this.mWnd.isInsertLabelButtonSelected()) {
            bl = this.mStringElement.addString(n, n2);
        }
        if (this.mWnd.isInsertTimingLineButtonSelected()) {
            bl = this.mAxisElement.addTimingLine(n, n2);
        }
        if (this.mWnd.isInsertBreakButtonSelected()) {
            bl = this.mAxisBreakElement.addAxisBreakSymbol(n, n2);
        }
        if (this.mWnd.isInsertSignificantDifferenceSymbolButtonSelected()) {
            bl = this.mSignificantDifferenceElement.addSignificantDifferenceSymbol(n, n2);
        }
        return bl;
    }

    protected boolean onMouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getClickCount();
        int n2 = mouseEvent.getModifiers();
        SGIFigureElement sGIFigureElement = this.onFigureElementClicked(mouseEvent);
        if (sGIFigureElement != null) {
            this.mWnd.setFocusedFigure(this, false);
            if ((n2 & 2) == 0 & (n2 & 1) == 0) {
                // empty if block
            }
            this.afterClicked(mouseEvent);
            return true;
        }
        if (this.isGraphRectContains(mouseEvent.getPoint())) {
            this.updateFocusedFigureList(mouseEvent);
            this.afterClicked(mouseEvent);
            this.mWnd.setFocusedFigure(this, true);
            if (SwingUtilities.isRightMouseButton(mouseEvent) & n == 1) {
                this.updatePopupMenu();
                this.mPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent) & n == 2) {
                this.mWnd.showPropertyDialogForSelectedFigures();
            }
            return true;
        }
        return false;
    }

    public boolean isSelected() {
        return this.mSelectedFlag;
    }

    public void setSelected(boolean bl) {
        this.mSelectedFlag = bl;
    }

    public boolean hideSelectedObjects() {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].hideSelectedObjects()) continue;
            return false;
        }
        return true;
    }

    protected void setSymbolsVisibleAroundAllObjects(boolean bl) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setSymbolsVisibleAroundAllObjects(bl);
        }
    }

    protected boolean updatePopupMenu() {
        Component[] componentArray = this.mPopupMenu.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JCheckBoxMenuItem)) continue;
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)componentArray[i];
            String string = jCheckBoxMenuItem.getActionCommand();
            if (string.equals(MENUCMD_RUBBER_BANDING)) {
                jCheckBoxMenuItem.setSelected(mRubberBandFlag);
                continue;
            }
            if (!string.equals(MENUCMD_SHOW_BOUNDING_BOX)) continue;
            jCheckBoxMenuItem.setSelected(mBoundingBoxVisibleFlag);
        }
        return true;
    }

    private boolean afterClicked(MouseEvent mouseEvent) {
        return true;
    }

    private SGIFigureElement onFigureElementClicked(MouseEvent mouseEvent) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArrayFromLayer();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (!sGIFigureElementArray[i].onMouseClicked(mouseEvent)) continue;
            return sGIFigureElementArray[i];
        }
        return null;
    }

    protected boolean onMousePressed(MouseEvent mouseEvent) {
        if (this.isFocusedFigure() && this.pressWithMouseLocation(mouseEvent)) {
            return true;
        }
        if (this.pressFigureElement(mouseEvent)) {
            return true;
        }
        if (this.isGraphRectContains(mouseEvent.getPoint())) {
            return this.pressed(mouseEvent);
        }
        return false;
    }

    private boolean pressFigureElement(MouseEvent mouseEvent) {
        SGIFigureElement sGIFigureElement = this.onFigureElementPressed(mouseEvent);
        if (sGIFigureElement != null) {
            this.afterPressed(mouseEvent);
            return true;
        }
        return false;
    }

    private boolean pressWithMouseLocation(MouseEvent mouseEvent) {
        if (this.mMouseLocation != 0) {
            return this.pressed(mouseEvent);
        }
        return false;
    }

    private boolean pressed(MouseEvent mouseEvent) {
        this.clearFocusedObjects();
        this.afterPressed(mouseEvent);
        return true;
    }

    private boolean afterPressed(MouseEvent mouseEvent) {
        mRubberBandVisibleFlag = true;
        if (this.mPressedElement == null && this.mWnd.getCursor().equals(Cursor.getDefaultCursor())) {
            this.changeCursor();
            if (this.mMouseLocation == 0) {
                this.mWnd.setCursor(new Cursor(13));
            }
        }
        this.mWnd.moveToFront(this);
        this.mPressedPoint.setLocation(mouseEvent.getPoint());
        this.recordFigureRect();
        return true;
    }

    protected boolean updateFocusedFigureList(MouseEvent mouseEvent) {
        SGDrawingWindow sGDrawingWindow = this.getWindow();
        ArrayList arrayList = sGDrawingWindow.getFocusedObjectsList();
        int n = mouseEvent.getModifiers();
        if ((n & 2) == 0 & (n & 1) == 0) {
            if (!arrayList.contains(this)) {
                sGDrawingWindow.clearAllFocusedObjectsInFigures();
                sGDrawingWindow.setFocusedFigure(this, true);
            }
        } else if (arrayList.contains(this)) {
            int n2 = this.mMouseLocation;
            if (n2 != 5 & n2 != 6 & n2 != 8 & n2 != 7 && this.mPressedElement == null) {
                sGDrawingWindow.setFocusedFigure(this, false);
            }
        } else {
            sGDrawingWindow.setFocusedFigure(this, true);
        }
        return true;
    }

    boolean recordFigureRect() {
        this.mTempFigureRect.setRect(this.getGraphRectInClientRect());
        return true;
    }

    private SGIFigureElement onFigureElementPressed(MouseEvent mouseEvent) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArrayFromLayer();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (!sGIFigureElementArray[i].setTemporaryPropertiesOfFocusedObjects()) {
                return null;
            }
            if (!sGIFigureElementArray[i].onMousePressed(mouseEvent)) continue;
            this.mPressedElement = sGIFigureElementArray[i];
            return sGIFigureElementArray[i];
        }
        return null;
    }

    protected boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mWnd.isInsertToggleButtonSelected()) {
            return false;
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            return true;
        }
        if (this.mPressedElement != null) {
            ArrayList arrayList = this.mPressedElement.getFocusedObjectsList();
            if (!this.mPressedElement.onMouseDragged(mouseEvent)) {
                return false;
            }
            if (arrayList.size() != 0) {
                this.mWnd.moveFocusedObjects(mouseEvent.getX(), mouseEvent.getY());
            }
            this.setCursorToWindow(this.mPressedElement);
            return true;
        }
        if (!this.isFocusedFigure()) {
            return true;
        }
        if (this.mMouseLocation == 0) {
            boolean bl = this.dragOtherPoint(mouseEvent);
            return bl;
        }
        Rectangle2D rectangle2D = this.getDraggingRect();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        Point point = new Point(this.mPressedPoint);
        this.recordFigureRect();
        int n = mouseEvent.getX() - point.x;
        int n2 = mouseEvent.getY() - point.y;
        float f5 = f3;
        float f6 = f4;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = f;
        float f10 = f2;
        float f11 = f3;
        float f12 = f4;
        int n3 = this.mMouseLocation;
        if (n3 == 1) {
            point.setLocation(point.getX(), point.getY() + (double)n2);
            f8 = f6 - (float)n2;
            f10 = f2 + f6 - f8;
            f12 = f8;
        } else if (n3 == 2) {
            point.setLocation(point.getX(), point.getY() + (double)n2);
            f12 = f8 = f6 + (float)n2;
        } else if (n3 == 3) {
            point.setLocation(point.getX() + (double)n, point.getY() + (double)n2);
            f7 = f5 - (float)n;
            f9 = f + f5 - f7;
            f11 = f7;
        } else if (n3 == 4) {
            point.setLocation(point.getX() + (double)n, point.getY());
            f11 = f7 = f5 + (float)n;
        } else if (n3 == 5) {
            point.setLocation(point.getX() + (double)n, point.getY() + (double)n2);
            f7 = f5 - (float)n;
            f8 = (mouseEvent.getModifiers() & 1) != 0 ? f7 * (f6 / f5) : f6 - (float)n2;
            f9 = f + f5 - f7;
            f10 = f2 + f6 - f8;
            f11 = f7;
            f12 = f8;
        } else if (n3 == 6 && (mouseEvent.getModifiers() & 1) == 0) {
            point.setLocation(point.getX() + (double)n, point.getY() + (double)n2);
            f7 = f5 + (float)n;
            f8 = f6 - (float)n2;
            f10 = f2 + f6 - f8;
            f11 = f7;
            f12 = f8;
        } else if (n3 == 6 && (mouseEvent.getModifiers() & 1) != 0) {
            point.setLocation(point.getX(), point.getY() + (double)n2);
            f8 = f6 - (float)n2;
            f7 = f8 * (f5 / f6);
            f10 = f2 + f6 - f8;
            f11 = f7;
            f12 = f8;
        } else if (n3 == 7 && (mouseEvent.getModifiers() & 1) == 0) {
            point.setLocation(point.getX() + (double)n, point.getY() + (double)n2);
            f7 = f5 - (float)n;
            f8 = f6 + (float)n2;
            f9 = f + f5 - f7;
            f11 = f7;
            f12 = f8;
        } else if (n3 == 7 && (mouseEvent.getModifiers() & 1) != 0) {
            point.setLocation(point.getX() + (double)n, point.getY() + (double)n2);
            f7 = f5 - (float)n;
            f8 = f7 * (f6 / f5);
            f9 = f + f5 - f7;
            f11 = f7;
            f12 = f8;
        } else if (n3 == 8 && (mouseEvent.getModifiers() & 1) == 0) {
            point.setLocation(point.getX() + (double)n, point.getY() + (double)n2);
            f7 = f5 + (float)n;
            f8 = f6 + (float)n2;
            f11 = f7;
            f12 = f8;
        } else if (n3 == 8 && (mouseEvent.getModifiers() & 1) != 0) {
            point.setLocation(point.getX() + (double)n, point.getY());
            f7 = f5 + (float)n;
            f8 = f7 * (f6 / f5);
            f11 = f7;
            f12 = f8;
        }
        this.mPressedPoint.setLocation(point);
        if (f11 < this.mMinWidth || f12 < this.mMinHeight) {
            return true;
        }
        this.setDraggingRect(f9, f10, f11, f12);
        this.snapToUnitCell(n3);
        if (!mRubberBandFlag) {
            this.setGraphRectOnDragging();
        }
        return true;
    }

    private boolean dragOtherPoint(MouseEvent mouseEvent) {
        if (!this.isSelected()) {
            return false;
        }
        if (this.isGraphRectContains(this.mPressedPoint)) {
            this.mWnd.moveFocusedObjects(mouseEvent.getX(), mouseEvent.getY());
            return true;
        }
        return false;
    }

    public void translate(float f, float f2) {
        Rectangle2D rectangle2D = this.getDraggingRect();
        this.setDraggingRect((float)rectangle2D.getX() + f, (float)rectangle2D.getY() + f2, (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        this.snapToUnitCell(0);
        if (!mRubberBandFlag) {
            this.mPressedPoint.setLocation((float)this.mPressedPoint.x + f, (float)this.mPressedPoint.y + f2);
            this.setGraphRectOnDragging();
        }
    }

    public void translateSelectedObjects(int n, int n2) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].equals(this.mPressedElement)) continue;
            sGIFigureElementArray[i].translateSelectedObjects(n, n2);
        }
    }

    Rectangle2D getRubberBandRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect(this.mRubberBandRect);
        return float_;
    }

    Rectangle2D getDraggingRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect(this.mDraggingRect);
        return float_;
    }

    void setRubberBandRect(float f, float f2, float f3, float f4) {
        this.mRubberBandRect.setRect(f, f2, f3, f4);
    }

    void setDraggingRect(float f, float f2, float f3, float f4) {
        this.mDraggingRect.setRect(f, f2, f3, f4);
    }

    protected boolean setGraphRectOnDragging() {
        Rectangle2D rectangle2D = this.getRubberBandRect();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        this.setGraphRectLocation(f, f2);
        this.setGraphRectSize(f3, f4);
        this.updateGraphRect();
        return true;
    }

    private float roundOffInFigureLengthOrder(float f) {
        float f2 = f * 0.035277776f;
        float f3 = (float)SGUtilityNumber.roundOffNumber(f2, -2);
        float f4 = f3 / 0.035277776f;
        return f4;
    }

    void snapToLines() {
        Rectangle2D rectangle2D = this.getGraphRect();
        this.setDraggingRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        if (this.mSnapToGridFlag) {
            this.snapToGrid(0);
        } else {
            this.snapToUnitCell(0);
        }
        this.setGraphRectOnDragging();
    }

    private void snapToUnitCell(int n) {
        float f = (float)SGUtilityNumber.getPowersOfTen(-1);
        float f2 = this.mMagnification * f / 0.035277776f;
        this.snap(f2, n);
    }

    private void snapToGrid(int n) {
        float f = this.mMagnification * this.mWnd.getGridLineInterval();
        this.snap(f, n);
    }

    private void snap(float f, int n) {
        float f2 = this.mWnd.getPaperX();
        float f3 = this.mWnd.getPaperY();
        Rectangle2D rectangle2D = this.getDraggingRect();
        float f4 = (float)rectangle2D.getMinX();
        float f5 = (float)rectangle2D.getMaxX();
        float f6 = (float)rectangle2D.getMinY();
        float f7 = (float)rectangle2D.getMaxY();
        float f8 = f4;
        float f9 = f7;
        float f10 = f8 - f2;
        float f11 = f9 - f3;
        int n2 = (int)(f10 / f);
        int n3 = (int)(f11 / f);
        float f12 = f * (float)n2;
        float f13 = f * (float)n3;
        int n4 = n2;
        int n5 = n3;
        if (f10 - f12 > f / 2.0f) {
            ++n4;
        }
        if (f11 - f13 > f / 2.0f) {
            ++n5;
        }
        float f14 = (float)n4 * f;
        float f15 = (float)n5 * f;
        float f16 = n == 3 | n == 7 | n == 5 ? f5 - f14 : (float)rectangle2D.getWidth();
        float f17 = n == 2 | n == 7 | n == 8 ? f15 - f6 : (float)rectangle2D.getHeight();
        float f18 = f14 + f2;
        float f19 = f15 + f3 - f17;
        this.setRubberBandRect(f18, f19, f16, f17);
    }

    protected boolean onMouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (!this.mWnd.isInsertToggleButtonSelected()) {
            this.setMouseCursor(n, n2);
        }
        if (mRubberBandFlag) {
            this.setGraphRectOnDragging();
        }
        mRubberBandVisibleFlag = false;
        if (this.mPressedElement != null) {
            this.mPressedElement.onMouseReleased(mouseEvent);
        }
        this.mPressedElement = null;
        return true;
    }

    protected boolean isFigureMoved() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.mTempFigureRect.getBounds();
        boolean bl = !rectangle2.equals(rectangle = this.getGraphRectInClientRect().getBounds());
        return bl;
    }

    boolean drawbackFigure() {
        Rectangle2D rectangle2D = this.mWnd.getClientRect();
        Rectangle2D rectangle2D2 = this.getBoundingBox();
        Rectangle2D rectangle2D3 = this.mWnd.getPaperRect();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect(rectangle2D2);
        if (rectangle2D2.getX() < rectangle2D.getX()) {
            ((Rectangle2D)float_).setRect(2.0, ((RectangularShape)float_).getY() + 2.0, ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (rectangle2D2.getY() < rectangle2D.getY()) {
            ((Rectangle2D)float_).setRect(((RectangularShape)float_).getX() + 2.0, 2.0, ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (rectangle2D2.getX() + rectangle2D2.getWidth() > rectangle2D3.getX() + rectangle2D3.getWidth()) {
            ((Rectangle2D)float_).setRect(rectangle2D3.getX() + rectangle2D3.getWidth() - rectangle2D2.getWidth() - 2.0, ((RectangularShape)float_).getY() + 2.0, ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (rectangle2D2.getY() + rectangle2D2.getHeight() > rectangle2D3.getY() + rectangle2D3.getHeight()) {
            ((Rectangle2D)float_).setRect(((RectangularShape)float_).getX() + 2.0, rectangle2D3.getY() + rectangle2D3.getHeight() - rectangle2D2.getHeight() - 2.0, ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (!this.setBoundingBox(float_)) {
            return false;
        }
        this.snapToLines();
        return true;
    }

    public boolean clearFocusedObjects() {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].clearFocusedObjects()) continue;
            return false;
        }
        return true;
    }

    public boolean undo() {
        --this.mFigureStateCounter;
        FigureProperties figureProperties = (FigureProperties)this.mFigurePropertyHistoryList.get(this.mFigureStateCounter);
        this.setProperties(figureProperties);
        this.updateGraphRect();
        return true;
    }

    public boolean redo() {
        ++this.mFigureStateCounter;
        FigureProperties figureProperties = (FigureProperties)this.mFigurePropertyHistoryList.get(this.mFigureStateCounter);
        this.setProperties(figureProperties);
        this.updateGraphRect();
        return true;
    }

    void updateGraphRect() {
        float f = this.getGraphRectX();
        float f2 = this.getGraphRectY();
        float f3 = this.getGraphRectWidth();
        float f4 = this.getGraphRectHeight();
        this.setRubberBandRect(f, f2, f3, f4);
        this.setDraggingRect(f, f2, f3, f4);
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        if (sGIFigureElementArray != null) {
            for (int i = 0; i < sGIFigureElementArray.length; ++i) {
                sGIFigureElementArray[i].setGraphRect(f, f2, f3, f4);
            }
        }
    }

    public void notifyToRoot() {
        this.mWnd.notifyToRoot();
    }

    public boolean isChanged() {
        if (this.mChangedFlag) {
            return true;
        }
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (!sGIFigureElementArray[i].isChanged()) continue;
            return true;
        }
        return false;
    }

    public void setChanged(boolean bl) {
        this.mChangedFlag = bl;
    }

    private Cursor setMouseCursor(int n, int n2) {
        this.setMouseLocation(n, n2);
        if (this.mMouseLocation == 0) {
            if (!this.onDrawingElement(n, n2)) {
                return this.setMouseCursor();
            }
        } else {
            return this.setMouseCursor();
        }
        return null;
    }

    private Cursor setMouseCursor() {
        if (!this.isSelected()) {
            Cursor cursor = Cursor.getDefaultCursor();
            this.setMouseCursor(cursor);
            return cursor;
        }
        return this.changeCursor();
    }

    private void setMouseLocation(int n, int n2) {
        float f = 1.5f * SGDrawingWindow.getAnchorSize();
        Rectangle2D rectangle2D = this.getGraphRect();
        if (Math.abs((double)n - rectangle2D.getX()) < (double)f && Math.abs((double)n2 - rectangle2D.getY()) < (double)f) {
            this.mMouseLocation = 5;
            return;
        }
        if (Math.abs((double)n - (rectangle2D.getX() + rectangle2D.getWidth())) < (double)f && Math.abs((double)n2 - (rectangle2D.getY() + rectangle2D.getHeight())) < (double)f) {
            this.mMouseLocation = 8;
            return;
        }
        if (Math.abs((double)n - (rectangle2D.getX() + rectangle2D.getWidth())) < (double)f && Math.abs((double)n2 - rectangle2D.getY()) < (double)f) {
            this.mMouseLocation = 6;
            return;
        }
        if (Math.abs((double)n - rectangle2D.getX()) < (double)f && Math.abs((double)n2 - (rectangle2D.getY() + rectangle2D.getHeight())) < (double)f) {
            this.mMouseLocation = 7;
            return;
        }
        if (Math.abs((double)n - rectangle2D.getX()) < (double)f && Math.abs((double)n2 - (rectangle2D.getY() + rectangle2D.getHeight() / 2.0)) < (double)f) {
            this.mMouseLocation = 3;
            return;
        }
        if (Math.abs((double)n - (rectangle2D.getX() + rectangle2D.getWidth())) < (double)f && Math.abs((double)n2 - (rectangle2D.getY() + rectangle2D.getHeight() / 2.0)) < (double)f) {
            this.mMouseLocation = 4;
            return;
        }
        if (Math.abs((double)n2 - rectangle2D.getY()) < (double)f && Math.abs((double)n - (rectangle2D.getX() + rectangle2D.getWidth() / 2.0)) < (double)f) {
            this.mMouseLocation = 1;
            return;
        }
        if (Math.abs((double)n2 - (rectangle2D.getY() + rectangle2D.getHeight())) < (double)f && Math.abs((double)n - (rectangle2D.getX() + rectangle2D.getWidth() / 2.0)) < (double)f) {
            this.mMouseLocation = 2;
            return;
        }
        this.mMouseLocation = 0;
    }

    private Cursor changeCursor() {
        Cursor cursor = null;
        switch (this.mMouseLocation) {
            case 3: {
                cursor = new Cursor(10);
                break;
            }
            case 4: {
                cursor = new Cursor(11);
                break;
            }
            case 1: {
                cursor = new Cursor(8);
                break;
            }
            case 2: {
                cursor = new Cursor(9);
                break;
            }
            case 5: {
                cursor = new Cursor(6);
                break;
            }
            case 8: {
                cursor = new Cursor(5);
                break;
            }
            case 6: {
                cursor = new Cursor(7);
                break;
            }
            case 7: {
                cursor = new Cursor(4);
                break;
            }
            default: {
                cursor = Cursor.getDefaultCursor();
            }
        }
        this.setMouseCursor(cursor);
        return cursor;
    }

    private void setMouseCursor(Cursor cursor) {
        this.getWindow().setCursor(cursor);
    }

    private boolean onDrawingElement(int n, int n2) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArrayFromLayer();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (!sGIFigureElementArray[i].onDrawingElement(n, n2)) continue;
            this.setCursorToWindow(sGIFigureElementArray[i]);
            return true;
        }
        this.mWnd.setCursor(Cursor.getDefaultCursor());
        return false;
    }

    protected boolean setCursorToWindow(SGIFigureElement sGIFigureElement) {
        Cursor cursor = sGIFigureElement.getFigureElementCursor();
        if (cursor != null) {
            this.mWnd.setCursor(cursor);
        }
        return true;
    }

    private boolean createPopupMenu() {
        JPopupMenu jPopupMenu = this.mPopupMenu;
        jPopupMenu.setBounds(0, 0, 100, 100);
        jPopupMenu.add(new JLabel("  -- Figure --"));
        jPopupMenu.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = SGUtility.addCheckBoxItem(jPopupMenu, this, MENUCMD_RUBBER_BANDING);
        jCheckBoxMenuItem.setSelected(mRubberBandFlag);
        jCheckBoxMenuItem = SGUtility.addCheckBoxItem(jPopupMenu, this, MENUCMD_SHOW_BOUNDING_BOX);
        jCheckBoxMenuItem.setSelected(mBoundingBoxVisibleFlag);
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, MENUCMD_SAVE_PROPERTY);
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Cut");
        SGUtility.addItem(jPopupMenu, this, "Copy");
        SGUtility.addItem(jPopupMenu, this, "Paste");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Delete");
        SGUtility.addItem(jPopupMenu, this, "Duplicate");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, MENUCMD_PROPERTY);
        return true;
    }

    public boolean prepare() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    protected abstract boolean createDialog();

    public SGProperties getProperties() {
        FigureProperties figureProperties = new FigureProperties();
        this.getProperties(figureProperties);
        return figureProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof FigureProperties)) {
            return false;
        }
        FigureProperties figureProperties = (FigureProperties)sGProperties;
        figureProperties.setX(this.mGraphRectX);
        figureProperties.setY(this.mGraphRectY);
        figureProperties.setWidth(this.mGraphRectWidth);
        figureProperties.setHeight(this.mGraphRectHeight);
        figureProperties.setSpaceLineAndNumber(this.mAxisElement.getSpaceAxisLineAndNumber());
        figureProperties.setSpaceNumberAndTitle(this.mAxisElement.getSpaceNumberAndTitle());
        figureProperties.setBackgroundColor(this.mBackgroundColor);
        figureProperties.setTransparent(this.mTransparentFlag);
        figureProperties.setLegendVisible(this.mLegendElement.isLegendVisible());
        return true;
    }

    public SGPropertyDialog getPropertyDialog() {
        return this.mDialog;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (string.equals(MENUCMD_SHOW_BOUNDING_BOX)) {
            mBoundingBoxVisibleFlag = !mBoundingBoxVisibleFlag;
            this.updatePopupMenu();
            this.repaint();
            return;
        }
        if (string.equals(MENUCMD_RUBBER_BANDING)) {
            mRubberBandFlag = !mRubberBandFlag;
            this.updatePopupMenu();
            this.repaint();
            return;
        }
        if (string.equals(MENUCMD_SAVE_PROPERTY)) {
            this.mWnd.createPropertyFileFromFocusedFigures();
        } else if (string.equals(MENUCMD_PROPERTY)) {
            this.mWnd.showPropertyDialogForSelectedFigures();
        } else if (string.equals("Move to Front")) {
            this.mWnd.moveFocusedObjectsToFront();
        } else if (string.equals("Move to Back")) {
            this.mWnd.moveFocusedObjectsToBack();
        } else {
            if (string.equals(MENUCMD_GRID_VISIBLE)) {
                boolean bl = this.mGridElement.isGridVisible();
                this.mGridElement.setGridVisible(!bl);
                this.mGridElement.setChanged(true);
                this.updatePopupMenu();
                this.repaint();
                this.notifyToRoot();
                return;
            }
            if (string.equals("Cut")) {
                this.mWnd.cutFocusedObjects();
            } else if (string.equals("Copy")) {
                this.mWnd.copyFocusedObjects();
            } else if (string.equals("Paste")) {
                this.mWnd.pasteCopiedObjects();
            } else if (string.equals("Delete")) {
                this.mWnd.deleteFocusedObjects();
            } else if (string.equals("Duplicate")) {
                this.mWnd.duplicateFocusedObjects();
            }
        }
        if (object instanceof SGIFigureElement) {
            SGIFigureElement sGIFigureElement = (SGIFigureElement)actionEvent.getSource();
            if (string.equals(NOTIFY_CHANGE)) {
                this.broadcast(sGIFigureElement);
            } else if (string.equals(SET_PROPERTIES_OF_SELECTED_OBJECTS)) {
                this.mWnd.showPropertyDialogForSelectedObjects(this, sGIFigureElement);
            } else if (string.equals(CLEAR_FOCUSED_OBJECTS)) {
                this.mWnd.clearAllFocusedObjectsInFigures();
            } else if (string.equals(NOTIFY_CHANGE_TO_ROOT)) {
                this.notifyToRoot();
            } else if (string.equals(NOTIFY_CHANGE_CURSOR)) {
                this.setCursorToWindow(sGIFigureElement);
            }
        }
        this.repaint();
    }

    private boolean mergeData(SGIFigureElement sGIFigureElement) {
        SGData sGData;
        int n;
        ArrayList arrayList = sGIFigureElement.getDataList();
        ArrayList<SGData> arrayList2 = new ArrayList<SGData>();
        for (n = 0; n < this.mDataList.size(); ++n) {
            sGData = (SGData)this.mDataList.get(n);
            if (arrayList.contains(sGData)) continue;
            arrayList2.add(sGData);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            sGData = (SGData)arrayList2.get(n);
            this.removeData(sGData);
        }
        return true;
    }

    public boolean initPropertiesHistory() {
        this.addFigurePropertyHistory((FigureProperties)this.getProperties());
        return true;
    }

    private boolean addFigurePropertyHistory(FigureProperties figureProperties) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.mFigureStateCounter; ++i) {
            arrayList.add(this.mFigurePropertyHistoryList.get(i));
        }
        arrayList.add(figureProperties);
        this.mFigurePropertyHistoryList = arrayList;
        return true;
    }

    public boolean onUndo() {
        if (this.mCurrentStateCounter == 0) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter - 1);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this) ? this.undo() : sGIUndoable.onUndo();
            if (bl) continue;
            return false;
        }
        --this.mCurrentStateCounter;
        return true;
    }

    public boolean onRedo() {
        if (this.mCurrentStateCounter == this.mUndoableObjectHistoryList.size()) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this) ? this.redo() : sGIUndoable.onRedo();
            if (bl) continue;
            return false;
        }
        ++this.mCurrentStateCounter;
        return true;
    }

    public boolean commit() {
        this.repaint();
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.mChangedFlag = true;
        }
        this.mTemporaryProperties = null;
        return true;
    }

    public boolean preview() {
        this.updateGraphRect();
        this.repaint();
        return true;
    }

    public boolean cancel() {
        this.setProperties(this.mTemporaryProperties);
        this.updateGraphRect();
        this.repaint();
        this.mTemporaryProperties = null;
        return true;
    }

    public boolean updateHistory() {
        ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
        if (this.mChangedFlag) {
            this.updateThisObjectHistory();
            arrayList.add(this);
            this.setChanged(false);
        }
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            SGIFigureElement sGIFigureElement = sGIFigureElementArray[i];
            if (!sGIFigureElement.isChanged()) continue;
            sGIFigureElement.updateHistory();
            arrayList.add(sGIFigureElement);
            if (!sGIFigureElement.equals(this.mLegendElement) || arrayList.contains(this)) continue;
            this.updateThisObjectHistory();
            arrayList.add(this);
            this.setChanged(false);
        }
        if (arrayList.size() != 0) {
            this.updateObjectHistory(arrayList);
        }
        return true;
    }

    public boolean updateThisObjectHistory() {
        ++this.mFigureStateCounter;
        this.addFigurePropertyHistory((FigureProperties)this.getProperties());
        return true;
    }

    public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
        ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
        arrayList.add(sGIUndoable);
        boolean bl = this.updateObjectHistory(arrayList);
        return bl;
    }

    public boolean updateObjectHistory(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < this.mCurrentStateCounter; ++i) {
            Object e = this.mUndoableObjectHistoryList.get(i);
            arrayList2.add(e);
        }
        arrayList2.add(new ArrayList(arrayList));
        this.mUndoableObjectHistoryList = arrayList2;
        ++this.mCurrentStateCounter;
        return true;
    }

    public boolean initGraphAreaLocation() {
        SGTuple2f sGTuple2f = new SGTuple2f();
        SGTuple2f sGTuple2f2 = new SGTuple2f();
        if (!this.calcMargin(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        float f3 = sGTuple2f2.x;
        float f4 = sGTuple2f2.y;
        this.mGraphRectX = f3;
        this.mGraphRectY = f;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setGraphRectLocation(this.mGraphRectX, this.mGraphRectY);
            sGIFigureElementArray[i].setGraphRectSize(this.mGraphRectWidth, this.mGraphRectHeight);
        }
        return true;
    }

    public boolean calcMargin(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[sGIFigureElementArray.length];
        SGTuple2f[] sGTuple2fArray2 = new SGTuple2f[sGIFigureElementArray.length];
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGTuple2fArray[i] = new SGTuple2f();
            sGTuple2fArray2[i] = new SGTuple2f();
            boolean bl = sGIFigureElementArray[i].getMarginAroundGraphRect(sGTuple2fArray[i], sGTuple2fArray2[i]);
            if (bl) continue;
            return false;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            float f5 = sGTuple2fArray[i].x;
            float f6 = sGTuple2fArray[i].y;
            float f7 = sGTuple2fArray2[i].x;
            float f8 = sGTuple2fArray2[i].y;
            if (f5 > f) {
                f = f5;
            }
            if (f6 > f2) {
                f2 = f6;
            }
            if (f7 > f3) {
                f3 = f7;
            }
            if (!(f8 > f4)) continue;
            f4 = f8;
        }
        float f9 = this.mMagnification;
        sGTuple2f.x = f + f9 * 5.0f;
        sGTuple2f.y = f2 + f9 * 5.0f;
        sGTuple2f2.x = f3 + f9 * 5.0f;
        sGTuple2f2.y = f4 + f9 * 5.0f;
        return true;
    }

    public Rectangle2D getBoundingBox() {
        Rectangle2D rectangle2D = this.getGraphRect();
        SGTuple2f sGTuple2f = new SGTuple2f();
        SGTuple2f sGTuple2f2 = new SGTuple2f();
        if (!this.calcMargin(sGTuple2f, sGTuple2f2)) {
            return null;
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)rectangle2D.getX() - sGTuple2f2.x, (float)rectangle2D.getY() - sGTuple2f.x, (float)rectangle2D.getWidth() + sGTuple2f2.x + sGTuple2f2.y, (float)rectangle2D.getHeight() + sGTuple2f.x + sGTuple2f.y);
        return float_;
    }

    public boolean setBoundingBox(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return false;
        }
        SGTuple2f sGTuple2f = new SGTuple2f();
        SGTuple2f sGTuple2f2 = new SGTuple2f();
        if (!this.calcMargin(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        float f = (float)rectangle2D.getX() + sGTuple2f2.x;
        float f2 = (float)rectangle2D.getY() + sGTuple2f.x;
        float f3 = (float)rectangle2D.getWidth() - (sGTuple2f2.x + sGTuple2f2.y);
        float f4 = (float)rectangle2D.getHeight() - (sGTuple2f.x + sGTuple2f.y);
        this.setGraphRect(f, f2, f3, f4);
        return true;
    }

    public boolean setCenter(float f, float f2) {
        float f3;
        float f4;
        Rectangle2D rectangle2D = this.getBoundingBox();
        float f5 = (float)rectangle2D.getWidth();
        float f6 = f - f5 / 2.0f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f6, f4 = f2 - (f3 = (float)rectangle2D.getHeight()) / 2.0f, f5, f3);
        return this.setBoundingBox(float_);
    }

    public boolean setGraphRectLocationByLeftBottom(float f, float f2) {
        Rectangle2D rectangle2D = this.getGraphRect();
        this.setGraphRectLocation(f, f2 - (float)rectangle2D.getHeight());
        return true;
    }

    private boolean broadcast(SGIFigureElement sGIFigureElement) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].synchronize(sGIFigureElement);
        }
        return true;
    }

    public boolean removeData(SGData sGData) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = this.mDataList.size() - 1; i >= 0; --i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            this.mDataList.remove(i);
            for (int j = 0; j < sGIFigureElementArray.length; ++j) {
                sGIFigureElementArray[j].removeData(sGData);
            }
            return true;
        }
        return true;
    }

    public ArrayList getDataList() {
        return new ArrayList(this.mDataList);
    }

    public ArrayList getVisibleDataList() {
        return this.mGraphElement.getVisibleDataList();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintGraphics(graphics, true);
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        Rectangle2D rectangle2D;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!this.mTransparentFlag) {
            rectangle2D = this.getGraphRect();
            graphics2D.setPaint(this.mBackgroundColor);
            graphics2D.fill(rectangle2D);
        }
        if (mBoundingBoxVisibleFlag & this.mSelectionSymbolsVisibleFlag && (rectangle2D = this.getBoundingBox()) != null) {
            graphics2D.setPaint(Color.BLUE);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(rectangle2D);
        }
    }

    public Element createElement(Document document) {
        Element element = document.createElement(TAG_NAME_FIGURE);
        if (!this.writeProperty(element)) {
            return null;
        }
        if (!this.createElementLower(document, element)) {
            return null;
        }
        return element;
    }

    public Element createElementForFocusedInBoundingBox(Document document) {
        Element element = document.createElement(TAG_NAME_FIGURE);
        if (!this.writePropertyOnFocusedInBoundingBox(element)) {
            return null;
        }
        if (!this.createElementLower(document, element)) {
            return null;
        }
        return element;
    }

    public Element createElementForFocusedForDuplication(Document document) {
        Element element = document.createElement(TAG_NAME_FIGURE);
        if (!this.writePropertyForDuplication(element)) {
            return null;
        }
        if (!this.createElementLower(document, element)) {
            return null;
        }
        return element;
    }

    private boolean createElementLower(Document document, Element element) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            Element element2 = sGIFigureElementArray[i].createElement(document);
            if (sGIFigureElementArray[i] instanceof SGIGraphElement) continue;
            if (element2 == null) {
                return false;
            }
            element.appendChild(element2);
        }
        ArrayList arrayList = new ArrayList();
        if (!this.mGraphElement.createElementOfData(document, arrayList)) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Element element3 = (Element)arrayList.get(i);
            element.appendChild(element3);
        }
        return true;
    }

    public boolean writeProperty(Element element) {
        float f = this.mGraphRectX;
        float f2 = this.mGraphRectY;
        return this.writeProperty_(element, f, f2);
    }

    public boolean writePropertyOnFocusedInBoundingBox(Element element) {
        SGDrawingWindow sGDrawingWindow = this.getWindow();
        Rectangle2D rectangle2D = sGDrawingWindow.getBoundingBoxOfFigures(sGDrawingWindow.getFocusedObjectsList());
        float f = this.mGraphRectX - (float)rectangle2D.getX() / this.mMagnification;
        float f2 = this.mGraphRectY - (float)rectangle2D.getY() / this.mMagnification;
        return this.writeProperty_(element, f, f2);
    }

    public boolean writePropertyForDuplication(Element element) {
        float f = 20.0f * this.mMagnification;
        float f2 = this.mGraphRectX + f;
        float f3 = this.mGraphRectY + f;
        return this.writeProperty_(element, f2, f3);
    }

    public abstract String getClassType();

    private boolean writeProperty_(Element element, float f, float f2) {
        element.setAttribute(KEY_FIGURE_TYPE, this.getClassType());
        float f3 = (float)SGUtilityNumber.roundOffNumber(f * 0.035277776f, -2);
        float f4 = (float)SGUtilityNumber.roundOffNumber(f2 * 0.035277776f, -2);
        element.setAttribute(KEY_FIGURE_X_IN_CLIENT, Float.toString(f3) + "cm");
        element.setAttribute(KEY_FIGURE_Y_IN_CLIENT, Float.toString(f4) + "cm");
        float f5 = (float)SGUtilityNumber.roundOffNumber(this.mGraphRectWidth * 0.035277776f, -2);
        float f6 = (float)SGUtilityNumber.roundOffNumber(this.mGraphRectHeight * 0.035277776f, -2);
        element.setAttribute(KEY_FIGURE_WIDTH, Float.toString(f5) + "cm");
        element.setAttribute(KEY_FIGURE_HEIGHT, Float.toString(f6) + "cm");
        element.setAttribute(KEY_SPACE_AXIS_LINE_AND_NUMBER, Float.toString(this.getSpaceAxisLineAndNumber() * 0.035277776f) + "cm");
        element.setAttribute(KEY_SPACE_NUMBER_AND_TITLE, Float.toString(this.getSpaceNumberAndTitle() * 0.035277776f) + "cm");
        element.setAttribute(KEY_FIGURE_BACKGROUND_COLOR, SGUtilityText.getColorString(this.mBackgroundColor));
        element.setAttribute(KEY_FIGURE_BACKGROUND_TRANSPARENT, Boolean.toString(this.mTransparentFlag));
        return true;
    }

    public boolean createDataObjectFromPropertyFile(Element element, SGData sGData) {
        this.mDataList.add(sGData);
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].createDataObject(element, sGData)) continue;
            return false;
        }
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof FigureProperties)) {
            return false;
        }
        FigureProperties figureProperties = (FigureProperties)sGProperties;
        this.mGraphRectX = figureProperties.mX;
        this.mGraphRectY = figureProperties.mY;
        this.mGraphRectWidth = figureProperties.mWidth;
        this.mGraphRectHeight = figureProperties.mHeight;
        this.setBackgroundColor(figureProperties.mBackgroundColor);
        this.setTransparent(figureProperties.mTransparentFlag);
        this.setSpaceAxisLineAndNumber(figureProperties.mSpaceLineAndNumber);
        this.setSpaceNumberAndTitle(figureProperties.mSpaceNumberAndTitle);
        this.setLegendVisible(figureProperties.mLegendVisibleFlag);
        return true;
    }

    protected boolean duplicateFocusedObjects() {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].duplicateFocusedObjects()) continue;
            return false;
        }
        return true;
    }

    protected ArrayList createCopiedObjects() {
        ArrayList arrayList = new ArrayList();
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            arrayList.addAll(sGIFigureElementArray[i].getCopiedObjectsList());
        }
        return arrayList;
    }

    protected ArrayList cutFocusedObjects() {
        ArrayList arrayList = new ArrayList();
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            arrayList.addAll(sGIFigureElementArray[i].cutFocusedObjects());
        }
        return arrayList;
    }

    boolean createCopiedDataObjects(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        ArrayList arrayList4 = this.mGraphElement.getFocusedDataList();
        for (int i = 0; i < arrayList4.size(); ++i) {
            SGData sGData = (SGData)arrayList4.get(i);
            arrayList.add(sGData);
            String string = this.getDataName(sGData);
            arrayList2.add(string);
            Map map = this.getDataPropertiesMap(sGData);
            arrayList3.add(map);
        }
        return true;
    }

    boolean cutFocusedDataObjects(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        ArrayList arrayList4 = this.mGraphElement.cutFocusedData();
        for (int i = 0; i < arrayList4.size(); ++i) {
            SGData sGData = (SGData)arrayList4.get(i);
            arrayList.add(sGData);
            String string = this.getDataName(sGData);
            arrayList2.add(string);
            Map map = this.getDataPropertiesMap(sGData);
            arrayList3.add(map);
        }
        return true;
    }

    public String getDataName(SGData sGData) {
        return this.mGraphElement.getDataName(sGData);
    }

    public boolean setDataName(String string, SGData sGData) {
        return this.mGraphElement.setDataName(string, sGData);
    }

    public Map getDataPropertiesMap(SGData sGData) {
        TreeMap<Integer, SGProperties> treeMap = new TreeMap<Integer, SGProperties>();
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            SGProperties sGProperties = sGIFigureElementArray[i].getDataProperties(sGData);
            treeMap.put(new Integer(i), sGProperties);
        }
        return treeMap;
    }

    public boolean paste(ArrayList arrayList) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].paste(arrayList)) continue;
            return false;
        }
        return true;
    }

    public boolean moveFocusedObjects(boolean bl) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].moveFocusedObjects(bl)) continue;
            return false;
        }
        return true;
    }

    public static class FigureProperties
    extends SGProperties {
        private float mX;
        private float mY;
        private float mWidth;
        private float mHeight;
        private float mSpaceLineAndNumber;
        private float mSpaceNumberAndTitle;
        private Color mBackgroundColor;
        private boolean mTransparentFlag;
        private boolean mLegendVisibleFlag;

        public boolean equals(Object object) {
            if (!(object instanceof FigureProperties)) {
                return false;
            }
            FigureProperties figureProperties = (FigureProperties)object;
            if (figureProperties.mX != this.mX) {
                return false;
            }
            if (figureProperties.mY != this.mY) {
                return false;
            }
            if (figureProperties.mWidth != this.mWidth) {
                return false;
            }
            if (figureProperties.mHeight != this.mHeight) {
                return false;
            }
            if (figureProperties.mSpaceLineAndNumber != this.mSpaceLineAndNumber) {
                return false;
            }
            if (figureProperties.mSpaceNumberAndTitle != this.mSpaceNumberAndTitle) {
                return false;
            }
            if (!figureProperties.mBackgroundColor.equals(this.mBackgroundColor)) {
                return false;
            }
            if (figureProperties.mTransparentFlag != this.mTransparentFlag) {
                return false;
            }
            return figureProperties.mLegendVisibleFlag == this.mLegendVisibleFlag;
        }

        public void setX(float f) {
            this.mX = f;
        }

        public void setY(float f) {
            this.mY = f;
        }

        public void setWidth(float f) {
            this.mWidth = f;
        }

        public void setHeight(float f) {
            this.mHeight = f;
        }

        public void setSpaceLineAndNumber(float f) {
            this.mSpaceLineAndNumber = f;
        }

        public void setSpaceNumberAndTitle(float f) {
            this.mSpaceNumberAndTitle = f;
        }

        public void setBackgroundColor(Color color) {
            this.mBackgroundColor = color;
        }

        public void setTransparent(boolean bl) {
            this.mTransparentFlag = bl;
        }

        public void setLegendVisible(boolean bl) {
            this.mLegendVisibleFlag = bl;
        }

        public float getX() {
            return this.mX;
        }

        public float getY() {
            return this.mY;
        }

        public float getWidth() {
            return this.mWidth;
        }

        public float getHeight() {
            return this.mHeight;
        }

        public float getSpaceLineAndNumber() {
            return this.mSpaceLineAndNumber;
        }

        public float getSpaceNumberAndTitle() {
            return this.mSpaceNumberAndTitle;
        }

        public Color getBackgroundColor() {
            return this.mBackgroundColor;
        }

        public boolean isTransparent() {
            return this.mTransparentFlag;
        }

        public boolean isLegendVisible() {
            return this.mLegendVisibleFlag;
        }
    }
}

