/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;

public class SGUtilityJava2D
implements SGILineConstants {
    public static Rectangle2D getBoundingBox(ArrayList arrayList) {
        ArrayList<Rectangle2D> arrayList2 = new ArrayList<Rectangle2D>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (e == null) {
                throw new NullPointerException("obj==null");
            }
            if (!(e instanceof SGIDrawingElementJava2D)) {
                throw new IllegalArgumentException("!(obj instanceof SGIDrawingElementJava2D)");
            }
            SGIDrawingElementJava2D sGIDrawingElementJava2D = (SGIDrawingElementJava2D)e;
            arrayList2.add(sGIDrawingElementJava2D.getElementBounds());
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList2);
        return rectangle2D;
    }

    public static ArrayList getSegmentList(PathIterator pathIterator) {
        ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
        while (!pathIterator.isDone()) {
            float[] fArray = new float[6];
            int n = pathIterator.currentSegment(fArray);
            if (n == 0 || n == 1) {
                arrayList.add(new Point2D.Float(fArray[0], fArray[1]));
            } else if (n == 2) {
                arrayList.add(new Point2D.Float(fArray[0], fArray[1]));
                arrayList.add(new Point2D.Float(fArray[2], fArray[3]));
            } else if (n == 3) {
                arrayList.add(new Point2D.Float(fArray[0], fArray[1]));
                arrayList.add(new Point2D.Float(fArray[2], fArray[3]));
                arrayList.add(new Point2D.Float(fArray[4], fArray[5]));
            }
            pathIterator.next();
        }
        return arrayList;
    }

    public static void drawCircle(Point2D point2D, float f, float f2, Color color, Color color2, Graphics2D graphics2D) {
        float f3 = (float)point2D.getX();
        float f4 = (float)point2D.getY();
        Ellipse2D.Float float_ = new Ellipse2D.Float(f3 - 0.5f * f, f4 - 0.5f * f, f, f);
        SGUtilityJava2D.drawSymbol(float_, f2, color, color2, graphics2D);
    }

    public static void drawSquare(Point2D point2D, float f, float f2, Color color, Color color2, Graphics2D graphics2D) {
        float f3 = (float)point2D.getX();
        float f4 = (float)point2D.getY();
        Rectangle2D.Float float_ = new Rectangle2D.Float(f3 - 0.5f * f, f4 - 0.5f * f, f, f);
        SGUtilityJava2D.drawSymbol(float_, f2, color, color2, graphics2D);
    }

    public static void drawSymbol(Shape shape, float f, Color color, Color color2, Graphics2D graphics2D) {
        graphics2D.setPaint(color2);
        graphics2D.fill(shape);
        graphics2D.setPaint(color);
        graphics2D.setStroke(new BasicStroke(f));
        graphics2D.draw(shape);
    }

    public static BasicStroke getBasicStroke(int n, float f, int n2, int n3, float f2, float f3) {
        BasicStroke basicStroke = null;
        switch (n) {
            case 1: {
                basicStroke = new BasicStroke(f, n2, n3);
                break;
            }
            case 2: {
                float[] fArray = new float[]{2.0f * f, f};
                basicStroke = new BasicStroke(f, n2, n3, f2, fArray, f3);
                break;
            }
            case 3: {
                float[] fArray = new float[]{f};
                basicStroke = new BasicStroke(f, n2, n3, f2, fArray, f3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Line type is invalid.");
            }
        }
        return basicStroke;
    }

    public static float getAngle(float f, float f2, float f3, float f4) {
        float f5 = (f4 - f2) / (f3 - f);
        float f6 = 0.0f;
        f6 = (double)f5 == Double.POSITIVE_INFINITY | (double)f5 == Double.NEGATIVE_INFINITY ? (f4 > f2 ? 1.5707964f : 4.712389f) : (float)Math.atan(f5);
        return f6;
    }

    public static Shape getShapeWithThickness(float f, float f2, float f3, float f4, float f5, float f6) {
        Point2D.Float float_ = new Point2D.Float(f, f2);
        Point2D.Float float_2 = new Point2D.Float(f3, f4);
        float f7 = f6 * (float)float_.distance(float_2);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(f, f2);
        float f8 = SGUtilityJava2D.getAngle(f, f2, f3, f4) - 1.5707964f;
        affineTransform.rotate(f8);
        float f9 = f6 * f5;
        Rectangle2D.Float float_3 = new Rectangle2D.Float(-f9 / 2.0f, 0.0f, f9, f7);
        Shape shape = affineTransform.createTransformedShape(float_3);
        return shape;
    }
}

