/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGSignificantDifferenceSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;

public class SGSignificantDifferenceSymbol2D
extends SGSignificantDifferenceSymbol
implements SGIDrawingElementJava2D {
    protected SGDrawingElementString2DExtended mStringElement = new SGDrawingElementString2DExtended("*");
    protected SGDrawingElementLine2D mHorizontalLine = new SGDrawingElementLine2D();
    protected SGDrawingElementLine2D mPerpendicularLine1 = new SGDrawingElementLine2D();
    protected SGDrawingElementLine2D mPerpendicularLine2 = new SGDrawingElementLine2D();

    public SGSignificantDifferenceSymbol2D() {
    }

    public SGSignificantDifferenceSymbol2D(float f, float f2, float f3, float f4, float f5) {
        super(f, f2, f3, f4, f5);
    }

    protected boolean createDrawingElement() {
        SGTuple2f sGTuple2f = new SGTuple2f(this.getX(), this.getY());
        SGTuple2f sGTuple2f2 = new SGTuple2f(this.getX() + this.getWidth(), this.getY());
        SGTuple2f sGTuple2f3 = new SGTuple2f(this.getX(), this.getY() + this.getPerpendicularHeight1());
        SGTuple2f sGTuple2f4 = new SGTuple2f(this.getX() + this.getWidth(), this.getY() + this.getPerpendicularHeight2());
        this.mHorizontalLine.setTermPoints(sGTuple2f, sGTuple2f2);
        this.mPerpendicularLine1.setTermPoints(sGTuple2f, sGTuple2f3);
        this.mPerpendicularLine2.setTermPoints(sGTuple2f2, sGTuple2f4);
        Rectangle2D rectangle2D = this.mStringElement.getElementBounds();
        float f = (float)rectangle2D.getWidth();
        float f2 = (float)rectangle2D.getHeight();
        float f3 = this.getX() + this.getWidth() / 2.0f - f / 2.0f;
        float f4 = !this.isFlippingVertical() ? this.getY() - this.getSpace() - f2 : this.getY() + this.getSpace();
        this.mStringElement.setLocation(f3, f4);
        return true;
    }

    public ArrayList getDrawingElementList() {
        ArrayList<SGDrawingElementLine2D> arrayList = new ArrayList<SGDrawingElementLine2D>();
        arrayList.add(this.mHorizontalLine);
        arrayList.add(this.mPerpendicularLine1);
        arrayList.add(this.mPerpendicularLine2);
        return arrayList;
    }

    public Point2D getJoint1() {
        Point2D.Float float_ = new Point2D.Float(this.getX1(), this.getY());
        return float_;
    }

    public Point2D getJoint2() {
        Point2D.Float float_ = new Point2D.Float(this.getX2(), this.getY());
        return float_;
    }

    public Point2D getLeftJoint() {
        Point2D point2D = !this.isFlippingHorizontal() ? this.getJoint1() : this.getJoint2();
        return point2D;
    }

    public Point2D getLeftTerm() {
        Point2D point2D = this.getLeftJoint();
        point2D.setLocation(point2D.getX(), point2D.getY() + (double)this.getLeftHeight());
        return point2D;
    }

    public Point2D getRightJoint() {
        Point2D point2D = !this.isFlippingHorizontal() ? this.getJoint2() : this.getJoint1();
        return point2D;
    }

    public Point2D getRightTerm() {
        Point2D point2D = this.getRightJoint();
        point2D.setLocation(point2D.getX(), point2D.getY() + (double)this.getRightHeight());
        return point2D;
    }

    public Point2D getHorizontalMiddle() {
        Point2D.Float float_ = new Point2D.Float(this.getX1() + this.getWidth() / 2.0f, this.getY());
        return float_;
    }

    public Point2D getLeftMiddle() {
        Point2D.Float float_ = new Point2D.Float();
        Point2D point2D = this.getLeftJoint();
        Point2D point2D2 = this.getLeftTerm();
        ((Point2D)float_).setLocation((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0);
        return float_;
    }

    public Point2D getRightMiddle() {
        Point2D.Float float_ = new Point2D.Float();
        Point2D point2D = this.getRightJoint();
        Point2D point2D2 = this.getRightTerm();
        ((Point2D)float_).setLocation((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0);
        return float_;
    }

    public SGDrawingElementString getStringElement() {
        return this.mStringElement;
    }

    public boolean setMagnification(float f) {
        super.setMagnification(f);
        ArrayList arrayList = this.getDrawingElementList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(i);
            sGDrawingElement.setMagnification(f);
        }
        this.mStringElement.setMagnification(f);
        return true;
    }

    public boolean setLineWidth(float f) {
        super.setLineWidth(f);
        ArrayList arrayList = this.getDrawingElementList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)arrayList.get(i);
            sGDrawingElementLine.setLineWidth(f);
        }
        return true;
    }

    public boolean contains(int n, int n2) {
        if (this.isLineVisible()) {
            if (this.mHorizontalLine.contains(n, n2)) {
                return true;
            }
            if (this.mPerpendicularLine1.contains(n, n2)) {
                return true;
            }
            if (this.mPerpendicularLine2.contains(n, n2)) {
                return true;
            }
        }
        return this.mStringElement.contains(n, n2);
    }

    public ArrayList getShapeList() {
        ArrayList arrayList = this.getDrawingElementList();
        ArrayList<Shape> arrayList2 = new ArrayList<Shape>();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)arrayList.get(i);
            arrayList2.add(sGDrawingElementLine2D.getShape());
        }
        return arrayList2;
    }

    public Shape getConnectedShape() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(this.mPerpendicularLine1.getShape(), true);
        generalPath.append(this.mHorizontalLine.getShape(), true);
        generalPath.append(this.mPerpendicularLine2.getShape(), true);
        return generalPath;
    }

    public boolean zoom(float f) {
        super.zoom(f);
        this.createDrawingElement();
        return true;
    }

    public Rectangle2D getElementBounds() {
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        arrayList.add(this.getLineBounds());
        arrayList.add(this.getStringBounds());
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        return rectangle2D;
    }

    public Rectangle2D getLineBounds() {
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        ArrayList arrayList2 = this.getDrawingElementList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)arrayList2.get(i);
            arrayList.add(sGDrawingElementLine2D.getShape().getBounds2D());
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        return rectangle2D;
    }

    public Rectangle2D getStringBounds() {
        return this.mStringElement.getElementBounds();
    }

    public void drawSymbol(Graphics2D graphics2D) {
        graphics2D.setPaint(this.getColor());
        if (this.isLineVisible()) {
            float f = this.mMagnification * this.getLineWidth();
            graphics2D.setStroke(new BasicStroke(f, 0, 0));
            Shape shape = this.getConnectedShape();
            graphics2D.draw(shape);
        }
        SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)this.getStringElement();
        sGDrawingElementString2DExtended.drawString(graphics2D);
    }
}

