/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Font;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;

public abstract class SGDrawingElementString
extends SGDrawingElement
implements SGIStringConstants,
SGIDrawingElementConstants {
    protected String mString = new String();
    protected Font mFont = null;
    protected String mFontName;
    protected float mFontSize;
    protected int mFontStyle;
    protected float mX;
    protected float mY;
    protected float mAngle;

    public SGDrawingElementString() {
    }

    public SGDrawingElementString(String string) {
        this.mString = new String(string);
    }

    public SGDrawingElementString(SGDrawingElementString sGDrawingElementString) {
        this.mMagnification = sGDrawingElementString.mMagnification;
        this.mString = new String(sGDrawingElementString.mString);
        this.setFont(sGDrawingElementString.getFontName(), sGDrawingElementString.getFontStyle(), sGDrawingElementString.getFontSize());
        this.mX = sGDrawingElementString.mX;
        this.mY = sGDrawingElementString.mY;
        this.mAngle = sGDrawingElementString.mAngle;
        this.mColorList = new ArrayList(sGDrawingElementString.mColorList);
    }

    public SGDrawingElementString(String string, String string2, int n, float f) {
        this.mString = new String(string);
        this.setFont(string2, n, f);
    }

    public SGDrawingElementString(String string, String string2, int n, float f, float f2, float f3) {
        this.mString = new String(string);
        this.setFont(string2, n, f);
        this.mX = f2;
        this.mY = f3;
    }

    public String toString() {
        return this.mString;
    }

    public boolean setFont(String string, int n, float f) {
        this.mFontName = string;
        this.mFontStyle = n;
        this.mFontSize = f;
        this.mFont = new Font(this.mFontName, this.mFontStyle, (int)(this.mMagnification * this.mFontSize));
        return true;
    }

    public boolean setString(String string) {
        this.mString = string;
        return true;
    }

    public boolean setMagnification(float f) {
        super.setMagnification(f);
        this.setFont(this.mFontName, this.mFontStyle, this.mFontSize);
        return true;
    }

    public String getString() {
        return this.mString;
    }

    public float getX() {
        return this.getLocation().x;
    }

    public float getY() {
        return this.getLocation().y;
    }

    public SGTuple2f getLocation() {
        return new SGTuple2f(this.mX, this.mY);
    }

    public float getFontSize() {
        return this.mFontSize;
    }

    public int getFontStyle() {
        return this.mFontStyle;
    }

    public boolean setLocation(SGTuple2f sGTuple2f) {
        if (sGTuple2f == null) {
            throw new IllegalArgumentException("pos==null");
        }
        this.setLocation(sGTuple2f.x, sGTuple2f.y);
        return true;
    }

    public boolean setLocation(float f, float f2) {
        this.mX = f;
        this.mY = f2;
        return true;
    }

    public boolean setX(float f) {
        this.setLocation(f, this.getY());
        return true;
    }

    public boolean setY(float f) {
        this.setLocation(this.getX(), f);
        return true;
    }

    public boolean setAngle(float f) {
        this.mAngle = f;
        return true;
    }

    public float getAngle() {
        return this.mAngle;
    }

    public String getFontName() {
        return this.mFontName;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementString)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)sGDrawingElement;
        this.setX(sGDrawingElementString.getX());
        this.setY(sGDrawingElementString.getY());
        this.setString(sGDrawingElementString.getString());
        this.setFont(sGDrawingElementString.getFontName(), sGDrawingElementString.getFontStyle(), sGDrawingElementString.getFontSize());
        this.setAngle(sGDrawingElementString.getAngle());
        return true;
    }

    public SGProperties getProperties() {
        StringProperties stringProperties = new StringProperties();
        this.getProperties(stringProperties);
        return stringProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        StringProperties stringProperties = (StringProperties)sGProperties;
        stringProperties.setX(this.mX);
        stringProperties.setY(this.mY);
        stringProperties.setText(this.getString());
        stringProperties.setFontName(this.getFontName());
        stringProperties.setFontSize(this.getFontSize());
        stringProperties.setFontStyle(this.getFontStyle());
        stringProperties.setAngle(this.getAngle());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        StringProperties stringProperties = (StringProperties)sGProperties;
        this.mX = stringProperties.getX().floatValue();
        this.mY = stringProperties.getY().floatValue();
        this.setString(stringProperties.getText());
        this.setFont(stringProperties.getFontName(), stringProperties.getFontStyle(), stringProperties.getFontSize().floatValue());
        this.setAngle(stringProperties.getAngle().floatValue());
        return true;
    }

    public boolean translate(float f, float f2) {
        this.setLocation(this.getX() + f, this.getY() + f2);
        return true;
    }

    public static class StringProperties
    extends SGDrawingElement.DrawingElementProperties {
        public static final String[] keys = new String[]{"X", "Y", "Text", "FontSize", "FontStyle", "FontName", "Angle"};

        public boolean equals(Object object) {
            if (!(object instanceof StringProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            StringProperties stringProperties = (StringProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(stringProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Float getX() {
            String string = this.getProperty("X");
            return SGUtilityText.getFloat(string);
        }

        public Float getY() {
            String string = this.getProperty("Y");
            return SGUtilityText.getFloat(string);
        }

        public String getText() {
            return this.getProperty("Text");
        }

        public String getFontName() {
            return this.getProperty("FontName");
        }

        public Float getFontSize() {
            String string = this.getProperty("FontSize");
            return SGUtilityText.getFloat(string);
        }

        public Integer getFontStyle() {
            String string = this.getProperty("FontStyle");
            return SGUtilityText.getInteger(string);
        }

        public Float getAngle() {
            String string = this.getProperty("Angle");
            return SGUtilityText.getFloat(string);
        }

        public boolean setX(float f) {
            this.setProperty("X", new Float(f).toString());
            return true;
        }

        public boolean setY(float f) {
            this.setProperty("Y", new Float(f).toString());
            return true;
        }

        public boolean setText(String string) {
            this.setProperty("Text", string);
            return true;
        }

        public boolean setFontName(String string) {
            this.setProperty("FontName", string);
            return true;
        }

        public boolean setFontSize(float f) {
            this.setProperty("FontSize", new Float(f).toString());
            return true;
        }

        public boolean setFontStyle(int n) {
            this.setProperty("FontStyle", new Integer(n).toString());
            return true;
        }

        public boolean setAngle(float f) {
            this.setProperty("Angle", new Float(f).toString());
            return true;
        }
    }
}

