/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.print.table;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import org.freehep.swing.print.table.CellPrinter;

public class DefaultCellPrinter
implements CellPrinter {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    protected String value;
    private Rectangle2D.Float rect;
    private Font font;
    private int align;

    DefaultCellPrinter(int align) {
        this.align = align;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public float getHeight(FontRenderContext frc) {
        if (this.rect == null) {
            this.rect = (Rectangle2D.Float)this.font.getStringBounds(this.value, frc);
        }
        return this.rect.height;
    }

    public void setValue(Object o) {
        this.value = this.format(o);
        this.rect = null;
    }

    public float getWidth(FontRenderContext frc) {
        if (this.rect == null) {
            this.rect = (Rectangle2D.Float)this.font.getStringBounds(this.value, frc);
        }
        return this.rect.width;
    }

    public void print(Graphics g, Rectangle2D.Float r) {
        if (this.value == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        FontRenderContext frc = g2.getFontRenderContext();
        if (this.rect == null) {
            this.rect = (Rectangle2D.Float)this.font.getStringBounds(this.value, frc);
        }
        float y = r.y - this.rect.y;
        float x = r.x;
        if (this.align == 2) {
            x += r.width - this.getWidth(frc);
        } else if (this.align == 1) {
            x += (r.width - this.getWidth(frc)) / 2.0f;
        }
        g2.setFont(this.font);
        g2.drawString(this.value, x, y);
    }

    protected String format(Object o) {
        return o == null ? "" : o.toString();
    }
}

