/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGDouble;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertySettingListener;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGITwoDimensionalData;
import jp.riken.brain.ni.samuraigraph.figure.SGAxisBreakSymbolDialog;
import jp.riken.brain.ni.samuraigraph.figure.SGAxisBreakingSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisBreakingSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisPanel;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGTimingElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;

public class SGAxisElement
extends SGFigureElement
implements SGIAxisElement,
WindowListener {
    private int mViewDirection = 0;
    private final ArrayList mElementsGroupList = new ArrayList();
    private Color mLineColor = SGDefaultValues.AXIS_LINE_COLOR;
    private float mAxisLineWidth = 1.5f;
    private float mScaleLineWidth = 1.5f;
    private Color mStringColor = SGDefaultValues.AXIS_STRING_COLOR;
    private float mTitleFontSize = 16.0f;
    private int mTitleFontStyle = -1;
    private String mTitleFontFamilyName = "Serif";
    private float mScaleFontSize = 16.0f;
    private int mScaleFontStyle = -1;
    private String mScaleFontFamilyName = "Serif";
    private float mScaleLineLength = 7.0866146f;
    private float mSpaceAxisLineAndNumber = 5.6692915f;
    private float mSpaceNumberAndTitle = 5.6692915f;
    private SGDrawingElement mPressedElement = null;
    private Point mPressedElementOrigin = null;
    private final JPopupMenu mPopupMenu = new JPopupMenu();
    private AxisDialog mDialog = null;
    private final ArrayList mTimingElementGroupSetList = new ArrayList();
    private boolean mFrameLinesVisibleFlag = true;
    private Color mFrameLineColor = SGDefaultValues.AXIS_FRAME_LINE_COLOR;
    private float mFrameLineWidth = 1.5f;
    private boolean mNotifyChangeOnDraggingFlag = true;
    public static final int AXIS_SCALE_EFFECTIVE_DIGIT = 3;
    private ArrayList mAxisBreakSymbolList = new ArrayList();
    private SGAxisBreakSymbolDialog mAxisBreakSymbolDialog = null;
    protected AxisBreakSymbol mFocusedSymbol = null;
    protected Point mPressedSymbolOrigin = null;
    private SGProperties mTemporaryProperties = null;
    public static final String REMOVE_AXIS_BREAK_SYMBOL = "Remove";

    public SGAxisElement() {
        if (!this.init()) {
            throw new Error();
        }
    }

    private boolean init() {
        this.setAxisLineWidth(1.5f);
        this.setScaleLineWidth(1.5f);
        this.setScaleLineLength(7.0866146f);
        this.setLineColor(SGDefaultValues.AXIS_LINE_COLOR);
        this.setFrameLinesVisible(false);
        this.setFrameLineWidth(1.5f);
        this.setFrameLineColor(SGDefaultValues.AXIS_FRAME_LINE_COLOR);
        this.setFontFamilyName("Serif");
        this.setFontSize(16.0f);
        int n = SGUtilityText.getFontStyle("Plain");
        if (n == -1) {
            return false;
        }
        this.setFontStyle(n);
        this.setStringColor(SGDefaultValues.AXIS_STRING_COLOR);
        return true;
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (sGIFigureElement instanceof SGIGraphElement) {
            SGIGraphElement sGIGraphElement = (SGIGraphElement)sGIFigureElement;
            bl = this.synchronizeToGraphElement(sGIGraphElement);
        } else if (!(sGIFigureElement instanceof SGIStringElement || sGIFigureElement instanceof SGILegendElement || sGIFigureElement instanceof SGIAxisElement)) {
            bl = sGIFigureElement.synchronizeArgument(this);
        }
        return bl;
    }

    private boolean synchronizeToGraphElement(SGIGraphElement sGIGraphElement) {
        Object object;
        Object object2;
        int n;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        sGIGraphElement.getTimingElementList(arrayList, arrayList2, arrayList3);
        for (n = this.mTimingElementGroupSetList.size() - 1; n >= 0; --n) {
            object2 = (TimingElementGroupSetInAxis)this.mTimingElementGroupSetList.get(n);
            object = ((TimingElementGroupSetInAxis)object2).mValue;
            boolean bl = arrayList3.contains(object);
            if (bl) continue;
            this.mTimingElementGroupSetList.remove(n);
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            SGTuple2f[] sGTuple2fArray;
            Object object3;
            Object object4;
            Object object5;
            object2 = (SGDouble)arrayList3.get(n);
            object = (SGAxis)arrayList.get(n);
            ArrayList arrayList4 = (ArrayList)arrayList2.get(n);
            boolean bl = false;
            for (int i = 0; i < this.mTimingElementGroupSetList.size(); ++i) {
                object5 = (TimingElementGroupSetInAxis)this.mTimingElementGroupSetList.get(i);
                object4 = ((TimingElementGroupSetInAxis)object5).mValue;
                if (!object4.equals(object2)) continue;
                object3 = ((TimingElementGroupSetInAxis)object5).mDrawingElementGroupList;
                for (int j = 0; j < ((ArrayList)object3).size(); ++j) {
                    sGTuple2fArray = (SGTuple2f[])((ArrayList)object3).get(j);
                    SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList4.get(j);
                    sGTuple2fArray.setProperty(sGDrawingElement);
                }
                bl = true;
                break;
            }
            if (bl) continue;
            TimingElementGroupSetInAxis timingElementGroupSetInAxis = new TimingElementGroupSetInAxis();
            timingElementGroupSetInAxis.mAxis = object;
            timingElementGroupSetInAxis.mValue = object2;
            for (int i = 0; i < arrayList4.size(); ++i) {
                object4 = (SGDrawingElement)arrayList4.get(i);
                timingElementGroupSetInAxis.addDrawingElementGroup((SGDrawingElement)object4);
            }
            this.mTimingElementGroupSetList.add(n, timingElementGroupSetInAxis);
            object5 = timingElementGroupSetInAxis.mDrawingElementGroupList;
            for (int i = 0; i < ((ArrayList)object5).size(); ++i) {
                object3 = (SGElementGroup)((ArrayList)object5).get(i);
                if (!(object3 instanceof SGElementGroupLine)) {
                    throw new Error();
                }
                SGElementGroupLine sGElementGroupLine = (SGElementGroupLine)object3;
                sGTuple2fArray = new SGTuple2f[]{new SGTuple2f(), new SGTuple2f()};
                sGElementGroupLine.setLocation(sGTuple2fArray);
            }
        }
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error("");
    }

    public boolean zoom(float f) {
        Object object;
        int n;
        super.zoom(f);
        for (n = 0; n < this.mElementsGroupList.size(); ++n) {
            object = (ElementsGroupOfAxis)this.mElementsGroupList.get(n);
            ((ElementsGroupOfAxis)object).zoom(f);
        }
        for (n = 0; n < this.mTimingElementGroupSetList.size(); ++n) {
            object = (SGElementGroupSet)this.mTimingElementGroupSetList.get(n);
            ((SGElementGroupSet)object).zoom(f);
        }
        for (n = 0; n < this.mAxisBreakSymbolList.size(); ++n) {
            object = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(n);
            ((SGAxisBreakingSymbol2D)object).zoom(f);
        }
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        Object object;
        int n;
        if (!super.onMouseClicked(mouseEvent)) {
            return false;
        }
        for (n = this.mAxisBreakSymbolList.size() - 1; n >= 0; --n) {
            object = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(n);
            if (!((SGDrawingElement)object).isVisible() || !((AxisBreakSymbol)object).clickDrawingElements(mouseEvent)) continue;
            return true;
        }
        for (n = 0; n < this.mElementsGroupList.size(); ++n) {
            object = (ElementsGroupOfAxis)this.mElementsGroupList.get(n);
            boolean bl = ((ElementsGroupOfAxis)object).onMouseClicked(mouseEvent);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        Object object;
        int n;
        if (!super.onMousePressed(mouseEvent)) {
            return false;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        for (n = this.mAxisBreakSymbolList.size() - 1; n >= 0; --n) {
            object = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(n);
            if (!((SGDrawingElement)object).isVisible() || !((SGAxisBreakingSymbol2D)object).contains(n2, n3)) continue;
            this.mFocusedSymbol = object;
            this.mPressedSymbolOrigin = new Point(n2 - (int)((SGAxisBreakingSymbol)object).getX(), n3 - (int)((SGAxisBreakingSymbol)object).getY());
            ((AxisBreakSymbol)object).mTemporaryProperties = ((SGAxisBreakingSymbol)object).getProperties();
            this.mAxisBreakSymbolList.remove(object);
            this.mAxisBreakSymbolList.add(object);
            this.repaint();
            return true;
        }
        for (n = 0; n < this.mElementsGroupList.size(); ++n) {
            object = (ElementsGroupOfAxis)this.mElementsGroupList.get(n);
            boolean bl = ((ElementsGroupOfAxis)object).onMousePressed(mouseEvent);
            if (!bl) continue;
            this.createTempProperties();
            return true;
        }
        return false;
    }

    private boolean clearFocusedSymbol() {
        this.mFocusedSymbol = null;
        this.mPressedSymbolOrigin = null;
        return true;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (!super.onMouseDragged(mouseEvent)) {
            return false;
        }
        if (this.mFocusedSymbol != null && this.mPressedSymbolOrigin != null) {
            float f = mouseEvent.getX() - this.mPressedSymbolOrigin.x;
            float f2 = mouseEvent.getY() - this.mPressedSymbolOrigin.y;
            this.mFocusedSymbol.setLocation(f, f2);
            return true;
        }
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            boolean bl = elementsGroupOfAxis.onMouseDragged(mouseEvent);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public boolean onKeyPressed(KeyEvent keyEvent) {
        return true;
    }

    public boolean onKeyReleased(KeyEvent keyEvent) {
        return true;
    }

    public boolean onKeyTyped(KeyEvent keyEvent) {
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        if (!super.onMouseReleased(mouseEvent)) {
            return false;
        }
        if (this.mFocusedSymbol != null && this.mFocusedSymbol.isChanged()) {
            this.mFocusedSymbol.updateHistory();
        }
        this.clearFocusedSymbol();
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            if (!elementsGroupOfAxis.onMouseReleased(mouseEvent)) continue;
            if (!this.createAllDrawingElements()) {
                return false;
            }
            this.notifyChange();
            this.initializePressedElement();
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.updateHistory();
            }
            this.mTemporaryProperties = null;
            return true;
        }
        this.initializePressedElement();
        return true;
    }

    public boolean onDrawingElement(int n, int n2) {
        for (int i = this.mAxisBreakSymbolList.size() - 1; i >= 0; --i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(i);
            if (axisBreakSymbol.contains(n, n2)) {
                axisBreakSymbol.mFrameFlag = true;
                this.repaint();
                return true;
            }
            axisBreakSymbol.mFrameFlag = false;
        }
        this.repaint();
        return false;
    }

    private void initializePressedElement() {
        this.mPressedElement = null;
        this.mPressedElementOrigin = null;
    }

    private boolean createTempProperties() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    public JDialog getDialog() {
        AxisDialog axisDialog = this.mDialog;
        axisDialog.setLocation(this.mDialogOwner.getLocation());
        axisDialog.setColorButtonBorder(true);
        this.setDialogProperty();
        this.createTempProperties();
        return this.mDialog;
    }

    private boolean setDialogProperty() {
        AxisDialog axisDialog = this.mDialog;
        axisDialog.setLineWidth(this.mAxisLineWidth);
        axisDialog.setScaleLineWidth(this.mScaleLineWidth);
        axisDialog.setScaleLineLength(this.mScaleLineLength * 0.035277776f);
        axisDialog.setLineColor(this.mLineColor);
        axisDialog.setFontFamilyName(this.mTitleFontFamilyName);
        axisDialog.setFontSize(this.mTitleFontSize);
        axisDialog.setStringColor(this.mStringColor);
        axisDialog.setFontStyle(this.mTitleFontStyle);
        axisDialog.setFrameVisible(this.mFrameLinesVisibleFlag);
        axisDialog.setFrameLineWidth(this.mFrameLineWidth);
        axisDialog.setFrameLineColor(this.mFrameLineColor);
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            elementsGroupOfAxis.setDialogProperty();
        }
        return true;
    }

    private boolean createDialog() {
        SGAxisBreakSymbolDialog sGAxisBreakSymbolDialog;
        AxisDialog axisDialog = new AxisDialog(this.mDialogOwner, true);
        ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroupInPlane(1);
        ElementsGroupOfAxis elementsGroupOfAxis2 = this.getAxisGroupInPlane(-1);
        ElementsGroupOfAxis elementsGroupOfAxis3 = this.getAxisGroupInPlane(2);
        ElementsGroupOfAxis elementsGroupOfAxis4 = this.getAxisGroupInPlane(-2);
        axisDialog.getBottomAxisPanel().add(elementsGroupOfAxis.mAxisPanel);
        axisDialog.getTopAxisPanel().add(elementsGroupOfAxis2.mAxisPanel);
        axisDialog.getLeftAxisPanel().add(elementsGroupOfAxis3.mAxisPanel);
        axisDialog.getRightAxisPanel().add(elementsGroupOfAxis4.mAxisPanel);
        axisDialog.pack();
        axisDialog.setActionListener(this);
        axisDialog.addWindowListener(this);
        this.mDialog = axisDialog;
        this.mAxisBreakSymbolDialog = sGAxisBreakSymbolDialog = new SGAxisBreakSymbolDialog(this.mDialogOwner, true);
        return true;
    }

    public boolean addData(SGData sGData) {
        super.addData(sGData);
        if (this.mElementsGroupList.size() == 0 && sGData instanceof SGITwoDimensionalData) {
            SGITwoDimensionalData sGITwoDimensionalData = (SGITwoDimensionalData)((Object)sGData);
            double d = sGITwoDimensionalData.getMinValueX();
            double d2 = sGITwoDimensionalData.getMaxValueX();
            double d3 = sGITwoDimensionalData.getMinValueY();
            double d4 = sGITwoDimensionalData.getMaxValueY();
            ElementsGroupOfAxis elementsGroupOfAxis = new ElementsGroupOfAxis();
            ElementsGroupOfAxis elementsGroupOfAxis2 = new ElementsGroupOfAxis();
            ElementsGroupOfAxis elementsGroupOfAxis3 = new ElementsGroupOfAxis();
            ElementsGroupOfAxis elementsGroupOfAxis4 = new ElementsGroupOfAxis();
            SGAxis sGAxis = new SGAxis();
            sGAxis.setRange(d, d2);
            sGAxis.setScaleType(0);
            ElementsGroupOfAxis elementsGroupOfAxis5 = elementsGroupOfAxis;
            elementsGroupOfAxis5.zoom(this.mMagnification);
            elementsGroupOfAxis5.setConfigurationInPlane(1);
            elementsGroupOfAxis5.mAxis = sGAxis;
            elementsGroupOfAxis5.mAxisElement = this;
            elementsGroupOfAxis5.mVisibleFlag = true;
            elementsGroupOfAxis5.mTitle.setString("X-Label");
            this.mElementsGroupList.add(elementsGroupOfAxis5);
            sGAxis = new SGAxis();
            sGAxis.setRange(d, d2);
            sGAxis.setScaleType(0);
            elementsGroupOfAxis5 = elementsGroupOfAxis2;
            elementsGroupOfAxis5.zoom(this.mMagnification);
            elementsGroupOfAxis5.setConfigurationInPlane(-1);
            elementsGroupOfAxis5.mAxis = sGAxis;
            elementsGroupOfAxis5.mAxisElement = this;
            elementsGroupOfAxis5.mVisibleFlag = false;
            elementsGroupOfAxis5.mTitle.setString("X-Label");
            this.mElementsGroupList.add(elementsGroupOfAxis5);
            sGAxis = new SGAxis();
            sGAxis.setRange(d3, d4);
            sGAxis.setScaleType(0);
            elementsGroupOfAxis5 = elementsGroupOfAxis3;
            elementsGroupOfAxis5.zoom(this.mMagnification);
            elementsGroupOfAxis5.setConfigurationInPlane(2);
            elementsGroupOfAxis5.mAxis = sGAxis;
            elementsGroupOfAxis5.mAxisElement = this;
            elementsGroupOfAxis5.mVisibleFlag = true;
            elementsGroupOfAxis5.mTitle.setString("Y-Label");
            this.mElementsGroupList.add(elementsGroupOfAxis5);
            sGAxis = new SGAxis();
            sGAxis.setRange(d3, d4);
            sGAxis.setScaleType(0);
            elementsGroupOfAxis5 = elementsGroupOfAxis4;
            elementsGroupOfAxis5.zoom(this.mMagnification);
            elementsGroupOfAxis5.setConfigurationInPlane(-2);
            elementsGroupOfAxis5.mAxis = sGAxis;
            elementsGroupOfAxis5.mAxisElement = this;
            elementsGroupOfAxis5.mVisibleFlag = false;
            elementsGroupOfAxis5.mTitle.setString("Y-Label");
            this.mElementsGroupList.add(elementsGroupOfAxis5);
            this.createAllDrawingElements();
            this.createDialog();
        }
        this.mDataList.add(sGData);
        return true;
    }

    public boolean setGraphAreaRect(float f, float f2, float f3, float f4) {
        super.setGraphAreaRect(f, f2, f3, f4);
        this.setLocationOfAllDrawingElements();
        return true;
    }

    public boolean getMarginAroundGraphAreaRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        Cloneable cloneable;
        Object object;
        if (!super.getMarginAroundGraphAreaRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroupInPlane(-1);
        ElementsGroupOfAxis elementsGroupOfAxis2 = this.getAxisGroupInPlane(1);
        ElementsGroupOfAxis elementsGroupOfAxis3 = this.getAxisGroupInPlane(2);
        ElementsGroupOfAxis elementsGroupOfAxis4 = this.getAxisGroupInPlane(-2);
        if (elementsGroupOfAxis == null || elementsGroupOfAxis2 == null || elementsGroupOfAxis3 == null || elementsGroupOfAxis4 == null) {
            return false;
        }
        float f = this.getSpaceAxisLineAndNumber();
        Rectangle2D rectangle2D = elementsGroupOfAxis.getBoundingBox();
        Rectangle2D rectangle2D2 = elementsGroupOfAxis2.getBoundingBox();
        Rectangle2D rectangle2D3 = elementsGroupOfAxis3.getBoundingBox();
        Rectangle2D rectangle2D4 = elementsGroupOfAxis4.getBoundingBox();
        ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
        for (int i = 0; i < this.mAxisBreakSymbolList.size(); ++i) {
            object = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(i);
            if (!((SGDrawingElement)object).isVisible()) continue;
            cloneable = ((SGAxisBreakingSymbol2D)object).getElementBounds();
            arrayList.add(cloneable);
        }
        Rectangle2D rectangle2D5 = null;
        if (arrayList.size() != 0) {
            rectangle2D5 = SGUtility.createUnion(arrayList);
        }
        object = this.getGraphAreaRect();
        cloneable = new ArrayList();
        ((ArrayList)cloneable).add(object);
        if (rectangle2D != null) {
            ((ArrayList)cloneable).add(rectangle2D);
        }
        if (rectangle2D2 != null) {
            ((ArrayList)cloneable).add(rectangle2D2);
        }
        if (rectangle2D3 != null) {
            ((ArrayList)cloneable).add(rectangle2D3);
        }
        if (rectangle2D4 != null) {
            ((ArrayList)cloneable).add(rectangle2D4);
        }
        if (rectangle2D5 != null) {
            ((ArrayList)cloneable).add(rectangle2D5);
        }
        Rectangle2D rectangle2D6 = SGUtility.createUnion((ArrayList)cloneable);
        float f2 = (float)(((RectangularShape)object).getY() - rectangle2D6.getY());
        float f3 = (float)(rectangle2D6.getY() + rectangle2D6.getHeight() - (((RectangularShape)object).getY() + ((RectangularShape)object).getHeight()));
        float f4 = (float)(((RectangularShape)object).getX() - rectangle2D6.getX());
        float f5 = (float)(rectangle2D6.getX() + rectangle2D6.getWidth() - (((RectangularShape)object).getX() + ((RectangularShape)object).getWidth()));
        sGTuple2f.x += f2;
        sGTuple2f.y += f3;
        sGTuple2f2.x += f4;
        sGTuple2f2.y += f5;
        return true;
    }

    public boolean setViewDirection(int n) {
        this.mViewDirection = n;
        return true;
    }

    public boolean setTitleFontSize(float f) {
        this.mTitleFontSize = f;
        return true;
    }

    public boolean setTitleFontStyle(int n) {
        this.mTitleFontStyle = n;
        return true;
    }

    public boolean setTitleFontFamilyName(String string) {
        this.mTitleFontFamilyName = string;
        return true;
    }

    public boolean setLineColor(Color color) {
        this.mLineColor = color;
        return true;
    }

    public boolean setAxisLineWidth(float f) {
        this.mAxisLineWidth = f;
        return true;
    }

    public boolean setScaleLineWidth(float f) {
        this.mScaleLineWidth = f;
        return true;
    }

    public boolean setStringColor(Color color) {
        this.mStringColor = color;
        return true;
    }

    public boolean setFontSize(float f) {
        this.setTitleFontSize(f);
        this.setScaleFontSize(f);
        return true;
    }

    public boolean setFontStyle(int n) {
        this.setTitleFontStyle(n);
        this.setScaleFontStyle(n);
        return true;
    }

    public boolean setFontFamilyName(String string) {
        this.setTitleFontFamilyName(string);
        this.setScaleFontFamilyName(string);
        return true;
    }

    public boolean setScaleFontSize(float f) {
        this.mScaleFontSize = f;
        return true;
    }

    public boolean setScaleFontStyle(int n) {
        this.mScaleFontStyle = n;
        return true;
    }

    public boolean setScaleFontFamilyName(String string) {
        this.mScaleFontFamilyName = string;
        return true;
    }

    public boolean setScaleLineLength(float f) {
        this.mScaleLineLength = f;
        return true;
    }

    public boolean setFrameLinesVisible(boolean bl) {
        this.mFrameLinesVisibleFlag = bl;
        return true;
    }

    public boolean setFrameLineWidth(float f) {
        this.mFrameLineWidth = f;
        return true;
    }

    public boolean setFrameLineColor(Color color) {
        this.mFrameLineColor = color;
        return true;
    }

    public boolean setSpaceAxisLineAndNumber(float f) {
        this.mSpaceAxisLineAndNumber = f / this.mMagnification;
        return true;
    }

    public boolean setSpaceNumberAndTitle(float f) {
        this.mSpaceNumberAndTitle = f / this.mMagnification;
        return true;
    }

    public float getSpaceAxisLineAndNumber() {
        return this.mSpaceAxisLineAndNumber * this.mMagnification;
    }

    public float getSpaceNumberAndTitle() {
        return this.mSpaceNumberAndTitle * this.mMagnification;
    }

    public float getNumberFontSize() {
        return this.mScaleFontSize;
    }

    public float getTitleFontSize() {
        return this.mTitleFontSize;
    }

    public boolean getTimingElementList(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        for (int i = 0; i < this.mTimingElementGroupSetList.size(); ++i) {
            TimingElementGroupSetInAxis timingElementGroupSetInAxis = (TimingElementGroupSetInAxis)this.mTimingElementGroupSetList.get(i);
            SGAxis sGAxis = timingElementGroupSetInAxis.mAxis;
            ArrayList arrayList4 = timingElementGroupSetInAxis.getDrawingElementList();
            SGDouble sGDouble = timingElementGroupSetInAxis.mValue;
            arrayList.add(sGAxis);
            arrayList2.add(arrayList4);
            arrayList3.add(sGDouble);
        }
        return true;
    }

    public boolean addTimingLine(int n, int n2) {
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            boolean bl = elementsGroupOfAxis.contains(n, n2);
            if (!bl) continue;
            elementsGroupOfAxis.addTimingLine(n, n2);
            this.notifyChange();
            return true;
        }
        return false;
    }

    public boolean addAxisBreakSymbol(int n, int n2) {
        if (!this.getGraphAreaRect().contains(n, n2)) {
            return false;
        }
        AxisBreakSymbol axisBreakSymbol = new AxisBreakSymbol(28.346458f, 14.173229f, 0.0f, 0.0f, true);
        axisBreakSymbol.addColor(SGDefaultValues.AXIS_BREAK_INNER_COLOR);
        axisBreakSymbol.setLineColor(SGDefaultValues.AXIS_BREAK_LINE_COLOR);
        axisBreakSymbol.setLineWidth(1.5f);
        axisBreakSymbol.setMagnification(this.mMagnification);
        axisBreakSymbol.setLocation(n, n2);
        this.mAxisBreakSymbolList.add(axisBreakSymbol);
        this.updateHistory();
        axisBreakSymbol.initPropertiesHistory();
        return true;
    }

    private boolean updateParentHistoryFromAxisBreakSymbol(AxisBreakSymbol axisBreakSymbol) {
        this.updateParentHistory();
        this.updateObjectHistory(axisBreakSymbol);
        return true;
    }

    private ElementsGroupOfAxis addAxisGroup(int n, SGTuple2d sGTuple2d, int n2) {
        ElementsGroupOfAxis elementsGroupOfAxis = new ElementsGroupOfAxis();
        SGAxis sGAxis = new SGAxis();
        sGAxis.setRange(new SGTuple2d(sGTuple2d));
        sGAxis.setScaleType(n2);
        elementsGroupOfAxis.mAxis = sGAxis;
        elementsGroupOfAxis.setConfigurationInCube(n);
        elementsGroupOfAxis.mAxisElement = this;
        this.mElementsGroupList.add(elementsGroupOfAxis);
        return elementsGroupOfAxis;
    }

    private ElementsGroupOfAxis addAxisGroup(int n) {
        return this.addAxisGroup(n, new SGTuple2d(), 0);
    }

    private double roundOffNumber(double d, int n) {
        double d2 = Math.pow(10.0, -((double)n));
        double d3 = d2 / 10.0;
        double d4 = d * d2;
        double d5 = d * d3;
        int n2 = (int)d4 % 10;
        double d6 = n2 < 5 ? Math.ceil(d5) / d3 : Math.floor(d5) / d3;
        return d6;
    }

    public void paintGraphics2D(Graphics2D graphics2D) {
        Object object;
        int n;
        super.paintGraphics2D(graphics2D);
        if (this.mFrameLinesVisibleFlag) {
            this.drawGraphAreaBoundsLines(graphics2D);
        }
        for (n = 0; n < this.mElementsGroupList.size(); ++n) {
            object = (ElementsGroupOfAxis)this.mElementsGroupList.get(n);
            if (!((ElementsGroupOfAxis)object).isVisible()) continue;
            ((ElementsGroupOfAxis)object).paintGraphics2D(graphics2D);
        }
        for (n = 0; n < this.mAxisBreakSymbolList.size(); ++n) {
            object = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(n);
            if (!((SGDrawingElement)object).isVisible()) continue;
            ((SGAxisBreakingSymbol2D)object).drawSymbol(graphics2D);
            if (!((AxisBreakSymbol)object).mFrameFlag) continue;
            ((AxisBreakSymbol)object).drawBoundingBox(graphics2D);
        }
    }

    public boolean chkBoundsVisible() {
        return true;
    }

    private boolean drawGraphAreaBoundsLines(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return false;
        }
        graphics2D.setPaint(this.mFrameLineColor);
        graphics2D.setStroke(new BasicStroke(this.mMagnification * this.mFrameLineWidth));
        graphics2D.drawRect((int)this.mGraphAreaX, (int)this.mGraphAreaY, (int)this.mGraphAreaWidth, (int)this.mGraphAreaHeight);
        return true;
    }

    private boolean drawStringBounds(SGDrawingElementString2D sGDrawingElementString2D, Graphics2D graphics2D) {
        if (sGDrawingElementString2D == null || graphics2D == null) {
            return false;
        }
        Color color = Color.BLACK;
        graphics2D.setPaint(color);
        graphics2D.setStroke(new BasicStroke(1.0f));
        Rectangle2D rectangle2D = sGDrawingElementString2D.getElementBounds();
        graphics2D.drawRect((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        return true;
    }

    private boolean drawString(SGDrawingElementString2D sGDrawingElementString2D, Graphics2D graphics2D) {
        if (sGDrawingElementString2D == null || graphics2D == null) {
            return false;
        }
        sGDrawingElementString2D.drawString(graphics2D);
        return true;
    }

    private boolean drawLine(SGDrawingElementLine2D sGDrawingElementLine2D, Graphics2D graphics2D) {
        if (sGDrawingElementLine2D == null || graphics2D == null) {
            return false;
        }
        graphics2D.setPaint(sGDrawingElementLine2D.getColor(0));
        graphics2D.setStroke(new BasicStroke(this.mMagnification * sGDrawingElementLine2D.getLineWidth()));
        SGTuple2f sGTuple2f = sGDrawingElementLine2D.getStart();
        SGTuple2f sGTuple2f2 = sGDrawingElementLine2D.getEnd();
        Line2D.Float float_ = new Line2D.Float(sGTuple2f.x, sGTuple2f.y, sGTuple2f2.x, sGTuple2f2.y);
        graphics2D.draw(float_);
        return true;
    }

    private boolean drawLine(double d, boolean bl, Graphics2D graphics2D) {
        double d2;
        if (graphics2D == null) {
            return false;
        }
        Point2D.Double double_ = null;
        Point2D.Double double_2 = null;
        if (bl) {
            d2 = d;
            double_ = new Point2D.Double(d2, 0.0);
            double_2 = new Point2D.Double(d2, this.getHeight());
        } else {
            d2 = d;
            double_ = new Point2D.Double(0.0, d2);
            double_2 = new Point2D.Double(this.getWidth(), d2);
        }
        Line2D.Double double_3 = new Line2D.Double(double_, double_2);
        graphics2D.draw(double_3);
        return true;
    }

    private boolean drawAxisBreakingSymbol(Graphics2D graphics2D) {
        return true;
    }

    public ArrayList getAxisList() {
        ArrayList<SGAxis> arrayList = new ArrayList<SGAxis>();
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            arrayList.add(elementsGroupOfAxis.mAxis);
        }
        return arrayList;
    }

    public ArrayList getXAxisList() {
        ArrayList arrayList = new ArrayList();
        switch (this.mViewDirection) {
            case 0: {
                arrayList = this.getHorizontalAxisList();
                break;
            }
            case 1: {
                arrayList = this.getHorizontalAxisList();
                break;
            }
            case 2: {
                arrayList = this.getNormalAxisList();
                break;
            }
        }
        return arrayList;
    }

    public ArrayList getYAxisList() {
        ArrayList arrayList = new ArrayList();
        switch (this.mViewDirection) {
            case 0: {
                arrayList = this.getPerpendicularAxisList();
                break;
            }
            case 1: {
                arrayList = this.getNormalAxisList();
                break;
            }
            case 2: {
                arrayList = this.getHorizontalAxisList();
                break;
            }
        }
        return arrayList;
    }

    public ArrayList getZAxisList() {
        ArrayList arrayList = new ArrayList();
        switch (this.mViewDirection) {
            case 0: {
                arrayList = this.getNormalAxisList();
                break;
            }
            case 1: {
                arrayList = this.getPerpendicularAxisList();
                break;
            }
            case 2: {
                arrayList = this.getPerpendicularAxisList();
                break;
            }
            default: {
                throw new Error("not defined");
            }
        }
        return arrayList;
    }

    public ArrayList getHorizontalAxisList() {
        ArrayList<SGAxis> arrayList = new ArrayList<SGAxis>();
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            int n = this.getConfigurationInPlaneByCube(elementsGroupOfAxis.getConfigurationInCube());
            if (n != 1 && n != -1) continue;
            arrayList.add(elementsGroupOfAxis.mAxis);
        }
        return arrayList;
    }

    public ArrayList getPerpendicularAxisList() {
        ArrayList<SGAxis> arrayList = new ArrayList<SGAxis>();
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            int n = this.getConfigurationInPlaneByCube(elementsGroupOfAxis.getConfigurationInCube());
            if (n != 2 && n != -2) continue;
            arrayList.add(elementsGroupOfAxis.mAxis);
        }
        return arrayList;
    }

    public ArrayList getNormalAxisList() {
        ArrayList arrayList = this.getHorizontalAxisList();
        ArrayList arrayList2 = this.getPerpendicularAxisList();
        ArrayList arrayList3 = this.getAxisList();
        for (int i = arrayList3.size() - 1; i >= 0; --i) {
            SGAxis sGAxis = (SGAxis)arrayList3.get(i);
            if (!arrayList.contains(sGAxis) && !arrayList2.contains(sGAxis)) continue;
            arrayList3.remove(sGAxis);
        }
        return arrayList3;
    }

    public SGAxis getAxisInCube(int n) {
        ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroupInCube(n);
        if (elementsGroupOfAxis == null) {
            return null;
        }
        SGAxis sGAxis = elementsGroupOfAxis.mAxis;
        return sGAxis;
    }

    public SGAxis getAxisInPlane(int n) {
        ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroupInPlane(n);
        if (elementsGroupOfAxis == null) {
            return null;
        }
        SGAxis sGAxis = elementsGroupOfAxis.mAxis;
        return sGAxis;
    }

    private ElementsGroupOfAxis getAxisGroupInCube(int n) {
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            if (elementsGroupOfAxis.getConfigurationInCube() != n) continue;
            return elementsGroupOfAxis;
        }
        return null;
    }

    private ElementsGroupOfAxis getAxisGroupInPlane(int n) {
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            if (elementsGroupOfAxis.getConfigurationInPlane() != n) continue;
            return elementsGroupOfAxis;
        }
        return null;
    }

    public int getConfigurationInCube(SGAxis sGAxis) {
        if (sGAxis == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            SGAxis sGAxis2 = elementsGroupOfAxis.mAxis;
            if (!sGAxis2.equals(sGAxis)) continue;
            n = elementsGroupOfAxis.getConfigurationInCube();
            return n;
        }
        return n;
    }

    public int getConfigurationInPlane(SGAxis sGAxis) {
        if (sGAxis == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            SGAxis sGAxis2 = elementsGroupOfAxis.mAxis;
            if (!sGAxis2.equals(sGAxis)) continue;
            n = elementsGroupOfAxis.getConfigurationInPlane();
            return n;
        }
        return n;
    }

    public int getConfigurationInPlaneByCube(int n) {
        int n2 = 0;
        block0 : switch (this.mViewDirection) {
            case 0: {
                switch (n) {
                    case 1: {
                        n2 = 1;
                        break block0;
                    }
                    case 2: {
                        n2 = -1;
                        break block0;
                    }
                    case 3: {
                        n2 = -1;
                        break block0;
                    }
                    case 4: {
                        n2 = 1;
                        break block0;
                    }
                    case 5: {
                        n2 = 2;
                        break block0;
                    }
                    case 6: {
                        n2 = 2;
                        break block0;
                    }
                    case 7: {
                        n2 = -2;
                        break block0;
                    }
                    case 8: {
                        n2 = -2;
                        break block0;
                    }
                }
                n2 = -1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new Error("not defined");
            }
        }
        return n2;
    }

    private int getConfigurationInCubeByPlane(int n) {
        int n2 = 0;
        block0 : switch (this.mViewDirection) {
            case 0: {
                switch (n) {
                    case 1: {
                        n2 = 1;
                        break block0;
                    }
                    case -1: {
                        n2 = 2;
                        break block0;
                    }
                    case 2: {
                        n2 = 5;
                        break block0;
                    }
                    case -2: {
                        n2 = 8;
                        break block0;
                    }
                }
                n2 = -1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new Error("not defined");
            }
        }
        return n2;
    }

    public String getConfigurationStringInPlaneByCube(int n) {
        int n2 = this.getConfigurationInPlaneByCube(n);
        String string = null;
        switch (n2) {
            case 1: {
                string = "Bottom";
                break;
            }
            case -1: {
                string = "Top";
                break;
            }
            case 2: {
                string = "Left";
                break;
            }
            case -2: {
                string = "Right";
                break;
            }
            default: {
                throw new Error();
            }
        }
        return string;
    }

    public int getConfigurationInCubeFromStringInPlane(String string) {
        int n;
        if (string.equals("Bottom")) {
            n = 1;
        } else if (string.equals("Top")) {
            n = -1;
        } else if (string.equals("Left")) {
            n = 2;
        } else if (string.equals("Right")) {
            n = -2;
        } else {
            throw new Error();
        }
        int n2 = this.getConfigurationInCubeByPlane(n);
        return n2;
    }

    public String toString() {
        return new String("SGAxisElement");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        boolean bl = true;
        if (string.equals("OK") || this.mDialog.getActiveComponentList().contains(object)) {
            bl = this.onOK();
        } else if (string.equals("Cancel")) {
            bl = this.onCanceled();
        } else if (string.equals("Preview")) {
            bl = this.onPreviewed();
        }
        if (!bl) {
            return;
        }
    }

    private boolean onOK() {
        if (!this.setPropertyWithDialog()) {
            return false;
        }
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.updateHistory();
        }
        this.mTemporaryProperties = null;
        this.mDialog.hide();
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    private boolean onCanceled() {
        boolean bl = this.recover();
        if (!bl) {
            return false;
        }
        this.mTemporaryProperties = null;
        this.mDialog.hide();
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    private boolean onPreviewed() {
        if (!this.setPropertyWithDialog()) {
            return false;
        }
        if (!this.createAllDrawingElements()) {
            return false;
        }
        if (!this.setDialogProperty()) {
            return false;
        }
        this.notifyChange();
        return true;
    }

    public boolean recover() {
        return this.setProperties(this.mTemporaryProperties);
    }

    public boolean undo() {
        boolean bl = super.undo();
        if (!bl) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    public boolean redo() {
        boolean bl = super.redo();
        if (!bl) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    public boolean addPropertiesHistory(SGProperties sGProperties) {
        if (!(sGProperties instanceof AxisProperties)) {
            return false;
        }
        boolean bl = super.addPropertiesHistory(sGProperties);
        return bl;
    }

    private AxisCommonProperties getCommonPropertiesFromDialog() {
        AxisDialog axisDialog = this.mDialog;
        AxisCommonProperties axisCommonProperties = axisDialog.getCommonProperties();
        return axisCommonProperties;
    }

    private AxisProperties getPropertiesFromDialog() {
        Object object;
        AxisProperties axisProperties = new AxisProperties();
        AxisCommonProperties axisCommonProperties = this.getCommonPropertiesFromDialog();
        if (axisCommonProperties == null) {
            return null;
        }
        axisProperties.cp = axisCommonProperties;
        axisProperties.ipArray = new AxisIndividualProperties[this.mElementsGroupList.size()];
        for (int i = 0; i < axisProperties.ipArray.length; ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            object = elementsGroupOfAxis.getPropertiesFromDialog();
            if (object == null) {
                return null;
            }
            axisProperties.ipArray[i] = object;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.mAxisBreakSymbolList.size(); ++i) {
            object = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(i);
            if (!((SGDrawingElement)object).isVisible()) continue;
            arrayList.add(object);
        }
        axisProperties.visibleAxisBreakSymbolList = arrayList;
        return axisProperties;
    }

    private boolean setPropertyWithDialog() {
        AxisProperties axisProperties = this.getPropertiesFromDialog();
        if (axisProperties == null) {
            return false;
        }
        return this.setProperties(axisProperties);
    }

    private float getMaxLengthOfScaleNumbers(ElementsGroupOfAxis elementsGroupOfAxis) {
        ArrayList arrayList = elementsGroupOfAxis.mScaleNumberList;
        double d = Double.MIN_VALUE;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            Rectangle2D rectangle2D = sGDrawingElementString2D.getElementBounds();
            double d2 = rectangle2D.getWidth();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return (float)d;
    }

    private boolean createAllDrawingElements() {
        for (int i = 0; i < this.mElementsGroupList.size(); ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            if (elementsGroupOfAxis.createDrawingElements()) continue;
            return false;
        }
        return true;
    }

    private boolean setLocationOfAllDrawingElements() {
        Object object;
        int n;
        for (n = 0; n < this.mElementsGroupList.size(); ++n) {
            object = (ElementsGroupOfAxis)this.mElementsGroupList.get(n);
            if (!((ElementsGroupOfAxis)object).isVisible() || ((ElementsGroupOfAxis)object).setLocationOfDrawingElements()) continue;
            return false;
        }
        for (n = 0; n < this.mAxisBreakSymbolList.size(); ++n) {
            object = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(n);
            ((SGAxisBreakingSymbol2D)object).create();
        }
        return true;
    }

    public boolean createDataObject(BufferedReader bufferedReader, SGData sGData) throws IOException {
        return super.createDataObject(bufferedReader, sGData);
    }

    public boolean writeProperty(Writer writer) throws IOException {
        Object object;
        int n;
        writer.write("[Axis]\n");
        SGUtilityText.writePropertyLine(writer, "Axis Line Width", new Float(this.mAxisLineWidth));
        SGUtilityText.writePropertyLine(writer, "Scale Line Width", new Float(this.mScaleLineWidth));
        SGUtilityText.writePropertyLine(writer, "Scale Line Length", new Float(this.mScaleLineLength * 0.035277776f));
        SGUtilityText.writeColorPropertyLine(writer, "Line Color", this.mLineColor);
        SGUtilityText.writePropertyLine(writer, "Font Family Name", this.mTitleFontFamilyName);
        SGUtilityText.writePropertyLine(writer, "Font Size", new Float(this.mTitleFontSize));
        SGUtilityText.writePropertyLine(writer, "Font Style", SGUtilityText.getFontStyleName(this.mTitleFontStyle));
        SGUtilityText.writeColorPropertyLine(writer, "String Color", this.mStringColor);
        SGUtilityText.writePropertyLine(writer, "Frame Lines Visible", new Boolean(this.mFrameLinesVisibleFlag));
        SGUtilityText.writePropertyLine(writer, "Frame Line Width", new Float(this.mFrameLineWidth));
        SGUtilityText.writeColorPropertyLine(writer, "Frame Line Color", this.mFrameLineColor);
        writer.write("\n");
        for (n = 0; n < this.mElementsGroupList.size(); ++n) {
            object = (ElementsGroupOfAxis)this.mElementsGroupList.get(n);
            ((ElementsGroupOfAxis)object).writeProperty(writer);
        }
        for (n = 0; n < this.mTimingElementGroupSetList.size(); ++n) {
            object = (TimingElementGroupSetInAxis)this.mTimingElementGroupSetList.get(n);
            ((TimingElementGroupSetInAxis)object).writeProperty(writer);
        }
        for (n = 0; n < this.mAxisBreakSymbolList.size(); ++n) {
            object = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(n);
            ((AxisBreakSymbol)object).writeProperty(writer);
        }
        return true;
    }

    public boolean readProperty(BufferedReader bufferedReader) throws IOException {
        ElementsGroupOfAxis elementsGroupOfAxis = null;
        elementsGroupOfAxis = this.addAxisGroup(1);
        if (elementsGroupOfAxis == null) {
            return false;
        }
        elementsGroupOfAxis = this.addAxisGroup(2);
        if (elementsGroupOfAxis == null) {
            return false;
        }
        elementsGroupOfAxis = this.addAxisGroup(5);
        if (elementsGroupOfAxis == null) {
            return false;
        }
        elementsGroupOfAxis = this.addAxisGroup(8);
        if (elementsGroupOfAxis == null) {
            return false;
        }
        boolean bl = this.createDialog();
        if (!bl) {
            return false;
        }
        bl = this.setProperty(bufferedReader);
        return bl;
    }

    private AxisCommonProperties readCommonProperties(BufferedReader bufferedReader) {
        AxisCommonProperties axisCommonProperties = new AxisCommonProperties();
        String string = null;
        try {
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Double d = SGUtilityText.getDoublePropertyFromLine(string, "Axis Line Width");
            if (d == null) {
                return null;
            }
            axisCommonProperties.axisLineWidth = d.floatValue();
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Double d2 = SGUtilityText.getDoublePropertyFromLine(string, "Scale Line Width");
            axisCommonProperties.scaleLineWidth = d2.floatValue();
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Double d3 = SGUtilityText.getDoublePropertyFromLine(string, "Scale Line Length");
            if (d3 == null) {
                return null;
            }
            axisCommonProperties.scaleLineLength = d3.floatValue() / 0.035277776f;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Color color = SGUtilityText.getColorPropertyFromLine(string, "Line Color");
            if (color == null) {
                return null;
            }
            axisCommonProperties.lineColor = color;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            String string2 = SGUtilityText.getPropertyFromLine(string, "Font Family Name");
            if (string2 == null) {
                return null;
            }
            axisCommonProperties.fontFamilyName = string2;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Double d4 = SGUtilityText.getDoublePropertyFromLine(string, "Font Size");
            if (d4 == null) {
                return null;
            }
            axisCommonProperties.fontSize = d4.floatValue();
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Integer n = SGUtilityText.getFontStyleFromLine(string, "Font Style");
            if (n == null) {
                return null;
            }
            axisCommonProperties.fontStyle = n;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Color color2 = SGUtilityText.getColorPropertyFromLine(string, "String Color");
            if (color2 == null) {
                return null;
            }
            axisCommonProperties.stringColor = color2;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Boolean bl = SGUtilityText.getBooleanPropertyFromLine(string, "Frame Lines Visible");
            if (bl == null) {
                return null;
            }
            axisCommonProperties.frameLinesVisibleFlag = bl;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Double d5 = SGUtilityText.getDoublePropertyFromLine(string, "Frame Line Width");
            if (d5 == null) {
                return null;
            }
            axisCommonProperties.frameLineWidth = d5.floatValue();
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Color color3 = SGUtilityText.getColorPropertyFromLine(string, "Frame Line Color");
            if (color3 == null) {
                return null;
            }
            axisCommonProperties.frameLineColor = color3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return axisCommonProperties;
    }

    private AxisIndividualProperties readIndividualProperties(BufferedReader bufferedReader) {
        AxisIndividualProperties axisIndividualProperties = new AxisIndividualProperties();
        String string = null;
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            String string2 = SGUtilityText.getPropertyFromLine(string, "Location");
            if (string2 == null) {
                return null;
            }
            axisIndividualProperties.configuration = this.getConfigurationInCubeFromStringInPlane(string2);
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Integer n = SGUtilityText.getScaleTypeFromLine(string, "Axis Scale Type");
            if (n == null) {
                return null;
            }
            axisIndividualProperties.scaleType = n;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Double d = SGUtilityText.getDoublePropertyFromLine(string, "Axis Min Value");
            if (d == null) {
                return null;
            }
            axisIndividualProperties.minValue = d;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Double d2 = SGUtilityText.getDoublePropertyFromLine(string, "Axis Max Value");
            if (d2 == null) {
                return null;
            }
            axisIndividualProperties.maxValue = d2;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Boolean bl4 = SGUtilityText.getBooleanPropertyFromLine(string, "Auto Calculation Axis Number");
            if (bl4 == null) {
                return null;
            }
            axisIndividualProperties.autoCalcAxisNumberFlag = bl3 = bl4.booleanValue();
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Double d3 = SGUtilityText.getDoublePropertyFromLine(string, "Increment Value");
            if (d3 != null) {
                axisIndividualProperties.incrementValue = d3;
            }
            if ((string = SGUtilityText.readLine(bufferedReader)) == null) {
                return null;
            }
            Double d4 = SGUtilityText.getDoublePropertyFromLine(string, "Increment Reference Value");
            if (d4 != null) {
                axisIndividualProperties.baseTickValue = d4;
            }
            if ((string = SGUtilityText.readLine(bufferedReader)) == null) {
                return null;
            }
            Boolean bl5 = SGUtilityText.getBooleanPropertyFromLine(string, "Axis Visible");
            if (bl5 == null) {
                return null;
            }
            axisIndividualProperties.axisVisibleFlag = bl2 = bl5.booleanValue();
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Boolean bl6 = SGUtilityText.getBooleanPropertyFromLine(string, "Title Visible");
            if (bl6 == null) {
                return null;
            }
            axisIndividualProperties.titleVisibleFlag = bl = bl6.booleanValue();
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            String string3 = SGUtilityText.getStringPropertyFromLine(string, "Title String");
            if (string3 == null) {
                return null;
            }
            axisIndividualProperties.titleString = string3;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Boolean bl7 = SGUtilityText.getBooleanPropertyFromLine(string, "Scale Numbers Visible");
            if (bl7 == null) {
                return null;
            }
            axisIndividualProperties.scaleNumbersVisibleFlag = bl7;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Boolean bl8 = SGUtilityText.getBooleanPropertyFromLine(string, "Scale Numbers Integer");
            if (bl8 == null) {
                return null;
            }
            axisIndividualProperties.scaleNumbersIntegerFlag = bl8;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Boolean bl9 = SGUtilityText.getBooleanPropertyFromLine(string, "Scale Lines Visible");
            if (bl9 == null) {
                return null;
            }
            axisIndividualProperties.scaleLinesVisibleFlag = bl9;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Boolean bl10 = SGUtilityText.getBooleanPropertyFromLine(string, "Scale Lines Inside");
            if (bl10 == null) {
                return null;
            }
            axisIndividualProperties.scaleLinesInsideFlag = bl10;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Boolean bl11 = SGUtilityText.getBooleanPropertyFromLine(string, "Exponent");
            if (bl11 == null) {
                return null;
            }
            axisIndividualProperties.exponentFlag = bl11;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return null;
            }
            Integer n2 = SGUtilityText.getIntegerPropertyFromLine(string, "Exponent Value");
            if (n2 == null) {
                return null;
            }
            axisIndividualProperties.exponentValue = n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return axisIndividualProperties;
    }

    private boolean setProperty(BufferedReader bufferedReader) throws IOException {
        Object object;
        Object object2;
        String string = null;
        AxisCommonProperties axisCommonProperties = this.readCommonProperties(bufferedReader);
        if (axisCommonProperties == null) {
            return false;
        }
        boolean bl = this.setCommonProperties(axisCommonProperties);
        if (!bl) {
            return false;
        }
        bufferedReader.mark(256);
        while (true) {
            if ((string = SGUtilityText.readLine(bufferedReader)) == null) {
                bufferedReader.reset();
                break;
            }
            if (!string.equals("<Axis>")) {
                bufferedReader.reset();
                break;
            }
            object2 = this.readIndividualProperties(bufferedReader);
            object = this.getAxisGroupInCube(((AxisIndividualProperties)object2).configuration);
            bl = ((ElementsGroupOfAxis)object).setProperties((AxisIndividualProperties)object2);
            if (!bl) {
                return false;
            }
            if (!((ElementsGroupOfAxis)object).createDrawingElements()) {
                return false;
            }
            bufferedReader.mark(256);
        }
        bufferedReader.mark(256);
        while (true) {
            if ((string = SGUtilityText.readLine(bufferedReader)) == null) {
                bufferedReader.reset();
                break;
            }
            if (!string.equals("<Timing Element>")) {
                bufferedReader.reset();
                break;
            }
            object2 = new TimingElementGroupSetInAxis();
            ((TimingElementGroupSetInAxis)object2).readProperty(bufferedReader);
            this.mTimingElementGroupSetList.add(object2);
            bufferedReader.mark(256);
        }
        bufferedReader.mark(256);
        while (true) {
            if ((string = SGUtilityText.readLine(bufferedReader)) == null) {
                bufferedReader.reset();
                break;
            }
            if (!string.equals("[Axis Break]")) {
                bufferedReader.reset();
                break;
            }
            object2 = this.readPropertiesOfAxisBreakSymbol(bufferedReader);
            if (object2 == null) {
                return false;
            }
            object = new AxisBreakSymbol();
            if (!((SGAxisBreakingSymbol)object).setProperties((SGProperties)object2)) {
                return false;
            }
            ((SGAxisBreakingSymbol2D)object).create();
            this.mAxisBreakSymbolList.add(object);
            ((AxisBreakSymbol)object).initPropertiesHistory();
            bufferedReader.mark(256);
        }
        return true;
    }

    private SGAxisBreakingSymbol.AxisBreakSymbolProperties readPropertiesOfAxisBreakSymbol(BufferedReader bufferedReader) throws IOException {
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d = SGUtilityText.getDoublePropertyFromLine(string, "X");
        if (d == null) {
            return null;
        }
        float f = d.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d2 = SGUtilityText.getDoublePropertyFromLine(string, "Y");
        if (d2 == null) {
            return null;
        }
        float f2 = d2.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d3 = SGUtilityText.getDoublePropertyFromLine(string, "Length");
        if (d3 == null) {
            return null;
        }
        float f3 = d3.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d4 = SGUtilityText.getDoublePropertyFromLine(string, "Interval");
        if (d4 == null) {
            return null;
        }
        float f4 = d4.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d5 = SGUtilityText.getDoublePropertyFromLine(string, "Distortion");
        if (d5 == null) {
            return null;
        }
        float f5 = d5.floatValue();
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d6 = SGUtilityText.getDoublePropertyFromLine(string, "Angle");
        if (d6 == null) {
            return null;
        }
        float f6 = d6.floatValue() * ((float)Math.PI / 180);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d7 = SGUtilityText.getDoublePropertyFromLine(string, "Line Width");
        if (d7 == null) {
            return null;
        }
        float f7 = d7.floatValue();
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Boolean bl = SGUtilityText.getBooleanPropertyFromLine(string, "Horizontal");
        if (bl == null) {
            return null;
        }
        boolean bl2 = bl;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Color color = SGUtilityText.getColorPropertyFromLine(string, "Line Color");
        if (color == null) {
            return null;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Color color2 = SGUtilityText.getColorPropertyFromLine(string, "Inner Color");
        if (color2 == null) {
            return null;
        }
        SGAxisBreakingSymbol.AxisBreakSymbolProperties axisBreakSymbolProperties = new SGAxisBreakingSymbol.AxisBreakSymbolProperties();
        axisBreakSymbolProperties.setX(f);
        axisBreakSymbolProperties.setY(f2);
        axisBreakSymbolProperties.setLength(f3);
        axisBreakSymbolProperties.setInterval(f4);
        axisBreakSymbolProperties.setDistortion(f5);
        axisBreakSymbolProperties.setAngle(f6);
        axisBreakSymbolProperties.setLineWidth(f7);
        axisBreakSymbolProperties.setHorizontal(bl2);
        axisBreakSymbolProperties.setLineColor(color);
        axisBreakSymbolProperties.setColor(color2);
        axisBreakSymbolProperties.setVisible(true);
        return axisBreakSymbolProperties;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object.equals(this.mDialog)) {
            this.onCanceled();
        }
    }

    public SGProperties getProperties() {
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.cp = this.getCommonProperties();
        axisProperties.ipArray = new AxisIndividualProperties[this.mElementsGroupList.size()];
        for (int i = 0; i < axisProperties.ipArray.length; ++i) {
            ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)this.mElementsGroupList.get(i);
            axisProperties.ipArray[i] = elementsGroupOfAxis.getProperties();
        }
        axisProperties.visibleAxisBreakSymbolList = this.getVisibleAxisBreakSymbolList();
        return axisProperties;
    }

    protected ArrayList getVisibleAxisBreakSymbolList() {
        ArrayList<AxisBreakSymbol> arrayList = new ArrayList<AxisBreakSymbol>();
        for (int i = 0; i < this.mAxisBreakSymbolList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(i);
            if (!axisBreakSymbol.isVisible()) continue;
            arrayList.add(axisBreakSymbol);
        }
        return arrayList;
    }

    public boolean setProperties(SGProperties sGProperties) {
        int n;
        if (!(sGProperties instanceof AxisProperties)) {
            return false;
        }
        AxisProperties axisProperties = (AxisProperties)sGProperties;
        if (!this.setCommonProperties(axisProperties.cp)) {
            return false;
        }
        AxisIndividualProperties[] axisIndividualPropertiesArray = axisProperties.ipArray;
        for (n = 0; n < axisIndividualPropertiesArray.length; ++n) {
            ElementsGroupOfAxis elementsGroupOfAxis = this.getAxisGroupInCube(axisIndividualPropertiesArray[n].configuration);
            if (elementsGroupOfAxis.setProperties(axisIndividualPropertiesArray[n])) continue;
            return false;
        }
        n = this.setVisibleAxisBreakSymbols(axisProperties.visibleAxisBreakSymbolList) ? 1 : 0;
        return n != 0;
    }

    protected boolean setVisibleAxisBreakSymbols(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        for (int i = 0; i < this.mAxisBreakSymbolList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(i);
            axisBreakSymbol.setVisible(arrayList.contains(axisBreakSymbol));
        }
        return true;
    }

    private AxisCommonProperties getCommonProperties() {
        AxisCommonProperties axisCommonProperties = new AxisCommonProperties();
        axisCommonProperties.viewDirection = this.mViewDirection;
        axisCommonProperties.frameLinesVisibleFlag = this.mFrameLinesVisibleFlag;
        axisCommonProperties.frameLineWidth = this.mFrameLineWidth;
        axisCommonProperties.frameLineColor = this.mFrameLineColor;
        axisCommonProperties.lineColor = this.mLineColor;
        axisCommonProperties.stringColor = this.mStringColor;
        axisCommonProperties.axisLineWidth = this.mAxisLineWidth;
        axisCommonProperties.scaleLineWidth = this.mScaleLineWidth;
        axisCommonProperties.scaleLineLength = this.mScaleLineLength;
        axisCommonProperties.fontSize = this.mTitleFontSize;
        axisCommonProperties.fontFamilyName = this.mTitleFontFamilyName;
        axisCommonProperties.fontStyle = this.mTitleFontStyle;
        return axisCommonProperties;
    }

    private boolean setCommonProperties(AxisCommonProperties axisCommonProperties) {
        this.mViewDirection = axisCommonProperties.viewDirection;
        this.setFrameLinesVisible(axisCommonProperties.frameLinesVisibleFlag);
        this.setFrameLineWidth(axisCommonProperties.frameLineWidth);
        this.setFrameLineColor(axisCommonProperties.frameLineColor);
        this.setLineColor(axisCommonProperties.lineColor);
        this.setStringColor(axisCommonProperties.stringColor);
        this.setAxisLineWidth(axisCommonProperties.axisLineWidth);
        this.setScaleLineWidth(axisCommonProperties.scaleLineWidth);
        this.setScaleLineLength(axisCommonProperties.scaleLineLength);
        this.setFontSize(axisCommonProperties.fontSize);
        this.setFontFamilyName(axisCommonProperties.fontFamilyName);
        this.setFontStyle(axisCommonProperties.fontStyle);
        return true;
    }

    public class AxisBreakSymbol
    extends SGAxisBreakingSymbol2D
    implements ActionListener,
    SGIPropertySettingListener,
    SGIUndoable {
        protected boolean mFrameFlag = false;
        protected SGProperties mTemporaryProperties = null;
        private JPopupMenu mPopupMenu = new JPopupMenu();
        private ArrayList mSigDiffSymbolPropertyHistoryList = new ArrayList();
        private int mStringElementStateCounter = 0;
        private int mCurrentStateCounter = 0;
        protected ArrayList mUndoableObjectHistoryList = new ArrayList();

        protected AxisBreakSymbol() {
            this.init();
        }

        protected AxisBreakSymbol(float f, float f2, float f3, float f4, boolean bl) {
            super(f, f2, f3, f4, bl);
            this.init();
        }

        private boolean init() {
            this.createPopupMenu();
            return true;
        }

        private boolean createPopupMenu() {
            this.mPopupMenu.setBounds(0, 0, 100, 100);
            String[] stringArray = new String[]{SGAxisElement.REMOVE_AXIS_BREAK_SYMBOL};
            for (int i = 0; i < stringArray.length; ++i) {
                JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
                jMenuItem.addActionListener(this);
                this.mPopupMenu.add(jMenuItem);
            }
            return true;
        }

        public SGTuple2f getLocation() {
            float f = this.mMagnification * this.mLocation.x + SGAxisElement.this.mGraphAreaX;
            float f2 = this.mMagnification * this.mLocation.y + SGAxisElement.this.mGraphAreaY;
            return new SGTuple2f(f, f2);
        }

        public void setLocation(float f, float f2) {
            float f3 = f - this.getX();
            float f4 = f2 - this.getY();
            this.mLocation.x = (f - SGAxisElement.this.mGraphAreaX) / this.mMagnification;
            this.mLocation.y = (f2 - SGAxisElement.this.mGraphAreaY) / this.mMagnification;
            this.create();
        }

        public void setForm(float f, float f2, float f3, float f4, boolean bl) {
            super.setForm(f, f2, f3, f4, bl);
            this.create();
        }

        private void drawBoundingBox(Graphics2D graphics2D) {
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setPaint(Color.BLACK);
            graphics2D.draw(this.getElementBounds());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            if (string.equals(SGAxisElement.REMOVE_AXIS_BREAK_SYMBOL)) {
                this.setVisible(false);
                SGAxisElement.this.callParentUpdateHistory();
                SGAxisElement.this.mFocusedSymbol = null;
                SGAxisElement.this.notifyChange();
                return;
            }
        }

        protected boolean clickDrawingElements(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            if (this.contains(n2, n = mouseEvent.getY())) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                    return true;
                }
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    this.showProeprtyDialog();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                    SGAxisElement.this.showPopupMenu(this.mPopupMenu, n2, n);
                }
                return true;
            }
            return false;
        }

        public boolean writeProperty(Writer writer) throws IOException {
            writer.write("[Axis Break]\n");
            SGUtilityText.writePropertyLine(writer, "X", new Float(this.mLocation.x * 0.035277776f));
            SGUtilityText.writePropertyLine(writer, "Y", new Float(this.mLocation.y * 0.035277776f));
            SGUtilityText.writePropertyLine(writer, "Length", new Float(this.mLength * 0.035277776f));
            SGUtilityText.writePropertyLine(writer, "Interval", new Float(this.mInterval * 0.035277776f));
            SGUtilityText.writePropertyLine(writer, "Distortion", new Float(this.mDistortion));
            SGUtilityText.writePropertyLine(writer, "Angle", new Float(this.mAngle / ((float)Math.PI / 180)));
            SGUtilityText.writePropertyLine(writer, "Line Width", new Float(this.mLineWidth));
            SGUtilityText.writePropertyLine(writer, "Horizontal", new Boolean(this.mForHorizontalAxisFlag));
            SGUtilityText.writeColorPropertyLine(writer, "Line Color", this.mLineColor);
            SGUtilityText.writeColorPropertyLine(writer, "Inner Color", (Color)this.getColorList().get(0));
            writer.write("\n");
            return true;
        }

        private boolean showProeprtyDialog() {
            SGAxisBreakSymbolDialog sGAxisBreakSymbolDialog = SGAxisElement.this.mAxisBreakSymbolDialog;
            sGAxisBreakSymbolDialog.addPropertySettingListener(this);
            sGAxisBreakSymbolDialog.setLocation(SGAxisElement.this.mDialogOwner.getLocation());
            this.setDialogProperty();
            this.createTemporaryPropertyObject();
            sGAxisBreakSymbolDialog.show();
            sGAxisBreakSymbolDialog.removeAllPropertySettingListeners();
            return true;
        }

        private boolean setDialogProperty() {
            SGAxisBreakSymbolDialog sGAxisBreakSymbolDialog = SGAxisElement.this.mAxisBreakSymbolDialog;
            sGAxisBreakSymbolDialog.setLength(new Float(this.mLength * 0.035277776f));
            sGAxisBreakSymbolDialog.setInterval(new Float(this.mInterval * 0.035277776f));
            sGAxisBreakSymbolDialog.setDistortion(new Float(this.mDistortion));
            sGAxisBreakSymbolDialog.setAngle(new Float(this.mAngle / ((float)Math.PI / 180)));
            sGAxisBreakSymbolDialog.setLineWidth(new Float(this.mLineWidth));
            sGAxisBreakSymbolDialog.setHorizontal(this.mForHorizontalAxisFlag);
            sGAxisBreakSymbolDialog.setLineColor(this.mLineColor);
            sGAxisBreakSymbolDialog.setInnerColor(this.getColor(0));
            return true;
        }

        public boolean createTemporaryPropertyObject() {
            this.mTemporaryProperties = this.getProperties();
            return true;
        }

        public boolean commit() {
            if (!this.setPropertiesFromDialog()) {
                return false;
            }
            this.updateHistory();
            return true;
        }

        public boolean cancel() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            return this.create();
        }

        public boolean preview() {
            return this.setPropertiesFromDialog();
        }

        private boolean setPropertiesFromDialog() {
            SGAxisBreakSymbolDialog sGAxisBreakSymbolDialog = SGAxisElement.this.mAxisBreakSymbolDialog;
            SGAxisBreakingSymbol.AxisBreakSymbolProperties axisBreakSymbolProperties = sGAxisBreakSymbolDialog.getProperties();
            if (axisBreakSymbolProperties == null) {
                throw new Error();
            }
            axisBreakSymbolProperties.setProperty("Visible", new Boolean(true).toString());
            axisBreakSymbolProperties.setProperty("X", new Float(this.mLocation.x).toString());
            axisBreakSymbolProperties.setProperty("Y", new Float(this.mLocation.y).toString());
            if (!this.setProperties(axisBreakSymbolProperties)) {
                throw new Error();
            }
            if (!this.create()) {
                throw new Error();
            }
            SGAxisElement.this.repaint();
            return true;
        }

        public boolean initPropertiesHistory() {
            this.addSigDiffSymbolPropertyHistory(this.getProperties());
            return true;
        }

        private boolean addSigDiffSymbolPropertyHistory(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGAxisBreakingSymbol.AxisBreakSymbolProperties)) {
                return false;
            }
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mStringElementStateCounter; ++i) {
                arrayList.add(this.mSigDiffSymbolPropertyHistoryList.get(i));
            }
            arrayList.add(sGProperties);
            this.mSigDiffSymbolPropertyHistoryList = arrayList;
            return true;
        }

        public boolean undo() {
            --this.mStringElementStateCounter;
            SGAxisBreakingSymbol.AxisBreakSymbolProperties axisBreakSymbolProperties = (SGAxisBreakingSymbol.AxisBreakSymbolProperties)this.mSigDiffSymbolPropertyHistoryList.get(this.mStringElementStateCounter);
            this.setProperties(axisBreakSymbolProperties);
            this.create();
            return true;
        }

        public boolean redo() {
            ++this.mStringElementStateCounter;
            SGAxisBreakingSymbol.AxisBreakSymbolProperties axisBreakSymbolProperties = (SGAxisBreakingSymbol.AxisBreakSymbolProperties)this.mSigDiffSymbolPropertyHistoryList.get(this.mStringElementStateCounter);
            this.setProperties(axisBreakSymbolProperties);
            this.create();
            return true;
        }

        public boolean onUndo() {
            return this.undo();
        }

        public boolean onRedo() {
            return this.redo();
        }

        public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
            ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
            arrayList.add(sGIUndoable);
            boolean bl = this.updateObjectHistory(arrayList);
            return bl;
        }

        public boolean updateObjectHistory(ArrayList arrayList) {
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < this.mCurrentStateCounter; ++i) {
                Object e = this.mUndoableObjectHistoryList.get(i);
                arrayList2.add(e);
            }
            arrayList2.add(new ArrayList(arrayList));
            this.mUndoableObjectHistoryList = arrayList2;
            ++this.mCurrentStateCounter;
            return true;
        }

        public boolean updateHistory() {
            this.updateParentHistory();
            this.updateThisObjectHistory();
            return true;
        }

        public boolean updateThisObjectHistory() {
            this.updateObjectHistory(this);
            ++this.mStringElementStateCounter;
            this.addSigDiffSymbolPropertyHistory(this.getProperties());
            return true;
        }

        public boolean updateParentHistory() {
            return SGAxisElement.this.updateParentHistoryFromAxisBreakSymbol(this);
        }

        private boolean isChanged() {
            boolean bl = !this.getProperties().equals(this.mTemporaryProperties);
            return bl;
        }
    }

    class AxisDialog
    extends SGAxisDialog {
        protected AxisDialog(Frame frame, boolean bl) {
            super(frame, bl);
        }

        public ArrayList getActiveComponentList() {
            ArrayList arrayList = super.getActiveComponentList();
            for (int i = 0; i < SGAxisElement.this.mElementsGroupList.size(); ++i) {
                ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)SGAxisElement.this.mElementsGroupList.get(i);
                SGAxisPanel sGAxisPanel = elementsGroupOfAxis.mAxisPanel;
                ArrayList arrayList2 = sGAxisPanel.getActiveComponentList();
                for (int j = 0; j < arrayList2.size(); ++j) {
                    arrayList.add(arrayList2.get(j));
                }
            }
            return arrayList;
        }

        public boolean setActionListener(ActionListener actionListener) {
            super.setActionListener(actionListener);
            for (int i = 0; i < SGAxisElement.this.mElementsGroupList.size(); ++i) {
                ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)SGAxisElement.this.mElementsGroupList.get(i);
                elementsGroupOfAxis.mAxisPanel.setActionListener(actionListener);
            }
            return true;
        }

        public boolean removeActionListener() {
            super.removeActionListener();
            for (int i = 0; i < SGAxisElement.this.mElementsGroupList.size(); ++i) {
                ElementsGroupOfAxis elementsGroupOfAxis = (ElementsGroupOfAxis)SGAxisElement.this.mElementsGroupList.get(i);
                elementsGroupOfAxis.mAxisPanel.removeActionListener();
            }
            return true;
        }
    }

    public static class AxisIndividualProperties
    extends SGProperties {
        int configuration;
        int scaleType;
        double minValue;
        double maxValue;
        boolean autoCalcAxisNumberFlag;
        double incrementValue;
        double baseTickValue;
        String titleString;
        boolean axisVisibleFlag;
        boolean titleVisibleFlag;
        boolean scaleLinesVisibleFlag;
        boolean scaleNumbersVisibleFlag;
        boolean scaleLinesInsideFlag;
        boolean scaleNumbersIntegerFlag;
        boolean exponentFlag;
        int exponentValue;

        public boolean equals(Object object) {
            if (!(object instanceof AxisIndividualProperties)) {
                return false;
            }
            AxisIndividualProperties axisIndividualProperties = (AxisIndividualProperties)object;
            if (axisIndividualProperties.configuration != this.configuration) {
                return false;
            }
            if (axisIndividualProperties.scaleType != this.scaleType) {
                return false;
            }
            if (axisIndividualProperties.minValue != this.minValue) {
                return false;
            }
            if (axisIndividualProperties.maxValue != this.maxValue) {
                return false;
            }
            if (axisIndividualProperties.autoCalcAxisNumberFlag != this.autoCalcAxisNumberFlag) {
                return false;
            }
            if (axisIndividualProperties.incrementValue != this.incrementValue) {
                return false;
            }
            if (axisIndividualProperties.baseTickValue != this.baseTickValue) {
                return false;
            }
            if (!axisIndividualProperties.titleString.equals(this.titleString)) {
                return false;
            }
            if (axisIndividualProperties.axisVisibleFlag != this.axisVisibleFlag) {
                return false;
            }
            if (axisIndividualProperties.titleVisibleFlag != this.titleVisibleFlag) {
                return false;
            }
            if (axisIndividualProperties.scaleLinesVisibleFlag != this.scaleLinesVisibleFlag) {
                return false;
            }
            if (axisIndividualProperties.scaleNumbersVisibleFlag != this.scaleNumbersVisibleFlag) {
                return false;
            }
            if (axisIndividualProperties.scaleLinesInsideFlag != this.scaleLinesInsideFlag) {
                return false;
            }
            if (axisIndividualProperties.scaleNumbersIntegerFlag != this.scaleNumbersIntegerFlag) {
                return false;
            }
            if (axisIndividualProperties.exponentFlag != this.exponentFlag) {
                return false;
            }
            return axisIndividualProperties.exponentValue == this.exponentValue;
        }
    }

    public static class AxisCommonProperties
    extends SGProperties {
        int viewDirection;
        boolean frameLinesVisibleFlag;
        float frameLineWidth;
        Color frameLineColor;
        Color lineColor;
        Color stringColor;
        float axisLineWidth;
        float scaleLineWidth;
        float scaleLineLength;
        float fontSize;
        String fontFamilyName;
        int fontStyle;

        public boolean equals(Object object) {
            if (!(object instanceof AxisCommonProperties)) {
                return false;
            }
            AxisCommonProperties axisCommonProperties = (AxisCommonProperties)object;
            if (axisCommonProperties.viewDirection != this.viewDirection) {
                return false;
            }
            if (axisCommonProperties.frameLinesVisibleFlag != this.frameLinesVisibleFlag) {
                return false;
            }
            if (axisCommonProperties.frameLineWidth != this.frameLineWidth) {
                return false;
            }
            if (!axisCommonProperties.frameLineColor.equals(this.frameLineColor)) {
                return false;
            }
            if (!axisCommonProperties.lineColor.equals(this.lineColor)) {
                return false;
            }
            if (!axisCommonProperties.stringColor.equals(this.stringColor)) {
                return false;
            }
            if (axisCommonProperties.axisLineWidth != this.axisLineWidth) {
                return false;
            }
            if (axisCommonProperties.scaleLineWidth != this.scaleLineWidth) {
                return false;
            }
            if (axisCommonProperties.scaleLineLength != this.scaleLineLength) {
                return false;
            }
            if (axisCommonProperties.fontSize != this.fontSize) {
                return false;
            }
            if (!axisCommonProperties.fontFamilyName.equals(this.fontFamilyName)) {
                return false;
            }
            return axisCommonProperties.fontStyle == this.fontStyle;
        }
    }

    public static class AxisProperties
    extends SGProperties {
        AxisCommonProperties cp;
        AxisIndividualProperties[] ipArray;
        ArrayList visibleAxisBreakSymbolList = new ArrayList();

        AxisProperties() {
        }

        public boolean equals(Object object) {
            if (!(object instanceof AxisProperties)) {
                return false;
            }
            AxisProperties axisProperties = (AxisProperties)object;
            if (!axisProperties.cp.equals(this.cp)) {
                return false;
            }
            if (axisProperties.ipArray.length != this.ipArray.length) {
                return false;
            }
            for (int i = 0; i < this.ipArray.length; ++i) {
                if (axisProperties.ipArray[i].equals(this.ipArray[i])) continue;
                return false;
            }
            return axisProperties.visibleAxisBreakSymbolList.equals(this.visibleAxisBreakSymbolList);
        }
    }

    class TimingElementGroupSetInAxis
    extends SGTimingElementGroupSet {
        protected TimingElementGroupSetInAxis() {
        }

        public boolean addDrawingElementGroup(int n) {
            TimingElementGroupLine timingElementGroupLine = null;
            if (n != 0) {
                throw new Error("");
            }
            timingElementGroupLine = new TimingElementGroupLine();
            timingElementGroupLine.mGroupSet = this;
            this.mDrawingElementGroupList.add(timingElementGroupLine);
            if (!((SGElementGroup)timingElementGroupLine).initDrawingElement(2)) {
                throw new Error();
            }
            return ((SGElementGroup)timingElementGroupLine).setPropertiesOfDrawingElements();
        }

        public boolean addDrawingElementGroup(SGDrawingElement sGDrawingElement) {
            TimingElementGroupLine timingElementGroupLine = null;
            if (!(sGDrawingElement instanceof SGDrawingElementLine)) {
                throw new Error("");
            }
            timingElementGroupLine = new TimingElementGroupLine();
            timingElementGroupLine.mGroupSet = this;
            if (!((SGElementGroup)timingElementGroupLine).setProperty(sGDrawingElement)) {
                return false;
            }
            this.mDrawingElementGroupList.add(timingElementGroupLine);
            return true;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
        }

        protected boolean clickDrawingElements(MouseEvent mouseEvent) {
            return false;
        }

        public boolean onDrawingElement(int n, int n2) {
            return false;
        }

        public boolean writeProperty(Writer writer) throws IOException {
            writer.write("<Timing Element>\n");
            int n = SGAxisElement.this.getConfigurationInCube(this.mAxis);
            SGUtilityText.writePropertyLine(writer, "Location", new Integer(n));
            SGUtilityText.writePropertyLine(writer, "Value", new Double(this.mValue.mValue));
            this.writePropertyOfData(writer);
            writer.write("\n");
            return true;
        }

        protected boolean readProperty(BufferedReader bufferedReader) throws IOException {
            SGAxis sGAxis;
            this.mDrawingElementGroupList.clear();
            String string = null;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return false;
            }
            Integer n = SGUtilityText.getIntegerPropertyFromLine(string, "Location");
            if (n == null) {
                return false;
            }
            int n2 = n;
            this.mAxis = sGAxis = SGAxisElement.this.getAxisInCube(n2);
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return false;
            }
            Double d = SGUtilityText.getDoublePropertyFromLine(string, "Value");
            if (d == null) {
                return false;
            }
            double d2 = d;
            if (this.mValue == null) {
                this.mValue = new SGDouble(d2);
            } else {
                this.mValue.mValue = d2;
            }
            bufferedReader.mark(256);
            while (true) {
                TimingElementGroupLine timingElementGroupLine = null;
                string = SGUtilityText.readLine(bufferedReader);
                if (string == null) {
                    return false;
                }
                if (!string.equals("<Line>")) break;
                timingElementGroupLine = new TimingElementGroupLine();
                timingElementGroupLine.mGroupSet = this;
                timingElementGroupLine.readProperty(bufferedReader);
                this.mDrawingElementGroupList.add(timingElementGroupLine);
                bufferedReader.mark(256);
            }
            bufferedReader.reset();
            return true;
        }
    }

    class ElementsGroupOfAxis {
        private int mConfigurationInCube = -1;
        private SGAxisElement mAxisElement = null;
        private SGAxis mAxis = null;
        private final ElementLineOfAxis mAxisLine = new ElementLineOfAxis();
        private final ElementStringOfTitle mTitle = new ElementStringOfTitle();
        private final ArrayList mScaleNumberList = new ArrayList();
        private final ArrayList mScaleLineList = new ArrayList();
        private boolean mVisibleFlag = true;
        private boolean mAxisLineVisibleFlag = true;
        private boolean mTitleVisibleFlag = true;
        private boolean mScaleNumbersVisibleFlag = true;
        private boolean mScaleLinesVisibleFlag = true;
        private boolean mScaleLinesInsideFlag = true;
        private double[] mAxisValueArray = null;
        private boolean mAutoCalcAxisNumberFlag = true;
        private final SGAxisPanel mAxisPanel = new SGAxisPanel();
        private double mIncrementValue = 0.0;
        private double mBaseTickValue = 0.0;
        private boolean mScaleNumbersIntegerFlag = false;
        private boolean mExponentFlag = false;
        private int mExponentValue = 0;
        private SGDrawingElementString2DExtended mExponentDrawingElement = null;
        private boolean mAxisNumberDraggingFlag = false;
        private SGDrawingElement mDraggingElement = null;
        private SGTuple2d mTempRange = null;

        protected ElementsGroupOfAxis() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.mScaleNumbersVisibleFlag = true;
            this.mScaleNumbersIntegerFlag = false;
            this.mScaleLinesVisibleFlag = true;
            this.mScaleLinesInsideFlag = true;
            return true;
        }

        private boolean setDialogProperty() {
            SGAxisPanel sGAxisPanel = this.mAxisPanel;
            sGAxisPanel.setTitleTextField(new String(this.mTitle.getString()));
            sGAxisPanel.setRange(this.mAxis.getRange());
            sGAxisPanel.setAutoCalcFlag(this.mAutoCalcAxisNumberFlag);
            sGAxisPanel.setIncrementValue(this.mIncrementValue);
            sGAxisPanel.setBaseTickValue(this.mBaseTickValue);
            sGAxisPanel.setScaleType(this.mAxis.getScaleType());
            sGAxisPanel.setAxisVisible(this.mVisibleFlag);
            sGAxisPanel.setTitleVisible(this.mTitleVisibleFlag);
            sGAxisPanel.setScaleLinesVisible(this.mScaleLinesVisibleFlag);
            sGAxisPanel.setScaleLinesInside(this.mScaleLinesInsideFlag);
            sGAxisPanel.setScaleNumbersVisible(this.mScaleNumbersVisibleFlag);
            sGAxisPanel.setScaleNumbersInteger(this.mScaleNumbersIntegerFlag);
            sGAxisPanel.setExponentFlag(this.mExponentFlag);
            sGAxisPanel.setExponentValue(this.mExponentValue);
            sGAxisPanel.setAxisPanelComponentsEnables(this.isVisible());
            return true;
        }

        private SGTuple2d getScaleFromDialog() {
            SGTuple2d sGTuple2d = this.mAxisPanel.getScale();
            if (sGTuple2d == null) {
                SGTuple2d sGTuple2d2 = this.mAxis.getRange();
                this.mAxisPanel.setRange(sGTuple2d2);
                sGTuple2d = sGTuple2d2;
            }
            return sGTuple2d;
        }

        private boolean addTimingLine(int n, int n2) {
            double d = 0.0;
            if (SGAxisElement.this.getHorizontalAxisList().contains(this.mAxis)) {
                d = SGAxisElement.this.calcValue(n, this.mAxis, true);
            } else if (SGAxisElement.this.getPerpendicularAxisList().contains(this.mAxis)) {
                d = SGAxisElement.this.calcValue(n2, this.mAxis, false);
            } else {
                throw new Error();
            }
            d = this.cutoffNumberInRangeOrder(d);
            TimingElementGroupSetInAxis timingElementGroupSetInAxis = new TimingElementGroupSetInAxis();
            timingElementGroupSetInAxis.mAxis = this.mAxis;
            timingElementGroupSetInAxis.mValue = new SGDouble(d);
            timingElementGroupSetInAxis.addDrawingElementGroup(0);
            SGAxisElement.this.mTimingElementGroupSetList.add(timingElementGroupSetInAxis);
            return true;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            if (this.mVisibleFlag) {
                int n;
                ArrayList arrayList;
                if (this.mAxisLineVisibleFlag) {
                    SGAxisElement.this.drawLine(this.mAxisLine, graphics2D);
                }
                if (this.mTitleVisibleFlag) {
                    SGAxisElement.this.drawString(this.mTitle, graphics2D);
                    if (this.mTitle.equals(SGAxisElement.this.mPressedElement)) {
                        SGAxisElement.this.drawStringBounds(this.mTitle, graphics2D);
                    }
                }
                if (this.mScaleNumbersVisibleFlag) {
                    arrayList = this.mScaleNumberList;
                    for (n = 0; n < arrayList.size(); ++n) {
                        ElementStringOfScale elementStringOfScale = (ElementStringOfScale)arrayList.get(n);
                        SGAxisElement.this.drawString(elementStringOfScale, graphics2D);
                    }
                    if (this.mDraggingElement != null && this.mDraggingElement instanceof ElementStringOfScale) {
                        ElementStringOfScale elementStringOfScale = (ElementStringOfScale)this.mDraggingElement;
                        SGAxisElement.this.drawString(elementStringOfScale, graphics2D);
                        SGAxisElement.this.drawStringBounds(elementStringOfScale, graphics2D);
                    }
                    if (this.mExponentFlag) {
                        SGAxisElement.this.drawString(this.mExponentDrawingElement, graphics2D);
                    }
                }
                if (this.mScaleLinesVisibleFlag) {
                    int n2;
                    ElementLineOfScale elementLineOfScale;
                    arrayList = this.mScaleLineList;
                    int n3 = n = this.mDraggingElement != null && this.mDraggingElement instanceof ElementLineOfScale ? 1 : 0;
                    if (n != 0) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            elementLineOfScale = (ElementLineOfScale)arrayList.get(i);
                            elementLineOfScale.setLineWidth(2.0f * SGAxisElement.this.mScaleLineWidth);
                        }
                    }
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        elementLineOfScale = (ElementLineOfScale)arrayList.get(n2);
                        SGAxisElement.this.drawLine(elementLineOfScale, graphics2D);
                    }
                    if (n != 0) {
                        for (n2 = 0; n2 < arrayList.size(); ++n2) {
                            elementLineOfScale = (ElementLineOfScale)arrayList.get(n2);
                            elementLineOfScale.setLineWidth(SGAxisElement.this.mScaleLineWidth);
                        }
                    }
                }
            }
        }

        private double getTitleHeight() {
            Rectangle2D rectangle2D = this.mTitle.getStringRect();
            return rectangle2D.getHeight();
        }

        private double getScaleHeight() {
            double d = 0.0;
            if (this.mScaleNumberList.size() == 0) {
                Font font = new Font(SGAxisElement.this.mScaleFontFamilyName, SGAxisElement.this.mScaleFontStyle, (int)(SGAxisElement.this.mMagnification * SGAxisElement.this.mScaleFontSize));
                Rectangle2D rectangle2D = font.getStringBounds("", new FontRenderContext(null, false, false));
                d = rectangle2D.getHeight();
            } else {
                SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)this.mScaleNumberList.get(0);
                Rectangle2D rectangle2D = sGDrawingElementString2D.getStringRect();
                d = rectangle2D.getHeight();
            }
            return d;
        }

        private boolean isVisible() {
            return this.mVisibleFlag;
        }

        private int getConfigurationInPlane() {
            return SGAxisElement.this.getConfigurationInPlaneByCube(this.mConfigurationInCube);
        }

        private int getConfigurationInCube() {
            return this.mConfigurationInCube;
        }

        private boolean setConfigurationInPlane(int n) {
            this.mConfigurationInCube = SGAxisElement.this.getConfigurationInCubeByPlane(n);
            return true;
        }

        private boolean setConfigurationInCube(int n) {
            this.mConfigurationInCube = n;
            return true;
        }

        public boolean zoom(float f) {
            SGDrawingElement sGDrawingElement;
            int n;
            this.mAxisLine.zoom(f);
            this.mTitle.zoom(f);
            for (n = 0; n < this.mScaleNumberList.size(); ++n) {
                sGDrawingElement = (ElementStringOfScale)this.mScaleNumberList.get(n);
                sGDrawingElement.zoom(f);
            }
            for (n = 0; n < this.mScaleLineList.size(); ++n) {
                sGDrawingElement = (ElementLineOfScale)this.mScaleLineList.get(n);
                sGDrawingElement.zoom(f);
            }
            return true;
        }

        private Rectangle2D getBoundingBox() {
            if (!this.isVisible()) {
                return null;
            }
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            ArrayList<SGDrawingElement> arrayList = new ArrayList<SGDrawingElement>();
            arrayList.add(this.mAxisLine);
            if (this.mTitleVisibleFlag) {
                arrayList.add(this.mTitle);
            }
            if (this.mScaleNumbersVisibleFlag) {
                for (int i = 0; i < this.mScaleNumberList.size(); ++i) {
                    arrayList.add((SGDrawingElement)this.mScaleNumberList.get(i));
                }
                if (this.mExponentFlag) {
                    arrayList.add(this.mExponentDrawingElement);
                }
            }
            if (arrayList.size() != 0) {
                ((Rectangle2D)float_).setRect(SGUtilityJava2D.getBoundingBox(arrayList));
            }
            return float_;
        }

        public boolean onMouseClicked(MouseEvent mouseEvent) {
            SGDrawingElement sGDrawingElement;
            int n;
            int n2;
            if (!this.mVisibleFlag) {
                return false;
            }
            int n3 = mouseEvent.getX();
            boolean bl = this.mAxisLine.contains(n3, n2 = mouseEvent.getY());
            if (bl) {
                return this.clicked(mouseEvent);
            }
            if (this.mTitleVisibleFlag && (bl = this.mTitle.contains(n3, n2))) {
                return this.clicked(mouseEvent);
            }
            if (this.mScaleNumbersVisibleFlag) {
                for (n = 0; n < this.mScaleNumberList.size(); ++n) {
                    sGDrawingElement = (ElementStringOfScale)this.mScaleNumberList.get(n);
                    bl = ((SGDrawingElementString2D)sGDrawingElement).contains(n3, n2);
                    if (!bl) continue;
                    return this.clicked(mouseEvent);
                }
            }
            if (this.mScaleLinesVisibleFlag) {
                for (n = 0; n < this.mScaleLineList.size(); ++n) {
                    sGDrawingElement = (ElementLineOfScale)this.mScaleLineList.get(n);
                    bl = ((SGDrawingElementLine2D)sGDrawingElement).contains(n3, n2);
                    if (!bl) continue;
                    return this.clicked(mouseEvent);
                }
            }
            return false;
        }

        public boolean contains(int n, int n2) {
            SGDrawingElement sGDrawingElement;
            int n3;
            boolean bl = this.mAxisLine.contains(n, n2);
            if (bl) {
                return true;
            }
            bl = this.mTitle.contains(n, n2);
            if (bl) {
                return true;
            }
            for (n3 = 0; n3 < this.mScaleNumberList.size(); ++n3) {
                sGDrawingElement = (ElementStringOfScale)this.mScaleNumberList.get(n3);
                bl = ((SGDrawingElementString2D)sGDrawingElement).contains(n, n2);
                if (!bl) continue;
                return true;
            }
            for (n3 = 0; n3 < this.mScaleLineList.size(); ++n3) {
                sGDrawingElement = (ElementLineOfScale)this.mScaleLineList.get(n3);
                bl = ((SGDrawingElementLine2D)sGDrawingElement).contains(n, n2);
                if (!bl) continue;
                return true;
            }
            return false;
        }

        private boolean clicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if ((!SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.getClickCount() != 1) && SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                SGAxisDialog sGAxisDialog = (SGAxisDialog)SGAxisElement.this.getDialog();
                sGAxisDialog.setSelectedPanel(this.mAxisPanel);
                sGAxisDialog.show();
            }
            return true;
        }

        public boolean onMousePressed(MouseEvent mouseEvent) {
            SGDrawingElement sGDrawingElement;
            int n;
            int n2;
            if (!this.mVisibleFlag) {
                return false;
            }
            int n3 = mouseEvent.getX();
            boolean bl = this.mAxisLine.contains(n3, n2 = mouseEvent.getY());
            if (bl) {
                return true;
            }
            if (this.mTitleVisibleFlag && (bl = this.mTitle.contains(n3, n2))) {
                SGAxisElement.this.mPressedElement = this.mTitle;
                SGAxisElement.this.mPressedElementOrigin = new Point((int)((float)mouseEvent.getX() - this.mTitle.getX()), (int)((float)mouseEvent.getY() - this.mTitle.getY()));
                return true;
            }
            if (this.mScaleNumbersVisibleFlag) {
                for (n = 0; n < this.mScaleNumberList.size(); ++n) {
                    sGDrawingElement = (ElementStringOfScale)this.mScaleNumberList.get(n);
                    if (!sGDrawingElement.isVisible() || !((SGDrawingElementString2D)sGDrawingElement).contains(n3, n2)) continue;
                    SGAxisElement.this.mPressedElement = sGDrawingElement;
                    SGAxisElement.this.mPressedElementOrigin = new Point((int)((float)mouseEvent.getX() - ((SGDrawingElementString)sGDrawingElement).getX()), (int)((float)mouseEvent.getY() - ((SGDrawingElementString)sGDrawingElement).getY()));
                    this.mTempRange = this.mAxis.getRange();
                    this.mDraggingElement = new ElementStringOfScale((ElementStringOfScale)sGDrawingElement);
                    this.mDraggingElement.setMagnification(sGDrawingElement.getMagnification());
                    this.mAxisNumberDraggingFlag = true;
                    return true;
                }
            }
            if (this.mScaleLinesVisibleFlag) {
                for (n = 0; n < this.mScaleLineList.size(); ++n) {
                    sGDrawingElement = (ElementLineOfScale)this.mScaleLineList.get(n);
                    if (!sGDrawingElement.isVisible() || !((SGDrawingElementLine2D)sGDrawingElement).contains(n3, n2)) continue;
                    SGAxisElement.this.mPressedElement = sGDrawingElement;
                    SGAxisElement.this.mPressedElementOrigin = mouseEvent.getPoint();
                    this.mTempRange = this.mAxis.getRange();
                    this.mDraggingElement = new ElementLineOfScale((ElementLineOfScale)sGDrawingElement);
                    this.mDraggingElement.setMagnification(sGDrawingElement.getMagnification());
                    return true;
                }
            }
            return false;
        }

        public boolean onMouseDragged(MouseEvent mouseEvent) {
            if (this.mDraggingElement == null || this.mTempRange == null) {
                return false;
            }
            int n = this.mAxis.getScaleType();
            if (this.mDraggingElement instanceof ElementStringOfScale) {
                double d;
                double d2;
                double d3;
                float f;
                double d4;
                double d5;
                double d6;
                double d7;
                ElementStringOfScale elementStringOfScale = (ElementStringOfScale)this.mDraggingElement;
                Rectangle2D rectangle2D = elementStringOfScale.getElementBounds();
                if (n == 0) {
                    d7 = this.mTempRange.x;
                    d6 = this.mTempRange.y;
                    d5 = elementStringOfScale.mValue;
                } else if (n == 1) {
                    d7 = Math.log(this.mTempRange.x) / Math.log(10.0);
                    d6 = Math.log(this.mTempRange.y) / Math.log(10.0);
                    d5 = Math.log(elementStringOfScale.mValue) / Math.log(10.0);
                } else {
                    throw new Error();
                }
                if (this.getConfigurationInPlane() == 1 || this.getConfigurationInPlane() == -1) {
                    d4 = (double)(mouseEvent.getX() - ((SGAxisElement)SGAxisElement.this).mPressedElementOrigin.x) + rectangle2D.getWidth() / 2.0;
                    f = this.mAxisLine.getStart().x;
                    float f2 = this.mAxisLine.getEnd().x;
                    float f3 = f2 - f;
                    if (d4 > (double)f2) {
                        d4 = f2;
                    }
                    if (d4 <= (double)f) {
                        return false;
                    }
                    double d8 = d7 + (d6 - d7) * (d4 - (double)f) / (double)(f2 - f);
                    d3 = d7;
                    d2 = d7 + (d6 - d7) * (d5 - d7) / (d8 - d7);
                    if (n == 0) {
                        d2 = this.cutoffNumberInRangeOrder(d2);
                    }
                    float f4 = (float)(d4 - rectangle2D.getWidth() / 2.0);
                    elementStringOfScale.setX(f4);
                    if (d2 - d3 < 0.05 * (d6 - d7)) {
                        return false;
                    }
                } else if (this.getConfigurationInPlane() == 2 || this.getConfigurationInPlane() == -2) {
                    d4 = (double)(mouseEvent.getY() - ((SGAxisElement)SGAxisElement.this).mPressedElementOrigin.y) + rectangle2D.getHeight() / 2.0;
                    f = this.mAxisLine.getEnd().y;
                    float f5 = this.mAxisLine.getStart().y;
                    float f6 = f5 - f;
                    if (d4 >= (double)f5) {
                        return false;
                    }
                    if (d4 < (double)f) {
                        d4 = f;
                    }
                    double d9 = d7 + (d6 - d7) * (1.0 - (d4 - (double)f) / (double)(f5 - f));
                    d3 = d7;
                    d2 = d7 + (d6 - d7) * (d5 - d7) / (d9 - d7);
                    if (n == 0) {
                        d2 = this.cutoffNumberInRangeOrder(d2);
                    }
                    float f7 = (float)(d4 - rectangle2D.getHeight() / 2.0);
                    elementStringOfScale.setY(f7);
                    if (d2 - d3 < 0.05 * (d6 - d7)) {
                        return false;
                    }
                } else {
                    throw new Error();
                }
                if (n == 0) {
                    d4 = d3;
                    d = d2;
                } else if (n == 1) {
                    d4 = Math.pow(10.0, d3);
                    d = Math.pow(10.0, d2);
                } else {
                    throw new Error();
                }
                this.mAxis.setRange(d4, d);
            } else if (this.mDraggingElement instanceof ElementLineOfScale) {
                double d;
                double d10;
                double d11;
                double d12;
                double d13;
                double d14;
                double d15;
                ElementLineOfScale elementLineOfScale = (ElementLineOfScale)this.mDraggingElement;
                if (n == 0) {
                    d15 = this.mTempRange.x;
                    d14 = this.mTempRange.y;
                    d13 = elementLineOfScale.mValue;
                } else if (n == 1) {
                    d15 = Math.log(this.mTempRange.x) / Math.log(10.0);
                    d14 = Math.log(this.mTempRange.y) / Math.log(10.0);
                    d13 = Math.log(elementLineOfScale.mValue) / Math.log(10.0);
                } else {
                    throw new Error();
                }
                if (this.getConfigurationInPlane() == 1 || this.getConfigurationInPlane() == -1) {
                    d12 = mouseEvent.getX();
                    if ((double)((SGAxisElement)SGAxisElement.this).mPressedElementOrigin.x == d12) {
                        return false;
                    }
                    d11 = this.mAxisLine.getStart().x;
                    double d16 = this.mAxisLine.getEnd().x;
                    if (d12 > d16) {
                        d12 = d16;
                    }
                    if (d12 < d11) {
                        d12 = d11;
                    }
                    double d17 = d15 + (d14 - d15) * (d12 - d11) / (d16 - d11);
                    double d18 = Math.abs(d17 - d13);
                    if (d17 > d13) {
                        d10 = d15 - d18;
                        d = d14 - d18;
                    } else {
                        d10 = d15 + d18;
                        d = d14 + d18;
                    }
                    if (n == 0) {
                        d10 = this.cutoffNumberInRangeOrder(d10);
                        d = this.cutoffNumberInRangeOrder(d);
                    }
                } else if (this.getConfigurationInPlane() == 2 || this.getConfigurationInPlane() == -2) {
                    d12 = mouseEvent.getY();
                    if ((double)((SGAxisElement)SGAxisElement.this).mPressedElementOrigin.y == d12) {
                        return false;
                    }
                    d11 = this.mAxisLine.getEnd().y;
                    double d19 = this.mAxisLine.getStart().y;
                    if (d12 > d19) {
                        d12 = d19;
                    }
                    if (d12 < d11) {
                        d12 = d11;
                    }
                    double d20 = d15 + (d14 - d15) * (1.0 - (d12 - d11) / (d19 - d11));
                    double d21 = Math.abs(d20 - d13);
                    if (d20 > d13) {
                        d10 = d15 - d21;
                        d = d14 - d21;
                    } else {
                        d10 = d15 + d21;
                        d = d14 + d21;
                    }
                    if (n == 0) {
                        d10 = this.cutoffNumberInRangeOrder(d10);
                        d = this.cutoffNumberInRangeOrder(d);
                    }
                } else {
                    throw new Error();
                }
                if (n == 0) {
                    d12 = d10;
                    d11 = d;
                } else if (n == 1) {
                    d12 = Math.pow(10.0, d10);
                    d11 = Math.pow(10.0, d);
                } else {
                    throw new Error();
                }
                this.mAxis.setRange(d12, d11);
            }
            if (!this.createDrawingElements()) {
                return false;
            }
            if (SGAxisElement.this.mNotifyChangeOnDraggingFlag) {
                SGAxisElement.this.notifyChange();
            }
            return true;
        }

        public boolean onMouseReleased(MouseEvent mouseEvent) {
            if (this.mTempRange != null || this.mDraggingElement != null) {
                this.mTempRange = null;
                this.mDraggingElement = null;
                if (this.getConfigurationInPlane() == 1 || this.getConfigurationInPlane() == -1) {
                    ElementsGroupOfAxis elementsGroupOfAxis = SGAxisElement.this.getAxisGroupInPlane(2);
                    elementsGroupOfAxis.mAxisNumberDraggingFlag = false;
                } else if (this.getConfigurationInPlane() == 2 || this.getConfigurationInPlane() == -2) {
                    ElementsGroupOfAxis elementsGroupOfAxis = SGAxisElement.this.getAxisGroupInPlane(1);
                    elementsGroupOfAxis.mAxisNumberDraggingFlag = false;
                }
                return true;
            }
            return false;
        }

        private double cutoffNumberInRangeOrder(double d) {
            int n = this.getRangeOrder() - 3 + 1;
            BigDecimal bigDecimal = new BigDecimal(d);
            bigDecimal = bigDecimal.movePointLeft(n);
            bigDecimal = bigDecimal.setScale(0, 4);
            bigDecimal = bigDecimal.movePointRight(n);
            return bigDecimal.doubleValue();
        }

        private boolean createDrawingElements() {
            if (!this.setAxisLineProperties()) {
                return false;
            }
            if (!this.setAxisLineLocation()) {
                return false;
            }
            if (!this.createScaleDrawingElements()) {
                return false;
            }
            if (!this.setTitleProperties()) {
                return false;
            }
            return this.setLocationOfTitleElement();
        }

        private boolean setLocationOfDrawingElements() {
            if (!this.setAxisLineLocation()) {
                return false;
            }
            if (this.mScaleNumbersVisibleFlag && !this.setLocationOfScaleNumbers()) {
                return false;
            }
            if (this.mScaleLinesVisibleFlag && !this.createScaleLines()) {
                return false;
            }
            return !this.mTitleVisibleFlag || this.setLocationOfTitleElement();
        }

        private boolean createScaleDrawingElements() {
            if (!this.calcValueArrayInScale()) {
                return false;
            }
            if (!this.createScaleNumberInstances()) {
                return false;
            }
            if (!this.setLocationOfScaleNumbers()) {
                return false;
            }
            return this.createScaleLines();
        }

        private boolean setAxisLineLocation() {
            float f;
            float f2;
            float f3;
            float f4;
            float f5 = SGAxisElement.this.mGraphAreaX;
            float f6 = SGAxisElement.this.mGraphAreaY;
            float f7 = SGAxisElement.this.mGraphAreaWidth;
            float f8 = SGAxisElement.this.mGraphAreaHeight;
            switch (this.getConfigurationInPlane()) {
                case 1: {
                    f4 = f5;
                    f3 = f6 + f8;
                    f2 = f5 + f7;
                    f = f3;
                    break;
                }
                case -1: {
                    f4 = f5;
                    f3 = f6;
                    f2 = f5 + f7;
                    f = f3;
                    break;
                }
                case 2: {
                    f4 = f5;
                    f3 = f6 + f8;
                    f2 = f4;
                    f = f6;
                    break;
                }
                case -2: {
                    f4 = f5 + f7;
                    f3 = f6 + f8;
                    f2 = f4;
                    f = f6;
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            this.mAxisLine.setTermPoints(f4, f3, f2, f);
            return true;
        }

        private boolean setAxisLineProperties() {
            this.mAxisLine.setLineWidth(SGAxisElement.this.mAxisLineWidth);
            this.mAxisLine.setColor(SGAxisElement.this.mLineColor);
            return true;
        }

        private boolean setLocationOfTitleElement() {
            float f = SGAxisElement.this.mGraphAreaX;
            float f2 = SGAxisElement.this.mGraphAreaY;
            float f3 = SGAxisElement.this.mGraphAreaWidth;
            float f4 = SGAxisElement.this.mGraphAreaHeight;
            float f5 = SGAxisElement.this.getSpaceAxisLineAndNumber();
            float f6 = SGAxisElement.this.getSpaceNumberAndTitle();
            float f7 = 0.0f;
            float f8 = 0.0f;
            if (this.mScaleNumbersVisibleFlag) {
                f7 = (float)this.getScaleHeight();
                f8 = SGAxisElement.this.getMaxLengthOfScaleNumbers(this);
            }
            switch (this.getConfigurationInPlane()) {
                case 1: {
                    Rectangle2D rectangle2D = this.mTitle.getElementBounds();
                    this.mTitle.setLocation(f + f3 / 2.0f - (float)rectangle2D.getWidth() / 2.0f, f2 + f4 + f7 + (f5 + f6));
                    break;
                }
                case -1: {
                    Rectangle2D rectangle2D = this.mTitle.getElementBounds();
                    this.mTitle.setLocation(f + f3 / 2.0f - (float)rectangle2D.getWidth() / 2.0f, f2 - f7 - (float)rectangle2D.getHeight() - (f5 + f6));
                    break;
                }
                case 2: {
                    this.mTitle.setAngle(1.5707964f);
                    Rectangle2D rectangle2D = this.mTitle.getElementBounds();
                    this.mTitle.setLocation(f - f8 - (float)rectangle2D.getWidth() - (f5 + f6), f2 + 0.5f * f4 + 0.5f * (float)rectangle2D.getHeight());
                    break;
                }
                case -2: {
                    this.mTitle.setAngle(1.5707964f);
                    Rectangle2D rectangle2D = this.mTitle.getElementBounds();
                    this.mTitle.setLocation(f + f3 + f8 + (f5 + f6), f2 + 0.5f * f4 + 0.5f * (float)rectangle2D.getHeight());
                    break;
                }
            }
            return true;
        }

        private boolean setTitleProperties() {
            this.mTitle.setColor(SGAxisElement.this.mStringColor);
            this.mTitle.setFont(SGAxisElement.this.mTitleFontFamilyName, SGAxisElement.this.mTitleFontStyle, SGAxisElement.this.mTitleFontSize);
            return true;
        }

        private boolean createScaleNumberInstances() {
            this.mScaleNumberList.clear();
            this.mExponentDrawingElement = null;
            int n = this.mAxis.getScaleType();
            double[] dArray = null;
            if (this.mExponentFlag) {
                dArray = new double[this.mAxisValueArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    BigDecimal bigDecimal = new BigDecimal(this.mAxisValueArray[i]);
                    bigDecimal = bigDecimal.movePointLeft(this.mExponentValue);
                    dArray[i] = bigDecimal.doubleValue();
                }
            } else {
                dArray = this.mAxisValueArray;
            }
            String[] stringArray = new String[dArray.length];
            if (n == 0) {
                if (this.mScaleNumbersIntegerFlag) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = new Integer((int)dArray[i]).toString();
                    }
                } else {
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = new Double(dArray[i]).toString();
                    }
                }
            } else if (n == 1) {
                for (int i = 0; i < stringArray.length; ++i) {
                    int n2 = SGUtilityNumber.getOrder(dArray[i]);
                    stringArray[i] = SGUtilityText.getSuperscriptString("10", new Integer(n2).toString());
                }
            }
            for (int i = 0; i < this.mAxisValueArray.length; ++i) {
                ElementStringOfScale elementStringOfScale = new ElementStringOfScale(stringArray[i], SGAxisElement.this.mScaleFontFamilyName, SGAxisElement.this.mScaleFontStyle, SGAxisElement.this.mScaleFontSize);
                elementStringOfScale.mValue = this.mAxisValueArray[i];
                elementStringOfScale.setMagnification(SGAxisElement.this.mMagnification);
                elementStringOfScale.setColor(SGAxisElement.this.mStringColor);
                this.mScaleNumberList.add(elementStringOfScale);
            }
            if (this.mExponentFlag) {
                this.createExponentDrawingElement();
            }
            return true;
        }

        private boolean createExponentDrawingElement() {
            String string = "x10";
            string = SGUtilityText.getSuperscriptString(string, new Integer(this.mExponentValue).toString());
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = new SGDrawingElementString2DExtended(string, SGAxisElement.this.mScaleFontFamilyName, SGAxisElement.this.mScaleFontStyle, SGAxisElement.this.mScaleFontSize);
            sGDrawingElementString2DExtended.setMagnification(SGAxisElement.this.mMagnification);
            sGDrawingElementString2DExtended.setColor(SGAxisElement.this.mStringColor);
            this.mExponentDrawingElement = sGDrawingElementString2DExtended;
            this.setLocationOfExponentDrawingElement();
            return true;
        }

        private boolean setLocationOfExponentDrawingElement() {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = this.mExponentDrawingElement;
            Rectangle2D rectangle2D = ((SGDrawingElementString2D)sGDrawingElementString2DExtended).getElementBounds();
            float f = SGAxisElement.this.mGraphAreaX;
            float f2 = SGAxisElement.this.mGraphAreaY;
            float f3 = SGAxisElement.this.mGraphAreaWidth;
            float f4 = SGAxisElement.this.mGraphAreaHeight;
            float f5 = SGAxisElement.this.getSpaceAxisLineAndNumber();
            float f6 = SGAxisElement.this.getSpaceNumberAndTitle();
            float f7 = 0.0f;
            float f8 = 0.0f;
            switch (this.getConfigurationInPlane()) {
                case 1: {
                    f7 = f + f3 - 0.0f * (float)rectangle2D.getWidth();
                    f8 = f2 + f4 + (float)((double)f5 + this.getScaleHeight() + (double)f6);
                    break;
                }
                case -1: {
                    f7 = f + f3 - 0.0f * (float)rectangle2D.getWidth();
                    f8 = f2 - (float)((double)f5 + this.getScaleHeight() + (double)f6 + this.getTitleHeight());
                    break;
                }
                case 2: {
                    f7 = f - (float)((double)(f5 + SGAxisElement.this.getMaxLengthOfScaleNumbers(this) + f6) + rectangle2D.getWidth());
                    f8 = f2 - (float)rectangle2D.getHeight();
                    break;
                }
                case -2: {
                    f7 = f + f3 + (f5 + SGAxisElement.this.getMaxLengthOfScaleNumbers(this) + f6);
                    f8 = f2 - (float)rectangle2D.getHeight();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            ((SGDrawingElementString)sGDrawingElementString2DExtended).setLocation(f7, f8);
            return true;
        }

        private boolean setLocationOfScaleNumbers() {
            int n = this.getConfigurationInPlane();
            float f = SGAxisElement.this.mGraphAreaX;
            float f2 = SGAxisElement.this.mGraphAreaY;
            float f3 = SGAxisElement.this.mGraphAreaWidth;
            float f4 = SGAxisElement.this.mGraphAreaHeight;
            int n2 = this.mAxis.getScaleType();
            double[] dArray = null;
            if (n2 == 0) {
                dArray = this.mAxisValueArray;
            } else if (n2 == 1) {
                dArray = new double[this.mAxisValueArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = Math.log(this.mAxisValueArray[i]);
                }
            }
            double d = 0.0;
            double d2 = 0.0;
            if (n2 == 0) {
                d = this.mAxis.getMinValue();
                d2 = this.mAxis.getMaxValue();
            } else if (n2 == 1) {
                d = Math.log(this.mAxis.getMinValue());
                d2 = Math.log(this.mAxis.getMaxValue());
            }
            float f5 = SGAxisElement.this.getSpaceNumberAndTitle();
            float f6 = SGAxisElement.this.getSpaceAxisLineAndNumber();
            block7: for (int i = 0; i < this.mScaleNumberList.size(); ++i) {
                ElementStringOfScale elementStringOfScale = (ElementStringOfScale)this.mScaleNumberList.get(i);
                Rectangle2D rectangle2D = elementStringOfScale.getElementBounds();
                float f7 = (float)rectangle2D.getWidth();
                float f8 = (float)rectangle2D.getHeight();
                switch (n) {
                    case 1: {
                        float f9 = (float)((double)f + (double)f3 * (dArray[i] - d) / (d2 - d));
                        float f10 = f2 + f4 + f6;
                        elementStringOfScale.setLocation(f9 - 0.5f * f7, f10);
                        continue block7;
                    }
                    case -1: {
                        float f9 = (float)((double)f + (double)f3 * (dArray[i] - d) / (d2 - d));
                        float f10 = (float)((double)(f2 - f6) - rectangle2D.getHeight());
                        elementStringOfScale.setLocation(f9 - 0.5f * f7, f10);
                        continue block7;
                    }
                    case 2: {
                        float f9 = (float)((double)f2 + (double)f4 * (1.0 - (dArray[i] - d) / (d2 - d)));
                        float f10 = (float)((double)(f - f6) - rectangle2D.getWidth());
                        elementStringOfScale.setLocation(f10, f9 - 0.5f * f8);
                        continue block7;
                    }
                    case -2: {
                        float f9 = (float)((double)f2 + (double)f4 * (1.0 - (dArray[i] - d) / (d2 - d)));
                        float f10 = f + f3 + f6;
                        elementStringOfScale.setLocation(f10, f9 - 0.5f * f8);
                        continue block7;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            if (this.mExponentFlag) {
                this.setLocationOfExponentDrawingElement();
            }
            return true;
        }

        private boolean createScaleLines() {
            this.mScaleLineList.clear();
            boolean bl = true;
            switch (this.mAxis.getScaleType()) {
                case 0: {
                    bl = this.createScaleLinesInLinearScale();
                    break;
                }
                case 1: {
                    bl = this.createScaleLinesInLogScale();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return bl;
        }

        private boolean createScaleLinesInLinearScale() {
            ElementLineOfScale elementLineOfScale;
            ElementLineOfScale elementLineOfScale2;
            double d;
            int n;
            float f = SGAxisElement.this.mMagnification * SGAxisElement.this.mScaleLineLength;
            for (n = 0; n < this.mAxisValueArray.length; ++n) {
                d = this.mAxisValueArray[n];
                elementLineOfScale2 = this.createSingleScaleLine(d, f);
                if (elementLineOfScale2 == null) continue;
                elementLineOfScale2.mValue = d;
                elementLineOfScale2.setMagnification(SGAxisElement.this.mMagnification);
                elementLineOfScale2.setColor(SGAxisElement.this.mLineColor);
                this.mScaleLineList.add(elementLineOfScale2);
            }
            for (n = 0; n < this.mAxisValueArray.length && n != this.mAxisValueArray.length - 1; ++n) {
                d = (this.mAxisValueArray[n] + this.mAxisValueArray[n + 1]) / 2.0;
                elementLineOfScale2 = this.createSingleScaleLine(d, f);
                if (elementLineOfScale2 == null) continue;
                elementLineOfScale2.mValue = d;
                elementLineOfScale2.setMagnification(SGAxisElement.this.mMagnification);
                elementLineOfScale2.setColor(SGAxisElement.this.mLineColor);
                this.mScaleLineList.add(elementLineOfScale2);
            }
            double d2 = this.mAxisValueArray[0] - this.mIncrementValue / 2.0;
            if (this.mAxis.insideRange(d2) && (elementLineOfScale = this.createSingleScaleLine(d2, f)) != null) {
                elementLineOfScale.mValue = d2;
                elementLineOfScale.setMagnification(SGAxisElement.this.mMagnification);
                elementLineOfScale.setColor(SGAxisElement.this.mLineColor);
                this.mScaleLineList.add(elementLineOfScale);
            }
            if (this.mAxis.insideRange(d2 = this.mAxisValueArray[this.mAxisValueArray.length - 1] + this.mIncrementValue / 2.0) && (elementLineOfScale = this.createSingleScaleLine(d2, f)) != null) {
                elementLineOfScale.mValue = d2;
                elementLineOfScale.setMagnification(SGAxisElement.this.mMagnification);
                elementLineOfScale.setColor(SGAxisElement.this.mLineColor);
                this.mScaleLineList.add(elementLineOfScale);
            }
            return true;
        }

        private boolean createScaleLinesInLogScale() {
            int n;
            float f = SGAxisElement.this.mMagnification * SGAxisElement.this.mScaleLineLength;
            for (int i = 0; i < this.mAxisValueArray.length; ++i) {
                double d = this.mAxisValueArray[i];
                ElementLineOfScale elementLineOfScale = this.createSingleScaleLine(d, f);
                if (elementLineOfScale == null) continue;
                elementLineOfScale.mValue = d;
                elementLineOfScale.setMagnification(SGAxisElement.this.mMagnification);
                elementLineOfScale.setColor(SGAxisElement.this.mLineColor);
                this.mScaleLineList.add(elementLineOfScale);
            }
            for (n = 0; n < this.mAxisValueArray.length; ++n) {
                for (int i = 2; i < 10; ++i) {
                    double d = this.mAxisValueArray[n] * 0.1 * (double)i;
                    ElementLineOfScale elementLineOfScale = this.createSingleScaleLine(d, 1.0f * f);
                    if (elementLineOfScale == null) continue;
                    elementLineOfScale.mValue = d;
                    elementLineOfScale.setMagnification(SGAxisElement.this.mMagnification);
                    elementLineOfScale.setColor(SGAxisElement.this.mLineColor);
                    this.mScaleLineList.add(elementLineOfScale);
                }
            }
            if (this.mAxisValueArray.length >= 1) {
                for (n = 2; n < 10; ++n) {
                    double d = this.mAxisValueArray[this.mAxisValueArray.length - 1] * (double)n;
                    ElementLineOfScale elementLineOfScale = this.createSingleScaleLine(d, 1.0f * f);
                    if (elementLineOfScale == null) continue;
                    elementLineOfScale.mValue = d;
                    elementLineOfScale.setMagnification(SGAxisElement.this.mMagnification);
                    elementLineOfScale.setColor(SGAxisElement.this.mLineColor);
                    this.mScaleLineList.add(elementLineOfScale);
                }
            }
            return true;
        }

        private ElementLineOfScale createSingleScaleLine(double d, float f) {
            double d2;
            double d3;
            double d4;
            if (!this.mAxis.insideRange(d)) {
                return null;
            }
            float f2 = SGAxisElement.this.mGraphAreaX;
            float f3 = SGAxisElement.this.mGraphAreaY;
            float f4 = SGAxisElement.this.mGraphAreaWidth;
            float f5 = SGAxisElement.this.mGraphAreaHeight;
            switch (this.mAxis.getScaleType()) {
                case 0: {
                    d4 = this.mAxis.getMinValue();
                    d3 = this.mAxis.getMaxValue();
                    d2 = d;
                    break;
                }
                case 1: {
                    d4 = Math.log(this.mAxis.getMinValue());
                    d3 = Math.log(this.mAxis.getMaxValue());
                    d2 = Math.log(d);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            ElementLineOfScale elementLineOfScale = null;
            switch (this.getConfigurationInPlane()) {
                case 1: {
                    double d5 = (double)f2 + (double)f4 * (d2 - d4) / (d3 - d4);
                    double d6 = f3 + f5;
                    double d7 = 0.0;
                    d7 = this.mScaleLinesInsideFlag ? d6 - (double)f : d6 + (double)f;
                    SGTuple2f sGTuple2f = new SGTuple2f((float)d5, (float)d6);
                    SGTuple2f sGTuple2f2 = new SGTuple2f((float)d5, (float)d7);
                    elementLineOfScale = new ElementLineOfScale(sGTuple2f, sGTuple2f2, SGAxisElement.this.mScaleLineWidth, this.mAxisElement.getWidth(), this.mAxisElement.getHeight());
                    break;
                }
                case -1: {
                    double d8 = (double)f2 + (double)f4 * (d2 - d4) / (d3 - d4);
                    double d9 = f3;
                    double d10 = 0.0;
                    d10 = this.mScaleLinesInsideFlag ? d9 + (double)f : d9 - (double)f;
                    SGTuple2f sGTuple2f = new SGTuple2f((float)d8, (float)d9);
                    SGTuple2f sGTuple2f3 = new SGTuple2f((float)d8, (float)d10);
                    elementLineOfScale = new ElementLineOfScale(sGTuple2f, sGTuple2f3, SGAxisElement.this.mScaleLineWidth, this.mAxisElement.getWidth(), this.mAxisElement.getHeight());
                    break;
                }
                case 2: {
                    double d11 = (double)f3 + (double)f5 * (1.0 - (d2 - d4) / (d3 - d4));
                    double d12 = f2;
                    double d13 = 0.0;
                    d13 = this.mScaleLinesInsideFlag ? d12 + (double)f : d12 - (double)f;
                    SGTuple2f sGTuple2f = new SGTuple2f((float)d12, (float)d11);
                    SGTuple2f sGTuple2f4 = new SGTuple2f((float)d13, (float)d11);
                    elementLineOfScale = new ElementLineOfScale(sGTuple2f, sGTuple2f4, SGAxisElement.this.mScaleLineWidth, this.mAxisElement.getWidth(), this.mAxisElement.getHeight());
                    break;
                }
                case -2: {
                    double d14 = (double)f3 + (double)f5 * (1.0 - (d2 - d4) / (d3 - d4));
                    double d15 = f2 + f4;
                    double d16 = 0.0;
                    d16 = this.mScaleLinesInsideFlag ? d15 - (double)f : d15 + (double)f;
                    SGTuple2f sGTuple2f = new SGTuple2f((float)d15, (float)d14);
                    SGTuple2f sGTuple2f5 = new SGTuple2f((float)d16, (float)d14);
                    elementLineOfScale = new ElementLineOfScale(sGTuple2f, sGTuple2f5, SGAxisElement.this.mScaleLineWidth, this.mAxisElement.getWidth(), this.mAxisElement.getHeight());
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return elementLineOfScale;
        }

        private boolean calcValueArrayInScale() {
            double[] dArray = null;
            switch (this.mAxis.getScaleType()) {
                case 0: {
                    dArray = this.calcScaleValuesInLinearScale();
                    break;
                }
                case 1: {
                    dArray = this.calcScaleValuesInLogScale();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            this.mAxisValueArray = dArray;
            return true;
        }

        private int getRangeOrder() {
            double d = this.mAxis.getRange().x;
            double d2 = this.mAxis.getRange().y;
            int n = SGUtilityNumber.getOrder(d2 - d);
            return n;
        }

        private double[] calcScaleValuesInLinearScale() {
            double d;
            double d2;
            double d3;
            double d4;
            double d5 = this.mAxis.getRange().x;
            double d6 = this.mAxis.getRange().y;
            double d7 = d6 - d5;
            double[] dArray = null;
            int n = SGUtilityNumber.getOrder(d7);
            double d8 = SGUtilityNumber.getPowersOfTen(n);
            if (this.mAutoCalcAxisNumberFlag) {
                d4 = 0.0;
                d3 = d7 - 0.1 * d8;
                int n2 = SGUtilityNumber.getOrder(d3);
                double d9 = SGUtilityNumber.getPowersOfTen(n2);
                double d10 = d3 / d9;
                double d11 = 0.0;
                if (d10 <= 1.1) {
                    d11 = 0.2 * d9;
                } else if (1.1 < d10 && d10 <= 2.0) {
                    d11 = 0.5 * d9;
                } else if (2.0 < d10 && d10 <= 6.0) {
                    d11 = 1.0 * d9;
                } else if (6.0 < d10) {
                    d11 = 2.0 * d9;
                }
                d11 = this.cutoffNumberInRangeOrder(d11);
                this.mBaseTickValue = d4;
                this.mIncrementValue = d11;
            }
            d4 = this.mBaseTickValue;
            d3 = this.mIncrementValue;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            int n3 = 0;
            while (!((d2 = d4 + (double)n3 * d3) > d6)) {
                if (!this.mAxis.insideRange(d2)) {
                    ++n3;
                    continue;
                }
                d = SGUtilityNumber.truncateNumber(d2, n - 5);
                arrayList.add(new Double(d));
                ++n3;
            }
            n3 = 1;
            while (!((d2 = d4 - (double)n3 * d3) < d5)) {
                if (!this.mAxis.insideRange(d2)) {
                    ++n3;
                    continue;
                }
                d = SGUtilityNumber.truncateNumber(d2, n - 5);
                arrayList.add(0, new Double(d));
                ++n3;
            }
            dArray = new double[arrayList.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (Double)arrayList.get(i);
            }
            if (this.mScaleNumbersIntegerFlag) {
                int n4;
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                for (n4 = 0; n4 < dArray.length; ++n4) {
                    int n5 = (int)dArray[n4];
                    arrayList2.add(new Integer(n5));
                }
                block4: for (n4 = arrayList2.size() - 1; n4 >= 1; --n4) {
                    Integer n6 = (Integer)arrayList2.get(n4);
                    for (int i = n4 - 1; i >= 0; --i) {
                        Integer n7 = (Integer)arrayList2.get(i);
                        if (n7.intValue() != n6.intValue()) continue;
                        arrayList2.remove(n4);
                        continue block4;
                    }
                }
                double[] dArray2 = new double[arrayList2.size()];
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray2[i] = ((Integer)arrayList2.get(i)).intValue();
                }
                dArray = dArray2;
            }
            return dArray;
        }

        private double[] calcScaleValuesInLogScale() {
            int n;
            double d = this.mAxis.getRange().x;
            double d2 = this.mAxis.getRange().y;
            double[] dArray = null;
            int n2 = SGUtilityNumber.getOrder(0.99999999999999 * d);
            int n3 = SGUtilityNumber.getOrder(d2);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = n2 + 1; n <= n3; ++n) {
                arrayList.add(new Integer(n));
            }
            dArray = new double[arrayList.size()];
            for (n = 0; n < dArray.length; ++n) {
                int n4 = (Integer)arrayList.get(n);
                dArray[n] = SGUtilityNumber.getPowersOfTen(n4);
            }
            return dArray;
        }

        private ArrayList getTimingElementsList() {
            ArrayList<TimingElementGroupSetInAxis> arrayList = new ArrayList<TimingElementGroupSetInAxis>();
            for (int i = 0; i < SGAxisElement.this.mTimingElementGroupSetList.size(); ++i) {
                TimingElementGroupSetInAxis timingElementGroupSetInAxis = (TimingElementGroupSetInAxis)SGAxisElement.this.mTimingElementGroupSetList.get(i);
                SGAxis sGAxis = timingElementGroupSetInAxis.mAxis;
                if (!sGAxis.equals(this.mAxis)) continue;
                arrayList.add(timingElementGroupSetInAxis);
            }
            return arrayList;
        }

        public boolean writeProperty(Writer writer) throws IOException {
            writer.write("<Axis>\n");
            SGTuple2d sGTuple2d = this.mAxis.getRange();
            int n = this.getConfigurationInCube();
            String string = SGAxisElement.this.getConfigurationStringInPlaneByCube(n);
            SGUtilityText.writePropertyLine(writer, "Location", string);
            SGUtilityText.writePropertyLine(writer, "Axis Scale Type", SGUtilityText.getScaleTypeName(this.mAxis.getScaleType()));
            SGUtilityText.writePropertyLine(writer, "Axis Min Value", new Double(sGTuple2d.x));
            SGUtilityText.writePropertyLine(writer, "Axis Max Value", new Double(sGTuple2d.y));
            SGUtilityText.writePropertyLine(writer, "Auto Calculation Axis Number", new Boolean(this.mAutoCalcAxisNumberFlag));
            SGUtilityText.writePropertyLine(writer, "Increment Value", new Double(this.mIncrementValue));
            SGUtilityText.writePropertyLine(writer, "Increment Reference Value", new Double(this.mBaseTickValue));
            SGUtilityText.writePropertyLine(writer, "Axis Visible", new Boolean(this.mVisibleFlag));
            SGUtilityText.writePropertyLine(writer, "Title Visible", new Boolean(this.mTitleVisibleFlag));
            SGUtilityText.writeStringPropertyLine(writer, "Title String", this.mTitle.getString());
            SGUtilityText.writePropertyLine(writer, "Scale Numbers Visible", new Boolean(this.mScaleNumbersVisibleFlag));
            SGUtilityText.writePropertyLine(writer, "Scale Numbers Integer", new Boolean(this.mScaleNumbersIntegerFlag));
            SGUtilityText.writePropertyLine(writer, "Scale Lines Visible", new Boolean(this.mScaleLinesVisibleFlag));
            SGUtilityText.writePropertyLine(writer, "Scale Lines Inside", new Boolean(this.mScaleLinesInsideFlag));
            SGUtilityText.writePropertyLine(writer, "Exponent", new Boolean(this.mExponentFlag));
            SGUtilityText.writePropertyLine(writer, "Exponent Value", new Integer(this.mExponentValue));
            writer.write("\n");
            return true;
        }

        private AxisIndividualProperties getPropertiesFromDialog() {
            AxisIndividualProperties axisIndividualProperties = this.mAxisPanel.getProperties();
            if (axisIndividualProperties == null) {
                return null;
            }
            axisIndividualProperties.configuration = this.getConfigurationInCube();
            return axisIndividualProperties;
        }

        private AxisIndividualProperties getProperties() {
            AxisIndividualProperties axisIndividualProperties = new AxisIndividualProperties();
            axisIndividualProperties.configuration = this.getConfigurationInCube();
            axisIndividualProperties.scaleType = this.mAxis.getScaleType();
            SGTuple2d sGTuple2d = this.mAxis.getRange();
            axisIndividualProperties.minValue = sGTuple2d.x;
            axisIndividualProperties.maxValue = sGTuple2d.y;
            axisIndividualProperties.autoCalcAxisNumberFlag = this.mAutoCalcAxisNumberFlag;
            axisIndividualProperties.incrementValue = this.mIncrementValue;
            axisIndividualProperties.baseTickValue = this.mBaseTickValue;
            axisIndividualProperties.titleString = this.mTitle.getString();
            axisIndividualProperties.axisVisibleFlag = this.mVisibleFlag;
            axisIndividualProperties.titleVisibleFlag = this.mTitleVisibleFlag;
            axisIndividualProperties.scaleLinesVisibleFlag = this.mScaleLinesVisibleFlag;
            axisIndividualProperties.scaleNumbersVisibleFlag = this.mScaleNumbersVisibleFlag;
            axisIndividualProperties.scaleLinesInsideFlag = this.mScaleLinesInsideFlag;
            axisIndividualProperties.scaleNumbersIntegerFlag = this.mScaleNumbersIntegerFlag;
            axisIndividualProperties.exponentFlag = this.mExponentFlag;
            axisIndividualProperties.exponentValue = this.mExponentValue;
            return axisIndividualProperties;
        }

        private boolean setProperties(AxisIndividualProperties axisIndividualProperties) {
            this.mConfigurationInCube = axisIndividualProperties.configuration;
            this.mAxis.setScaleType(axisIndividualProperties.scaleType);
            this.mAxis.setRange(axisIndividualProperties.minValue, axisIndividualProperties.maxValue);
            this.mAutoCalcAxisNumberFlag = axisIndividualProperties.autoCalcAxisNumberFlag;
            this.mIncrementValue = axisIndividualProperties.incrementValue;
            this.mBaseTickValue = axisIndividualProperties.baseTickValue;
            this.mTitle.setString(axisIndividualProperties.titleString);
            this.mVisibleFlag = axisIndividualProperties.axisVisibleFlag;
            this.mTitleVisibleFlag = axisIndividualProperties.titleVisibleFlag;
            this.mScaleLinesVisibleFlag = axisIndividualProperties.scaleLinesVisibleFlag;
            this.mScaleNumbersVisibleFlag = axisIndividualProperties.scaleNumbersVisibleFlag;
            this.mScaleLinesInsideFlag = axisIndividualProperties.scaleLinesInsideFlag;
            this.mScaleNumbersIntegerFlag = axisIndividualProperties.scaleNumbersIntegerFlag;
            this.mExponentFlag = axisIndividualProperties.exponentFlag;
            this.mExponentValue = axisIndividualProperties.exponentValue;
            return true;
        }
    }

    public static class TimingElementGroupLine
    extends SGElementGroupLine
    implements ITimingElement {
        protected TimingElementGroupLine() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setLineWidth(1.0f);
            Integer n = SGDrawingElementLine.getLineTypeFromName("Solid");
            if (n == null) {
                return false;
            }
            this.setLineType(n);
            this.setColor(SGDefaultValues.TIMING_LINE_COLOR);
            return true;
        }

        public boolean createDrawingElement() {
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[]{new SGTuple2f(), new SGTuple2f()};
            this.setLocation(sGTuple2fArray);
            return true;
        }

        public boolean setPropertyWithDialog() {
            return true;
        }
    }

    public static interface ITimingElement {
        public boolean createDrawingElement();
    }

    public static class ElementStringOfScale
    extends SGDrawingElementString2DExtended {
        private double mValue;

        protected ElementStringOfScale(String string, String string2, int n, float f) {
            super(string, string2, n, f);
        }

        protected ElementStringOfScale(ElementStringOfScale elementStringOfScale) {
            super(elementStringOfScale);
            this.mValue = elementStringOfScale.mValue;
        }
    }

    public static class ElementLineOfScale
    extends SGDrawingElementLine2D {
        private double mValue;

        protected ElementLineOfScale(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2, float f, double d, double d2) {
            super(sGTuple2f, sGTuple2f2, f);
        }

        protected ElementLineOfScale(ElementLineOfScale elementLineOfScale) {
            this.mValue = elementLineOfScale.mValue;
        }
    }

    public static class ElementStringOfTitle
    extends SGDrawingElementString2DExtended {
        protected ElementStringOfTitle() {
        }
    }

    public static class ElementLineOfAxis
    extends SGDrawingElementLine2D {
        protected ElementLineOfAxis() {
        }
    }
}

