/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.print.attribute.standard.MediaSize;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.riken.brain.ni.samuraigraph.base.SGAboutDialog;
import jp.riken.brain.ni.samuraigraph.base.SGConstants;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertySettingListener;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.base.SGWindowDialog;
import org.freehep.util.export.ExportDialog;

public class SGDrawingWindow
extends JFrame
implements ComponentListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
ActionListener,
AdjustmentListener,
WindowListener,
ChangeListener,
SGIUndoable,
SGIPropertySettingListener {
    public static final String WINDOW_TITLE = "[Window]";
    public static final String KEY_PAPER_WIDTH = "Paper Width";
    public static final String KEY_PAPER_HEIGHT = "Paper Height";
    public static final String KEY_BACKGROUND_COLOR = "Background Color";
    public static final String KEY_GRID_VISIBLE = "Grid Visible";
    public static final String KEY_GRID_INTERVAL = "Grid Interval";
    public static final String KEY_GRID_LINE_WIDTH = "Grid Line Width";
    public static final String KEY_GRID_COLOR = "Grid Line Color";
    private int mID;
    private TreeMap mFigureMap = new TreeMap();
    protected ArrayList mFocusedFigureList = new ArrayList();
    protected JLayeredPane mLayeredPane = new JLayeredPane();
    protected GridPanel mGridPanel = new GridPanel();
    protected AnchorPanel mAnchorPanel = new AnchorPanel();
    private RulerPanel mRulerPanel = null;
    private JScrollBar mHScrollBar = null;
    private JScrollBar mVScrollBar = null;
    private JComboBox mMagnificationComboBox = null;
    protected JButton mCreateNewGraphButton = null;
    protected JButton mDrawGraphButton = null;
    protected JButton mLoadPropertyButton = null;
    protected JButton mSaveGraphButton = null;
    protected JButton mExportImageButton = null;
    protected JToggleButton mInsertBreakButton = null;
    protected JButton mBoundingBoxButton = null;
    protected JToggleButton mAddStringButton = null;
    protected JToggleButton mAddTimingElementButton = null;
    protected JToggleButton mAddSignificantSymbolButton = null;
    protected JToggleButton mLockFigureButton = null;
    private JPopupMenu mPopupMenu = new JPopupMenu();
    private SGWindowDialog mDialog = null;
    private PreviewDialog mPreviewDialog = null;
    protected final Dimension mTemporaryViewportSize = new Dimension();
    protected float mMagnification = 1.0f;
    private Color mBackgroundColor = SGDefaultValues.WINDOW_BACKGROUND_COLOR;
    private float mGridInterval = 28.346458f;
    private float mGridLineWidth = 1.0f;
    private Color mGridLineColor = SGDefaultValues.GRID_LINE_COLOR;
    private JToolBar mToolBar = new JToolBar();
    private boolean mLockFigureFlag = false;
    protected float mAnchorSize = 6.0f;
    private boolean mDrawAnchorFlag = true;
    private float mRulerAxisLineWidth = 2.0f;
    private float mRulerScaleLineWidth = 1.0f;
    private Color mRulerLineColor = Color.BLACK;
    private Color mRulerBackGroundColor;
    private float mRulerFontSize;
    private int mRulerFontStyle;
    private String mRulerFontFamilyName;
    private Font mRulerFont = null;
    public static final int LAYER_GRID_PANEL = 20;
    public static final int LAYER_FIGURE = 30;
    public static final int LAYER_ANCHOR_PANEL = 40;
    public static final int LAYER_RULER_PANEL = 50;
    public static final int RULER_WIDTH = 20;
    public static final int MIN_MAGNIFICATION_VALUE = 10;
    public static final int MAX_MAGNIFICATION_VALUE = 400;
    public static final int[] MAGNIFICATION_ARRAY = new int[]{400, 300, 200, 150, 100, 75, 66, 50, 33, 25};
    protected SGProperties mTemporaryProperties = null;
    protected final SGTuple2f mPaperOrigin = new SGTuple2f();
    protected final SGTuple2f mPaperSize = new SGTuple2f();
    protected final Rectangle2D mClientRect = new Rectangle2D.Float();
    public static final int MINIMAL_LENGTH_ORDER = -2;
    public SGAboutDialog mAboutDialog = null;
    private Dimension mMinimumWindowSize = new Dimension();
    public static float PAPER_MARGIN = 42.519688f;
    private boolean mViewportPressedFlag = false;
    static long time = 0L;
    private ArrayList mActionListenerList = new ArrayList();
    public static final String NOTIFY_OPEN_WINDOW = "open a new window";
    public static final String NOTIFY_ADD_DATA = "add new data";
    public static final String NOTIFY_LOAD_PROPERTY = "load property";
    private int mCurrentStateCounter = 0;
    private int mWindowStateCounter = 0;
    private ArrayList mWindowPropertyHistoryList = new ArrayList();
    private ArrayList mUndoableObjectHistoryList = new ArrayList();
    private ArrayList mFigureMapHistoryList = new ArrayList();
    private final String MENU_FILE = "File";
    private final String MENUCMD_OPEN_WINDOW = "Open";
    private final String MENUCMD_CLOSE_WINDOW = "Close";
    private final String MENUCMD_DRAW_GRAPH = "Draw Graph";
    private final String MENUCMD_LOAD_PROPERTY_FILE = "Load Property";
    private final String MENUCMD_SAVE_PROPERTY_FILE = "Save Property";
    private final String MENUCMD_EXPORT = "Export";
    private final String MENUCMD_PRINT = "Print";
    private final String MENUCMD_EXIT = "Exit";
    private final String MENU_EDIT = "Edit";
    private final String MENUCMD_UNDO = "Undo";
    private final String MENUCMD_REDO = "Redo";
    private final String MENUCMD_MOVE_SELECTED_DATA_TO_FRONT = "Move Data to Front";
    private final String MENUCMD_MOVE_SELECTED_DATA_TO_BACK = "Move Data to Back";
    private final String MENUCMD_REMOVE_SELECTED_DATA = "Remove Data";
    private final String MENU_LAYOUT = "Layout";
    private final String MENUCMD_PAPER_SIZE = "Paper Size";
    private final String MENUCMD_A4_SIZE = "A4";
    private final String MENUCMD_B5_SIZE = "B5";
    private final String MENUCMD_LETTER_SIZE = "Letter";
    private final String MENUCMD_BOUNDING_BOX = "Bounding Box";
    private final String MENUCMD_ALIGN_FIGURES = "Align Figures";
    private final String MENU_HELP = "Help";
    private final String MENUCMD_ABOUT = "About";
    private static ExportDialog mExportDialog = new ExportDialog();
    public final String PROPERTY_FILE_NAME = "property.txt";
    private String mPropertyFileName = "property.txt";
    public final String PROPERTY_FILE_DIR_NAME = "./";
    public String mPropertyFileDirName = "./";

    public SGDrawingWindow() {
        this.create();
    }

    public String toString() {
        return new String("SGDrawingWindow:" + this.getID());
    }

    private boolean create() {
        ImageIcon imageIcon = this.createIcon("/resources/Samurai.gif");
        this.setIconImage(imageIcon.getImage());
        this.createPopupMenu();
        this.createDialog();
        this.createAboutDialog();
        this.setJMenuBar(this.createMenuBar());
        this.createScrollBars();
        this.mLayeredPane = new JLayeredPane();
        this.getContentPane().add((Component)this.mLayeredPane, "Center");
        this.createMagnificationBox();
        this.createToolBar();
        this.mLockFigureButton.setSelected(this.mLockFigureFlag);
        this.createGridPanel();
        this.createAnchorPanel();
        this.createRulerPanel();
        this.pack();
        this.mAddStringButton.addActionListener(this);
        this.mAddTimingElementButton.addActionListener(this);
        this.mAddSignificantSymbolButton.addActionListener(this);
        this.mSaveGraphButton.addActionListener(this);
        this.mExportImageButton.addActionListener(this);
        this.mDrawGraphButton.addActionListener(this);
        this.mLoadPropertyButton.addActionListener(this);
        this.mInsertBreakButton.addActionListener(this);
        this.mLockFigureButton.addActionListener(this);
        this.mCreateNewGraphButton.addActionListener(this);
        this.mBoundingBoxButton.addActionListener(this);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.mVScrollBar.addAdjustmentListener(this);
        this.mHScrollBar.addAdjustmentListener(this);
        this.mMagnificationComboBox.addActionListener(this);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addKeyEventPostProcessor(new KeyEventPostProcessor(){

            public boolean postProcessKeyEvent(KeyEvent keyEvent) {
                switch (keyEvent.getID()) {
                    case 401: {
                        SGDrawingWindow.this.onKeyPressed(keyEvent);
                        break;
                    }
                    case 402: {
                        SGDrawingWindow.this.onKeyReleased(keyEvent);
                        break;
                    }
                    case 400: {
                        SGDrawingWindow.this.onKeyTyped(keyEvent);
                        break;
                    }
                }
                return false;
            }
        });
        this.createPreviewDialog();
        this.setComponentsByFigureNumbers();
        return true;
    }

    protected boolean setComponentsByFigureNumbers() {
        boolean bl = this.getVisibleFigureListFromMap().size() != 0;
        this.setInsertToggleButtonsEnabled(bl);
        this.mBoundingBoxButton.setEnabled(bl);
        String[] stringArray = new String[]{"Bounding Box", "Align Figures"};
        for (int i = 0; i < stringArray.length; ++i) {
            JMenuItem jMenuItem = this.getMenuItem("Layout", stringArray[i]);
            jMenuItem.setEnabled(bl);
        }
        return true;
    }

    public boolean init() {
        float f = 566.92914f;
        float f2 = f / SGConstants.GOLDEN_RATIO;
        this.setViewportSize(f, f2);
        int n = this.getInsets().left + this.mMagnificationComboBox.getX() + this.mMagnificationComboBox.getWidth();
        int n2 = this.getInsets().top + this.getJMenuBar().getHeight() + this.getToolBarHeight() + 20;
        this.mMinimumWindowSize.setSize(n, n2);
        this.setClientOrigin(0.0f, 0.0f);
        this.updateClientRect();
        this.setPaperOrigin(0.0f, 0.0f);
        this.setPaperSize(MediaSize.ISO.A4);
        this.updateClientRect();
        this.setScrollBarValue();
        this.initPropertiesHistory();
        return true;
    }

    private boolean createPreviewDialog() {
        String string = "Preview:" + this.getID();
        this.mPreviewDialog = new PreviewDialog(this, "Preview");
        this.mPreviewDialog.hide();
        return true;
    }

    private boolean createScrollBars() {
        this.mVScrollBar = new JScrollBar(1, 0, 100, 0, 100);
        this.mHScrollBar = new JScrollBar(0, 0, 100, 0, 100);
        this.mVScrollBar.setVisible(false);
        this.mHScrollBar.setVisible(false);
        this.getContentPane().add((Component)this.mVScrollBar, "East");
        this.getContentPane().add((Component)this.mHScrollBar, "South");
        int n = this.mHScrollBar.getMinimum();
        int n2 = this.mHScrollBar.getMaximum();
        int n3 = this.mHScrollBar.getVisibleAmount();
        this.mHScrollBar.setValue((n2 - n3 - n) / 2);
        n = this.mVScrollBar.getMinimum();
        n2 = this.mVScrollBar.getMaximum();
        n3 = this.mVScrollBar.getVisibleAmount();
        this.mVScrollBar.setValue((n2 - n3 - n) / 2);
        return true;
    }

    private ImageIcon createIcon(String string) {
        if (string == null) {
            return null;
        }
        Class<?> clazz = this.getClass();
        URL uRL = clazz.getResource(string);
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(string);
        return imageIcon;
    }

    private boolean createToolBar() {
        Dimension dimension = this.mMagnificationComboBox.getPreferredSize();
        this.mMagnificationComboBox.setPreferredSize(new Dimension((int)dimension.getWidth() / 2, (int)dimension.getHeight()));
        ImageIcon imageIcon = this.createIcon("/resources/NewGraph.gif");
        this.mCreateNewGraphButton = new JButton(imageIcon);
        this.mCreateNewGraphButton.setToolTipText("\u30a6\u30a4\u30f3\u30c9\u30a6\u306e\u65b0\u898f\u4f5c\u6210");
        ImageIcon imageIcon2 = this.createIcon("/resources/DrawGraph.gif");
        this.mDrawGraphButton = new JButton(imageIcon2);
        this.mDrawGraphButton.setToolTipText("\u30b0\u30e9\u30d5\u306e\u63cf\u753b");
        ImageIcon imageIcon3 = this.createIcon("/resources/LoadProperty.gif");
        this.mLoadPropertyButton = new JButton(imageIcon3);
        this.mLoadPropertyButton.setToolTipText("\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u8aad\u307f\u8fbc\u307f");
        ImageIcon imageIcon4 = this.createIcon("/resources/SaveGraph.gif");
        this.mSaveGraphButton = new JButton(imageIcon4);
        this.mSaveGraphButton.setToolTipText("\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u4fdd\u5b58");
        ImageIcon imageIcon5 = this.createIcon("/resources/ExportImage.gif");
        this.mExportImageButton = new JButton(imageIcon5);
        this.mExportImageButton.setToolTipText("\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u4fdd\u5b58");
        ImageIcon imageIcon6 = this.createIcon("/resources/BoundingBox.gif");
        this.mBoundingBoxButton = new JButton(imageIcon6);
        this.mBoundingBoxButton.setToolTipText("\u30d0\u30a6\u30f3\u30c7\u30a3\u30f3\u30b0\u30dc\u30c3\u30af\u30b9\u306e\u8a2d\u5b9a");
        ImageIcon imageIcon7 = this.createIcon("/resources/InsertString.gif");
        this.mAddStringButton = new JToggleButton(imageIcon7);
        this.mAddStringButton.setToolTipText("\u30e9\u30d9\u30eb\u306e\u633f\u5165");
        ImageIcon imageIcon8 = this.createIcon("/resources/InsertSig.gif");
        this.mAddSignificantSymbolButton = new JToggleButton(imageIcon8);
        this.mAddSignificantSymbolButton.setToolTipText("\u6709\u610f\u5dee\u30b7\u30f3\u30dc\u30eb\u306e\u633f\u5165");
        ImageIcon imageIcon9 = this.createIcon("/resources/InsertBreak.gif");
        this.mInsertBreakButton = new JToggleButton(imageIcon9);
        this.mInsertBreakButton.setToolTipText("\u8ef8\u306e\u30d6\u30ec\u30a4\u30af\u30b7\u30f3\u30dc\u30eb\u306e\u633f\u5165");
        ImageIcon imageIcon10 = this.createIcon("/resources/InsertTiming.gif");
        this.mAddTimingElementButton = new JToggleButton(imageIcon10);
        this.mAddTimingElementButton.setToolTipText("\u30bf\u30a4\u30df\u30f3\u30b0\u7dda\u306e\u633f\u5165");
        ImageIcon imageIcon11 = this.createIcon("/resources/UnlockFigure.gif");
        this.mLockFigureButton = new JToggleButton(imageIcon11);
        this.mLockFigureButton.setToolTipText("\u30d5\u30a3\u30ae\u30e5\u30a2\u3092\u30a6\u30a4\u30f3\u30c9\u30a6\u306b\u30ed\u30c3\u30af");
        this.mToolBar.add(this.mCreateNewGraphButton);
        this.mToolBar.add(this.mDrawGraphButton);
        this.mToolBar.add(this.mLoadPropertyButton);
        this.mToolBar.add(this.mSaveGraphButton);
        this.mToolBar.add(this.mExportImageButton);
        this.mToolBar.add(this.mBoundingBoxButton);
        this.mToolBar.addSeparator();
        this.mToolBar.add(this.mAddStringButton);
        this.mToolBar.add(this.mAddSignificantSymbolButton);
        this.mToolBar.add(this.mInsertBreakButton);
        this.mToolBar.addSeparator();
        this.mToolBar.add(this.mAddTimingElementButton);
        this.mToolBar.addSeparator();
        this.mToolBar.add(this.mLockFigureButton);
        this.mToolBar.addSeparator();
        this.mToolBar.add(this.mMagnificationComboBox);
        this.mMagnificationComboBox.setMaximumSize(new Dimension(100, 100));
        this.getContentPane().add((Component)this.mToolBar, "North");
        this.mToolBar.setFloatable(false);
        return true;
    }

    private int getToolBarHeight() {
        return this.mToolBar.getHeight();
    }

    private boolean setLockToggleButton(boolean bl) {
        ImageIcon imageIcon = bl ? this.createIcon("/resources/LockFigure.gif") : this.createIcon("/resources/UnlockFigure.gif");
        if (imageIcon == null) {
            return false;
        }
        this.mLockFigureButton.setIcon(imageIcon);
        return true;
    }

    private boolean createGridPanel() {
        this.mGridPanel = new GridPanel();
        this.mGridPanel.setVisible(true);
        this.mGridPanel.setOpaque(true);
        this.mLayeredPane.add(this.mGridPanel);
        this.mLayeredPane.setLayer(this.mGridPanel, 20);
        return true;
    }

    private boolean createMagnificationBox() {
        int n;
        this.mMagnificationComboBox = new JComboBox();
        Integer[] integerArray = new Integer[MAGNIFICATION_ARRAY.length];
        for (n = 0; n < integerArray.length; ++n) {
            integerArray[n] = new Integer(MAGNIFICATION_ARRAY[n]);
        }
        for (n = 0; n < MAGNIFICATION_ARRAY.length; ++n) {
            this.mMagnificationComboBox.addItem(integerArray[n]);
        }
        this.mMagnificationComboBox.setSelectedItem(new Integer(100));
        this.mMagnificationComboBox.setEditable(true);
        this.mMagnificationComboBox.setBackground(Color.WHITE);
        this.mMagnificationComboBox.setToolTipText("\u30ba\u30fc\u30e0");
        return true;
    }

    private boolean createAnchorPanel() {
        this.mAnchorPanel = new AnchorPanel();
        this.mAnchorPanel.setVisible(true);
        this.mAnchorPanel.setOpaque(false);
        this.mLayeredPane.add(this.mAnchorPanel);
        this.mLayeredPane.setLayer(this.mAnchorPanel, 40);
        return true;
    }

    private boolean createRulerPanel() {
        this.mRulerPanel = new RulerPanel();
        this.mRulerPanel.setVisible(true);
        this.mRulerPanel.setOpaque(false);
        this.mRulerFontSize = 11.0f;
        this.mRulerFontFamilyName = "Serif";
        this.mRulerFontStyle = SGUtilityText.getFontStyle("Plain");
        this.mRulerBackGroundColor = this.getBackground();
        this.mRulerLineColor = Color.BLACK;
        this.mRulerFont = new Font(this.mRulerFontFamilyName, this.mRulerFontStyle, (int)this.mRulerFontSize);
        this.mLayeredPane.add(this.mRulerPanel);
        this.mLayeredPane.setLayer(this.mRulerPanel, 50);
        return true;
    }

    private boolean createPopupMenu() {
        return true;
    }

    private boolean createDialog() {
        this.mDialog = new SGWindowDialog((Frame)this, true);
        return true;
    }

    private boolean createAboutDialog() {
        this.mAboutDialog = new SGAboutDialog((Frame)this, true);
        return true;
    }

    public SGAboutDialog getAboutDialog() {
        return this.mAboutDialog;
    }

    public int getID() {
        return this.mID;
    }

    public boolean setID(int n) {
        this.mID = n;
        return true;
    }

    public float getGridLineWidth() {
        return this.mGridLineWidth;
    }

    public Color getGridLineColor() {
        return this.mGridLineColor;
    }

    public boolean setGridLineWidth(float f) {
        this.mGridLineWidth = f;
        return true;
    }

    public boolean setGridLineColor(Color color) {
        this.mGridLineColor = color;
        return true;
    }

    public boolean setBackgroundColor(Color color) {
        if (this.mGridPanel == null) {
            return false;
        }
        this.mBackgroundColor = color;
        return true;
    }

    public boolean setGridInterval(float f) {
        this.mGridInterval = f;
        return true;
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public int getCurrentFigureId() {
        int n = this.mFigureMap.size() == 0 ? 1 : (Integer)this.mFigureMap.lastKey() + 1;
        return n;
    }

    public int getTopWidth() {
        Insets insets = this.getInsets();
        int n = insets.top;
        JMenuBar jMenuBar = this.getJMenuBar();
        int n2 = jMenuBar.getHeight();
        int n3 = this.getToolBarHeight();
        int n4 = n + n2 + n3;
        return n4;
    }

    public int getBottomWidth() {
        Insets insets = this.getInsets();
        int n = insets.bottom;
        return n;
    }

    public int getLeftWidth() {
        Insets insets = this.getInsets();
        int n = insets.left;
        return n;
    }

    public int getRightWidth() {
        Insets insets = this.getInsets();
        int n = insets.right;
        return n;
    }

    public TreeMap getFigureMap() {
        return this.mFigureMap;
    }

    public boolean addFigure(int n, SGFigure sGFigure) {
        this.addFigure_(n, sGFigure);
        return true;
    }

    public boolean addFigure(int n, SGFigure sGFigure, Point point) {
        this.addFigure_(n, sGFigure);
        Point2D point2D = this.getLocationOnFigure(point);
        sGFigure.setGraphAreaLocation((float)point2D.getX(), (float)point2D.getY());
        return true;
    }

    private boolean addFigure_(int n, SGFigure sGFigure) {
        sGFigure.setID(n);
        this.mFigureMap.put(new Integer(n), sGFigure);
        this.mLayeredPane.setLayer(sGFigure, 30);
        this.mLayeredPane.add(sGFigure);
        SGTuple2f sGTuple2f = this.getViewportSize();
        sGFigure.setLocation(20, 20);
        sGFigure.setSize((int)sGTuple2f.x, (int)sGTuple2f.y);
        SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setISize(new SGTuple2f(sGTuple2f.x, sGTuple2f.y));
        }
        sGFigure.setViewBounds();
        this.zoom(this.mMagnification);
        this.setComponentsByFigureNumbers();
        return true;
    }

    public SGFigure[] getFigureArrayFromMap() {
        SGFigure[] sGFigureArray = new SGFigure[this.mFigureMap.size()];
        Iterator iterator = this.mFigureMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            sGFigureArray[n] = (SGFigure)iterator.next();
            ++n;
        }
        return sGFigureArray;
    }

    public SGFigure[] getFigureArrayFromLayer() {
        Component[] componentArray = this.mLayeredPane.getComponentsInLayer(30);
        SGFigure[] sGFigureArray = new SGFigure[componentArray.length];
        for (int i = 0; i < sGFigureArray.length; ++i) {
            sGFigureArray[i] = (SGFigure)componentArray[i];
        }
        return sGFigureArray;
    }

    public ArrayList getVisibleFigureListFromMap() {
        SGFigure[] sGFigureArray = this.getFigureArrayFromMap();
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (!sGFigureArray[i].isVisible()) continue;
            arrayList.add(sGFigureArray[i]);
        }
        return arrayList;
    }

    public ArrayList getVisibleFigureListFromLayer() {
        SGFigure[] sGFigureArray = this.getFigureArrayFromLayer();
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (!sGFigureArray[i].isVisible()) continue;
            arrayList.add(sGFigureArray[i]);
        }
        return arrayList;
    }

    public boolean drawBackAllVisibleFigures() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (this.drawBackFigure(sGFigure)) continue;
            return false;
        }
        return true;
    }

    public boolean drawBackFigure(SGFigure sGFigure) {
        return sGFigure.drawbackFigure();
    }

    public SGFigure getFigure(int n) {
        return (SGFigure)this.mFigureMap.get(new Integer(n));
    }

    protected boolean hideSelectedFigures() {
        for (int i = 0; i < this.mFocusedFigureList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)this.mFocusedFigureList.get(i);
            sGFigure.setVisible(false);
        }
        this.updateHistory();
        this.mFocusedFigureList.clear();
        this.setComponentsByFigureNumbers();
        return true;
    }

    public boolean removeFigure(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (this.removeFigure(sGFigure)) continue;
            return false;
        }
        return true;
    }

    protected boolean removeFigure(SGFigure sGFigure) {
        if (sGFigure == null) {
            return false;
        }
        this.mFigureMap.remove(new Integer(sGFigure.getID()));
        this.mLayeredPane.remove(sGFigure);
        return true;
    }

    protected boolean setFigureVisible(SGFigure sGFigure, boolean bl) {
        if (sGFigure == null) {
            return false;
        }
        sGFigure.setVisible(bl);
        this.mFocusedFigureList.clear();
        return true;
    }

    protected boolean clearFocusedFigures() {
        for (int i = 0; i < this.mFocusedFigureList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)this.mFocusedFigureList.get(i);
            sGFigure.clearSelectedElements();
        }
        this.mFocusedFigureList.clear();
        return true;
    }

    public Point2D getLocationOnFigure(int n, int n2) {
        float f = n - this.getLeftWidth() - 20;
        float f2 = n2 - this.getTopWidth() - 20;
        return new Point2D.Float(f, f2);
    }

    public Point2D getLocationOnFigure(Point point) {
        return this.getLocationOnFigure(point.x, point.y);
    }

    protected boolean setScrollValue(JScrollBar jScrollBar, double d) {
        int n = jScrollBar.getMinimum();
        int n2 = jScrollBar.getMaximum();
        int n3 = jScrollBar.getVisibleAmount();
        int n4 = n2 - n - n3;
        double d2 = d * (double)n4;
        jScrollBar.setValue((int)d2);
        return true;
    }

    protected float getScrollValue(JScrollBar jScrollBar) {
        int n;
        int n2 = jScrollBar.getMinimum();
        int n3 = jScrollBar.getMaximum();
        if (n3 - n2 - (n = jScrollBar.getVisibleAmount()) == 0) {
            return 0.0f;
        }
        float f = (float)jScrollBar.getValue() / (float)(n3 - n2 - n);
        return f;
    }

    protected float getHScrollValue() {
        return this.getScrollValue(this.mHScrollBar);
    }

    protected float getVScrollValue() {
        return this.getScrollValue(this.mVScrollBar);
    }

    private boolean setScrollBarValue() {
        if (this.mHScrollBar.isVisible()) {
            this.setScrollBarValue(true);
        }
        if (this.mVScrollBar.isVisible()) {
            this.setScrollBarValue(false);
        }
        return true;
    }

    private boolean setScrollBarValue(boolean bl) {
        Rectangle2D rectangle2D = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getViewportBoundsInClientRect();
        JScrollBar jScrollBar = null;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (bl) {
            jScrollBar = this.mHScrollBar;
            f = (float)rectangle2D.getWidth();
            f2 = (float)rectangle2D2.getX();
            f3 = (float)rectangle2D2.getWidth();
        } else {
            jScrollBar = this.mVScrollBar;
            f = (float)rectangle2D.getHeight();
            f2 = (float)rectangle2D2.getY();
            f3 = (float)rectangle2D2.getHeight();
        }
        int n = jScrollBar.getMinimum();
        int n2 = jScrollBar.getMaximum();
        int n3 = (int)(f3 / f * (float)(n2 - n));
        jScrollBar.setVisibleAmount(n3);
        float f4 = f2 / (f - f3);
        int n4 = n + (int)(f4 * (float)(n2 - n3 - n));
        jScrollBar.setValue(n4);
        jScrollBar.setBlockIncrement(n3);
        return true;
    }

    public SGTuple2f getViewportSize() {
        SGTuple2f sGTuple2f = this.getPaneSize();
        sGTuple2f.x -= 20.0f;
        sGTuple2f.y -= 20.0f;
        return sGTuple2f;
    }

    public SGTuple2f getPaneSize() {
        Insets insets = this.getInsets();
        int n = insets.top;
        int n2 = insets.bottom;
        int n3 = insets.left;
        int n4 = insets.right;
        JMenuBar jMenuBar = this.getJMenuBar();
        int n5 = jMenuBar.getHeight();
        int n6 = this.getToolBarHeight();
        float f = this.getWidth() - (n3 + n4);
        float f2 = this.getHeight() - (n + n2 + n5 + n6);
        SGTuple2f sGTuple2f = new SGTuple2f(f, f2);
        return sGTuple2f;
    }

    public boolean setPaperOrigin(float f, float f2) {
        Rectangle2D rectangle2D = this.mClientRect;
        float f3 = (f - (float)rectangle2D.getX()) / this.mMagnification;
        float f4 = (f2 - (float)rectangle2D.getY()) / this.mMagnification;
        this.mPaperOrigin.setValues(f3, f4);
        return true;
    }

    public boolean setPaperSize(float f, float f2) {
        this.mPaperSize.setValues(f / this.mMagnification, f2 / this.mMagnification);
        return true;
    }

    public float getPaperX() {
        Rectangle2D rectangle2D = this.mClientRect;
        return (float)rectangle2D.getX() + this.mMagnification * this.mPaperOrigin.x;
    }

    public float getPaperY() {
        Rectangle2D rectangle2D = this.mClientRect;
        return (float)rectangle2D.getY() + this.mMagnification * this.mPaperOrigin.y;
    }

    public float getPaperWidth() {
        return this.mMagnification * this.mPaperSize.x;
    }

    public float getPaperHeight() {
        return this.mMagnification * this.mPaperSize.y;
    }

    public Rectangle2D getPaperRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getPaperX(), this.getPaperY(), this.getPaperWidth(), this.getPaperHeight());
        return float_;
    }

    public Rectangle2D getBoundingBox() {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect(this.getPaperRect());
        ((Rectangle2D)float_).setRect(((RectangularShape)float_).getX(), ((RectangularShape)float_).getY(), ((RectangularShape)float_).getWidth() + (double)(PAPER_MARGIN * this.mMagnification), ((RectangularShape)float_).getHeight() + (double)(PAPER_MARGIN * this.mMagnification));
        return float_;
    }

    public boolean setViewportSize(float f, float f2) {
        this.mTemporaryViewportSize.setSize(f, f2);
        Insets insets = this.getInsets();
        int n = insets.top;
        int n2 = insets.bottom;
        int n3 = insets.left;
        int n4 = insets.right;
        JMenuBar jMenuBar = this.getJMenuBar();
        int n5 = jMenuBar.getHeight();
        int n6 = this.getToolBarHeight();
        float f3 = f + (float)(n3 + n4 + 20);
        float f4 = f2 + (float)(n + n2 + n5 + n6 + 20);
        this.setSize((int)f3, (int)f4);
        return true;
    }

    private boolean onResized() {
        SGTuple2f sGTuple2f = this.getPaneSize();
        this.mLayeredPane.setSize((int)sGTuple2f.x, (int)sGTuple2f.y);
        this.mGridPanel.setBounds();
        this.mAnchorPanel.setBounds();
        this.mRulerPanel.setBounds();
        SGTuple2f sGTuple2f2 = this.getViewportSize();
        float f = sGTuple2f2.x - (float)this.mTemporaryViewportSize.width;
        float f2 = sGTuple2f2.y - (float)this.mTemporaryViewportSize.height;
        float f3 = sGTuple2f2.x / (float)this.mTemporaryViewportSize.width;
        float f4 = sGTuple2f2.y / (float)this.mTemporaryViewportSize.height;
        this.updateClientRect();
        this.setScrollBarValue();
        SGTuple2f sGTuple2f3 = this.getViewportSize();
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.updateFigureRect();
            sGFigure.setSize(sGTuple2f3);
            sGFigure.setViewBounds();
        }
        if (this.mLockFigureFlag) {
            int n;
            Rectangle2D rectangle2D = this.getPaperRect();
            float f5 = f3 * (float)rectangle2D.getWidth() / this.mMagnification;
            float f6 = f4 * (float)rectangle2D.getHeight() / this.mMagnification;
            this.setPaperSizeRoundingOut(f5, f6);
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                sGFigure.updateFigureRect();
                sGFigure.resize(f3, f4);
            }
            this.updateClientRect();
            this.setScrollBarValue();
            ArrayList<Container> arrayList2 = new ArrayList<Container>();
            for (n = 0; n < arrayList.size(); ++n) {
                SGFigure sGFigure = (SGFigure)arrayList.get(n);
                if (!sGFigure.isFigureMoved()) continue;
                boolean bl = sGFigure.updateHistory();
                if (!bl) {
                    return false;
                }
                arrayList2.add(sGFigure);
            }
            if (!this.updateHistory()) {
                return false;
            }
            arrayList2.add(this);
            n = this.updateObjectHistory(arrayList2) ? 1 : 0;
            if (n == 0) {
                return false;
            }
        }
        this.mTemporaryViewportSize.setSize(sGTuple2f2.x, sGTuple2f2.y);
        Rectangle2D rectangle2D = this.getBoundingBox();
        Rectangle2D rectangle2D2 = this.mClientRect;
        Rectangle2D rectangle2D3 = this.getViewportBounds();
        return true;
    }

    private boolean onZoomed() {
        float f = 0.0f;
        try {
            Object object = this.mMagnificationComboBox.getSelectedItem();
            f = Float.valueOf(object.toString()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            this.mMagnificationComboBox.setSelectedItem(new Integer((int)(this.mMagnification * 100.0f)));
            System.out.println("\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002");
            return false;
        }
        if ((double)f < 0.0) {
            this.mMagnificationComboBox.setSelectedItem(new Integer((int)(this.mMagnification * 100.0f)));
            System.out.println("\u6b63\u306e\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002");
            return false;
        }
        if (f < 10.0f) {
            this.mMagnificationComboBox.setSelectedItem(new Integer(10));
        }
        if (f > 400.0f) {
            this.mMagnificationComboBox.setSelectedItem(new Integer(400));
        }
        return this.zoom(f / 100.0f);
    }

    private boolean zoom(float f) {
        this.mMagnification = f;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            boolean bl = sGFigure.zoom(this.mMagnification);
            if (bl) continue;
            return false;
        }
        this.updateClientRect();
        this.setScrollBarValue();
        this.getContentPane().repaint();
        return true;
    }

    public boolean setFigureBoundingBox(int n) {
        Object object;
        if (n != 0 && n != 1 && n != 2) {
            return false;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        ArrayList arrayList2 = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList2.size(); ++i) {
            object = (SGFigure)arrayList2.get(i);
            arrayList.add(((SGFigure)object).getBoundingBox());
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        if (rectangle2D == null) {
            return false;
        }
        object = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getPaperRect();
        float f = (float)rectangle2D2.getWidth();
        float f2 = (float)rectangle2D2.getHeight();
        if (n == 0 || n == 1) {
            f = (float)(-((RectangularShape)object).getX() + rectangle2D.getX() + rectangle2D.getWidth()) / this.mMagnification;
        }
        if (n == 0 || n == 2) {
            f2 = (float)(-((RectangularShape)object).getY() + rectangle2D.getY() + rectangle2D.getHeight()) / this.mMagnification;
        }
        this.setPaperSizeRoundingOut(f, f2);
        this.updateClientRect();
        this.setScrollBarValue();
        return true;
    }

    public Rectangle2D getBoundingBoxOfFigures(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() == 0) {
            return new Rectangle2D.Float();
        }
        ArrayList<Rectangle2D> arrayList2 = new ArrayList<Rectangle2D>();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure == null) continue;
            Rectangle2D rectangle2D = sGFigure.getBoundingBox();
            if (rectangle2D == null) {
                return null;
            }
            arrayList2.add(rectangle2D);
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList2);
        return rectangle2D;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object instanceof JScrollBar) {
            JScrollBar jScrollBar = (JScrollBar)object;
            if (jScrollBar.equals(this.mHScrollBar)) {
                this.setClientRectByValueOfScrollBar(true);
            } else if (jScrollBar.equals(this.mVScrollBar)) {
                this.setClientRectByValueOfScrollBar(false);
            }
            ArrayList arrayList = this.getVisibleFigureListFromMap();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                sGFigure.setGraphAreaRectToFigureElement();
            }
            this.getContentPane().repaint();
        }
    }

    private boolean setClientRectByValueOfScrollBar(boolean bl) {
        JScrollBar jScrollBar = null;
        jScrollBar = bl ? this.mHScrollBar : this.mVScrollBar;
        float f = this.getScrollValue(jScrollBar);
        Rectangle2D rectangle2D = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getViewportBounds();
        if (bl) {
            float f2 = (float)(rectangle2D.getWidth() - rectangle2D2.getWidth());
            float f3 = -f * f2;
            this.setClientOrigin(f3, (float)this.mClientRect.getY());
        } else {
            float f4 = (float)(rectangle2D.getHeight() - rectangle2D2.getHeight());
            float f5 = -f * f4;
            this.setClientOrigin((float)this.mClientRect.getX(), f5);
        }
        return true;
    }

    public Component getComponent(int n, int n2) {
        Container container = this;
        SGFigure[] sGFigureArray = this.getFigureArrayFromLayer();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            Point point;
            Rectangle2D rectangle2D;
            if (!sGFigureArray[i].isVisible() || !(rectangle2D = sGFigureArray[i].getGraphAreaRect()).contains(point = this.getLocationInPane(n, n2))) continue;
            container = sGFigureArray[i];
            break;
        }
        return container;
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.getWidth() < this.mMinimumWindowSize.width) {
            this.setSize(this.mMinimumWindowSize.width, this.getHeight());
            return;
        }
        if (this.getHeight() < this.mMinimumWindowSize.height) {
            this.setSize(this.getWidth(), this.mMinimumWindowSize.height);
            return;
        }
        this.onResized();
    }

    private int getTopShift() {
        return this.getTopWidth() + 20;
    }

    private int getLeftShift() {
        return this.getLeftWidth() + 20;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.getLeftShift();
        int n2 = this.getTopShift();
        mouseEvent.translatePoint(-n, -n2);
        this.onFigureClicked(mouseEvent);
        mouseEvent.translatePoint(n, n2);
    }

    protected boolean onMouseClicked(MouseEvent mouseEvent) {
        this.mFocusedFigureList.clear();
        this.setDefaultCursor();
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
            this.showPropertyDialog();
        }
        if (!SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.getClickCount() == 1) {
            // empty if block
        }
        return true;
    }

    public boolean showPropertyDialog() {
        SGWindowDialog sGWindowDialog = this.mDialog;
        sGWindowDialog.addPropertySettingListener(this);
        this.mDialog.setLocation(this.getLocation());
        this.setDialogProperty();
        sGWindowDialog.setColorButtonBorder(true);
        this.createTemporaryPropertyObject();
        sGWindowDialog.show();
        sGWindowDialog.removeAllPropertySettingListeners();
        return true;
    }

    protected boolean onFigureClicked(MouseEvent mouseEvent) {
        SGFigure[] sGFigureArray = this.getFigureArrayFromLayer();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (!sGFigureArray[i].isVisible() || !sGFigureArray[i].click(mouseEvent)) continue;
            return true;
        }
        this.onMouseClicked(mouseEvent);
        return false;
    }

    protected boolean onFigureReleased(MouseEvent mouseEvent) {
        JComponent jComponent;
        int n;
        SGFigure[] sGFigureArray = this.getFigureArrayFromLayer();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (!sGFigureArray[i].isVisible()) continue;
            sGFigureArray[i].onToggleSelected(mouseEvent);
            sGFigureArray[i].release(mouseEvent);
        }
        if (sGFigureArray.length == 0) {
            ArrayList arrayList = this.getInsertToggleButtonList();
            for (n = 0; n < arrayList.size(); ++n) {
                jComponent = (AbstractButton)arrayList.get(n);
                if (!((AbstractButton)jComponent).isSelected()) continue;
                SGUtility.showMessageDialog(this, "There is no figure.", "Failed to add a symbol.", 2);
                this.setInsertToggleButtonsSelected(false);
                this.setDefaultCursor();
                break;
            }
        }
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        for (n = 0; n < this.mFocusedFigureList.size(); ++n) {
            jComponent = (SGFigure)this.mFocusedFigureList.get(n);
            if (!((SGFigure)jComponent).isFigureMoved()) continue;
            boolean bl = ((SGFigure)jComponent).updateThisObjectHistory();
            if (!bl) {
                return false;
            }
            arrayList.add(jComponent);
        }
        if (arrayList.size() != 0 && (n = (int)(this.updateObjectHistory(arrayList) ? 1 : 0)) == 0) {
            return false;
        }
        this.updateClientRect();
        this.setScrollBarValue();
        return true;
    }

    protected boolean onFigurePressed(MouseEvent mouseEvent) {
        SGFigure[] sGFigureArray = this.getFigureArrayFromLayer();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (!sGFigureArray[i].isVisible() || !sGFigureArray[i].press(mouseEvent)) continue;
            return true;
        }
        this.onMousePressed(mouseEvent);
        return false;
    }

    protected boolean onFigureDragged(MouseEvent mouseEvent) {
        int n;
        SGFigure[] sGFigureArray = this.getFigureArrayFromLayer();
        for (n = 0; n < sGFigureArray.length; ++n) {
            if (!sGFigureArray[n].isVisible() || !sGFigureArray[n].drag(mouseEvent)) continue;
            this.getContentPane().repaint();
            return true;
        }
        n = this.onMouseMovedOrDragged(mouseEvent) ? 1 : 0;
        if (n != 0) {
            this.getContentPane().repaint();
            return true;
        }
        return false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.getViewportBoundsInComponent().contains(mouseEvent.getPoint())) {
            return;
        }
        this.mViewportPressedFlag = true;
        int n = this.getLeftShift();
        int n2 = this.getTopShift();
        mouseEvent.translatePoint(-n, -n2);
        this.onFigurePressed(mouseEvent);
        mouseEvent.translatePoint(n, n2);
    }

    protected boolean onMousePressed(MouseEvent mouseEvent) {
        this.mFocusedFigureList.clear();
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.clearSelectedElements();
        }
        return true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.mViewportPressedFlag) {
            return;
        }
        int n = this.getLeftShift();
        int n2 = this.getTopShift();
        mouseEvent.translatePoint(-n, -n2);
        this.onFigureReleased(mouseEvent);
        mouseEvent.translatePoint(n, n2);
        this.getContentPane().repaint();
        this.mViewportPressedFlag = false;
    }

    protected boolean onMouseReleased(MouseEvent mouseEvent) {
        this.mFocusedFigureList.clear();
        this.setDefaultCursor();
        return true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.mViewportPressedFlag) {
            return;
        }
        int n = this.getLeftShift();
        int n2 = this.getTopShift();
        mouseEvent.translatePoint(-n, -n2);
        this.onFigureDragged(mouseEvent);
        mouseEvent.translatePoint(n, n2);
        this.onMouseMovedOrDragged(mouseEvent);
    }

    protected boolean onFigureMoved(MouseEvent mouseEvent) {
        SGFigure[] sGFigureArray = this.getFigureArrayFromLayer();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (!sGFigureArray[i].isVisible() || !sGFigureArray[i].move(mouseEvent)) continue;
            return true;
        }
        this.onMouseMovedOrDragged(mouseEvent);
        return true;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.getLeftShift();
        int n2 = this.getTopShift();
        mouseEvent.translatePoint(-n, -n2);
        this.onFigureMoved(mouseEvent);
        mouseEvent.translatePoint(n, n2);
        this.onMouseMovedOrDragged(mouseEvent);
    }

    private boolean onMouseMovedOrDragged(MouseEvent mouseEvent) {
        Point point = this.getLocationInPane(mouseEvent.getX(), mouseEvent.getY());
        int n = point.x;
        int n2 = point.y;
        if (n < 0 || n2 < 0) {
            return true;
        }
        this.setPositionLabel(n, n2);
        return true;
    }

    private Point getLocationInPane(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        Insets insets = this.getInsets();
        int n5 = insets.top;
        int n6 = insets.bottom;
        int n7 = insets.left;
        int n8 = insets.right;
        n3 -= n7;
        n4 -= n5;
        JMenuBar jMenuBar = this.getJMenuBar();
        double d = jMenuBar.getHeight();
        n4 = (int)((double)n4 - d);
        double d2 = this.getToolBarHeight();
        n4 = (int)((double)n4 - d2);
        n3 = (int)((double)n3 - 20.0);
        n4 = (int)((double)n4 - 20.0);
        return new Point(n3, n4);
    }

    protected boolean notifyPosition(Component component, int n, int n2) {
        Insets insets = this.getInsets();
        int n3 = insets.top;
        int n4 = insets.bottom;
        int n5 = insets.left;
        int n6 = insets.right;
        int n7 = n + component.getX();
        int n8 = n2 + component.getY();
        n8 += n3;
        JMenuBar jMenuBar = this.getJMenuBar();
        n8 -= jMenuBar.getHeight();
        if ((n7 -= 20) < 0 || (n8 -= 20) < 0) {
            return true;
        }
        this.setPositionLabel(n7, n8);
        return true;
    }

    private boolean setPositionLabel(int n, int n2) {
        Rectangle2D rectangle2D = this.mClientRect;
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        float f3 = (-f + (float)n) * 0.035277776f / this.mMagnification;
        float f4 = (-f2 + (float)n2) * 0.035277776f / this.mMagnification;
        String string = "(" + decimalFormat.format(f3) + ", " + decimalFormat.format(f4) + ")";
        String string2 = "Window:" + new Integer(this.getID()).toString() + "  " + string;
        this.setTitle(string2);
        return true;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JMenu) {
            JMenu jMenu = (JMenu)object;
            this.menuChanged(changeEvent, jMenu);
        }
    }

    protected boolean menuChanged(ChangeEvent changeEvent, JMenu jMenu) {
        String string = jMenu.getText();
        if (string.equals("Edit")) {
            boolean bl = false;
            ArrayList arrayList = this.getVisibleFigureListFromMap();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                SGIGraphElement sGIGraphElement = sGFigure.getGraphElement();
                if (!sGIGraphElement.hasSelectedData()) continue;
                bl = true;
                break;
            }
            this.getMenuItem(string, "Move Data to Front").setEnabled(bl);
            this.getMenuItem(string, "Move Data to Back").setEnabled(bl);
            this.getMenuItem(string, "Remove Data").setEnabled(bl);
        }
        return true;
    }

    public void addActionListener(ActionListener actionListener) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            return;
        }
        this.mActionListenerList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        for (int i = this.mActionListenerList.size() - 1; i >= 0; --i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            this.mActionListenerList.remove(actionListener);
        }
    }

    public void notifyToListener(String string) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener = (ActionListener)this.mActionListenerList.get(i);
            actionListener.actionPerformed(this.getActionEvent(string));
        }
    }

    private ActionEvent getActionEvent(String string) {
        return new ActionEvent(this, 0, string);
    }

    public void onKeyPressed(KeyEvent keyEvent) {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.onKeyPressed(keyEvent);
        }
    }

    public void onKeyReleased(KeyEvent keyEvent) {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.onKeyReleased(keyEvent);
        }
    }

    public void onKeyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getModifiers();
        if ((n & 2) != 0 || (n & 1) != 0) {
            // empty if block
        }
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.onKeyTyped(keyEvent);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object.equals(this.mDialog)) {
            this.cancel();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        JScrollBar jScrollBar = this.mVScrollBar;
        int n = mouseWheelEvent.getScrollAmount() * mouseWheelEvent.getWheelRotation();
        int n2 = jScrollBar.getValue() + n;
        jScrollBar.setValue(n2);
    }

    public boolean createTemporaryPropertyObject() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    protected ArrayList getInsertToggleButtonList() {
        ArrayList<JToggleButton> arrayList = new ArrayList<JToggleButton>();
        arrayList.add(this.mAddStringButton);
        arrayList.add(this.mAddTimingElementButton);
        arrayList.add(this.mAddSignificantSymbolButton);
        arrayList.add(this.mInsertBreakButton);
        return arrayList;
    }

    protected boolean setInsertToggleButtonsSelected(boolean bl) {
        ArrayList arrayList = this.getInsertToggleButtonList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AbstractButton abstractButton = (AbstractButton)arrayList.get(i);
            abstractButton.setSelected(bl);
        }
        return true;
    }

    protected boolean setInsertToggleButtonsEnabled(boolean bl) {
        ArrayList arrayList = this.getInsertToggleButtonList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AbstractButton abstractButton = (AbstractButton)arrayList.get(i);
            abstractButton.setEnabled(bl);
        }
        return true;
    }

    protected boolean isInsertToggleButtonSelected() {
        ArrayList arrayList = this.getInsertToggleButtonList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AbstractButton abstractButton = (AbstractButton)arrayList.get(i);
            if (!abstractButton.isSelected()) continue;
            return true;
        }
        return false;
    }

    protected void notifyOpen() {
        this.notifyToListener(NOTIFY_OPEN_WINDOW);
    }

    protected void notifyAddData() {
        this.notifyToListener(NOTIFY_ADD_DATA);
    }

    protected void notifyLoadProperty() {
        this.notifyToListener(NOTIFY_LOAD_PROPERTY);
    }

    public boolean closeWindow() {
        WindowEvent windowEvent = new WindowEvent(this, 201);
        WindowListener[] windowListenerArray = this.getWindowListeners();
        for (int i = 0; i < windowListenerArray.length; ++i) {
            windowListenerArray[i].windowClosing(windowEvent);
        }
        this.dispose();
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        Object object;
        Serializable serializable;
        int n;
        Cloneable cloneable;
        String string = actionEvent.getActionCommand();
        Object object2 = actionEvent.getSource();
        if (string.equals("Exit")) {
            System.exit(0);
        } else if (string.equals("Open")) {
            this.notifyOpen();
        } else if (string.equals("Close")) {
            this.closeWindow();
        } else if (string.equals("Draw Graph")) {
            this.notifyAddData();
        } else if (string.equals("Load Property")) {
            this.notifyLoadProperty();
        } else if (string.equals("Save Property")) {
            this.createPropertyFile();
        } else if (string.equals("Export")) {
            try {
                this.export();
            }
            catch (IOException iOException) {
                System.out.println("\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                iOException.printStackTrace();
            }
        } else if (string.equals("Print")) {
            SGUtility.showNotImplementedMessageDialog(this);
        } else if (string.equals("Remove Data")) {
            cloneable = this.getVisibleFigureListFromMap();
            for (n = 0; n < cloneable.size(); ++n) {
                serializable = (SGFigure)cloneable.get(n);
                object = ((SGFigure)serializable).getGraphElement();
                object.hideSelectedData();
            }
        } else if (string.equals("Move Data to Front")) {
            cloneable = this.getVisibleFigureListFromMap();
            for (n = 0; n < cloneable.size(); ++n) {
                serializable = (SGFigure)cloneable.get(n);
                object = ((SGFigure)serializable).getGraphElement();
                object.moveSelectedDataToFront();
            }
        } else if (string.equals("Move Data to Back")) {
            cloneable = this.getVisibleFigureListFromMap();
            for (n = 0; n < cloneable.size(); ++n) {
                serializable = (SGFigure)cloneable.get(n);
                object = ((SGFigure)serializable).getGraphElement();
                object.moveSelectedDataToBack();
            }
        } else if (string.equals("Undo")) {
            this.onUndo();
        } else if (string.equals("Redo")) {
            this.onRedo();
        } else if (string.equals("A4") || string.equals("B5") || string.equals("Letter")) {
            cloneable = null;
            if (string.equals("A4")) {
                cloneable = MediaSize.ISO.A4;
            } else if (string.equals("B5")) {
                cloneable = MediaSize.ISO.B5;
            } else if (string.equals("Letter")) {
                cloneable = MediaSize.NA.LETTER;
            }
            this.onPaperSizeChanged((MediaSize)cloneable);
        } else if (string.equals("Bounding Box")) {
            this.setBoundigBox();
        } else if (string.equals("Align Figures")) {
            this.onFiguresAligned();
        } else if (string.equals("About")) {
            this.onAbout();
        }
        if (object2.equals(this.mMagnificationComboBox)) {
            this.onZoomed();
        }
        if (object2.equals(this.mCreateNewGraphButton)) {
            this.notifyOpen();
        }
        if (object2.equals(this.mDrawGraphButton)) {
            this.notifyAddData();
        }
        if (object2.equals(this.mLoadPropertyButton)) {
            this.notifyLoadProperty();
        }
        if (object2.equals(this.mBoundingBoxButton)) {
            this.setBoundigBox();
        }
        if ((cloneable = this.getInsertToggleButtonList()).contains(object2)) {
            AbstractButton abstractButton = (AbstractButton)object2;
            if (abstractButton.isSelected()) {
                serializable = new Cursor(1);
                this.setCursor((Cursor)serializable);
            } else {
                this.setDefaultCursor();
            }
            for (int i = 0; i < cloneable.size(); ++i) {
                object = (AbstractButton)cloneable.get(i);
                if (abstractButton.equals(object)) continue;
                ((AbstractButton)object).setSelected(false);
            }
        }
        if (object2.equals(this.mLockFigureButton)) {
            this.setLockToggleButton(this.mLockFigureButton.isSelected());
            this.mLockFigureFlag = this.mLockFigureButton.isSelected();
            if (this.mLockFigureFlag) {
                // empty if block
            }
        }
        if (object2.equals(this.mExportImageButton)) {
            try {
                this.export();
            }
            catch (IOException iOException) {
                System.out.println("\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
        }
        if (object2.equals(this.mSaveGraphButton) && !(bl = this.createPropertyFile())) {
            System.out.println("\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        this.getContentPane().repaint();
    }

    private boolean onAbout() {
        SGAboutDialog sGAboutDialog = this.mAboutDialog;
        int n = sGAboutDialog.getWidth();
        int n2 = sGAboutDialog.getHeight();
        int n3 = this.getX() + this.getWidth() / 2 - n / 2;
        int n4 = this.getY() + this.getHeight() / 2 - n2 / 2;
        sGAboutDialog.setLocation(n3, n4);
        sGAboutDialog.show();
        return true;
    }

    private boolean onFiguresAligned() {
        int n;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.updateFigureRect();
        }
        if (!this.alignFiguresByGraphArea()) {
            return false;
        }
        ArrayList<Container> arrayList2 = new ArrayList<Container>();
        for (n = 0; n < arrayList.size(); ++n) {
            SGFigure sGFigure = (SGFigure)arrayList.get(n);
            if (!sGFigure.isFigureMoved()) continue;
            boolean bl = sGFigure.updateHistory();
            if (!bl) {
                return false;
            }
            arrayList2.add(sGFigure);
        }
        if (!this.updateHistory()) {
            return false;
        }
        arrayList2.add(this);
        n = this.updateObjectHistory(arrayList2) ? 1 : 0;
        return n != 0;
    }

    private boolean onPaperSizeChanged(MediaSize mediaSize) {
        int n;
        Rectangle rectangle = this.getPaperRect().getBounds();
        this.setPaperSize(mediaSize);
        Rectangle rectangle2 = this.getPaperRect().getBounds();
        if (rectangle.equals(rectangle2)) {
            return true;
        }
        this.updateClientRect();
        this.setScrollBarValue();
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.updateFigureRect();
        }
        ArrayList<Container> arrayList2 = new ArrayList<Container>();
        for (n = 0; n < arrayList.size(); ++n) {
            SGFigure sGFigure = (SGFigure)arrayList.get(n);
            if (!sGFigure.isFigureMoved()) continue;
            boolean bl = sGFigure.updateHistory();
            if (!bl) {
                return false;
            }
            arrayList2.add(sGFigure);
        }
        if (!this.updateHistory()) {
            return false;
        }
        arrayList2.add(this);
        n = this.updateObjectHistory(arrayList2) ? 1 : 0;
        return n != 0;
    }

    private boolean setBoundigBox() {
        Rectangle rectangle = this.getPaperRect().getBounds();
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        if (arrayList.size() != 0) {
            this.setFigureBoundingBox(0);
            Rectangle rectangle2 = this.getPaperRect().getBounds();
            if (rectangle.equals(rectangle2)) {
                return true;
            }
            if (!this.updateHistory()) {
                return false;
            }
        } else {
            SGUtility.showMessageDialog(this, "There is no figure.", "Failed to get the Bounding box.", 2);
        }
        return true;
    }

    public boolean setPaperSize(MediaSize mediaSize) {
        if (mediaSize == null) {
            return false;
        }
        BigDecimal bigDecimal = new BigDecimal(mediaSize.getX(1000));
        BigDecimal bigDecimal2 = new BigDecimal(mediaSize.getY(1000));
        bigDecimal = bigDecimal.movePointLeft(1);
        bigDecimal2 = bigDecimal2.movePointLeft(1);
        float f = bigDecimal.floatValue();
        float f2 = bigDecimal2.floatValue();
        this.setPaperSizeRoundingOutInCMUnit(f, f2);
        return true;
    }

    protected boolean setPaperSizeRoundingOutInCMUnit(float f, float f2) {
        float f3 = (float)SGUtilityNumber.roundOutNumber(f, -2);
        float f4 = (float)SGUtilityNumber.roundOutNumber(f2, -2);
        float f5 = f3 / 0.035277776f;
        float f6 = f4 / 0.035277776f;
        float f7 = f5 * this.mMagnification;
        float f8 = f6 * this.mMagnification;
        this.setPaperSize(f7, f8);
        return true;
    }

    protected boolean setPaperSizeRoundingOut(float f, float f2) {
        float f3 = f * 0.035277776f;
        float f4 = f2 * 0.035277776f;
        this.setPaperSizeRoundingOutInCMUnit(f3, f4);
        return true;
    }

    public boolean initPropertiesHistory() {
        WindowProperties windowProperties = (WindowProperties)this.getProperties();
        this.addWindowPropertiesHistory(windowProperties);
        return true;
    }

    private boolean addWindowPropertiesHistory(WindowProperties windowProperties) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.mWindowStateCounter; ++i) {
            arrayList.add(this.mWindowPropertyHistoryList.get(i));
        }
        arrayList.add(windowProperties);
        this.mWindowPropertyHistoryList = arrayList;
        return true;
    }

    public boolean commit() {
        boolean bl = this.setPropertiesFromDialog();
        if (!bl) {
            return false;
        }
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.updateHistory();
        }
        this.mTemporaryProperties = null;
        this.mDialog.removePropertySettingListener(this);
        this.getContentPane().repaint();
        return true;
    }

    public boolean updateHistory() {
        this.updateThisObjectHistory();
        return true;
    }

    public boolean updateThisObjectHistory() {
        this.updateObjectHistory(this);
        ++this.mWindowStateCounter;
        this.addWindowPropertiesHistory((WindowProperties)this.getProperties());
        return true;
    }

    public boolean updateParentHistory() {
        return true;
    }

    public boolean cancel() {
        if (!this.setProperties(this.mTemporaryProperties)) {
            return false;
        }
        this.mTemporaryProperties = null;
        this.mDialog.removePropertySettingListener(this);
        this.updateClientRect();
        this.setScrollBarValue();
        this.getContentPane().repaint();
        return true;
    }

    private WindowProperties readProperties(BufferedReader bufferedReader) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        WindowProperties windowProperties = new WindowProperties();
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        if (!string.equals(WINDOW_TITLE)) {
            return null;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d = SGUtilityText.getDoublePropertyFromLine(string, KEY_PAPER_WIDTH);
        if (d == null) {
            return null;
        }
        float f = d.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d2 = SGUtilityText.getDoublePropertyFromLine(string, KEY_PAPER_HEIGHT);
        if (d2 == null) {
            return null;
        }
        float f2 = d2.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d3 = SGUtilityText.getDoublePropertyFromLine(string, KEY_GRID_INTERVAL);
        if (d3 == null) {
            return null;
        }
        float f3 = d3.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d4 = SGUtilityText.getDoublePropertyFromLine(string, KEY_GRID_LINE_WIDTH);
        if (d4 == null) {
            return null;
        }
        float f4 = d4.floatValue();
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Color color = SGUtilityText.getColorPropertyFromLine(string, KEY_BACKGROUND_COLOR);
        if (color == null) {
            return null;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Color color2 = SGUtilityText.getColorPropertyFromLine(string, KEY_GRID_COLOR);
        if (color2 == null) {
            return null;
        }
        windowProperties.setPaperWidth(f);
        windowProperties.setPaperHeight(f2);
        windowProperties.setGridInterval(f3);
        windowProperties.setGridLineWidth(f4);
        windowProperties.setBackGroundColor(color);
        windowProperties.setGridColor(color2);
        windowProperties.figureMap = this.mFigureMap;
        windowProperties.visibleFigureList = this.getVisibleFigureIDList();
        return windowProperties;
    }

    public boolean preview() {
        this.setPropertiesFromDialog();
        this.getContentPane().repaint();
        return true;
    }

    protected boolean setDefaultCursor() {
        Cursor cursor = Cursor.getDefaultCursor();
        this.setCursor(cursor);
        return true;
    }

    private boolean setDialogProperty() {
        SGWindowDialog sGWindowDialog = this.mDialog;
        sGWindowDialog.setWindowWidth(this.mPaperSize.x * 0.035277776f);
        sGWindowDialog.setWindowHeight(this.mPaperSize.y * 0.035277776f);
        sGWindowDialog.setWindowGridLinesInterval(this.mGridInterval * 0.035277776f);
        sGWindowDialog.setWindowGridLinesWidth(this.mGridLineWidth);
        sGWindowDialog.setWindowBackgroundColor(this.mBackgroundColor);
        sGWindowDialog.setWindowGridLinesColor(this.mGridLineColor);
        return true;
    }

    public boolean setPropertiesFromDialog() {
        WindowProperties windowProperties = this.getPropertiesFromDialog();
        if (!this.setProperties(windowProperties)) {
            return false;
        }
        this.updateClientRect();
        this.setScrollBarValue();
        return true;
    }

    private boolean updateClientRect() {
        double d;
        boolean bl;
        boolean bl2;
        Rectangle2D rectangle2D;
        Rectangle2D rectangle2D2;
        this.fitClientRectToBBRect(true);
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), true)) {
            this.fitClientRectToVPRect(true);
        }
        if (!SGUtility.isRectContains(this.getClientRect(), this.getViewportBounds(), true)) {
            rectangle2D2 = this.getClientRect();
            rectangle2D = this.getViewportBounds();
            bl2 = SGUtility.isRectContains(rectangle2D2, rectangle2D.getX(), true);
            bl = SGUtility.isRectContains(rectangle2D2, rectangle2D.getX() + rectangle2D.getWidth(), true);
            d = 0.0;
            if (!bl2 && bl) {
                d = rectangle2D.getX() - rectangle2D2.getX();
            } else if (bl2 && !bl) {
                d = rectangle2D.getX() + rectangle2D.getWidth() - (rectangle2D2.getX() + rectangle2D2.getWidth());
            } else if (!bl2 && !bl) {
                d = rectangle2D2.getX() < rectangle2D.getX() ? rectangle2D.getX() + rectangle2D.getWidth() - (rectangle2D2.getX() + rectangle2D2.getWidth()) : rectangle2D.getX() - rectangle2D2.getX();
            }
            this.setClientOrigin((float)(rectangle2D2.getX() + d), (float)rectangle2D2.getY());
        }
        this.fitClientRectToBBRect(false);
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), false)) {
            this.fitClientRectToVPRect(false);
        }
        if (!SGUtility.isRectContains(this.getClientRect(), this.getViewportBounds(), false)) {
            rectangle2D2 = this.getClientRect();
            rectangle2D = this.getViewportBounds();
            bl2 = SGUtility.isRectContains(rectangle2D2, rectangle2D.getY(), false);
            bl = SGUtility.isRectContains(rectangle2D2, rectangle2D.getY() + rectangle2D.getHeight(), false);
            d = 0.0;
            if (!bl2 && bl) {
                d = rectangle2D.getY() - rectangle2D2.getY();
            } else if (bl2 && !bl) {
                d = rectangle2D.getY() + rectangle2D.getHeight() - (rectangle2D2.getY() + rectangle2D2.getHeight());
            } else if (!bl2 && !bl) {
                d = rectangle2D2.getY() < rectangle2D.getY() ? rectangle2D.getY() + rectangle2D.getHeight() - (rectangle2D2.getY() + rectangle2D2.getHeight()) : rectangle2D.getY() - rectangle2D2.getY();
            }
            this.setClientOrigin((float)rectangle2D2.getX(), (float)(rectangle2D2.getY() + d));
        }
        this.setScrollBarValue();
        this.setEnableScrollBars();
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), true)) {
            this.fitClientRectToVPRect(true);
        }
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), false)) {
            this.fitClientRectToVPRect(false);
        }
        return true;
    }

    protected boolean updateClientRectNew() {
        this.updateClientRect(true);
        this.updateClientRect(false);
        this.setScrollBarValue();
        this.setEnableScrollBars();
        return true;
    }

    protected boolean updateClientRect(boolean bl) {
        Rectangle2D rectangle2D = this.getBoundingBox();
        Rectangle2D rectangle2D2 = this.getClientRect();
        Rectangle2D rectangle2D3 = this.getViewportBounds();
        this.fitClientRectToBBRect(bl);
        return true;
    }

    private boolean fitClientRectToBBRect(boolean bl) {
        Rectangle2D rectangle2D = this.getBoundingBox();
        if (rectangle2D == null) {
            return false;
        }
        Rectangle2D rectangle2D2 = this.mClientRect;
        if (bl) {
            rectangle2D2.setRect(rectangle2D.getX(), rectangle2D2.getY(), rectangle2D.getWidth(), rectangle2D2.getHeight());
        } else {
            rectangle2D2.setRect(rectangle2D2.getX(), rectangle2D.getY(), rectangle2D2.getWidth(), rectangle2D.getHeight());
        }
        return true;
    }

    private boolean fitClientRectToVPRect(boolean bl) {
        Rectangle2D rectangle2D = this.getViewportBounds();
        if (rectangle2D == null) {
            return false;
        }
        Rectangle2D rectangle2D2 = this.mClientRect;
        if (bl) {
            rectangle2D2.setRect(rectangle2D.getX(), rectangle2D2.getY(), rectangle2D.getWidth(), rectangle2D2.getHeight());
        } else {
            rectangle2D2.setRect(rectangle2D2.getX(), rectangle2D.getY(), rectangle2D2.getWidth(), rectangle2D.getHeight());
        }
        return true;
    }

    protected boolean setEnableScrollBars() {
        Rectangle2D rectangle2D = this.getViewportBoundsInClientRect();
        Rectangle2D rectangle2D2 = this.getBoundingBox();
        if (rectangle2D == null || rectangle2D2 == null) {
            return false;
        }
        boolean bl = SGUtilityNumber.contains(rectangle2D.getX(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D2.getX(), rectangle2D2.getX() + rectangle2D2.getWidth());
        boolean bl2 = SGUtilityNumber.contains(rectangle2D.getY(), rectangle2D.getY() + rectangle2D.getHeight(), rectangle2D2.getY(), rectangle2D2.getY() + rectangle2D2.getHeight());
        this.mHScrollBar.setVisible(!bl);
        this.mVScrollBar.setVisible(!bl2);
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof WindowProperties)) {
            return false;
        }
        WindowProperties windowProperties = (WindowProperties)sGProperties;
        Float f = windowProperties.getPaperWidth();
        Float f2 = windowProperties.getPaperHeight();
        if (f == null || f2 == null) {
            return false;
        }
        this.mPaperSize.setValues(f.floatValue(), f2.floatValue());
        Color color = windowProperties.getBackgroundColor();
        if (color == null) {
            return false;
        }
        this.setBackgroundColor(color);
        Color color2 = windowProperties.getGridColor();
        if (color2 == null) {
            return false;
        }
        this.setGridLineColor(color2);
        Float f3 = windowProperties.getGridInterval();
        if (f3 == null) {
            return false;
        }
        this.setGridInterval(f3.floatValue());
        Float f4 = windowProperties.getGridLineWidth();
        if (f4 == null) {
            return false;
        }
        this.setGridLineWidth(f4.floatValue());
        this.mFigureMap = windowProperties.figureMap;
        this.setFigureVisible(new ArrayList(windowProperties.visibleFigureList));
        return true;
    }

    public SGProperties getProperties() {
        WindowProperties windowProperties = new WindowProperties();
        windowProperties.setPaperWidth(this.mPaperSize.x);
        windowProperties.setPaperHeight(this.mPaperSize.y);
        windowProperties.setBackGroundColor(this.mBackgroundColor);
        windowProperties.setGridColor(this.mGridLineColor);
        windowProperties.setGridInterval(this.mGridInterval);
        windowProperties.setGridLineWidth(this.mGridLineWidth);
        windowProperties.figureMap = this.mFigureMap;
        windowProperties.visibleFigureList = new ArrayList(this.getVisibleFigureIDList());
        return windowProperties;
    }

    protected ArrayList getVisibleFigureIDList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList arrayList2 = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList2.get(i);
            int n = sGFigure.getID();
            arrayList.add(new Integer(n));
        }
        return arrayList;
    }

    protected boolean setFigureVisible(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        SGFigure[] sGFigureArray = this.getFigureArrayFromMap();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            int n = sGFigureArray[i].getID();
            if (arrayList.contains(new Integer(n))) {
                sGFigureArray[i].setVisible(true);
                continue;
            }
            sGFigureArray[i].setVisible(false);
        }
        return true;
    }

    private WindowProperties getPropertiesFromDialog() {
        WindowProperties windowProperties = this.mDialog.getProperties();
        if (windowProperties == null) {
            return null;
        }
        windowProperties.figureMap = this.mFigureMap;
        windowProperties.visibleFigureList = this.getVisibleFigureIDList();
        return windowProperties;
    }

    protected boolean setDraggingRectOfFocusedFigures() {
        for (int i = 0; i < this.mFocusedFigureList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)this.mFocusedFigureList.get(i);
            sGFigure.setDraggingRect();
        }
        return true;
    }

    public Rectangle2D getClientRect() {
        return this.mClientRect;
    }

    public boolean setClientOrigin(float f, float f2) {
        this.setClientRect(f, f2, (float)this.mClientRect.getWidth(), (float)this.mClientRect.getHeight());
        return true;
    }

    public boolean setClientSize(float f, float f2) {
        this.setClientRect((float)this.mClientRect.getX(), (float)this.mClientRect.getY(), f, f2);
        return true;
    }

    public void dumpClientRect() {
        Rectangle2D rectangle2D = this.mClientRect;
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        System.out.println("x=" + d * 0.035277776420116425 + "cm, y=" + d2 * 0.035277776420116425 + "cm");
        System.out.println("w=" + d3 * 0.035277776420116425 + "cm, h=" + d4 * 0.035277776420116425 + "cm");
        System.out.println();
    }

    public void dumpRect() {
        Rectangle2D rectangle2D = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getViewportBounds();
        Rectangle2D rectangle2D3 = this.getBoundingBox();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        Rectangle2D.Float float_2 = new Rectangle2D.Float();
        Rectangle2D.Float float_3 = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect((float)rectangle2D.getX() * 0.035277776f, (float)rectangle2D.getY() * 0.035277776f, (float)rectangle2D.getWidth() * 0.035277776f, (float)rectangle2D.getHeight() * 0.035277776f);
        ((Rectangle2D)float_2).setRect((float)rectangle2D2.getX() * 0.035277776f, (float)rectangle2D2.getY() * 0.035277776f, (float)rectangle2D2.getWidth() * 0.035277776f, (float)rectangle2D2.getHeight() * 0.035277776f);
        ((Rectangle2D)float_3).setRect((float)rectangle2D3.getX() * 0.035277776f, (float)rectangle2D3.getY() * 0.035277776f, (float)rectangle2D3.getWidth() * 0.035277776f, (float)rectangle2D3.getHeight() * 0.035277776f);
        System.out.println("client:" + float_);
        System.out.println("viewport:" + float_2);
        System.out.println("bounding box:" + float_3);
    }

    public boolean setClientRect(Rectangle2D rectangle2D) {
        this.mClientRect.setRect(rectangle2D);
        return true;
    }

    public boolean setClientRect(float f, float f2, float f3, float f4) {
        this.mClientRect.setRect(f, f2, f3, f4);
        return true;
    }

    public Rectangle2D getViewportBoundsInClientRect() {
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        float f3 = -((float)this.mClientRect.getX());
        float f4 = -((float)this.mClientRect.getY());
        Rectangle2D.Float float_ = new Rectangle2D.Float(f3, f4, f, f2);
        return float_;
    }

    public Rectangle2D getViewportBounds() {
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
        return float_;
    }

    public Rectangle2D getViewportBoundsInLayeredPane() {
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        Rectangle2D.Float float_ = new Rectangle2D.Float(20.0f, 20.0f, f, f2);
        return float_;
    }

    public Rectangle2D getViewportBoundsInComponent() {
        int n = this.getTopWidth();
        int n2 = this.getLeftWidth();
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        Rectangle2D.Float float_ = new Rectangle2D.Float(n2, n, f, f2);
        return float_;
    }

    protected SGFigure[][] getOrderedFigureArray() {
        int n;
        int n2;
        int n3;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        int n4 = arrayList.size();
        if (n4 == 0) {
            return new SGFigure[0][0];
        }
        int n5 = 0;
        for (n3 = 1; n3 <= 16; ++n3) {
            n2 = (n3 - 1) * (n3 - 1);
            n = n3 * n3;
            if (n2 >= n4 || n4 > n) continue;
            n5 = n3;
            break;
        }
        n3 = n5;
        n2 = n4 / n3;
        n = n4 % n3 == 0 ? n2 : n2 + 1;
        SGFigure[][] sGFigureArray = new SGFigure[n][n3];
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n6 = i * n3 + j;
                if (n6 >= arrayList.size()) {
                    bl = false;
                    break;
                }
                sGFigureArray[i][j] = (SGFigure)arrayList.get(n6);
            }
            if (!bl) break;
        }
        return sGFigureArray;
    }

    public boolean alignFiguresByGraphArea() {
        boolean bl;
        int n;
        int n2;
        int n3;
        Object object;
        float f;
        float f2;
        float f3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        if (arrayList.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D = this.mClientRect;
        float f4 = Float.MAX_VALUE;
        float f5 = Float.MAX_VALUE;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            Rectangle2D rectangle2D2 = sGFigure.getGraphAreaRect();
            if (rectangle2D2.getWidth() < (double)f4) {
                f4 = (float)rectangle2D2.getWidth();
            }
            if (!(rectangle2D2.getHeight() < (double)f5)) continue;
            f5 = (float)rectangle2D2.getHeight();
        }
        float f6 = f4;
        float f7 = f5;
        int n9 = (int)((float)rectangle2D.getWidth() / f6) + 1;
        int n10 = (int)((float)rectangle2D.getHeight() / f7) + 1;
        ArrayList[][] arrayListArray = new ArrayList[n9][n10];
        for (n8 = 0; n8 < n9; ++n8) {
            for (int i = 0; i < n10; ++i) {
                arrayListArray[n8][i] = new ArrayList();
            }
        }
        for (n8 = 0; n8 < arrayList.size(); ++n8) {
            SGFigure sGFigure = (SGFigure)arrayList.get(n8);
            Rectangle2D rectangle2D3 = sGFigure.getGraphAreaRect();
            n7 = (int)((rectangle2D3.getCenterX() - rectangle2D.getX()) / (double)f6);
            n6 = (int)((rectangle2D3.getCenterY() - rectangle2D.getY()) / (double)f7);
            arrayListArray[n7][n6].add(sGFigure);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < n9; ++i) {
            boolean bl2 = false;
            for (n7 = 0; n7 < n10; ++n7) {
                if (arrayListArray[i][n7].size() == 0) continue;
                bl2 = true;
                break;
            }
            if (!bl2) continue;
            arrayList2.add(new Integer(i));
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (n5 = 0; n5 < n10; ++n5) {
            n7 = 0;
            for (n6 = 0; n6 < n9; ++n6) {
                if (arrayListArray[n6][n5].size() == 0) continue;
                n7 = 1;
                break;
            }
            if (n7 == 0) continue;
            arrayList3.add(new Integer(n5));
        }
        n5 = arrayList2.size();
        n7 = arrayList3.size();
        ArrayList[][] arrayListArray2 = new ArrayList[n5][n7];
        for (int i = 0; i < n5; ++i) {
            int n11 = (Integer)arrayList2.get(i);
            for (int j = 0; j < n7; ++j) {
                int n12 = (Integer)arrayList3.get(j);
                arrayListArray2[i][j] = arrayListArray[n11][n12];
            }
        }
        float[][] fArray = new float[n5][n7];
        float[][] fArray2 = new float[n5][n7];
        float[][] fArray3 = new float[n5][n7];
        float[][] fArray4 = new float[n5][n7];
        for (int i = 0; i < n5; ++i) {
            for (n4 = 0; n4 < n7; ++n4) {
                if (arrayListArray2[i][n4] == null) continue;
                ArrayList arrayList4 = arrayListArray2[i][n4];
                float f8 = 0.0f;
                f3 = 0.0f;
                f2 = 0.0f;
                f = 0.0f;
                for (int j = 0; j < arrayList4.size(); ++j) {
                    SGFigure sGFigure = (SGFigure)arrayList4.get(j);
                    Rectangle2D rectangle2D4 = sGFigure.getGraphAreaRect();
                    SGTuple2f sGTuple2f = new SGTuple2f();
                    object = new SGTuple2f();
                    sGFigure.calcMargin(sGTuple2f, (SGTuple2f)object);
                    if (sGTuple2f.x + (float)rectangle2D4.getHeight() > f8) {
                        f8 = sGTuple2f.x + (float)rectangle2D4.getHeight();
                    }
                    if (sGTuple2f.y > f3) {
                        f3 = sGTuple2f.y;
                    }
                    if (((SGTuple2f)object).x > f2) {
                        f2 = ((SGTuple2f)object).x;
                    }
                    if (!(((SGTuple2f)object).y + (float)rectangle2D4.getWidth() > f)) continue;
                    f = ((SGTuple2f)object).y + (float)rectangle2D4.getWidth();
                }
                fArray[i][n4] = f8;
                fArray2[i][n4] = f3;
                fArray3[i][n4] = f2;
                fArray4[i][n4] = f;
            }
        }
        float[] fArray5 = new float[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            float f9 = 0.0f;
            for (int i = 0; i < n7; ++i) {
                f3 = fArray3[n4][i] + fArray4[n4][i];
                if (!(f3 > f9)) continue;
                f9 = f3;
            }
            fArray5[n4] = f9;
        }
        float[] fArray6 = new float[n7];
        for (int i = 0; i < n7; ++i) {
            float f10 = 0.0f;
            for (int j = 0; j < n5; ++j) {
                f2 = fArray[j][i] + fArray2[j][i];
                if (!(f2 > f10)) continue;
                f10 = f2;
            }
            fArray6[i] = f10;
        }
        float[] fArray7 = new float[n5];
        for (int i = 0; i < n5; ++i) {
            float f11 = 0.0f;
            for (int j = 0; j < n7; ++j) {
                f = fArray3[i][j];
                if (!(f > f11)) continue;
                f11 = f;
            }
            fArray7[i] = f11;
        }
        float[] fArray8 = new float[n7];
        for (int i = 0; i < n7; ++i) {
            float f12 = 0.0f;
            for (int j = 0; j < n5; ++j) {
                float f13 = fArray2[j][i];
                if (!(f13 > f12)) continue;
                f12 = f13;
            }
            fArray8[i] = f12;
        }
        float[] fArray9 = new float[n5];
        float f14 = (float)rectangle2D.getX();
        for (int i = 0; i < n5; ++i) {
            fArray9[i] = f14 + fArray7[i];
            f14 += fArray5[i];
        }
        float[] fArray10 = new float[n7];
        float f15 = (float)rectangle2D.getY();
        for (n3 = 0; n3 < n7; ++n3) {
            fArray10[n3] = f15 + fArray6[n3] - fArray8[n3];
            f15 += fArray6[n3];
        }
        n3 = 1;
        for (n2 = 0; n2 < n7; ++n2) {
            for (int i = 0; i < n5; ++i) {
                object = arrayListArray2[i][n2];
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    SGFigure sGFigure = (SGFigure)((ArrayList)object).get(n);
                    if (sGFigure == null) {
                        n3 = 0;
                        break;
                    }
                    if (sGFigure.setGraphAreaLocationByLeftBottom(fArray9[i], fArray10[n2])) continue;
                    return false;
                }
                if (n3 == 0) break;
            }
            if (n3 == 0) break;
        }
        n2 = -1;
        float f16 = 0.0f;
        float f17 = 0.0f;
        for (n = 0; n < fArray5.length; ++n) {
            f16 += fArray5[n];
        }
        for (n = 0; n < fArray6.length; ++n) {
            f17 += fArray6[n];
        }
        Rectangle2D rectangle2D5 = this.getPaperRect();
        boolean bl3 = rectangle2D5.getWidth() < (double)f16;
        boolean bl4 = bl = rectangle2D5.getHeight() < (double)f17;
        if (bl3 & bl) {
            n2 = 0;
        } else if (bl3) {
            n2 = 1;
        } else if (bl) {
            n2 = 2;
        }
        return n2 == -1 || this.setFigureBoundingBox(n2);
    }

    public boolean alignFiguresByBoundingBox() {
        boolean bl;
        int n;
        int n2;
        float f;
        int n3;
        SGFigure[][] sGFigureArray = this.getOrderedFigureArray();
        if (sGFigureArray == null) {
            return false;
        }
        if (sGFigureArray.length == 0) {
            return true;
        }
        int n4 = sGFigureArray.length;
        int n5 = sGFigureArray[0].length;
        Rectangle2D[][] rectangle2DArray = new Rectangle2D[n4][n5];
        boolean bl2 = true;
        for (int i = 0; i < n4; ++i) {
            for (n3 = 0; n3 < n5; ++n3) {
                if (sGFigureArray[i][n3] == null) {
                    bl2 = false;
                    break;
                }
                rectangle2DArray[i][n3] = sGFigureArray[i][n3].getBoundingBox();
            }
            if (!bl2) break;
        }
        float[] fArray = new float[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            Rectangle2D rectangle2D;
            float f2 = 0.0f;
            for (int i = 0; i < n4 && (rectangle2D = rectangle2DArray[i][n3]) != null; ++i) {
                float f3 = (float)rectangle2DArray[i][n3].getWidth();
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            fArray[n3] = f2;
        }
        float[] fArray2 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            Rectangle2D rectangle2D;
            float f4 = 0.0f;
            for (int j = 0; j < n5 && (rectangle2D = rectangle2DArray[i][j]) != null; ++j) {
                f = (float)rectangle2DArray[i][j].getHeight();
                if (!(f > f4)) continue;
                f4 = f;
            }
            fArray2[i] = f4;
        }
        Rectangle2D rectangle2D = this.getClientRect();
        float[] fArray3 = new float[n5];
        float f5 = (float)rectangle2D.getX();
        for (int i = 0; i < n5; ++i) {
            fArray3[i] = f5 + fArray[i] / 2.0f;
            f5 += fArray[i];
        }
        float[] fArray4 = new float[n4];
        f = (float)rectangle2D.getY();
        for (n2 = 0; n2 < n4; ++n2) {
            fArray4[n2] = f + fArray2[n2] / 2.0f;
            f += fArray2[n2];
        }
        bl2 = true;
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = 0; i < n5; ++i) {
                int n6 = n2 * n5 + i;
                SGFigure sGFigure = sGFigureArray[n2][i];
                if (sGFigure == null) {
                    bl2 = false;
                    break;
                }
                if (sGFigure.setCenter(fArray3[i], fArray4[n2])) continue;
                return false;
            }
            if (!bl2) break;
        }
        n2 = -1;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (n = 0; n < fArray.length; ++n) {
            f6 += fArray[n];
        }
        for (n = 0; n < fArray2.length; ++n) {
            f7 += fArray2[n];
        }
        Rectangle2D rectangle2D2 = this.getPaperRect();
        boolean bl3 = rectangle2D2.getWidth() < (double)f6;
        boolean bl4 = bl = rectangle2D2.getHeight() < (double)f7;
        if (bl3 & bl) {
            n2 = 0;
        } else if (bl3) {
            n2 = 1;
        } else if (bl) {
            n2 = 2;
        }
        return n2 == -1 || this.setFigureBoundingBox(n2);
    }

    public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
        ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
        arrayList.add(sGIUndoable);
        boolean bl = this.updateObjectHistory(arrayList);
        return bl;
    }

    public boolean updateObjectHistory(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < this.mCurrentStateCounter; ++i) {
            Object e = this.mUndoableObjectHistoryList.get(i);
            arrayList2.add(e);
        }
        arrayList2.add(new ArrayList(arrayList));
        this.mUndoableObjectHistoryList = arrayList2;
        ++this.mCurrentStateCounter;
        this.setUndoMenuItem();
        return true;
    }

    public boolean undo() {
        --this.mWindowStateCounter;
        WindowProperties windowProperties = (WindowProperties)this.mWindowPropertyHistoryList.get(this.mWindowStateCounter);
        this.setProperties(windowProperties);
        return true;
    }

    public boolean redo() {
        ++this.mWindowStateCounter;
        WindowProperties windowProperties = (WindowProperties)this.mWindowPropertyHistoryList.get(this.mWindowStateCounter);
        this.setProperties(windowProperties);
        return true;
    }

    public boolean onUndo() {
        if (this.mCurrentStateCounter == 0) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter - 1);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this) ? this.undo() : sGIUndoable.onUndo();
            if (bl) continue;
            return false;
        }
        --this.mCurrentStateCounter;
        this.mFocusedFigureList.clear();
        this.setUndoMenuItem();
        this.updateClientRect();
        this.setScrollBarValue();
        return true;
    }

    public boolean onRedo() {
        if (this.mCurrentStateCounter == this.mUndoableObjectHistoryList.size()) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this) ? this.redo() : sGIUndoable.onRedo();
            if (bl) continue;
            return false;
        }
        ++this.mCurrentStateCounter;
        this.mFocusedFigureList.clear();
        this.setUndoMenuItem();
        this.updateClientRect();
        this.setScrollBarValue();
        return true;
    }

    private boolean setUndoMenuItem() {
        JMenuItem jMenuItem = this.getMenuItem("Edit", "Undo");
        if (this.mCurrentStateCounter == 0) {
            jMenuItem.setEnabled(false);
        } else {
            jMenuItem.setEnabled(true);
        }
        jMenuItem = this.getMenuItem("Edit", "Redo");
        if (this.mCurrentStateCounter == this.mUndoableObjectHistoryList.size()) {
            jMenuItem.setEnabled(false);
        } else {
            jMenuItem.setEnabled(true);
        }
        return true;
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.addChangeListener(this);
        JMenuItem jMenuItem = new JMenuItem("Open");
        jMenuItem.setActionCommand("Open");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Close");
        jMenuItem2.setActionCommand("Close");
        jMenuItem2.addActionListener(this);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Draw Graph");
        jMenuItem3.setActionCommand("Draw Graph");
        jMenuItem3.addActionListener(this);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Load Property");
        jMenuItem4.setActionCommand("Load Property");
        jMenuItem4.addActionListener(this);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Save Property");
        jMenuItem5.setActionCommand("Save Property");
        jMenuItem5.addActionListener(this);
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem("Export");
        jMenuItem6.setActionCommand("Export");
        jMenuItem6.addActionListener(this);
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenu.add(jMenuItem6);
        jMenu.addSeparator();
        JMenuItem jMenuItem7 = new JMenuItem("Print");
        jMenuItem7.setActionCommand("Print");
        jMenuItem7.addActionListener(this);
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenu.add(jMenuItem7);
        jMenu.addSeparator();
        JMenuItem jMenuItem8 = new JMenuItem("Exit");
        jMenuItem8.setActionCommand("Exit");
        jMenuItem8.addActionListener(this);
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jMenu.add(jMenuItem8);
        jMenu = new JMenu("Edit");
        jMenuBar.add(jMenu);
        jMenu.addChangeListener(this);
        jMenuItem = new JMenuItem("Undo");
        jMenuItem.setActionCommand("Undo");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        jMenu.add(jMenuItem);
        jMenuItem.setEnabled(false);
        jMenuItem2 = new JMenuItem("Redo");
        jMenuItem2.setActionCommand("Redo");
        jMenuItem2.addActionListener(this);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        jMenu.add(jMenuItem2);
        jMenuItem2.setEnabled(false);
        jMenu.addSeparator();
        jMenuItem3 = new JMenuItem("Move Data to Front");
        jMenuItem3.setActionCommand("Move Data to Front");
        jMenuItem3.addActionListener(this);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        jMenu.add(jMenuItem3);
        jMenuItem3.setEnabled(false);
        jMenuItem4 = new JMenuItem("Move Data to Back");
        jMenuItem4.setActionCommand("Move Data to Back");
        jMenuItem4.addActionListener(this);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        jMenu.add(jMenuItem4);
        jMenuItem4.setEnabled(false);
        jMenuItem5 = new JMenuItem("Remove Data");
        jMenuItem5.setActionCommand("Remove Data");
        jMenuItem5.addActionListener(this);
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        jMenu.add(jMenuItem5);
        jMenuItem5.setEnabled(false);
        jMenu = new JMenu("Layout");
        jMenuBar.add(jMenu);
        jMenu.addChangeListener(this);
        jMenuItem = new JMenu("Paper Size");
        jMenu.add(jMenuItem);
        jMenuItem2 = new JMenuItem("A4");
        jMenuItem2.setActionCommand("A4");
        jMenuItem2.addActionListener(this);
        ((JMenu)jMenuItem).add(jMenuItem2);
        jMenuItem3 = new JMenuItem("B5");
        jMenuItem3.setActionCommand("B5");
        jMenuItem3.addActionListener(this);
        ((JMenu)jMenuItem).add(jMenuItem3);
        jMenuItem4 = new JMenuItem("Letter");
        jMenuItem4.setActionCommand("Letter");
        jMenuItem4.addActionListener(this);
        ((JMenu)jMenuItem).add(jMenuItem4);
        jMenuItem5 = new JMenuItem("Bounding Box");
        jMenuItem5.setActionCommand("Bounding Box");
        jMenuItem5.addActionListener(this);
        jMenu.add(jMenuItem5);
        jMenuItem6 = new JMenuItem("Align Figures");
        jMenuItem6.setActionCommand("Align Figures");
        jMenuItem6.addActionListener(this);
        jMenu.add(jMenuItem6);
        jMenu = new JMenu("Help");
        jMenuBar.add(jMenu);
        jMenu.addChangeListener(this);
        jMenuItem = new JMenuItem("About");
        jMenuItem.setActionCommand("About");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        return jMenuBar;
    }

    private JMenu getMenu(String string) {
        JMenuBar jMenuBar = this.getJMenuBar();
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            if (!jMenu.getActionCommand().equals(string)) continue;
            return jMenu;
        }
        return null;
    }

    private JMenuItem getMenuItem(String string, String string2) {
        JMenu jMenu = this.getMenu(string);
        if (jMenu == null) {
            return null;
        }
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || !jMenuItem.getText().equals(string2)) continue;
            return jMenuItem;
        }
        return null;
    }

    public boolean export() throws IOException {
        SGFigure sGFigure;
        int n;
        float f = this.mMagnification;
        double d = this.getHScrollValue();
        double d2 = this.getVScrollValue();
        this.mDrawAnchorFlag = false;
        this.clearFocusedFigures();
        ArrayList arrayList = this.getVisibleFigureListFromLayer();
        Rectangle2D rectangle2D = this.mClientRect;
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGTuple2fArray[n] = new SGTuple2f(sGFigure.mGraphAreaX, sGFigure.mGraphAreaY);
        }
        this.zoom(1.0f);
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGFigure.setGraphAreaLocation(sGFigure.getGraphAreaX() - (float)rectangle2D.getX(), sGFigure.getGraphAreaY() - (float)rectangle2D.getY());
        }
        Insets insets = this.mPreviewDialog.getInsets();
        int n2 = (int)this.mPaperSize.x;
        int n3 = (int)this.mPaperSize.y;
        this.mPreviewDialog.setSize(n2 + insets.left + insets.right, n3 + insets.top + insets.bottom);
        this.mPreviewDialog.setLocation(this.getLocation());
        JLayeredPane jLayeredPane = this.mPreviewDialog.mLayeredPane;
        jLayeredPane.setLocation(0, 0);
        jLayeredPane.setSize(n2, n3);
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, n2, n3);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure2 = (SGFigure)arrayList.get(i);
            sGFigure2.setLocation(0, 0);
            sGFigure2.setSize(new SGTuple2f(n2, n3));
            sGFigure2.setGraphAreaRectToFigureElement();
            sGFigure2.setViewBounds(float_);
            jLayeredPane.add(sGFigure2);
            jLayeredPane.setLayer(sGFigure2, 30);
        }
        this.mPreviewDialog.show();
        mExportDialog.showExportDialog(jLayeredPane, "Export view as ...", jLayeredPane, "export");
        this.terminatePreviewDialog();
        this.zoom(f);
        this.setScrollValue(this.mHScrollBar, d);
        this.setScrollValue(this.mVScrollBar, d2);
        SGTuple2f sGTuple2f = this.getViewportSize();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure3 = (SGFigure)arrayList.get(i);
            sGFigure3.mGraphAreaX = sGTuple2fArray[i].x;
            sGFigure3.mGraphAreaY = sGTuple2fArray[i].y;
            sGFigure3.setSize(sGTuple2f);
            sGFigure3.setGraphAreaRectToFigureElement();
            sGFigure3.setViewBounds();
        }
        this.mDrawAnchorFlag = true;
        return true;
    }

    private boolean terminatePreviewDialog() {
        Component[] componentArray = this.mPreviewDialog.mLayeredPane.getComponentsInLayer(30);
        for (int i = 0; i < componentArray.length; ++i) {
            SGFigure sGFigure = (SGFigure)componentArray[i];
            sGFigure.setLocation(20, 20);
            this.mLayeredPane.add(sGFigure);
        }
        this.mPreviewDialog.hide();
        return true;
    }

    private File openFileChooser(String string) {
        JFileChooser jFileChooser = new JFileChooser(string);
        File file = new File(this.mPropertyFileName);
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showSaveDialog(this);
        File file2 = null;
        switch (n) {
            case 0: {
                file2 = jFileChooser.getSelectedFile();
                this.mPropertyFileDirName = file2.getPath();
                break;
            }
            case 1: {
                break;
            }
            case -1: {
                throw new Error();
            }
        }
        return file2;
    }

    public boolean createPropertyFile() {
        boolean bl = true;
        try {
            File file = this.openFileChooser(this.mPropertyFileDirName);
            if (file == null) {
                return true;
            }
            String string = file.getPath();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bl = this.writeProperty(bufferedWriter);
            if (!bl) {
                return false;
            }
            ArrayList arrayList = this.getVisibleFigureListFromMap();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                bl = sGFigure.createPropertyFileAll(bufferedWriter);
                if (bl) continue;
                return false;
            }
            bufferedWriter.close();
            outputStreamWriter.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean createPropertyFileForFocusedFigures() {
        boolean bl = true;
        try {
            File file = this.openFileChooser(this.mPropertyFileDirName);
            if (file == null) {
                return true;
            }
            String string = file.getPath();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bl = this.writePropertyForFocusedFigures(bufferedWriter);
            if (!bl) {
                return false;
            }
            for (int i = 0; i < this.mFocusedFigureList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)this.mFocusedFigureList.get(i);
                bl = sGFigure.createPropertyFileAllOnFocused(bufferedWriter);
                if (bl) continue;
                return false;
            }
            bufferedWriter.close();
            outputStreamWriter.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean writePropertyForFocusedFigures(Writer writer) throws IOException {
        writer.write("[Window]\n");
        Rectangle2D rectangle2D = this.getBoundingBoxOfFigures(this.mFocusedFigureList);
        SGUtilityText.writePropertyLine(writer, KEY_PAPER_WIDTH, new Double(rectangle2D.getWidth() * 0.035277776420116425));
        SGUtilityText.writePropertyLine(writer, KEY_PAPER_HEIGHT, new Double(rectangle2D.getHeight() * 0.035277776420116425));
        SGUtilityText.writePropertyLine(writer, KEY_GRID_INTERVAL, new Float(this.mGridInterval * 0.035277776f));
        SGUtilityText.writePropertyLine(writer, KEY_GRID_LINE_WIDTH, new Float(this.mGridLineWidth * 0.035277776f));
        SGUtilityText.writeColorPropertyLine(writer, KEY_BACKGROUND_COLOR, this.getBackgroundColor());
        SGUtilityText.writeColorPropertyLine(writer, KEY_GRID_COLOR, this.mGridLineColor);
        writer.write("\n\n");
        return true;
    }

    private boolean writePropertyOfWindowPaneForFocusedFigures(Writer writer) throws IOException {
        return true;
    }

    public boolean writeProperty(Writer writer) throws IOException {
        writer.write("[Window]\n");
        SGUtilityText.writePropertyLine(writer, KEY_PAPER_WIDTH, new Float(this.mPaperSize.x * 0.035277776f));
        SGUtilityText.writePropertyLine(writer, KEY_PAPER_HEIGHT, new Float(this.mPaperSize.y * 0.035277776f));
        SGUtilityText.writePropertyLine(writer, KEY_GRID_INTERVAL, new Float(this.mGridInterval * 0.035277776f));
        SGUtilityText.writePropertyLine(writer, KEY_GRID_LINE_WIDTH, new Float(this.mGridLineWidth));
        SGUtilityText.writeColorPropertyLine(writer, KEY_BACKGROUND_COLOR, this.getBackgroundColor());
        SGUtilityText.writeColorPropertyLine(writer, KEY_GRID_COLOR, this.mGridLineColor);
        writer.write("\n\n");
        return true;
    }

    protected boolean setPropertyOfSelectedObjects() {
        SGFigure sGFigure;
        int n;
        ArrayList arrayList = new ArrayList();
        ArrayList<SGPropertyDialog> arrayList2 = new ArrayList<SGPropertyDialog>();
        ArrayList arrayList3 = this.getVisibleFigureListFromMap();
        for (n = 0; n < arrayList3.size(); ++n) {
            sGFigure = (SGFigure)arrayList3.get(n);
            ArrayList arrayList4 = sGFigure.mGraphElement.getPropertySettingListerListOfDataElements();
            if (arrayList4.size() == 0) continue;
            arrayList.addAll(arrayList4);
            arrayList2.add(sGFigure.mGraphElement.getPropertyDialogForDataElements());
        }
        if (arrayList.size() == 0) {
            return true;
        }
        for (n = 0; n < arrayList2.size() - 1; ++n) {
            sGFigure = arrayList2.get(n);
            for (int i = n; i < arrayList2.size(); ++i) {
                Object e = arrayList2.get(i);
                if (sGFigure.getClass().equals(e.getClass())) continue;
                return false;
            }
        }
        SGPropertyDialog sGPropertyDialog = (SGPropertyDialog)arrayList2.get(0);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIPropertySettingListener sGIPropertySettingListener = (SGIPropertySettingListener)arrayList.get(i);
            sGPropertyDialog.addPropertySettingListener(sGIPropertySettingListener);
            sGIPropertySettingListener.createTemporaryPropertyObject();
        }
        sGPropertyDialog.setDialogProperty();
        sGPropertyDialog.setLocation(this.getLocation());
        sGPropertyDialog.show();
        return true;
    }

    public static class WindowProperties
    extends SGProperties {
        TreeMap figureMap = new TreeMap();
        ArrayList visibleFigureList = new ArrayList();
        public static final String[] keys = new String[]{"Paper Width", "Paper Height", "Background Color", "Grid Line Color", "Grid Interval", "Grid Line Width"};

        public String toString() {
            String string = new String("[");
            string = string + this.visibleFigureList.toString();
            string = string + new String("]");
            return string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof WindowProperties)) {
                return false;
            }
            WindowProperties windowProperties = (WindowProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(windowProperties.getProperty(keys[i]))) continue;
                return false;
            }
            if (!windowProperties.figureMap.equals(this.figureMap)) {
                return false;
            }
            return windowProperties.visibleFigureList.equals(this.visibleFigureList);
        }

        public Float getPaperWidth() {
            String string = this.getProperty(SGDrawingWindow.KEY_PAPER_WIDTH);
            return SGUtilityText.getFloat(string);
        }

        public Float getPaperHeight() {
            String string = this.getProperty(SGDrawingWindow.KEY_PAPER_HEIGHT);
            return SGUtilityText.getFloat(string);
        }

        public Color getBackgroundColor() {
            String string = this.getProperty(SGDrawingWindow.KEY_BACKGROUND_COLOR);
            return SGUtilityText.getColorFromString(string);
        }

        public Color getGridColor() {
            String string = this.getProperty(SGDrawingWindow.KEY_GRID_COLOR);
            return SGUtilityText.getColorFromString(string);
        }

        public Float getGridInterval() {
            String string = this.getProperty(SGDrawingWindow.KEY_GRID_INTERVAL);
            return SGUtilityText.getFloat(string);
        }

        public Float getGridLineWidth() {
            String string = this.getProperty(SGDrawingWindow.KEY_GRID_LINE_WIDTH);
            return SGUtilityText.getFloat(string);
        }

        public boolean setPaperWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGDrawingWindow.KEY_PAPER_WIDTH, new Float(f).toString());
            return true;
        }

        public boolean setPaperHeight(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGDrawingWindow.KEY_PAPER_HEIGHT, new Float(f).toString());
            return true;
        }

        public boolean setBackGroundColor(Color color) {
            if (color == null) {
                return false;
            }
            String string = SGUtilityText.getColorString(color);
            if (string == null) {
                return false;
            }
            this.setProperty(SGDrawingWindow.KEY_BACKGROUND_COLOR, string);
            return true;
        }

        public boolean setGridColor(Color color) {
            if (color == null) {
                return false;
            }
            String string = SGUtilityText.getColorString(color);
            if (string == null) {
                return false;
            }
            this.setProperty(SGDrawingWindow.KEY_GRID_COLOR, string);
            return true;
        }

        public boolean setGridInterval(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGDrawingWindow.KEY_GRID_INTERVAL, new Float(f).toString());
            return true;
        }

        public boolean setGridLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGDrawingWindow.KEY_GRID_LINE_WIDTH, new Float(f).toString());
            return true;
        }
    }

    class PreviewDialog
    extends JDialog {
        private JLayeredPane mLayeredPane = new JLayeredPane();

        protected PreviewDialog() {
            this.initComponents();
        }

        protected PreviewDialog(Frame frame, String string) {
            super(frame, string);
            this.initComponents();
        }

        private void initComponents() {
            this.getContentPane().add(this.mLayeredPane);
            this.setVisible(true);
            this.setResizable(false);
        }
    }

    class RulerPanel
    extends JPanel {
        protected RulerPanel() {
        }

        protected boolean setBounds() {
            Rectangle rectangle = SGDrawingWindow.this.mLayeredPane.getBounds();
            this.setBounds(0, 0, rectangle.width, rectangle.height);
            return true;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.drawRuler(graphics2D);
        }

        private boolean drawRuler(Graphics2D graphics2D) {
            int[] nArray = new int[6];
            int[] nArray2 = new int[6];
            nArray[0] = 0;
            nArray2[0] = 0;
            nArray[1] = this.getWidth();
            nArray2[1] = 0;
            nArray[2] = this.getWidth();
            nArray2[2] = 20;
            nArray[3] = 20;
            nArray2[3] = 20;
            nArray[4] = 20;
            nArray2[4] = this.getHeight();
            nArray[5] = 0;
            nArray2[5] = this.getHeight();
            Polygon polygon = new Polygon(nArray, nArray2, 6);
            graphics2D.setPaint(SGDrawingWindow.this.mRulerLineColor);
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
            graphics2D.setPaint(SGDrawingWindow.this.mRulerBackGroundColor);
            graphics2D.fill(polygon);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.draw(polygon);
            this.drawNumbersAndLines(graphics2D);
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, 20.0f, 20.0f);
            graphics2D.setPaint(SGDrawingWindow.this.mRulerBackGroundColor);
            graphics2D.fill(float_);
            graphics2D.setPaint(SGDrawingWindow.this.mRulerLineColor);
            graphics2D.draw(float_);
            return true;
        }

        private boolean drawNumbersAndLines(Graphics2D graphics2D) {
            int n;
            Integer n2;
            float f;
            int n3;
            int n4;
            graphics2D.setPaint(SGDrawingWindow.this.mRulerLineColor);
            Rectangle2D rectangle2D = SGDrawingWindow.this.getViewportBounds();
            Rectangle2D rectangle2D2 = SGDrawingWindow.this.getClientRect();
            float f2 = SGDrawingWindow.this.getHScrollValue();
            float f3 = SGDrawingWindow.this.getVScrollValue();
            float f4 = 20.0f + (float)rectangle2D2.getX();
            float f5 = 20.0f + (float)rectangle2D2.getY();
            Line2D.Float float_ = new Line2D.Float();
            graphics2D.setStroke(new BasicStroke(SGDrawingWindow.this.mRulerAxisLineWidth, 0, 0));
            float f6 = this.getWidth();
            ((Line2D)float_).setLine(20.0, 20.0, f6, 20.0);
            graphics2D.draw(float_);
            float f7 = this.getHeight();
            ((Line2D)float_).setLine(20.0, 20.0, 20.0, f7);
            graphics2D.draw(float_);
            graphics2D.setStroke(new BasicStroke(SGDrawingWindow.this.mRulerScaleLineWidth, 0, 0));
            graphics2D.setFont(SGDrawingWindow.this.mRulerFont);
            float f8 = SGDrawingWindow.this.mMagnification / 0.035277776f;
            ArrayList<Float> arrayList = new ArrayList<Float>();
            f7 = 0.0f;
            int n5 = n4 = (int)((rectangle2D.getX() - rectangle2D2.getX()) * 0.035277776420116425 / (double)SGDrawingWindow.this.mMagnification);
            while (!((double)(f7 = f8 * (float)n5) > rectangle2D2.getWidth()) && !((double)f7 > rectangle2D.getX() + rectangle2D.getWidth() - rectangle2D2.getX())) {
                arrayList.add(new Float(f7));
                ++n5;
            }
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                f7 = ((Float)arrayList.get(n3)).floatValue();
                f = f4 + f7;
                ((Line2D)float_).setLine(f, 4.0, f, 20.0);
                graphics2D.draw(float_);
                n2 = new Integer(n4 + n3);
                int n6 = (int)(f + 0.3f * SGDrawingWindow.this.mRulerFontSize);
                n = (int)SGDrawingWindow.this.mRulerFontSize + 1;
                graphics2D.drawString(n2.toString(), n6, n);
                for (int i = 0; i < 4; ++i) {
                    float f9 = f + SGDrawingWindow.this.mMagnification * 0.2f * (float)(i + 1) * 28.346458f;
                    ((Line2D)float_).setLine(f9, 15.0, f9, 20.0);
                    graphics2D.draw(float_);
                }
            }
            arrayList = new ArrayList();
            f7 = 0.0f;
            n5 = n4 = (int)((rectangle2D.getY() - rectangle2D2.getY()) * 0.035277776420116425 / (double)SGDrawingWindow.this.mMagnification);
            while (!((double)(f7 = f8 * (float)n5) > rectangle2D2.getHeight()) && !((double)f7 > rectangle2D.getY() + rectangle2D.getHeight() - rectangle2D2.getY())) {
                arrayList.add(new Float(f7));
                ++n5;
            }
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                int n7;
                f7 = ((Float)arrayList.get(n3)).floatValue();
                f = f5 + f7;
                ((Line2D)float_).setLine(4.0, f, 20.0, f);
                graphics2D.draw(float_);
                n2 = new Integer(n3 + n4);
                n = (int)(f + SGDrawingWindow.this.mRulerFontSize + 1.0f);
                char[] cArray = n2.toString().toCharArray();
                for (n7 = 0; n7 < cArray.length; ++n7) {
                    Character c = new Character(cArray[n7]);
                    graphics2D.drawString(c.toString(), 4, n);
                    n += (int)SGDrawingWindow.this.mRulerFontSize;
                }
                for (n7 = 0; n7 < 4; ++n7) {
                    float f10 = f + SGDrawingWindow.this.mMagnification * 0.2f * (float)(n7 + 1) * 28.346458f;
                    ((Line2D)float_).setLine(15.0, f10, 20.0, f10);
                    graphics2D.draw(float_);
                }
            }
            return true;
        }
    }

    class GridPanel
    extends JPanel {
        protected GridPanel() {
        }

        protected boolean setBounds() {
            Rectangle rectangle = SGDrawingWindow.this.mLayeredPane.getBounds();
            this.setBounds(20, 20, rectangle.width - 20, rectangle.height - 20);
            return true;
        }

        public void paintComponent(Graphics graphics) {
            float f;
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle2D rectangle2D = SGDrawingWindow.this.getPaperRect();
            Rectangle2D rectangle2D2 = SGDrawingWindow.this.getViewportBounds();
            graphics2D.setPaint(SGDrawingWindow.this.getBackgroundColor());
            graphics2D.fill(rectangle2D);
            graphics2D.setStroke(new BasicStroke(SGDrawingWindow.this.mGridLineWidth, 0, 0));
            graphics2D.setPaint(SGDrawingWindow.this.mGridLineColor);
            float f2 = SGDrawingWindow.this.mMagnification * SGDrawingWindow.this.mGridInterval;
            Line2D.Float float_ = new Line2D.Float();
            int n = (int)((rectangle2D2.getX() - rectangle2D.getX()) / (double)f2) + 1;
            while (!((double)(f = (float)n * f2 + (float)rectangle2D.getX()) > rectangle2D2.getX() + rectangle2D2.getWidth()) && !((double)f > rectangle2D.getX() + rectangle2D.getWidth())) {
                ((Line2D)float_).setLine(f, rectangle2D.getY(), f, rectangle2D.getY() + rectangle2D.getHeight());
                graphics2D.draw(float_);
                ++n;
            }
            n = (int)((rectangle2D2.getY() - rectangle2D.getY()) / (double)f2) + 1;
            while (!((double)(f = (float)n * f2 + (float)rectangle2D.getY()) > rectangle2D2.getY() + rectangle2D2.getHeight()) && !((double)f > rectangle2D.getY() + rectangle2D.getHeight())) {
                ((Line2D)float_).setLine(rectangle2D.getX(), f, rectangle2D.getX() + rectangle2D.getWidth(), f);
                graphics2D.draw(float_);
                ++n;
            }
            graphics2D.setPaint(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(rectangle2D);
        }
    }

    class AnchorPanel
    extends JPanel {
        protected AnchorPanel() {
        }

        protected boolean setBounds() {
            Rectangle rectangle = SGDrawingWindow.this.mLayeredPane.getBounds();
            this.setBounds(20, 20, rectangle.width - 20, rectangle.height - 20);
            return true;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (!SGDrawingWindow.this.mDrawAnchorFlag) {
                return;
            }
            for (int i = 0; i < SGDrawingWindow.this.mFocusedFigureList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)SGDrawingWindow.this.mFocusedFigureList.get(i);
                Rectangle2D rectangle2D = sGFigure.getRectangleOnDragging();
                if (SGFigure.mDrawRectangleOnDraggingFlag) {
                    this.drawRectangle(graphics2D, rectangle2D);
                }
                Rectangle2D rectangle2D2 = sGFigure.getGraphAreaRect();
                int n = (int)rectangle2D2.getX();
                int n2 = (int)rectangle2D2.getY();
                int n3 = (int)rectangle2D2.getWidth();
                int n4 = (int)rectangle2D2.getHeight();
                this.drawAnchor(graphics2D, n, n2);
                this.drawAnchor(graphics2D, n + n3, n2);
                this.drawAnchor(graphics2D, n, n2 + n4);
                this.drawAnchor(graphics2D, n + n3, n2 + n4);
                this.drawAnchor(graphics2D, n + n3 / 2, n2);
                this.drawAnchor(graphics2D, n, n2 + n4 / 2);
                this.drawAnchor(graphics2D, n + n3 / 2, n2 + n4);
                this.drawAnchor(graphics2D, n + n3, n2 + n4 / 2);
            }
        }

        private void drawAnchor(Graphics2D graphics2D, int n, int n2) {
            Ellipse2D.Float float_ = new Ellipse2D.Float((float)n - 0.5f * SGDrawingWindow.this.mAnchorSize, (float)n2 - 0.5f * SGDrawingWindow.this.mAnchorSize, SGDrawingWindow.this.mAnchorSize, SGDrawingWindow.this.mAnchorSize);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.draw(float_);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fill(float_);
        }

        private void drawRectangle(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            graphics2D.setPaint(Color.BLACK);
            float[] fArray = new float[]{4.0f, 2.0f};
            graphics2D.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, fArray, 0.0f));
            double d = rectangle2D.getX();
            double d2 = rectangle2D.getY();
            double d3 = rectangle2D.getWidth();
            double d4 = rectangle2D.getHeight();
            Line2D.Double double_ = new Line2D.Double(d, d2, d + d3, d2);
            Line2D.Double double_2 = new Line2D.Double(d, d2 + d4, d + d3, d2 + d4);
            Line2D.Double double_3 = new Line2D.Double(d, d2, d, d2 + d4);
            Line2D.Double double_4 = new Line2D.Double(d + d3, d2, d + d3, d2 + d4);
            graphics2D.draw(double_);
            graphics2D.draw(double_2);
            graphics2D.draw(double_3);
            graphics2D.draw(double_4);
        }
    }
}

