/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public abstract class SGDrawingElement {
    protected float mMagnification = 1.0f;
    protected ArrayList mColorList = new ArrayList();
    protected boolean mVisibleFlag = true;
    public static final String KEY_COLOR_LIST = "Color List";
    public static final String KEY_VISIBLE = "Visible";

    public abstract boolean contains(int var1, int var2);

    public boolean zoom(float f) {
        this.setMagnification(f);
        return true;
    }

    public boolean isVisible() {
        return this.mVisibleFlag;
    }

    public void setVisible(boolean bl) {
        this.mVisibleFlag = bl;
    }

    public boolean setMagnification(float f) {
        this.mMagnification = f;
        return true;
    }

    public boolean setColorList(ArrayList arrayList) {
        this.mColorList = new ArrayList(arrayList);
        return true;
    }

    public boolean setColor(Color color) {
        this.mColorList = new ArrayList();
        this.mColorList.add(color);
        return true;
    }

    public boolean addColor(Color color) {
        if (this.mColorList == null) {
            this.mColorList = new ArrayList();
        }
        this.mColorList.add(color);
        return true;
    }

    public ArrayList getColorList() {
        return this.mColorList;
    }

    public Color getColor(int n) {
        if (this.mColorList == null) {
            return null;
        }
        if (n >= this.mColorList.size()) {
            return null;
        }
        return (Color)this.mColorList.get(n);
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        this.setMagnification(sGDrawingElement.getMagnification());
        this.setColorList(sGDrawingElement.getColorList());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof DrawingElementProperties)) {
            return false;
        }
        DrawingElementProperties drawingElementProperties = (DrawingElementProperties)sGProperties;
        Boolean bl = drawingElementProperties.isVisible();
        if (bl == null) {
            return false;
        }
        this.setVisible(bl);
        ArrayList arrayList = drawingElementProperties.getColorList();
        if (arrayList == null) {
            return false;
        }
        this.setColorList(arrayList);
        return true;
    }

    public SGProperties getProperties() {
        DrawingElementProperties drawingElementProperties = new DrawingElementProperties();
        if (!this.getProperties(drawingElementProperties)) {
            return null;
        }
        return drawingElementProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof DrawingElementProperties)) {
            return false;
        }
        DrawingElementProperties drawingElementProperties = (DrawingElementProperties)sGProperties;
        drawingElementProperties.setVisible(this.isVisible());
        drawingElementProperties.setColorList(this.getColorList());
        return true;
    }

    public static class DrawingElementProperties
    extends SGProperties {
        public static final String[] keys = new String[]{"Visible", "Color List"};

        public boolean equals(Object object) {
            if (!(object instanceof DrawingElementProperties)) {
                return false;
            }
            DrawingElementProperties drawingElementProperties = (DrawingElementProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(drawingElementProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Boolean isVisible() {
            String string = this.getProperty(SGDrawingElement.KEY_VISIBLE);
            return SGUtilityText.getBoolean(string);
        }

        public ArrayList getColorList() {
            String string = this.getProperty(SGDrawingElement.KEY_COLOR_LIST);
            return SGUtilityText.getColorList(string);
        }

        public boolean setVisible(boolean bl) {
            this.setProperty(SGDrawingElement.KEY_VISIBLE, new Boolean(bl).toString());
            return true;
        }

        public boolean setColor(Color color) {
            if (color == null) {
                new IllegalArgumentException("cl==null");
            }
            ArrayList<Color> arrayList = new ArrayList<Color>();
            arrayList.add(color);
            String string = SGUtilityText.getColorListString(arrayList);
            if (string == null) {
                new IllegalArgumentException("str==null");
            }
            this.setProperty(SGDrawingElement.KEY_COLOR_LIST, string);
            return true;
        }

        public boolean setColorList(ArrayList arrayList) {
            String string;
            if (arrayList == null) {
                new IllegalArgumentException("list==null");
            }
            if (arrayList.size() == 0) {
                new IllegalArgumentException("list.size()==0");
            }
            if ((string = SGUtilityText.getColorListString(arrayList)) == null) {
                new IllegalArgumentException("str==null");
            }
            this.setProperty(SGDrawingElement.KEY_COLOR_LIST, string);
            return true;
        }
    }
}

