/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;

public abstract class SGFigureElement
extends JPanel
implements SGIFigureElement {
    protected float mGraphAreaX;
    protected float mGraphAreaY;
    protected float mGraphAreaWidth;
    protected float mGraphAreaHeight;
    protected float mMagnification = 1.0f;
    protected Rectangle2D mViewBounds = null;
    protected ArrayList mDataList = new ArrayList();
    protected ArrayList mActionListenerList = new ArrayList();
    protected Cursor mCursor = null;
    public static final String FROM_FIGURE_ELEMENT = "from the SGIFigureElement object";
    protected float mRulerUnit = 0.035277776f;
    protected Frame mDialogOwner = null;
    protected boolean mComponentBoundsVisibleFlag = false;
    protected Rectangle2D mTempGraphAreaRect = new Rectangle2D.Float();
    protected int mFigureElementStateCounter = 0;
    protected ArrayList mPropertyHistoryList = new ArrayList();
    protected int mCurrentStateCounter = 0;
    protected ArrayList mUndoableObjectHistoryList = new ArrayList();

    public boolean addData(SGData sGData) {
        this.mDataList.add(sGData);
        return true;
    }

    public boolean removeData(SGData sGData) {
        for (int i = this.mDataList.size() - 1; i >= 0; --i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            this.mDataList.remove(i);
            return true;
        }
        return true;
    }

    public boolean removeAllElements() {
        this.mDataList.clear();
        return true;
    }

    public ArrayList getDataList() {
        return this.mDataList;
    }

    public boolean getMarginAroundGraphAreaRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (sGTuple2f == null || sGTuple2f2 == null) {
            return false;
        }
        sGTuple2f.clear();
        sGTuple2f2.clear();
        return true;
    }

    public void setComponentBoundsVisibleFlag(boolean bl) {
        this.mComponentBoundsVisibleFlag = bl;
    }

    public boolean getComponentBoundsVisibleFlag() {
        return this.mComponentBoundsVisibleFlag;
    }

    public boolean setGraphAreaRect(float f, float f2, float f3, float f4) {
        this.setGraphAreaLocation(f, f2);
        this.setGraphAreaSize(f3, f4);
        return true;
    }

    public boolean setGraphAreaLocation(float f, float f2) {
        this.mGraphAreaX = f;
        this.mGraphAreaY = f2;
        return true;
    }

    public boolean setGraphAreaSize(float f, float f2) {
        if ((double)f < 0.0 || (double)f2 < 0.0) {
            throw new IllegalArgumentException("width<0.0 || height<0.0");
        }
        this.mGraphAreaWidth = f;
        this.mGraphAreaHeight = f2;
        return true;
    }

    public Rectangle2D getGraphAreaRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.mGraphAreaX, this.mGraphAreaY, this.mGraphAreaWidth, this.mGraphAreaHeight);
        return float_;
    }

    public boolean isInsideGraphArea(SGTuple2f sGTuple2f) {
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        float f3 = this.mGraphAreaX;
        float f4 = this.mGraphAreaY;
        float f5 = this.mGraphAreaWidth;
        float f6 = this.mGraphAreaHeight;
        if (f < f3 || f > f3 + f5) {
            return false;
        }
        return !(f2 < f4) && !(f2 > f4 + f6);
    }

    public boolean isInsideGraphArea(Point2D point2D) {
        return this.isInsideGraphArea((int)point2D.getX(), (int)point2D.getY());
    }

    public boolean isInsideGraphArea(int n, int n2) {
        SGTuple2f sGTuple2f = new SGTuple2f(n, n2);
        return this.isInsideGraphArea(sGTuple2f);
    }

    public SGTuple2f getISize() {
        SGTuple2f sGTuple2f = new SGTuple2f();
        sGTuple2f.x = this.getWidth();
        sGTuple2f.y = this.getHeight();
        return sGTuple2f;
    }

    public SGTuple2f getILocation() {
        SGTuple2f sGTuple2f = new SGTuple2f();
        sGTuple2f.x = this.getX();
        sGTuple2f.y = this.getY();
        return sGTuple2f;
    }

    public boolean setISize(SGTuple2f sGTuple2f) {
        this.setSize((int)sGTuple2f.x, (int)sGTuple2f.y);
        return true;
    }

    public boolean setILocation(SGTuple2f sGTuple2f) {
        this.setLocation((int)sGTuple2f.x, (int)sGTuple2f.y);
        return true;
    }

    public boolean setDialogOwner(Frame frame) {
        this.mDialogOwner = frame;
        return true;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean setMagnification(float f) {
        this.mMagnification = f;
        return true;
    }

    public Cursor getFigureElementCursor() {
        return this.mCursor;
    }

    public boolean zoom(float f) {
        this.setMagnification(f);
        return true;
    }

    public abstract boolean synchronize(SGIFigureElement var1);

    public abstract boolean synchronizeArgument(SGIFigureElement var1);

    public boolean setViewBounds(Rectangle2D rectangle2D) {
        this.mViewBounds = rectangle2D;
        return true;
    }

    public boolean createDataObject(BufferedReader bufferedReader, SGData sGData) throws IOException {
        if (bufferedReader == null || sGData == null) {
            return false;
        }
        this.mDataList.add(sGData);
        return true;
    }

    protected ImageIcon createIcon(String string) {
        if (string == null) {
            return null;
        }
        Class<?> clazz = this.getClass();
        URL uRL = clazz.getResource(string);
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(string);
        return imageIcon;
    }

    public abstract boolean onMouseClicked(MouseEvent var1);

    public abstract boolean onMousePressed(MouseEvent var1);

    public abstract boolean onMouseDragged(MouseEvent var1);

    public abstract boolean onMouseReleased(MouseEvent var1);

    public void addActionListener(ActionListener actionListener) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            return;
        }
        this.mActionListenerList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        for (int i = this.mActionListenerList.size() - 1; i >= 0; --i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            this.mActionListenerList.remove(actionListener);
        }
    }

    public void notifyChange() {
        this.notifyToListener(0);
    }

    public boolean updateParentHistory() {
        this.notifyToListener(1);
        return true;
    }

    public boolean addToLatestHistory() {
        this.notifyToListener(2);
        return true;
    }

    public boolean setPropertyOfSelectedData() {
        this.notifyToListener(3);
        return true;
    }

    public void notifyToListener(int n) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener = (ActionListener)this.mActionListenerList.get(i);
            actionListener.actionPerformed(this.getActionEvent(n));
        }
    }

    private ActionEvent getActionEvent(int n) {
        return new ActionEvent(this, n, FROM_FIGURE_ELEMENT);
    }

    public float getGraphAreaX() {
        return this.mGraphAreaX;
    }

    public float getGraphAreaY() {
        return this.mGraphAreaY;
    }

    public float getGraphAreaWidth() {
        return this.mGraphAreaWidth;
    }

    public float getGraphAreaHeight() {
        return this.mGraphAreaHeight;
    }

    protected float calcLocation(double d, SGAxis sGAxis, boolean bl) {
        SGTuple2d sGTuple2d = sGAxis.getRange();
        double d2 = sGTuple2d.x;
        double d3 = sGTuple2d.y;
        int n = sGAxis.getScaleType();
        float f = 0.0f;
        if (n == 0) {
            f = (float)((d - d2) / (d3 - d2));
        } else if (n == 1) {
            double d4 = Math.log(d2);
            double d5 = Math.log(d3);
            double d6 = Math.log(d);
            f = (float)((d6 - d4) / (d5 - d4));
        }
        float f2 = 0.0f;
        f2 = bl ? this.mGraphAreaX + f * this.mGraphAreaWidth : this.mGraphAreaY + (1.0f - f) * this.mGraphAreaHeight;
        return f2;
    }

    protected double calcValue(int n, SGAxis sGAxis, boolean bl) {
        SGTuple2d sGTuple2d = sGAxis.getRange();
        double d = sGTuple2d.x;
        double d2 = sGTuple2d.y;
        int n2 = sGAxis.getScaleType();
        double d3 = 0.0;
        d3 = bl ? ((double)n - (double)this.mGraphAreaX) / (double)this.mGraphAreaWidth : 1.0 - ((double)n - (double)this.mGraphAreaY) / (double)this.mGraphAreaHeight;
        double d4 = 0.0;
        if (n2 == 0) {
            d4 = d + d3 * (d2 - d);
        } else if (n2 == 1) {
            double d5 = Math.log(d);
            double d6 = Math.log(d2);
            d4 = Math.exp(d5 + d3 * (d6 - d5));
        }
        return d4;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paintGraphics2D(graphics2D);
    }

    public void paintGraphics2D(Graphics2D graphics2D) {
        if (this.mComponentBoundsVisibleFlag) {
            this.drawComponentBounds(graphics2D);
        }
    }

    protected boolean drawComponentBounds(Graphics2D graphics2D) {
        graphics2D.setPaint(Color.BLACK);
        graphics2D.setStroke(new BasicStroke(1.0f));
        Rectangle rectangle = this.getBounds();
        rectangle.setBounds((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth() - 1, (int)rectangle.getHeight() - 1);
        graphics2D.draw(rectangle);
        return true;
    }

    public boolean clearSelectedElements() {
        return true;
    }

    public boolean isResizable(double d, double d2) {
        return true;
    }

    public abstract SGProperties getProperties();

    public abstract boolean setProperties(SGProperties var1);

    public boolean addPropertiesHistory(SGProperties sGProperties) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.mFigureElementStateCounter; ++i) {
            arrayList.add(this.mPropertyHistoryList.get(i));
        }
        arrayList.add(sGProperties);
        this.mPropertyHistoryList = arrayList;
        return true;
    }

    public boolean initPropertiesHistory() {
        this.addPropertiesHistory(this.getProperties());
        return true;
    }

    public boolean updateHistory() {
        this.updateParentHistory();
        this.updateThisObjectHistory();
        return true;
    }

    public boolean updateThisObjectHistory() {
        this.updateObjectHistory(this);
        ++this.mFigureElementStateCounter;
        this.addPropertiesHistory(this.getProperties());
        return true;
    }

    protected boolean callParentUpdateHistory() {
        return this.updateHistory();
    }

    public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
        ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
        arrayList.add(sGIUndoable);
        boolean bl = this.updateObjectHistory(arrayList);
        return bl;
    }

    public boolean updateObjectHistory(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < this.mCurrentStateCounter; ++i) {
            Object e = this.mUndoableObjectHistoryList.get(i);
            arrayList2.add(e);
        }
        arrayList2.add(new ArrayList(arrayList));
        this.mUndoableObjectHistoryList = arrayList2;
        ++this.mCurrentStateCounter;
        return true;
    }

    public boolean onUndo() {
        if (this.mCurrentStateCounter == 0) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter - 1);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this) ? this.undo() : sGIUndoable.onUndo();
            if (bl) continue;
            return false;
        }
        --this.mCurrentStateCounter;
        return true;
    }

    public boolean onRedo() {
        if (this.mCurrentStateCounter == this.mUndoableObjectHistoryList.size()) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this) ? this.redo() : sGIUndoable.onRedo();
            if (bl) continue;
            return false;
        }
        ++this.mCurrentStateCounter;
        return true;
    }

    public boolean undo() {
        --this.mFigureElementStateCounter;
        SGProperties sGProperties = (SGProperties)this.mPropertyHistoryList.get(this.mFigureElementStateCounter);
        return this.setProperties(sGProperties);
    }

    public boolean redo() {
        ++this.mFigureElementStateCounter;
        SGProperties sGProperties = (SGProperties)this.mPropertyHistoryList.get(this.mFigureElementStateCounter);
        return this.setProperties(sGProperties);
    }
}

