/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData;
import jp.riken.brain.ni.samuraigraph.data.SGVXYData;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupString;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupTickLabel;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGGraphElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIPropertySettingListenerSXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGPropertyDialogSXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGTimingElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;

public class SGSXYGraphElement
extends SGGraphElement {
    public static final String PF_ERROR_BAR_EMPTY = "<Error Bars Empty>";
    public static final String PF_TICK_LABELS_EMPTY = "<Tick Labels Empty>";
    public static final String MSG_NOT_HIDE_ALL_ELEMENTS = "\u5168\u90e8\u306f\u6d88\u305b\u307e\u305b\u3093\u3002";

    public SGSXYGraphElement() {
        this.createDataDialog();
    }

    protected boolean createDataDialog() {
        SGPropertyDialogSXYData sGPropertyDialogSXYData = new SGPropertyDialogSXYData(this.mDialogOwner, true);
        mPropertyDialogForData = sGPropertyDialogSXYData;
        return true;
    }

    public boolean addData(SGData sGData) {
        if (!(sGData instanceof SGSXYData) && !(sGData instanceof SGSXYMultipleData)) {
            return false;
        }
        this.mDataList.add(sGData);
        SGAxis sGAxis = this.mAxisElement.getAxisInPlane(1);
        SGAxis sGAxis2 = this.mAxisElement.getAxisInPlane(-1);
        SGAxis sGAxis3 = this.mAxisElement.getAxisInPlane(2);
        SGAxis sGAxis4 = this.mAxisElement.getAxisInPlane(-2);
        SGAxis sGAxis5 = null;
        SGAxis sGAxis6 = null;
        if ("Left-Bottom".equals("Left-Bottom")) {
            sGAxis5 = sGAxis;
            sGAxis6 = sGAxis3;
        } else if ("Left-Bottom".equals("Left-Top")) {
            sGAxis5 = sGAxis2;
            sGAxis6 = sGAxis3;
        } else if ("Left-Bottom".equals("Right-Bottom")) {
            sGAxis5 = sGAxis;
            sGAxis6 = sGAxis4;
        } else if ("Left-Bottom".equals("Right-Top")) {
            sGAxis5 = sGAxis2;
            sGAxis6 = sGAxis4;
        } else {
            return false;
        }
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = null;
        if (sGData instanceof SGSXYData) {
            elementGroupSetInGraph = this.createGroupSet((SGSXYData)sGData, sGAxis5, sGAxis6);
        } else if (sGData instanceof SGSXYMultipleData) {
            elementGroupSetInGraph = this.createMultipleGroupSet((SGSXYMultipleData)sGData, sGAxis5, sGAxis6);
        } else {
            return false;
        }
        this.mGroupSetList.add(elementGroupSetInGraph);
        return this.updateHistory();
    }

    private SGGraphElement.ElementGroupSetForMultipleData createMultipleGroupSet(SGSXYMultipleData sGSXYMultipleData, SGAxis sGAxis, SGAxis sGAxis2) {
        ElementGroupSetForMultipleDataInSXYGraph elementGroupSetForMultipleDataInSXYGraph = new ElementGroupSetForMultipleDataInSXYGraph();
        String string = "data" + (this.mGroupSetList.size() + 1);
        elementGroupSetForMultipleDataInSXYGraph.setName(string);
        elementGroupSetForMultipleDataInSXYGraph.setXAxis(sGAxis);
        elementGroupSetForMultipleDataInSXYGraph.setYAxis(sGAxis2);
        double[] dArray = sGSXYMultipleData.getXValueArray();
        double[][] dArray2 = sGSXYMultipleData.getYValueArray();
        for (int i = 0; i < dArray2.length; ++i) {
            boolean bl;
            SGSXYData sGSXYData = new SGSXYData(dArray, dArray2[i]);
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = new ElementGroupSetInSXYGraph();
            elementGroupSetInSXYGraph.setName(string);
            elementGroupSetInSXYGraph.setXAxis(sGAxis);
            elementGroupSetInSXYGraph.setYAxis(sGAxis2);
            elementGroupSetInSXYGraph.createPointList(sGSXYData);
            elementGroupSetInSXYGraph.addDrawingElementGroup(0);
            elementGroupSetInSXYGraph.addDrawingElementGroup(1);
            elementGroupSetInSXYGraph.addDrawingElementGroup(2);
            ElementGroupSymbol elementGroupSymbol = this.getGroupSymbol(elementGroupSetInSXYGraph);
            elementGroupSymbol.setVisible(false);
            ElementGroupBar elementGroupBar = this.getGroupBar(elementGroupSetInSXYGraph);
            elementGroupBar.setVisible(false);
            if (sGSXYData.getErrorArray() != null && !(bl = this.createErrorBar(elementGroupSetInSXYGraph, sGSXYData))) {
                return null;
            }
            if (sGSXYData.getStringArray() != null && !(bl = this.createTickLabels(elementGroupSetInSXYGraph, sGSXYData))) {
                return null;
            }
            elementGroupSetInSXYGraph.setMagnification(this.mMagnification);
            elementGroupSetInSXYGraph.initPropertiesHistory();
            elementGroupSetForMultipleDataInSXYGraph.mElementGroupSetList.add(elementGroupSetInSXYGraph);
        }
        elementGroupSetForMultipleDataInSXYGraph.initPropertiesHistory();
        return elementGroupSetForMultipleDataInSXYGraph;
    }

    private ElementGroupSetInSXYGraph createGroupSet(SGSXYData sGSXYData, SGAxis sGAxis, SGAxis sGAxis2) {
        boolean bl;
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = new ElementGroupSetInSXYGraph();
        String string = "data" + (this.mGroupSetList.size() + 1);
        elementGroupSetInSXYGraph.setName(string);
        elementGroupSetInSXYGraph.setXAxis(sGAxis);
        elementGroupSetInSXYGraph.setYAxis(sGAxis2);
        elementGroupSetInSXYGraph.createPointList(sGSXYData);
        elementGroupSetInSXYGraph.addDrawingElementGroup(0);
        elementGroupSetInSXYGraph.addDrawingElementGroup(1);
        elementGroupSetInSXYGraph.addDrawingElementGroup(2);
        if (sGSXYData.getErrorArray() != null && !(bl = this.createErrorBar(elementGroupSetInSXYGraph, sGSXYData))) {
            return null;
        }
        if (sGSXYData.getStringArray() != null && !(bl = this.createTickLabels(elementGroupSetInSXYGraph, sGSXYData))) {
            return null;
        }
        elementGroupSetInSXYGraph.setMagnification(this.mMagnification);
        elementGroupSetInSXYGraph.initPropertiesHistory();
        return elementGroupSetInSXYGraph;
    }

    private boolean createTickLabels(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph, SGSXYData sGSXYData) {
        ElementGroupTickLabelStringElement elementGroupTickLabelStringElement = new ElementGroupTickLabelStringElement();
        elementGroupSetInSXYGraph.mTickLabels = elementGroupTickLabelStringElement;
        elementGroupTickLabelStringElement.mGroupSet = elementGroupSetInSXYGraph;
        elementGroupTickLabelStringElement.createDrawingElements(sGSXYData);
        return true;
    }

    private boolean createErrorBar(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph, SGSXYData sGSXYData) {
        ElementGroupErrorBar elementGroupErrorBar = new ElementGroupErrorBar();
        elementGroupSetInSXYGraph.mErrorBarGroup = elementGroupErrorBar;
        elementGroupErrorBar.mGroupSet = elementGroupSetInSXYGraph;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        elementGroupSetInSXYGraph.mErrorBarGroup.calcErrorBarRatio(sGSXYData, elementGroupSetInSXYGraph.mXAxis, elementGroupSetInSXYGraph.mYAxis, arrayList, arrayList2);
        elementGroupErrorBar.createDrawingElement(arrayList, arrayList2);
        return true;
    }

    protected boolean synchronizeToLegendElement(SGILegendElement sGILegendElement) {
        super.synchronizeToLegendElement(sGILegendElement);
        boolean bl = super.synchronizeToLegendElement(sGILegendElement);
        if (!bl) {
            return bl;
        }
        for (int i = 0; i < this.mDataList.size(); ++i) {
            Object object;
            SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mGroupSetList.get(i);
            ArrayList arrayList = elementGroupSetInGraph.mDrawingElementGroupList;
            arrayList.clear();
            SGData sGData = (SGData)this.mDataList.get(i);
            String string = sGILegendElement.getDataName(sGData);
            elementGroupSetInGraph.setName(string);
            elementGroupSetInGraph.setVisible(sGILegendElement.isDataVisible(sGData));
            ((IElementGroupSetInSXYGraph)((Object)elementGroupSetInGraph)).createPointList(sGData);
            ArrayList arrayList2 = sGILegendElement.getDrawingElementList(sGData);
            for (int j = 0; j < arrayList2.size(); ++j) {
                object = (SGDrawingElement)arrayList2.get(j);
                elementGroupSetInGraph.addDrawingElementGroup((SGDrawingElement)object);
            }
            ArrayList arrayList3 = sGILegendElement.getVisibleFlagList(sGData);
            object = elementGroupSetInGraph.mDrawingElementGroupList;
            for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                SGElementGroup sGElementGroup = (SGElementGroup)((ArrayList)object).get(j);
                Boolean bl2 = (Boolean)arrayList3.get(j);
                sGElementGroup.setVisible(bl2);
            }
        }
        this.createAllDrawingElements();
        return bl;
    }

    public void paintGraphics2D(Graphics2D graphics2D) {
        Object object;
        int n;
        super.paintGraphics2D(graphics2D);
        for (n = 0; n < this.mGroupSetList.size(); ++n) {
            object = (IElementGroupSetInSXYGraph)this.mGroupSetList.get(n);
            object.paintDataString(graphics2D);
        }
        this.clipGraphArea(graphics2D);
        for (n = 0; n < this.mTimingElementGroupSetList.size(); ++n) {
            object = (SGGraphElement.TimingElementGroupSetInGraph)this.mTimingElementGroupSetList.get(n);
            if (!((SGElementGroupSet)object).isVisible()) continue;
            ((SGGraphElement.TimingElementGroupSetInGraph)object).paintGraphics2D(graphics2D);
        }
        for (n = 0; n < this.mGroupSetList.size(); ++n) {
            object = (SGElementGroupSet)this.mGroupSetList.get(n);
            if (!((SGElementGroupSet)object).isVisible()) continue;
            ((SGElementGroupSet)object).paintGraphics2D(graphics2D);
        }
    }

    private ElementGroupLine getGroupLine(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph) {
        ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupLine)) continue;
            return (ElementGroupLine)sGElementGroup;
        }
        return null;
    }

    private ElementGroupBar getGroupBar(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph) {
        ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupBar)) continue;
            return (ElementGroupBar)sGElementGroup;
        }
        return null;
    }

    private ElementGroupSymbol getGroupSymbol(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph) {
        ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupSymbol)) continue;
            return (ElementGroupSymbol)sGElementGroup;
        }
        return null;
    }

    protected boolean onZoomed(int n, int n2, int n3, int n4, float f) {
        super.onZoomed(n, n2, n3, n4, f);
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mGroupSetList.get(i);
            elementGroupSetInGraph.zoom(n3, n4, f);
        }
        return true;
    }

    public boolean getMarginAroundGraphAreaRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (!super.getMarginAroundGraphAreaRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGData sGData;
            SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mGroupSetList.get(i);
            Rectangle2D rectangle2D = ((IElementGroupSetInSXYGraph)((Object)elementGroupSetInGraph)).getTickLabelsBoundingBox(sGData = this.getData(elementGroupSetInGraph));
            if (rectangle2D == null) {
                return false;
            }
            if (rectangle2D.getWidth() < Double.MIN_VALUE || rectangle2D.getHeight() < Double.MIN_VALUE) continue;
            arrayList.add(rectangle2D);
        }
        if (arrayList.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        float f = this.mGraphAreaY - (float)rectangle2D.getY();
        float f2 = -(this.mGraphAreaY + this.mGraphAreaHeight) + (float)(rectangle2D.getY() + rectangle2D.getHeight());
        float f3 = this.mGraphAreaX - (float)rectangle2D.getX();
        float f4 = -(this.mGraphAreaX + this.mGraphAreaWidth) + (float)(rectangle2D.getX() + rectangle2D.getWidth());
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    public boolean createAllDrawingElements() {
        SGElementGroupSet sGElementGroupSet;
        int n;
        for (n = 0; n < this.mGroupSetList.size(); ++n) {
            sGElementGroupSet = (SGGraphElement.ElementGroupSetInGraph)this.mGroupSetList.get(n);
            if (!sGElementGroupSet.isVisible()) continue;
            SGData sGData = (SGData)this.mDataList.get(n);
            if (!((IElementGroupSetInSXYGraph)((Object)sGElementGroupSet)).createPointList(sGData)) {
                return false;
            }
            if (((SGGraphElement.ElementGroupSetInGraph)sGElementGroupSet).createDrawingElements()) continue;
            return false;
        }
        for (n = 0; n < this.mTimingElementGroupSetList.size(); ++n) {
            sGElementGroupSet = (SGGraphElement.TimingElementGroupSetInGraph)this.mTimingElementGroupSetList.get(n);
            this.createTimingElements((SGTimingElementGroupSet)sGElementGroupSet);
        }
        return true;
    }

    protected SGGraphElement.ElementGroupSetInGraph getGroupSetNewInstance(SGData sGData) {
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = null;
        if (sGData instanceof SGSXYData) {
            elementGroupSetInGraph = new ElementGroupSetInSXYGraph();
        } else if (sGData instanceof SGSXYMultipleData) {
            elementGroupSetInGraph = new ElementGroupSetForMultipleDataInSXYGraph();
        }
        return elementGroupSetInGraph;
    }

    public boolean createDataObject(BufferedReader bufferedReader, SGData sGData) throws IOException {
        if (!(sGData instanceof SGSXYData) && !(sGData instanceof SGSXYMultipleData)) {
            return false;
        }
        super.createDataObject(bufferedReader, sGData);
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = this.getGroupSetNewInstance(sGData);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        this.mGroupSetList.add(elementGroupSetInGraph);
        int n = this.setProperty(bufferedReader, elementGroupSetInGraph);
        return n != 1;
    }

    private int setProperty(BufferedReader bufferedReader, SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph) throws IOException {
        SGData sGData = this.getData(elementGroupSetInGraph);
        int n = 1;
        if (sGData instanceof SGSXYData) {
            SGSXYData sGSXYData = (SGSXYData)sGData;
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)elementGroupSetInGraph;
            n = this.setPropertyOfElementGroupSetInSXYGraph(bufferedReader, elementGroupSetInSXYGraph, sGSXYData);
        } else if (sGData instanceof SGSXYMultipleData) {
            SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)sGData;
            ElementGroupSetForMultipleDataInSXYGraph elementGroupSetForMultipleDataInSXYGraph = (ElementGroupSetForMultipleDataInSXYGraph)elementGroupSetInGraph;
            n = this.setPropertyOfElementGroupSetForMultipleDataInSXYGraph(bufferedReader, elementGroupSetForMultipleDataInSXYGraph, sGSXYMultipleData);
        } else if (sGData instanceof SGSXYSamplingData) {
            SGSXYSamplingData sGSXYSamplingData = (SGSXYSamplingData)sGData;
        }
        return n;
    }

    private int setPropertyOfElementGroupSetForMultipleDataInSXYGraph(BufferedReader bufferedReader, ElementGroupSetForMultipleDataInSXYGraph elementGroupSetForMultipleDataInSXYGraph, SGSXYMultipleData sGSXYMultipleData) throws IOException {
        elementGroupSetForMultipleDataInSXYGraph.mDrawingElementGroupList.clear();
        SGSXYData[] sGSXYDataArray = sGSXYMultipleData.getSXYDataArray();
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = new ElementGroupSetInSXYGraph();
        int n = this.setPropertyOfElementGroupSetInSXYGraph(bufferedReader, elementGroupSetInSXYGraph, sGSXYDataArray[0]);
        if (n == 1) {
            return n;
        }
        SGProperties sGProperties = elementGroupSetInSXYGraph.getProperties();
        SGProperties sGProperties2 = elementGroupSetInSXYGraph.getWholeProperties();
        ElementGroupSetInSXYGraph[] elementGroupSetInSXYGraphArray = new ElementGroupSetInSXYGraph[sGSXYDataArray.length];
        ArrayList<ElementGroupSetInSXYGraph> arrayList = new ArrayList<ElementGroupSetInSXYGraph>();
        for (int i = 0; i < elementGroupSetInSXYGraphArray.length; ++i) {
            elementGroupSetInSXYGraphArray[i] = new ElementGroupSetInSXYGraph();
            if (!elementGroupSetInSXYGraphArray[i].setProperties(sGProperties)) {
                return 1;
            }
            elementGroupSetInSXYGraphArray[i].createPointList(sGSXYDataArray[i]);
            elementGroupSetInSXYGraphArray[i].addDrawingElementGroup(0);
            elementGroupSetInSXYGraphArray[i].addDrawingElementGroup(1);
            elementGroupSetInSXYGraphArray[i].addDrawingElementGroup(2);
            if (!elementGroupSetInSXYGraphArray[i].setWholeProperties(sGProperties2)) {
                return 1;
            }
            elementGroupSetInSXYGraphArray[i].initPropertiesHistory();
            arrayList.add(elementGroupSetInSXYGraphArray[i]);
        }
        elementGroupSetForMultipleDataInSXYGraph.mElementGroupSetList = new ArrayList(arrayList);
        elementGroupSetForMultipleDataInSXYGraph.mName = new String(elementGroupSetInSXYGraph.getName());
        elementGroupSetForMultipleDataInSXYGraph.initPropertiesHistory();
        return 0;
    }

    private int setPropertyOfElementGroupSetInSXYGraph(BufferedReader bufferedReader, ElementGroupSetInSXYGraph elementGroupSetInSXYGraph, SGSXYData sGSXYData) throws IOException {
        SGElementGroup sGElementGroup;
        elementGroupSetInSXYGraph.mDrawingElementGroupList.clear();
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return 1;
        }
        String string2 = SGUtilityText.getStringPropertyFromLine(string, "Name");
        if (string2 == null) {
            return 1;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return 1;
        }
        String string3 = SGUtilityText.getPropertyFromLine(string, "Location of the X-Axis");
        if (string3 == null) {
            return 1;
        }
        int n = this.mAxisElement.getConfigurationInCubeFromStringInPlane(string3);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return 1;
        }
        String string4 = SGUtilityText.getPropertyFromLine(string, "Location of the Y-Axis");
        if (string4 == null) {
            return 1;
        }
        int n2 = this.mAxisElement.getConfigurationInCubeFromStringInPlane(string4);
        elementGroupSetInSXYGraph.setName(string2);
        elementGroupSetInSXYGraph.mXAxis = this.mAxisElement.getAxisInCube(n);
        elementGroupSetInSXYGraph.mYAxis = this.mAxisElement.getAxisInCube(n2);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return 1;
        }
        if (string.equals("<Error Bar>")) {
            sGElementGroup = new ElementGroupErrorBar();
            sGElementGroup.readProperty(bufferedReader);
            if (sGSXYData.getErrorArray() != null) {
                sGElementGroup.setMagnification(this.mMagnification);
                elementGroupSetInSXYGraph.mErrorBarGroup = (ElementGroupErrorBar)sGElementGroup;
                ((ElementGroupErrorBar)sGElementGroup).mGroupSet = elementGroupSetInSXYGraph;
            }
        } else if (string.equals(PF_ERROR_BAR_EMPTY) && sGSXYData.getErrorArray() != null) {
            this.createErrorBar(elementGroupSetInSXYGraph, sGSXYData);
        }
        if ((string = SGUtilityText.readLine(bufferedReader)) == null) {
            return 1;
        }
        if (string.equals("<Tick Labels>")) {
            sGElementGroup = new ElementGroupTickLabelStringElement();
            sGElementGroup.readProperty(bufferedReader);
            if (sGSXYData.getStringArray() != null) {
                sGElementGroup.setMagnification(this.mMagnification);
                elementGroupSetInSXYGraph.mTickLabels = (ElementGroupTickLabelStringElement)sGElementGroup;
                ((ElementGroupTickLabelStringElement)sGElementGroup).mGroupSet = elementGroupSetInSXYGraph;
            }
        } else if (string.equals(PF_TICK_LABELS_EMPTY) && sGSXYData.getStringArray() != null) {
            this.createTickLabels(elementGroupSetInSXYGraph, sGSXYData);
        }
        bufferedReader.mark(256);
        while (true) {
            sGElementGroup = null;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) break;
            if (string.equals("<Line>")) {
                sGElementGroup = new ElementGroupLine();
            } else if (string.equals("<Symbol>")) {
                sGElementGroup = new ElementGroupSymbol();
            } else if (string.equals("<Bar>")) {
                sGElementGroup = new ElementGroupBar();
            } else {
                bufferedReader.reset();
                break;
            }
            sGElementGroup.mGroupSet = elementGroupSetInSXYGraph;
            elementGroupSetInSXYGraph.mDrawingElementGroupList.add(sGElementGroup);
            sGElementGroup.setMagnification(this.mMagnification);
            sGElementGroup.readProperty(bufferedReader);
            bufferedReader.mark(256);
        }
        return 0;
    }

    class TickLabelStringElement
    extends SGDrawingElementString2D {
        protected TickLabelStringElement() {
        }

        protected TickLabelStringElement(String string) {
            super(string);
        }

        protected TickLabelStringElement(SGDrawingElementString sGDrawingElementString) {
            super(sGDrawingElementString);
        }

        protected TickLabelStringElement(String string, int n, float f, float f2, float f3) {
            super(string, n, f, f2, f3);
        }

        protected TickLabelStringElement(String string, int n, float f) {
            super(string, n, f);
        }
    }

    class ElementGroupTickLabelStringElement
    extends SGElementGroupTickLabel {
        protected ElementGroupTickLabelStringElement() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            this.setFontFamilyName("Serif");
            this.setFontSize(16.0f);
            this.setFontStyle(SGUtilityText.getFontStyle("Plain"));
            Float f = SGElementGroupTickLabel.getTickLabelAngleFromName("Horizontal");
            if (f == null) {
                return false;
            }
            this.setAngle(f.floatValue());
            this.setColor(SGDefaultValues.TICK_LABEL_COLOR);
            return true;
        }

        private boolean drawStringBounds(SGDrawingElementString2D sGDrawingElementString2D, Graphics2D graphics2D) {
            Color color = Color.BLACK;
            graphics2D.setPaint(color);
            graphics2D.setStroke(new BasicStroke(1.0f));
            Rectangle2D rectangle2D = sGDrawingElementString2D.getElementBounds();
            graphics2D.drawRect((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            return true;
        }

        protected SGElementGroup.ElementGroupProperties getPropertiesFromDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            SGElementGroupString.StringProperties stringProperties = new SGElementGroupString.StringProperties();
            stringProperties.setVisible(sGPropertyDialogSXYData.getTickLabelVisible());
            stringProperties.setColorList(sGPropertyDialogSXYData.getTickLabelColorList());
            stringProperties.setFontFamilyName(sGPropertyDialogSXYData.getTickLabelFontFamilyName());
            Number number = sGPropertyDialogSXYData.getTickLabelFontSize();
            if (number == null) {
                SGUtility.showIllegalInputErrorMessageDialog(SGSXYGraphElement.this.mDialogOwner);
                return null;
            }
            stringProperties.setFontSize(number.floatValue());
            Integer n = sGPropertyDialogSXYData.getTickLabelFontStyle();
            if (n == null) {
                SGUtility.showIllegalInputErrorMessageDialog(SGSXYGraphElement.this.mDialogOwner);
                return null;
            }
            stringProperties.setFontStyle(n);
            Number number2 = sGPropertyDialogSXYData.getTickLabelAngle();
            if (number2 == null) {
                SGUtility.showIllegalInputErrorMessageDialog(SGSXYGraphElement.this.mDialogOwner);
                return null;
            }
            stringProperties.setAngle(number2.floatValue());
            return stringProperties;
        }

        protected boolean setDialogProperty() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            sGPropertyDialogSXYData.setTickLabelVisible(this.isVisible());
            sGPropertyDialogSXYData.setTickLabelFontFamilyName(this.mFontFamilyName);
            sGPropertyDialogSXYData.setTickLabelFontSize(new Float(this.mFontSize));
            sGPropertyDialogSXYData.setTickLabelFontStyle(new Integer(this.mFontStyle));
            sGPropertyDialogSXYData.setTickLabelAngle(new Float(this.mAngle));
            sGPropertyDialogSXYData.setTickLabelColorList(this.mColorList);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean createDrawingElements(SGSXYData sGSXYData) {
            this.mDrawingElementList.clear();
            double d = SGSXYGraphElement.this.mGraphAreaX;
            double d2 = SGSXYGraphElement.this.mGraphAreaY;
            double d3 = SGSXYGraphElement.this.mGraphAreaWidth;
            double d4 = SGSXYGraphElement.this.mGraphAreaHeight;
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet;
            SGAxis sGAxis = elementGroupSetInSXYGraph.mXAxis;
            double d5 = sGAxis.getRange().x;
            double d6 = sGAxis.getRange().y;
            int n = SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(sGAxis);
            SGTuple2d[] sGTuple2dArray = sGSXYData.getValueArray();
            String[] stringArray = sGSXYData.getStringArray();
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i = 0; i < sGTuple2dArray.length; ++i) {
                double d7 = sGTuple2dArray[i].x;
                if (!(d5 < d7) || !(d7 < d6)) continue;
                arrayList.add(new Double(d7));
                arrayList2.add(stringArray[i]);
            }
            double[] dArray = new double[arrayList.size()];
            String[] stringArray2 = new String[arrayList2.size()];
            for (int i = 0; i < dArray.length; ++i) {
                double d8 = (Double)arrayList.get(i);
                dArray[i] = SGSXYGraphElement.this.calcLocation(d8, sGAxis, true);
                stringArray2[i] = (String)arrayList2.get(i);
            }
            String string = this.getFontFamilyName();
            int n2 = this.getFontStyle();
            float f = this.getFontSize();
            ArrayList arrayList3 = this.getColorList();
            float f2 = this.getAngle();
            float f3 = this.mMagnification * SGSXYGraphElement.this.mAxisElement.getSpaceAxisLineAndNumber();
            if (stringArray == null) return true;
            for (int i = 0; i < dArray.length; ++i) {
                TickLabelStringElement tickLabelStringElement = new TickLabelStringElement(stringArray2[i], n2, f);
                tickLabelStringElement.setMagnification(this.mMagnification);
                tickLabelStringElement.setFontFamilyName(string);
                tickLabelStringElement.setFontStyle(n2);
                tickLabelStringElement.setColorList(arrayList3);
                tickLabelStringElement.setAngle(f2);
                Rectangle2D rectangle2D = tickLabelStringElement.getElementBounds();
                float f4 = (float)rectangle2D.getWidth();
                float f5 = (float)rectangle2D.getHeight();
                Rectangle2D rectangle2D2 = tickLabelStringElement.getStringRect();
                float f6 = (float)rectangle2D2.getWidth();
                float f7 = (float)rectangle2D2.getHeight();
                float f8 = 0.0f;
                float f9 = 0.0f;
                float f10 = 0.0f;
                if (f2 == 0.0f) {
                    f8 = (float)dArray[i] - 0.5f * f4;
                } else {
                    if (f2 != 0.5235988f) throw new Error();
                    if (n == 1) {
                        f8 = (float)dArray[i] - f6 * (float)Math.cos(f2);
                    } else {
                        if (n != -1) throw new Error();
                        f8 = (float)dArray[i] - f7 * (float)Math.sin(f2);
                    }
                }
                if (n == 1) {
                    f10 = (float)(d2 + d4 + (double)f3);
                } else {
                    if (n != -1) throw new Error();
                    f10 = (float)(d2 - (double)f3 - (double)f5);
                }
                tickLabelStringElement.setLocation(f8, f10);
                float f11 = (float)tickLabelStringElement.getElementBounds().getY();
                f9 = f10 + (f10 - f11);
                tickLabelStringElement.setLocation(f8, f9);
                this.mDrawingElementList.add(tickLabelStringElement);
            }
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D) {
            super.paintElement(graphics2D);
            return true;
        }
    }

    class ElementGroupErrorBar
    extends SGElementGroupErrorBar {
        protected ElementGroupErrorBar() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f);
            this.setHeadSize(7.0866146f);
            Integer n = SGDrawingElementSymbol.getSymbolTypeFromName("Transverse Line");
            if (n == null) {
                return false;
            }
            this.setStartHeadType(n);
            this.setEndHeadType(n);
            this.setHeadEdgeLineWidth(1.0f);
            this.setColor(SGDefaultValues.ERROR_BAR_COLOR);
            Integer n2 = ElementGroupErrorBar.getErrorBarStyleFromName("Bothsides");
            if (n2 == null) {
                return false;
            }
            this.mErrorBarStyle = n2;
            return true;
        }

        private boolean calcErrorBarRatio(SGSXYData sGSXYData, SGAxis sGAxis, SGAxis sGAxis2, ArrayList arrayList, ArrayList arrayList2) {
            SGTuple2d[] sGTuple2dArray = sGSXYData.getErrorArray();
            if (sGTuple2dArray == null) {
                return false;
            }
            SGTuple2d[] sGTuple2dArray2 = sGSXYData.getValueArray();
            int n = sGTuple2dArray2.length;
            SGTuple2d[] sGTuple2dArray3 = new SGTuple2d[n];
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                if (this.mErrorBarStyle == 0) {
                    sGTuple2dArray3[i] = new SGTuple2d(sGTuple2dArray2[i].x, sGTuple2dArray2[i].y + sGTuple2dArray[i].x);
                    dArray[i] = sGTuple2dArray[i].y - sGTuple2dArray[i].x;
                } else if (this.mErrorBarStyle == 1) {
                    sGTuple2dArray3[i] = new SGTuple2d(sGTuple2dArray2[i].x, sGTuple2dArray2[i].y);
                    dArray[i] = sGTuple2dArray[i].y;
                } else if (this.mErrorBarStyle == 2) {
                    sGTuple2dArray3[i] = new SGTuple2d(sGTuple2dArray2[i].x, sGTuple2dArray2[i].y + sGTuple2dArray[i].x);
                    dArray[i] = Math.abs(sGTuple2dArray[i].x);
                }
                dArray2[i] = 1.5707963267948966;
            }
            SGVXYData sGVXYData = new SGVXYData(sGTuple2dArray3, dArray, dArray2);
            SGSXYGraphElement.this.calcLocationOfVXYData(sGVXYData.getStartArray(), sGVXYData.getEndArray(), sGAxis, sGAxis2, arrayList, arrayList2);
            return true;
        }

        protected boolean setDialogProperty() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            sGPropertyDialogSXYData.setErrorBarVisible(this.isVisible());
            String string = null;
            if (this.mErrorBarStyle == 0 || this.mErrorBarStyle == 2) {
                string = ElementGroupErrorBar.getSymbolTypeName(this.mStartHeadType);
            } else if (this.mErrorBarStyle == 1) {
                string = ElementGroupErrorBar.getSymbolTypeName(this.mEndHeadType);
            }
            sGPropertyDialogSXYData.setErrorBarType(string);
            sGPropertyDialogSXYData.setErrorBarSymbolSize(new Float(this.mHeadSize * 0.035277776f));
            sGPropertyDialogSXYData.setErrorBarLineWidth(new Float(this.mLineWidth));
            sGPropertyDialogSXYData.setErrorBarColorList(this.mColorList);
            sGPropertyDialogSXYData.setErrorBarStyle(new Integer(this.mErrorBarStyle));
            return true;
        }

        protected SGElementGroup.ElementGroupProperties getPropertiesFromDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            SGElementGroupErrorBar.ErrorBarProperties errorBarProperties = sGPropertyDialogSXYData.getErrorBarProperties();
            return errorBarProperties;
        }
    }

    class ElementGroupSymbol
    extends SGElementGroupSymbol {
        protected ElementGroupSymbol() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            Integer n = SGDrawingElementSymbol.getSymbolTypeFromName("Circle");
            if (n == null) {
                return false;
            }
            this.setType(n);
            this.setSize(8.503938f);
            this.setColor(SGDefaultValues.SYMBOL_BODY_COLOR);
            this.setLineWidth(1.0f);
            this.setLineColor(SGDefaultValues.SYMBOL_LINE_COLOR);
            return true;
        }

        private boolean drawRectangle(Shape shape, Graphics2D graphics2D) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            graphics2D.setPaint(Color.black);
            graphics2D.setStroke(new BasicStroke(1.0f));
            int n = (int)rectangle2D.getX();
            int n2 = (int)rectangle2D.getY();
            int n3 = (int)rectangle2D.getWidth();
            int n4 = (int)rectangle2D.getHeight();
            graphics2D.drawRect(n, n2, n3, n4);
            return true;
        }

        public boolean createDrawingElement(ArrayList arrayList) {
            float f = SGSXYGraphElement.this.mGraphAreaX;
            float f2 = SGSXYGraphElement.this.mGraphAreaY;
            float f3 = SGSXYGraphElement.this.mGraphAreaWidth;
            float f4 = SGSXYGraphElement.this.mGraphAreaHeight;
            float f5 = this.mMagnification;
            int n = arrayList.size();
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2fArray[i] = (SGTuple2f)arrayList.get(i);
            }
            boolean[] blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = SGSXYGraphElement.this.isInsideGraphArea(sGTuple2fArray[i]);
            }
            ArrayList<SGTuple2f> arrayList2 = new ArrayList<SGTuple2f>();
            for (int i = 0; i < n; ++i) {
                if (!blArray[i]) continue;
                arrayList2.add(sGTuple2fArray[i]);
            }
            super.createDrawingElement(arrayList2);
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D) {
            block4: {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph;
                super.paintElement(graphics2D);
                if (!this.isSelected() || (elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet).isBarVisible()) break block4;
                int n = this.mDrawingElementList.size();
                if (n <= 8) {
                    for (int i = 0; i < n; ++i) {
                        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementList.get(i);
                        this.emphasisSymbol(sGDrawingElementSymbol2D, graphics2D);
                    }
                } else {
                    int n2 = n / 8;
                    int n3 = 0;
                    do {
                        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementList.get(n3);
                        this.emphasisSymbol(sGDrawingElementSymbol2D, graphics2D);
                    } while ((n3 += n2) < n);
                }
            }
            return true;
        }

        private boolean emphasisSymbol(SGDrawingElementSymbol2D sGDrawingElementSymbol2D, Graphics2D graphics2D) {
            Rectangle2D rectangle2D = sGDrawingElementSymbol2D.getElementBounds();
            Point2D.Float float_ = new Point2D.Float((float)rectangle2D.getX(), (float)rectangle2D.getY());
            Point2D.Float float_2 = new Point2D.Float((float)(rectangle2D.getX() + rectangle2D.getWidth()), (float)rectangle2D.getY());
            Point2D.Float float_3 = new Point2D.Float((float)rectangle2D.getX(), (float)(rectangle2D.getY() + rectangle2D.getHeight()));
            Point2D.Float float_4 = new Point2D.Float((float)(rectangle2D.getX() + rectangle2D.getWidth()), (float)(rectangle2D.getY() + rectangle2D.getHeight()));
            SGSXYGraphElement.this.drawEmphasisSymol(graphics2D, float_);
            SGSXYGraphElement.this.drawEmphasisSymol(graphics2D, float_2);
            SGSXYGraphElement.this.drawEmphasisSymol(graphics2D, float_3);
            SGSXYGraphElement.this.drawEmphasisSymol(graphics2D, float_4);
            return true;
        }

        protected boolean setDialogProperty() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            sGPropertyDialogSXYData.setSymbolVisible(this.isVisible());
            sGPropertyDialogSXYData.setSymbolType(new Integer(this.mSymbolType));
            sGPropertyDialogSXYData.setSymbolSize(new Float(this.mSymbolSize * this.mRulerUnit));
            sGPropertyDialogSXYData.setSymbolLineWidth(new Float(this.mLineWidth));
            sGPropertyDialogSXYData.setSymbolColorList(this.mColorList);
            sGPropertyDialogSXYData.setSymbolLineColor(this.mLineColor);
            return true;
        }

        protected SGElementGroup.ElementGroupProperties getPropertiesFromDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            SGElementGroupSymbol.SymbolProperties symbolProperties = sGPropertyDialogSXYData.getSymbolProperties();
            return symbolProperties;
        }
    }

    class ElementGroupBar
    extends SGElementGroupBar {
        protected ElementGroupBar() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            this.setBaseLineValue(0.0);
            this.setRectangleWidth(14.173229f);
            this.setColor(SGDefaultValues.BAR_COLOR);
            this.setEdgeLineWidth(0.5f);
            this.setEdgeLineColor(SGDefaultValues.BAR_LINE_COLOR);
            return true;
        }

        private float getReferenceRatio(double d) {
            SGAxis sGAxis = ((ElementGroupSetInSXYGraph)this.mGroupSet).getYAxis();
            float f = SGSXYGraphElement.this.calcLocation(d, sGAxis, false);
            return f;
        }

        public boolean createDrawingElement(ArrayList arrayList) {
            this.mDrawingElementList.clear();
            float f = SGSXYGraphElement.this.mGraphAreaX;
            float f2 = SGSXYGraphElement.this.mGraphAreaY;
            float f3 = SGSXYGraphElement.this.mGraphAreaWidth;
            float f4 = SGSXYGraphElement.this.mGraphAreaHeight;
            int n = arrayList.size();
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2fArray[i] = (SGTuple2f)arrayList.get(i);
            }
            boolean[] blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = f < sGTuple2fArray[i].x & sGTuple2fArray[i].x < f + f3;
            }
            ArrayList<SGTuple2f> arrayList2 = new ArrayList<SGTuple2f>();
            for (int i = 0; i < n; ++i) {
                if (!blArray[i]) continue;
                arrayList2.add(sGTuple2fArray[i]);
            }
            float f5 = this.getReferenceRatio(this.mBaselineValue);
            for (int i = 0; i < arrayList2.size(); ++i) {
                SGTuple2f sGTuple2f = (SGTuple2f)arrayList2.get(i);
                float f6 = sGTuple2f.x - 0.5f * this.mMagnification * this.mRectangleWidth;
                float f7 = this.mMagnification * this.mRectangleWidth;
                float f8 = 0.0f;
                float f9 = 0.0f;
                if (f5 <= f2) {
                    if (sGTuple2f.y <= f2) continue;
                    if (sGTuple2f.y >= f2 + f4) {
                        f8 = f2;
                        f9 = f4;
                    } else if (sGTuple2f.y > f2 && sGTuple2f.y < f2 + f4) {
                        f8 = f2;
                        f9 = sGTuple2f.y - f2;
                    }
                } else if (f5 >= f2 + f4) {
                    if (sGTuple2f.y <= f2) {
                        f8 = 0.0f;
                        f9 = f2 + f4;
                    } else {
                        if (sGTuple2f.y >= f2 + f4) continue;
                        if (sGTuple2f.y > f2 && sGTuple2f.y < f2 + f4) {
                            f8 = sGTuple2f.y;
                            f9 = f2 + f4 - sGTuple2f.y;
                        }
                    }
                } else if (f5 > f2 && f5 < f2 + f4) {
                    if (sGTuple2f.y <= f2) {
                        f8 = f2;
                        f9 = f5 - f2;
                    } else if (sGTuple2f.y >= f2 + f4) {
                        f8 = f5;
                        f9 = f2 + f4 - f5;
                    } else if (sGTuple2f.y > f2 && sGTuple2f.y < f2 + f4) {
                        if (f5 >= sGTuple2f.y) {
                            f8 = sGTuple2f.y;
                            f9 = f5 - sGTuple2f.y;
                        } else {
                            f8 = f5;
                            f9 = sGTuple2f.y - f5;
                        }
                    }
                }
                SGDrawingElementBar2D sGDrawingElementBar2D = new SGDrawingElementBar2D(f6, f8, f7, f9);
                sGDrawingElementBar2D.setColorList(this.mColorList);
                this.addDrawingElement(sGDrawingElementBar2D);
            }
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D) {
            block4: {
                super.paintElement(graphics2D);
                if (!this.isSelected()) break block4;
                int n = this.mDrawingElementList.size();
                if (n <= 8) {
                    for (int i = 0; i < n; ++i) {
                        SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)this.mDrawingElementList.get(i);
                        this.emphasisBar(sGDrawingElementBar2D, graphics2D);
                    }
                } else {
                    int n2 = n / 8;
                    int n3 = 0;
                    do {
                        SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)this.mDrawingElementList.get(n3);
                        this.emphasisBar(sGDrawingElementBar2D, graphics2D);
                    } while ((n3 += n2) < n);
                }
            }
            return true;
        }

        private boolean emphasisBar(SGDrawingElementBar2D sGDrawingElementBar2D, Graphics2D graphics2D) {
            Rectangle2D rectangle2D = sGDrawingElementBar2D.getElementBounds();
            Point2D.Float float_ = new Point2D.Float((float)rectangle2D.getX(), (float)rectangle2D.getY());
            Point2D.Float float_2 = new Point2D.Float((float)(rectangle2D.getX() + rectangle2D.getWidth()), (float)rectangle2D.getY());
            Point2D.Float float_3 = new Point2D.Float((float)rectangle2D.getX(), (float)(rectangle2D.getY() + rectangle2D.getHeight()));
            Point2D.Float float_4 = new Point2D.Float((float)(rectangle2D.getX() + rectangle2D.getWidth()), (float)(rectangle2D.getY() + rectangle2D.getHeight()));
            SGSXYGraphElement.this.drawEmphasisSymol(graphics2D, float_);
            SGSXYGraphElement.this.drawEmphasisSymol(graphics2D, float_2);
            SGSXYGraphElement.this.drawEmphasisSymol(graphics2D, float_3);
            SGSXYGraphElement.this.drawEmphasisSymol(graphics2D, float_4);
            return true;
        }

        protected boolean setDialogProperty() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            sGPropertyDialogSXYData.setBarVisible(this.isVisible());
            sGPropertyDialogSXYData.setBarWidth(new Float(this.mRectangleWidth * this.mRulerUnit));
            sGPropertyDialogSXYData.setBarEdgeLineWidth(new Float(this.mEdgeLineWidth));
            sGPropertyDialogSXYData.setBarBaselineValue(new Double(this.mBaselineValue));
            sGPropertyDialogSXYData.setBarInnerColorList(this.mColorList);
            sGPropertyDialogSXYData.setBarEdgeLineColor(this.mEdgeLineColor);
            return true;
        }

        protected SGElementGroup.ElementGroupProperties getPropertiesFromDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            SGElementGroupBar.BarProperties barProperties = sGPropertyDialogSXYData.getBarProperties();
            return barProperties;
        }
    }

    class ElementGroupLine
    extends SGElementGroupLine {
        protected ElementGroupLine() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f);
            Integer n = SGDrawingElementLine.getLineTypeFromName("Solid");
            if (n == null) {
                return false;
            }
            this.setLineType(n);
            this.setColor(SGDefaultValues.LINE_COLOR);
            return true;
        }

        public boolean createDrawingElement(ArrayList arrayList) {
            float f = SGSXYGraphElement.this.mGraphAreaX;
            float f2 = SGSXYGraphElement.this.mGraphAreaY;
            float f3 = SGSXYGraphElement.this.mGraphAreaWidth;
            float f4 = SGSXYGraphElement.this.mGraphAreaHeight;
            float f5 = this.mMagnification;
            int n = arrayList.size();
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2fArray[i] = (SGTuple2f)arrayList.get(i);
            }
            boolean[] blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = SGSXYGraphElement.this.isInsideGraphArea(sGTuple2fArray[i]);
            }
            ArrayList<SGTuple2f> arrayList2 = new ArrayList<SGTuple2f>();
            if (n <= 2) {
                for (int i = 0; i < n; ++i) {
                    arrayList2.add(sGTuple2fArray[i]);
                }
            } else {
                if (blArray[0] || blArray[1]) {
                    arrayList2.add(sGTuple2fArray[0]);
                }
                for (int i = 1; i < n - 1; ++i) {
                    if (!blArray[i - 1] && !blArray[i] && !blArray[i + 1]) continue;
                    arrayList2.add(sGTuple2fArray[i]);
                }
                if (blArray[n - 2] || blArray[n - 1]) {
                    arrayList2.add(sGTuple2fArray[n - 1]);
                }
            }
            super.createDrawingElement(arrayList2);
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D) {
            block5: {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph;
                super.paintElement(graphics2D);
                if (!this.isSelected() || (elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet).isSymbolVisible() || elementGroupSetInSXYGraph.isBarVisible()) break block5;
                int n = 0;
                ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
                PathIterator pathIterator = this.mConnectedPath.getPathIterator(new AffineTransform());
                float[] fArray = new float[6];
                pathIterator.currentSegment(fArray);
                Point2D.Float float_ = new Point2D.Float(fArray[0], fArray[1]);
                pathIterator.next();
                while (!pathIterator.isDone()) {
                    pathIterator.currentSegment(fArray);
                    Point2D.Float float_2 = new Point2D.Float(fArray[0], fArray[1]);
                    ((Point2D)float_2).setLocation((((Point2D)float_).getX() + ((Point2D)float_2).getX()) / 2.0, (((Point2D)float_).getY() + ((Point2D)float_2).getY()) / 2.0);
                    ((Point2D)float_).setLocation(fArray[0], fArray[1]);
                    arrayList.add(float_2);
                    pathIterator.next();
                    ++n;
                }
                if (n <= 8) {
                    for (int i = 0; i < n; ++i) {
                        Point2D point2D = (Point2D)arrayList.get(i);
                        SGSXYGraphElement.this.drawEmphasisSymol(graphics2D, point2D);
                    }
                } else {
                    int n2 = n / 8;
                    int n3 = 0;
                    do {
                        Point2D point2D = (Point2D)arrayList.get(n3);
                        SGSXYGraphElement.this.drawEmphasisSymol(graphics2D, point2D);
                    } while ((n3 += n2) < n);
                }
            }
            return true;
        }

        protected boolean setDialogProperty() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            sGPropertyDialogSXYData.setLineVisible(this.isVisible());
            sGPropertyDialogSXYData.setLineWidth(new Float(this.mLineWidth));
            sGPropertyDialogSXYData.setLineType(new Integer(this.mLineType));
            sGPropertyDialogSXYData.setLineColorList(this.mColorList);
            return true;
        }

        protected SGElementGroup.ElementGroupProperties getPropertiesFromDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            SGElementGroupLine.LineProperties lineProperties = sGPropertyDialogSXYData.getLineProperties();
            return lineProperties;
        }
    }

    class ElementGroupSetInSXYGraph
    extends SGGraphElement.ElementGroupSetInGraph
    implements IElementGroupSetInSXYGraph,
    SGIPropertySettingListenerSXYData {
        private ElementGroupErrorBar mErrorBarGroup = null;
        private ElementGroupTickLabelStringElement mTickLabels = null;
        private ArrayList mPointsList = null;

        protected ElementGroupSetInSXYGraph() {
            this.createPopupMenu();
        }

        private boolean createPopupMenu() {
            this.mPopupMenu.setBounds(0, 0, 100, 100);
            String[] stringArray = new String[]{"Dialog"};
            for (int i = 0; i < stringArray.length; ++i) {
                JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
                jMenuItem.addActionListener(this);
                this.mPopupMenu.add(jMenuItem);
            }
            return true;
        }

        public boolean contains(int n, int n2) {
            if (super.contains(n, n2)) {
                return true;
            }
            if (this.mErrorBarGroup != null && this.mErrorBarGroup.contains(n, n2)) {
                return true;
            }
            return this.mTickLabels != null && this.mTickLabels.contains(n, n2);
        }

        public boolean zoom(int n, int n2, float f) {
            super.zoom(n, n2, f);
            ElementGroupErrorBar elementGroupErrorBar = this.mErrorBarGroup;
            if (elementGroupErrorBar != null) {
                elementGroupErrorBar.zoom(n, n2, f);
            }
            if (this.mTickLabels != null) {
                this.mTickLabels.zoom(n, n2, f);
            }
            return true;
        }

        public ArrayList getLineGroups() {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                Object e = this.mDrawingElementGroupList.get(i);
                if (!(e instanceof SGElementGroupLine)) continue;
                arrayList.add(e);
            }
            return arrayList;
        }

        public ArrayList getSymbolGroups() {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                Object e = this.mDrawingElementGroupList.get(i);
                if (!(e instanceof SGElementGroupSymbol)) continue;
                arrayList.add(e);
            }
            return arrayList;
        }

        public ArrayList getBarGroups() {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                Object e = this.mDrawingElementGroupList.get(i);
                if (!(e instanceof SGElementGroupBar)) continue;
                arrayList.add(e);
            }
            return arrayList;
        }

        public ArrayList getErrorBarGroups() {
            ArrayList<ElementGroupErrorBar> arrayList = new ArrayList<ElementGroupErrorBar>();
            if (this.mErrorBarGroup != null) {
                arrayList.add(this.mErrorBarGroup);
            }
            return arrayList;
        }

        public ArrayList getTickLabelGroups() {
            ArrayList<ElementGroupTickLabelStringElement> arrayList = new ArrayList<ElementGroupTickLabelStringElement>();
            if (this.mTickLabels != null) {
                arrayList.add(this.mTickLabels);
            }
            return arrayList;
        }

        public boolean setLineProperties(SGProperties sGProperties) {
            return this.setProperties(this.getLineGroups(), sGProperties);
        }

        public boolean setSymbolProperties(SGProperties sGProperties) {
            return this.setProperties(this.getSymbolGroups(), sGProperties);
        }

        public boolean setBarProperties(SGProperties sGProperties) {
            return this.setProperties(this.getBarGroups(), sGProperties);
        }

        public boolean setErrorBarProperties(SGProperties sGProperties) {
            return this.setProperties(this.getErrorBarGroups(), sGProperties);
        }

        public boolean setTickLabelProperties(SGProperties sGProperties) {
            return this.setProperties(this.getTickLabelGroups(), sGProperties);
        }

        private boolean setProperties(ArrayList arrayList, SGProperties sGProperties) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                if (sGElementGroup.setProperties(sGProperties)) continue;
                return false;
            }
            return true;
        }

        public int getXAxisConfiguration() {
            return SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(this.mXAxis);
        }

        public int getYAxisConfiguration() {
            return SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(this.mYAxis);
        }

        public boolean addDrawingElementGroup(int n) {
            SGElementGroupSXY sGElementGroupSXY = null;
            if (n == 0) {
                sGElementGroupSXY = new ElementGroupLine();
            } else if (n == 2) {
                sGElementGroupSXY = new ElementGroupBar();
            } else if (n == 1) {
                sGElementGroupSXY = new ElementGroupSymbol();
            } else {
                throw new Error("");
            }
            if (!this.checkGroupType(sGElementGroupSXY)) {
                return false;
            }
            sGElementGroupSXY.setMagnification(this.mMagnification);
            this.addElementGroup(sGElementGroupSXY);
            return true;
        }

        public boolean addDrawingElementGroup(SGDrawingElement sGDrawingElement) {
            SGElementGroupSXY sGElementGroupSXY = null;
            if (sGDrawingElement instanceof SGDrawingElementLine) {
                sGElementGroupSXY = new ElementGroupLine();
            } else if (sGDrawingElement instanceof SGDrawingElementRectangle) {
                sGElementGroupSXY = new ElementGroupBar();
            } else if (sGDrawingElement instanceof SGDrawingElementSymbol) {
                sGElementGroupSXY = new ElementGroupSymbol();
            } else {
                throw new Error("");
            }
            if (!this.checkGroupType(sGElementGroupSXY)) {
                return false;
            }
            sGElementGroupSXY.setProperty(sGDrawingElement);
            sGElementGroupSXY.setMagnification(this.mMagnification);
            this.addElementGroup(sGElementGroupSXY);
            return true;
        }

        private boolean checkGroupType(SGElementGroup sGElementGroup) {
            Class<?> clazz = sGElementGroup.getClass();
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                SGElementGroup sGElementGroup2 = (SGElementGroup)this.mDrawingElementGroupList.get(i);
                Class<?> clazz2 = sGElementGroup2.getClass();
                if (!clazz.equals(clazz2)) continue;
                System.out.println("\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\uff01");
                return false;
            }
            return true;
        }

        protected boolean isLineVisible() {
            ArrayList arrayList = this.getLineGroups();
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(0);
            return sGElementGroup.isVisible();
        }

        protected boolean isSymbolVisible() {
            ArrayList arrayList = this.getSymbolGroups();
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(0);
            return sGElementGroup.isVisible();
        }

        protected boolean isBarVisible() {
            ArrayList arrayList = this.getBarGroups();
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(0);
            return sGElementGroup.isVisible();
        }

        public boolean createPointList(SGData sGData) {
            if (!(sGData instanceof SGSXYData)) {
                return false;
            }
            SGSXYData sGSXYData = (SGSXYData)sGData;
            this.mPointsList = new ArrayList();
            boolean bl = SGSXYGraphElement.this.calcLocationOfSXYData(sGSXYData.getValueArray(), this.mXAxis, this.mYAxis, this.mPointsList);
            return bl;
        }

        protected boolean createDrawingElements() {
            Object object;
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (SGElementGroupSXY)arrayList.get(i);
                if (!((SGElementGroup)object).isVisible()) continue;
                ((SGElementGroupSXY)object).createDrawingElement(this.mPointsList);
            }
            SGSXYData sGSXYData = (SGSXYData)SGSXYGraphElement.this.getData(this);
            if (this.mErrorBarGroup != null && this.mErrorBarGroup.mVisibleFlag) {
                object = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                this.mErrorBarGroup.calcErrorBarRatio(sGSXYData, this.mXAxis, this.mYAxis, (ArrayList)object, arrayList2);
                this.mErrorBarGroup.createDrawingElement((ArrayList)object, arrayList2);
            }
            if (this.mTickLabels != null && this.mTickLabels.mVisibleFlag) {
                this.createDataString(sGSXYData);
            }
            return true;
        }

        private boolean addElementGroup(SGElementGroupSXY sGElementGroupSXY) {
            sGElementGroupSXY.mGroupSet = this;
            if (this.mPointsList == null) {
                throw new Error();
            }
            sGElementGroupSXY.createDrawingElement(this.mPointsList);
            sGElementGroupSXY.setMagnification(this.mMagnification);
            this.mDrawingElementGroupList.add(sGElementGroupSXY);
            return true;
        }

        private boolean createDataString(SGSXYData sGSXYData) {
            this.mTickLabels.createDrawingElements(sGSXYData);
            return true;
        }

        public Rectangle2D getTickLabelsBoundingBox(SGData sGData) {
            if (!(sGData instanceof SGSXYData)) {
                return null;
            }
            SGSXYData sGSXYData = (SGSXYData)sGData;
            ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
            ElementGroupTickLabelStringElement elementGroupTickLabelStringElement = this.mTickLabels;
            if (elementGroupTickLabelStringElement == null) {
                return new Rectangle2D.Float();
            }
            if (!elementGroupTickLabelStringElement.isVisible()) {
                return new Rectangle2D.Float();
            }
            if (!this.createDataString(sGSXYData)) {
                return null;
            }
            ArrayList arrayList2 = elementGroupTickLabelStringElement.mDrawingElementList;
            Rectangle2D rectangle2D = SGUtilityJava2D.getBoundingBox(arrayList2);
            arrayList.add(rectangle2D);
            Rectangle2D rectangle2D2 = SGUtility.createUnion(arrayList);
            return rectangle2D2;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            ElementGroupSymbol elementGroupSymbol;
            ElementGroupLine elementGroupLine;
            ElementGroupErrorBar elementGroupErrorBar;
            ElementGroupBar elementGroupBar = SGSXYGraphElement.this.getGroupBar(this);
            if (elementGroupBar != null && elementGroupBar.isVisible()) {
                elementGroupBar.paintElement(graphics2D);
            }
            if ((elementGroupErrorBar = this.mErrorBarGroup) != null && elementGroupErrorBar.isVisible()) {
                elementGroupErrorBar.paintElement(graphics2D);
            }
            if ((elementGroupLine = SGSXYGraphElement.this.getGroupLine(this)) != null && elementGroupLine.isVisible()) {
                elementGroupLine.paintElement(graphics2D);
            }
            if ((elementGroupSymbol = SGSXYGraphElement.this.getGroupSymbol(this)) != null && elementGroupSymbol.isVisible()) {
                elementGroupSymbol.paintElement(graphics2D);
            }
        }

        public boolean paintDataString(Graphics2D graphics2D) {
            ElementGroupTickLabelStringElement elementGroupTickLabelStringElement = this.mTickLabels;
            if (elementGroupTickLabelStringElement != null && elementGroupTickLabelStringElement.isVisible()) {
                elementGroupTickLabelStringElement.paintElement(graphics2D);
            }
            return true;
        }

        protected boolean clickDrawingElements(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            if (!this.contains(n2, n = mouseEvent.getY())) {
                return false;
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                return true;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                this.showPropertyDialog();
                return true;
            }
            return true;
        }

        public boolean setPropertiesFromDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            if (!(sGPropertyDialogSXYData.getLineVisible() || sGPropertyDialogSXYData.getBarVisible() || sGPropertyDialogSXYData.getSymbolVisible())) {
                JOptionPane.showMessageDialog(sGPropertyDialogSXYData, SGSXYGraphElement.MSG_NOT_HIDE_ALL_ELEMENTS);
                return false;
            }
            if (!this.setPropertyWithDialog_()) {
                return false;
            }
            SGSXYGraphElement.this.createAllDrawingElements();
            SGSXYGraphElement.this.repaint();
            return true;
        }

        private boolean setPropertyWithDialog_() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            this.setAxisPropertyWithDialog();
            ArrayList arrayList = this.getLineGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroupLine sGElementGroupLine = (SGElementGroupLine)arrayList.get(i);
                if (!sGPropertyDialogSXYData.isTabEnabled(sGPropertyDialogSXYData.getLinePanel()) || sGPropertyDialogSXYData.setLineProperties(sGElementGroupLine)) continue;
                return false;
            }
            ArrayList arrayList2 = this.getSymbolGroups();
            for (int i = 0; i < arrayList2.size(); ++i) {
                SGElementGroupSymbol sGElementGroupSymbol = (SGElementGroupSymbol)arrayList2.get(i);
                if (!sGPropertyDialogSXYData.isTabEnabled(sGPropertyDialogSXYData.getSymbolPanel()) || sGPropertyDialogSXYData.setSymbolProperties(sGElementGroupSymbol)) continue;
                return false;
            }
            ArrayList arrayList3 = this.getBarGroups();
            for (int i = 0; i < arrayList3.size(); ++i) {
                SGElementGroupBar sGElementGroupBar = (SGElementGroupBar)arrayList3.get(i);
                if (!sGPropertyDialogSXYData.isTabEnabled(sGPropertyDialogSXYData.getBarPanel()) || sGPropertyDialogSXYData.setBarProperties(sGElementGroupBar)) continue;
                return false;
            }
            if (this.mErrorBarGroup != null && sGPropertyDialogSXYData.isTabEnabled(sGPropertyDialogSXYData.getErrorBarPanel()) && !sGPropertyDialogSXYData.setErrorBarProperties(this.mErrorBarGroup)) {
                return false;
            }
            return this.mTickLabels == null || !sGPropertyDialogSXYData.isTabEnabled(sGPropertyDialogSXYData.getTickLabelPanel()) || sGPropertyDialogSXYData.setTickLabelProperties(this.mTickLabels);
        }

        private boolean setAxisPropertyWithDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            SGAxis sGAxis = SGSXYGraphElement.this.mAxisElement.getAxisInPlane(1);
            SGAxis sGAxis2 = SGSXYGraphElement.this.mAxisElement.getAxisInPlane(-1);
            SGAxis sGAxis3 = SGSXYGraphElement.this.mAxisElement.getAxisInPlane(2);
            SGAxis sGAxis4 = SGSXYGraphElement.this.mAxisElement.getAxisInPlane(-2);
            if (sGPropertyDialogSXYData.isLeftBottomSelected()) {
                this.mXAxis = sGAxis;
                this.mYAxis = sGAxis3;
            } else if (sGPropertyDialogSXYData.isLeftTopSelected()) {
                this.mXAxis = sGAxis2;
                this.mYAxis = sGAxis3;
            } else if (sGPropertyDialogSXYData.isRightBottomSelected()) {
                this.mXAxis = sGAxis;
                this.mYAxis = sGAxis4;
            } else if (sGPropertyDialogSXYData.isRightTopSelected()) {
                this.mXAxis = sGAxis2;
                this.mYAxis = sGAxis4;
            }
            return true;
        }

        public boolean showPropertyDialog() {
            super.showPropertyDialog();
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            this.setDialogProperty();
            int n = sGPropertyDialogSXYData.getTabbedPane().getSelectedIndex();
            sGPropertyDialogSXYData.setColorButtonProperty(n);
            this.createTemporaryPropertyObject();
            sGPropertyDialogSXYData.show();
            sGPropertyDialogSXYData.removeAllPropertySettingListeners();
            return true;
        }

        public boolean createTemporaryPropertyObject() {
            this.mTemporaryProperties = this.getWholeProperties();
            return true;
        }

        public boolean readProperties(BufferedReader bufferedReader, SGProperties sGProperties) throws IOException {
            SGProperties sGProperties2;
            if (bufferedReader == null || sGProperties == null) {
                return false;
            }
            if (!super.readProperties(bufferedReader, sGProperties)) {
                return false;
            }
            if (!(sGProperties instanceof ElementGroupSetInSXYGraphProperties)) {
                return false;
            }
            ElementGroupSetInSXYGraphProperties elementGroupSetInSXYGraphProperties = (ElementGroupSetInSXYGraphProperties)sGProperties;
            String string = null;
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return false;
            }
            if (string.equals("<Error Bar>")) {
                sGProperties2 = this.mErrorBarGroup.readProperties(bufferedReader);
                if (sGProperties2 == null) {
                    return false;
                }
                elementGroupSetInSXYGraphProperties.errorBarProperties = sGProperties2;
            } else if (string.equals(SGSXYGraphElement.PF_ERROR_BAR_EMPTY)) {
                elementGroupSetInSXYGraphProperties.errorBarProperties = null;
            } else {
                return false;
            }
            string = SGUtilityText.readLine(bufferedReader);
            if (string == null) {
                return false;
            }
            if (string.equals("<Tick Labels>")) {
                sGProperties2 = this.mTickLabels.readProperties(bufferedReader);
                if (sGProperties2 == null) {
                    return false;
                }
                elementGroupSetInSXYGraphProperties.tickLabelsProperties = sGProperties2;
            } else if (string.equals(SGSXYGraphElement.PF_TICK_LABELS_EMPTY)) {
                elementGroupSetInSXYGraphProperties.tickLabelsProperties = null;
            } else {
                return false;
            }
            return true;
        }

        public SGProperties readProperties(BufferedReader bufferedReader) throws IOException {
            ElementGroupSetInSXYGraphProperties elementGroupSetInSXYGraphProperties = new ElementGroupSetInSXYGraphProperties();
            if (!this.readProperties(bufferedReader, elementGroupSetInSXYGraphProperties)) {
                return null;
            }
            SGElementGroupSet.WholeProperties wholeProperties = new SGElementGroupSet.WholeProperties();
            wholeProperties.ep = elementGroupSetInSXYGraphProperties;
            String string = null;
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                string = SGUtilityText.readLine(bufferedReader);
                if (string == null) {
                    return null;
                }
                SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
                SGProperties sGProperties = sGElementGroup.readProperties(bufferedReader);
                wholeProperties.ipList.add(sGProperties);
            }
            return wholeProperties;
        }

        private boolean setDialogProperty() {
            this.setDialogPropertyOfAxis();
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
                sGElementGroup.setDialogProperty();
            }
            if (this.mErrorBarGroup != null) {
                this.mErrorBarGroup.setDialogProperty();
            }
            if (this.mTickLabels != null) {
                this.mTickLabels.setDialogProperty();
            }
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            sGPropertyDialogSXYData.setTabEnabled(sGPropertyDialogSXYData.getLinePanel(), true);
            sGPropertyDialogSXYData.setTabEnabled(sGPropertyDialogSXYData.getSymbolPanel(), true);
            sGPropertyDialogSXYData.setTabEnabled(sGPropertyDialogSXYData.getBarPanel(), true);
            if (this.mErrorBarGroup != null) {
                sGPropertyDialogSXYData.setTabEnabled(sGPropertyDialogSXYData.getErrorBarPanel(), true);
            } else {
                if (sGPropertyDialogSXYData.getTabbedPane().getSelectedComponent().equals(sGPropertyDialogSXYData.getErrorBarPanel())) {
                    sGPropertyDialogSXYData.getTabbedPane().setSelectedComponent(sGPropertyDialogSXYData.getLinePanel());
                }
                sGPropertyDialogSXYData.setTabEnabled(sGPropertyDialogSXYData.getErrorBarPanel(), false);
            }
            if (this.mTickLabels != null) {
                sGPropertyDialogSXYData.setTabEnabled(sGPropertyDialogSXYData.getTickLabelPanel(), true);
            } else {
                if (sGPropertyDialogSXYData.getTabbedPane().getSelectedComponent().equals(sGPropertyDialogSXYData.getTickLabelPanel())) {
                    sGPropertyDialogSXYData.getTabbedPane().setSelectedComponent(sGPropertyDialogSXYData.getLinePanel());
                }
                sGPropertyDialogSXYData.setTabEnabled(sGPropertyDialogSXYData.getTickLabelPanel(), false);
            }
            return true;
        }

        private boolean setDialogPropertyOfAxis() {
            int n;
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            int n2 = SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(this.mXAxis);
            boolean bl = sGPropertyDialogSXYData.setAxisRadioButton(n2, n = SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(this.mYAxis));
            return bl;
        }

        public boolean writePropertyOfData(Writer writer) throws IOException {
            if (!super.writePropertyOfData(writer)) {
                return false;
            }
            int n = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(this.mXAxis);
            int n2 = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(this.mYAxis);
            String string = SGSXYGraphElement.this.mAxisElement.getConfigurationStringInPlaneByCube(n);
            String string2 = SGSXYGraphElement.this.mAxisElement.getConfigurationStringInPlaneByCube(n2);
            SGUtilityText.writePropertyLine(writer, "Location of the X-Axis", string);
            SGUtilityText.writePropertyLine(writer, "Location of the Y-Axis", string2);
            writer.write("\n");
            if (this.mErrorBarGroup != null) {
                this.mErrorBarGroup.writePropertyOfData(writer);
            } else {
                writer.write(SGSXYGraphElement.PF_ERROR_BAR_EMPTY);
                writer.write("\n\n");
            }
            if (this.mTickLabels != null) {
                this.mTickLabels.writePropertyOfData(writer);
            } else {
                writer.write(SGSXYGraphElement.PF_TICK_LABELS_EMPTY);
                writer.write("\n\n");
            }
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
                sGElementGroup.writePropertyOfData(writer);
            }
            writer.write("\n");
            return true;
        }

        public SGProperties getProperties() {
            ElementGroupSetInSXYGraphProperties elementGroupSetInSXYGraphProperties = new ElementGroupSetInSXYGraphProperties();
            if (!this.getProperties(elementGroupSetInSXYGraphProperties)) {
                return null;
            }
            return elementGroupSetInSXYGraphProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ElementGroupSetInSXYGraphProperties)) {
                return false;
            }
            super.getProperties(sGProperties);
            ElementGroupSetInSXYGraphProperties elementGroupSetInSXYGraphProperties = (ElementGroupSetInSXYGraphProperties)sGProperties;
            if (this.mErrorBarGroup != null) {
                elementGroupSetInSXYGraphProperties.errorBarProperties = this.mErrorBarGroup.getProperties();
            }
            if (this.mTickLabels != null) {
                elementGroupSetInSXYGraphProperties.tickLabelsProperties = this.mTickLabels.getProperties();
            }
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGGraphElement.ElementGroupSetInGraph.ElementGroupSetInGraphProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            ElementGroupSetInSXYGraphProperties elementGroupSetInSXYGraphProperties = (ElementGroupSetInSXYGraphProperties)sGProperties;
            if (this.mErrorBarGroup != null) {
                this.mErrorBarGroup.setProperties(elementGroupSetInSXYGraphProperties.errorBarProperties);
            }
            if (this.mTickLabels != null) {
                this.mTickLabels.setProperties(elementGroupSetInSXYGraphProperties.tickLabelsProperties);
            }
            return true;
        }

        class ElementGroupSetInSXYGraphProperties
        extends SGGraphElement.ElementGroupSetInGraph.ElementGroupSetInGraphProperties {
            SGProperties errorBarProperties;
            SGProperties tickLabelsProperties;

            ElementGroupSetInSXYGraphProperties() {
            }

            public boolean equals(Object object) {
                if (!(object instanceof ElementGroupSetInSXYGraphProperties)) {
                    return false;
                }
                if (!super.equals(object)) {
                    return false;
                }
                ElementGroupSetInSXYGraphProperties elementGroupSetInSXYGraphProperties = (ElementGroupSetInSXYGraphProperties)object;
                if (elementGroupSetInSXYGraphProperties.errorBarProperties == null ? this.errorBarProperties != null : !elementGroupSetInSXYGraphProperties.errorBarProperties.equals(this.errorBarProperties)) {
                    return false;
                }
                return !(elementGroupSetInSXYGraphProperties.tickLabelsProperties == null ? this.tickLabelsProperties != null : !elementGroupSetInSXYGraphProperties.tickLabelsProperties.equals(this.tickLabelsProperties));
            }

            public String toString() {
                String string = new String("[");
                string = string + super.toString();
                string = this.errorBarProperties != null ? string + this.errorBarProperties.toString() : string + "ErrorBars_empty, ";
                string = this.tickLabelsProperties != null ? string + this.tickLabelsProperties.toString() : string + "TickLabels_empty, ";
                string = string + new String("]");
                return string;
            }
        }
    }

    class ElementGroupSetForMultipleDataInSXYGraph
    extends SGGraphElement.ElementGroupSetForMultipleData
    implements ActionListener,
    IElementGroupSetInSXYGraph {
        protected ElementGroupSetForMultipleDataInSXYGraph() {
        }

        protected boolean createDrawingElements() {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                if (elementGroupSetInGraph.createDrawingElements()) continue;
                return false;
            }
            return true;
        }

        public boolean createPointList(SGData sGData) {
            if (!(sGData instanceof SGSXYMultipleData)) {
                return false;
            }
            SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)sGData;
            SGSXYData[] sGSXYDataArray = sGSXYMultipleData.getSXYDataArray();
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                if (iElementGroupSetInSXYGraph.createPointList(sGSXYDataArray[i])) continue;
                return false;
            }
            return true;
        }

        public Rectangle2D getTickLabelsBoundingBox(SGData sGData) {
            if (!(sGData instanceof SGSXYMultipleData)) {
                return null;
            }
            SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)sGData;
            SGSXYData[] sGSXYDataArray = sGSXYMultipleData.getSXYDataArray();
            ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                Rectangle2D rectangle2D = iElementGroupSetInSXYGraph.getTickLabelsBoundingBox(sGSXYDataArray[i]);
                if (rectangle2D == null) {
                    return null;
                }
                arrayList.add(rectangle2D);
            }
            Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
            return rectangle2D;
        }

        public boolean paintDataString(Graphics2D graphics2D) {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                iElementGroupSetInSXYGraph.paintDataString(graphics2D);
            }
            return true;
        }

        public boolean showPropertyDialog() {
            super.showPropertyDialog();
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            this.setDialogProperty();
            int n = sGPropertyDialogSXYData.getTabbedPane().getSelectedIndex();
            sGPropertyDialogSXYData.setColorButtonProperty(n);
            this.createTemporaryPropertyObject();
            sGPropertyDialogSXYData.show();
            return true;
        }

        public boolean createTemporaryPropertyObject() {
            this.mTemporaryProperties = this.getWholeProperties();
            return true;
        }

        private boolean setDialogProperty() {
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mElementGroupSetList.get(0);
            return elementGroupSetInSXYGraph.setDialogProperty();
        }

        public boolean setPropertiesFromDialog() {
            SGPropertyDialogSXYData sGPropertyDialogSXYData = (SGPropertyDialogSXYData)SGGraphElement.mPropertyDialogForData;
            if (!(sGPropertyDialogSXYData.getLineVisible() || sGPropertyDialogSXYData.getBarVisible() || sGPropertyDialogSXYData.getSymbolVisible())) {
                JOptionPane.showMessageDialog(sGPropertyDialogSXYData, SGSXYGraphElement.MSG_NOT_HIDE_ALL_ELEMENTS);
                return false;
            }
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                if (elementGroupSetInSXYGraph.setPropertyWithDialog_()) continue;
                return false;
            }
            return true;
        }

        protected boolean recover() {
            return this.setWholeProperties(this.mTemporaryProperties);
        }

        protected boolean clickDrawingElements(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            if (!this.contains(n2, n = mouseEvent.getY())) {
                return false;
            }
            if ((!SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.getClickCount() != 1) && SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                this.showPropertyDialog();
            }
            return true;
        }

        public SGProperties getProperties() {
            ElementGroupSetPropertiesForSamplingDataInSXYGraph elementGroupSetPropertiesForSamplingDataInSXYGraph = new ElementGroupSetPropertiesForSamplingDataInSXYGraph();
            if (!this.getProperties(elementGroupSetPropertiesForSamplingDataInSXYGraph)) {
                return null;
            }
            return elementGroupSetPropertiesForSamplingDataInSXYGraph;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ElementGroupSetPropertiesForSamplingDataInSXYGraph)) {
                return false;
            }
            ElementGroupSetPropertiesForSamplingDataInSXYGraph elementGroupSetPropertiesForSamplingDataInSXYGraph = (ElementGroupSetPropertiesForSamplingDataInSXYGraph)sGProperties;
            elementGroupSetPropertiesForSamplingDataInSXYGraph.samplingRate = this.getSamplingRate();
            return true;
        }

        public double getSamplingRate() {
            SGData sGData = SGSXYGraphElement.this.getData(this);
            SGSXYSamplingData sGSXYSamplingData = (SGSXYSamplingData)sGData;
            return sGSXYSamplingData.getSamplingRate();
        }

        public SGProperties getWholeProperties() {
            SGElementGroupSet.WholeProperties wholeProperties;
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mElementGroupSetList.get(0);
            if (!elementGroupSetInSXYGraph.getWholeProperties(wholeProperties = new SGElementGroupSet.WholeProperties())) {
                return null;
            }
            return wholeProperties;
        }

        public boolean setWholeProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSet.WholeProperties)) {
                return false;
            }
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)sGProperties;
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                if (elementGroupSetInSXYGraph.setWholeProperties(sGProperties)) continue;
                return false;
            }
            return true;
        }

        public boolean writePropertyOfData(Writer writer) throws IOException {
            SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)SGSXYGraphElement.this.getData(this);
            if (sGSXYMultipleData instanceof SGSXYSamplingData) {
                double d = this.getSamplingRate();
                SGUtilityText.writePropertyLine(writer, "Sampling Rate", new Double(d));
            }
            if (!super.writePropertyOfData(writer)) {
                return false;
            }
            int n = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(this.mXAxis);
            int n2 = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(this.mYAxis);
            String string = SGSXYGraphElement.this.mAxisElement.getConfigurationStringInPlaneByCube(n);
            String string2 = SGSXYGraphElement.this.mAxisElement.getConfigurationStringInPlaneByCube(n2);
            SGUtilityText.writePropertyLine(writer, "Location of the X-Axis", string);
            SGUtilityText.writePropertyLine(writer, "Location of the Y-Axis", string2);
            writer.write("\n");
            writer.write(SGSXYGraphElement.PF_ERROR_BAR_EMPTY);
            writer.write("\n\n");
            writer.write(SGSXYGraphElement.PF_TICK_LABELS_EMPTY);
            writer.write("\n\n");
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mElementGroupSetList.get(0);
            ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                sGElementGroup.writePropertyOfData(writer);
            }
            writer.write("\n");
            return true;
        }

        public SGProperties readProperties(BufferedReader bufferedReader) throws IOException {
            Serializable serializable;
            SGGraphElement.ElementGroupSetInGraph.ElementGroupSetInGraphProperties elementGroupSetInGraphProperties = null;
            SGData sGData = SGSXYGraphElement.this.getData(this);
            elementGroupSetInGraphProperties = sGData instanceof SGSXYSamplingData ? new ElementGroupSetPropertiesForSamplingDataInSXYGraph() : new SGGraphElement.ElementGroupSetInGraph.ElementGroupSetInGraphProperties();
            if (!this.readProperties(bufferedReader, elementGroupSetInGraphProperties)) {
                return null;
            }
            String string = null;
            if (sGData instanceof SGSXYSamplingData) {
                if (SGUtilityText.readLine(bufferedReader) == null) {
                    return null;
                }
                serializable = SGUtilityText.getDoublePropertyFromLine(string, "Sampling Rate");
                if (serializable == null) {
                    return null;
                }
                SGGraphElement.ElementGroupSetInGraph.ElementGroupSetInGraphProperties elementGroupSetInGraphProperties2 = elementGroupSetInGraphProperties;
                elementGroupSetInGraphProperties2.samplingRate = (Double)serializable;
            }
            serializable = new SGElementGroupSet.WholeProperties();
            ((SGElementGroupSet.WholeProperties)serializable).ep = elementGroupSetInGraphProperties;
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                string = SGUtilityText.readLine(bufferedReader);
                if (string == null) {
                    return null;
                }
                SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
                SGProperties sGProperties = sGElementGroup.readProperties(bufferedReader);
                ((SGElementGroupSet.WholeProperties)serializable).ipList.add(sGProperties);
            }
            return serializable;
        }

        class ElementGroupSetPropertiesForSamplingDataInSXYGraph
        extends SGGraphElement.ElementGroupSetInGraph.ElementGroupSetInGraphProperties {
            double samplingRate;

            ElementGroupSetPropertiesForSamplingDataInSXYGraph() {
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (!(object instanceof ElementGroupSetPropertiesForSamplingDataInSXYGraph)) {
                    return false;
                }
                ElementGroupSetPropertiesForSamplingDataInSXYGraph elementGroupSetPropertiesForSamplingDataInSXYGraph = (ElementGroupSetPropertiesForSamplingDataInSXYGraph)object;
                return elementGroupSetPropertiesForSamplingDataInSXYGraph.samplingRate == this.samplingRate;
            }
        }
    }

    static interface IElementGroupSetInSXYGraph {
        public Rectangle2D getTickLabelsBoundingBox(SGData var1);

        public boolean createPointList(SGData var1);

        public boolean paintDataString(Graphics2D var1);
    }
}

