/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupString;

public abstract class SGElementGroupTickLabel
extends SGElementGroupString {
    public static final float ANGLE_HORIZONTAL = 0.0f;
    public static final float ANGLE_INCLINED = 0.5235988f;
    public static final String HORIZONTAL = "Horizontal";
    public static final String INCLINED = "Inclined";
    public static final String PF_TICK_LABEL_TITLE = "<Tick Labels>";

    public static Float getTickLabelAngleFromName(String string) {
        if (string == null) {
            return null;
        }
        Float f = null;
        if (string.equals(HORIZONTAL)) {
            f = new Float(0.0f);
        } else if (string.equals(INCLINED)) {
            f = new Float(0.5235988f);
        }
        return f;
    }

    public static String getTickLabelAngleName(double d) {
        String string = null;
        if (d == 0.0) {
            string = HORIZONTAL;
        } else if (d == 0.5235987901687622) {
            string = INCLINED;
        } else {
            throw new Error();
        }
        return string;
    }

    public boolean writePropertyOfData(Writer writer) throws IOException {
        writer.write("<Tick Labels>\n");
        SGUtilityText.writePropertyLine(writer, "Visible", new Boolean(this.mVisibleFlag));
        SGUtilityText.writePropertyLine(writer, "Font Size", new Float(this.mFontSize));
        SGUtilityText.writePropertyLine(writer, "Font Family Name", this.mFontFamilyName);
        SGUtilityText.writePropertyLine(writer, "Font Style", SGUtilityText.getFontStyleName(this.mFontStyle));
        SGUtilityText.writeColorListPropertyLine(writer, "Colors", this.mColorList);
        String string = SGElementGroupTickLabel.getTickLabelAngleName(this.mAngle);
        SGUtilityText.writePropertyLine(writer, "Angle", string);
        writer.write("\n");
        return false;
    }

    public SGProperties readProperties(BufferedReader bufferedReader) throws IOException {
        SGElementGroupString.StringProperties stringProperties = new SGElementGroupString.StringProperties();
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Boolean bl = SGUtilityText.getBooleanPropertyFromLine(string, "Visible");
        if (bl == null) {
            return null;
        }
        stringProperties.setVisible(bl);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d = SGUtilityText.getDoublePropertyFromLine(string, "Font Size");
        if (d == null) {
            return null;
        }
        stringProperties.setFontSize(d.floatValue());
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        String string2 = SGUtilityText.getPropertyFromLine(string, "Font Family Name");
        if (string2 == null) {
            return null;
        }
        stringProperties.setFontFamilyName(string2);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Integer n = SGUtilityText.getFontStyleFromLine(string, "Font Style");
        if (n == null) {
            return null;
        }
        stringProperties.setFontStyle(n);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        ArrayList arrayList = SGUtilityText.getColorListFromLine(string, "Colors");
        if (arrayList == null) {
            return null;
        }
        stringProperties.setColorList(arrayList);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        String string3 = SGUtilityText.getPropertyFromLine(string, "Angle");
        if (string3 == null) {
            return null;
        }
        Float f = SGElementGroupTickLabel.getTickLabelAngleFromName(string3);
        if (f == null) {
            return null;
        }
        stringProperties.setAngle(f.floatValue());
        return stringProperties;
    }

    public static class TickLabelProperties
    extends SGElementGroupString.StringProperties {
    }
}

