/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;

public abstract class SGElementGroupSymbol
extends SGElementGroupSXY {
    protected float mSymbolSize;
    protected int mSymbolType;
    protected double mAngle;
    protected Color mLineColor = Color.BLACK;
    protected float mLineWidth;
    public static final String PF_SYMBOL_TITLE = "<Symbol>";
    public static final String KEY_SYMBOL_SIZE = "Size";
    public static final String KEY_SYMBOL_TYPE = "Type";
    public static final String KEY_LINE_WIDTH = "Edge Line Width";
    public static final String KEY_LINE_COLOR = "Edge Line Color";
    public static final String PF_SYMBOL_COLOR_LIST = "Inner Color List";

    public float getSize() {
        return this.mSymbolSize;
    }

    public int getType() {
        return this.mSymbolType;
    }

    public double getAngle() {
        return this.mAngle;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public Color getLineColor() {
        return this.mLineColor;
    }

    public boolean setSize(float f) {
        this.mSymbolSize = f;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementList.get(i);
            sGDrawingElementSymbol2D.setSize(this.mSymbolSize);
        }
        return true;
    }

    public boolean setType(int n) {
        this.mSymbolType = n;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementList.get(i);
            sGDrawingElementSymbol2D.setType(this.mSymbolType);
        }
        return true;
    }

    public boolean setLineColor(Color color) {
        this.mLineColor = color;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementList.get(i);
            sGDrawingElementSymbol2D.setLineColor(this.mLineColor);
        }
        return true;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidth = f;
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementList.get(i);
            sGDrawingElementSymbol2D.setLineWidth(this.mLineWidth);
        }
        return true;
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = new SGDrawingElementSymbol2D();
        sGDrawingElementSymbol2D.setSize(this.mSymbolSize);
        sGDrawingElementSymbol2D.setType(this.mSymbolType);
        sGDrawingElementSymbol2D.setColorList(this.mColorList);
        sGDrawingElementSymbol2D.setLineColor(this.mLineColor);
        sGDrawingElementSymbol2D.setLineWidth(this.mLineWidth);
        return sGDrawingElementSymbol2D;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementSymbol)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementSymbol sGDrawingElementSymbol = (SGDrawingElementSymbol)sGDrawingElement;
        this.setType(sGDrawingElementSymbol.getType());
        this.setSize(sGDrawingElementSymbol.getSize());
        this.setLineWidth(sGDrawingElementSymbol.getLineWidth());
        this.setLineColor(sGDrawingElementSymbol.getLineColor());
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D) {
        for (int i = 0; i < this.mDrawingElementList.size(); ++i) {
            SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementList.get(i);
            Shape shape = sGDrawingElementSymbol2D.getShape();
            graphics2D.setPaint(this.getColor(0));
            graphics2D.fill(shape);
            graphics2D.setStroke(new BasicStroke(this.mMagnification * this.mLineWidth, 0, 0));
            graphics2D.setPaint(this.mLineColor);
            graphics2D.draw(shape);
        }
        return true;
    }

    public boolean writePropertyOfData(Writer writer) throws IOException {
        writer.write("<Symbol>\n");
        SGUtilityText.writePropertyLine(writer, "Visible", new Boolean(this.mVisibleFlag));
        SGUtilityText.writePropertyLine(writer, KEY_SYMBOL_SIZE, new Float(this.mSymbolSize * this.mRulerUnit));
        SGUtilityText.writePropertyLine(writer, KEY_SYMBOL_TYPE, SGDrawingElementSymbol.getSymbolTypeName(this.mSymbolType));
        SGUtilityText.writeColorListPropertyLine(writer, PF_SYMBOL_COLOR_LIST, this.mColorList);
        SGUtilityText.writePropertyLine(writer, KEY_LINE_WIDTH, new Float(this.mLineWidth));
        SGUtilityText.writeColorPropertyLine(writer, KEY_LINE_COLOR, this.mLineColor);
        writer.write("\n");
        return true;
    }

    public SGProperties readProperties(BufferedReader bufferedReader) throws IOException {
        SymbolProperties symbolProperties = new SymbolProperties();
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Boolean bl = SGUtilityText.getBooleanPropertyFromLine(string, "Visible");
        if (bl == null) {
            return null;
        }
        symbolProperties.setVisible(bl);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d = SGUtilityText.getDoublePropertyFromLine(string, KEY_SYMBOL_SIZE);
        if (d == null) {
            return null;
        }
        symbolProperties.setSize(d.floatValue() / 0.035277776f);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        String string2 = SGUtilityText.getPropertyFromLine(string, KEY_SYMBOL_TYPE);
        if (string2 == null) {
            return null;
        }
        Integer n = SGDrawingElementSymbol.getSymbolTypeFromName(string2);
        if (n == null) {
            return null;
        }
        symbolProperties.setSymbolType(n);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        ArrayList arrayList = SGUtilityText.getColorListFromLine(string, PF_SYMBOL_COLOR_LIST);
        if (arrayList == null) {
            return null;
        }
        symbolProperties.setColorList(arrayList);
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d2 = SGUtilityText.getDoublePropertyFromLine(string, KEY_LINE_WIDTH);
        symbolProperties.setLineWidth(d2.floatValue());
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Color color = SGUtilityText.getColorPropertyFromLine(string, KEY_LINE_COLOR);
        if (color == null) {
            return null;
        }
        symbolProperties.setLineColor(color);
        return symbolProperties;
    }

    public boolean createDrawingElement(ArrayList arrayList) {
        this.mDrawingElementList.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGTuple2f sGTuple2f = (SGTuple2f)arrayList.get(i);
            SGDrawingElementSymbol2D sGDrawingElementSymbol2D = new SGDrawingElementSymbol2D();
            sGDrawingElementSymbol2D.setLocation(sGTuple2f);
            sGDrawingElementSymbol2D.setMagnification(this.mMagnification);
            sGDrawingElementSymbol2D.setSize(this.mSymbolSize);
            sGDrawingElementSymbol2D.setType(this.mSymbolType);
            sGDrawingElementSymbol2D.setColorList(this.mColorList);
            sGDrawingElementSymbol2D.setLineWidth(this.mLineWidth);
            sGDrawingElementSymbol2D.setLineColor(this.mLineColor);
            this.addDrawingElement(sGDrawingElementSymbol2D);
        }
        return true;
    }

    public SGProperties getProperties() {
        SymbolProperties symbolProperties = new SymbolProperties();
        this.getProperties(symbolProperties);
        return symbolProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof SymbolProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        SymbolProperties symbolProperties = (SymbolProperties)sGProperties;
        symbolProperties.setSize(this.getSize());
        symbolProperties.setSymbolType(this.getType());
        symbolProperties.setLineWidth(this.getLineWidth());
        symbolProperties.setLineColor(this.getLineColor());
        symbolProperties.angle = this.getAngle();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SymbolProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SymbolProperties symbolProperties = (SymbolProperties)sGProperties;
        Float f = symbolProperties.getSize();
        if (f == null) {
            return false;
        }
        this.setSize(f.floatValue());
        Integer n = symbolProperties.getSymbolType();
        if (n == null) {
            return false;
        }
        this.setType(n);
        Float f2 = symbolProperties.getLineWidth();
        if (f2 == null) {
            return false;
        }
        this.setLineWidth(f2.floatValue());
        Color color = symbolProperties.getLineColor();
        if (color == null) {
            return false;
        }
        this.setLineColor(color);
        return true;
    }

    public static class SymbolProperties
    extends SGElementGroup.ElementGroupProperties {
        double angle;
        public static final String[] keys = new String[]{"Type", "Size", "Edge Line Width", "Edge Line Color"};

        public boolean equals(Object object) {
            if (!(object instanceof SymbolProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SymbolProperties symbolProperties = (SymbolProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(symbolProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return symbolProperties.angle == this.angle;
        }

        public Float getSize() {
            String string = this.getProperty(SGElementGroupSymbol.KEY_SYMBOL_SIZE);
            return SGUtilityText.getFloat(string);
        }

        public Integer getSymbolType() {
            String string = this.getProperty(SGElementGroupSymbol.KEY_SYMBOL_TYPE);
            return SGUtilityText.getInteger(string);
        }

        public Float getLineWidth() {
            String string = this.getProperty(SGElementGroupSymbol.KEY_LINE_WIDTH);
            return SGUtilityText.getFloat(string);
        }

        public Color getLineColor() {
            String string = this.getProperty(SGElementGroupSymbol.KEY_LINE_COLOR);
            return SGUtilityText.getColorFromString(string);
        }

        public boolean setSize(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGElementGroupSymbol.KEY_SYMBOL_SIZE, new Float(f).toString());
            return true;
        }

        public boolean setSymbolType(int n) {
            this.setProperty(SGElementGroupSymbol.KEY_SYMBOL_TYPE, new Integer(n).toString());
            return true;
        }

        public boolean setLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGElementGroupSymbol.KEY_LINE_WIDTH, new Float(f).toString());
            return true;
        }

        public boolean setLineColor(Color color) {
            if (color == null) {
                return false;
            }
            String string = SGUtilityText.getColorString(color);
            if (string == null) {
                return false;
            }
            this.setProperty(SGElementGroupSymbol.KEY_LINE_COLOR, string);
            return true;
        }
    }
}

