/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;

public abstract class SGElementGroupSet {
    protected ArrayList mDrawingElementGroupList = new ArrayList();
    protected float mMagnification = 1.0f;
    protected boolean mSelectedFlag = false;
    protected boolean mVisibleFlag = true;
    protected static final String MOVE_GRAPH_TO_FRONT = "Move this graph to front";
    protected static final String MOVE_GRAPH_TO_BACK = "Move this graph to back";
    protected static final String REMOVE_GRAPH = "Remove this graph";

    public ArrayList getDrawingElementList() {
        ArrayList<SGDrawingElement> arrayList = new ArrayList<SGDrawingElement>();
        for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
            SGDrawingElement sGDrawingElement = sGElementGroup.getDrawingElement();
            arrayList.add(sGDrawingElement);
        }
        return arrayList;
    }

    protected boolean moveElementsToFront(SGElementGroup sGElementGroup) {
        ArrayList arrayList = this.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!sGElementGroup.equals(arrayList.get(i))) continue;
            arrayList.remove(i);
            break;
        }
        arrayList.add(arrayList.size(), sGElementGroup);
        return true;
    }

    protected boolean moveElementsToBack(SGElementGroup sGElementGroup) {
        ArrayList arrayList = this.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!sGElementGroup.equals(arrayList.get(i))) continue;
            arrayList.remove(i);
            break;
        }
        arrayList.add(0, sGElementGroup);
        return true;
    }

    protected boolean removeElements(SGElementGroup sGElementGroup) {
        ArrayList arrayList = this.mDrawingElementGroupList;
        if (arrayList.size() == 1) {
            System.out.println("size of list is equal to 1!");
            return true;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!sGElementGroup.equals(arrayList.get(i))) continue;
            arrayList.remove(i);
            return true;
        }
        return false;
    }

    public void setVisible(boolean bl) {
        this.mVisibleFlag = bl;
    }

    public boolean isVisible() {
        return this.mVisibleFlag;
    }

    public void setSelected(boolean bl) {
        this.mSelectedFlag = bl;
    }

    public boolean isSelected() {
        return this.mSelectedFlag;
    }

    public boolean shiftColorList() {
        for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
            sGElementGroup.shiftColorList();
        }
        return true;
    }

    public boolean setMagnification(float f) {
        this.mMagnification = f;
        for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
            sGElementGroup.setMagnification(f);
        }
        return true;
    }

    public boolean zoom(int n, int n2, float f) {
        this.mMagnification = f;
        for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
            sGElementGroup.zoom(n, n2, f);
        }
        return true;
    }

    public abstract boolean addDrawingElementGroup(int var1);

    public abstract void paintGraphics2D(Graphics2D var1);

    public boolean contains(int n, int n2) {
        for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
            if (!sGElementGroup.isVisible() || !sGElementGroup.contains(n, n2)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean clickDrawingElements(MouseEvent var1);

    public abstract boolean addDrawingElementGroup(SGDrawingElement var1);

    public abstract boolean writePropertyOfData(Writer var1) throws IOException;

    public abstract boolean onDrawingElement(int var1, int var2);

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ElementGroupSetProperties)) {
            return false;
        }
        ElementGroupSetProperties elementGroupSetProperties = (ElementGroupSetProperties)sGProperties;
        this.setVisible(elementGroupSetProperties.visible);
        return true;
    }

    public SGProperties getProperties() {
        ElementGroupSetProperties elementGroupSetProperties = new ElementGroupSetProperties();
        if (!this.getProperties(elementGroupSetProperties)) {
            return null;
        }
        return elementGroupSetProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ElementGroupSetProperties)) {
            return false;
        }
        ElementGroupSetProperties elementGroupSetProperties = (ElementGroupSetProperties)sGProperties;
        elementGroupSetProperties.visible = this.isVisible();
        return true;
    }

    public SGProperties getWholeProperties() {
        WholeProperties wholeProperties = new WholeProperties();
        if (!this.getWholeProperties(wholeProperties)) {
            return null;
        }
        return wholeProperties;
    }

    public boolean getWholeProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof WholeProperties)) {
            return false;
        }
        WholeProperties wholeProperties = (WholeProperties)sGProperties;
        wholeProperties.ep = (ElementGroupSetProperties)this.getProperties();
        wholeProperties.ipList.clear();
        for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
            wholeProperties.ipList.add(sGElementGroup.getProperties());
        }
        return true;
    }

    public boolean setWholeProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof WholeProperties)) {
            return false;
        }
        WholeProperties wholeProperties = (WholeProperties)sGProperties;
        if (!this.setProperties(wholeProperties.ep)) {
            return false;
        }
        ArrayList arrayList = wholeProperties.ipList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGProperties sGProperties2 = (SGProperties)arrayList.get(i);
            SGElementGroup sGElementGroup = (SGElementGroup)this.mDrawingElementGroupList.get(i);
            if (sGElementGroup.setProperties(sGProperties2)) continue;
            return false;
        }
        return true;
    }

    public boolean readProperties(BufferedReader bufferedReader, SGProperties sGProperties) throws IOException {
        if (bufferedReader == null || sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ElementGroupSetProperties)) {
            return false;
        }
        ElementGroupSetProperties elementGroupSetProperties = (ElementGroupSetProperties)sGProperties;
        elementGroupSetProperties.visible = this.isVisible();
        return true;
    }

    public static class ElementGroupSetProperties
    extends SGProperties {
        boolean visible;

        public boolean equals(Object object) {
            if (!(object instanceof ElementGroupSetProperties)) {
                return false;
            }
            ElementGroupSetProperties elementGroupSetProperties = (ElementGroupSetProperties)object;
            return elementGroupSetProperties.visible == this.visible;
        }

        public String toString() {
            String string = new String("[");
            string = string + new String("visible=" + this.visible + ", ");
            string = string + new String("]");
            return string;
        }
    }

    public static class WholeProperties
    extends SGProperties {
        ElementGroupSetProperties ep;
        ArrayList ipList = new ArrayList();

        public boolean equals(Object object) {
            if (!(object instanceof WholeProperties)) {
                return false;
            }
            WholeProperties wholeProperties = (WholeProperties)object;
            if (!wholeProperties.ep.equals(this.ep)) {
                return false;
            }
            return wholeProperties.ipList.equals(this.ipList);
        }

        public String toString() {
            String string = new String("[");
            string = string + this.ep.toString();
            string = string + this.ipList.toString();
            string = string + new String("]");
            return string;
        }
    }
}

