/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;

public class SGWindowDialog
extends SGPropertyDialog {
    public static final String TITLE = "Window Dialog";
    private JButton mBackgroundColorButton;
    private JLabel mBackgroundColorLabel1;
    private JLabel mBottomLabel;
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JLabel mColorLabel;
    private JSeparator mColorSeparator;
    private JLabel mGridLabel;
    private JButton mGridLinesColorButton;
    private JLabel mGridLinesColorLabel;
    private SGSpinner mGridLinesIntervalSpinner;
    private SGSpinner mGridLinesWidthSpinner;
    private JSeparator mGridSeparator;
    private JLabel mHeightLabel;
    private SGSpinner mHeightSpinner;
    private JLabel mIntervalLabel;
    private JLabel mLeftSpaceLabel;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JLabel mSizeLabel;
    private JSeparator mSizeSeparator;
    private JLabel mWidthLabel;
    private SGSpinner mWidthSpinner;
    private JPanel mWindowPanel;

    public SGWindowDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mWindowPanel = new JPanel();
        this.mWidthLabel = new JLabel();
        this.mHeightLabel = new JLabel();
        this.mWidthSpinner = new SGSpinner();
        this.mHeightSpinner = new SGSpinner();
        this.mSizeLabel = new JLabel();
        this.mColorLabel = new JLabel();
        this.mIntervalLabel = new JLabel();
        this.mGridLinesIntervalSpinner = new SGSpinner();
        this.mBottomLabel = new JLabel();
        this.mGridLinesWidthSpinner = new SGSpinner();
        this.mGridLabel = new JLabel();
        this.mGridLinesColorButton = new JButton();
        this.mBackgroundColorLabel1 = new JLabel();
        this.mGridLinesColorLabel = new JLabel();
        this.mBackgroundColorButton = new JButton();
        this.mSizeSeparator = new JSeparator();
        this.mGridSeparator = new JSeparator();
        this.mColorSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SGWindowDialog.this.closeDialog(windowEvent);
            }
        });
        this.mWindowPanel.setLayout(new GridBagLayout());
        this.mWindowPanel.setBorder(new BevelBorder(0));
        this.mWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mWidthLabel.setText("Width");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mWindowPanel.add((Component)this.mWidthLabel, gridBagConstraints);
        this.mHeightLabel.setFont(new Font("Dialog", 0, 12));
        this.mHeightLabel.setText("Height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mWindowPanel.add((Component)this.mHeightLabel, gridBagConstraints);
        this.mWidthSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mWidthSpinner, gridBagConstraints);
        this.mHeightSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mHeightSpinner, gridBagConstraints);
        this.mSizeLabel.setFont(new Font("Dialog", 3, 12));
        this.mSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.mWindowPanel.add((Component)this.mSizeLabel, gridBagConstraints);
        this.mColorLabel.setFont(new Font("Dialog", 3, 12));
        this.mColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mWindowPanel.add((Component)this.mColorLabel, gridBagConstraints);
        this.mIntervalLabel.setFont(new Font("Dialog", 0, 12));
        this.mIntervalLabel.setText("Interval");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mWindowPanel.add((Component)this.mIntervalLabel, gridBagConstraints);
        this.mGridLinesIntervalSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mGridLinesIntervalSpinner, gridBagConstraints);
        this.mBottomLabel.setFont(new Font("Dialog", 0, 12));
        this.mBottomLabel.setText("Line width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mWindowPanel.add((Component)this.mBottomLabel, gridBagConstraints);
        this.mGridLinesWidthSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mGridLinesWidthSpinner, gridBagConstraints);
        this.mGridLabel.setFont(new Font("Dialog", 3, 12));
        this.mGridLabel.setText("Grid");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mWindowPanel.add((Component)this.mGridLabel, gridBagConstraints);
        this.mGridLinesColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mWindowPanel.add((Component)this.mGridLinesColorButton, gridBagConstraints);
        this.mBackgroundColorLabel1.setFont(new Font("Dialog", 0, 12));
        this.mBackgroundColorLabel1.setText("Background");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mWindowPanel.add((Component)this.mBackgroundColorLabel1, gridBagConstraints);
        this.mGridLinesColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mGridLinesColorLabel.setText("Grid");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mWindowPanel.add((Component)this.mGridLinesColorLabel, gridBagConstraints);
        this.mBackgroundColorButton.setPreferredSize(new Dimension(65, 20));
        this.mBackgroundColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGWindowDialog.this.mBackgroundColorButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mWindowPanel.add((Component)this.mBackgroundColorButton, gridBagConstraints);
        this.mSizeSeparator.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 35, 0, 0);
        this.mWindowPanel.add((Component)this.mSizeSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 35, 0, 0);
        this.mWindowPanel.add((Component)this.mGridSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 42, 0, 0);
        this.mWindowPanel.add((Component)this.mColorSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mWindowPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mWindowPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mWindowPanel, gridBagConstraints);
        this.mOKButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private void mBackgroundColorButtonActionPerformed(ActionEvent actionEvent) {
    }

    private void closeDialog(WindowEvent windowEvent) {
    }

    public static void main(String[] stringArray) {
        new SGWindowDialog((Frame)new JFrame(), true).show();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mWidthSpinner.setDigitForRoundingOut(-2);
        this.mWidthSpinner.initProperties(new SpinnerNumberModel(0.0, 0.0, 50.0, 1.0), " cm");
        this.mWidthSpinner.setMinimumFractionDigits(1);
        this.mWidthSpinner.setMaximumFractionDigits(1);
        this.mHeightSpinner.setDigitForRoundingOut(-2);
        this.mHeightSpinner.initProperties(new SpinnerNumberModel(0.0, 0.0, 50.0, 1.0), " cm");
        this.mHeightSpinner.setMinimumFractionDigits(1);
        this.mHeightSpinner.setMaximumFractionDigits(1);
        this.mGridLinesIntervalSpinner.initProperties(new SpinnerNumberModel(1.0, 0.5, 10.0, 0.5), " cm");
        this.mGridLinesWidthSpinner.initProperties(this.getLineWidthSpinnerNumberModel(), " pt");
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
        this.mBackgroundColorButton.addActionListener(this);
        this.mGridLinesColorButton.addActionListener(this);
        this.mFocusedColorSetButton = this.mBackgroundColorButton;
        return true;
    }

    public Number getWindowWidth() {
        return this.mWidthSpinner.getNumber();
    }

    public Number getWindowHeight() {
        return this.mHeightSpinner.getNumber();
    }

    public Color getWindowBackgroundColor() {
        return this.mBackgroundColorButton.getBackground();
    }

    public Color getWindowGridLinesColor() {
        return this.mGridLinesColorButton.getBackground();
    }

    public Number getWindowGridLinesInterval() {
        return this.mGridLinesIntervalSpinner.getNumber();
    }

    public Number getWindowGridLinesWidth() {
        return this.mGridLinesWidthSpinner.getNumber();
    }

    public boolean setWindowWidth(float f) {
        this.mWidthSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setWindowHeight(float f) {
        this.mHeightSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setWindowGridLinesInterval(float f) {
        this.mGridLinesIntervalSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setWindowGridLinesWidth(float f) {
        this.mGridLinesWidthSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setWindowBackgroundColor(Color color) {
        this.mBackgroundColorButton.setBackground(color);
        return true;
    }

    public boolean setWindowGridLinesColor(Color color) {
        this.mGridLinesColorButton.setBackground(color);
        return true;
    }

    public ArrayList getColorSelectionComponentList() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.mBackgroundColorButton);
        arrayList.add(this.mGridLinesColorButton);
        return arrayList;
    }

    public ArrayList getActiveComponentList() {
        ArrayList arrayList = this.getActiveComponentListFromSpinners();
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mWidthSpinner);
        arrayList.add(this.mHeightSpinner);
        arrayList.add(this.mGridLinesIntervalSpinner);
        arrayList.add(this.mGridLinesWidthSpinner);
        return arrayList;
    }

    public SGDrawingWindow.WindowProperties getProperties() {
        SGDrawingWindow.WindowProperties windowProperties = new SGDrawingWindow.WindowProperties();
        Number number = this.getWindowWidth();
        if (number == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        windowProperties.setPaperWidth(number.floatValue() / 0.035277776f);
        Number number2 = this.getWindowHeight();
        if (number2 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        windowProperties.setPaperHeight(number2.floatValue() / 0.035277776f);
        Number number3 = this.getWindowGridLinesInterval();
        if (number3 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        windowProperties.setGridInterval(number3.floatValue() / 0.035277776f);
        Number number4 = this.getWindowGridLinesWidth();
        if (number4 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        windowProperties.setGridLineWidth(number4.floatValue());
        Color color = this.getWindowGridLinesColor();
        windowProperties.setGridColor(color);
        Color color2 = this.getWindowBackgroundColor();
        windowProperties.setBackGroundColor(color2);
        return windowProperties;
    }
}

