/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGFigureDialog;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public abstract class SGFigure
extends JLayeredPane
implements ActionListener,
ComponentListener,
WindowListener,
SGIUndoable {
    protected int mID;
    protected SGDrawingWindow mWnd = null;
    protected ArrayList mDataList = new ArrayList();
    protected SGIGraphElement mGraphElement = null;
    protected SGILegendElement mLegendElement = null;
    protected SGIStringElement mStringElement = null;
    protected SGIAxisElement mAxisElement = null;
    protected float mGraphAreaX = 0.0f;
    protected float mGraphAreaY = 0.0f;
    protected float mGraphAreaWidth = 0.0f;
    protected float mGraphAreaHeight = 0.0f;
    protected float mMagnification = 1.0f;
    protected JPopupMenu mPopupMenu = new JPopupMenu();
    protected JDialog mDialog = null;
    protected SGIFigureElement mPressedElement = null;
    protected Point mPressedPoint = new Point();
    protected Rectangle2D mTempFigureRect = new Rectangle2D.Float();
    protected Rectangle2D mViewBounds = null;
    protected Color mBackgroundColor = new Color(255, 210, 210);
    protected Rectangle2D mRectangleOnDragging = new Rectangle2D.Float();
    public static boolean mDrawRectangleOnDraggingFlag = false;
    public static boolean mDraggingFlag = false;
    protected int mMouseLocation = 0;
    protected float mMinWidth = 50.0f;
    protected float mMinHeight = 50.0f;
    private static boolean mBoundingBoxVisibleFlag = false;
    protected boolean mUpperFitFlag = false;
    protected boolean mLowerFitFlag = false;
    protected boolean mLeftFitFlag = false;
    protected boolean mRightFitFlag = false;
    protected SGProperties mTemporaryProperties = null;
    protected ArrayList mTemporaryDataList = null;
    private float mSpaceAxisLineAndNumber = 5.6692915f;
    private float mSpaceNumberAndTitle = 5.6692915f;
    private boolean mTransparentFlag = false;
    public static final int LAYER_GRAPH = 10;
    public static final int LAYER_AXIS = 20;
    public static final int LAYER_LEGEND = 30;
    public static final int LAYER_STRING = 40;
    protected final int OTHER = 0;
    protected final int NORTH = 1;
    protected final int SOUTH = 2;
    protected final int WEST = 3;
    protected final int EAST = 4;
    protected final int NORTH_WEST = 5;
    protected final int NORTH_EAST = 6;
    protected final int SOUTH_WEST = 7;
    protected final int SOUTH_EAST = 8;
    public static final int NOTIFY_CHANGE = 0;
    public static final int UPDATE_HISTORY = 1;
    public static final int SET_PROPERTY_OF_SELECTED_DATA = 2;
    protected final String SHOW_FRAME = "show/hide frame lines";
    protected final String ADD_STRING = "add a string";
    protected final String REMOVE_FIGURE = "Remove Selected Figures";
    public final String ERRMSG_FAILED_TO_CREATE_DRAWING_ELEMENTS = "\u63cf\u753b\u8981\u7d20\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
    protected final String DRAW_DRAGGING_RECTANGLE = "Draw Dragging Rectangle";
    protected final String SAVE_PROPERTY = "Save the Property";
    private ArrayList mFigurePropertyHistoryList = new ArrayList();
    private int mFigureStateCounter = 0;
    protected ArrayList mUndoableObjectHistoryList = new ArrayList();
    private int mCurrentStateCounter = 0;
    public static final String PF_FIGURE_TITLE = "[Figure]";
    public static final String PF_CLASS_NAME = "Class Name";
    public static final String PF_FIGURE_ID = "ID";
    public static final String PF_FIGURE_X_IN_CLIENT = "X";
    public static final String PF_FIGURE_Y_IN_CLIENT = "Y";
    public static final String PF_WIDTH = "Width";
    public static final String PF_HEIGHT = "Height";
    public static final String PF_SPACE_AXIS_LINE_AND_NUMBER = "Space between Axis Line and Numbers";
    public static final String PF_SPACE_NUMBER_AND_TITLE = "Space between Numbers and Title";
    public static final String PF_BACKGROUND_COLOR = "Background Color";
    public static final String PF_TRANSPARENCY = "Transparency";
    public static final String PF_LEGEND_VISIBLE = "Legend Visible";
    public static final int MINIMAL_LENGTH_ORDER = -1;

    public SGFigure() {
        this.create();
    }

    public SGFigure(SGDrawingWindow sGDrawingWindow) {
        this.setWindow(sGDrawingWindow);
        this.create();
    }

    public String toString() {
        return new String("SGFigure:" + this.getID());
    }

    private boolean create() {
        this.createDialog();
        this.createPopupMenu();
        this.setBackgroundColor(SGDefaultValues.FIGURE_BACKGROUND_COLOR);
        this.setVisible(true);
        this.setOpaque(false);
        return true;
    }

    public void repaint() {
        super.repaint();
        this.mWnd.repaint();
    }

    protected boolean isFocusedFigure() {
        ArrayList arrayList = this.mWnd.mFocusedFigureList;
        boolean bl = arrayList.contains(this);
        return bl;
    }

    public int getID() {
        return this.mID;
    }

    public boolean setID(int n) {
        this.mID = n;
        return true;
    }

    public boolean setBackgroundColor(Color color) {
        this.mBackgroundColor = color;
        return true;
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public boolean isTransparent() {
        return this.mTransparentFlag;
    }

    public SGDrawingWindow getWindow() {
        return this.mWnd;
    }

    public boolean setSpaceAxisLineAndNumber(float f) {
        this.mSpaceAxisLineAndNumber = f;
        this.mAxisElement.setSpaceAxisLineAndNumber(f);
        return true;
    }

    public boolean setSpaceNumberAndTitle(float f) {
        this.mSpaceNumberAndTitle = f;
        this.mAxisElement.setSpaceNumberAndTitle(f);
        return true;
    }

    public boolean setLegendVisible(boolean bl) {
        this.mLegendElement.setLegendVisible(bl);
        return true;
    }

    public boolean setTransparent(boolean bl) {
        this.mTransparentFlag = bl;
        return true;
    }

    public boolean setWindow(SGDrawingWindow sGDrawingWindow) {
        this.mWnd = sGDrawingWindow;
        return true;
    }

    public boolean setGraphElement(SGIGraphElement sGIGraphElement) {
        this.mGraphElement = sGIGraphElement;
        return true;
    }

    public boolean setLegendElement(SGILegendElement sGILegendElement) {
        this.mLegendElement = sGILegendElement;
        return true;
    }

    public boolean setStringElement(SGIStringElement sGIStringElement) {
        this.mStringElement = sGIStringElement;
        return true;
    }

    public boolean setAxisElement(SGIAxisElement sGIAxisElement) {
        this.mAxisElement = sGIAxisElement;
        return true;
    }

    public SGIGraphElement getGraphElement() {
        return this.mGraphElement;
    }

    public SGIAxisElement getAxisElement() {
        return this.mAxisElement;
    }

    public SGILegendElement getLegendElement() {
        return this.mLegendElement;
    }

    public SGIStringElement getStringElement() {
        return this.mStringElement;
    }

    public SGIFigureElement[] getIFigureElementArray() {
        SGIFigureElement[] sGIFigureElementArray = new SGIFigureElement[]{this.mAxisElement, this.mGraphElement, this.mLegendElement, this.mStringElement};
        return sGIFigureElementArray;
    }

    protected Rectangle2D getViewBounds() {
        return this.mViewBounds;
    }

    public boolean isGraphAreaContains(Point2D point2D) {
        Rectangle2D rectangle2D = this.getGraphAreaRect();
        return rectangle2D.contains(point2D);
    }

    public Rectangle2D getGraphAreaRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getGraphAreaX(), this.getGraphAreaY(), this.getGraphAreaWidth(), this.getGraphAreaHeight());
        return float_;
    }

    public float getGraphAreaX() {
        Rectangle2D rectangle2D = this.mWnd.getClientRect();
        return (float)rectangle2D.getX() + this.mMagnification * this.mGraphAreaX;
    }

    public float getGraphAreaY() {
        Rectangle2D rectangle2D = this.mWnd.getClientRect();
        return (float)rectangle2D.getY() + this.mMagnification * this.mGraphAreaY;
    }

    public float getGraphAreaWidth() {
        return this.mMagnification * this.mGraphAreaWidth;
    }

    public float getGraphAreaHeight() {
        return this.mMagnification * this.mGraphAreaHeight;
    }

    public boolean setGraphAreaLocation(float f, float f2) {
        this.setGraphAreaLocation2(f, f2);
        this.setGraphAreaRectToFigureElement();
        return true;
    }

    private boolean setGraphAreaLocation2(float f, float f2) {
        Rectangle2D rectangle2D = this.mWnd.getClientRect();
        this.mGraphAreaX = (f - (float)rectangle2D.getX()) / this.mMagnification;
        this.mGraphAreaY = (f2 - (float)rectangle2D.getY()) / this.mMagnification;
        return true;
    }

    protected boolean setGraphAreaLocationRoundingOut(float f, float f2) {
        Rectangle2D rectangle2D = this.mWnd.getClientRect();
        float f3 = (f - (float)rectangle2D.getX()) * 0.035277776f / this.mMagnification;
        float f4 = (f2 - (float)rectangle2D.getY()) * 0.035277776f / this.mMagnification;
        float f5 = (float)SGUtilityNumber.roundOutNumber(f3, -2);
        float f6 = (float)SGUtilityNumber.roundOutNumber(f4, -2);
        float f7 = f5 / 0.035277776f;
        float f8 = f6 / 0.035277776f;
        this.mGraphAreaX = f7;
        this.mGraphAreaY = f8;
        return true;
    }

    public boolean setGraphAreaSize(float f, float f2) {
        this.setGraphAreaSize2(f, f2);
        this.setGraphAreaRectToFigureElement();
        return true;
    }

    private boolean setGraphAreaSize2(float f, float f2) {
        this.mGraphAreaWidth = f / this.mMagnification;
        this.mGraphAreaHeight = f2 / this.mMagnification;
        return true;
    }

    protected boolean setGraphAreaSizeRoundingOut(float f, float f2) {
        float f3 = f * 0.035277776f / this.mMagnification;
        float f4 = f2 * 0.035277776f / this.mMagnification;
        float f5 = (float)SGUtilityNumber.roundOutNumber(f3, -2);
        float f6 = (float)SGUtilityNumber.roundOutNumber(f4, -2);
        float f7 = f5 / 0.035277776f;
        float f8 = f6 / 0.035277776f;
        this.mGraphAreaWidth = f7;
        this.mGraphAreaHeight = f8;
        return true;
    }

    public boolean setGraphAreaRect(float f, float f2, float f3, float f4) {
        this.setGraphAreaLocation2(f, f2);
        this.setGraphAreaSize2(f3, f4);
        this.setGraphAreaRectToFigureElement();
        return true;
    }

    protected boolean setGraphAreaRectToFigureElement() {
        Rectangle2D rectangle2D = this.mWnd.getClientRectZoomed();
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i] == null) continue;
            sGIFigureElementArray[i].setGraphAreaRect(this.getGraphAreaX(), this.getGraphAreaY(), this.getGraphAreaWidth(), this.getGraphAreaHeight());
        }
        return true;
    }

    public boolean addData(SGData sGData) {
        this.mDataList.add(sGData);
        this.mAxisElement.addData(sGData);
        this.mGraphElement.addData(sGData);
        this.mLegendElement.addData(sGData);
        this.mStringElement.addData(sGData);
        return true;
    }

    protected boolean setViewBounds() {
        Rectangle2D rectangle2D = this.mWnd.getViewportBounds();
        this.setViewBounds(rectangle2D);
        return true;
    }

    protected boolean setViewBounds(Rectangle2D rectangle2D) {
        this.mViewBounds = rectangle2D;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setViewBounds(rectangle2D);
        }
        return true;
    }

    public boolean setSize(SGTuple2f sGTuple2f) {
        this.setSize((int)sGTuple2f.x, (int)sGTuple2f.y);
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setISize(new SGTuple2f(sGTuple2f));
        }
        return true;
    }

    public boolean resize(float f, float f2) {
        this.mGraphAreaX *= f;
        this.mGraphAreaY *= f2;
        this.mGraphAreaWidth *= f;
        this.mGraphAreaHeight *= f2;
        this.setGraphAreaRectToFigureElement();
        this.setViewBounds();
        return true;
    }

    public boolean zoom(float f) {
        this.mMagnification = f;
        int n = this.getWidth();
        int n2 = this.getHeight();
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].zoom(0, 0, n, n2, f);
        }
        if (!this.setGraphAreaRectToFigureElement()) {
            return false;
        }
        this.repaint();
        return true;
    }

    private boolean setFitFlag() {
        return true;
    }

    protected boolean move(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.setMouseLocation(n, n2);
        this.changeCursor();
        this.onDrawingElement(n, n2);
        return true;
    }

    protected boolean onToggleSelected(MouseEvent mouseEvent) {
        boolean bl = this.mWnd.mAddStringButton.isSelected();
        if (bl) {
            System.out.println("addString");
            this.mStringElement.addString(mouseEvent.getX(), mouseEvent.getY());
            this.mWnd.setDefaultCursor();
            this.mWnd.setInsertToggleButtonsSelected(false);
            return true;
        }
        boolean bl2 = this.mWnd.mAddTimingElementButton.isSelected();
        if (bl2) {
            System.out.println("addTimingLine");
            this.mAxisElement.addTimingLine(mouseEvent.getX(), mouseEvent.getY());
            this.mWnd.setDefaultCursor();
            this.mWnd.setInsertToggleButtonsSelected(false);
            return true;
        }
        boolean bl3 = this.mWnd.mAddSignificantSymbolButton.isSelected();
        if (bl3) {
            System.out.println("addSignificant");
            this.mGraphElement.addSignificantDifferenceSymbol(mouseEvent.getX(), mouseEvent.getY());
            this.mWnd.setDefaultCursor();
            this.mWnd.setInsertToggleButtonsSelected(false);
            return true;
        }
        return true;
    }

    protected boolean click(MouseEvent mouseEvent) {
        boolean bl = this.onFigureElementClicked(mouseEvent);
        if (bl) {
            this.afterClicked(mouseEvent);
            return true;
        }
        if (this.isGraphAreaContains(mouseEvent.getPoint())) {
            this.afterClicked(mouseEvent);
            if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                this.mPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                this.getDialog().show();
            }
            return true;
        }
        return false;
    }

    private boolean afterClicked(MouseEvent mouseEvent) {
        this.mWnd.mLayeredPane.moveToFront(this);
        this.repaint();
        return true;
    }

    private boolean onFigureElementClicked(MouseEvent mouseEvent) {
        boolean bl = this.mStringElement.onMouseClicked(mouseEvent);
        if (bl) {
            return true;
        }
        bl = this.mLegendElement.onMouseClicked(mouseEvent);
        if (bl) {
            return true;
        }
        bl = this.mAxisElement.onMouseClicked(mouseEvent);
        if (bl) {
            return true;
        }
        bl = this.mGraphElement.onMouseClicked(mouseEvent);
        return bl;
    }

    protected boolean press(MouseEvent mouseEvent) {
        boolean bl = this.onFigureElementPressed(mouseEvent);
        if (bl) {
            this.afterPressed(mouseEvent);
            this.setFocusedFigureList(mouseEvent);
            return true;
        }
        bl = false;
        if (this.isGraphAreaContains(mouseEvent.getPoint())) {
            bl = true;
        }
        if (this.mMouseLocation != 0) {
            bl = true;
        }
        if (bl) {
            this.afterPressed(mouseEvent);
            this.setFocusedFigureList(mouseEvent);
            return true;
        }
        return false;
    }

    private boolean afterPressed(MouseEvent mouseEvent) {
        this.mWnd.setDraggingRectOfFocusedFigures();
        mDraggingFlag = true;
        if (this.mWnd.getCursor().equals(Cursor.getDefaultCursor())) {
            this.changeCursor();
            if (this.mMouseLocation == 0) {
                this.mWnd.setCursor(new Cursor(13));
            }
        }
        this.mWnd.mLayeredPane.moveToFront(this);
        this.mPressedPoint.setLocation(mouseEvent.getPoint());
        this.updateFigureRect();
        return true;
    }

    protected boolean setFocusedFigureList(MouseEvent mouseEvent) {
        ArrayList arrayList = this.mWnd.mFocusedFigureList;
        if ((mouseEvent.getModifiers() & 2) == 0 && (mouseEvent.getModifiers() & 1) == 0) {
            if (!arrayList.contains(this)) {
                this.mWnd.clearFocusedFigures();
                arrayList.add(this);
            }
        } else if (arrayList.contains(this)) {
            if (this.mMouseLocation != 5 && this.mMouseLocation != 6 && this.mMouseLocation != 8 && this.mMouseLocation != 7 && this.mPressedElement == null) {
                arrayList.remove(this);
            }
        } else {
            arrayList.add(this);
        }
        return true;
    }

    protected boolean updateFigureRect() {
        this.mTempFigureRect.setRect(this.getGraphAreaRect());
        return true;
    }

    protected boolean setDraggingRect() {
        this.mRectangleOnDragging.setRect(this.getGraphAreaX(), this.getGraphAreaY(), this.getGraphAreaWidth(), this.getGraphAreaHeight());
        return true;
    }

    private boolean onFigureElementPressed(MouseEvent mouseEvent) {
        boolean bl = this.mStringElement.onMousePressed(mouseEvent);
        if (bl) {
            this.mPressedElement = this.mStringElement;
            return true;
        }
        bl = this.mLegendElement.onMousePressed(mouseEvent);
        if (bl) {
            this.mPressedElement = this.mLegendElement;
            return true;
        }
        bl = this.mAxisElement.onMousePressed(mouseEvent);
        if (bl) {
            this.mPressedElement = this.mAxisElement;
            return true;
        }
        bl = this.mGraphElement.onMousePressed(mouseEvent);
        if (bl) {
            this.mPressedElement = this.mGraphElement;
            return true;
        }
        return false;
    }

    protected boolean drag(MouseEvent mouseEvent) {
        boolean bl;
        this.mWnd.notifyPosition(this, mouseEvent.getX(), mouseEvent.getY());
        if (this.mMouseLocation == 0) {
            boolean bl2 = this.dragOtherPoint(mouseEvent);
            return bl2;
        }
        Rectangle2D rectangle2D = this.getRectangleOnDragging();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        this.updateFigureRect();
        Rectangle2D rectangle2D2 = this.mWnd.getClientRectZoomed();
        int n = mouseEvent.getX() - this.mPressedPoint.x;
        int n2 = mouseEvent.getY() - this.mPressedPoint.y;
        float f5 = f3;
        float f6 = f4;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = f;
        float f10 = f2;
        float f11 = f3;
        float f12 = f4;
        if (this.mMouseLocation == 1) {
            this.mPressedPoint.setLocation(this.mPressedPoint.getX(), this.mPressedPoint.getY() + (double)n2);
            f8 = f6 - (float)n2;
            f10 = f2 + f6 - f8;
            f12 = f8;
        } else if (this.mMouseLocation == 2) {
            this.mPressedPoint.setLocation(this.mPressedPoint.getX(), this.mPressedPoint.getY() + (double)n2);
            f12 = f8 = f6 + (float)n2;
        } else if (this.mMouseLocation == 3) {
            this.mPressedPoint.setLocation(this.mPressedPoint.getX() + (double)n, this.mPressedPoint.getY() + (double)n2);
            f7 = f5 - (float)n;
            f9 = f + f5 - f7;
            f11 = f7;
        } else if (this.mMouseLocation == 4) {
            this.mPressedPoint.setLocation(this.mPressedPoint.getX() + (double)n, this.mPressedPoint.getY());
            f11 = f7 = f5 + (float)n;
        } else if (this.mMouseLocation == 5) {
            this.mPressedPoint.setLocation(this.mPressedPoint.getX() + (double)n, this.mPressedPoint.getY() + (double)n2);
            f7 = f5 - (float)n;
            f8 = (mouseEvent.getModifiers() & 1) != 0 ? f7 * (f6 / f5) : f6 - (float)n2;
            f9 = f + f5 - f7;
            f10 = f2 + f6 - f8;
            f11 = f7;
            f12 = f8;
        } else if (this.mMouseLocation == 6 && (mouseEvent.getModifiers() & 1) == 0) {
            this.mPressedPoint.setLocation(this.mPressedPoint.getX() + (double)n, this.mPressedPoint.getY() + (double)n2);
            f7 = f5 + (float)n;
            f8 = f6 - (float)n2;
            f10 = f2 + f6 - f8;
            f11 = f7;
            f12 = f8;
        } else if (this.mMouseLocation == 6 && (mouseEvent.getModifiers() & 1) != 0) {
            this.mPressedPoint.setLocation(this.mPressedPoint.getX(), this.mPressedPoint.getY() + (double)n2);
            f8 = f6 - (float)n2;
            f7 = f8 * (f5 / f6);
            f10 = f2 + f6 - f8;
            f11 = f7;
            f12 = f8;
        } else if (this.mMouseLocation == 7 && (mouseEvent.getModifiers() & 1) == 0) {
            this.mPressedPoint.setLocation(this.mPressedPoint.getX() + (double)n, this.mPressedPoint.getY() + (double)n2);
            f7 = f5 - (float)n;
            f8 = f6 + (float)n2;
            f9 = f + f5 - f7;
            f11 = f7;
            f12 = f8;
        } else if (this.mMouseLocation == 7 && (mouseEvent.getModifiers() & 1) != 0) {
            this.mPressedPoint.setLocation(this.mPressedPoint.getX() + (double)n, this.mPressedPoint.getY() + (double)n2);
            f7 = f5 - (float)n;
            f8 = f7 * (f6 / f5);
            f9 = f + f5 - f7;
            f11 = f7;
            f12 = f8;
        } else if (this.mMouseLocation == 8 && (mouseEvent.getModifiers() & 1) == 0) {
            this.mPressedPoint.setLocation(this.mPressedPoint.getX() + (double)n, this.mPressedPoint.getY() + (double)n2);
            f7 = f5 + (float)n;
            f8 = f6 + (float)n2;
            f11 = f7;
            f12 = f8;
        } else if (this.mMouseLocation == 8 && (mouseEvent.getModifiers() & 1) != 0) {
            this.mPressedPoint.setLocation(this.mPressedPoint.getX() + (double)n, this.mPressedPoint.getY());
            f7 = f5 + (float)n;
            f8 = f7 * (f6 / f5);
            f11 = f7;
            f12 = f8;
        }
        if (f11 < this.mMinWidth || f12 < this.mMinHeight) {
            return true;
        }
        this.mRectangleOnDragging.setRect(f9, f10, f11, f12);
        if (!mDrawRectangleOnDraggingFlag && !(bl = this.setGraphAreaRectOnDragging())) {
            this.mRectangleOnDragging.setRect(f, f2, f3, f4);
        }
        this.repaint();
        return true;
    }

    private boolean dragOtherPoint(MouseEvent mouseEvent) {
        if (this.mPressedElement != null) {
            boolean bl = this.mPressedElement.onMouseDragged(mouseEvent);
            this.setCursorToWindow(this.mPressedElement);
            return bl;
        }
        if (this.isGraphAreaContains(this.mPressedPoint)) {
            int n = mouseEvent.getX() - this.mPressedPoint.x;
            int n2 = mouseEvent.getY() - this.mPressedPoint.y;
            ArrayList arrayList = this.mWnd.mFocusedFigureList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                sGFigure.getRectangleOnDragging().setRect(sGFigure.getGraphAreaX() + (float)n, sGFigure.getGraphAreaY() + (float)n2, sGFigure.getGraphAreaWidth(), sGFigure.getGraphAreaHeight());
                if (mDrawRectangleOnDraggingFlag) continue;
                sGFigure.mPressedPoint.setLocation(sGFigure.mPressedPoint.x + n, sGFigure.mPressedPoint.y + n2);
                sGFigure.setGraphAreaRectOnDragging();
            }
            this.repaint();
        }
        return true;
    }

    private boolean setGraphAreaRectOnDragging() {
        Rectangle2D rectangle2D = this.getRectangleOnDragging();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        this.setGraphAreaRect(f, f2, f3, f4);
        return true;
    }

    protected boolean release(MouseEvent mouseEvent) {
        this.mWnd.setDefaultCursor();
        if (mDrawRectangleOnDraggingFlag && this.mPressedElement == null) {
            this.setGraphAreaRectOnDragging();
        }
        if (this.mPressedElement != null) {
            this.mPressedElement.onMouseReleased(mouseEvent);
        }
        this.mPressedElement = null;
        mDraggingFlag = false;
        if (!this.isFigureMoved()) {
            this.repaint();
            return true;
        }
        for (int i = 0; i < this.mWnd.mFocusedFigureList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)this.mWnd.mFocusedFigureList.get(i);
            sGFigure.drawbackFigure();
        }
        this.mStringElement.chkBoundsVisible();
        this.mLegendElement.chkBoundsVisible();
        this.repaint();
        return true;
    }

    protected boolean isFigureMoved() {
        boolean bl = !this.mTempFigureRect.equals(this.getGraphAreaRect());
        return bl;
    }

    protected boolean drawbackFigure() {
        Rectangle2D rectangle2D = this.mWnd.getClientRect();
        Rectangle2D rectangle2D2 = this.getBoundingBox();
        Rectangle2D rectangle2D3 = this.mWnd.getPaperRect();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect(rectangle2D2);
        if (rectangle2D2.getX() < rectangle2D.getX()) {
            ((Rectangle2D)float_).setRect(0.0, ((RectangularShape)float_).getY(), ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (rectangle2D2.getY() < rectangle2D.getY()) {
            ((Rectangle2D)float_).setRect(((RectangularShape)float_).getX(), 0.0, ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (rectangle2D2.getX() + rectangle2D2.getWidth() > rectangle2D3.getX() + rectangle2D3.getWidth()) {
            ((Rectangle2D)float_).setRect(rectangle2D3.getX() + rectangle2D3.getWidth() - rectangle2D2.getWidth(), ((RectangularShape)float_).getY(), ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (rectangle2D2.getY() + rectangle2D2.getHeight() > rectangle2D3.getY() + rectangle2D3.getHeight()) {
            ((Rectangle2D)float_).setRect(((RectangularShape)float_).getX(), rectangle2D3.getY() + rectangle2D3.getHeight() - rectangle2D2.getHeight(), ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (!this.setBoundingBox(float_)) {
            return false;
        }
        this.setDraggingRect();
        return true;
    }

    public boolean clearSelectedElements() {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].clearSelectedElements();
        }
        return true;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    protected boolean onKeyPressed(KeyEvent keyEvent) {
        this.mAxisElement.onKeyPressed(keyEvent);
        this.mLegendElement.onKeyPressed(keyEvent);
        this.mGraphElement.onKeyPressed(keyEvent);
        this.mStringElement.onKeyPressed(keyEvent);
        return true;
    }

    protected boolean onKeyReleased(KeyEvent keyEvent) {
        this.mAxisElement.onKeyReleased(keyEvent);
        this.mLegendElement.onKeyReleased(keyEvent);
        this.mGraphElement.onKeyReleased(keyEvent);
        this.mStringElement.onKeyReleased(keyEvent);
        return true;
    }

    protected boolean onKeyTyped(KeyEvent keyEvent) {
        this.mAxisElement.onKeyTyped(keyEvent);
        this.mLegendElement.onKeyTyped(keyEvent);
        this.mGraphElement.onKeyTyped(keyEvent);
        this.mStringElement.onKeyTyped(keyEvent);
        return true;
    }

    private boolean typed(KeyEvent keyEvent) {
        return true;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object.equals(this.mDialog)) {
            this.onCanceled();
        }
    }

    public boolean undo() {
        --this.mFigureStateCounter;
        FigureProperties figureProperties = (FigureProperties)this.mFigurePropertyHistoryList.get(this.mFigureStateCounter);
        this.setProperties(figureProperties);
        this.setGraphAreaRectToFigureElement();
        this.repaint();
        return true;
    }

    public boolean redo() {
        ++this.mFigureStateCounter;
        FigureProperties figureProperties = (FigureProperties)this.mFigurePropertyHistoryList.get(this.mFigureStateCounter);
        this.setProperties(figureProperties);
        this.setGraphAreaRectToFigureElement();
        this.repaint();
        return true;
    }

    protected Rectangle2D getRectangleOnDragging() {
        return this.mRectangleOnDragging;
    }

    private boolean setMouseLocation(int n, int n2) {
        double d = 1.5 * (double)this.mWnd.mAnchorSize;
        Rectangle2D rectangle2D = this.getGraphAreaRect();
        if (Math.abs((double)n - rectangle2D.getX()) < d && Math.abs((double)n2 - rectangle2D.getY()) < d) {
            this.mMouseLocation = 5;
            return true;
        }
        if (Math.abs((double)n - (rectangle2D.getX() + rectangle2D.getWidth())) < d && Math.abs((double)n2 - (rectangle2D.getY() + rectangle2D.getHeight())) < d) {
            this.mMouseLocation = 8;
            return true;
        }
        if (Math.abs((double)n - (rectangle2D.getX() + rectangle2D.getWidth())) < d && Math.abs((double)n2 - rectangle2D.getY()) < d) {
            this.mMouseLocation = 6;
            return true;
        }
        if (Math.abs((double)n - rectangle2D.getX()) < d && Math.abs((double)n2 - (rectangle2D.getY() + rectangle2D.getHeight())) < d) {
            this.mMouseLocation = 7;
            return true;
        }
        if (Math.abs((double)n - rectangle2D.getX()) < d && Math.abs((double)n2 - (rectangle2D.getY() + rectangle2D.getHeight() / 2.0)) < d) {
            this.mMouseLocation = 3;
            return true;
        }
        if (Math.abs((double)n - (rectangle2D.getX() + rectangle2D.getWidth())) < d && Math.abs((double)n2 - (rectangle2D.getY() + rectangle2D.getHeight() / 2.0)) < d) {
            this.mMouseLocation = 4;
            return true;
        }
        if (Math.abs((double)n2 - rectangle2D.getY()) < d && Math.abs((double)n - (rectangle2D.getX() + rectangle2D.getWidth() / 2.0)) < d) {
            this.mMouseLocation = 1;
            return true;
        }
        if (Math.abs((double)n2 - (rectangle2D.getY() + rectangle2D.getHeight())) < d && Math.abs((double)n - (rectangle2D.getX() + rectangle2D.getWidth() / 2.0)) < d) {
            this.mMouseLocation = 2;
            return true;
        }
        this.mMouseLocation = 0;
        return true;
    }

    private boolean changeCursor() {
        Cursor cursor = null;
        switch (this.mMouseLocation) {
            case 3: {
                cursor = new Cursor(10);
                break;
            }
            case 4: {
                cursor = new Cursor(11);
                break;
            }
            case 1: {
                cursor = new Cursor(8);
                break;
            }
            case 2: {
                cursor = new Cursor(9);
                break;
            }
            case 5: {
                cursor = new Cursor(6);
                break;
            }
            case 8: {
                cursor = new Cursor(5);
                break;
            }
            case 6: {
                cursor = new Cursor(7);
                break;
            }
            case 7: {
                cursor = new Cursor(4);
                break;
            }
            default: {
                cursor = Cursor.getDefaultCursor();
            }
        }
        if (this.mWnd.mFocusedFigureList.contains(this)) {
            this.mWnd.setCursor(cursor);
        }
        return true;
    }

    private boolean onDrawingElement(int n, int n2) {
        boolean bl = this.mStringElement.onDrawingElement(n, n2);
        if (bl) {
            return true;
        }
        bl = this.mLegendElement.onDrawingElement(n, n2);
        if (bl) {
            return true;
        }
        bl = this.mAxisElement.onDrawingElement(n, n2);
        if (bl) {
            return true;
        }
        bl = this.mGraphElement.onDrawingElement(n, n2);
        if (bl) {
            this.setCursorToWindow(this.mGraphElement);
            return true;
        }
        return false;
    }

    protected boolean setCursorToWindow(SGIFigureElement sGIFigureElement) {
        Cursor cursor = sGIFigureElement.getFigureElementCursor();
        if (cursor != null) {
            this.mWnd.setCursor(cursor);
            this.repaint();
        }
        return true;
    }

    private boolean createPopupMenu() {
        JMenuItem jMenuItem;
        int n;
        this.mPopupMenu.setBounds(0, 0, 100, 100);
        String[] stringArray = new String[]{"Draw Dragging Rectangle", "Save the Property", "Remove Selected Figures"};
        String[] stringArray2 = new String[]{"show/hide frame lines"};
        for (n = 0; n < stringArray.length; ++n) {
            jMenuItem = new JMenuItem(stringArray[n]);
            jMenuItem.addActionListener(this);
            this.mPopupMenu.add(jMenuItem);
        }
        this.mPopupMenu.addSeparator();
        for (n = 0; n < stringArray2.length; ++n) {
            jMenuItem = new JMenuItem(stringArray2[n]);
            jMenuItem.addActionListener(this);
            this.mPopupMenu.add(jMenuItem);
        }
        return true;
    }

    private JDialog getDialog() {
        SGFigureDialog sGFigureDialog = (SGFigureDialog)this.mDialog;
        sGFigureDialog.setLocation(this.mWnd.getLocation());
        sGFigureDialog.setColorButtonBorder(true);
        this.setDialogProperty();
        this.mTemporaryProperties = this.getProperties();
        return this.mDialog;
    }

    private boolean setDialogProperty() {
        SGFigureDialog sGFigureDialog = (SGFigureDialog)this.mDialog;
        sGFigureDialog.setFigureX(this.mGraphAreaX * 0.035277776f);
        sGFigureDialog.setFigureY(this.mGraphAreaY * 0.035277776f);
        sGFigureDialog.setFigureWidth(this.mGraphAreaWidth * 0.035277776f);
        sGFigureDialog.setFigureHeight(this.mGraphAreaHeight * 0.035277776f);
        sGFigureDialog.setFigureBackgroundColor(this.mBackgroundColor);
        sGFigureDialog.setFigureTransparentFlag(this.mTransparentFlag);
        sGFigureDialog.setFigureSpaceLineAndNumber(this.mSpaceAxisLineAndNumber * 0.035277776f);
        sGFigureDialog.setFigureSpaceNumberAndTitle(this.mSpaceNumberAndTitle * 0.035277776f);
        String string = "Figure Dialog";
        string = string + ":" + new Integer(this.getID()).toString();
        this.mDialog.setTitle(string);
        sGFigureDialog.setFigureLegendVisible(this.mLegendElement.isLegendVisible());
        return true;
    }

    private boolean createDialog() {
        SGFigureDialog sGFigureDialog = new SGFigureDialog((Frame)this.mWnd, true);
        sGFigureDialog.setListener(this);
        this.mDialog = sGFigureDialog;
        return true;
    }

    private boolean setPropertyWithDialog() {
        FigureProperties figureProperties = this.getPropertyFromDialog();
        this.setProperties(figureProperties);
        this.setGraphAreaRectToFigureElement();
        this.repaint();
        return true;
    }

    public SGProperties getProperties() {
        FigureProperties figureProperties = new FigureProperties();
        figureProperties.x = this.mGraphAreaX;
        figureProperties.y = this.mGraphAreaY;
        figureProperties.width = this.mGraphAreaWidth;
        figureProperties.height = this.mGraphAreaHeight;
        figureProperties.spaceLineAndNumber = this.mSpaceAxisLineAndNumber;
        figureProperties.spaceNumberAndTitle = this.mSpaceNumberAndTitle;
        figureProperties.legendVisible = this.mLegendElement.isLegendVisible();
        figureProperties.bgColor = this.mBackgroundColor;
        figureProperties.transparent = this.mTransparentFlag;
        return figureProperties;
    }

    private FigureProperties getPropertyFromDialog() {
        SGFigureDialog sGFigureDialog = (SGFigureDialog)this.mDialog;
        FigureProperties figureProperties = sGFigureDialog.getProperties();
        return figureProperties;
    }

    private boolean setBackgroundColorWidhDialog() {
        SGFigureDialog sGFigureDialog = (SGFigureDialog)this.mDialog;
        this.mBackgroundColor = sGFigureDialog.getFigureBackgroundColor();
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (string.equals("show/hide frame lines")) {
            mBoundingBoxVisibleFlag = !mBoundingBoxVisibleFlag;
        } else if (string.equals("Draw Dragging Rectangle")) {
            mDrawRectangleOnDraggingFlag = !mDrawRectangleOnDraggingFlag;
        } else if (string.equals("Remove Selected Figures")) {
            this.mWnd.hideSelectedFigures();
        } else if (string.equals("Save the Property")) {
            this.mWnd.createPropertyFileForFocusedFigures();
        }
        SGFigureDialog sGFigureDialog = (SGFigureDialog)this.mDialog;
        ArrayList arrayList = sGFigureDialog.getActiveComponentList();
        if (string.equals("OK") || arrayList.contains(object)) {
            this.onOK();
        } else if (string.equals("Cancel")) {
            this.onCanceled();
        } else if (string.equals("Preview")) {
            this.onPreviewed();
        }
        if (object instanceof SGIFigureElement) {
            this.fromFigureElement(actionEvent);
        }
        this.repaint();
    }

    private boolean mergeDatas(SGIFigureElement sGIFigureElement) {
        SGData sGData;
        int n;
        ArrayList arrayList = sGIFigureElement.getDataList();
        ArrayList<SGData> arrayList2 = new ArrayList<SGData>();
        for (n = 0; n < this.mDataList.size(); ++n) {
            sGData = (SGData)this.mDataList.get(n);
            if (arrayList.contains(sGData)) continue;
            arrayList2.add(sGData);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            sGData = (SGData)arrayList2.get(n);
            this.removeData(sGData);
        }
        return true;
    }

    private boolean fromFigureElement(ActionEvent actionEvent) {
        SGIFigureElement sGIFigureElement = (SGIFigureElement)actionEvent.getSource();
        int n = actionEvent.getID();
        switch (n) {
            case 0: {
                this.mergeDatas(sGIFigureElement);
                this.notifyFigureElement(sGIFigureElement);
                break;
            }
            case 1: {
                this.updateHistory(sGIFigureElement);
                break;
            }
            case 2: {
                this.mWnd.setPropertyOfSelectedObjects();
                break;
            }
        }
        return true;
    }

    public boolean notifyFigureElement(SGIFigureElement sGIFigureElement) {
        this.broadcast(sGIFigureElement);
        return true;
    }

    public boolean initPropertiesHistory() {
        this.addFigurePropertyHistory((FigureProperties)this.getProperties());
        return true;
    }

    private boolean addFigurePropertyHistory(FigureProperties figureProperties) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.mFigureStateCounter; ++i) {
            arrayList.add(this.mFigurePropertyHistoryList.get(i));
        }
        arrayList.add(figureProperties);
        this.mFigurePropertyHistoryList = arrayList;
        return true;
    }

    public boolean onUndo() {
        if (this.mCurrentStateCounter == 0) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter - 1);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this) ? this.undo() : sGIUndoable.onUndo();
            if (bl) continue;
            return false;
        }
        --this.mCurrentStateCounter;
        return true;
    }

    public boolean onRedo() {
        if (this.mCurrentStateCounter == this.mUndoableObjectHistoryList.size()) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this) ? this.redo() : sGIUndoable.onRedo();
            if (bl) continue;
            return false;
        }
        ++this.mCurrentStateCounter;
        return true;
    }

    protected boolean onOK() {
        System.out.println("onOK");
        boolean bl = this.setPropertyWithDialog();
        if (!bl) {
            return false;
        }
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        System.out.println("pTemp:" + sGProperties);
        System.out.println("pPresent:" + sGProperties2);
        System.out.println(sGProperties.equals(sGProperties2));
        System.out.println();
        if (!sGProperties.equals(sGProperties2)) {
            this.updateParentHistory();
            this.updateHistory();
        }
        this.mTemporaryProperties = null;
        this.mDialog.hide();
        this.repaint();
        return true;
    }

    public boolean updateHistory() {
        this.updateObjectHistory(this);
        ++this.mFigureStateCounter;
        this.addFigurePropertyHistory((FigureProperties)this.getProperties());
        return true;
    }

    public boolean updateParentHistory() {
        this.mWnd.updateObjectHistory(this);
        return true;
    }

    protected boolean updateHistory(SGIFigureElement sGIFigureElement) {
        this.updateParentHistory();
        this.updateObjectHistory(sGIFigureElement);
        return true;
    }

    public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
        ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
        arrayList.add(sGIUndoable);
        boolean bl = this.updateObjectHistory(arrayList);
        return bl;
    }

    public boolean updateObjectHistory(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < this.mCurrentStateCounter; ++i) {
            Object e = this.mUndoableObjectHistoryList.get(i);
            arrayList2.add(e);
        }
        arrayList2.add(new ArrayList(arrayList));
        this.mUndoableObjectHistoryList = arrayList2;
        ++this.mCurrentStateCounter;
        return true;
    }

    protected boolean onCanceled() {
        if (!this.setProperties(this.mTemporaryProperties)) {
            return false;
        }
        this.setGraphAreaRectToFigureElement();
        this.mTemporaryProperties = null;
        this.mDialog.hide();
        this.repaint();
        return true;
    }

    protected boolean onPreviewed() {
        this.setPropertyWithDialog();
        this.repaint();
        return true;
    }

    public boolean initGraphAreaLocation() {
        SGTuple2f sGTuple2f = new SGTuple2f();
        SGTuple2f sGTuple2f2 = new SGTuple2f();
        if (!this.calcMargin(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        float f3 = sGTuple2f2.x;
        float f4 = sGTuple2f2.y;
        this.mGraphAreaX = f3;
        this.mGraphAreaY = f;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setGraphAreaLocation(this.mGraphAreaX, this.mGraphAreaY);
            sGIFigureElementArray[i].setGraphAreaSize(this.mGraphAreaWidth, this.mGraphAreaHeight);
        }
        return true;
    }

    public boolean calcMargin(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[sGIFigureElementArray.length];
        SGTuple2f[] sGTuple2fArray2 = new SGTuple2f[sGIFigureElementArray.length];
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGTuple2fArray[i] = new SGTuple2f();
            sGTuple2fArray2[i] = new SGTuple2f();
            boolean bl = sGIFigureElementArray[i].getMarginAroundGraphAreaRect(sGTuple2fArray[i], sGTuple2fArray2[i]);
            if (bl) continue;
            return false;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            float f5 = sGTuple2fArray[i].x;
            float f6 = sGTuple2fArray[i].y;
            float f7 = sGTuple2fArray2[i].x;
            float f8 = sGTuple2fArray2[i].y;
            if (f5 > f) {
                f = f5;
            }
            if (f6 > f2) {
                f2 = f6;
            }
            if (f7 > f3) {
                f3 = f7;
            }
            if (!(f8 > f4)) continue;
            f4 = f8;
        }
        sGTuple2f.x = f;
        sGTuple2f.y = f2;
        sGTuple2f2.x = f3;
        sGTuple2f2.y = f4;
        return true;
    }

    public Rectangle2D getBoundingBox() {
        Rectangle2D rectangle2D = this.getGraphAreaRect();
        SGTuple2f sGTuple2f = new SGTuple2f();
        SGTuple2f sGTuple2f2 = new SGTuple2f();
        if (!this.calcMargin(sGTuple2f, sGTuple2f2)) {
            return null;
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)rectangle2D.getX() - sGTuple2f2.x, (float)rectangle2D.getY() - sGTuple2f.x, (float)rectangle2D.getWidth() + sGTuple2f2.x + sGTuple2f2.y, (float)rectangle2D.getHeight() + sGTuple2f.x + sGTuple2f.y);
        return float_;
    }

    public boolean setBoundingBox(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return false;
        }
        SGTuple2f sGTuple2f = new SGTuple2f();
        SGTuple2f sGTuple2f2 = new SGTuple2f();
        if (!this.calcMargin(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        float f = (float)rectangle2D.getX() + sGTuple2f2.x;
        float f2 = (float)rectangle2D.getY() + sGTuple2f.x;
        float f3 = (float)rectangle2D.getWidth() - (sGTuple2f2.x + sGTuple2f2.y);
        float f4 = (float)rectangle2D.getHeight() - (sGTuple2f.x + sGTuple2f.y);
        this.setGraphAreaRect(f, f2, f3, f4);
        return true;
    }

    public boolean setCenter(float f, float f2) {
        float f3;
        float f4;
        Rectangle2D rectangle2D = this.getBoundingBox();
        float f5 = (float)rectangle2D.getWidth();
        float f6 = f - f5 / 2.0f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f6, f4 = f2 - (f3 = (float)rectangle2D.getHeight()) / 2.0f, f5, f3);
        return this.setBoundingBox(float_);
    }

    public boolean setGraphAreaLocationByLeftBottom(float f, float f2) {
        Rectangle2D rectangle2D = this.getGraphAreaRect();
        this.setGraphAreaLocation(f, f2 - (float)rectangle2D.getHeight());
        return true;
    }

    private boolean broadcast(SGIFigureElement sGIFigureElement) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].synchronize(sGIFigureElement);
        }
        return true;
    }

    public boolean removeData(SGData sGData) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = this.mDataList.size() - 1; i >= 0; --i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            this.mDataList.remove(i);
            for (int j = 0; j < sGIFigureElementArray.length; ++j) {
                sGIFigureElementArray[j].removeData(sGData);
            }
            return true;
        }
        return true;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paintGraphics2D(graphics2D);
    }

    public void paintGraphics2D(Graphics2D graphics2D) {
        Rectangle2D rectangle2D;
        Rectangle2D rectangle2D2 = this.getGraphAreaRect();
        if (!this.mTransparentFlag) {
            graphics2D.setPaint(this.mBackgroundColor);
            graphics2D.fill(rectangle2D2);
        }
        if (mBoundingBoxVisibleFlag && (rectangle2D = this.getBoundingBox()) != null) {
            graphics2D.setPaint(Color.BLUE);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.draw(rectangle2D);
        }
    }

    private void drawFrameLines(Graphics2D graphics2D) {
        graphics2D.setPaint(Color.RED);
        graphics2D.setStroke(new BasicStroke(5.0f));
        graphics2D.draw(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public boolean createPropertyFileAll(Writer writer) throws IOException {
        this.writeProperty(writer);
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].writeProperty(writer);
        }
        this.mGraphElement.writePropertyOfData(writer);
        writer.write("\n");
        return true;
    }

    public boolean createPropertyFileAllOnFocused(Writer writer) throws IOException {
        this.writePropertyOnFocused(writer);
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].writeProperty(writer);
        }
        this.mGraphElement.writePropertyOfData(writer);
        writer.write("\n");
        return true;
    }

    public boolean createPropertyFile(Writer writer) throws IOException {
        this.writeProperty(writer);
        return true;
    }

    public boolean writeProperty(Writer writer) throws IOException {
        writer.write("[Figure]\n");
        float f = this.mGraphAreaX;
        float f2 = this.mGraphAreaY;
        this.writeProperty_(writer, f, f2);
        writer.write("\n\n");
        return true;
    }

    public boolean writePropertyOnFocused(Writer writer) throws IOException {
        return true;
    }

    public abstract String getClassType();

    private boolean writeProperty_(Writer writer, float f, float f2) throws IOException {
        SGUtilityText.writePropertyLine(writer, PF_CLASS_NAME, this.getClassType());
        SGUtilityText.writePropertyLine(writer, PF_FIGURE_X_IN_CLIENT, new Float(f * 0.035277776f));
        SGUtilityText.writePropertyLine(writer, PF_FIGURE_Y_IN_CLIENT, new Float(f2 * 0.035277776f));
        SGUtilityText.writePropertyLine(writer, PF_WIDTH, new Float(this.mGraphAreaWidth * 0.035277776f));
        SGUtilityText.writePropertyLine(writer, PF_HEIGHT, new Float(this.mGraphAreaHeight * 0.035277776f));
        SGUtilityText.writePropertyLine(writer, PF_SPACE_AXIS_LINE_AND_NUMBER, new Float(this.mSpaceAxisLineAndNumber * 0.035277776f));
        SGUtilityText.writePropertyLine(writer, PF_SPACE_NUMBER_AND_TITLE, new Float(this.mSpaceNumberAndTitle * 0.035277776f));
        SGUtilityText.writeColorPropertyLine(writer, PF_BACKGROUND_COLOR, this.mBackgroundColor);
        SGUtilityText.writePropertyLine(writer, PF_TRANSPARENCY, new Boolean(this.mTransparentFlag));
        SGUtilityText.writePropertyLine(writer, PF_LEGEND_VISIBLE, new Boolean(this.mLegendElement.isLegendVisible()));
        return true;
    }

    private boolean removeAllElements() {
        this.mDataList.clear();
        this.mAxisElement.removeAllElements();
        this.mGraphElement.removeAllElements();
        this.mLegendElement.removeAllElements();
        this.mStringElement.removeAllElements();
        return true;
    }

    private FigureProperties readProperties(BufferedReader bufferedReader) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        boolean bl;
        boolean bl2;
        FigureProperties figureProperties = new FigureProperties();
        String string = null;
        float f = 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        if (!string.equals(PF_FIGURE_TITLE)) {
            return null;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d = SGUtilityText.getDoublePropertyFromLine(string, PF_FIGURE_X_IN_CLIENT);
        if (d == null) {
            return null;
        }
        float f2 = d.floatValue() / f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d2 = SGUtilityText.getDoublePropertyFromLine(string, PF_FIGURE_Y_IN_CLIENT);
        if (d2 == null) {
            return null;
        }
        float f3 = d2.floatValue() / f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d3 = SGUtilityText.getDoublePropertyFromLine(string, PF_WIDTH);
        if (d3 == null) {
            return null;
        }
        float f4 = d3.floatValue() / f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d4 = SGUtilityText.getDoublePropertyFromLine(string, PF_HEIGHT);
        if (d4 == null) {
            return null;
        }
        float f5 = d4.floatValue() / f;
        figureProperties.x = f2;
        figureProperties.y = f3;
        figureProperties.width = f4;
        figureProperties.height = f5;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d5 = SGUtilityText.getDoublePropertyFromLine(string, PF_SPACE_AXIS_LINE_AND_NUMBER);
        if (d5 == null) {
            return null;
        }
        float f6 = d5.floatValue() / f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d6 = SGUtilityText.getDoublePropertyFromLine(string, PF_SPACE_NUMBER_AND_TITLE);
        if (d6 == null) {
            return null;
        }
        float f7 = d6.floatValue() / f;
        figureProperties.spaceLineAndNumber = f6;
        figureProperties.spaceNumberAndTitle = f7;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Color color = SGUtilityText.getColorPropertyFromLine(string, PF_BACKGROUND_COLOR);
        if (color == null) {
            return null;
        }
        figureProperties.bgColor = color;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Boolean bl3 = SGUtilityText.getBooleanPropertyFromLine(string, PF_TRANSPARENCY);
        if (bl3 == null) {
            return null;
        }
        figureProperties.transparent = bl2 = bl3.booleanValue();
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Boolean bl4 = SGUtilityText.getBooleanPropertyFromLine(string, PF_LEGEND_VISIBLE);
        if (bl4 == null) {
            return null;
        }
        figureProperties.legendVisible = bl = bl4.booleanValue();
        return figureProperties;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof FigureProperties)) {
            return false;
        }
        FigureProperties figureProperties = (FigureProperties)sGProperties;
        float f = Math.abs(this.mGraphAreaX - figureProperties.x) * 0.035277776f;
        float f2 = Math.abs(this.mGraphAreaY - figureProperties.y) * 0.035277776f;
        float f3 = Math.abs(this.mGraphAreaWidth - figureProperties.width) * 0.035277776f;
        float f4 = Math.abs(this.mGraphAreaHeight - figureProperties.height) * 0.035277776f;
        float f5 = (float)SGUtilityNumber.getPowersOfTen(-1);
        if (f > f5) {
            this.mGraphAreaX = figureProperties.x;
        }
        if (f2 > f5) {
            this.mGraphAreaY = figureProperties.y;
        }
        if (f3 > f5) {
            this.mGraphAreaWidth = figureProperties.width;
        }
        if (f4 > f5) {
            this.mGraphAreaHeight = figureProperties.height;
        }
        this.mSpaceAxisLineAndNumber = figureProperties.spaceLineAndNumber;
        this.mSpaceNumberAndTitle = figureProperties.spaceNumberAndTitle;
        this.setBackgroundColor(figureProperties.bgColor);
        this.setTransparent(figureProperties.transparent);
        this.setLegendVisible(figureProperties.legendVisible);
        return true;
    }

    public boolean createDataObjectFromPropertyFile(BufferedReader bufferedReader, SGData sGData) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.mDataList.add(sGData);
        boolean bl = this.mGraphElement.createDataObject(bufferedReader, sGData);
        if (!bl) {
            return false;
        }
        bl = this.mLegendElement.createDataObject(bufferedReader, sGData);
        if (!bl) {
            return false;
        }
        bl = this.mStringElement.createDataObject(bufferedReader, sGData);
        if (!bl) {
            return false;
        }
        bl = this.mAxisElement.createDataObject(bufferedReader, sGData);
        return bl;
    }

    public static class FigureProperties
    extends SGProperties {
        float x;
        float y;
        float width;
        float height;
        float spaceLineAndNumber;
        float spaceNumberAndTitle;
        Color bgColor;
        boolean transparent;
        boolean legendVisible;

        public String toString() {
            String string = new String("[");
            string = string + new String("x=" + this.x + ", ");
            string = string + new String("y=" + this.y + ", ");
            string = string + new String("width=" + this.width + ", ");
            string = string + new String("height=" + this.height + ", ");
            string = string + new String("spaceLineAndNumber=" + this.spaceLineAndNumber + ", ");
            string = string + new String("spaceNumberAndTitle=" + this.spaceNumberAndTitle + ", ");
            string = string + new String("background color=" + this.bgColor + ", ");
            string = string + new String("transparent=" + this.transparent + ", ");
            string = string + new String("legend visible=" + this.legendVisible + ", ");
            string = string + new String("]");
            return string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FigureProperties)) {
                return false;
            }
            FigureProperties figureProperties = (FigureProperties)object;
            if (figureProperties.x != this.x) {
                return false;
            }
            if (figureProperties.y != this.y) {
                return false;
            }
            if (figureProperties.width != this.width) {
                return false;
            }
            if (figureProperties.height != this.height) {
                return false;
            }
            if (figureProperties.spaceLineAndNumber != this.spaceLineAndNumber) {
                return false;
            }
            if (figureProperties.spaceNumberAndTitle != this.spaceNumberAndTitle) {
                return false;
            }
            if (!figureProperties.bgColor.equals(this.bgColor)) {
                return false;
            }
            if (figureProperties.transparent != this.transparent) {
                return false;
            }
            return figureProperties.legendVisible == this.legendVisible;
        }
    }
}

