<?php
/**
 * ページ情報変更情報入力画面クラス
 *
 * ページ情報変更情報入力画面を実現するためのクラス
 *
 * @package   simplepage
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simplepage_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class pagemod_entry extends simplepage_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_db   = new RisoluteDb();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが自分と同じでない or 前画面のActが「pagelist」または「pageview」または「pagemod_confirm」でない場合、
      // 入力画面に飛ばす
      $tmp_cage_last    = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage'    ) );
      $tmp_cage_current = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );

      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( ( $tmp_cage_last != $tmp_cage_current ) or ( $tmp_act != 'pagelist' and $tmp_act != 'pageview' and $tmp_act != 'pagemod_confirm' ) )
      {
        $this->obj_util->redirectTo( 'pagelist', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // FCKeditorが存在すれば使用する
      //------------------------------------------------------------------------
      clearstatcache();
      $this->gotDat[ 'is_fckeditor' ] = file_exists( RISOLUTO_DOCROOT . '/fckeditor/' );



      //------------------------------------------------------------------------
      // セッション情報の取得
      //------------------------------------------------------------------------
      // 前画面のActが「pagemod_confirm」なら、必要な情報をセッションから取得する
      if ( $tmp_act == 'pagemod_confirm' )
      {
        // セッションからエラーメッセージと入力値を取得し、削除する
        $tmp_entered = $this->obj_sess->sessLoad( $this->obj_sess->sessLoad( 'currentcage' ) );
        $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'currentcage' ) );

        // 表示に必要な加工を行う
        $this->gotDat[ 'errMsg' ][ 'message' ] = $tmp_entered[ 'errMsg' ][ 'message' ];
        $this->gotDat[ 'errMsg' ][ 'pageid'  ] = $tmp_entered[ 'errMsg' ][ 'pageid'  ];
        $this->gotDat[ 'errMsg' ][ 'title'   ] = $tmp_entered[ 'errMsg' ][ 'title'   ];
        $this->gotDat[ 'errMsg' ][ 'body'    ] = $tmp_entered[ 'errMsg' ][ 'body'    ];
        return true;
      } // end of if


      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // ページID
      if ( isset( $_GET[ 'pageid' ] ) )
      {
        $tmp_entered[ 'errMsg' ][ 'pageid' ] = strip_tags( trim( $_GET[ 'pageid' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // 渡されてきたページIDが数字でなければ、ユーザ選択画面に遷移する
      if ( ! is_numeric( $tmp_entered[ 'errMsg' ][ 'pageid' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'errMsg' ][ 'message' ] = 'invalid_pageid';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'pagemod_select', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // グループ情報の取得
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {

        // ユーザ情報を取得する
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT `pages`.`page_id`    -- ページID
                   , `pages`.`page_title` -- ページタイトル
                   , `pages`.`page_body`  -- ページ本文
                FROM `simplepage_t_pages` pages
               WHERE `pages`.`page_id` = ?

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'errMsg' ][ 'pageid' ]
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_pagedat = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_pagedat ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'page information get Failure' );
          return false;
        } // end of if
        // 正常に取得できていれば、クラス変数にセットする
        else
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          $this->gotDat[ 'errMsg' ][ 'pageid' ] = $tmp_pagedat[ 'page_id'    ];
          $this->gotDat[ 'errMsg' ][ 'title'  ] = $tmp_pagedat[ 'page_title' ];
          $this->gotDat[ 'errMsg' ][ 'body'   ] = $tmp_pagedat[ 'page_body'  ];
        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else



      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',           $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage',        $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',         $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      $this->smarty->assign ( 'mycage',           str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) ) );

      $this->smarty->assign ( 'is_fckeditor',     $this->gotDat[ 'is_fckeditor' ] );
      $this->smarty->assign ( 'base_url',         str_replace( 'index.php', '', $this->obj_util->getBaseUrl() ) );

      $this->smarty->assign ( 'errMsg',           $this->gotDat[ 'errMsg' ][ 'message' ] );
      $this->smarty->assign ( 'entered_pageid',   $this->gotDat[ 'errMsg' ][ 'pageid'  ] );
      $this->smarty->assign ( 'entered_title',    $this->gotDat[ 'errMsg' ][ 'title'   ] );
      $this->smarty->assign ( 'entered_body',     $this->gotDat[ 'errMsg' ][ 'body'    ] );

      // 表示
      $this->smarty->display( 'pagemod_entry.tpl' );

      return true;

    } // end of function:view()

  } // end of class:pageadd_entry

?>
