<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.ExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class UserLoginTableVerify{
	var $valid = true;

	function UserLoginTableVerify(){
	}
	function verify($tableObject){
		$this->verifyId($tableObject->getId());
		$this->verifyLogin($tableObject->getLogin());
		$this->verifyPassword($tableObject->getPassword());
		$this->verifyCode($tableObject->getCode());
		return $this->valid;	
	}
	function verifyId($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedId())),$this->_validName("id"));
		}
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedId())),$this->_validName("id"));
		}
		unset($value);
	}
	function verifyLogin($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedLogin())),$this->_validName("login"));
		}
		if(!empty($value) && !Validate::isString($value,0,256)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedLogin(),256)),$this->_validName("login"));
		}
		unset($value);
	}
	function verifyPassword($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedPassword())),$this->_validName("password"));
		}
		if(!empty($value) && !Validate::isString($value,0,256)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedPassword(),256)),$this->_validName("password"));
		}
		unset($value);
	}
	function verifyCode($value){
		if(!empty($value) && !Validate::isString($value,0,64)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedCode(),64)),$this->_validName("code"));
		}
		unset($value);
	}

	function namedId(){
		return Message::_("ID");
	}
	function namedLogin(){
		return Message::_("LOGIN");
	}
	function namedPassword(){
		return Message::_("PASSWORD");
	}
	function namedCode(){
		return Message::_("CODE");
	}
	function _validName($name){
		$this->valid = false;
		return "UserLogin_".$name;
	}
}

?>