<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");
Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.DbConnectionGoesby");
Rhaco::importLibrary("data.verify.UserLoginVerify");
Rhaco::importLibrary("data.UserDetail");
Rhaco::importLibrary("data.Memory");
Rhaco::importLibrary("data.Bookmark");
class UserLoginTable extends TableObjectBase{
	var $id;
	var $login;
	var $password;
	var $code;
	function UserLoginTable(
		$id=null
	){
		$this->id = 0;
		$this->login = null;
		$this->password = null;
		$this->code = null;
		$this->setId($id);
	}
	function setId($value){
		$this->id = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getId(){
		return $this->id;
	}
	function setLogin($value){
		$this->login = $value;
	}
	function getLogin(){
		return $this->login;
	}
	function setPassword($value){
		$this->password = $value;
	}
	function getPassword(){
		return $this->password;
	}
	function setCode($value){
		$this->code = $value;
	}
	function getCode(){
		return $this->code;
	}
	function columnId(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."USER_LOGIN","USER_LOGIN"),"ID","Id","SERIAL");
	}
	function columnLogin(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."USER_LOGIN","USER_LOGIN"),"LOGIN","Login","STRING");
	}
	function columnPassword(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."USER_LOGIN","USER_LOGIN"),"PASSWORD","Password","STRING");
	}
	function columnCode(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."USER_LOGIN","USER_LOGIN"),"CODE","Code","STRING");
	}
	function dependColumnId(){
		return array(
				array(new UserDetail(),new Memory(),new Bookmark(),),
				array(UserDetail::columnUserId(),Memory::columnUserId(),Bookmark::columnUserId(),),
				$this->getId());
	}
	function related($criteria=null){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		return $criteria;
	}
	function unique(){
		return array(
			);
	}
	function verifyObject(){
		return new UserLoginVerify();
	}
	function connection(){
		return new DbConnectionGoesby();
	}
	function beforeDelete($dbUtil,$criteria){
		if(Variable::isClassType(DbUtil,$dbUtil)){
			list($objList,$columnList,$value) = $this->dependColumnId();
			foreach($objList as $key => $obj){
				$dbUtil->delete($obj,new Criteria($columnList[$key],$value));
			}
		}
		unset($dbUtil,$criteria);
	}
	function verify(){
		$verify = new UserLoginVerify();
		return $verify->verify($this);
	}
	function columns(){
		return array(UserLogin::columnId(),UserLogin::columnLogin(),UserLogin::columnPassword(),UserLogin::columnCode(),);
	}
	function primaryKey(){
		return array(UserLogin::columnId(),);
	}
}
?>